#!/usr/local/bin/perl
# backup_db.cgi
# Do the actual backup

require './mysql-lib.pl';
&ReadParse();
&can_edit_db($in{'db'}) || &error($text{'dbase_ecannot'});
$access{'edonly'} && &error($text{'dbase_ecannot'});
&error_setup($text{'backup_err'});

$in{'file'} =~ /^\S+$/ || &error($text{'backup_efile'});
$drop = $in{'drop'} ? "--add-drop-table" : "";
$in{'where_def'} || $in{'where'} || &error($text{'backup_ewhere'});
$where = $in{'where_def'} ? "" : "\"--where=$in{'where'}\"";
$p = $access{'bpath'} =~ /\/$/ ? $access{'bpath'} : $access{'bpath'}.'/';
if (substr($in{'file'}, 0, length($p)) ne $p) {
	&error($text{'backup_epath'});
	}

unlink($in{'file'});
if ($access{'buser'} eq 'root') {
	$out = &backquote_logged("$config{'mysqldump'} $authstr $drop $where $in{'db'} 2>&1 >$in{'file'}");
	}
else {
	$out = &backquote_logged("su $access{'buser'} -c '$config{'mysqldump'} $authstr $drop $where $in{'db'} >$in{'file'}' 2>&1");
	}
if ($? || $out) {
	unlink($in{'file'});
	&error(&text('backup_ebackup', "<tt>$out</tt>"));
	}

&header($text{'backup_title'}, "");
print "<hr>\n";
@st = stat($in{'file'});
print "<p>",&text('backup_done', "<tt>$in{'db'}</tt>", "<tt>$in{'file'}</tt>",
		  $st[7]),"<p>\n";
$config{'backup_'.$in{'db'}} = $in{'file'};
&write_file("$module_config_directory/config", \%config);
&webmin_log("backup", undef, $in{'db'}, \%in);
print "<hr>\n";
&footer("edit_dbase.cgi?db=$in{'db'}", $text{'dbase_return'},
	"", $text{'index_return'});

