#!/opt/perl/bin/perl -w

# tests relating to searching. Especially around custom fields, and
# corner cases.

use strict;
use warnings;

use Test::More tests => 35;
use_ok('RT');
RT::LoadConfig();
RT::Init();

# setup the queue

my $q = RT::Queue->new($RT::SystemUser);
my $queue = 'SearchTests-'.$$;
$q->Create(Name => $queue);
ok ($q->id, "Created the queue");


# and setup the CFs
# we believe the Type shouldn't matter.

my $cf = RT::CustomField->new($RT::SystemUser);
$cf->Create(Name => 'SearchTest', Type => 'Freeform', MaxValues => 0, Queue => $q->id);
ok($cf->id, "Created the SearchTest CF");
my $cflabel = "CustomField-".$cf->id;

my $cf2 = RT::CustomField->new($RT::SystemUser);
$cf2->Create(Name => 'SearchTest2', Type => 'Freeform', MaxValues => 0, Queue => $q->id);
ok($cf2->id, "Created the SearchTest2 CF");
my $cflabel2 = "CustomField-".$cf2->id;

my $cf3 = RT::CustomField->new($RT::SystemUser);
$cf3->Create(Name => 'SearchTest3', Type => 'Freeform', MaxValues => 0, Queue => $q->id);
ok($cf3->id, "Created the SearchTest3 CF");
my $cflabel3 = "CustomField-".$cf3->id;


# setup some tickets
# we'll need a small pile of them, to test various combinations and nulls.
# there's probably a way to think harder and do this with fewer


my $t1 = RT::Ticket->new($RT::SystemUser);
my ( $id, undef $msg ) = $t1->Create(
    Queue      => $q->id,
    Subject    => 'SearchTest1',
    Requestor  => ['search1@example.com'],
    $cflabel   => 'foo1',
    $cflabel2  => 'bar1',
    $cflabel3  => 'qux1',
);
ok( $id, $msg );


my $t2 = RT::Ticket->new($RT::SystemUser);
( $id, undef, $msg ) = $t2->Create(
    Queue      => $q->id,
    Subject    => 'SearchTest2',
    Requestor  => ['search2@example.com'],
#    $cflabel   => 'foo2',
    $cflabel2  => 'bar2',
    $cflabel3  => 'qux2',
);
ok( $id, $msg );

my $t3 = RT::Ticket->new($RT::SystemUser);
( $id, undef, $msg ) = $t3->Create(
    Queue      => $q->id,
    Subject    => 'SearchTest3',
    Requestor  => ['search3@example.com'],
    $cflabel   => 'foo3',
#    $cflabel2  => 'bar3',
    $cflabel3  => 'qux3',
);
ok( $id, $msg );

my $t4 = RT::Ticket->new($RT::SystemUser);
( $id, undef, $msg ) = $t4->Create(
    Queue      => $q->id,
    Subject    => 'SearchTest4',
    Requestor  => ['search4@example.com'],
    $cflabel   => 'foo4',
    $cflabel2  => 'bar4',
#    $cflabel3  => 'qux4',
);
ok( $id, $msg );

my $t5 = RT::Ticket->new($RT::SystemUser);
( $id, undef, $msg ) = $t5->Create(
    Queue      => $q->id,
#    Subject    => 'SearchTest5',
    Requestor  => ['search5@example.com'],
    $cflabel   => 'foo5',
    $cflabel2  => 'bar5',
    $cflabel3  => 'qux5',
);
ok( $id, $msg );

my $t6 = RT::Ticket->new($RT::SystemUser);
( $id, undef, $msg ) = $t6->Create(
    Queue      => $q->id,
    Subject    => 'SearchTest6',
#    Requestor  => ['search6@example.com'],
    $cflabel   => 'foo6',
    $cflabel2  => 'bar6',
    $cflabel3  => 'qux6',
);
ok( $id, $msg );

my $t7 = RT::Ticket->new($RT::SystemUser);
( $id, undef, $msg ) = $t7->Create(
    Queue      => $q->id,
    Subject    => 'SearchTest7',
    Requestor  => ['search7@example.com'],
#    $cflabel   => 'foo7',
#    $cflabel2  => 'bar7',
    $cflabel3  => 'qux7',
);
ok( $id, $msg );

# we have tickets. start searching
my $tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("Queue = '$queue'");
is($tix->Count, 7, "found all the tickets");


# very simple searches. both CF and normal

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("Queue = '$queue' AND CF.SearchTest = 'foo1'");
is($tix->Count, 1, "matched identical subject");

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("Queue = '$queue' AND CF.SearchTest LIKE 'foo1'");
is($tix->Count, 1, "matched LIKE subject");

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("Queue = '$queue' AND CF.SearchTest = 'foo'");
is($tix->Count, 0, "IS a regexp match");

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("Queue = '$queue' AND CF.SearchTest LIKE 'foo'");
is($tix->Count, 5, "matched LIKE subject");


$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("Queue = '$queue' AND CF.SearchTest IS NULL");
    
    is($tix->Count, 2, "IS null CF");

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("Queue = '$queue' AND Requestors LIKE 'search1'");
is($tix->Count, 1, "LIKE requestor");

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("Queue = '$queue' AND Requestors = 'search1\@example.com'");
is($tix->Count, 1, "IS requestor");

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("Queue = '$queue' AND Requestors LIKE 'search'");
is($tix->Count, 6, "LIKE requestor");

TODO: {
    
    local $TODO = "Can't search for 'no requestor"; 
    $tix = RT::Tickets->new($RT::SystemUser);
    $tix->FromSQL("Queue = '$queue' AND Requestors IS NULL");
    is($tix->Count, 1, "Search for no requestor");

};

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("Queue = '$queue' AND Subject = 'SearchTest1'");
is($tix->Count, 1, "IS subject");

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("Queue = '$queue' AND Subject LIKE 'SearchTest1'");
is($tix->Count, 1, "LIKE subject");

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("Queue = '$queue' AND Subject = ''");
is($tix->Count, 1, "found one ticket");

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("Queue = '$queue' AND Subject LIKE 'SearchTest'");
is($tix->Count, 6, "found two ticket");

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("Queue = '$queue' AND Subject LIKE 'qwerty'");
is($tix->Count, 0, "found zero ticket");




# various combinations

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("CF.SearchTest LIKE 'foo' AND CF.SearchTest2 LIKE 'bar1'");
is($tix->Count, 1, "LIKE cf and LIKE cf");

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("CF.SearchTest = 'foo1' AND CF.SearchTest2 = 'bar1'");
is($tix->Count, 1, "is cf and is cf");

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("CF.SearchTest = 'foo' AND CF.SearchTest2 LIKE 'bar1'");
is($tix->Count, 0, "is cf and like cf");

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("CF.SearchTest LIKE 'foo' AND CF.SearchTest2 LIKE 'bar' AND CF.SearchTest3 LIKE 'qux'");
is($tix->Count, 3, "like cf and like cf and like cf");

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("CF.SearchTest LIKE 'foo' AND CF.SearchTest2 LIKE 'bar' AND CF.SearchTest3 LIKE 'qux6'");
is($tix->Count, 1, "like cf and like cf and is cf");

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("CF.SearchTest LIKE 'foo' AND Subject LIKE 'SearchTest'");
is($tix->Count, 4, "like cf and like subject");

$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("CF.SearchTest IS NULL AND CF.SearchTest2 = 'bar2'");
    
    is($tix->Count, 1, "null cf and is cf");


$tix = RT::Tickets->new($RT::SystemUser);
$tix->FromSQL("Queue = '$queue' AND CF.SearchTest IS NULL AND CF.SearchTest2 IS NULL");

        is($tix->Count, 1, "null cf and null cf"); 


