.IP "\fB\-f \fIformat\fR"
.IQ "\fB\-\-format=\fIformat\fR"
Sets the type of table formatting.  The following types of
\fIformat\fR are available:
.RS
.ie '\*(PN'ovs\-vsctl' .IP "\fBtable\fR"
.el                    .IP "\fBtable\fR (default)"
2-D text tables with aligned columns.
.ie '\*(PN'ovs\-vsctl' .IP "\fBlist\fR (default)"
.el                    .IP "\fBlist\fR"
A list with one column per line and rows separated by a blank line.
.IP "\fBhtml\fR"
HTML tables.
.IP "\fBcsv\fR"
Comma-separated values as defined in RFC 4180.
.IP "\fBjson\fR"
JSON format as defined in RFC 4627.  The output is a sequence of JSON
objects, each of which corresponds to one table.  Each JSON object has
the following members with the noted values:
.RS
.IP "\fBcaption\fR"
The table's caption.  This member is omitted if the table has no
caption.
.IP "\fBheadings\fR"
An array with one element per table column.  Each array element is a
string giving the corresponding column's heading.
.IP "\fBdata\fR"
An array with one element per table row.  Each element is also an
array with one element per table column.  The elements of this
second-level array are the cells that constitute the table.  Cells
that represent OVSDB data or data types are expressed in the format
described in the OVSDB specification; other cells are simply expressed
as text strings.
.RE
.RE
.
.IP "\fB\-d \fIformat\fR"
.IQ "\fB\-\-data=\fIformat\fR"
Sets the formatting for cells within output tables unless the table
format is set to \fBjson\fR, in which case \fBjson\fR formatting is
always used when formatting cells.  The following types of \fIformat\fR
are available:
.RS
.IP "\fBstring\fR (default)"
The simple format described in the \fBDatabase Values\fR
.ie '\*(PN'ovs\-vsctl' section below.
.el                    section of \fBovs\-vsctl\fR(8).
.IP "\fBbare\fR"
The simple format with punctuation stripped off: \fB[]\fR and \fB{}\fR
are omitted around sets, maps, and empty columns, items within sets
and maps are space-separated, and strings are never quoted.  This
format may be easier for scripts to parse.
.IP "\fBjson\fR"
The RFC 4627 JSON format as described above.
.RE
.IP
.
.IP "\fB\-\-no\-headings\fR"
This option suppresses the heading row that otherwise appears in the
first row of table output.
.
.IP "\fB\-\-pretty\fR"
By default, JSON in output is printed as compactly as possible.  This
option causes JSON in output to be printed in a more readable
fashion.  Members of objects and elements of arrays are printed one
per line, with indentation.
.IP
This option does not affect JSON in tables, which is always printed
compactly.
.IP "\fB\-\-bare\fR"
Equivalent to \fB\-\-format=list \-\-data=bare \-\-no\-headings\fR.
