/*----------------------------------------------------------------------------

   libtunepimp -- The MusicBrainz tagging library.  
                  Let a thousand taggers bloom!
   
   Copyright (C) Robert Kaye 2003
   
   This file is part of libtunepimp.

   libtunepimp is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   libtunepimp is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with libtunepimp; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   $Id: metadata.h,v 1.14 2004/03/04 22:53:04 robert Exp $

----------------------------------------------------------------------------*/
#ifndef __METADATA_H__
#define __METADATA_H__

#include <string>
using namespace std;

#include "defs.h"

struct Metadata
{
    string        artist;
    string        sortName;
    string        album;
    string        track;
    int           trackNum;
    bool          variousArtist;
    string        artistId;   
    string        albumId;   
    string        trackId;
    string        fileTrm;
    string        albumArtistId;
    unsigned long duration;
    TPAlbumType   albumType;
    TPAlbumStatus albumStatus;
    string        fileFormat;
    int           releaseYear, releaseMonth, releaseDay;
    string        releaseCountry;

    // This is only used in case of TRM collision
    int           numTRMIds;

    Metadata::Metadata(void) 
    { 
        trackNum = 0; 
        duration = 0; 
        variousArtist = false; 
        albumType = eAlbumType_Error;
        albumStatus = eAlbumStatus_Error;
        numTRMIds = 0;
        releaseYear = releaseMonth = releaseDay = 0;
    };
    Metadata &operator=(const Metadata &other)
    {
        artist = other.artist;
        sortName = other.sortName;
        album = other.album;
        track = other.track;
        trackNum = other.trackNum;
        trackId = other.trackId;
        artistId = other.artistId;
        albumId = other.albumId;
        fileTrm = other.fileTrm;
        duration = other.duration;
        variousArtist = other.variousArtist;
        albumArtistId = other.albumArtistId;
        albumType = other.albumType;
        albumStatus = other.albumStatus;
        fileFormat = other.fileFormat;
        numTRMIds = other.numTRMIds;
        releaseYear = other.releaseYear;
        releaseMonth = other.releaseMonth;
        releaseDay = other.releaseDay;
        releaseCountry = other.releaseCountry;

        return *this;
    };
    bool isEmpty(void)
    {
        return (artist.empty() && album.empty() && track.empty() &&
            trackNum == 0 && duration == 0 && fileTrm.empty() &&
            artistId.empty() && albumId.empty() && albumId.empty() &&
            sortName.empty() && fileFormat.empty());
    }

    bool operator==(const Metadata &other)
    {
        if (artist == other.artist &&
            album == other.album &&
            track == other.track &&
            trackNum == other.trackNum &&
            trackId == other.trackId &&
            artistId == other.artistId &&
            albumId == other.albumId &&
            fileTrm == other.fileTrm &&
            duration == other.duration &&
            sortName == other.sortName &&
            albumArtistId == other.albumArtistId &&
            variousArtist == other.variousArtist &&
            albumType == other.albumType &&
            albumStatus == other.albumStatus &&
	    fileFormat == other.fileFormat &&
            releaseYear == other.releaseYear &&
            releaseDay == other.releaseDay &&
            releaseMonth == other.releaseMonth && 
            releaseCountry == other.releaseCountry)
            return true;

        return false;
    };

    void clear(void)
    {
        artist = "";
        album = "";
        track = "";
        trackNum = 0;
        fileTrm = "";
        duration = 0;
        artistId = "";
        trackId = "";
        albumId = "";
        sortName = "";
        albumArtistId = "";
        variousArtist = false;
        albumType = eAlbumType_Error;
        albumStatus = eAlbumStatus_Error;
	fileFormat = "";
        numTRMIds = 0;
        releaseYear = releaseMonth = releaseDay = 0;
        releaseCountry = "";
    }
};

class MetadataCompare 
{
    public:

                 MetadataCompare(void) {};
        virtual ~MetadataCompare(void) {};

        int      compare(const Metadata &a, const Metadata &b) const;

    private:

        double   durationSim(int trackA, int trackB) const;
};

TPAlbumStatus convertToAlbumStatus  (const char *albumStatus);
TPAlbumType   convertToAlbumType    (const char *albumType);
void          convertFromAlbumStatus(TPAlbumStatus status, string &albumStatus);
void          convertFromAlbumType  (TPAlbumType type, string &albumType);

#endif
