<?php
/**
 * Project Membership Request
 *
 * The rest Copyright 2005 (c) GForge, L.L.C.
 * http://gforge.org/
 *
 * This file is part of GForge.
 *
 * GForge is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * GForge is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GForge; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


require_once('../env.inc.php');
require_once $gfwww.'include/pre.php';
require_once $gfcommon.'include/GroupJoinRequest.class.php';

$group_id=getIntFromGet('group_id');
$submit=getStringFromPost('submit');
$comments=getStringFromPost('comments');

if (!$group_id) {
	exit_no_group();
}

if (!session_loggedin()) {
	exit_not_logged_in();
}

$group =& group_get_object($group_id);

if ($submit) {

	$gjr=new GroupJoinRequest($group);
	$usr=&session_get_user();
	if (!$gjr->create($usr->getId(),$comments)) {
		exit_error('Error',$gjr->getErrorMessage());
	} else {
		$feedback = _('Your request has been submitted.');
	}
}

site_project_header(array('title'=>_('Request to join project'),'group'=>$group_id,'toptab'=>'summary'));

?>
<p><?php 
$nbadmins = count($group->getAdmins());
echo ngettext('You can request to join a project by clicking the submit button. The administrator will be emailed to approve or deny your request.', 'You can request to join a project by clicking the submit button. The administrators will be emailed to approve or deny your request.', $nbadmins); ?></p>
<form action="<?php echo getStringFromServer('PHP_SELF')."?group_id=$group_id"; ?>" method="post">
<p>
<?php echo ngettext('You must send a comment to the administrator:', 'You must send a comment to the administrators:',$nbadmins); echo utils_requiredField(); ?><br>
<textarea name="comments" rows="15" cols="60"><?php echo $comments ?></textarea>
</p>
<p>
	<input type="submit" name="submit" value="<?php echo _('Submit'); ?>" />
</p>
</form>
<?php

site_project_footer(array());

?>
