<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Compilation et installation - Serveur Apache HTTP</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.2</p>
<img alt="" src="./images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.2</a></div><div id="page-content"><div id="preamble"><h1>Compilation et installation</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./de/install.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="./en/install.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/install.html" hreflang="es" rel="alternate" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./fr/install.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/install.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/install.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/install.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>


    <p>Ce document couvre l'installation et la compilation du serveur
    HTTP Apache
    sur les systmes Unix et similaires seulement. Pour la compilation et
    l'installation sous Windows, voir <a href="platform/windows.html">Utiliser Apache HTTPd avec Microsoft
    Windows</a>. Pour les autres plateformes, se rfrer  la documentation par
     <a href="platform/">plateforme</a>.</p>

    <p>Apache HTTPd utilise <code>libtool</code> et <code>autoconf</code>
    afin de crer un environnement de construction similaire  la plupart
    des projets Open Source .</p>

    <p>Si vous effectuez une mise  jour depuis une version mineure vers
    la suivante (par exemple, 2.2.50  2.2.51), veuillez passer  la section
    <a href="#upgrading">mise  jour</a>.</p>

</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#overview">Aperu pour les plus presss</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#requirements">Prrequis</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#download">Tlchargement</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#extract">Extraction</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#configure">Configuration de l'arborescence des sources</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#compile">Construction</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#install">Installation</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#customize">Personnalisation</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#test">Test</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#upgrading">Mise  jour</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="programs/configure.html">Configuration de l'arborescence
	des sources</a></li><li><a href="invoking.html">Dmarrer le serveur HTTP Apache</a></li><li><a href="stopping.html">Arrt et redmarrage</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="overview" id="overview">Aperu pour les plus presss</a></h2>

    <table>
      
      <tr>
        <td><a href="#download">Tlchargement</a></td>

        <td><code>$ lynx http://httpd.apache.org/download.cgi</code>
        </td>
      </tr>

      <tr>
        <td><a href="#extract">Extraction</a></td>

        <td><code>$ gzip -d httpd-<em>NN</em>.tar.gz<br />
         $ tar xvf httpd-<em>NN</em>.tar<br />
         $ cd httpd-<em>NN</em></code></td>
      </tr>

      <tr>
        <td><a href="#configure">Configuration</a></td>

        <td><code>$ ./configure --prefix=<em>PREFIX</em></code>
        </td>
      </tr>

      <tr>
        <td><a href="#compile">Compilation</a></td>

        <td><code>$ make</code> </td>
      </tr>

      <tr>
        <td><a href="#install">Installation</a></td>

        <td><code>$ make install</code> </td>
      </tr>

      <tr>
        <td><a href="#customize">Personnalisation</a></td>

        <td><code>$ vi <em>PREFIX</em>/conf/httpd.conf</code> </td>
      </tr>

      <tr>
        <td><a href="#test">Test</a></td>

        <td><code>$ <em>PREFIX</em>/bin/apachectl -k start</code>
        </td>
      </tr>
    </table>

    <p><em>NN</em> doit tre remplac par le numro de version courant,
    et <em>PREFIX</em> par le
    chemin du rpertoire d'installation. Si
    <em>PREFIX</em> n'est pas spcifi, le chemin du rpertoire
    d'installation prendra sa valeur par dfaut,  savoir
    <code>/usr/local/apache2</code>.</p>

    <p>Chaque tape du processus de compilation et d'installation est
    dcrite plus en dtails ci-dessous,  commencer par les prrequis
    pour compiler et installer le serveur HTTP Apache.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="requirements" id="requirements">Prrequis</a></h2>

    <p>Les prrequis pour la construction d'Apache HTTPd sont les suivants:</p>

    <dl>
      <dt>Espace disque</dt>
      <dd>Assurez-vous d'avoir au moins 50 MB d'espace disque disponible
      temporaire. Aprs l'installation Apache occupe
      approximativement 10 MB d'espace disque. L'espace disque rellement
      ncessaire va varier considrablement en fonction de vos options
      de configuration et de la prsence ventuelle de modules tiers.</dd>

      <dt>Compilateur ANSI-C et systme de construction</dt>
      <dd>Vous devez disposer d'un compilateur ANSI-C. Le compilateur <a href="http://www.gnu.org/software/gcc/gcc.html">GNU C
       (GCC)</a> de la <a href="http://www.gnu.org/">Free Software Foundation (FSF)</a>
      est recommand. Si vous ne possdez pas GCC,
      assurez-vous au moins que votre compilateur soit compatible ANSI.
      En outre, votre <code>PATH</code> doit contenir
      les outils de construction de base tels que <code>make</code>.</dd>

      <dt>Connaissance de l'heure exacte</dt>
      <dd>Les lments du protocole HTTP font rfrence  l'heure du jour.
      Par consquent, il est ncessaire d'quiper votre systme d'un
      dispositif de synchronisation du temps. Les programmes
      <code>ntpdate</code> ou <code>xntpd</code>, bass sur le protocole NTP,
      sont couramment utiliss  cet effet.
      Voir la <a href="http://www.ntp.org">page d'accueil de NTP</a>
      pour plus de dtails  propos du logiciel NTP et des serveurs
      de temps publics.</dd>

      <dt><a href="http://www.perl.org/">Perl 5</a>
      [OPTIONNEL]</dt>
      <dd>L'interprteur Perl 5 (les versions 5.003 ou suprieures conviennent)
      est ncessaire pour l'excution de certains scripts comme
      <code class="program"><a href="./programs/apxs.html">apxs</a></code> ou <code class="program"><a href="./programs/dbmmanage.html">dbmmanage</a></code>
      (qui sont crits en Perl). Si vous disposez de plusieurs interprteurs
      Perl (par exemple, une installation globale Perl 4, et
      votre installation personnelle de Perl 5), il vous faut utiliser l'option
      <code>--with-perl</code> (voir ci-dessous) afin de vous assurer que le
      bon interprteur sera utilis par <code class="program"><a href="./programs/configure.html">configure</a></code>.
      Si le script <code class="program"><a href="./programs/configure.html">configure</a></code> ne trouve pas d'interprteur
      Perl 5, vous ne pourrez pas utiliser les scripts qui en ont besoin.
      Bien entendu, vous pourrez tout de mme construire et utiliser
      Apache httpd.</dd>

      <dt><a href="http://apr.apache.org">apr/apr-util &gt;= 1.2</a></dt>
      <dd><code>apr</code> et <code>apr-util</code> sont inclus
      dans les sources d'Apache HTTPd, et peuvent tre utiliss sans problme
      dans la plupart des cas. Cependant, si
      <code>apr</code> ou <code>apr-util</code>, versions 1.0 ou 1.1,
      sont installs sur votre systme, vous devez soit mettre  jour vos
      installations <code>apr</code>/<code>apr-util</code> vers la version
      1.2, forcer l'utilisation des bibliothques intgres,
      soit faire en sorte que httpd utilise des constructions spares.
      Pour utiliser les sources de
      <code>apr</code>/<code>apr-util</code> incluses, utilisez l'option
      <code>--with-included-apr</code> du script configure :

      <div class="note"><h3>Note</h3>
        L'option --with-included-apr est disponible  partir
	de la version 2.2.3
      </div>
      <div class="example"><p><code>
        # Forcer l'utilisation des sources de apr/apr-util intgres<br />
        ./configure --with-included-apr<br />
      </code></p></div>

      Pour construire Apache HTTPd suite   une installation manuelle de
      <code>apr</code>/<code>apr-util</code> :

      <div class="example"><p><code>
        # Construction et installation apr 1.2<br />
        cd srclib/apr<br />
        ./configure --prefix=/usr/local/apr-httpd/<br />
        make<br />
        make install<br />
        <br />
        # Construction et installation apr-util 1.2<br />
        cd ../apr-util<br />
        ./configure --prefix=/usr/local/apr-util-httpd/
          --with-apr=/usr/local/apr-httpd/<br />
        make<br />
        make install<br />
        <br />
        # Configuration httpd<br />
        cd ../../<br />
        ./configure --with-apr=/usr/local/apr-httpd/
          --with-apr-util=/usr/local/apr-util-httpd/
      </code></p></div>
      </dd>


    </dl>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="download" id="download">Tlchargement</a></h2>

    <p>Le serveur HTTP Apache peut tre tlcharg  partir du
    <a href="http://httpd.apache.org/download.cgi">site de tlchargement
    du serveur HTTP Apache</a>, qui fournit la liste de nombreux miroirs.
    Il sera plus commode  la plupart des utilisateurs d'Apache HTTPd sur les
    systmes UNIX ou similaires de tlcharger et de compiler
    la version sources.  Le processus de construction (dcrit ci-dessous) est
    simple, et vous permet de personnaliser votre serveur selon vos besoins.
    En outre, les versions binaires sont souvent plus anciennes que les
    dernires versions sources  Si vous tlchargez une version binaire,
    suivez les instructions dcrites dans le fichier
    <code>INSTALL.bindist</code> inclus dans la distribution.</p>

    <p>Aprs le tlchargement, il est important de vrifier que vous
    disposez d'une version complte et non modifie du serveur HTTP Apache.
    Vous pouvez le faire en testant l'archive tlcharge  l'aide de
    la signature PGP. Vous trouverez les dtails de cette opration sur la <a href="http://httpd.apache.org/download.cgi#verify">page de tlchargement</a> ainsi qu'un exemple prcis dcrivant <a href="http://httpd.apache.org/dev/verification.html">l'utilisation de
    PGP</a>.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="extract" id="extract">Extraction</a></h2>

    <p>L'extraction des sources depuis l'archive Apache HTTPd consiste
    simplement  dcompresser et  dsarchiver cette dernire :</p>

<div class="example"><p><code>
$ gzip -d httpd-<em>NN</em>.tar.gz<br />
$ tar xvf httpd-<em>NN</em>.tar
</code></p></div>

    <p>Ceci crera, dans le rpertoire courant, un nouveau rpertoire
    contenant le code source de la distribution. Vous devrez vous positionner
    dans ce rpertoire avant de procder  la compilation du serveur.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="configure" id="configure">Configuration de l'arborescence des sources</a></h2>

    <p>L'tape suivante consiste  configurer l'arborescence des sources
    d'Apache HTTPd en fonction de votre plateforme et de vos besoins personnels.
    Le script  <code class="program"><a href="./programs/configure.html">configure</a></code>, situ  la racine du
    rpertoire de la distribution, a t conu  cet effet.
    (Les dveloppeurs qui tlchargent
    une version non officielle de l'arborescence des sources d'Apache HTTPd
    devront disposer de
    <code>autoconf</code> et <code>libtool</code> et
    excuter <code>buildconf</code> avant de passer  l'tape suivante,
    ce qui n'est pas ncessaire pour les versions officielles.)</p>

    <p>Pour configurer l'arborescence des sources avec les valeurs par dfaut
    pour toutes les options, entrez simplement <code>./configure</code>.
    Pour modifier les valeurs des options, <code class="program"><a href="./programs/configure.html">configure</a></code>
    comprend toute une varit de variables et
    d'options de ligne de commande.</p>

    <p>L'option la plus importante <code>--prefix</code> est le chemin
    du rpertoire d'installation du serveur HTTP Apache, car Apache doit tre configur
    en fonction de ce chemin pour pouvoir fonctionner correctement.
    Il est possible de dfinir plus finement le chemin d'installation des fichiers
     l'aide d'<a href="programs/configure.html#installationdirectories">
    options supplmentaires de configure</a>.</p>

    <p> ce niveau, vous pouvez aussi spcifier de quelles <a href="programs/configure.html#optionalfeatures">fonctionnalits</a> vous
    voulez disposer dans Apache HTTPd en activant ou dsactivant des <a href="mod/">modules</a>.  Apache est fourni avec un jeu de modules de
    <a href="mod/module-dict.html#Status">Base</a> inclus par dfaut.
    Les autres modules sont activs  l'aide de l'option
    <code>--enable-<var>module</var></code>, o
    <var>module</var> est le nom du module sans la chane
    <code>mod_</code> et o tout caractre de soulignement est converti
    en tiret.  Vous pouvez aussi choisir de compiler les modules comme
    <a href="dso.html">objets partags (DSOs)</a> -- qui peuvent tre chargs
    ou dchargs  l'excution --  l'aide de l'option
    <code>--enable-<var>module</var>=shared</code>.  D'une manire similaire,
    vous pouvez dsactiver des modules de base  l'aide de l'option
    <code>--disable-<var>module</var></code> option.  Faites trs attention
    en utilisant ces options, car <code class="program"><a href="./programs/configure.html">configure</a></code> n'est pas en
    mesure de vous avertir si le module que vous avez spcifi n'existe pas;
    il ignorera tout simplement l'option.</p>

    <p>En outre, vous devrez peut-tre fournir au script
    <code class="program"><a href="./programs/configure.html">configure</a></code> des informations supplmentaires sur
    le chemin de votre compilateur, de vos librairies, ou de vos fichiers
    d'en-ttes.  A cet effet, vous pouvez passer des options de ligne de
    commande ou des variables d'environnement au script
    <code class="program"><a href="./programs/configure.html">configure</a></code>. Pour plus d'informations, voir la
    page de manuel de <code class="program"><a href="./programs/configure.html">configure</a></code>.</p>

    <p>Pour vous faire une ide des possibilits qui s'offrent  vous, voici
    un exemple typique de compilation d'Apache avec le rpertoire
    d'installation <code>/sw/pkg/apache</code>, un compilateur et des drapeaux
    particuliers et les deux modules additionnels <code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code>
    et <code class="module"><a href="./mod/mod_speling.html">mod_speling</a></code> qui pourront tre chargs plus tard
     l'aide du mcanisme DSO:</p>

<div class="example"><p><code>
      $ CC="pgcc" CFLAGS="-O2" \<br />
       ./configure --prefix=/sw/pkg/apache \<br />
       --enable-rewrite=shared \<br />
       --enable-speling=shared
</code></p></div>

    <p>Quand <code class="program"><a href="./programs/configure.html">configure</a></code> est lanc, il peut prendre
    plusieurs minutes pour tester la disponibilit des fonctionnalits
    au sein de votre systme, et construire les Makefiles qui seront utiliss
    par la suite pour compiler le serveur.</p>

    <p>Vous trouverez une description dtaille des options de
    <code class="program"><a href="./programs/configure.html">configure</a></code> dans sa page de manuel.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="compile" id="compile">Construction</a></h2>

    <p>Vous pouvez maintenant construire les diffrents lments qui
    composent le paquet Apache HTTPd en lanant tout simplement la commande :</p>

<div class="example"><p><code>$ make</code></p></div>

    <p>Vous devez tre patient, car il faut plusieurs minutes pour compiler
    une configuration de base, et cette dure peut varier considrablement
    en fonction de votre matriel et du nombre de modules que vous avez activs.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="install" id="install">Installation</a></h2>

    <p>Il est temps maintenant d'installer le paquet dans le rpertoire
    d'installation dfini par <em>PREFIX</em> (voir plus haut l'option
    <code>--prefix</code>) en lanant:</p>

<div class="example"><p><code>$ make install</code></p></div>

    <p>Si vous effectuez une mise  jour, l'installation n'crasera pas
    vos fichiers de configuration ou autres documents.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="customize" id="customize">Personnalisation</a></h2>

    <p>Ensuite, vous pourrez personnaliser votre Serveur HTTP Apache en
    ditant les <a href="configuring.html">fichiers de configuration</a>
    situs dans <code><em>PREFIX</em>/conf/</code>.</p>

<div class="example"><p><code>$ vi <em>PREFIX</em>/conf/httpd.conf</code></p></div>

    <p>Consultez le manuel du serveur HTTP Apache situ dans
    <a href="./">docs/manual/</a> ou
    <a href="http://httpd.apache.org/docs/2.2/">http://httpd.apache.org/docs/2.2/</a> pour la version la plus
    rcente de ce manuel et la liste complte des <a href="mod/directives.html">directives de configuration</a> disponibles.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="test" id="test">Test</a></h2>

    <p>Vous pouvez maintenant <a href="invoking.html">dmarrer</a> votre
    Serveur HTTP Apache en lanant:</p>

<div class="example"><p><code>$ <em>PREFIX</em>/bin/apachectl -k start</code></p></div>

    <p>Vous devriez alors pouvoir requrir votre premier document
     l'aide de l'URL <code>http://localhost/</code>. La page web que vous
    voyez est situe dans le rpertoire dfini par la directive
    <code class="directive"><a href="./mod/core.html#documentroot">DocumentRoot</a></code>,
    qui est gnralement <code><em>PREFIX</em>/htdocs/</code>.
    Pour <a href="stopping.html">arrter</a> le serveur, lancez:</p>

<div class="example"><p><code>$ <em>PREFIX</em>/bin/apachectl -k stop</code></p></div>
</div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="upgrading" id="upgrading">Mise  jour</a></h2>

    <p>La premire tape d'une mise  jour consiste  lire l'annonce de la
    sortie de la nouvelle version et le fichier <code>CHANGES</code>
    dans la distribution des sources afin de dceler toutes les modifications
    qui pourraient affecter votre site. Lors d'un changement majeur de version
    (par exemple de 1.3  2.0 ou de 2.0  2.2),
    il y aura certainement des diffrences importantes quant  la
    configuration de la compilation et de l'excution qui ncessiteront des
    ajustements manuels.  Tous les
    modules devront aussi tre mis  jour pour qu'ils s'adaptent aux
    changements de l'API des modules.</p>

    <p>La mise  jour d'une version mineure  la suivante (par exemple, de
    2.2.55  2.2.57) est plus aise.  Le processus <code>make install</code>
    n'crasera aucun de vos documents existants, fichiers de log,
    ou fichiers de configuration.  De plus, les dveloppeurs font tout
    leur possible pour viter les changements entranant une
    incompatibilit dans les options de
    <code class="program"><a href="./programs/configure.html">configure</a></code>, la configuration de l'excution, ou l'API
    des modules d'une version mineure  l'autre.  Dans la plupart des cas,
    vous pourrez utiliser une ligne de commande
    <code class="program"><a href="./programs/configure.html">configure</a></code> identique, le mme fichier de configuration,
    et tous vos modules continueront de fonctionner.</p>

    <p>Pour effectuer une mise  jour entre deux versions mineures,
    commencez par trouver le fichier
    <code>config.nice</code> dans le rpertoire de <code>construction</code>
    de votre serveur install ou  la racine de l'arborescence des sources
    de votre ancienne installation.  Il contient la reproduction exacte de la
    ligne de commande <code class="program"><a href="./programs/configure.html">configure</a></code> que vous avez utilise pour
    configurer l'arborescence des sources.  Ensuite, pour mettre  jour
    l'ancienne version vers la nouvelle,
    il vous suffit de copier le fichier <code>config.nice</code> dans
    l'arborescence des sources de la nouvelle version, de l'diter pour
    effectuer toute modification souhaite, et de lancer:</p>

    <div class="example"><p><code>
    $ ./config.nice<br />
    $ make<br />
    $ make install<br />
    $ <em>PREFIX</em>/bin/apachectl -k graceful-stop<br />
    $ <em>PREFIX</em>/bin/apachectl -k start<br />
    </code></p></div>

    <div class="warning">Vous devez toujours effectuer un test de la nouvelle
    version dans votre environnement avant de la mettre en production.
    Par exemple, vous pouvez installer et excuter la nouvelle version
    en parallle avec l'ancienne en utilisant une option
    <code>--prefix</code> et un port diffrents (en ajustant la directive
    <code class="directive"><a href="./mod/mpm_common.html#listen">Listen</a></code>) afin de dceler toute
    incompatibilit avant d'effectuer la mise  jour dfinitive.</div>

    </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./de/install.html" hreflang="de" rel="alternate" title="Deutsch">&nbsp;de&nbsp;</a> |
<a href="./en/install.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./es/install.html" hreflang="es" rel="alternate" title="Espaol">&nbsp;es&nbsp;</a> |
<a href="./fr/install.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./ja/install.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="./ko/install.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="./tr/install.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2012 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div>
</body></html>