/* This file is Copyright 1993 by Clifford A. Adams */
/* shmisc.c
 *
 * help scan mode misc. functions
 * (includes many of the Scan interface routines)
 */

/* trim this list */
#include "EXTERN.h"
#include "common.h"
#ifdef SCAN
#include "intrp.h"
#include "scan.h"
#include "scmd.h"
#include "sdisp.h"
#include "smisc.h"
#include "shelp.h"
#include "shdata.h"
#include "term.h"
#include "util.h"
#include "INTERN.h"
#include "shmisc.h"

/* could be more picky later */
bool
sh_eligible(ent)
long ent;
{
    return(TRUE);
}

char *
sh_get_desc(ent,line,trunc)
long ent;
int line;
bool_int trunc;		/* should this be truncated? */
{
    static char desc_buf[256];
    static char lbuf[256];

    desc_buf[0] = '\0';
    /* name has same function for any type */
    sprintf(lbuf,"%s",sh_ents[ent].name);
    strcat(desc_buf,lbuf);
    if (trunc)
	desc_buf[s_desc_cols] = '\0';
    return(desc_buf);
}

/* fixed 5-character line */
char *
sh_get_statchars(ent,line)
long ent;
int line;
{
    static char statbuf[256];

    switch (sh_ents[ent].type) {
	case 1:		/* help file */
	    strcpy(statbuf," help");
	    break;
	case 2:		/* file */
	    strcpy(statbuf,"topic");
	    break;
    }
    statbuf[s_status_cols] = '\0';
    return(statbuf);
}

void
sh_refresh_top()
{
    char lbuf[256];
    char *s;

    standout();
    if (sh_num_contexts==1)
	printf("Top Level |");
    else
	printf("Level %d |",sh_num_contexts);
    /* add flags (if any) here */
    /* print up to 40 characters of title (change to less later?) */
    s = sh_contexts[sh_num_contexts-1].title;
    if (strlen(s)<41)
	printf(" %s",s);
    else {
	/* actually use 43 characters of line */
	strncpy(lbuf,s,40);
	lbuf[40] = '\0';
	printf(" %s...",lbuf);
    }
    un_standout();
    erase_eol();
    printf("\n") FLUSH;
}

void
sh_refresh_bot()
{
    standout();
    s_mail_and_place();
    un_standout();
    erase_eol();
    fflush(stdout);
}

int
sh_ent_lines(ent)
long ent;
{
    return(1);
}

/* returns TRUE if screen/window is big enough, FALSE otherwise */
/* for now, the requirements are 15 columns and 5 lines */
bool
sh_check_screen()
{
    if (LINES<5 || COLS<5)
	return(FALSE);
    return(TRUE);
}

/* sets up shape of screen */
/* assumes s_initscreen has been called */
void
sh_set_screen()
{
    /* One size fits all for now. */
    s_top_lines = 1;
    s_bot_lines = 1;
    s_status_cols = 5;
    s_cursor_cols = 2;
    /* (scr_width-1) keeps last character blank. */
    s_desc_cols = (scr_width-1)-s_status_cols-s_cursor_cols;
}

/* prints out the file "file" */
void
sh_page_file(file)
char *file;
{
    static char lbuf[512];
    static char lbuf2[512];
    char *s;
    int i;

    /* find the current directory */
    for (i=sh_num_contexts-1;i>=0;i--)
	if (sh_contexts[i].filename)
	    break;
    if (i<0) {
	s_beep();
	printf("\nsh_page_file: Cannot find the current directory.\n") FLUSH;
	(void)get_anything();
	return;
    }
    if (strlen(sh_contexts[i].filename) > 450) {
	s_beep();
	printf("\nsh_page_file: Path name too long.\n") FLUSH;
	(void)get_anything();
	return;
    }
    safecpy(lbuf,sh_contexts[i].filename,500);
    s = rindex(lbuf,'/');
    if (!s || !*s) {
	s_beep();
	printf("\nsh_page_file: no '/' in file name.\n") FLUSH;
	(void)get_anything();
	return;
    }
    s++;
    strcpy(s,file);			/* make new filename */
    s = getval("HELPPAGER",getval("PAGER","more"));
    sprintf(lbuf2,"%s %s",s,lbuf);
    resetty();			/* make sure tty is friendly */
    doshell(sh,filexp(lbuf2));
    noecho();			/* and make terminal */
    crmode();			/*   unfriendly again */
    (void)get_anything();
}
#endif /* SCAN */
