/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.rmi.RemoteException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.util.Enumeration;
import java.util.Hashtable;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.LeaseChecker;
import sun.rmi.transport.LeaseInfo;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.RMIThread;
import sun.rmi.transport.Target;
import sun.rmi.transport.Utils;

final class DGCImpl
implements DGC {
    static int logLevel = DGCImpl.getLogLevel();
    static final long leaseCheckInterval = Utils.getLong("sun.rmi.dgc.checkInterval", 300000L);
    private static ObjID dgcID;
    private static DGCImpl dgc;
    private Hashtable leaseTable = new Hashtable();
    private Thread checker;

    private static int getLogLevel() {
        SecurityManager.enablePrivilege((String)"UniversalPropertyRead");
        return LogStream.parseLevel(Utils.getProperty("sun.rmi.dgc.logLevel"));
    }

    static DGCImpl getDGCImpl() {
        return dgc;
    }

    private DGCImpl() {
    }

    public Lease dirty(ObjID[] objIDArray, long l, Lease lease) {
        Object object;
        VMID vMID = lease.getVMID();
        long l2 = lease.getValue();
        if (logLevel >= 20) {
            LogStream.log("dgc").println("DGCImpl.dirty: vmid = " + vMID);
        }
        if (vMID == null) {
            vMID = new VMID();
            lease = new Lease(vMID, l2);
            if (logLevel >= 10) {
                try {
                    object = RemoteServer.getClientHost();
                }
                catch (ServerNotActiveException serverNotActiveException) {
                    object = "<unknown host>";
                }
                LogStream.log("dgc").println("DGCImpl.dirty: assigning vmid " + vMID + " to client " + (String)object);
            }
        }
        object = this.leaseTable;
        synchronized (object) {
            LeaseInfo leaseInfo = (LeaseInfo)this.leaseTable.get(vMID);
            if (leaseInfo == null) {
                this.leaseTable.put(vMID, new LeaseInfo(vMID, l2));
                if (this.checker == null) {
                    this.checker = RMIThread.newThread(new LeaseChecker(), "LeaseChecker", true);
                    this.checker.start();
                }
            } else {
                leaseInfo.renew(l2);
            }
        }
        int n = 0;
        while (n < objIDArray.length) {
            if (logLevel >= 20) {
                LogStream.log("dgc").println("DGCImpl.dirty: id = " + objIDArray[n] + ", vmid = " + vMID + ", duration = " + l2);
            }
            ObjectTable.referenced(objIDArray[n], l, vMID);
            ++n;
        }
        return lease;
    }

    public void clean(ObjID[] objIDArray, long l, VMID vMID, boolean bl) {
        int n = 0;
        while (n < objIDArray.length) {
            if (logLevel >= 20) {
                LogStream.log("dgc").println("DGCImpl.clean: id = " + objIDArray[n] + ", vmid = " + vMID + ", strong = " + bl);
            }
            ObjectTable.unreferenced(objIDArray[n], l, vMID, bl);
            ++n;
        }
    }

    void registerTarget(VMID vMID, Target target) {
        Hashtable hashtable = this.leaseTable;
        synchronized (hashtable) {
            LeaseInfo leaseInfo = (LeaseInfo)this.leaseTable.get(vMID);
            if (leaseInfo == null) {
                target.vmidDead(vMID);
            } else if (!leaseInfo.notifyList.contains(target)) {
                leaseInfo.notifyList.addElement(target);
            }
            return;
        }
    }

    void unregisterTarget(VMID vMID, Target target) {
        Hashtable hashtable = this.leaseTable;
        synchronized (hashtable) {
            LeaseInfo leaseInfo = (LeaseInfo)this.leaseTable.get(vMID);
            if (leaseInfo != null) {
                leaseInfo.notifyList.removeElement(target);
            }
            return;
        }
    }

    boolean checkLeases() {
        long l = System.currentTimeMillis();
        Hashtable hashtable = this.leaseTable;
        synchronized (hashtable) {
            Enumeration enumeration = this.leaseTable.elements();
            while (enumeration.hasMoreElements()) {
                LeaseInfo leaseInfo = (LeaseInfo)enumeration.nextElement();
                if (!leaseInfo.expired(l)) continue;
                this.leaseTable.remove(leaseInfo);
            }
            if (this.leaseTable.isEmpty()) {
                this.checker = null;
                boolean bl = false;
                Object var5_7 = null;
                return bl;
            }
            boolean bl = true;
            Object var5_8 = null;
            return bl;
        }
    }

    static ObjID getID() {
        return dgcID;
    }

    static {
        try {
            dgc = new DGCImpl();
            dgcID = new ObjID(2);
            LiveRef liveRef = new LiveRef(dgcID, 0);
            UnicastServerRef unicastServerRef = new UnicastServerRef(liveRef);
            RemoteStub remoteStub = unicastServerRef.setSkeleton(dgc);
            Target target = new Target(dgc, unicastServerRef, remoteStub);
            target.setPermanent(true);
            ObjectTable.putTarget(dgcID, target);
        }
        catch (RemoteException remoteException) {
            System.out.println("couldn't init remote garbage collector");
            System.out.println(remoteException.getMessage());
            remoteException.printStackTrace();
        }
    }
}

