/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.FastStringBuffer;
import netscape.application.Graphics;
import netscape.application.Range;
import netscape.application.Rect;
import netscape.application.TextParagraphFormat;
import netscape.application.TextPositionInfo;
import netscape.application.TextStyleRun;
import netscape.application.TextView;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Hashtable;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class TextParagraph
implements Cloneable,
Codable {
    TextView _owner;
    TextParagraphFormat _format;
    Vector _runVector;
    int _y;
    int _height;
    int[] _lineBreaks;
    int _breakCount;
    int[] _lineHeights;
    int _heightCount;
    int[] _baselines;
    int _baselineCount;
    int[] _lineRemainders;
    int _remainderCount;
    int _charCount;
    int _startChar;
    static final String FORMAT_KEY = "format";
    static final String RUNVECTOR_KEY = "runVector";

    public TextParagraph() {
    }

    TextParagraph(TextView textView) {
        this();
        this.init(textView);
    }

    TextParagraph(TextView textView, TextParagraphFormat textParagraphFormat) {
        this();
        this.init(textView, textParagraphFormat);
    }

    void init(TextView textView, TextParagraphFormat textParagraphFormat) {
        this._owner = textView;
        this._runVector = new Vector();
        this.setFormat(textParagraphFormat);
    }

    void init(TextView textView) {
        this.init(textView, null);
    }

    Object objectAt(Vector vector, int n) {
        if (n < 0 || n >= vector.count()) {
            return null;
        }
        return vector.elementAt(n);
    }

    public Object clone() {
        Object object = null;
        this.collectEmptyRuns();
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InconsistencyException(String.valueOf(this) + ": clone() not supported :" + cloneNotSupportedException);
        }
        if (object != null) {
            TextParagraph textParagraph = (TextParagraph)object;
            textParagraph._owner = null;
            textParagraph._format = this._format != null ? (TextParagraphFormat)this._format.clone() : null;
            textParagraph._runVector = new Vector();
            int n = this._runVector.count();
            int n2 = 0;
            while (n2 < n) {
                TextStyleRun textStyleRun = (TextStyleRun)this._runVector.elementAt(n2);
                textParagraph.addRun(textStyleRun.createEmptyRun());
                ++n2;
            }
            textParagraph._lineBreaks = null;
            textParagraph._lineHeights = null;
            textParagraph._baselines = null;
            textParagraph._lineRemainders = null;
        }
        return object;
    }

    void setOwner(TextView textView) {
        this._owner = textView;
    }

    TextView owner() {
        return this._owner;
    }

    void setY(int n) {
        this._y = n;
    }

    void setStartChar(int n) {
        this._startChar = n;
    }

    void setFormat(TextParagraphFormat textParagraphFormat) {
        if (textParagraphFormat == null && this._format == null) {
            return;
        }
        this._format = textParagraphFormat != null ? (TextParagraphFormat)textParagraphFormat.clone() : null;
        if (this._charCount > 0) {
            this.computeLineBreaksAndHeights(this._owner.bounds.width);
        }
    }

    TextParagraphFormat format() {
        return this._format;
    }

    TextParagraphFormat currentParagraphFormat() {
        if (this._format != null) {
            return this._format;
        }
        TextParagraphFormat textParagraphFormat = null;
        if (this._owner != null) {
            textParagraphFormat = (TextParagraphFormat)this._owner.defaultAttributes().get((Object)"ParagraphFormatKey");
        }
        if (textParagraphFormat != null) {
            return textParagraphFormat;
        }
        return new TextParagraphFormat();
    }

    Vector runVector() {
        return this._runVector;
    }

    TextStyleRun firstRun() {
        return (TextStyleRun)this._runVector.firstElement();
    }

    TextStyleRun lastRun() {
        return (TextStyleRun)this._runVector.lastElement();
    }

    void addRun(TextStyleRun textStyleRun) {
        if (textStyleRun != null) {
            textStyleRun.setParagraph(this);
            this._runVector.addElement((Object)textStyleRun);
        }
    }

    void collectEmptyRuns() {
        int n = 1;
        int n2 = this._runVector.count();
        while (n < n2) {
            TextStyleRun textStyleRun = (TextStyleRun)this._runVector.elementAt(n);
            if (textStyleRun.charCount() == 0 && (textStyleRun._attributes == null || textStyleRun._attributes.get((Object)"LinkDestinationKey") == null)) {
                this._runVector.removeElementAt(n);
                --n;
                --n2;
            }
            ++n;
        }
    }

    void addRuns(Vector vector) {
        if (vector != null) {
            int n = vector.count();
            int n2 = 0;
            while (n2 < n) {
                this.addRun((TextStyleRun)vector.elementAt(n2));
                ++n2;
            }
        }
    }

    void insertRunAt(TextStyleRun textStyleRun, int n) {
        if (textStyleRun != null && n >= 0) {
            textStyleRun.setParagraph(this);
            this._runVector.insertElementAt((Object)textStyleRun, n);
        }
    }

    TextStyleRun runBefore(TextStyleRun textStyleRun) {
        if (textStyleRun == null) {
            return null;
        }
        int n = this._runVector.indexOfIdentical((Object)textStyleRun);
        if (n < 1) {
            return null;
        }
        return (TextStyleRun)this._runVector.elementAt(n - 1);
    }

    TextStyleRun runAfter(TextStyleRun textStyleRun) {
        if (textStyleRun == null) {
            return null;
        }
        int n = this._runVector.indexOfIdentical((Object)textStyleRun);
        if (n == this._runVector.count() - 1) {
            return null;
        }
        return (TextStyleRun)this._runVector.elementAt(n + 1);
    }

    Vector runsBefore(TextStyleRun textStyleRun) {
        Vector vector = TextView.newVector();
        if (textStyleRun == null) {
            return vector;
        }
        int n = this._runVector.indexOfIdentical((Object)textStyleRun);
        if (n == -1) {
            return vector;
        }
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(this._runVector.elementAt(n2));
            ++n2;
        }
        return vector;
    }

    Vector runsAfter(TextStyleRun textStyleRun) {
        Vector vector = TextView.newVector();
        if (textStyleRun == null) {
            return vector;
        }
        int n = this._runVector.indexOfIdentical((Object)textStyleRun);
        if (n == -1) {
            return vector;
        }
        int n2 = this._runVector.count();
        while (n < n2) {
            vector.addElement(this._runVector.elementAt(n));
            ++n;
        }
        return vector;
    }

    /*
     * Unable to fully structure code
     */
    Vector runsFromTo(TextStyleRun var1_1, TextStyleRun var2_2) {
        var3_3 = TextView.newVector();
        if (var1_1 == var2_2 && var1_1 != null) {
            var3_3.addElement((Object)var1_1);
            return var3_3;
        }
        var4_4 = var1_1 == null ? 0 : this._runVector.indexOfIdentical((Object)var1_1);
        var5_5 = var2_2 == null ? this._runVector.count() - 1 : this._runVector.indexOfIdentical((Object)var2_2);
        if (var4_4 >= 0 && var5_5 >= 0) ** GOTO lbl11
        return var3_3;
lbl-1000:
        // 1 sources

        {
            var3_3.addElement(this._runVector.elementAt(var4_4));
            ++var4_4;
lbl11:
            // 2 sources

            ** while (var4_4 <= var5_5)
        }
lbl12:
        // 1 sources

        return var3_3;
    }

    void removeRun(TextStyleRun textStyleRun) {
        if (textStyleRun != null) {
            this._runVector.removeElement((Object)textStyleRun);
        }
    }

    void removeRuns(Vector vector) {
        if (vector == null) {
            return;
        }
        int n = vector.count();
        while (n-- > 0) {
            this._runVector.removeElement(vector.elementAt(n));
        }
    }

    void removeRunAt(int n) {
        this._runVector.removeElementAt(n);
    }

    boolean isEmpty() {
        int n = 0;
        int n2 = this._runVector.count();
        while (n2-- > 0 && n == 0) {
            TextStyleRun textStyleRun = (TextStyleRun)this._runVector.elementAt(n2);
            n += textStyleRun.charCount();
        }
        return n == 0;
    }

    int[] _growArrayTo(int[] nArray, int n) {
        int n2;
        if (n < 1) {
            return nArray;
        }
        if (nArray != null && nArray.length >= n) {
            return nArray;
        }
        int[] nArray2 = nArray;
        if (nArray != null) {
            n2 = nArray.length;
            while (n2 < n) {
                n2 *= 2;
            }
        } else {
            n2 = 20;
        }
        nArray = new int[n2];
        if (nArray2 == null) {
            return nArray;
        }
        System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
        return nArray;
    }

    void _addLineBreak(int n) {
        if (n < 0) {
            return;
        }
        this._lineBreaks = this._growArrayTo(this._lineBreaks, this._breakCount + 1);
        this._lineBreaks[this._breakCount] = n;
        ++this._breakCount;
    }

    void _addLineHeightAndBaseline(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return;
        }
        this._lineHeights = this._growArrayTo(this._lineHeights, this._heightCount + 1);
        this._lineHeights[this._heightCount] = n;
        ++this._heightCount;
        this._baselines = this._growArrayTo(this._baselines, this._baselineCount + 1);
        this._baselines[this._baselineCount] = n2;
        ++this._baselineCount;
    }

    void _addLineRemainder(int n) {
        if (n < 0) {
            n = 0;
        }
        this._lineRemainders = this._growArrayTo(this._lineRemainders, this._remainderCount + 1);
        this._lineRemainders[this._remainderCount] = n;
        ++this._remainderCount;
    }

    int addWidthOfInitialTabs(int n) {
        int n2 = 0;
        int[] nArray = this.currentParagraphFormat().tabPositions();
        int n3 = 0;
        int n4 = this._runVector.count();
        while (n3 < n4) {
            TextStyleRun textStyleRun = (TextStyleRun)this._runVector.elementAt(n3);
            FastStringBuffer fastStringBuffer = textStyleRun._contents;
            if (fastStringBuffer == null || fastStringBuffer.length() == 0) break;
            int n5 = 0;
            int n6 = fastStringBuffer.length();
            while (n5 < n6 && fastStringBuffer.charAt(n5) == '\t') {
                ++n2;
                ++n5;
            }
            if (n5 < n6) break;
            ++n3;
        }
        if (n2 == 0) {
            return n;
        }
        n3 = 0;
        n4 = nArray.length;
        while (n3 < n4) {
            if (nArray[n3] >= n) break;
            ++n3;
        }
        if (n3 == n4) {
            return n;
        }
        if ((n3 += n2) >= nArray.length) {
            return nArray[nArray.length - 1];
        }
        return nArray[n3 - 1];
    }

    void computeLineBreaksAndHeights(int n) {
        this.computeLineBreaksAndHeights(n, 0);
    }

    /*
     * Unable to fully structure code
     */
    void computeLineBreaksAndHeights(int var1_1, int var2_2) {
        var20_3 = this.currentParagraphFormat();
        if (var2_2 > 0) {
            --var2_2;
        }
        this._breakCount = var2_2;
        this._heightCount = var2_2;
        this._baselineCount = var2_2;
        this._remainderCount = var2_2;
        if (var20_3._justification == 0 && var2_2 == 0) {
            this._lineRemainders = null;
        }
        if ((var1_1 -= var20_3._leftMargin + var20_3._rightMargin) < 1) {
            var1_1 = 1;
        }
        if (var2_2 == 0) {
            var9_4 = var1_1 - var20_3._leftIndent;
            if (var9_4 < 1) {
                var9_4 = 1;
            }
            var13_5 = var9_4;
            this._height = 0;
            this._charCount = 0;
        } else {
            var9_4 = var1_1;
            var13_5 = var1_1;
            this._height = 0;
            var5_6 = 0;
            while (var5_6 < var2_2) {
                this._height += this._lineHeights[var5_6];
                ++var5_6;
            }
            this._charCount = this._lineBreaks[var2_2 - 1];
        }
        var4_7 = this._runVector.count();
        var10_8 = this._charCount;
        var11_9 = 0;
        var12_10 = 0;
        var15_11 = 0;
        var14_12 = 0;
        var19_14 = var18_13 = var20_3._leftMargin;
        if (var2_2 == 0) {
            var18_13 += var20_3._leftIndent;
        }
        if (var20_3.wrapsUnderFirstCharacter()) {
            var19_14 = this.addWidthOfInitialTabs(var20_3._leftMargin + var20_3._leftIndent);
            var9_4 = var1_1 -= var19_14 - var18_13;
        }
        if (var2_2 == 0) {
            var5_6 = 0;
            var3_15 = null;
            var7_16 = 0;
            var6_17 = 0;
        } else {
            var3_15 = this.runForCharPosition(this._startChar + this._charCount);
            var5_6 = this._runVector.indexOfIdentical((Object)var3_15) + 1;
            var7_16 = var3_15.charCount();
            var6_17 = this._startChar + this._charCount - var3_15.rangeIndex();
            this._charCount += var3_15.rangeIndex() + var7_16 - (this._startChar + this._charCount);
        }
        block1: while (true) {
            if (var3_15 == null || var6_17 >= var7_16) {
                if (var5_6 == this._runVector.count()) break;
                if ((var3_15 = (TextStyleRun)this._runVector.elementAt(var5_6++)).charCount() == 0) continue;
                var6_17 = 0;
                var7_16 = var3_15.charCount();
                this._charCount += var7_16;
            }
            while (true) {
                if (var6_17 < var7_16) ** break;
                continue block1;
                var8_18 = var3_15.charsForWidth(var6_17, var18_13, var9_4, var13_5, var20_3._tabStops);
                if (var8_18 > 0) {
                    var6_17 += var8_18;
                    var10_8 += var8_18;
                    var16_19 = var3_15.baseline();
                    var17_20 = var3_15.height() - var3_15.baseline();
                    if (var14_12 < var16_19) {
                        var14_12 = var16_19;
                    }
                    if (var15_11 < var17_20) {
                        var15_11 = var17_20;
                    }
                    if (var14_12 + var15_11 > var11_9) {
                        var11_9 = var14_12 + var15_11;
                    }
                    if (var14_12 > var12_10) {
                        var12_10 = var14_12;
                    }
                    var18_13 += var9_4 - var3_15._remainder;
                    var9_4 = var3_15._remainder;
                }
                if (var6_17 >= var7_16) continue;
                this._addLineBreak(var10_8);
                this._addLineHeightAndBaseline(var11_9 + var20_3._lineSpacing, var12_10);
                this._height += var11_9 + var20_3._lineSpacing;
                this._addLineRemainder(var9_4);
                var9_4 = var13_5 = var1_1;
                var12_10 = 0;
                var11_9 = 0;
                var15_11 = 0;
                var14_12 = 0;
                var18_13 = var19_14;
            }
            break;
        }
        this._addLineBreak(var10_8);
        if (var11_9 == 0) {
            var3_15 = (TextStyleRun)this._runVector.firstElement();
            var11_9 = var3_15.height() + var20_3._lineSpacing;
            var12_10 = var3_15.baseline();
        } else {
            var11_9 += var20_3._lineSpacing;
        }
        this._addLineHeightAndBaseline(var11_9, var12_10);
        this._height += var11_9;
        this._addLineRemainder(var9_4);
        ++this._charCount;
    }

    int characterStartingLine(int n) {
        if (n == 0) {
            return this._startChar;
        }
        if (n < this._breakCount) {
            return this._startChar + this._lineBreaks[n - 1];
        }
        return -1;
    }

    Rect rectForLine(int n) {
        TextParagraphFormat textParagraphFormat = this.currentParagraphFormat();
        if (n >= this._breakCount) {
            return null;
        }
        int n2 = this._y;
        int n3 = 0;
        while (n3 < n) {
            n2 += this._lineHeights[n3];
            ++n3;
        }
        return TextView.newRect(textParagraphFormat._leftMargin, n2, this._owner.bounds.width - textParagraphFormat._rightMargin, this._lineHeights[n3]);
    }

    Range rangeForLine(int n) {
        if (n >= this._breakCount) {
            return new Range(this._startChar + this._charCount, 0);
        }
        if (n == 0) {
            return new Range(this._startChar, this._lineBreaks[n]);
        }
        return new Range(this._startChar + this._lineBreaks[n - 1], this._lineBreaks[n] - this._lineBreaks[n - 1]);
    }

    int runIndexForCharPosition(int n) {
        int n2 = n - this._startChar;
        int n3 = this._runVector.count();
        int n4 = 0;
        while (n4 < n3) {
            TextStyleRun textStyleRun = (TextStyleRun)this._runVector.elementAt(n4);
            if (textStyleRun.charCount() <= n2) {
                n2 -= textStyleRun.charCount();
            } else {
                return n4;
            }
            ++n4;
        }
        return this._runVector.count() - 1;
    }

    TextStyleRun runForCharPosition(int n) {
        int n2 = this.runIndexForCharPosition(n);
        if (n2 >= 0) {
            return (TextStyleRun)this._runVector.elementAt(n2);
        }
        return null;
    }

    char characterAt(int n) {
        if (this._charCount < 2) {
            return '\n';
        }
        int n2 = n - this._startChar;
        int n3 = this._runVector.count();
        int n4 = 0;
        while (n4 < n3) {
            TextStyleRun textStyleRun = (TextStyleRun)this._runVector.elementAt(n4);
            if (textStyleRun.charCount() <= n2) {
                n2 -= textStyleRun.charCount();
            } else {
                char c = textStyleRun.charAt(n2);
                return c;
            }
            ++n4;
        }
        if (n2 < 2) {
            return '\n';
        }
        return '\u0000';
    }

    int lineForPosition(int n) {
        int n2 = n - this._startChar;
        if (this._breakCount > 0 && n2 == this._lineBreaks[this._breakCount - 1]) {
            return this._breakCount - 1;
        }
        int n3 = 0;
        while (n3 < this._breakCount && n2 >= this._lineBreaks[n3]) {
            ++n3;
        }
        if (n3 >= this._breakCount) {
            return -1;
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    TextPositionInfo positionForPoint(int var1_1, int var2_2, boolean var3_3) {
        var4_4 = null;
        var16_5 = 0;
        var18_6 = this.currentParagraphFormat();
        var7_7 = this._y;
        var6_8 = 0;
        while (var6_8 < this._breakCount) {
            if (var2_2 >= var7_7 && var2_2 <= var7_7 + this._lineHeights[var6_8]) break;
            var7_7 += this._lineHeights[var6_8];
            ++var6_8;
        }
        var8_10 = (var13_9 = var6_8) == 0 ? this._startChar : this._startChar + this._lineBreaks[var13_9 - 1];
        var9_11 = this._startChar + this._lineBreaks[var13_9];
        var17_12 = this._runVector.count();
        var10_13 = this._startChar;
        var6_8 = 0;
        while (var6_8 < var17_12) {
            var4_4 = (TextStyleRun)this._runVector.elementAt(var6_8);
            if (var10_13 + var4_4.charCount() > var8_10) {
                var16_5 = var8_10 - var10_13;
                break;
            }
            var10_13 += var4_4.charCount();
            ++var6_8;
        }
        if (var4_4 == null) {
            return null;
        }
        var14_14 = var6_8;
        var11_15 = var18_6._justification == 0 ? var18_6._leftMargin : (var18_6._justification == 2 ? var18_6._leftMargin + this._lineRemainders[var13_9] : var18_6._leftMargin + this._lineRemainders[var13_9] / 2);
        var12_16 = this._owner.bounds.width - var18_6._leftMargin - var18_6._rightMargin;
        if (var13_9 == 0) {
            var11_15 += var18_6._leftIndent;
            var12_16 -= var18_6._leftIndent;
        } else if (var18_6.wrapsUnderFirstCharacter()) {
            var19_17 = var11_15;
            var11_15 = this.addWidthOfInitialTabs(var11_15 + var18_6._leftIndent);
            var12_16 -= var11_15 - var19_17;
        }
        if (var12_16 < 1) {
            var12_16 = 1;
        }
        if (var1_1 > var11_15 + var12_16 - this._lineRemainders[var13_9]) {
            var5_18 = this.infoForPosition(var9_11, -1);
            var5_18.setAtEndOfLine(true);
            return var5_18;
        }
        if (var1_1 <= var11_15) {
            return this.infoForPosition(var8_10, var2_2);
        }
        ++var14_14;
        while (var4_4 != null && var4_4.charCount() == 0) {
            var4_4 = this.runAfter(var4_4);
            ++var14_14;
        }
        if (var4_4 != null) ** GOTO lbl70
        return this.infoForPosition(var8_10 + var10_13, var2_2);
lbl-1000:
        // 1 sources

        {
            var15_19 = var4_4.widthOfContents(var16_5, 1, var11_15, var18_6._tabStops);
            if (var1_1 >= var11_15 && var1_1 <= var11_15 + var15_19) {
                if (var3_3) {
                    return this.infoForPosition(var8_10, var2_2);
                }
                if (var1_1 >= var11_15 + (var15_19 /= 2)) {
                    return this.infoForPosition(var8_10 + 1, var2_2);
                }
                return this.infoForPosition(var8_10, var2_2);
            }
            if (++var16_5 >= var4_4.charCount()) {
                var4_4 = (TextStyleRun)this.objectAt(this._runVector, var14_14++);
                while (var4_4 != null && var4_4.charCount() == 0) {
                    var4_4 = this.runAfter(var4_4);
                    ++var14_14;
                }
                if (var4_4 == null) {
                    return this.infoForPosition(var8_10 + var10_13, var2_2);
                }
                var16_5 = 0;
            }
            ++var8_10;
            var11_15 += var15_19;
lbl70:
            // 2 sources

            ** while (var8_10 <= var9_11)
        }
lbl71:
        // 1 sources

        return null;
    }

    /*
     * Unable to fully structure code
     */
    TextPositionInfo _infoForPosition(int var1_1) {
        var4_2 = 0;
        var5_3 = 0;
        var6_4 = 1;
        var7_5 = 0;
        var10_6 = 0;
        var15_7 = this.currentParagraphFormat();
        var12_9 = var3_8 = var1_1 - this._startChar;
        if (var3_8 >= this._charCount) {
            var3_8 = this._charCount;
        }
        var13_10 = this._owner.bounds.width - var15_7._leftMargin - var15_7._rightMargin;
        var8_11 = this._y;
        var4_2 = 0;
        while (var4_2 < this._breakCount - 1) {
            if (this._lineBreaks[var4_2] >= var3_8) break;
            var8_11 += this._lineHeights[var4_2];
            ++var4_2;
        }
        if (var4_2 > 0) {
            var6_4 = this.runIndexForCharPosition(this._startChar + this._lineBreaks[var4_2 - 1]);
            var2_12 = (TextStyleRun)this._runVector.elementAt(var6_4++);
            var11_13 = this._lineBreaks[var4_2 - 1] + this._startChar - var2_12.rangeIndex();
            var3_8 -= this._lineBreaks[var4_2 - 1];
        } else {
            var6_4 = 1;
            var2_12 = (TextStyleRun)this._runVector.firstElement();
            var11_13 = 0;
        }
        while (var4_2 < this._breakCount) {
            var5_3 = var4_2 == 0 ? this._lineBreaks[var4_2] : this._lineBreaks[var4_2] - this._lineBreaks[var4_2 - 1];
            if (var5_3 > var3_8) {
                var5_3 = var3_8;
            }
            var7_5 = var15_7._justification == 0 ? var15_7._leftMargin : (var15_7._justification == 2 ? var15_7._leftMargin + this._lineRemainders[var4_2] : var15_7._leftMargin + this._lineRemainders[var4_2] / 2);
            var14_15 = var13_10;
            if (var4_2 == 0) {
                var7_5 += var15_7._leftIndent;
                var14_15 -= var15_7._leftIndent;
            } else if (var15_7.wrapsUnderFirstCharacter()) {
                var16_16 = this.addWidthOfInitialTabs(var7_5 + var15_7._leftIndent);
                var14_15 -= var16_16 - var7_5;
                var7_5 = var16_16;
            }
            if (var14_15 < 1) {
                var14_15 = 1;
            }
            if (var5_3 != 0) ** GOTO lbl74
            return new TextPositionInfo(var2_12, var7_5, var8_11, var4_2, this._lineHeights[var4_2], var11_13, var1_1);
lbl-1000:
            // 1 sources

            {
                var9_14 = var2_12.charCount() - var11_13;
                if (var5_3 >= var9_14) {
                    if (var5_3 <= var3_8) {
                        var10_6 = var2_12.widthOfContents(var11_13, var5_3, var7_5, var15_7._tabStops);
                    }
                    var5_3 -= var9_14;
                    var3_8 -= var9_14;
                    var2_12 = (TextStyleRun)this.objectAt(this._runVector, var6_4++);
                    while (var2_12 != null && var2_12.charCount() == 0) {
                        var2_12 = (TextStyleRun)this.objectAt(this._runVector, var6_4++);
                    }
                    var11_13 = 0;
                } else {
                    if (var5_3 <= var3_8) {
                        var10_6 = var2_12.widthOfContents(var11_13, var5_3, var7_5, var15_7._tabStops);
                    }
                    var11_13 += var5_3;
                    var3_8 -= var5_3;
                    var5_3 = 0;
                }
                var7_5 += var10_6;
                var14_15 -= var10_6;
                if (var3_8 != 0 && (var2_12 != null || var3_8 != 1)) continue;
                if (var2_12 == null) {
                    var2_12 = (TextStyleRun)this._runVector.lastElement();
                    var11_13 = var2_12.charCount();
                }
                var16_17 = new TextPositionInfo(var2_12, var7_5, var8_11, var4_2, this._lineHeights[var4_2], var11_13, var1_1);
                if (var12_9 == this._lineBreaks[var4_2]) {
                    var16_17.setAtEndOfLine(true);
                    if (var4_2 == this._breakCount - 1) {
                        var16_17.setAtEndOfParagraph(true);
                    }
                }
                return var16_17;
lbl74:
                // 2 sources

                ** while (var5_3 > 0)
            }
lbl75:
            // 1 sources

            var8_11 += this._lineHeights[var4_2];
            ++var4_2;
        }
        return null;
    }

    TextPositionInfo infoForPosition(int n, int n2) {
        TextParagraphFormat textParagraphFormat = this.currentParagraphFormat();
        TextPositionInfo textPositionInfo = this._infoForPosition(n);
        if (textPositionInfo == null) {
            textPositionInfo = this._infoForPosition(this._startChar + this._charCount);
            return textPositionInfo;
        }
        if (n2 < textPositionInfo.maxY()) {
            return textPositionInfo;
        }
        TextPositionInfo textPositionInfo2 = this._infoForPosition(n + 1);
        if (textPositionInfo2 == null || textPositionInfo2._lineNumber == textPositionInfo._lineNumber) {
            return textPositionInfo;
        }
        int n3 = textPositionInfo2._lineNumber;
        int n4 = textParagraphFormat._justification == 0 ? textParagraphFormat._leftMargin : (textParagraphFormat._justification == 2 ? textParagraphFormat._leftMargin + this._lineRemainders[n3] : textParagraphFormat._leftMargin + this._lineRemainders[n3] / 2);
        textPositionInfo = new TextPositionInfo(textPositionInfo._textRun, n4, textPositionInfo2._y, textPositionInfo2._lineNumber, textPositionInfo2._lineHeight, textPositionInfo._positionInRun, textPositionInfo._absPosition);
        textPositionInfo.setNextLine(true);
        return textPositionInfo;
    }

    TextPositionInfo insertCharOrStringAt(char c, String string, int n) {
        int n2;
        TextStyleRun textStyleRun = null;
        if (string == null && c == '\u0000') {
            return null;
        }
        int n3 = n - this._startChar;
        int n4 = this._runVector.count();
        int n5 = 0;
        while (n5 < n4) {
            textStyleRun = (TextStyleRun)this.objectAt(this._runVector, n5);
            if (textStyleRun == null) break;
            if (textStyleRun.charCount() < n3) {
                n3 -= textStyleRun.charCount();
            } else {
                if (!textStyleRun.containsATextAttachment()) break;
                if (n3 == 0) {
                    TextStyleRun textStyleRun2 = textStyleRun.createEmptyRun();
                    this.insertRunAt(textStyleRun2, this._runVector.indexOfIdentical((Object)textStyleRun));
                    textStyleRun = textStyleRun2;
                } else {
                    TextStyleRun textStyleRun3 = null;
                    if (n5 > 0) {
                        textStyleRun3 = (TextStyleRun)this.objectAt(this._runVector, n5 - 1);
                        TextStyleRun textStyleRun4 = textStyleRun3.createEmptyRun(TextView.attributesByRemovingStaticAttributes(textStyleRun3.attributes()));
                        this.insertRunAt(textStyleRun4, this._runVector.indexOfIdentical((Object)textStyleRun) + 1);
                        textStyleRun = textStyleRun4;
                    } else {
                        textStyleRun = (TextStyleRun)this.objectAt(this._runVector, 0);
                        TextStyleRun textStyleRun5 = textStyleRun.createEmptyRun(TextView.attributesByRemovingStaticAttributes(textStyleRun.attributes()));
                        this.insertRunAt(textStyleRun5, 1);
                        textStyleRun = textStyleRun5;
                    }
                    if (textStyleRun == null) {
                        textStyleRun = new TextStyleRun(this, "", null);
                        this.addRun(textStyleRun);
                    }
                }
                n3 = 0;
                break;
            }
            ++n5;
        }
        if ((n5 >= n4 || textStyleRun == null) && n3 == 1) {
            textStyleRun = (TextStyleRun)this._runVector.lastElement();
            n3 = textStyleRun.charCount();
        } else if (textStyleRun == null) {
            return null;
        }
        int n6 = this.lineForPosition(n - 1);
        int n7 = this._lineBreaks[n6] + this._startChar;
        TextPositionInfo textPositionInfo = this.infoForPosition(n7, -1);
        int n8 = this._height;
        if (string != null) {
            textStyleRun.insertStringAt(string, n3);
            n2 = string.length();
        } else {
            textStyleRun.insertCharAt(c, n3);
            n2 = 1;
        }
        this.computeLineBreaksAndHeights(this._owner.bounds.width, n6);
        TextPositionInfo textPositionInfo2 = this.infoForPosition(n + n2, -1);
        if (n8 != this._height) {
            textPositionInfo2.setRedrawCurrentParagraphOnly(false);
            textPositionInfo2.setRedrawCurrentLineOnly(false);
            return textPositionInfo2;
        }
        textPositionInfo2.setRedrawCurrentParagraphOnly(true);
        if (textPositionInfo2._lineNumber != textPositionInfo._lineNumber) {
            textPositionInfo2.setRedrawCurrentParagraphOnly(false);
            if (textPositionInfo._lineNumber < textPositionInfo2._lineNumber) {
                textPositionInfo2.setUpdateLine(textPositionInfo._lineNumber);
            } else {
                textPositionInfo2.setUpdateLine(textPositionInfo2._lineNumber);
            }
            return textPositionInfo2;
        }
        textPositionInfo2.setRedrawCurrentParagraphOnly(true);
        TextPositionInfo textPositionInfo3 = this.infoForPosition(n7 + 1, -1);
        if (textPositionInfo3 != null && textPositionInfo != null && textPositionInfo3._lineNumber == textPositionInfo._lineNumber) {
            if (this.currentParagraphFormat().wrapsUnderFirstCharacter()) {
                textPositionInfo2.setRedrawCurrentLineOnly(false);
            } else {
                textPositionInfo2.setRedrawCurrentLineOnly(true);
            }
        } else {
            textPositionInfo2.setRedrawCurrentLineOnly(false);
        }
        return textPositionInfo2;
    }

    TextPositionInfo removeCharAt(int n) {
        TextStyleRun textStyleRun = null;
        if (n <= this._startChar) {
            return null;
        }
        int n2 = --n - this._startChar;
        int n3 = this._runVector.count();
        int n4 = 0;
        while (n4 < n3) {
            textStyleRun = (TextStyleRun)this._runVector.elementAt(n4);
            if (textStyleRun.charCount() > n2) break;
            n2 -= textStyleRun.charCount();
            ++n4;
        }
        if ((n4 >= n3 || textStyleRun == null) && n2 == 0) {
            textStyleRun = (TextStyleRun)this._runVector.lastElement();
            n2 = textStyleRun.charCount() - 1;
        } else if (textStyleRun == null) {
            return null;
        }
        int n5 = this.lineForPosition(n - 1);
        int n6 = n5 == 0 ? this._startChar + 1 : this._lineBreaks[n5 - 1] + this._startChar + 1;
        int n7 = this._lineBreaks[n5] + this._startChar + 1;
        if (n7 > this._startChar + this._charCount) {
            n7 = this._startChar + this._charCount;
        }
        TextPositionInfo textPositionInfo = this.infoForPosition(n7, -1);
        TextPositionInfo textPositionInfo2 = this.infoForPosition(n6, -1);
        int n8 = this._height;
        textStyleRun.removeCharAt(n2);
        if (textStyleRun.charCount() == 0 && this._runVector.count() > 1) {
            this._runVector.removeElement((Object)textStyleRun);
        }
        this.computeLineBreaksAndHeights(this._owner.bounds.width);
        TextPositionInfo textPositionInfo3 = this.infoForPosition(n, -1);
        if (n8 == this._height) {
            textPositionInfo3.setRedrawCurrentParagraphOnly(true);
        }
        if (textPositionInfo3._lineNumber != textPositionInfo2._lineNumber) {
            if (textPositionInfo2._lineNumber < textPositionInfo3._lineNumber) {
                textPositionInfo3.setUpdateLine(textPositionInfo2._lineNumber);
            } else {
                textPositionInfo3.setUpdateLine(textPositionInfo3._lineNumber);
            }
            return textPositionInfo3;
        }
        TextPositionInfo textPositionInfo4 = this.infoForPosition(n7 - 1, -1);
        if (textPositionInfo._lineNumber != textPositionInfo4._lineNumber) {
            if (textPositionInfo._lineNumber < textPositionInfo4._lineNumber) {
                textPositionInfo3.setUpdateLine(textPositionInfo._lineNumber);
            } else {
                textPositionInfo3.setUpdateLine(textPositionInfo4._lineNumber);
            }
            return textPositionInfo3;
        }
        TextPositionInfo textPositionInfo5 = this.infoForPosition(n6, -1);
        if (n8 == this._height && textPositionInfo5 != null && textPositionInfo2 != null && textPositionInfo5._lineNumber == textPositionInfo2._lineNumber) {
            if (this.currentParagraphFormat().wrapsUnderFirstCharacter()) {
                textPositionInfo3.setRedrawCurrentLineOnly(false);
            } else {
                textPositionInfo3.setRedrawCurrentLineOnly(true);
            }
        }
        return textPositionInfo3;
    }

    TextStyleRun createNewRunAt(int n) {
        TextPositionInfo textPositionInfo = this.infoForPosition(n, -1);
        if (textPositionInfo == null) {
            return null;
        }
        int n2 = this._runVector.indexOfIdentical((Object)textPositionInfo._textRun);
        TextStyleRun textStyleRun = textPositionInfo._textRun.breakAt(textPositionInfo._positionInRun);
        this.insertRunAt(textStyleRun, n2 + 1);
        return textStyleRun;
    }

    TextParagraph createNewParagraphAt(int n) {
        int n2;
        TextStyleRun textStyleRun = null;
        TextParagraphFormat textParagraphFormat = this.currentParagraphFormat();
        this.collectEmptyRuns();
        TextStyleRun textStyleRun2 = this.runForCharPosition(n);
        int n3 = n - textStyleRun2.rangeIndex();
        TextParagraph textParagraph = new TextParagraph(this._owner, textParagraphFormat);
        if (n3 == 0) {
            n2 = this._runVector.indexOfIdentical((Object)textStyleRun2);
            Hashtable hashtable = TextView.attributesByRemovingStaticAttributes(textStyleRun2.attributes());
            if (n2 == 0) {
                textStyleRun = textStyleRun2.createEmptyRun(hashtable);
                this._runVector.insertElementAt((Object)textStyleRun, 0);
            } else {
                --n2;
            }
            textParagraph.addRun(new TextStyleRun(this, "", hashtable));
        } else if (textStyleRun2.containsATextAttachment()) {
            n2 = this._runVector.indexOfIdentical((Object)textStyleRun2);
            int n4 = n2 - 1;
            TextStyleRun textStyleRun3 = null;
            while (n4 > 0) {
                textStyleRun3 = (TextStyleRun)this.objectAt(this._runVector, n4);
                if (textStyleRun3 == null || !textStyleRun3.containsATextAttachment()) break;
                --n4;
            }
            if (textStyleRun3 == null) {
                textStyleRun = new TextStyleRun(this, "", null);
                textParagraph.addRun(textStyleRun);
            } else {
                textStyleRun = new TextStyleRun(this, "", TextView.attributesByRemovingStaticAttributes(textStyleRun3.attributes()));
                textParagraph.addRun(textStyleRun);
            }
        } else {
            TextStyleRun textStyleRun4;
            textStyleRun = textStyleRun4 = textStyleRun2.breakAt(n3);
            textParagraph.addRun(textStyleRun4);
            n2 = this._runVector.indexOfIdentical((Object)textStyleRun2);
        }
        if (n2 < 0) {
            return textParagraph;
        }
        ++n2;
        int n5 = this._runVector.count();
        int n6 = 0;
        while (n2 < n5) {
            textParagraph.addRun((TextStyleRun)this._runVector.elementAt(n2));
            ++n2;
            ++n6;
        }
        while (n6-- > 0) {
            this._runVector.removeLastElement();
        }
        return textParagraph;
    }

    void drawBackgroundForLine(Graphics graphics, int n, int n2, int n3) {
        Rect rect;
        Rect rect2;
        Rect rect3 = null;
        TextParagraphFormat textParagraphFormat = this.currentParagraphFormat();
        TextParagraphFormat textParagraphFormat2 = (TextParagraphFormat)this._owner.defaultAttributes().get((Object)"ParagraphFormatKey");
        int n4 = this._owner.bounds.width - textParagraphFormat._leftMargin - textParagraphFormat._rightMargin;
        int n5 = this._owner.bounds.width - textParagraphFormat2._leftMargin - textParagraphFormat2._rightMargin;
        if (n == 0) {
            n4 -= textParagraphFormat._leftIndent;
        }
        if (n < 0 || n >= this._breakCount || !this._owner.hasSelectionRange() && !this._owner.insertionPointVisible) {
            if (!this._owner.isTransparent()) {
                graphics.setColor(this._owner._backgroundColor);
                graphics.fillRect(textParagraphFormat2._leftMargin, n3, n5, this._lineHeights[n]);
            }
            return;
        }
        int n6 = this._owner.selectionStart();
        int n7 = this._owner.selectionEnd();
        TextPositionInfo textPositionInfo = this._owner.selectionStartInfo();
        TextPositionInfo textPositionInfo2 = this._owner.selectionEndInfo();
        int n8 = n == 0 ? this._startChar : this._startChar + this._lineBreaks[n - 1];
        int n9 = this._startChar + this._lineBreaks[n];
        if (n == this._breakCount - 1) {
            ++n9;
        }
        if (n6 == n7 || n6 > n9 || n7 < n8) {
            if (!this._owner.isTransparent()) {
                graphics.setColor(this._owner._backgroundColor);
                graphics.fillRect(textParagraphFormat2._leftMargin, n3, n5, this._lineHeights[n]);
            }
            return;
        }
        if (n8 >= n6 && n9 <= n7) {
            rect3 = TextView.newRect(textParagraphFormat2._leftMargin, n3, n5, this._lineHeights[n]);
            rect2 = null;
            rect = null;
        } else if (n8 >= n6 && n9 > n7 && n8 < n7) {
            rect3 = n6 == n8 ? TextView.newRect(n2, n3, textPositionInfo2._x - n2, this._lineHeights[n]) : TextView.newRect(textParagraphFormat2._leftMargin, n3, textPositionInfo2._x - textParagraphFormat2._leftMargin, this._lineHeights[n]);
            rect = TextView.newRect(rect3.maxX(), n3, n5 - rect3.width, this._lineHeights[n]);
            rect2 = null;
        } else if (n8 < n6 && n6 < n9 && n9 <= n7) {
            if (textPositionInfo._textRun._paragraph != this || textPositionInfo._lineNumber > n) {
                rect = TextView.newRect(textParagraphFormat2._leftMargin, n3, n5, this._lineHeights[n]);
            } else {
                rect3 = TextView.newRect(textPositionInfo._x, n3, this._owner.bounds.width - textParagraphFormat2._rightMargin - textPositionInfo._x, this._lineHeights[n]);
                rect = TextView.newRect(textParagraphFormat2._leftMargin, n3, rect3.x - textParagraphFormat2._leftMargin, this._lineHeights[n]);
            }
            rect2 = null;
        } else if (n8 < n6 && n9 > n7) {
            rect3 = TextView.newRect(textPositionInfo._x, n3, textPositionInfo2._x - textPositionInfo._x, this._lineHeights[n]);
            rect = TextView.newRect(rect3.maxX(), n3, n5 - rect3.width, this._lineHeights[n]);
            rect2 = TextView.newRect(textParagraphFormat2._leftMargin, n3, rect3.x - textParagraphFormat2._leftMargin, this._lineHeights[n]);
        } else {
            rect = TextView.newRect(textParagraphFormat2._leftMargin, n3, n5, this._lineHeights[n]);
            rect2 = null;
        }
        if (!this._owner.isTransparent()) {
            graphics.setColor(this._owner._backgroundColor);
            if (rect != null) {
                graphics.fillRect(rect);
                TextView.returnRect(rect);
            }
            if (rect2 != null) {
                graphics.fillRect(rect2);
                TextView.returnRect(rect2);
            }
        }
        if (this._owner.hasSelectionRange() && rect3 != null && this._owner.isSelectable()) {
            if (rect3.width == 0 && rect3.x == n2) {
                rect3.sizeTo(4, rect3.height);
            }
            if (!this._owner.isEditing()) {
                if (!this._owner.isTransparent()) {
                    graphics.setColor(this._owner._backgroundColor);
                    graphics.fillRect(rect3);
                }
            } else {
                graphics.setColor(this._owner._selectionColor);
                graphics.fillRect(rect3);
            }
            TextView.returnRect(rect3);
        }
    }

    void drawLine(Graphics graphics, int n) {
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        TextParagraphFormat textParagraphFormat = this.currentParagraphFormat();
        if (n >= this._breakCount) {
            return;
        }
        int n5 = this._owner.bounds.width - textParagraphFormat._leftMargin - textParagraphFormat._rightMargin;
        int n6 = this._y;
        if (!this._owner.isTransparent()) {
            graphics.setColor(this._owner._backgroundColor);
            graphics.fillRect(0, n6, textParagraphFormat._leftMargin, this._height);
            graphics.fillRect(this._owner.bounds.width - textParagraphFormat._rightMargin, n6, textParagraphFormat._rightMargin + 1, this._height);
        }
        TextStyleRun textStyleRun = (TextStyleRun)this._runVector.firstElement();
        int n7 = 0;
        int n8 = 0;
        while (n8 <= n) {
            int n9 = textParagraphFormat._justification == 0 ? textParagraphFormat._leftMargin : (textParagraphFormat._justification == 2 ? textParagraphFormat._leftMargin + this._lineRemainders[n8] : textParagraphFormat._leftMargin + this._lineRemainders[n8] / 2);
            int n10 = n5;
            if (n8 == 0) {
                n9 += textParagraphFormat._leftIndent;
                n10 -= textParagraphFormat._leftIndent;
            } else if (textParagraphFormat.wrapsUnderFirstCharacter()) {
                int n11 = this.addWidthOfInitialTabs(n9 + textParagraphFormat._leftIndent);
                n10 -= n11 - n9;
                n9 = n11;
            }
            n2 = n8 == 0 ? this._lineBreaks[n8] : this._lineBreaks[n8] - this._lineBreaks[n8 - 1];
            if (n8 == n) {
                this.drawBackgroundForLine(graphics, n8, n9, n6);
            }
            while (n2 > 0) {
                int n12 = textStyleRun.charCount() - n7;
                if (n2 >= n12) {
                    if (n8 == n) {
                        n4 = textStyleRun.drawCharacters(graphics, n7, n12, n9, n6 + this._baselines[n8], textParagraphFormat._tabStops);
                    }
                    n2 -= n12;
                    textStyleRun = (TextStyleRun)this.objectAt(this._runVector, n3++);
                    while (textStyleRun != null && textStyleRun.charCount() == 0) {
                        textStyleRun = (TextStyleRun)this.objectAt(this._runVector, n3++);
                    }
                    n7 = 0;
                } else {
                    if (n8 == n) {
                        n4 = textStyleRun.drawCharacters(graphics, n7, n2, n9, n6 + this._baselines[n8], textParagraphFormat._tabStops);
                    }
                    n7 += n2;
                    n2 = 0;
                }
                n9 += n4;
                n10 -= n4;
            }
            n6 += this._lineHeights[n8];
            ++n8;
        }
    }

    void drawView(Graphics graphics, Rect rect) {
        int n = 0;
        int n2 = 1;
        TextParagraphFormat textParagraphFormat = this.currentParagraphFormat();
        TextParagraphFormat textParagraphFormat2 = (TextParagraphFormat)this._owner.defaultAttributes().get((Object)"ParagraphFormatKey");
        int n3 = this._owner.bounds.width - textParagraphFormat._leftMargin - textParagraphFormat._rightMargin;
        int n4 = this._y;
        if (!this._owner.isTransparent()) {
            graphics.setColor(this._owner._backgroundColor);
            graphics.fillRect(rect.maxX() - textParagraphFormat2._rightMargin, n4, textParagraphFormat2._rightMargin + 1, this._height);
        }
        TextStyleRun textStyleRun = (TextStyleRun)this._runVector.firstElement();
        int n5 = 0;
        Rect rect2 = TextView.newRect();
        Rect rect3 = graphics.clipRect();
        int n6 = 0;
        while (n6 < this._breakCount) {
            int n7 = textParagraphFormat._justification == 0 ? rect.x + textParagraphFormat._leftMargin : (textParagraphFormat._justification == 2 ? rect.x + textParagraphFormat._leftMargin + this._lineRemainders[n6] : rect.x + textParagraphFormat._leftMargin + this._lineRemainders[n6] / 2);
            int n8 = n3;
            if (n6 == 0) {
                n7 += textParagraphFormat._leftIndent;
                n8 -= textParagraphFormat._leftIndent;
            } else if (textParagraphFormat.wrapsUnderFirstCharacter()) {
                int n9 = this.addWidthOfInitialTabs(n7 + textParagraphFormat._leftIndent);
                n8 -= n9 - n7;
                n7 = n9;
            }
            n = n6 == 0 ? this._lineBreaks[n6] : this._lineBreaks[n6] - this._lineBreaks[n6 - 1];
            rect2.setBounds(0, n4, this._owner.bounds.width, this._lineHeights[n6]);
            boolean bl = rect3.intersects(rect2);
            if (!this._owner.isTransparent()) {
                graphics.setColor(this._owner.backgroundColor());
                graphics.fillRect(rect.x, n4, n7 - rect.x, this._lineHeights[n6]);
            }
            if (bl) {
                this.drawBackgroundForLine(graphics, n6, n7, n4);
            }
            while (n > 0) {
                int n10;
                int n11 = textStyleRun.charCount() - n5;
                if (n >= n11) {
                    n10 = bl ? textStyleRun.drawCharacters(graphics, n5, n11, n7, n4 + this._baselines[n6], textParagraphFormat._tabStops) : 0;
                    n -= n11;
                    textStyleRun = (TextStyleRun)this.objectAt(this._runVector, n2++);
                    while (textStyleRun != null && textStyleRun.charCount() == 0) {
                        textStyleRun = (TextStyleRun)this.objectAt(this._runVector, n2++);
                    }
                    n5 = 0;
                } else {
                    n10 = bl ? textStyleRun.drawCharacters(graphics, n5, n, n7, n4 + this._baselines[n6], textParagraphFormat._tabStops) : 0;
                    n5 += n;
                    n = 0;
                }
                n7 += n10;
                n8 -= n10;
            }
            n4 += this._lineHeights[n6];
            ++n6;
        }
        TextView.returnRect(rect2);
    }

    void draw() {
        if (this._owner != null) {
            Rect rect = TextView.newRect(0, this._y, this._owner.bounds.width, this._height);
            this._owner.draw(rect);
            TextView.returnRect(rect);
        }
    }

    void subsumeParagraph(TextParagraph textParagraph) {
        if (textParagraph == null) {
            return;
        }
        int n = textParagraph._runVector.count();
        int n2 = 0;
        while (n2 < n) {
            TextStyleRun textStyleRun = (TextStyleRun)textParagraph._runVector.elementAt(n2);
            if (textStyleRun.charCount() > 0 || this._runVector.isEmpty() && n2 + 1 == n) {
                this.addRun(textStyleRun);
            }
            ++n2;
        }
    }

    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer();
        fastStringBuffer.append("[");
        int n = this._runVector.count();
        int n2 = 0;
        while (n2 < n) {
            TextStyleRun textStyleRun = (TextStyleRun)this._runVector.elementAt(n2);
            fastStringBuffer.append(textStyleRun.toString());
            ++n2;
        }
        fastStringBuffer.append("]\n");
        return fastStringBuffer.toString();
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.TextParagraph", 1);
        classInfo.addField(FORMAT_KEY, (byte)18);
        classInfo.addField(RUNVECTOR_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject(FORMAT_KEY, this._format);
        encoder.encodeObject(RUNVECTOR_KEY, this._runVector);
    }

    public void decode(Decoder decoder) throws CodingException {
        this._format = (TextParagraphFormat)decoder.decodeObject(FORMAT_KEY);
        this._runVector = (Vector)decoder.decodeObject(RUNVECTOR_KEY);
        int n = this._runVector.count();
        while (n-- > 0) {
            TextStyleRun textStyleRun = (TextStyleRun)this._runVector.elementAt(n);
            textStyleRun.setParagraph(this);
        }
    }

    public void finishDecoding() throws CodingException {
    }

    String stringForRange(Range range) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this._startChar;
        Range range2 = TextView.allocateRange();
        int n2 = 0;
        int n3 = this._runVector.count();
        while (n2 < n3) {
            TextStyleRun textStyleRun = (TextStyleRun)this._runVector.elementAt(n2);
            range2.index = n;
            range2.length = textStyleRun.charCount();
            range2.intersectWith(range);
            if (range2.index != Range.nullRange().index) {
                String string = textStyleRun.text().substring(range2.index - n, range2.index - n + range2.length);
                stringBuffer.append(string);
            }
            n += textStyleRun.charCount();
            ++n2;
        }
        if (range.index + range.length - 1 == this._startChar + this._charCount - 1) {
            stringBuffer.append("\n");
        }
        TextView.recycleRange(range2);
        return stringBuffer.toString();
    }

    Range range() {
        return TextView.allocateRange(this._startChar, this._charCount);
    }

    int lineCount() {
        return this._breakCount;
    }
}

