/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class Point
implements Codable {
    public int x;
    public int y;
    private static Vector _pointCache = new Vector();
    private static boolean _cachePoints = true;
    static final String X_KEY = "x";
    static final String Y_KEY = "y";

    public Point() {
    }

    public Point(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public Point(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }

    public void moveTo(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void moveBy(int n, int n2) {
        this.x += n;
        this.y += n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Point)) {
            return false;
        }
        Point point = (Point)object;
        return point.x == this.x && point.y == this.y;
    }

    public int hashCode() {
        return this.x ^ this.y;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.Point", 1);
        classInfo.addField(X_KEY, (byte)8);
        classInfo.addField(Y_KEY, (byte)8);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeInt(X_KEY, this.x);
        encoder.encodeInt(Y_KEY, this.y);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.x = decoder.decodeInt(X_KEY);
        this.y = decoder.decodeInt(Y_KEY);
    }

    public void finishDecoding() throws CodingException {
    }

    static Point newPoint(int n, int n2) {
        Point point;
        Vector vector = _pointCache;
        synchronized (vector) {
            if (!_cachePoints || _pointCache.isEmpty()) {
                Point point2 = new Point(n, n2);
                Object var5_4 = null;
                return point2;
            }
            point = (Point)_pointCache.removeLastElement();
        }
        point.moveTo(n, n2);
        return point;
    }

    static Point newPoint(Point point) {
        if (point == null) {
            return Point.newPoint(0, 0);
        }
        return Point.newPoint(point.x, point.y);
    }

    static Point newPoint() {
        return Point.newPoint(0, 0);
    }

    static void returnPoint(Point point) {
        if (!_cachePoints) {
            return;
        }
        Vector vector = _pointCache;
        synchronized (vector) {
            if (_pointCache.count() < 30) {
                _pointCache.addElement((Object)point);
            }
            return;
        }
    }

    static void returnPoints(Vector vector) {
        if (vector == null || !_cachePoints) {
            return;
        }
        int n = vector.count();
        while (n-- > 0) {
            Point.returnPoint((Point)vector.elementAt(n));
        }
        vector.removeAllElements();
    }

    static void setShouldCachePoints(boolean bl) {
        Vector vector = _pointCache;
        synchronized (vector) {
            _cachePoints = bl;
            if (!_cachePoints) {
                _pointCache.removeAllElements();
            }
            return;
        }
    }
}

