/* strbegcmp.c
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,96  Lele Gaifax
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "tua.h"

/*
 * int strbegcmp (const char * s1, const char * s2)
 *
 * Returns non zero if the strings are different. Otherwise returns 0 if
 * they are equal or one is a prefix substring of the other
 */
int
DEFUN (strbegcmp, (s1, s2),
       CONST char * s1 AND CONST char * s2)
{
  while (*s1 && *s2)
    if (*s1 != *s2)
      return *s1 - *s2;
    else
      s1++, s2++;
  return 0;
}

