#ifndef BASKER_SFACTOR_KOKKOS_HPP
#define BASKER_SFACTOR_KOKKOS_HPP

#include "basker_decl.hpp"
#include "basker_matrix_decl.hpp"
#include "basker_types.hpp"

#include <Kokkos_Core.hpp>
#include "basker_kokkos.hpp"

namespace Basker
{
  template <class Int, class Entry, class Exe_Space>
  struct workspace_init_funct
  {
    //Kokkos Typedefs

    //Basker Typedefs
    //Matrix data structures
    typedef  BaskerMatrix<Int, Entry, Exe_Space>                  MATRIX;
    typedef  BaskerMatrixView<Int, Entry, Exe_Space>              MATRIX_VIEW;
    typedef  basker_2Darray<Int, MATRIX_VIEW, Exe_Space>          MATRIX_VIEW_ARRAY;
    typedef  basker_2Darray<Int, MATRIX, Exe_Space>               MATRIX_ARRAY;

    //Arrays
    typedef  basker_2Darray<Int, Int,   Exe_Space>                INT_2DARRAY;
    typedef  basker_2Darray<Int, Entry, Exe_Space>                ENTRY_2DARRAY;
    typedef  basker_1Darray<Int, Int,   Exe_Space>                INT_1DARRAY;
    typedef  basker_1Darray<Int, Entry, Exe_Space>                ENTRY_1DARRAY;
   
    //Tree
    typedef  basker_tree<Int, Entry, Exe_Space>                   TREE;

    
    INT_2DARRAY   ws;
    ENTRY_2DARRAY X;
    TREE          tree;
    INT_2DARRAY   S;
    Int           lvl;

    KOKKOS_INLINE_FUNCTION
    workspace_init_funct()
    {}

    KOKKOS_INLINE_FUNCTION
    workspace_init_funct(INT_2DARRAY  _ws,   ENTRY_2DARRAY  _X, 
			 TREE _tree, INT_2DARRAY _S,  Int _lvl)
    {
      ws = _ws;
      X  = _X;
      tree = _tree;
      S = _S;
      lvl  = _lvl;
    }// workspace_init_funct()

    KOKKOS_INLINE_FUNCTION
    void operator()(const int i) const
    {
      printf("Kokkos: workspace: %d lvl: %d \n", i, lvl);
    } // operator()
   
  };

}//end Basker namespace


#endif //end ifndef
