% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{\%s<\%}
\alias{\%s<\%}
\alias{\%s<=\%}
\alias{\%s>\%}
\alias{\%s>=\%}
\alias{\%s==\%}
\alias{\%s!=\%}
\alias{\%s===\%}
\alias{\%s!==\%}
\alias{\%stri<\%}
\alias{\%stri<=\%}
\alias{\%stri>\%}
\alias{\%stri>=\%}
\alias{\%stri==\%}
\alias{\%stri!=\%}
\alias{\%stri===\%}
\alias{\%stri!==\%}
\title{Compare Strings with or without Collation}
\usage{
e1 \%s<\% e2

e1 \%s<=\% e2

e1 \%s>\% e2

e1 \%s>=\% e2

e1 \%s==\% e2

e1 \%s!=\% e2

e1 \%s===\% e2

e1 \%s!==\% e2

e1 \%stri<\% e2

e1 \%stri<=\% e2

e1 \%stri>\% e2

e1 \%stri>=\% e2

e1 \%stri==\% e2

e1 \%stri!=\% e2

e1 \%stri===\% e2

e1 \%stri!==\% e2
}
\arguments{
\item{e1, e2}{character vectors or objects coercible to character vectors}
}
\value{
All the functions return a logical vector
indicating the result of a pairwise comparison.
As usual, the elements of shorter vectors are recycled if necessary.
}
\description{
Relational operators for comparing corresponding strings in
two character vectors, with a typical \R look-and-feel.
}
\details{
These functions call \code{\link{stri_cmp_le}} or its
friends, using default collator options.
Thus, they are vectorized over \code{e1} and \code{e2}.

\code{\%stri==\%} tests for canonical equivalence of strings
(see \code{\link{stri_cmp_equiv}}) and is a locale-dependent operation.
On the other hand, \code{\%stri===\%} performs a locale-independent,
code point-based comparison.
}
\examples{
"a" \%stri<\% "b"
c("a", "b", "c") \%stri>=\% "b"

}
\seealso{
Other locale_sensitive: \code{\link{stri_compare}},
  \code{\link{stri_count_boundaries}},
  \code{\link{stri_duplicated}},
  \code{\link{stri_enc_detect2}},
  \code{\link{stri_extract_all_boundaries}},
  \code{\link{stri_locate_all_boundaries}},
  \code{\link{stri_opts_collator}},
  \code{\link{stri_order}},
  \code{\link{stri_split_boundaries}},
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_unique}}, \code{\link{stri_wrap}},
  \code{\link{stringi-locale}},
  \code{\link{stringi-search-boundaries}},
  \code{\link{stringi-search-coll}}
}
