/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.StoringInvocationUnit;

public class ConstantParameterFilter
extends SimplifiedVisitor
implements MemberVisitor {
    private final MemberVisitor constantParameterVisitor;

    public ConstantParameterFilter(MemberVisitor memberVisitor) {
        this.constantParameterVisitor = memberVisitor;
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        int n = (programMethod.getAccessFlags() & 8) != 0 ? 0 : 1;
        int n2 = ClassUtil.internalMethodParameterCount(programMethod.getDescriptor(programClass));
        for (int i = n; i < n2; ++i) {
            Value value = StoringInvocationUnit.getMethodParameterValue(programMethod, i);
            if (value == null || !value.isParticular()) continue;
            this.constantParameterVisitor.visitProgramMethod(programClass, programMethod);
        }
    }
}

