#ifndef _MEMWATCH_H
#define _MEMWATCH_H

#include <stdarg.h>

/* This file was contributed by Peter Selinger and is copyrighted
   under the GNU General Public License. */

char *memwatch_strdup(const char *s, char *file, int line);
void *memwatch_realloc(void *p, size_t size, char *file, int line);
void memwatch_free(void *p, char *file, int line);
void *memwatch_malloc(size_t size, char *file, int line);
int memwatch_vasprintf(char **strp, const char *fmt, va_list ap, char *file, int line);
void memwatch_cleartags();
void memwatch_tag(void *p, int tag);
void memwatch_dump();

#ifdef malloc
#undef malloc
#endif

#define malloc(size) memwatch_malloc(size, __FILE__, __LINE__)
  
#ifdef free
#undef free
#endif

#define free(p) memwatch_free(p, __FILE__, __LINE__)
  
#ifdef realloc
#undef realloc
#endif

#define realloc(p, size) memwatch_realloc(p, size, __FILE__, __LINE__)
  
#ifdef strdup
#undef strdup
#endif

#define strdup(s) memwatch_strdup(s, __FILE__, __LINE__)

#ifdef vasprintf
#undef vasprintf
#endif

#define vasprintf(pp, fmt, ap) memwatch_vasprintf(pp, fmt, ap, __FILE__, __LINE__)

#endif /* _MEMWATCH_H */
