#include "sw-contact-view-ginterface.h"

#include "sw-marshals.h"

static const DBusGObjectInfo _sw_contact_view_iface_object_info;

struct _SwContactViewIfaceClass {
    GTypeInterface parent_class;
    sw_contact_view_iface_start_impl start;
    sw_contact_view_iface_refresh_impl refresh;
    sw_contact_view_iface_stop_impl stop;
    sw_contact_view_iface_close_impl close;
};

enum {
    SIGNAL_CONTACT_VIEW_IFACE_ContactsAdded,
    SIGNAL_CONTACT_VIEW_IFACE_ContactsRemoved,
    SIGNAL_CONTACT_VIEW_IFACE_ContactsChanged,
    N_CONTACT_VIEW_IFACE_SIGNALS
};
static guint contact_view_iface_signals[N_CONTACT_VIEW_IFACE_SIGNALS] = {0};

static void sw_contact_view_iface_base_init (gpointer klass);

GType
sw_contact_view_iface_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (SwContactViewIfaceClass),
        sw_contact_view_iface_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "SwContactViewIface", &info, 0);
    }

  return type;
}

/**
 * sw_contact_view_iface_start_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Start on interface com.meego.libsocialweb.ContactView.
 */
static void
sw_contact_view_iface_start (SwContactViewIface *self,
    DBusGMethodInvocation *context)
{
  sw_contact_view_iface_start_impl impl = (SW_CONTACT_VIEW_IFACE_GET_CLASS (self)->start);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_contact_view_iface_implement_start:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Start D-Bus method
 *
 * Register an implementation for the Start method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_contact_view_iface_implement_start (SwContactViewIfaceClass *klass, sw_contact_view_iface_start_impl impl)
{
  klass->start = impl;
}

/**
 * sw_contact_view_iface_refresh_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Refresh on interface com.meego.libsocialweb.ContactView.
 */
static void
sw_contact_view_iface_refresh (SwContactViewIface *self,
    DBusGMethodInvocation *context)
{
  sw_contact_view_iface_refresh_impl impl = (SW_CONTACT_VIEW_IFACE_GET_CLASS (self)->refresh);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_contact_view_iface_implement_refresh:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Refresh D-Bus method
 *
 * Register an implementation for the Refresh method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_contact_view_iface_implement_refresh (SwContactViewIfaceClass *klass, sw_contact_view_iface_refresh_impl impl)
{
  klass->refresh = impl;
}

/**
 * sw_contact_view_iface_stop_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Stop on interface com.meego.libsocialweb.ContactView.
 */
static void
sw_contact_view_iface_stop (SwContactViewIface *self,
    DBusGMethodInvocation *context)
{
  sw_contact_view_iface_stop_impl impl = (SW_CONTACT_VIEW_IFACE_GET_CLASS (self)->stop);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_contact_view_iface_implement_stop:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Stop D-Bus method
 *
 * Register an implementation for the Stop method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_contact_view_iface_implement_stop (SwContactViewIfaceClass *klass, sw_contact_view_iface_stop_impl impl)
{
  klass->stop = impl;
}

/**
 * sw_contact_view_iface_close_impl:
 * @self: The object implementing this interface
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * Close on interface com.meego.libsocialweb.ContactView.
 */
static void
sw_contact_view_iface_close (SwContactViewIface *self,
    DBusGMethodInvocation *context)
{
  sw_contact_view_iface_close_impl impl = (SW_CONTACT_VIEW_IFACE_GET_CLASS (self)->close);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_contact_view_iface_implement_close:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the Close D-Bus method
 *
 * Register an implementation for the Close method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_contact_view_iface_implement_close (SwContactViewIfaceClass *klass, sw_contact_view_iface_close_impl impl)
{
  klass->close = impl;
}

/**
 * sw_contact_view_iface_emit_contacts_added:
 * @instance: The object implementing this interface
 * @arg_contacts: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ContactsAdded signal on interface com.meego.libsocialweb.ContactView.
 */
void
sw_contact_view_iface_emit_contacts_added (gpointer instance,
    const GPtrArray *arg_contacts)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, SW_TYPE_CONTACT_VIEW_IFACE));
  g_signal_emit (instance,
      contact_view_iface_signals[SIGNAL_CONTACT_VIEW_IFACE_ContactsAdded],
      0,
      arg_contacts);
}

/**
 * sw_contact_view_iface_emit_contacts_removed:
 * @instance: The object implementing this interface
 * @arg_contacts: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ContactsRemoved signal on interface com.meego.libsocialweb.ContactView.
 */
void
sw_contact_view_iface_emit_contacts_removed (gpointer instance,
    const GPtrArray *arg_contacts)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, SW_TYPE_CONTACT_VIEW_IFACE));
  g_signal_emit (instance,
      contact_view_iface_signals[SIGNAL_CONTACT_VIEW_IFACE_ContactsRemoved],
      0,
      arg_contacts);
}

/**
 * sw_contact_view_iface_emit_contacts_changed:
 * @instance: The object implementing this interface
 * @arg_contacts: const GPtrArray * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * ContactsChanged signal on interface com.meego.libsocialweb.ContactView.
 */
void
sw_contact_view_iface_emit_contacts_changed (gpointer instance,
    const GPtrArray *arg_contacts)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, SW_TYPE_CONTACT_VIEW_IFACE));
  g_signal_emit (instance,
      contact_view_iface_signals[SIGNAL_CONTACT_VIEW_IFACE_ContactsChanged],
      0,
      arg_contacts);
}

static inline void
sw_contact_view_iface_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (sw_contact_view_iface_get_type (),
      &_sw_contact_view_iface_object_info);

  /**
   * SwContactViewIface::contacts-added:
   * @arg_contacts: const GPtrArray * (FIXME, generate documentation)
   *
   * The ContactsAdded D-Bus signal is emitted whenever this GObject signal is.
   */
  contact_view_iface_signals[SIGNAL_CONTACT_VIEW_IFACE_ContactsAdded] =
  g_signal_new ("contacts-added",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT64, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_STRV)), G_TYPE_INVALID)))));

  /**
   * SwContactViewIface::contacts-removed:
   * @arg_contacts: const GPtrArray * (FIXME, generate documentation)
   *
   * The ContactsRemoved D-Bus signal is emitted whenever this GObject signal is.
   */
  contact_view_iface_signals[SIGNAL_CONTACT_VIEW_IFACE_ContactsRemoved] =
  g_signal_new ("contacts-removed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INVALID)))));

  /**
   * SwContactViewIface::contacts-changed:
   * @arg_contacts: const GPtrArray * (FIXME, generate documentation)
   *
   * The ContactsChanged D-Bus signal is emitted whenever this GObject signal is.
   */
  contact_view_iface_signals[SIGNAL_CONTACT_VIEW_IFACE_ContactsChanged] =
  g_signal_new ("contacts-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOXED,
      G_TYPE_NONE,
      1,
      (dbus_g_type_get_collection ("GPtrArray", (dbus_g_type_get_struct ("GValueArray", G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT64, (dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_STRV)), G_TYPE_INVALID)))));

}
static void
sw_contact_view_iface_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      sw_contact_view_iface_base_init_once (klass);
    }
}
static const DBusGMethodInfo _sw_contact_view_iface_methods[] = {
  { (GCallback) sw_contact_view_iface_start, g_cclosure_marshal_VOID__POINTER, 0 },
  { (GCallback) sw_contact_view_iface_refresh, g_cclosure_marshal_VOID__POINTER, 44 },
  { (GCallback) sw_contact_view_iface_stop, g_cclosure_marshal_VOID__POINTER, 90 },
  { (GCallback) sw_contact_view_iface_close, g_cclosure_marshal_VOID__POINTER, 133 },
};

static const DBusGObjectInfo _sw_contact_view_iface_object_info = {
  0,
  _sw_contact_view_iface_methods,
  4,
"com.meego.libsocialweb.ContactView\0Start\0A\0\0com.meego.libsocialweb.ContactView\0Refresh\0A\0\0com.meego.libsocialweb.ContactView\0Stop\0A\0\0com.meego.libsocialweb.ContactView\0Close\0A\0\0\0",
"com.meego.libsocialweb.ContactView\0ContactsAdded\0com.meego.libsocialweb.ContactView\0ContactsRemoved\0com.meego.libsocialweb.ContactView\0ContactsChanged\0\0",
"\0\0",
};


