------------------------------------------------------------------------------
--                                                                          --
--                	        G N A T . RAVENSCAR                         --
--                                                                          --
--                      Copyright (C) 2008-2015, AdaCore                    --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO; -- language standard not embedded on ERC32
--  with System.IO; --  GNAT specific emdebbed on ERC32
--  with Ada.Float_Text_IO;

package body GNAT.Ravenscar.Report is

   --  DEBUG : Boolean := True;
   DEBUG : Boolean := False;

   protected body Reporter is

      procedure Print (Message : String; For_Debug : Boolean := False) is
         use Ada.Text_IO;
         --  use Ada.Float_Text_IO;
         --  use System.IO;
         use Ada.Real_Time;
         --  Elapsed : Time_Span;
      begin
         if not For_Debug or (For_Debug and DEBUG) then
            --  Elapsed := Clock - SST;
            Put_Line (Message);
         end if;
      end Print;

      procedure Init (System_Start_Time : Ada.Real_Time.Time) is
      begin
         Open (Log, Append_File, "log.txt");
         Set_Output (Log);
         SST := System_Start_Time;
      end Init;

   end Reporter;

   procedure Print (Message : String; For_Debug : Boolean := False) is
   begin
      Reporter.Print (Message, For_Debug);
   end Print;

   procedure Init (System_Start_Time : Ada.Real_Time.Time) is
   begin
      Reporter.Init (System_Start_Time);
   end Init;

end GNAT.Ravenscar.Report;
