/*
 * $Id: g321x.c,v 1.1.1.1 1995/10/24 10:19:37 cernlib Exp $
 *
 * $Log: g321x.c,v $
 * Revision 1.1.1.1  1995/10/24 10:19:37  cernlib
 * Geant
 *
 */
/*CMZ :          24/08/95  15.30.04  by  S.Ravndal*/
#if !defined(CERNLIB_KUIP95A)
 
/*-- Author :*/
/*
 * This file has been generated by the KUIP compiler.  Do NOT change it!
 *
 * KUIP header: 950303      Generation date: Thu Aug 24 15:18:48 1995
 *
 * Input file: geant321x.doc
 */
 
#if !defined(F77_LCASE) && !defined(F77_UCASE) && !defined(F77_USCORE)
#  if defined(__EXTENDED__) && !defined(IBM370) && !defined(_IBMR2)
#    define IBM370
#  endif
#  if defined(CRAY) || defined(IBM370) || defined(vms)
#    define F77_UCASE
#  else
#    if ( defined(apollo) || defined(__apollo) ) && defined(APOFTN)
#      define F77_LCASE
#    else
#      define F77_USCORE
#    endif
#  endif
#endif
 
typedef int     IntFunc();
typedef char*   CharFunc();
typedef char** pCharFunc();
typedef void    SUBROUTINE();
#ifdef IBM370
#  pragma linkage(SUBROUTINE,FORTRAN)
#endif
 
extern void klnkmenu();
extern void klnkbrcl();
extern void klnkkmcl();
extern void klnkicon();
extern void klnkbutt();
 
typedef unsigned long KmPixmap; /* Pixmap from <X11/X.h>                   */
 typedef void *KmWidget;         /* Widget from <X11/Intrinsic.h>           */
 typedef void *KmCalldata;       /* XmAnyCallbackStruct from <Motif/Xm.h>   */
                                 /*                                         */
 typedef enum {                  /*                                         */
   BRACT_OPEN = 0,               /*                                         */
   BRACT_ROOT = 1,               /*                                         */
   BRACT_CONT = 2,               /*                                         */
   BRACT_GRAF = 3                /*                                         */
 } BrActTag;                     /*                                         */
                                 /*                                         */
 typedef enum {                  /*                                         */
   BrActUpdate    = 0x01,        /* browser window has to be updated ('!')  */
   BrActSeparator = 0x02,        /* put separator in menu ('/')             */
   BrActToggle    = 0x04,        /* register as toggle button               */
   BrActToggleOn  = 0x08,        /* toggle state is on                      */
   BrActSensitive = 0x10         /* button is sensitive                     */
 } BrActFlag;                    /*                                         */
                                 /*                                         */
 
typedef struct _BrAction {      /*                                         */
  struct _BrAction *next;       /* link to next action binding             */
  BrActFlag   flags;            /*                                         */
  char       *text;             /* text line in menu                       */
  char       *user_text;        /* user text overriding CDF text (malloced)*/
  char       *accel;            /* accelerator                             */
  char       *exec;             /* action commands                         */
  SUBROUTINE *call_F;           /* action routine                          */
  IntFunc    *call_C;           /* action function                         */
  BrActTag    tag;              /* for which window the action is defined  */
  struct _BrClass *class;       /* pointer to BrClass in case of open menu */
 } BrAction;                     /*                                         */
                                 /*                                         */
 typedef struct _BrClass {       /*                                         */
   struct _BrClass *next;        /* link to next browsable class            */
   char       *name;             /* unique identifier name                  */
   char       *title;            /* title for popup menu (maybe NULL)       */
   SUBROUTINE *scan_km_F;        /* user function scanning the directory    */
   pCharFunc  *scan_km_C;        /* user function scanning the directory    */
   SUBROUTINE *scan_br_F;        /* user function scanning for browsables   */
   pCharFunc  *scan_br_C;        /* user function scanning for browsables   */
   BrAction   *root;             /* list of actions in root window          */
   BrAction   *open;             /* list of actions in open menu            */
 } BrClass;                      /*                                         */
                                 /*                                         */
 
typedef struct _KmIcon {        /*                                         */
  struct _KmIcon *next;         /* link to next icon                       */
  char       *name;             /* unique identifier name                  */
  int         width;            /* width of the pixmap                     */
  int         height;           /* height of the pixmap                    */
  char       *bitmap;           /* bitmap data                             */
  KmPixmap    pix;              /* filled in Motif part                    */
  KmPixmap    hi_pix;           /* high lighted pixmap                     */
 } KmIcon;                       /*                                         */
                                 /*                                         */
 typedef struct _KmClass {       /*                                         */
   struct _KmClass *next;        /* link to next object class               */
   int         is_dir;           /* flag if class has is a directory        */
   char       *name;             /* unique identifier name                  */
   char       *title;            /* title for popup menu (maybe NULL)       */
   char       *big_icon;         /* name of the big icon                    */
   KmIcon     *bicon;            /* pointer to the big icon structure       */
   char       *sm_icon;          /* name of the small icon                  */
   KmIcon     *sicon;            /* pointer to the small icon structure     */
   SUBROUTINE *user_icon_F;      /* user function to return icon bitmap     */
   IntFunc    *user_icon_C;      /* user function to return icon bitmap     */
   BrAction   *cont;             /* list of actions in content window       */
   BrAction   *graf;             /* list of actions in graphics window      */
   int         obj_count;        /* number of objects in content window     */
 } KmClass;                      /*                                         */
                                 /*                                         */
 
typedef enum {                  /*                                         */
  KmButtSensitive       = 0x00, /* sensitive button                        */
  KmButtNonSensitive    = 0x01, /* non-sensitive button ('NS')             */
  KmButtToggleSensitive = 0x02, /* toggle-sensitive button ('TS')          */
  KmButtSensitivityMask = 0x03, /* mask for sensitivity type               */
  KmButtSeparator       = 0x04, /* put separator in menu ('/')             */
  KmButtBrowser         = 0x08  /* button is in main browser ('BR')        */
 } KmButtFlag;                   /*                                         */
                                 /*                                         */
 typedef struct _KmButton {      /*                                         */
   struct _KmButton *next;       /* button label or menu item               */
   char       *menu;             /* menu name or NULL for buttons           */
   char       *label;            /* button label or menu item               */
   SUBROUTINE *call_F;           /* callback routine (FORTRAN)              */
   IntFunc    *call_C;           /* callback routine (C)                    */
   char       *action;           /* name of callback routine                */
   char       *mnemo;            /* button mnemonic                         */
   char       *accel;            /* button accelerator                      */
   char       *accel_text;       /* button accelerator text                 */
   KmButtFlag  flags;            /* sensitivity type etc.                   */
   KmWidget    widget;           /* Motif widget ID                         */
 } KmButton;                     /*                                         */
                                 /*                                         */
 
extern struct {                        /*
    */   /* indirect calls to avoid linking HIGZ
    */   IntFunc    *graf_info_C;      /* pass display, open and close
 (ixmotif)  */   SUBROUTINE *graf_size_F;      /* resize window (IGRSIZ)
            */   SUBROUTINE *graf_pick_F;      /* identifying graphics objects
 (IGOBJ)    */   SUBROUTINE *graf_attr_F;      /* set attributes (IGSET)
            */   SUBROUTINE *graf_close_F;     /* close workstation (ICLWK)
            */   /* optional routines for Motif customization
            */   pCharFunc  *user_FallBk_C;    /* get application fallbacks
            */   IntFunc    *user_TopWid_C;    /* pass toplevel widget
 identifiers        */ } klnkaddr;                     /*
                    */
 
typedef enum {                  /*                                         */
  KmFLAG_FORGET = 0x01,         /* last value is not kept for Motif panels */
  KmFLAG_MINUS  = 0x02,         /* -VALUE is not an abbrev for CHOPT=VALUE */
  KmFLAG_QUOTE  = 0x04,         /* do not remove quotes                    */
  KmFLAG_VARARG = 0x08,         /* append additional args to this param.   */
  KmFLAG_CONST  = 0x10,         /* do not allow to assign a value          */
  KmFLAG_HIDDEN = 0x20,         /* do not show in menus                    */
  KmFLAG_SEPARATE = 0x40        /* treat arguments as separate tokens      */
 } KmParFlag;                    /*                                         */
                                 /*                                         */
 typedef enum {                  /*                                         */
   KmTYPE_CHAR   = 'C',          /* character string                        */
   KmTYPE_FILE   = 'F',          /* file name                               */
   KmTYPE_INT    = 'I',          /* integer                                 */
   KmTYPE_OPTION = 'O',          /* option                                  */
   KmTYPE_REAL   = 'R'           /* real                                    */
 } KmParType;                    /*                                         */
                                 /*                                         */
 
typedef struct {                /* file name                               */
  char         *filter_default; /* filter wildcard                         */
  char         *filter_current; /* current filter                          */
 } KmParFile;                    /*                                         */
                                 /*                                         */
 typedef struct {                /*                                         */
   char         *range_lower;    /* lower value of range                    */
   char         *range_upper;    /* upper value of range                    */
   char         *slider_lower;   /* lower limit for slider                  */
   char         *slider_upper;   /* upper limit for slider                  */
   int           decimals;       /* number of decimals used for slider      */
 } KmParInt;                     /*                                         */
                                 /*                                         */
 typedef struct {                /* option                                  */
   char        **text;           /* explanations (parallel to range_value)  */
   int          *mutex;          /* mutex group to which text belongs       */
   int          *radio;          /* radio group to which text belongs       */
 } KmParOption;                  /*                                         */
                                 /*                                         */
 
typedef KmParInt KmParReal;     /* real and int have the same fields       */
                                /*                                         */
 typedef struct {                /*                                         */
   char         *name;           /* parameter name                          */
   int           abbrev;         /* minimum length that name is recognized  */
   char         *prompt;         /* prompt string                           */
   char         *dfault;         /* default value                           */
   char         *last;           /* last value for Motif panel (malloced)   */
   int           width;          /* width of input field                    */
   int           range_count;    /* number of items in range_value          */
   char        **range_value;    /* list of allowed values                  */
   int           select_count;   /* number of items in select_count         */
   char        **select_value;   /* list of values for selection box        */
   KmParFlag     flags;          /* special flags                           */
   KmParType     type;           /* parameter type                          */
   void        *ptype;           /* structure pointer selected by type      */
 } KmParameter;                  /*                                         */
                                 /*                                         */
 
typedef struct _KmCommand {     /*                                         */
  struct _KmCommand *next;      /* link to next command                    */
  char         *path;           /* command path                            */
  char         *name;           /* command name                            */
  int           hidden;         /* flag if command is invisible            */
  int           level;          /* depth of submenus                       */
  int           total;          /* total number of parameters              */
  int           mandatory;      /* number of mandatory parameters          */
  KmParameter **par;            /* list of total parameter descriptions    */
  int           list_par;       /* index+1 of parameter taking a list      */
  int           xcount;         /* count number of action calls            */
  SUBROUTINE   *action_F;       /* action routine                          */
  IntFunc      *action_C;       /* action routine                          */
  SUBROUTINE   *user_help_F;    /* user help routine                       */
  pCharFunc    *user_help_C;    /* user help routine                       */
  int          nguidance;       /* number of lines in guidance text        */
  char        **guidance;       /* help text                               */
  int          nkeyword;        /* number of lines for keywords            */
  char        **keyword;        /* list of keywords                        */
  int          nhlink;          /* number of lines for links               */
  char        **hlink;          /* list of links                           */
  int           argc;           /* number of arguments entered             */
  char        **argv;           /* argc argument values                    */
  char         *argline;        /* argument line as entered                */
  int          *argoffs;        /* argc offsets into argline for KUGETE    */
 } KmCommand;                    /*                                         */
                                 /*                                         */
 
typedef struct _KmMenu {        /*                                         */
  struct _KmMenu *next;         /* link to next menu                       */
  struct _KmMenu *down;         /* link to submenu                         */
  char         *path;           /* path of parent menu                     */
  char         *name;           /* menu name                               */
  int           level;          /* depth of submenus                       */
  KmCommand    *cmds;           /* link to first command                   */
  int          nguidance;       /* number of lines in guidance text        */
  char        **guidance;       /* help text                               */
  int          nkeyword;        /* number of lines for keywords            */
  char        **keyword;        /* list of keywords                        */
  int          nhlink;          /* number of lines for links               */
  char        **hlink;          /* list of links                           */
 } KmMenu;                       /*                                         */
                                 /*                                         */
 extern void klnkbrcl();         /*                                         */
 extern void klnkicon();         /*                                         */
 extern void klnkkmcl();         /*                                         */
 extern void klnkmenu();         /*                                         */
                                 /*                                         */
 
#ifdef F77_LCASE
#  define gkdraw_ gkdraw
#  define gxdraw_ gxdraw
#  define gxpick_ gxpick
#endif
 
#ifdef F77_UCASE
#  define gkdraw_ GKDRAW
#  define gxdraw_ GXDRAW
#  define gxpick_ GXPICK
#endif
 
#ifdef IBM370
#  pragma linkage(GKDRAW,FORTRAN)
#  pragma linkage(GXDRAW,FORTRAN)
#  pragma linkage(GXPICK,FORTRAN)
#endif
 
extern void gkdraw_();
extern void gxdraw_();
extern void gxpick_();
 
void gkdraw_()
{
 
static KmParReal   _GEANT_CVOL_VALCUT_XCUT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_VALCUT_XCUT = { "XCUT", 4,
 "x coordinate of cutted value", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_VALCUT_XCUT_type };
static KmParReal   _GEANT_CVOL_VALCUT_YCUT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_VALCUT_YCUT = { "YCUT", 4,
 "y coordinate of cutted value", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_VALCUT_YCUT_type };
static KmParReal   _GEANT_CVOL_VALCUT_ZCUT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_VALCUT_ZCUT = { "ZCUT", 4,
 "z coordinate of cutted value", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_VALCUT_ZCUT_type };
static KmParameter *_GEANT_CVOL_VALCUT_parameters[] = {
 &_GEANT_CVOL_VALCUT_XCUT, &_GEANT_CVOL_VALCUT_YCUT, &_GEANT_CVOL_VALCUT_ZCUT
 };
static char *_GEANT_CVOL_VALCUT_guidance[] = {
 "It allows the cutting in the ray-tracing. All the volumes are cutted",
 "from XCUT to +BIG along the x axis, from YCUT to +BIG along the y axis",
 "and from ZCUT to +BIG along the z axis." };
static KmCommand _GEANT_CVOL_VALCUT = {  (KmCommand*)0, "/GEANT/CVOL/VALCUT",
 "VALCUT", 0, 2, 3, 3, _GEANT_CVOL_VALCUT_parameters, 0, 0, gxdraw_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_CVOL_VALCUT_guidance,
 0, (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CVOL_SPHE_CNVV = { "CNVV", 4,
 " Name of volume to be clipped          ", "*   ", (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_CVOL_SPHE_RMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_SPHE_RMAX = { "RMAX", 4,
 " External radius of sphere             ", "0.1", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_SPHE_RMAX_type };
static KmParReal   _GEANT_CVOL_SPHE_XMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_SPHE_XMED = { "XMED", 4,
 " Center X coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_SPHE_XMED_type };
static KmParReal   _GEANT_CVOL_SPHE_YMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_SPHE_YMED = { "YMED", 4,
 " Center Y coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_SPHE_YMED_type };
static KmParReal   _GEANT_CVOL_SPHE_ZMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_SPHE_ZMED = { "ZMED", 4,
 " Center Z coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_SPHE_ZMED_type };
static KmParameter *_GEANT_CVOL_SPHE_parameters[] = { &_GEANT_CVOL_SPHE_CNVV,
 &_GEANT_CVOL_SPHE_RMAX, &_GEANT_CVOL_SPHE_XMED, &_GEANT_CVOL_SPHE_YMED,
 &_GEANT_CVOL_SPHE_ZMED };
static char *_GEANT_CVOL_SPHE_guidance[] = {
 "This command performs a boolean subtraction between the volume",
 "CNVV and a sphere; the sphere has the given parameters and is placed in",
 "the MARS according to the given coordinates of its center.",
 "See also CVOL. The following commands clip by a sphere,",
 "positioned according to the given parameters, the volume specified",
 "by NAME (a valid string for the NAME of the volume",
 "can be found using the DTREE command).", "EXAMPLE -", " dopt hide on",
 " satt * seen -2", " draw NAME 40 40 0 10 10 .01 .01", " next",
 " sphe * 500 0 0 500", " draw NAME 40 40 0 10 10 .01 .01", " box ." };
static KmCommand _GEANT_CVOL_SPHE = { &_GEANT_CVOL_VALCUT, "/GEANT/CVOL/SPHE",
 "SPHE", 0, 2, 5, 1, _GEANT_CVOL_SPHE_parameters, 0, 0, gxdraw_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 15, _GEANT_CVOL_SPHE_guidance, 0, (char**)0,
 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CVOL_CONE_CNVV = { "CNVV", 4,
 " Name of volume to be clipped          ", "*   ", (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_CVOL_CONE_RMAX1_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_CONE_RMAX1 = { "RMAX1", 5,
 " Min external radius                   ", "0.1", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_CONE_RMAX1_type };
static KmParReal   _GEANT_CVOL_CONE_RMAX2_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_CONE_RMAX2 = { "RMAX2", 5,
 " Max external radius                   ", "0.1", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_CONE_RMAX2_type };
static KmParReal   _GEANT_CVOL_CONE_ZDEM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_CONE_ZDEM = { "ZDEM", 4,
 " Half length of cone axis              ", "0.1", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_CONE_ZDEM_type };
static KmParReal   _GEANT_CVOL_CONE_XMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_CONE_XMED = { "XMED", 4,
 " Center X coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_CONE_XMED_type };
static KmParReal   _GEANT_CVOL_CONE_YMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_CONE_YMED = { "YMED", 4,
 " Center Y coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_CONE_YMED_type };
static KmParReal   _GEANT_CVOL_CONE_ZMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_CONE_ZMED = { "ZMED", 4,
 " Center Z coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_CONE_ZMED_type };
static KmParameter *_GEANT_CVOL_CONE_parameters[] = { &_GEANT_CVOL_CONE_CNVV,
 &_GEANT_CVOL_CONE_RMAX1, &_GEANT_CVOL_CONE_RMAX2, &_GEANT_CVOL_CONE_ZDEM,
 &_GEANT_CVOL_CONE_XMED, &_GEANT_CVOL_CONE_YMED, &_GEANT_CVOL_CONE_ZMED };
static char *_GEANT_CVOL_CONE_guidance[] = {
 "This command performs a boolean subtraction between the volume",
 "CNVV and a cone; the cone has the given parameters and is placed in",
 "the MARS according to the given coordinates of its center.",
 "See also CVOL.", "The following commands will clip by a cone,",
 "positioned according the given parameters, the volume specified",
 "by NAME (a valid string for the NAME of the volume",
 "can be found using the DTREE command).", " EXAMPLE -", " dopt hide on",
 " satt * seen -2", " draw NAME 40 40 0 10 10 .01 .01", " next",
 " cone * 1 750 1000 0 0 1000", " draw NAME 40 40 0 10 10 .01 .01", " box ." };
static KmCommand _GEANT_CVOL_CONE = { &_GEANT_CVOL_SPHE, "/GEANT/CVOL/CONE",
 "CONE", 0, 2, 7, 1, _GEANT_CVOL_CONE_parameters, 0, 0, gxdraw_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 16, _GEANT_CVOL_CONE_guidance, 0, (char**)0,
 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CVOL_TUBE_CNVV = { "CNVV", 4,
 " Name of volume to be clipped          ", "*   ", (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_CVOL_TUBE_RMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_TUBE_RMAX = { "RMAX", 4,
 " External radius of tube               ", "0.1", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_TUBE_RMAX_type };
static KmParReal   _GEANT_CVOL_TUBE_ZDEM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_TUBE_ZDEM = { "ZDEM", 4,
 " Half length of tube axis              ", "0.1", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_TUBE_ZDEM_type };
static KmParReal   _GEANT_CVOL_TUBE_XMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_TUBE_XMED = { "XMED", 4,
 " Center X coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_TUBE_XMED_type };
static KmParReal   _GEANT_CVOL_TUBE_YMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_TUBE_YMED = { "YMED", 4,
 " Center Y coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_TUBE_YMED_type };
static KmParReal   _GEANT_CVOL_TUBE_ZMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_TUBE_ZMED = { "ZMED", 4,
 " Center Z coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_TUBE_ZMED_type };
static KmParameter *_GEANT_CVOL_TUBE_parameters[] = { &_GEANT_CVOL_TUBE_CNVV,
 &_GEANT_CVOL_TUBE_RMAX, &_GEANT_CVOL_TUBE_ZDEM, &_GEANT_CVOL_TUBE_XMED,
 &_GEANT_CVOL_TUBE_YMED, &_GEANT_CVOL_TUBE_ZMED };
static char *_GEANT_CVOL_TUBE_guidance[] = {
 "This command performs a boolean subtraction between the volume",
 "CNVV and a tube; the tube has the given parameters and is placed in",
 "the MARS according the given coordinates of its center.", "See also CVOL.",
 "The following commands will clip, by a tube,",
 "positioned according to the given parameters, the volume specified",
 "by NAME (a valid string for the NAME of the volume",
 "can be found using the DTREE command).", " EXAMPLE -", " dopt hide on",
 " satt * seen -2", " draw NAME 40 40 0 10 10 .01 .01", " next",
 " tube * 500 1000 500 0 0", " draw NAME 40 40 0 10 10 .01 .01", " box ." };
static KmCommand _GEANT_CVOL_TUBE = { &_GEANT_CVOL_CONE, "/GEANT/CVOL/TUBE",
 "TUBE", 0, 2, 6, 1, _GEANT_CVOL_TUBE_parameters, 0, 0, gxdraw_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 16, _GEANT_CVOL_TUBE_guidance, 0, (char**)0,
 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CVOL_BOX_CNNV = { "CNNV", 4,
 " Name of volume to be clipped          ", "*   ", (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_CVOL_BOX_XMIN_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_CVOL_BOX_XMIN = { "XMIN", 4,
 " Lower limit of the Shape X coordinate ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_BOX_XMIN_type };
static KmParReal   _GEANT_CVOL_BOX_XMAX_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_CVOL_BOX_XMAX = { "XMAX", 4,
 " Upper limit of the Shape X coordinate ", "-9999.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_BOX_XMAX_type };
static KmParReal   _GEANT_CVOL_BOX_YMIN_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_CVOL_BOX_YMIN = { "YMIN", 4,
 " Lower limit of the Shape Y coordinate ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_BOX_YMIN_type };
static KmParReal   _GEANT_CVOL_BOX_YMAX_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_CVOL_BOX_YMAX = { "YMAX", 4,
 " Upper limit of the Shape Y coordinate ", "-9999.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_BOX_YMAX_type };
static KmParReal   _GEANT_CVOL_BOX_ZMIN_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_CVOL_BOX_ZMIN = { "ZMIN", 4,
 " Lower limit of the Shape Z coordinate ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_BOX_ZMIN_type };
static KmParReal   _GEANT_CVOL_BOX_ZMAX_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_CVOL_BOX_ZMAX = { "ZMAX", 4,
 " Upper limit of the Shape Z coordinate ", "-9999.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_BOX_ZMAX_type };
static KmParameter *_GEANT_CVOL_BOX_parameters[] = { &_GEANT_CVOL_BOX_CNNV,
 &_GEANT_CVOL_BOX_XMIN, &_GEANT_CVOL_BOX_XMAX, &_GEANT_CVOL_BOX_YMIN,
 &_GEANT_CVOL_BOX_YMAX, &_GEANT_CVOL_BOX_ZMIN, &_GEANT_CVOL_BOX_ZMAX };
static char *_GEANT_CVOL_BOX_guidance[] = {
 "This command performs a boolean subtraction between the volume",
 "CNVV and a box placed in the MARS according the values of the given",
 "coordinates. See also CVOL.", "The following commands will clip by a box,",
 "with a vertex at the origin, the volume specified by NAME (a valid",
 "string for the NAME of the volume can be found using the DTREE command).",
 " EXAMPLE -", " dopt hide on", " satt * seen -2",
 " draw NAME 40 40 0 10 10 .01 .01", " next",
 " box NAME 0 1000 0 1000 0 1000", " draw NAME 40 40 0 10 10 .01 .01",
 " box ." };
static KmCommand _GEANT_CVOL_BOX = { &_GEANT_CVOL_TUBE, "/GEANT/CVOL/BOX",
 "BOX", 0, 2, 7, 1, _GEANT_CVOL_BOX_parameters, 0, 0, gxdraw_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 14, _GEANT_CVOL_BOX_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DUVIEW_NAME = { "NAME", 4, "Detector name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_DRAWING_DUVIEW_TYPE = { "TYPE", 4, "View name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_DRAWING_DUVIEW_CPXTYP = { "CPXTYP", 6,
 "Complexity name", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_DRAWING_DUVIEW_IVIEW_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DUVIEW_IVIEW = { "IVIEW", 5,
 "View number where picture is stored", "0", (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_DUVIEW_IVIEW_type };
static KmParameter *_GEANT_DRAWING_DUVIEW_parameters[] = {
 &_GEANT_DRAWING_DUVIEW_NAME, &_GEANT_DRAWING_DUVIEW_TYPE,
 &_GEANT_DRAWING_DUVIEW_CPXTYP, &_GEANT_DRAWING_DUVIEW_IVIEW };
static char *_GEANT_DRAWING_DUVIEW_guidance[] = {
 " CALL GUVIEW(name,type,cpxtyp,iview)" };
static KmCommand _GEANT_DRAWING_DUVIEW = {  (KmCommand*)0,
 "/GEANT/DRAWING/DUVIEW", "DUVIEW", 0, 2, 4, 3,
 _GEANT_DRAWING_DUVIEW_parameters, 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 1, _GEANT_DRAWING_DUVIEW_guidance, 0, (char**)0, 0, (char**)0,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DCHIT_CHUSET = { "CHUSET", 6,
 "User set identifier", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_DRAWING_DCHIT_CHUDET = { "CHUDET", 6,
 "User detector identifier", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_DRAWING_DCHIT_ITRA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCHIT_ITRA = { "ITRA", 4,
 "Number of the selected track", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_DCHIT_ITRA_type };
static KmParInt    _GEANT_DRAWING_DCHIT_ISYMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCHIT_ISYMB = { "ISYMB", 5,
 "Character selection number", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_DCHIT_ISYMB_type };
static KmParReal   _GEANT_DRAWING_DCHIT_SIZMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCHIT_SIZMAX = { "SIZMAX", 6,
 "Maximum character size (cm)", "1", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DCHIT_SIZMAX_type };
static KmParInt    _GEANT_DRAWING_DCHIT_IHIT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCHIT_IHIT = { "IHIT", 4,
 "Index of array HITS", "4", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_DCHIT_IHIT_type };
static KmParReal   _GEANT_DRAWING_DCHIT_HITMIN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCHIT_HITMIN = { "HITMIN", 6,
 "Lower boundary of HITS(IHIT)", "0", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DCHIT_HITMIN_type };
static KmParReal   _GEANT_DRAWING_DCHIT_HITMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCHIT_HITMAX = { "HITMAX", 6,
 "Upper boundary of HITS(IHIT)", "0", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DCHIT_HITMAX_type };
static KmParameter *_GEANT_DRAWING_DCHIT_parameters[] = {
 &_GEANT_DRAWING_DCHIT_CHUSET, &_GEANT_DRAWING_DCHIT_CHUDET,
 &_GEANT_DRAWING_DCHIT_ITRA, &_GEANT_DRAWING_DCHIT_ISYMB,
 &_GEANT_DRAWING_DCHIT_SIZMAX, &_GEANT_DRAWING_DCHIT_IHIT,
 &_GEANT_DRAWING_DCHIT_HITMIN, &_GEANT_DRAWING_DCHIT_HITMAX };
static char *_GEANT_DRAWING_DCHIT_guidance[] = {
 " CALL GDCHIT(chuset,chudet,itra,isymb,sizmax,ihit,hitmin,hitmax)",
 "The character plotted at each hit point may be chosen via",
 "CSYMB; isymb is composed as:",
 "      -1   (small) hardware points             (fast)",
 "       0   software crosses                    (default)",
 " 840,850   empty/full circles                  (slow)",
 " 841,851   empty/full squares                  (slow)",
 " 842,852   empty/full triangles (up)           (slow)",
 " 843,853   empty diamond/full triangle (down)  (slow)",
 " 844,854   empty/full stars                    (slow)",
 "Except for isymb=-1 the SIZE of the character on the screen",
 "is a function of HITS(IHIT), the array containing the calorimeter",
 "quantity, with HITMIN and HITMAX defining its range.",
 "The maximum character size (used in overflow) is SIZMAX.",
 " SIZE = SIZMAX * ( HITS(IHIT) - HITMIN ) / HITMAX" };
static KmCommand _GEANT_DRAWING_DCHIT = { &_GEANT_DRAWING_DUVIEW,
 "/GEANT/DRAWING/DCHIT", "DCHIT", 0, 2, 8, 0, _GEANT_DRAWING_DCHIT_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 15,
 _GEANT_DRAWING_DCHIT_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_KHITS_CHUSET = { "CHUSET", 6,
 "User set identifier", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_DRAWING_KHITS_CHUDET = { "CHUDET", 6,
 "User detector identifier", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_DRAWING_KHITS_EPSILO_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_KHITS_EPSILO = { "EPSILO", 6,
 "Pick aperture", "0.1", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_KHITS_EPSILO_type };
static KmParameter *_GEANT_DRAWING_KHITS_parameters[] = {
 &_GEANT_DRAWING_KHITS_CHUSET, &_GEANT_DRAWING_KHITS_CHUDET,
 &_GEANT_DRAWING_KHITS_EPSILO };
static char *_GEANT_DRAWING_KHITS_guidance[] = {
 " CALL GKHITS(chuset,chudet,epsilo)",
 "The picking of hit points requires the appropriate JSET data structure",
 "have been filled",
 "and is  repeated until the character typed is 'Q' or 'q' (GKS) or the",
 "right button of the mouse is clicked (X11).",
 "If the character typed to pick is 'K' or 'k' then the",
 "kinematics of the corresponding track is also printed.",
 "The search is made of all the hits of all tracks in",
 "detector CHUDET of set CHUSET.",
 "EPSILO is the pick aperture; if EPSILO<0 its absolute value is taken",
 "and in addition the pick aperture is drawn; if EPSILO=0",
 "there is an infinite pick aperture and",
 "over all the hits the one nearest to the pick point is taken." };
static KmCommand _GEANT_DRAWING_KHITS = { &_GEANT_DRAWING_DCHIT,
 "/GEANT/DRAWING/KHITS", "KHITS", 0, 2, 3, 0, _GEANT_DRAWING_KHITS_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 13,
 _GEANT_DRAWING_KHITS_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DHITS_CHUSET = { "CHUSET", 6,
 "User set identifier", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_DRAWING_DHITS_CHUDET = { "CHUDET", 6,
 "User detector identifier", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_DRAWING_DHITS_ITRA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DHITS_ITRA = { "ITRA", 4,
 "Number of the selected track", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_DHITS_ITRA_type };
static KmParInt    _GEANT_DRAWING_DHITS_ISYMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DHITS_ISYMB = { "ISYMB", 5,
 "Character selection number", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_DHITS_ISYMB_type };
static KmParReal   _GEANT_DRAWING_DHITS_SSYMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DHITS_SSYMB = { "SSYMB", 5,
 "Size of characters (cm)", "0.1", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DHITS_SSYMB_type };
static KmParameter *_GEANT_DRAWING_DHITS_parameters[] = {
 &_GEANT_DRAWING_DHITS_CHUSET, &_GEANT_DRAWING_DHITS_CHUDET,
 &_GEANT_DRAWING_DHITS_ITRA, &_GEANT_DRAWING_DHITS_ISYMB,
 &_GEANT_DRAWING_DHITS_SSYMB };
static char *_GEANT_DRAWING_DHITS_guidance[] = {
 "CALL GDHITS(chuset,chudet,itra,isymb,ssymb).",
 "The character plotted at each hit point may be chosen by isymb :",
 "      -1   (small) hardware points             (fast)",
 "       0   software crosses                    (default)",
 "   840,850   empty/full circles                  (slow)",
 "   841,851   empty/full squares                  (slow)",
 "   842,852   empty/full triangles (up)           (slow)",
 "   843,853   empty diamond/full triangle (down)  (slow)",
 "   844,854   empty/full stars                    (slow)",
 "Except for isymb=-1, the size of the character on the screen can be",
 "chosen by SSYMB cm. The hit colour will follow the value of TXCI (text",
 "colour) for isymb>0, the value of PMCI (polymarkers colour) for isymb<0,",
 "the value of PLCI (polyline colour) for isymb=0." };
static KmCommand _GEANT_DRAWING_DHITS = { &_GEANT_DRAWING_KHITS,
 "/GEANT/DRAWING/DHITS", "DHITS", 0, 2, 5, 0, _GEANT_DRAWING_DHITS_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 13,
 _GEANT_DRAWING_DHITS_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DRAWING_DPART_ITRA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DPART_ITRA = { "ITRA", 4, "Track number",
 "0", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_DPART_ITRA_type };
static KmParInt    _GEANT_DRAWING_DPART_ISEL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DPART_ISEL = { "ISEL", 4, "Option flag",
 "11", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_DPART_ISEL_type };
static KmParReal   _GEANT_DRAWING_DPART_SIZE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DPART_SIZE = { "SIZE", 4,
 "Character size (cm) for particle names", "0.25", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DPART_SIZE_type };
static KmParameter *_GEANT_DRAWING_DPART_parameters[] = {
 &_GEANT_DRAWING_DPART_ITRA, &_GEANT_DRAWING_DPART_ISEL,
 &_GEANT_DRAWING_DPART_SIZE };
static char *_GEANT_DRAWING_DPART_guidance[] = {
 " CALL GDPART(itra,isel,size)", " isel=x1 to draw the track number",
 " isel=1x to draw the particle name" };
static KmCommand _GEANT_DRAWING_DPART = { &_GEANT_DRAWING_DHITS,
 "/GEANT/DRAWING/DPART", "DPART", 0, 2, 3, 0, _GEANT_DRAWING_DPART_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_DRAWING_DPART_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_KXYZ_EPSILO_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_KXYZ_EPSILO = { "EPSILO", 6, "Delta angle",
 "0.25", (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_KXYZ_EPSILO_type };
static KmParameter *_GEANT_DRAWING_KXYZ_parameters[] = {
 &_GEANT_DRAWING_KXYZ_EPSILO };
static char *_GEANT_DRAWING_KXYZ_guidance[] = { " CALL GKXYZ(epsilo)",
 "The picking of track points requires the JXYZ data structure",
 "and is  repeated until the character typed is 'Q' or 'q' (GKS)",
 "or the right button of the mouse is clicked (X11).",
 "EPSILO is the delta angle used for picking; if EPSILO=0",
 "there is no optimization performed and",
 "over all the track points the one nearest to the pick", "point is taken." };
static KmCommand _GEANT_DRAWING_KXYZ = { &_GEANT_DRAWING_DPART,
 "/GEANT/DRAWING/KXYZ", "KXYZ", 0, 2, 1, 0, _GEANT_DRAWING_KXYZ_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 8,
 _GEANT_DRAWING_KXYZ_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DRAWING_DXYZ_ITRA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DXYZ_ITRA = { "ITRA", 4, "Track number",
 "0", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_DXYZ_ITRA_type };
static KmParameter *_GEANT_DRAWING_DXYZ_parameters[] = {
 &_GEANT_DRAWING_DXYZ_ITRA };
static char *_GEANT_DRAWING_DXYZ_guidance[] = { " CALL GDXYZ(itra)",
 "Draw tracks previously stored via GSXYZ." };
static KmCommand _GEANT_DRAWING_DXYZ = { &_GEANT_DRAWING_KXYZ,
 "/GEANT/DRAWING/DXYZ", "DXYZ", 0, 2, 1, 0, _GEANT_DRAWING_DXYZ_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_DRAWING_DXYZ_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_ZOOM_ZFU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_ZOOM_ZFU = { "ZFU", 3,
 "Zoom factor for U-coord. (horizontal)", "2.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_ZOOM_ZFU_type };
static KmParReal   _GEANT_DRAWING_ZOOM_ZFV_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_ZOOM_ZFV = { "ZFV", 3,
 "Zoom factor for V-coord. (vertical)", "2.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_ZOOM_ZFV_type };
static KmParInt    _GEANT_DRAWING_ZOOM_ISEL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_ZOOM_ISEL = { "ISEL", 4, "Options", "1",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_ZOOM_ISEL_type };
static KmParReal   _GEANT_DRAWING_ZOOM_UZ0_type = { "0.", "20.", "0.", "20.",
 0 };
static KmParameter _GEANT_DRAWING_ZOOM_UZ0 = { "UZ0", 3,
 "U-coord. of the centre of zoom rectangle", "10.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_ZOOM_UZ0_type };
static KmParReal   _GEANT_DRAWING_ZOOM_VZ0_type = { "0.", "20.", "0.", "20.",
 0 };
static KmParameter _GEANT_DRAWING_ZOOM_VZ0 = { "VZ0", 3,
 "V-coord. of the centre of zoom rectangle", "10.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_ZOOM_VZ0_type };
static KmParReal   _GEANT_DRAWING_ZOOM_U0_type = { "0.", "20.", "0.", "20.", 0
 };
static KmParameter _GEANT_DRAWING_ZOOM_U0 = { "U0", 2,
 "U-coord. of the centre of resulting zoomed rectangle", "10.", (char*)0, 12,
 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_ZOOM_U0_type };
static KmParReal   _GEANT_DRAWING_ZOOM_V0_type = { "0.", "20.", "0.", "20.", 0
 };
static KmParameter _GEANT_DRAWING_ZOOM_V0 = { "V0", 2,
 "V-coord. of the centre of resulting zoomed rectangle", "10.", (char*)0, 12,
 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_ZOOM_V0_type };
static KmParameter *_GEANT_DRAWING_ZOOM_parameters[] = {
 &_GEANT_DRAWING_ZOOM_ZFU, &_GEANT_DRAWING_ZOOM_ZFV,
 &_GEANT_DRAWING_ZOOM_ISEL, &_GEANT_DRAWING_ZOOM_UZ0,
 &_GEANT_DRAWING_ZOOM_VZ0, &_GEANT_DRAWING_ZOOM_U0, &_GEANT_DRAWING_ZOOM_V0 };
static char *_GEANT_DRAWING_ZOOM_guidance[] = {
 " CALL GDZOOM(zfu,zfv,uz0,vz0,u0,v0)",
 "This command sets the zoom parameters that will be used by",
 "subsequent calls to the drawing routines. Each zoom operation is always",
 "relative to the status of the current zoom parameters.",
 "The scale factors in u,v are respectively  zfu,zfv.",
 "zfu=0 (or zfv=0) will act as a reset (i.e. unzoomed viewing).",
 "The zoom is computed around uz0,vz0 (user coordinates),",
 "and the resulting picture will be centered at u0,v0.",
 "The use of the space bar is replaced by the left button of the mouse",
 "running with X11:", "If isel=0 :", " 1. position the cursor at (uz0,vz0)",
 " 2. type the space bar (GKS)", "(u0,v0 are chosen at centre of screen)",
 "If isel=1 :", " 1. position the cursor at first corner of zoom rectangle",
 " 2. type the space bar (GKS)",
 " 3. position the cursor at second corner of zoom rectangle",
 " 4. type the space bar (GKS)",
 "(zfu,zfv are chosen according to the zoom rectangle;",
 "uz0,vz0 are chosen at the centre of the zoom rectangle;",
 "u0,v0 are chosen at centre of screen)", "If isel=2 :",
 " 1. position the cursor at (uz0,vz0)", " 2. type the space bar (GKS)",
 " 3. position the cursor at (u0,v0)", " 4. type the space bar (GKS)",
 "If isel=1000+n and running with X-windows:",
 " 1. n must be the identifier of an active view bank",
 " 2. clicking on the left button of the mouse will display",
 "    a zoomed view (computed around the cursor position) of",
 "    the previous drawing in a new window",
 " 3. it is now possible to iterate the zooming from the new window",
 " 4. clicking on the right button will return the control to the",
 "    main window",
 " 5. clicking on the left button it is possible to open new windows",
 "    zooming in other points of the detector",
 " 6. clicking on the right button when the main window is active",
 "    will return the control to the 'command mode'." };
static KmCommand _GEANT_DRAWING_ZOOM = { &_GEANT_DRAWING_DXYZ,
 "/GEANT/DRAWING/ZOOM", "ZOOM", 0, 2, 7, 0, _GEANT_DRAWING_ZOOM_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 39,
 _GEANT_DRAWING_ZOOM_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DRAWING_LENS_KNUM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_LENS_KNUM = { "KNUM", 4,
 "View bank identifier", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_LENS_KNUM_type };
static KmParameter _GEANT_DRAWING_LENS_KSAM = { "KSAM", 4,
 "Sample mode         ", "OFF ", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_DRAWING_LENS_parameters[] = {
 &_GEANT_DRAWING_LENS_KNUM, &_GEANT_DRAWING_LENS_KSAM };
static char *_GEANT_DRAWING_LENS_guidance[] = {
 "Interactive zooming for detectors and events when running",
 "with X-windows. Using this command, when showing the contents of a",
 "view bank, it is possible to click (left button) in two points of the",
 "drawing (which will represent the left upper corner and the right",
 "bottom corner of the part to be zoomed). After the second click",
 "a new 'window' will appear to fit the frame defined",
 "by the two clicks and it will show a zoomed view as seen from a",
 "lens with those dimensions. Clicking now the central button will",
 "translate the lens over the drawing, while clicking the right button",
 "will stop it. Moreover, clicking the left button of the",
 "mouse, the lens will increase (or decrease) its magnification",
 "power according to the backward-to-forward movement of the mouse.",
 "A click on the right button will stop this action and it is possible",
 "to restart the translation of the lens or, clicking",
 "on the right button again, to make the lens disappear. It is then possible",
 "to open another 'window-lens' with different dimensions. Thus,",
 "this command can be useful to scan detailed parts of a detector or",
 "to scan hits and showers for events. Clicking the right",
 "button when no lens is displayed will return the control to the",
 "'command mode'. The LENS is also available in sample mode when KSAM is",
 "'ON'.", "The following commands will fill a view bank and will",
 "allow to scan the detector and an event previously stored",
 "via the use of LENS (when running", "with X-windows):", " EXAMPLE -",
 " satt * seen 1", " dopen 1", " draw NAME 40 40 0 10 10 .01 .01", " dxyz 0",
 " dhits * * 0 0 .2", " dclose", " dsh 1", " lens 1 on" };
static KmCommand _GEANT_DRAWING_LENS = { &_GEANT_DRAWING_ZOOM,
 "/GEANT/DRAWING/LENS", "LENS", 0, 2, 2, 1, _GEANT_DRAWING_LENS_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 34,
 _GEANT_DRAWING_LENS_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_PERSP_NAME = { "NAME", 4, "Volume name",
 "    ", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParReal   _GEANT_DRAWING_PERSP_DISTT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_PERSP_DISTT = { "DISTT", 5,
 "Volume distance from observer", "1000.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_PERSP_DISTT_type };
static KmParameter _GEANT_DRAWING_PERSP_SAMP = { "SAMP", 4,
 "Control to the mouse", "OFF ", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_DRAWING_PERSP_parameters[] = {
 &_GEANT_DRAWING_PERSP_NAME, &_GEANT_DRAWING_PERSP_DISTT,
 &_GEANT_DRAWING_PERSP_SAMP };
static char *_GEANT_DRAWING_PERSP_guidance[] = {
 "To control the perspective according to the variation of the distance",
 "between the observer and the object (if PROJ has the value PERS).",
 "If SAMP is ON the control of the distance is given via the mouse." };
static KmCommand _GEANT_DRAWING_PERSP = { &_GEANT_DRAWING_LENS,
 "/GEANT/DRAWING/PERSP", "PERSP", 0, 2, 3, 2, _GEANT_DRAWING_PERSP_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_DRAWING_PERSP_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_MOVE3D_NAME = { "NAME", 4, "Volume name",
 "    ", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParReal   _GEANT_DRAWING_MOVE3D_THETA_type = { "0.", "180.", "0.",
 "180.", 0 };
static KmParameter _GEANT_DRAWING_MOVE3D_THETA = { "THETA", 5,
 "Viewing angle theta (for 3D projection)", "40.", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_MOVE3D_THETA_type };
static KmParReal   _GEANT_DRAWING_MOVE3D_PHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_MOVE3D_PHI = { "PHI", 3,
 "Viewing angle phi (for 3D projection)", "40.", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_MOVE3D_PHI_type };
static KmParReal   _GEANT_DRAWING_MOVE3D_PSI_type = { "0.", "180.", "0.",
 "180.", 0 };
static KmParameter _GEANT_DRAWING_MOVE3D_PSI = { "PSI", 3,
 "Viewing angle psi (for 2D rotation)", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_MOVE3D_PSI_type };
static KmParReal   _GEANT_DRAWING_MOVE3D_U0_type = { "0.", "20.", "0.", "20.",
 0 };
static KmParameter _GEANT_DRAWING_MOVE3D_U0 = { "U0", 2,
 "U-coord. (horizontal) of volume origin", "10.", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_MOVE3D_U0_type };
static KmParReal   _GEANT_DRAWING_MOVE3D_V0_type = { "0.", "20.", "0.", "20.",
 0 };
static KmParameter _GEANT_DRAWING_MOVE3D_V0 = { "V0", 2,
 "V-coord. (vertical) of volume origin", "10.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_MOVE3D_V0_type };
static KmParReal   _GEANT_DRAWING_MOVE3D_SU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_MOVE3D_SU = { "SU", 2,
 "Scale factor for U-coord.", "0.01", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_MOVE3D_SU_type };
static KmParReal   _GEANT_DRAWING_MOVE3D_SV_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_MOVE3D_SV = { "SV", 2,
 "Scale factor for V-coord.", "0.01", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_MOVE3D_SV_type };
static KmParReal   _GEANT_DRAWING_MOVE3D_SZ_type = { "0.1", "10.", "0.1",
 "10.", 1 };
static KmParameter _GEANT_DRAWING_MOVE3D_SZ = { "SZ", 2, "Scale zoom factor",
 "1.", (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_MOVE3D_SZ_type };
static char *_GEANT_DRAWING_MOVE3D_NOPT_range[] = { "T", "H" };
static char *_GEANT_DRAWING_MOVE3D_NOPT_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_DRAWING_MOVE3D_NOPT_type = {
 _GEANT_DRAWING_MOVE3D_NOPT_text, (int*)0, (int*)0 };
static KmParameter _GEANT_DRAWING_MOVE3D_NOPT = { "NOPT", 4,
 "T=tracks,H=hits", "    ", (char*)0, 8, 2, _GEANT_DRAWING_MOVE3D_NOPT_range,
 2, _GEANT_DRAWING_MOVE3D_NOPT_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_DRAWING_MOVE3D_NOPT_type };
static KmParameter *_GEANT_DRAWING_MOVE3D_parameters[] = {
 &_GEANT_DRAWING_MOVE3D_NAME, &_GEANT_DRAWING_MOVE3D_THETA,
 &_GEANT_DRAWING_MOVE3D_PHI, &_GEANT_DRAWING_MOVE3D_PSI,
 &_GEANT_DRAWING_MOVE3D_U0, &_GEANT_DRAWING_MOVE3D_V0,
 &_GEANT_DRAWING_MOVE3D_SU, &_GEANT_DRAWING_MOVE3D_SV,
 &_GEANT_DRAWING_MOVE3D_SZ, &_GEANT_DRAWING_MOVE3D_NOPT };
static char *_GEANT_DRAWING_MOVE3D_guidance[] = {
 "Same functionality of the command MOVE interfaced with MOTIF." };
static KmCommand _GEANT_DRAWING_MOVE3D = { &_GEANT_DRAWING_PERSP,
 "/GEANT/DRAWING/MOVE3D", "MOVE3D", 0, 2, 10, 1,
 _GEANT_DRAWING_MOVE3D_parameters, 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 1, _GEANT_DRAWING_MOVE3D_guidance, 0, (char**)0, 0, (char**)0,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_MOVE_NAME = { "NAME", 4, "Volume name",
 "    ", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParameter _GEANT_DRAWING_MOVE_NOPT = { "NOPT", 4,
 "S=sample mode,T=tracks,H=hits", "    ", (char*)0, 20, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_DRAWING_MOVE_parameters[] = {
 &_GEANT_DRAWING_MOVE_NAME, &_GEANT_DRAWING_MOVE_NOPT };
static char *_GEANT_DRAWING_MOVE_guidance[] = {
 "Positioning some daughter volumes inside a 'mother', it can be",
 "important to check if overlaps between such volumes have occurred.",
 "Instead of putting the drawing in a view bank, zooming, and iterating",
 "the process for different viewing angles of the same detector, the",
 "MOVE facility has been developed (for machines running with X11):",
 "it is sufficient to draw a view of the volumes to be analysed (after",
 "setting the proper SEEN, COLO, etc. attributes) and then to enter",
 "'MOVE' followed by the same 'NAME' used for the last command DRAW.",
 "The detector will appear in a panel with five buttons at the",
 "bottom: THETA, PHI, TRASL, ZOOM, OFF. Clicking on the left button",
 "of the mouse, when the cursor is inside the THETA area, will rotate the",
 "detector along the polar angle theta according to the",
 "backward-to-forward movement of the mouse",
 "(clicking up and down the left button if",
 "not in sample mode); clicking on the right button of",
 "the mouse will stop the rotation; clicking now on the",
 "left button of the mouse when inside the PHI area will activate a",
 "rotation along the polar angle phi. In the same way, activating the",
 "TRASL button, the detector can be translated in the u,v plane",
 "of the screen according to the 2D-movement of the mouse. Finally,",
 "activating the ZOOM button, the detector will be zoomed (or unzoomed)",
 "according to the backward-to-forward movement of the mouse. Clicking on\
 the", "OFF button will return the control to the 'command mode'. The MOVE",
 "command will work also with hidden line removal and shading options",
 "(when SHAD is on the background will be black);",
 "moreover, if the volumes are clipped, exploded, shifted, etc., they",
 "will be 'MOVED' with these features as well.",
 "Tracks and hits of a previously stored physical event can be moved",
 "together with the detector, allowing a dynamical 3-D analysis of the",
 "simulated events. Clicking the central button of the mouse when a good",
 "view of the event is found, will stop any movement and the mouse will",
 "allow the normal picking capabilities first for the tracks and then for",
 "the hits. After clicking of the right button, the normal",
 "movement will restart to find another interesting view of the event",
 "and to iterate the process.", "The MOVE is also available in sample mode.",
 "The following commands will produce a drawing of a volume",
 "and then will give the control to the MOVE panel; try the following",
 "possibilities:", " EXAMPLE 1 -", " dopt hide off", " satt * seen -2",
 " draw NAME 40 40 0 10 10 .01 .01", " move NAME", " EXAMPLE 2 -",
 " dopt hide on", " satt * seen -2", " draw NAME 40 40 0 10 10 .01 .01",
 " move NAME", " EXAMPLE 3 -", " dopt shad on", " satt * colo 3",
 " satt * fill 2", " dopt edge off", " draw NAME 40 40 0 10 10 .01 .01",
 " move NAME" };
static KmCommand _GEANT_DRAWING_MOVE = { &_GEANT_DRAWING_MOVE3D,
 "/GEANT/DRAWING/MOVE", "MOVE", 0, 2, 2, 1, _GEANT_DRAWING_MOVE_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 56,
 _GEANT_DRAWING_MOVE_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_DRAWING_PICK_guidance[] = {
 "Activates graphic input to identify detector elements",
 "in a cut view. Clicking on the left button of the mouse when",
 "the cursor is in a given point of the drawing and clicking again",
 "(outside the detector) will produce the following effect:",
 "a line joininig the two points will be drawn together with",
 "the name and the medium number of the volume picked",
 "with the first clicking close to the second point." };
static KmCommand _GEANT_DRAWING_PICK = { &_GEANT_DRAWING_MOVE,
 "/GEANT/DRAWING/PICK", "PICK", 0, 2, 0, 0, (KmParameter**)0, 0, 0, gxpick_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 7, _GEANT_DRAWING_PICK_guidance,
 0, (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_DRAWING_MEASURE_guidance[] = {
 "Position the cursor on the first point (u1,v1) and hit the space bar(GKS).",
 "Position the cursor on the second point (u2,v2) and hit the space\
 bar(GKS).",
 "Clicking the left button of the mouse (X11) will have the same effect as",
 "hiting the space bar (GKS).",
 "The command will compute and print the distance in space separating",
 "the two points on the projection view. It can be useful to measure",
 "distances either between volumes or between tracks or hits." };
static KmCommand _GEANT_DRAWING_MEASURE = { &_GEANT_DRAWING_PICK,
 "/GEANT/DRAWING/MEASURE", "MEASURE", 0, 2, 0, 0, (KmParameter**)0, 0, 0,
 gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 7,
 _GEANT_DRAWING_MEASURE_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DRAWING_DHEAD_ISEL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DHEAD_ISEL = { "ISEL", 4, "Option flag",
 "111110", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_DHEAD_ISEL_type };
static KmParameter _GEANT_DRAWING_DHEAD_NAME = { "NAME", 4, "Title", " ",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParReal   _GEANT_DRAWING_DHEAD_CHRSIZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DHEAD_CHRSIZ = { "CHRSIZ", 6,
 "Character size (cm) of title NAME", "0.6", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DHEAD_CHRSIZ_type };
static KmParameter *_GEANT_DRAWING_DHEAD_parameters[] = {
 &_GEANT_DRAWING_DHEAD_ISEL, &_GEANT_DRAWING_DHEAD_NAME,
 &_GEANT_DRAWING_DHEAD_CHRSIZ };
static char *_GEANT_DRAWING_DHEAD_guidance[] = {
 " CALL GDHEAD(isel,name,chrsiz)", "ISEL =",
 " 0      to have only the header lines",
 " xxxxx1 to add the text name centered on top of header",
 " xxxx1x to add global detector name (first volume) on left",
 " xxx1xx to add date on right",
 " xx1xxx to select thick characters for text on top of header",
 " x1xxxx to add the text 'EVENT NR x' on top of header",
 " 1xxxxx to add the text 'RUN NR x' on top of header",
 "NOTE that ISEL=x1xxx1 or ISEL=1xxxx1 are illegal choices,",
 "i.e. they generate overwritten text.", "NAME is the title",
 "and CHRSIZ the character size in cm of text name." };
static KmCommand _GEANT_DRAWING_DHEAD = { &_GEANT_DRAWING_MEASURE,
 "/GEANT/DRAWING/DHEAD", "DHEAD", 0, 2, 3, 0, _GEANT_DRAWING_DHEAD_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 13,
 _GEANT_DRAWING_DHEAD_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_DMAN_U_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DMAN_U = { "U", 1,
 "U-coord. (horizontal) of the centre of man", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DMAN_U_type };
static KmParReal   _GEANT_DRAWING_DMAN_V_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DMAN_V = { "V", 1,
 "V-coord. (vertical) of the centre of man", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DMAN_V_type };
static char *_GEANT_DRAWING_DMAN_TYPE_range[] = { "MAN", "WM1", "WM2", "WM3" };
static char *_GEANT_DRAWING_DMAN_TYPE_text[] = { (char*)0, (char*)0, (char*)0,
 (char*)0 };
static KmParOption _GEANT_DRAWING_DMAN_TYPE_type = {
 _GEANT_DRAWING_DMAN_TYPE_text, (int*)0, (int*)0 };
static KmParameter _GEANT_DRAWING_DMAN_TYPE = { "TYPE", 4,
 "Man, Wm1, Wm2, Wm3", "MAN", (char*)0, 8, 4, _GEANT_DRAWING_DMAN_TYPE_range,
 4, _GEANT_DRAWING_DMAN_TYPE_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_DRAWING_DMAN_TYPE_type };
static KmParameter *_GEANT_DRAWING_DMAN_parameters[] = {
 &_GEANT_DRAWING_DMAN_U, &_GEANT_DRAWING_DMAN_V, &_GEANT_DRAWING_DMAN_TYPE };
static char *_GEANT_DRAWING_DMAN_guidance[] = {
 " CALL GDMAN(u,v),CALL GDWMN1(u,v),CALL GDWMN2(u,v),CALL GDWMN2(u,v)",
 "It superimposes the picure of a man or of a woman, chosen among",
 "three different ones, with the same scale factors as the detector",
 "in the current drawing." };
static KmCommand _GEANT_DRAWING_DMAN = { &_GEANT_DRAWING_DHEAD,
 "/GEANT/DRAWING/DMAN", "DMAN", 0, 2, 3, 3, _GEANT_DRAWING_DMAN_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_DRAWING_DMAN_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_DAXIS_X0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DAXIS_X0 = { "X0", 2,
 "X-coord. of axis origin", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DAXIS_X0_type };
static KmParReal   _GEANT_DRAWING_DAXIS_Y0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DAXIS_Y0 = { "Y0", 2,
 "Y-coord. of axis origin", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DAXIS_Y0_type };
static KmParReal   _GEANT_DRAWING_DAXIS_Z0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DAXIS_Z0 = { "Z0", 2,
 "Z-coord. of axis origin", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DAXIS_Z0_type };
static KmParReal   _GEANT_DRAWING_DAXIS_DX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DAXIS_DX = { "DX", 2, "Axis size", (char*)0,
 (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DAXIS_DX_type };
static KmParameter *_GEANT_DRAWING_DAXIS_parameters[] = {
 &_GEANT_DRAWING_DAXIS_X0, &_GEANT_DRAWING_DAXIS_Y0, &_GEANT_DRAWING_DAXIS_Z0,
 &_GEANT_DRAWING_DAXIS_DX };
static char *_GEANT_DRAWING_DAXIS_guidance[] = { " CALL GDAXIS(x0,y0,z0,dx)",
 "This commmand superimposes the axis of the MARS on the",
 "current picture. It is useful for finding immediately the",
 "orientation of the current drawing of the detector in the space." };
static KmCommand _GEANT_DRAWING_DAXIS = { &_GEANT_DRAWING_DMAN,
 "/GEANT/DRAWING/DAXIS", "DAXIS", 0, 2, 4, 4, _GEANT_DRAWING_DAXIS_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_DRAWING_DAXIS_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_DSCALE_U_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DSCALE_U = { "U", 1,
 "U-coord. (horizontal) of the centre of scale", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DSCALE_U_type };
static KmParReal   _GEANT_DRAWING_DSCALE_V_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DSCALE_V = { "V", 1,
 "V-coord. (vertical) of the centre of scale", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DSCALE_V_type };
static KmParameter *_GEANT_DRAWING_DSCALE_parameters[] = {
 &_GEANT_DRAWING_DSCALE_U, &_GEANT_DRAWING_DSCALE_V };
static char *_GEANT_DRAWING_DSCALE_guidance[] = { " CALL GDSCAL(u,v)",
 "It draws a scale centered in U,V." };
static KmCommand _GEANT_DRAWING_DSCALE = { &_GEANT_DRAWING_DAXIS,
 "/GEANT/DRAWING/DSCALE", "DSCALE", 0, 2, 2, 2,
 _GEANT_DRAWING_DSCALE_parameters, 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 2, _GEANT_DRAWING_DSCALE_guidance, 0, (char**)0, 0, (char**)0,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DVECTOR_XVECT = { "XVECT", 5,
 "Vector containing X-coord. (horizontal)", (char*)0, (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_DRAWING_DVECTOR_YVECT = { "YVECT", 5,
 "Vector containing Y-coord. (vertical)", (char*)0, (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_DRAWING_DVECTOR_NPOINT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DVECTOR_NPOINT = { "NPOINT", 6,
 "Number of coord.", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_DVECTOR_NPOINT_type };
static KmParameter *_GEANT_DRAWING_DVECTOR_parameters[] = {
 &_GEANT_DRAWING_DVECTOR_XVECT, &_GEANT_DRAWING_DVECTOR_YVECT,
 &_GEANT_DRAWING_DVECTOR_NPOINT };
static char *_GEANT_DRAWING_DVECTOR_guidance[] = {
 "Draw a polyline of 'npoint' point via",
 "a call to GDRAWV(xvect,yvect,npoint)",
 "where xvect and yvect are two KUIP vectors" };
static KmCommand _GEANT_DRAWING_DVECTOR = { &_GEANT_DRAWING_DSCALE,
 "/GEANT/DRAWING/DVECTOR", "DVECTOR", 0, 2, 3, 3,
 _GEANT_DRAWING_DVECTOR_parameters, 0, 0, gxdraw_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_DRAWING_DVECTOR_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_DTEXT_X0_type = { "0.", "20.", "0.", "20.",
 0 };
static KmParameter _GEANT_DRAWING_DTEXT_X0 = { "X0", 2,
 "X-coord. (horizontal) of text string", "10.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DTEXT_X0_type };
static KmParReal   _GEANT_DRAWING_DTEXT_Y0_type = { "0.", "20.", "0.", "20.",
 0 };
static KmParameter _GEANT_DRAWING_DTEXT_Y0 = { "Y0", 2,
 "Y-coord. (vertical) of text string", "10.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DTEXT_Y0_type };
static KmParameter _GEANT_DRAWING_DTEXT_TEXT = { "TEXT", 4, "Text string",
 "GEANT", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
  (void*)0 };
static KmParReal   _GEANT_DRAWING_DTEXT_SIZE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DTEXT_SIZE = { "SIZE", 4,
 "Character size (cm)", ".5", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DTEXT_SIZE_type };
static KmParReal   _GEANT_DRAWING_DTEXT_ANGLE_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DTEXT_ANGLE = { "ANGLE", 5,
 "Rotation angle (deg)", "0.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DTEXT_ANGLE_type };
static KmParInt    _GEANT_DRAWING_DTEXT_LWID_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DTEXT_LWID = { "LWID", 4, "Line width", "4",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_DTEXT_LWID_type };
static char *_GEANT_DRAWING_DTEXT_CENT_range[] = { "CENT", "LEFT", "RIGH" };
static char *_GEANT_DRAWING_DTEXT_CENT_text[] = { (char*)0, (char*)0, (char*)0
 };
static KmParOption _GEANT_DRAWING_DTEXT_CENT_type = {
 _GEANT_DRAWING_DTEXT_CENT_text, (int*)0, (int*)0 };
static KmParameter _GEANT_DRAWING_DTEXT_CENT = { "CENT", 4,
 "Centering option", "CENT", (char*)0, 8, 3, _GEANT_DRAWING_DTEXT_CENT_range,
 3, _GEANT_DRAWING_DTEXT_CENT_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_DRAWING_DTEXT_CENT_type };
static KmParameter *_GEANT_DRAWING_DTEXT_parameters[] = {
 &_GEANT_DRAWING_DTEXT_X0, &_GEANT_DRAWING_DTEXT_Y0,
 &_GEANT_DRAWING_DTEXT_TEXT, &_GEANT_DRAWING_DTEXT_SIZE,
 &_GEANT_DRAWING_DTEXT_ANGLE, &_GEANT_DRAWING_DTEXT_LWID,
 &_GEANT_DRAWING_DTEXT_CENT };
static char *_GEANT_DRAWING_DTEXT_guidance[] = {
 " CALL GDRAWT(x0,y0,text,size,angle,lwid,opt)",
 "It allows one to draw some text in the current picture.",
 "Now more than 160 colours are available. The text colour",
 "must be set via the command IGSET. The size of the",
 "text will follow the zooming factors in the view banks." };
static KmCommand _GEANT_DRAWING_DTEXT = { &_GEANT_DRAWING_DVECTOR,
 "/GEANT/DRAWING/DTEXT", "DTEXT", 0, 2, 7, 7, _GEANT_DRAWING_DTEXT_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 5,
 _GEANT_DRAWING_DTEXT_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DFSPC_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static char *_GEANT_DRAWING_DFSPC_CSORT_range[] = { "Y", "N", "0", "1" };
static char *_GEANT_DRAWING_DFSPC_CSORT_text[] = { (char*)0, (char*)0,
 (char*)0, (char*)0 };
static KmParOption _GEANT_DRAWING_DFSPC_CSORT_type = {
 _GEANT_DRAWING_DFSPC_CSORT_text, (int*)0, (int*)0 };
static KmParameter _GEANT_DRAWING_DFSPC_CSORT = { "CSORT", 5,
 "Alphabetic sorting flag", "N", (char*)0, 8, 4,
 _GEANT_DRAWING_DFSPC_CSORT_range, 4, _GEANT_DRAWING_DFSPC_CSORT_range,
 (KmParFlag)0, KmTYPE_OPTION, &_GEANT_DRAWING_DFSPC_CSORT_type };
static char *_GEANT_DRAWING_DFSPC_CINTER_range[] = { "I", "B", "0", "1" };
static char *_GEANT_DRAWING_DFSPC_CINTER_text[] = { (char*)0, (char*)0,
 (char*)0, (char*)0 };
static KmParOption _GEANT_DRAWING_DFSPC_CINTER_type = {
 _GEANT_DRAWING_DFSPC_CINTER_text, (int*)0, (int*)0 };
static KmParameter _GEANT_DRAWING_DFSPC_CINTER = { "CINTER", 6,
 "Interactive/Batch version", "I", (char*)0, 8, 4,
 _GEANT_DRAWING_DFSPC_CINTER_range, 4, _GEANT_DRAWING_DFSPC_CINTER_range,
 (KmParFlag)0, KmTYPE_OPTION, &_GEANT_DRAWING_DFSPC_CINTER_type };
static KmParameter *_GEANT_DRAWING_DFSPC_parameters[] = {
 &_GEANT_DRAWING_DFSPC_NAME, &_GEANT_DRAWING_DFSPC_CSORT,
 &_GEANT_DRAWING_DFSPC_CINTER };
static char *_GEANT_DRAWING_DFSPC_guidance[] = {
 " CALL GDFSPC(name,isort,inter)",
 "Same as DSPEC, but it will draw the specifications for all the volumes.",
 "If the alphabetic sorting flag is YES, all pictures will be drawn in\
 ascending", "alphabetic order; isort is set to 1.",
 "If INTERACTIVE, (inter=1), the routine will prompt the user at each plot",
 "before doing a clear screen, otherwise it will clear automatically",
 "the screen before starting a new frame." };
static KmCommand _GEANT_DRAWING_DFSPC = { &_GEANT_DRAWING_DTEXT,
 "/GEANT/DRAWING/DFSPC", "DFSPC", 0, 2, 3, 1, _GEANT_DRAWING_DFSPC_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 7,
 _GEANT_DRAWING_DFSPC_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_D3DSPEC_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_DRAWING_D3DSPEC_TETA3_type = { "0.", "180.", "0.",
 "180.", 0 };
static KmParameter _GEANT_DRAWING_D3DSPEC_TETA3 = { "TETA3", 5, "Theta angle",
 "40.", (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_D3DSPEC_TETA3_type };
static KmParReal   _GEANT_DRAWING_D3DSPEC_PHI3_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_D3DSPEC_PHI3 = { "PHI3", 4, "Phi angle",
 "40.", (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_D3DSPEC_PHI3_type };
static KmParReal   _GEANT_DRAWING_D3DSPEC_PSI3_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_D3DSPEC_PSI3 = { "PSI3", 4, "Psi angle",
 "0.", (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_D3DSPEC_PSI3_type };
static KmParReal   _GEANT_DRAWING_D3DSPEC_U03_type = { "-40.", "40.", "-40.",
 "40.", 0 };
static KmParameter _GEANT_DRAWING_D3DSPEC_U03 = { "U03", 3,
 "U-coord. (horizontal) of volume origin", "10.", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_D3DSPEC_U03_type };
static KmParReal   _GEANT_DRAWING_D3DSPEC_V03_type = { "-40.", "40.", "-40.",
 "40.", 0 };
static KmParameter _GEANT_DRAWING_D3DSPEC_V03 = { "V03", 3,
 "V-coord. (vertical) of volume origin", "10.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_D3DSPEC_V03_type };
static KmParReal   _GEANT_DRAWING_D3DSPEC_ZM3_type = { "0.00001", "10.",
 "0.00001", "10.", 5 };
static KmParameter _GEANT_DRAWING_D3DSPEC_ZM3 = { "ZM3", 3,
 "Zoom factor for current size factors", "1.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_D3DSPEC_ZM3_type };
static KmParameter *_GEANT_DRAWING_D3DSPEC_parameters[] = {
 &_GEANT_DRAWING_D3DSPEC_NAME, &_GEANT_DRAWING_D3DSPEC_TETA3,
 &_GEANT_DRAWING_D3DSPEC_PHI3, &_GEANT_DRAWING_D3DSPEC_PSI3,
 &_GEANT_DRAWING_D3DSPEC_U03, &_GEANT_DRAWING_D3DSPEC_V03,
 &_GEANT_DRAWING_D3DSPEC_ZM3 };
static char *_GEANT_DRAWING_D3DSPEC_guidance[] = {
 "Trough a call to GSPE3D, this command allows one to show",
 "the volume (3D views in real time), together with",
 "its geometrical specifications (if using MOTIF). The 3D drawing will",
 "be performed according the current values of the options HIDE and",
 "SHAD and according the current CVOL clipping parameters for that", "volume."
 };
static KmCommand _GEANT_DRAWING_D3DSPEC = { &_GEANT_DRAWING_DFSPC,
 "/GEANT/DRAWING/D3DSPEC", "D3DSPEC", 0, 2, 7, 1,
 _GEANT_DRAWING_D3DSPEC_parameters, 0, 0, gxdraw_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 6, _GEANT_DRAWING_D3DSPEC_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DSPEC_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_DRAWING_DSPEC_parameters[] = {
 &_GEANT_DRAWING_DSPEC_NAME };
static char *_GEANT_DRAWING_DSPEC_guidance[] = {
 "Trough a call to GDSPEC(name), this command allows one to show three",
 "views of the volume (two cut-views and a 3D view), together with",
 "its geometrical specifications. The 3D drawing will",
 "be performed according the current values of the options HIDE and",
 "SHAD and according the current CVOL clipping parameters for that", "volume."
 };
static KmCommand _GEANT_DRAWING_DSPEC = { &_GEANT_DRAWING_D3DSPEC,
 "/GEANT/DRAWING/DSPEC", "DSPEC", 0, 2, 1, 1, _GEANT_DRAWING_DSPEC_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 6,
 _GEANT_DRAWING_DSPEC_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DTREE_NAME = { "NAME", 4, "Volume name",
 " ", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParInt    _GEANT_DRAWING_DTREE_LEVMAX_type = { "-15", "15", "-15",
 "15", 0 };
static KmParameter _GEANT_DRAWING_DTREE_LEVMAX = { "LEVMAX", 6, "Depth level",
 "3", (char*)0, 3, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_DTREE_LEVMAX_type };
static KmParInt    _GEANT_DRAWING_DTREE_ISELT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DTREE_ISELT = { "ISELT", 5, "Options    ",
 "111", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_DTREE_ISELT_type };
static KmParameter *_GEANT_DRAWING_DTREE_parameters[] = {
 &_GEANT_DRAWING_DTREE_NAME, &_GEANT_DRAWING_DTREE_LEVMAX,
 &_GEANT_DRAWING_DTREE_ISELT };
static char *_GEANT_DRAWING_DTREE_guidance[] = {
 "This command allows the drawing of the logical tree,",
 "displaying the name, the multiplicity and other information about the\
 volumes,", "via a call to GDTREE(name,levmax,isel):",
 "if the third parameter is not given (default), the command will",
 "produce the drawing of the tree displaying, for each volume, the",
 "number of the following levels (red arrows) and of the preceeding",
 "levels (green arrows); then the control is automatically given to the",
 "mouse: clicking on the left button when the cursor is inside a volume's",
 "pave will perform a DSPEC for that volume; doing the same when the cursor",
 "is on a red arrow, will perform a DTREE for the relative volume (the",
 "number of levels displayed depending on the clicked arrow); doing the",
 "same for the 'i-th' green arrow of a given volume, will perform a DTREE",
 "for its mother-volume staying 'i' levels before.",
 "If running with X-windows, the drawing of the specification (DSPEC)",
 "is performed",
 "in a different window to speed up the scanning of the tree.",
 "Iterating this procedure it is possible to analyse very easily and quickly",
 "any kind of tree. Clicking the right button of the mouse will return",
 "the control to the command mode.", "If the ISELT parameter is given,",
 "then the TREE will work as in the",
 "previous version, with ISELT up to 10001.",
 "The following command will perform a drawing of the tree and give the",
 "control to the user via the mouse:", " EXAMPLE -", " dtree NAME 3" };
static KmCommand _GEANT_DRAWING_DTREE = { &_GEANT_DRAWING_DSPEC,
 "/GEANT/DRAWING/DTREE", "DTREE", 0, 2, 3, 0, _GEANT_DRAWING_DTREE_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 26,
 _GEANT_DRAWING_DTREE_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_BOMB_BOOM_type = { "-10.", "10.", "-10.",
 "10.", 0 };
static KmParameter _GEANT_DRAWING_BOMB_BOOM = { "BOOM", 4,
 " Exploding factor for volumes position ", "0.", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_BOMB_BOOM_type };
static KmParameter *_GEANT_DRAWING_BOMB_parameters[] = {
 &_GEANT_DRAWING_BOMB_BOOM };
static char *_GEANT_DRAWING_BOMB_guidance[] = {
 "To 'explode' the detector. If BOOM is positive (values smaller",
 "than 1. are suggested, but any value is possible)",
 "all the volumes are shifted by a distance",
 "proportional to BOOM along the direction between their centre",
 "and the origin of the MARS; the volumes which are symmetric",
 "with respect to this origin are simply not shown.",
 "BOOM equal to 0 resets the normal mode.",
 "A negative (greater than -1.) value of",
 "BOOM will cause an 'implosion'; for even lower values of BOOM",
 "the volumes' positions will be reflected respect to the origin.",
 "This command can be useful to improve the 3D effect for very",
 "complex detectors. The following commands will make explode the",
 "detector:", " EXAMPLE -", " dopt hide on", " satt * seen 1",
 " draw NAME 40 40 0 10 10 .01 .01", " bomb 1", " next",
 " draw NAME 40 40 0 10 10 .01 .01" };
static KmCommand _GEANT_DRAWING_BOMB = { &_GEANT_DRAWING_DTREE,
 "/GEANT/DRAWING/BOMB", "BOMB", 0, 2, 1, 1, _GEANT_DRAWING_BOMB_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 20,
 _GEANT_DRAWING_BOMB_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_SHIFT_CNVN = { "CNVN", 4,
 " Name of volume to be shifted        ", "*", (char*)0, 20, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_DRAWING_SHIFT_XXXX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_SHIFT_XXXX = { "XXXX", 4,
 " Shift along X axis                  ", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_SHIFT_XXXX_type };
static KmParReal   _GEANT_DRAWING_SHIFT_YYYY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_SHIFT_YYYY = { "YYYY", 4,
 " Shift along Y axis                  ", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_SHIFT_YYYY_type };
static KmParReal   _GEANT_DRAWING_SHIFT_ZZZZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_SHIFT_ZZZZ = { "ZZZZ", 4,
 " Shift along Z axis                  ", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_SHIFT_ZZZZ_type };
static KmParameter *_GEANT_DRAWING_SHIFT_parameters[] = {
 &_GEANT_DRAWING_SHIFT_CNVN, &_GEANT_DRAWING_SHIFT_XXXX,
 &_GEANT_DRAWING_SHIFT_YYYY, &_GEANT_DRAWING_SHIFT_ZZZZ };
static char *_GEANT_DRAWING_SHIFT_guidance[] = {
 "To draw a volume shifted from its initial position when hidden",
 "line removal is ON. It can be useful if you want to extract a",
 "volume or some volumes from the detector to show them more clearly.",
 "The last requested SHIFT for each volume",
 "NAME is performed. Moreover, the SHIFT of",
 "each volume will be performed starting from where its mother has",
 "been shifted, so that it's easier to SHIFT nicely sets",
 "of volumes using the mother-daughter relationships.",
 "If '.' is given as the name of the volume",
 "to be shifted, the shifts for all volumes will be reset.",
 "The following commands will produce the translation along",
 "the Z-axis of the previously drawn volume:", " EXAMPLE -", " dopt hide on",
 " satt * seen -2", " draw NAME 40 40 0 10 10 .01 .01", " shift NAME 0 0 10" };
static KmCommand _GEANT_DRAWING_SHIFT = { &_GEANT_DRAWING_BOMB,
 "/GEANT/DRAWING/SHIFT", "SHIFT", 0, 2, 4, 4, _GEANT_DRAWING_SHIFT_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 17,
 _GEANT_DRAWING_SHIFT_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DXCUT_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_DRAWING_DXCUT_CUTTHE_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DXCUT_CUTTHE = { "CUTTHE", 6,
 "Theta angle of the line normal to cut plane", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DXCUT_CUTTHE_type };
static KmParReal   _GEANT_DRAWING_DXCUT_CUTPHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DXCUT_CUTPHI = { "CUTPHI", 6,
 "Phi angle of the line normal to cut plane", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DXCUT_CUTPHI_type };
static KmParReal   _GEANT_DRAWING_DXCUT_CUTVAL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DXCUT_CUTVAL = { "CUTVAL", 6,
 "Cut plane distance from the origin along the axis", (char*)0, (char*)0, 12,
 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DXCUT_CUTVAL_type };
static KmParReal   _GEANT_DRAWING_DXCUT_THETA_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DXCUT_THETA = { "THETA", 5,
 "Viewing angle theta (for 3D projection)", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DXCUT_THETA_type };
static KmParReal   _GEANT_DRAWING_DXCUT_PHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DXCUT_PHI = { "PHI", 3,
 "Viewing angle phi (for 3D projection)", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DXCUT_PHI_type };
static KmParReal   _GEANT_DRAWING_DXCUT_U0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DXCUT_U0 = { "U0", 2,
 "U-coord. (horizontal) of volume origin", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DXCUT_U0_type };
static KmParReal   _GEANT_DRAWING_DXCUT_V0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DXCUT_V0 = { "V0", 2,
 "V-coord. (vertical) of volume origin", (char*)0, (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DXCUT_V0_type };
static KmParReal   _GEANT_DRAWING_DXCUT_SU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DXCUT_SU = { "SU", 2,
 "Scale factor for U-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DXCUT_SU_type };
static KmParReal   _GEANT_DRAWING_DXCUT_SV_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DXCUT_SV = { "SV", 2,
 "Scale factor for V-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DXCUT_SV_type };
static KmParameter *_GEANT_DRAWING_DXCUT_parameters[] = {
 &_GEANT_DRAWING_DXCUT_NAME, &_GEANT_DRAWING_DXCUT_CUTTHE,
 &_GEANT_DRAWING_DXCUT_CUTPHI, &_GEANT_DRAWING_DXCUT_CUTVAL,
 &_GEANT_DRAWING_DXCUT_THETA, &_GEANT_DRAWING_DXCUT_PHI,
 &_GEANT_DRAWING_DXCUT_U0, &_GEANT_DRAWING_DXCUT_V0, &_GEANT_DRAWING_DXCUT_SU,
 &_GEANT_DRAWING_DXCUT_SV };
static char *_GEANT_DRAWING_DXCUT_guidance[] = {
 " CALL GDRAWX(name,cutthe,cutphi,cutval,theta,phi,u0,v0,su,sv)",
 "The cut plane is normal to the line given by the cut angles",
 "cutthe and cutphi and placed at the distance cutval from the origin.",
 "The resulting picture is seen from the viewing angles theta,phi.",
 "If optional parameters are missing, the current values in /GCDRAW/",
 "are taken." };
static KmCommand _GEANT_DRAWING_DXCUT = { &_GEANT_DRAWING_SHIFT,
 "/GEANT/DRAWING/DXCUT", "DXCUT", 0, 2, 10, 4,
 _GEANT_DRAWING_DXCUT_parameters, 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 6, _GEANT_DRAWING_DXCUT_guidance, 0, (char**)0, 0, (char**)0,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DCUT_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static char *_GEANT_DRAWING_DCUT_CAXIS_range[] = { "X", "Y", "Z" };
static char *_GEANT_DRAWING_DCUT_CAXIS_text[] = { (char*)0, (char*)0, (char*)0
 };
static KmParOption _GEANT_DRAWING_DCUT_CAXIS_type = {
 _GEANT_DRAWING_DCUT_CAXIS_text, (int*)0, (int*)0 };
static KmParameter _GEANT_DRAWING_DCUT_CAXIS = { "CAXIS", 5, "Axis value",
 (char*)0, (char*)0, 8, 3, _GEANT_DRAWING_DCUT_CAXIS_range, 3,
 _GEANT_DRAWING_DCUT_CAXIS_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_DRAWING_DCUT_CAXIS_type };
static KmParReal   _GEANT_DRAWING_DCUT_CUTVAL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCUT_CUTVAL = { "CUTVAL", 6,
 "Cut plane distance from the origin along the axis", (char*)0, (char*)0, 12,
 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DCUT_CUTVAL_type };
static KmParReal   _GEANT_DRAWING_DCUT_U0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCUT_U0 = { "U0", 2,
 "U-coord. (horizontal) of volume origin", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DCUT_U0_type };
static KmParReal   _GEANT_DRAWING_DCUT_V0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCUT_V0 = { "V0", 2,
 "V-coord. (vertical) of volume origin", (char*)0, (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DCUT_V0_type };
static KmParReal   _GEANT_DRAWING_DCUT_SU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCUT_SU = { "SU", 2,
 "Scale factor for U-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DCUT_SU_type };
static KmParReal   _GEANT_DRAWING_DCUT_SV_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCUT_SV = { "SV", 2,
 "Scale factor for V-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DCUT_SV_type };
static KmParameter *_GEANT_DRAWING_DCUT_parameters[] = {
 &_GEANT_DRAWING_DCUT_NAME, &_GEANT_DRAWING_DCUT_CAXIS,
 &_GEANT_DRAWING_DCUT_CUTVAL, &_GEANT_DRAWING_DCUT_U0,
 &_GEANT_DRAWING_DCUT_V0, &_GEANT_DRAWING_DCUT_SU, &_GEANT_DRAWING_DCUT_SV };
static char *_GEANT_DRAWING_DCUT_guidance[] = {
 " CALL GDRAWC(name,iaxis,cutval,u0,v0,su,sv)",
 "The cut plane is normal to caxis (X,Y,Z), corresponding to iaxis (1,2,3),",
 "and placed at the distance cutval from the origin.",
 "The resulting picture is seen from the the same axis.",
 "If optional parameters are missing, the current values in /GCDRAW/",
 "are taken.",
 "When HIDE Mode is ON, it is possible to get the same effect with",
 "the CVOL/BOX command." };
static KmCommand _GEANT_DRAWING_DCUT = { &_GEANT_DRAWING_DXCUT,
 "/GEANT/DRAWING/DCUT", "DCUT", 0, 2, 7, 3, _GEANT_DRAWING_DCUT_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 8,
 _GEANT_DRAWING_DCUT_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DRAWING_DVOLUME_N_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DVOLUME_N = { "N", 1,
 "Number of elements in arrays LNAMES and LNUMBS", "1", (char*)0, 8, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_DVOLUME_N_type };
static KmParameter _GEANT_DRAWING_DVOLUME_NAMNUM = { "NAMNUM", 6,
 "Volume names and numbers (ex. \"NAME1,NR1,NAME2,NR2\")", (char*)0, (char*)0,
 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static char *_GEANT_DRAWING_DVOLUME_CHNRS_range[] = { "MARS", "DRS" };
static char *_GEANT_DRAWING_DVOLUME_CHNRS_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_DRAWING_DVOLUME_CHNRS_type = {
 _GEANT_DRAWING_DVOLUME_CHNRS_text, (int*)0, (int*)0 };
static KmParameter _GEANT_DRAWING_DVOLUME_CHNRS = { "CHNRS", 5,
 "Reference system used", "MARS", (char*)0, 8, 2,
 _GEANT_DRAWING_DVOLUME_CHNRS_range, 2, _GEANT_DRAWING_DVOLUME_CHNRS_range,
 (KmParFlag)0, KmTYPE_OPTION, &_GEANT_DRAWING_DVOLUME_CHNRS_type };
static KmParReal   _GEANT_DRAWING_DVOLUME_THETA_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DVOLUME_THETA = { "THETA", 5,
 "Viewing angle theta (for 3D projection)", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DVOLUME_THETA_type };
static KmParReal   _GEANT_DRAWING_DVOLUME_PHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DVOLUME_PHI = { "PHI", 3,
 "Viewing angle phi (for 3D projection)", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DVOLUME_PHI_type };
static KmParReal   _GEANT_DRAWING_DVOLUME_PSI_type = { "0.", "180.", "0.",
 "180.", 0 };
static KmParameter _GEANT_DRAWING_DVOLUME_PSI = { "PSI", 3,
 "Viewing angle psi (for 2D rotation)", (char*)0, (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DVOLUME_PSI_type };
static KmParReal   _GEANT_DRAWING_DVOLUME_U0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DVOLUME_U0 = { "U0", 2,
 "U-coord. (horizontal) of volume origin", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DVOLUME_U0_type };
static KmParReal   _GEANT_DRAWING_DVOLUME_V0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DVOLUME_V0 = { "V0", 2,
 "V-coord. (vertical) of volume origin", (char*)0, (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DVOLUME_V0_type };
static KmParReal   _GEANT_DRAWING_DVOLUME_SU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DVOLUME_SU = { "SU", 2,
 "Scale factor for U-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DVOLUME_SU_type };
static KmParReal   _GEANT_DRAWING_DVOLUME_SV_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DVOLUME_SV = { "SV", 2,
 "Scale factor for V-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DVOLUME_SV_type };
static KmParameter *_GEANT_DRAWING_DVOLUME_parameters[] = {
 &_GEANT_DRAWING_DVOLUME_N, &_GEANT_DRAWING_DVOLUME_NAMNUM,
 &_GEANT_DRAWING_DVOLUME_CHNRS, &_GEANT_DRAWING_DVOLUME_THETA,
 &_GEANT_DRAWING_DVOLUME_PHI, &_GEANT_DRAWING_DVOLUME_PSI,
 &_GEANT_DRAWING_DVOLUME_U0, &_GEANT_DRAWING_DVOLUME_V0,
 &_GEANT_DRAWING_DVOLUME_SU, &_GEANT_DRAWING_DVOLUME_SV };
static char *_GEANT_DRAWING_DVOLUME_guidance[] = {
 " CALL GDRVOL(n,lnames,lnumbs,nrs,theta,phi,psi,u0,v0,su,sv)",
 "N is the number of levels from the top of the geometry structure",
 "to the volume lnames(n),lnumbs(n) to be drawn.",
 "NAMNUM contain the arrays lnames and lnumbs,",
 "identifying the path, in pairs and separated by commas; for",
 "example (with n=2) :", "'lname(1),lnumbs(1),lname(2),lnumbs(2) '",
 "CHNRS is the name of the reference system used: MARS for MAster Reference",
 "System or DRS for Daughter Reference System.",
 "NRS=0 for MARS or NRS<>0 for DRS",
 "If optional parameters are missing, the current values in /GCDRAW/",
 "are taken." };
static KmCommand _GEANT_DRAWING_DVOLUME = { &_GEANT_DRAWING_DCUT,
 "/GEANT/DRAWING/DVOLUME", "DVOLUME", 0, 2, 10, 3,
 _GEANT_DRAWING_DVOLUME_parameters, 0, 0, gxdraw_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 12, _GEANT_DRAWING_DVOLUME_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_RANG5D_X1MIN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_RANG5D_X1MIN = { "X1MIN", 5,
 "x coordinate min", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_RANG5D_X1MIN_type };
static KmParReal   _GEANT_DRAWING_RANG5D_X1MAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_RANG5D_X1MAX = { "X1MAX", 5,
 "x coordinate max", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_RANG5D_X1MAX_type };
static KmParReal   _GEANT_DRAWING_RANG5D_Y1MIN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_RANG5D_Y1MIN = { "Y1MIN", 5,
 "y coordinate min", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_RANG5D_Y1MIN_type };
static KmParReal   _GEANT_DRAWING_RANG5D_Y1MAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_RANG5D_Y1MAX = { "Y1MAX", 5,
 "y coordinate max", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_RANG5D_Y1MAX_type };
static KmParReal   _GEANT_DRAWING_RANG5D_Z1MIN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_RANG5D_Z1MIN = { "Z1MIN", 5,
 "z coordinate min", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_RANG5D_Z1MIN_type };
static KmParReal   _GEANT_DRAWING_RANG5D_Z1MAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_RANG5D_Z1MAX = { "Z1MAX", 5,
 "z coordinate max", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_RANG5D_Z1MAX_type };
static KmParameter *_GEANT_DRAWING_RANG5D_parameters[] = {
 &_GEANT_DRAWING_RANG5D_X1MIN, &_GEANT_DRAWING_RANG5D_X1MAX,
 &_GEANT_DRAWING_RANG5D_Y1MIN, &_GEANT_DRAWING_RANG5D_Y1MAX,
 &_GEANT_DRAWING_RANG5D_Z1MIN, &_GEANT_DRAWING_RANG5D_Z1MAX };
static char *_GEANT_DRAWING_RANG5D_guidance[] = {
 "It sets the range for the x,y,z variables." };
static KmCommand _GEANT_DRAWING_RANG5D = { &_GEANT_DRAWING_DVOLUME,
 "/GEANT/DRAWING/RANG5D", "RANG5D", 0, 2, 6, 6,
 _GEANT_DRAWING_RANG5D_parameters, 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 1, _GEANT_DRAWING_RANG5D_guidance, 0, (char**)0, 0, (char**)0,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_VAR5D_TSEQTO_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_VAR5D_TSEQTO = { "TSEQTO", 6,
 "total sequential time", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_VAR5D_TSEQTO_type };
static KmParInt    _GEANT_DRAWING_VAR5D_NPROC_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_VAR5D_NPROC = { "NPROC", 5,
 "number of processors", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_VAR5D_NPROC_type };
static KmParInt    _GEANT_DRAWING_VAR5D_NMPTOT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_VAR5D_NMPTOT = { "NMPTOT", 6,
 "number of message passing", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_VAR5D_NMPTOT_type };
static KmParReal   _GEANT_DRAWING_VAR5D_TOTMBY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_VAR5D_TOTMBY = { "TOTMBY", 6,
 "total megabytes transfert", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_VAR5D_TOTMBY_type };
static KmParReal   _GEANT_DRAWING_VAR5D_TSEQ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_VAR5D_TSEQ = { "TSEQ", 4,
 "not parallelized code", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_VAR5D_TSEQ_type };
static KmParReal   _GEANT_DRAWING_VAR5D_TLAT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_VAR5D_TLAT = { "TLAT", 4, "latency time",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_DRAWING_VAR5D_TLAT_type };
static KmParReal   _GEANT_DRAWING_VAR5D_TNET_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_VAR5D_TNET = { "TNET", 4,
 "network speed in Mbytes/sec", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_VAR5D_TNET_type };
static KmParameter *_GEANT_DRAWING_VAR5D_parameters[] = {
 &_GEANT_DRAWING_VAR5D_TSEQTO, &_GEANT_DRAWING_VAR5D_NPROC,
 &_GEANT_DRAWING_VAR5D_NMPTOT, &_GEANT_DRAWING_VAR5D_TOTMBY,
 &_GEANT_DRAWING_VAR5D_TSEQ, &_GEANT_DRAWING_VAR5D_TLAT,
 &_GEANT_DRAWING_VAR5D_TNET };
static char *_GEANT_DRAWING_VAR5D_guidance[] = {
 "It sets the values of the parameters expressed in the formula and",
 "specify which variables must be assumed as x,y,z (setting their value",
 "to 1001,1002,1003, respectively)." };
static KmCommand _GEANT_DRAWING_VAR5D = { &_GEANT_DRAWING_RANG5D,
 "/GEANT/DRAWING/VAR5D", "VAR5D", 0, 2, 7, 7, _GEANT_DRAWING_VAR5D_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_DRAWING_VAR5D_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_SPOT_XLPOS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_SPOT_XLPOS = { "XLPOS", 5,
 "x coordinate of light source", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_SPOT_XLPOS_type };
static KmParReal   _GEANT_DRAWING_SPOT_YLPOS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_SPOT_YLPOS = { "YLPOS", 5,
 "y coordinate of light source", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_SPOT_YLPOS_type };
static KmParReal   _GEANT_DRAWING_SPOT_ZLPOS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_SPOT_ZLPOS = { "ZLPOS", 5,
 "z coordinate of light source", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_SPOT_ZLPOS_type };
static KmParInt    _GEANT_DRAWING_SPOT_INTEN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_SPOT_INTEN = { "INTEN", 5,
 "intensity of light source", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_SPOT_INTEN_type };
static KmParameter *_GEANT_DRAWING_SPOT_parameters[] = {
 &_GEANT_DRAWING_SPOT_XLPOS, &_GEANT_DRAWING_SPOT_YLPOS,
 &_GEANT_DRAWING_SPOT_ZLPOS, &_GEANT_DRAWING_SPOT_INTEN };
static char *_GEANT_DRAWING_SPOT_guidance[] = {
 "This point-like light source can be moved in the space and its intensity",
 "can be changed (INTEN going from 0 to 10) relatively to the ambience light."
 };
static KmCommand _GEANT_DRAWING_SPOT = { &_GEANT_DRAWING_VAR5D,
 "/GEANT/DRAWING/SPOT", "SPOT", 0, 2, 4, 4, _GEANT_DRAWING_SPOT_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_DRAWING_SPOT_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DRAW_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_DRAWING_DRAW_THETA_type = { "0.", "180.", "0.",
 "180.", 0 };
static KmParameter _GEANT_DRAWING_DRAW_THETA = { "THETA", 5,
 "Viewing angle theta (for 3D projection)", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DRAW_THETA_type };
static KmParReal   _GEANT_DRAWING_DRAW_PHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DRAW_PHI = { "PHI", 3,
 "Viewing angle phi (for 3D projection)", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DRAW_PHI_type };
static KmParReal   _GEANT_DRAWING_DRAW_PSI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DRAW_PSI = { "PSI", 3,
 "Viewing angle psi (for 2D rotation)", (char*)0, (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DRAW_PSI_type };
static KmParReal   _GEANT_DRAWING_DRAW_U0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DRAW_U0 = { "U0", 2,
 "U-coord. (horizontal) of volume origin", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DRAW_U0_type };
static KmParReal   _GEANT_DRAWING_DRAW_V0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DRAW_V0 = { "V0", 2,
 "V-coord. (vertical) of volume origin", (char*)0, (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DRAW_V0_type };
static KmParReal   _GEANT_DRAWING_DRAW_SU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DRAW_SU = { "SU", 2,
 "Scale factor for U-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DRAW_SU_type };
static KmParReal   _GEANT_DRAWING_DRAW_SV_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DRAW_SV = { "SV", 2,
 "Scale factor for V-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DRAW_SV_type };
static KmParameter *_GEANT_DRAWING_DRAW_parameters[] = {
 &_GEANT_DRAWING_DRAW_NAME, &_GEANT_DRAWING_DRAW_THETA,
 &_GEANT_DRAWING_DRAW_PHI, &_GEANT_DRAWING_DRAW_PSI, &_GEANT_DRAWING_DRAW_U0,
 &_GEANT_DRAWING_DRAW_V0, &_GEANT_DRAWING_DRAW_SU, &_GEANT_DRAWING_DRAW_SV };
static char *_GEANT_DRAWING_DRAW_guidance[] = {
 " CALL GDRAW(name,theta,phi,psi,u0,v0,su,sv)",
 "If optional parameters are missing, the corresponding values are",
 "taken from the common /GCDRAW/. This command will draw the volumes,",
 "selected with their graphical attributes, set by the SATT",
 "facility. The drawing may be performed with hidden line removal",
 "and with shading effects according to the value of the options HIDE",
 "and SHAD; if the option SHAD is ON, the contour's edges can be",
 "drawn or not. If the option HIDE is ON, the detector can be",
 "exploded (BOMB), clipped with different shapes (CVOL), and some",
 "of its parts can be shifted from their original",
 "position (SHIFT). When HIDE is ON, if",
 "the drawing requires more than the available memory, the program",
 "will evaluate and display the number of missing words",
 "(so that the user can increase the",
 "size of its ZEBRA store). Finally, at the end of each drawing (with HIDE\
 on),", "the program will print messages about the memory used and",
 "statistics on the volumes' visibility.",
 "The following commands will produce the drawing of a green",
 "volume, specified by NAME, without using the hidden line removal",
 "technique, using the hidden line removal technique,",
 "with different linewidth and colour (red), with",
 "solid colour, with shading of surfaces, and without edges.",
 "Finally, some examples are given for the ray-tracing. (A possible",
 "string for the NAME of the volume can be found using the command DTREE).",
 " EXAMPLE -", " satt * seen -2", " satt NAME colo 3",
 " draw NAME 40 40 0 10 10 .01 .01", " next", " dopt hide on",
 " draw NAME 40 40 0 10 10 .01 .01", " next", " satt NAME colo 2",
 " satt NAME lwid 4", " draw NAME 40 40 0 10 10 .01 .01", " next",
 " dopt shad on", " satt * lwid 1", " satt NAME fill 1",
 " draw NAME 40 40 0 10 10 .01 .01", " next", " satt NAME fill 3",
 " draw NAME 40 40 0 10 10 .01 .01", " next", " dopt edge off",
 " draw NAME 40 40 0 10 10 .01 .01", " dopt rayt on", " satt * fill 20",
 " dopt mapp 1", " draw NAME 40 40 0 10 10 .01 .01", " dopt proj pers",
 " persp NAME 500", " draw NAME 40 40 0 10 10 1 1", " valcut 100 100 100",
 " dopt mapp 0", " dopt user on", " satt NAM1 seen 0", " satt NAM2 colo 2",
 " draw NAME 40 40 0 10 10 5 5" };
static KmCommand _GEANT_DRAWING_DRAW = { &_GEANT_DRAWING_SPOT,
 "/GEANT/DRAWING/DRAW", "DRAW", 0, 2, 8, 1, _GEANT_DRAWING_DRAW_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 59,
 _GEANT_DRAWING_DRAW_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_DRAWING_guidance[] = {
 "Drawing commands. These commands allow the visualization in several ways",
 "of the volumes defined in the geometrical data structure. It is possible",
 "to draw the logical tree of volumes belonging to the detector (DTREE),",
 "to show their geometrical specification (DSPEC,DFSPC), to draw them",
 "and their cut views (DRAW, DCUT). Moreover, it is possible to execute",
 "these commands when the hidden line removal option is activated; in",
 "this case, the volumes can be also either translated in the space",
 "(SHIFT), or clipped by boolean operation (CVOL). In addition, it is",
 "possible to fill the surfaces of the volumes",
 "with solid colours when the shading option (SHAD) is activated.",
 "Several tools (ZOOM, LENS) have been developed to zoom detailed parts",
 "of the detectors or to scan physical events as well.",
 "Finally, the command MOVE will allow the rotation, translation and zooming",
 "on real time parts of the detectors or tracks and hits of a simulated\
 event.",
 "Ray-tracing commands. In case the command (DOPT RAYT ON) is executed,",
 "the drawing is performed by the Geant ray-tracing;",
 "automatically, the color is assigned according to the tracking medium of\
 each",
 "volume and the volumes with a density lower/equal than the air are\
 considered",
 "transparent; if the option (USER) is set (ON) (again via the command\
 (DOPT)),",
 "the user can set color and visibility for the desired volumes via the\
 command",
 "(SATT), as usual, relatively to the attributes (COLO) and (SEEN).",
 "The resolution can be set via the command (SATT * FILL VALUE), where\
 (VALUE)",
 "is the ratio between the number of pixels drawn and 20 (user coordinates).",
 "Parallel view and perspective view are possible (DOPT PROJ PARA/PERS); in\
 the",
 "first case, we assume that the first mother volume of the tree is a box\
 with",
 "dimensions 10000 X 10000 X 10000 cm and the view point (infinetely far) is",
 "5000 cm far from the origin along the Z axis of the user coordinates; in\
 the",
 "second case, the distance between the observer and the origin of the world",
 "reference system is set in cm by the command (PERSP NAME VALUE);\
 grand-angle",
 "or telescopic effects can be achieved changing the scale factors in the\
 command", "(DRAW). When the final picture does not occupy the full window,",
 "mapping the space before tracing can speed up the drawing, but can also",
 "produce less precise results; values from 1 to 4 are allowed in the\
 command",
 "(DOPT MAPP VALUE), the mapping being more precise for increasing (VALUE);\
 for",
 "(VALUE = 0) no mapping is performed (therefore max precision and lowest\
 speed).",
 "The command (VALCUT) allows the cutting of the detector by three planes",
 "ortogonal to the x,y,z axis. The attribute (LSTY) can be set by the\
 command",
 "SATT for any desired volume and can assume values from 0 to 7; it\
 determines",
 "the different light processing to be performed for different materials:",
 "0 = dark-matt, 1 = bright-matt, 2 = plastic, 3 = ceramic, 4 =\
 rough-metals,",
 "5 = shiny-metals, 6 = glass, 7 = mirror. The detector is assumed to be in\
 the",
 "dark, the ambient light luminosity is 0.2 for each basic hue (the\
 saturation",
 "is 0.9) and the observer is assumed to have a light source (therefore he\
 will",
 "produce parallel light in the case of parallel view and point-like-source",
 "light in the case of perspective view)." };
static KmMenu _GEANT_DRAWING = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/DRAWING",
 "DRAWING", 2, &_GEANT_DRAWING_DRAW, 45, _GEANT_DRAWING_guidance, 0,
 (char**)0, 0, (char**)0 };
 
static char *_GEANT_CVOL_guidance[] = { "Clipping commands.",
 "The hidden line removal technique is necessary to visualize properly",
 "very complex detectors. At the same time, it can be useful to visualize",
 "the inner elements of a detector in detail. For this purpose, the",
 "commands menu CVOL has been developed: these commands allow",
 "subtractions (via boolean operation) of given shapes from any part of",
 "the detector, therefore showing its inner contents. It is possible",
 "to clip each different volume by means of a different shape (BOX ,",
 "TUBE, CONE, SPHE are available). If '*' is given as the name of the",
 "volume to be clipped, all volumes are clipped by the given shape.",
 "A volume can be clipped at most twice (even by",
 "different shapes); if a volume is explicitely clipped",
 "twice, the '*' will not act on it anymore. Giving '.' as the name",
 "of the volume to be clipped will reset the clipping." };
static KmMenu _GEANT_CVOL = { &_GEANT_DRAWING,  (KmMenu*)0, "/GEANT/CVOL",
 "CVOL", 2, &_GEANT_CVOL_BOX, 14, _GEANT_CVOL_guidance, 0, (char**)0, 0,
 (char**)0 };
 
static char *_GEANT_guidance[] = { "GEANT specific commands." };
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_CVOL, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 1, _GEANT_guidance, 0, (char**)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 950303 );
}
 
 
#ifdef F77_LCASE
#  define gkgcon_ gkgcon
#  define gxgcon_ gxgcon
#endif
 
#ifdef F77_UCASE
#  define gkgcon_ GKGCON
#  define gxgcon_ GXGCON
#endif
 
#ifdef IBM370
#  pragma linkage(GKGCON,FORTRAN)
#  pragma linkage(GXGCON,FORTRAN)
#endif
 
extern void gkgcon_();
extern void gxgcon_();
 
void gkgcon_()
{
 
static KmParInt    _GEANT_GRAPHICS_CONTROL_MAP_COLOR_ICADD_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_MAP_COLOR_ICADD = { "ICADD", 5,
 "Colour table index", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GRAPHICS_CONTROL_MAP_COLOR_ICADD_type };
static KmParInt    _GEANT_GRAPHICS_CONTROL_MAP_COLOR_ICVAL_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_MAP_COLOR_ICVAL = { "ICVAL", 5,
 "Colour table value", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GRAPHICS_CONTROL_MAP_COLOR_ICVAL_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_MAP_COLOR_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_MAP_COLOR_ICADD,
 &_GEANT_GRAPHICS_CONTROL_MAP_COLOR_ICVAL };
static char *_GEANT_GRAPHICS_CONTROL_MAP_COLOR_guidance[] = {
 "Sets the color table LOOKTB(ICADD)=ICVAL.",
 "If ICADD=0 then LOOKTB(1:16) is taken.",
 "If ICVAL is omitted the current value of LOOKTB(ICADD) is shown." };
static KmCommand _GEANT_GRAPHICS_CONTROL_MAP_COLOR = {  (KmCommand*)0,
 "/GEANT/GRAPHICS_CONTROL/MAP_COLOR", "MAP_COLOR", 0, 2, 2, 0,
 _GEANT_GRAPHICS_CONTROL_MAP_COLOR_parameters, 0, 0, gxgcon_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_GRAPHICS_CONTROL_MAP_COLOR_guidance,
 0, (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_GRAPHICS_CONTROL_SPERS_DPERS_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_SPERS_DPERS = { "DPERS", 5,
 "Distance from the origin", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_GRAPHICS_CONTROL_SPERS_DPERS_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_SPERS_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_SPERS_DPERS };
static char *_GEANT_GRAPHICS_CONTROL_SPERS_guidance[] = {
 "Set the variable dpers in /GCDRAW/, representing",
 "the distance from the origin when using option PERSpective." };
static KmCommand _GEANT_GRAPHICS_CONTROL_SPERS = {
 &_GEANT_GRAPHICS_CONTROL_MAP_COLOR, "/GEANT/GRAPHICS_CONTROL/SPERS", "SPERS",
 0, 2, 1, 1, _GEANT_GRAPHICS_CONTROL_SPERS_parameters, 0, 0, gxgcon_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_GRAPHICS_CONTROL_SPERS_guidance, 0, (char**)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_GRAPHICS_CONTROL_SIZE_XSIZE_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_SIZE_XSIZE = { "XSIZE", 5,
 "Size along X", "20.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GRAPHICS_CONTROL_SIZE_XSIZE_type };
static KmParReal   _GEANT_GRAPHICS_CONTROL_SIZE_YSIZE_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_SIZE_YSIZE = { "YSIZE", 5,
 "Size along Y", "20.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GRAPHICS_CONTROL_SIZE_YSIZE_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_SIZE_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_SIZE_XSIZE, &_GEANT_GRAPHICS_CONTROL_SIZE_YSIZE };
static char *_GEANT_GRAPHICS_CONTROL_SIZE_guidance[] = {
 "Set the size of the picture.",
 "On the terminal, the pictures will have the ratio YSIZE/XSIZE, and,",
 "if a metafile is produced, pictures will be YSIZE by XSIZE cm.",
 "This command sets the parameters for the normalisation transformation",
 "number 1 to [0-XSIZE], [0-YSIZE]." };
static KmCommand _GEANT_GRAPHICS_CONTROL_SIZE = {
 &_GEANT_GRAPHICS_CONTROL_SPERS, "/GEANT/GRAPHICS_CONTROL/SIZE", "SIZE", 0, 2,
 2, 0, _GEANT_GRAPHICS_CONTROL_SIZE_parameters, 0, 0, gxgcon_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 5, _GEANT_GRAPHICS_CONTROL_SIZE_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_GRAPHICS_CONTROL_DOPT_IOPT = { "IOPT", 4,
 "Option name", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_DOPT_IVAL = { "IVAL", 4,
 "Option value", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_GRAPHICS_CONTROL_DOPT_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_DOPT_IOPT, &_GEANT_GRAPHICS_CONTROL_DOPT_IVAL };
static char *_GEANT_GRAPHICS_CONTROL_DOPT_guidance[] = {
 " CALL GDOPT(iopt,ival)", "To set/modify the drawing options.",
 "   IOPT   IVAL      Action", "   THRZ    ON       Draw tracks in R vs Z",
 "           OFF (D)  Draw tracks in X,Y,Z", "           180",
 "           360", "   PROJ    PARA (D) Parallel projection",
 "           PERS     Perspective",
 "   TRAK    LINE (D) Trajectory drawn with lines",
 "           POIN       \" \" with markers",
 "   HIDE    ON       Hidden line removal using the CG package",
 "           OFF (D)  No hidden line removal",
 "   SHAD    ON       Fill area and shading of surfaces.",
 "           OFF (D)  Normal hidden line removal.",
 "   RAYT    ON       Ray-tracing on.",
 "           OFF (D)  Ray-tracing off.",
 "   EDGE    OFF      Does not draw contours when shad is on.",
 "           ON  (D)  Normal shading.",
 "   MAPP    1,2,3,4  Mapping before ray-tracing.",
 "           0   (D)  No mapping.",
 "   USER    ON       User graphics options in the raytracing.",
 "           OFF (D)  Automatic graphics options." };
static KmCommand _GEANT_GRAPHICS_CONTROL_DOPT = {
 &_GEANT_GRAPHICS_CONTROL_SIZE, "/GEANT/GRAPHICS_CONTROL/DOPT", "DOPT", 0, 2,
 2, 0, _GEANT_GRAPHICS_CONTROL_DOPT_parameters, 0, 0, gxgcon_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 23, _GEANT_GRAPHICS_CONTROL_DOPT_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_GRAPHICS_CONTROL_NEXT_guidance[] = {
 "Clear screen (start a new picture on graphics file, if opened)." };
static KmCommand _GEANT_GRAPHICS_CONTROL_NEXT = {
 &_GEANT_GRAPHICS_CONTROL_DOPT, "/GEANT/GRAPHICS_CONTROL/NEXT", "NEXT", 0, 2,
 0, 0, (KmParameter**)0, 0, 0, gxgcon_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 1, _GEANT_GRAPHICS_CONTROL_NEXT_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GRAPHICS_CONTROL_LWID_LWIDTH_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_LWID_LWIDTH = { "LWIDTH", 6,
 "Line width code", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GRAPHICS_CONTROL_LWID_LWIDTH_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_LWID_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_LWID_LWIDTH };
static char *_GEANT_GRAPHICS_CONTROL_LWID_guidance[] = {
 " CALL GDLW(-abs(lwidth))" };
static KmCommand _GEANT_GRAPHICS_CONTROL_LWID = {
 &_GEANT_GRAPHICS_CONTROL_NEXT, "/GEANT/GRAPHICS_CONTROL/LWID", "LWID", 0, 2,
 1, 1, _GEANT_GRAPHICS_CONTROL_LWID_parameters, 0, 0, gxgcon_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 1, _GEANT_GRAPHICS_CONTROL_LWID_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GRAPHICS_CONTROL_COLOR_ICOL_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_COLOR_ICOL = { "ICOL", 4,
 "Colour code", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_INT, &_GEANT_GRAPHICS_CONTROL_COLOR_ICOL_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_COLOR_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_COLOR_ICOL };
static char *_GEANT_GRAPHICS_CONTROL_COLOR_guidance[] = {
 " CALL GDCOL(-abs(icol))" };
static KmCommand _GEANT_GRAPHICS_CONTROL_COLOR = {
 &_GEANT_GRAPHICS_CONTROL_LWID, "/GEANT/GRAPHICS_CONTROL/COLOR", "COLOR", 0,
 2, 1, 1, _GEANT_GRAPHICS_CONTROL_COLOR_parameters, 0, 0, gxgcon_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_GRAPHICS_CONTROL_COLOR_guidance, 0, (char**)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_GRAPHICS_CONTROL_SCALE_GSCU_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_SCALE_GSCU = { "GSCU", 4,
 "Scale factor for U-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_GRAPHICS_CONTROL_SCALE_GSCU_type };
static KmParReal   _GEANT_GRAPHICS_CONTROL_SCALE_GSCV_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_SCALE_GSCV = { "GSCV", 4,
 "Scale factor for V-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_GRAPHICS_CONTROL_SCALE_GSCV_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_SCALE_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_SCALE_GSCU, &_GEANT_GRAPHICS_CONTROL_SCALE_GSCV };
static char *_GEANT_GRAPHICS_CONTROL_SCALE_guidance[] = {
 "Change the scale factors GSCU and GSCV in /GCDRAW/." };
static KmCommand _GEANT_GRAPHICS_CONTROL_SCALE = {
 &_GEANT_GRAPHICS_CONTROL_COLOR, "/GEANT/GRAPHICS_CONTROL/SCALE", "SCALE", 0,
 2, 2, 2, _GEANT_GRAPHICS_CONTROL_SCALE_parameters, 0, 0, gxgcon_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_GRAPHICS_CONTROL_SCALE_guidance, 0, (char**)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_GRAPHICS_CONTROL_SATT_NAME = { "NAME", 4,
 "Volume name", "*   ", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_SATT_IOPT = { "IOPT", 4,
 "Name of the attribute to be set", "DEFA", (char*)0, 20, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_GRAPHICS_CONTROL_SATT_IVAL_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_SATT_IVAL = { "IVAL", 4,
 "Value to which the attribute is to be set", "10000", (char*)0, 8, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_GRAPHICS_CONTROL_SATT_IVAL_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_SATT_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_SATT_NAME, &_GEANT_GRAPHICS_CONTROL_SATT_IOPT,
 &_GEANT_GRAPHICS_CONTROL_SATT_IVAL };
static char *_GEANT_GRAPHICS_CONTROL_SATT_guidance[] = {
 " CALL GSATT(name,iopt,ival)", "name='*' stands for all the volumes.",
 "iopt can be chosen among the following :",
 " 'WORK'   0=volume name is inactive for the tracking",
 "          1=volume name is active for the tracking (default)",
 " 'SEEN'   0=volume name is invisible",
 "          1=volume name is visible (default)",
 "         -1=volume invisible with all its descendants in the tree",
 "         -2=volume visible but not its descendants in the tree",
 " 'LSTY'   line style 1,2,3,... (default=1)",
 "          LSTY=7 will produce a very precise approximation for",
 "          revolution bodies.",
 " 'LWID'   line width -7,...,1,2,3,..7 (default=1)",
 "          LWID<0 will act as abs(LWID) was set for the volume",
 "          and for all the levels below it. When SHAD is 'ON', LWID",
 "          represent the linewidth of the scan lines filling the surfaces",
 "          (whereas the FILL value represent their number). Therefore",
 "          tuning this parameter will help to obtain the desired",
 "          quality/performance ratio.",
 " 'COLO'   colour code -166,...,1,2,..166 (default=1)",
 "          n=1=black",
 "          n=2=red;    n=17+m, m=0,25, increasing luminosity according to\
 'm';",
 "          n=3=green;  n=67+m, m=0,25, increasing luminosity according to\
 'm';",
 "          n=4=blue;   n=117+m, m=0,25, increasing luminosity according to\
 'm';",
 "          n=5=yellow; n=42+m, m=0,25, increasing luminosity according to\
 'm';",
 "          n=6=violet; n=142+m, m=0,25, increasing luminosity according to\
 'm';",
 "          n=7=lightblue; n=92+m, m=0,25, increasing luminosity according to\
 'm';", "          colour=n*10+m, m=1,2,...9, will produce the same colour",
 "          as 'n', but with increasing luminosity according to 'm';",
 "          COLO<0 will act as if abs(COLO) was set for the volume",
 "          and for all the levels below it.",
 "          When for a volume the attribute FILL is > 1 (and the",
 "          option SHAD is on), the ABS of its colour code must be < 8",
 "          because an automatic shading of its faces will be",
 "          performed.",
 " 'FILL'   (1992) fill area  -7,...,0,1,...7 (default=0)",
 "          when option SHAD is 'on' the FILL attribute of any",
 "          volume can be set different from 0 (normal drawing);",
 "          if it is set to 1, the faces of such volume will be filled",
 "          with solid colours; if ABS(FILL) is > 1, then a light",
 "          source is placed along the observer line, and the faces of",
 "          such volumes will be painted by colours whose luminosity",
 "          will depend on the amount of light reflected;",
 "          if ABS(FILL) = 1, then it is possible to use all the 166",
 "          colours of the colour table, becouse the automatic shading",
 "          is not performed;",
 "          for increasing values of FILL the drawing will be performed",
 "          with higher and higher resolution improving the quality (the",
 "          number of scan lines used to fill the faces increases with\
 FILL);", "          it is possible to set different values of FILL",
 "          for different volumes, in order to optimize at the same time",
 "          the performance and the quality of the picture;",
 "          FILL<0 will act as if abs(FILL) was set for the volume",
 "          and for all the levels below it.",
 "          This kind of drawing can be saved in 'picture files'",
 "          or in view banks.", "          0=drawing without fill area",
 "          1=faces filled with solid colours and resolution = 6",
 "          2=lowest resolution (very fast)",
 "          3=default resolution", "          4=.................",
 "          5=.................", "          6=.................",
 "          7=max resolution",
 "          Finally, if a coloured background is desired, the FILL",
 "          attribute for the first volume of the tree must be set",
 "          equal to -abs(colo), colo being >0 and <166.",
 " 'SET '   set number associated to volume name",
 " 'DET '   detector number associated to volume name",
 " 'DTYP'   detector type (1,2)" };
static KmCommand _GEANT_GRAPHICS_CONTROL_SATT = {
 &_GEANT_GRAPHICS_CONTROL_SCALE, "/GEANT/GRAPHICS_CONTROL/SATT", "SATT", 0, 2,
 3, 0, _GEANT_GRAPHICS_CONTROL_SATT_parameters, 0, 0, gxgcon_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 70, _GEANT_GRAPHICS_CONTROL_SATT_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_GRAPHICS_CONTROL_SSETVA_RVAL_type = { "-10.", "10.",
 "-10.", "10.", 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_SSETVA_RVAL = { "RVAL", 4,
 "Attribute value", "1.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GRAPHICS_CONTROL_SSETVA_RVAL_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_SSETVA_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_SSETVA_RVAL };
static char *_GEANT_GRAPHICS_CONTROL_SSETVA_guidance[] = {
 "Set current attribute value." };
static KmCommand _GEANT_GRAPHICS_CONTROL_SSETVA = {
 &_GEANT_GRAPHICS_CONTROL_SATT, "/GEANT/GRAPHICS_CONTROL/SSETVA", "SSETVA", 0,
 2, 1, 0, _GEANT_GRAPHICS_CONTROL_SSETVA_parameters, 0, 0, gxgcon_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_GRAPHICS_CONTROL_SSETVA_guidance, 0, (char**)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_GRAPHICS_CONTROL_SSETAT_IOPT = { "IOPT", 4,
 "Attribute name", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_GRAPHICS_CONTROL_SSETAT_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_SSETAT_IOPT };
static char *_GEANT_GRAPHICS_CONTROL_SSETAT_guidance[] = {
 "Set current attribute." };
static KmCommand _GEANT_GRAPHICS_CONTROL_SSETAT = {
 &_GEANT_GRAPHICS_CONTROL_SSETVA, "/GEANT/GRAPHICS_CONTROL/SSETAT", "SSETAT",
 0, 2, 1, 1, _GEANT_GRAPHICS_CONTROL_SSETAT_parameters, 0, 0, gxgcon_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_GRAPHICS_CONTROL_SSETAT_guidance, 0, (char**)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_GRAPHICS_CONTROL_RESETWK_guidance[] = { "CALL GRESWK",
 "It deactivate the previosly activated workstation and reactivate the",
 "default one." };
static KmCommand _GEANT_GRAPHICS_CONTROL_RESETWK = {
 &_GEANT_GRAPHICS_CONTROL_SSETAT, "/GEANT/GRAPHICS_CONTROL/RESETWK",
 "RESETWK", 0, 2, 0, 0, (KmParameter**)0, 0, 0, gxgcon_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_GRAPHICS_CONTROL_RESETWK_guidance,
 0, (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_GRAPHICS_CONTROL_CHANGEWK_guidance[] = { "CALL GCHNWK",
 "It open a new workstation (if not already opened) and activate it",
 "(deactivating the default one)." };
static KmCommand _GEANT_GRAPHICS_CONTROL_CHANGEWK = {
 &_GEANT_GRAPHICS_CONTROL_RESETWK, "/GEANT/GRAPHICS_CONTROL/CHANGEWK",
 "CHANGEWK", 0, 2, 0, 0, (KmParameter**)0, 0, 0, gxgcon_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_GRAPHICS_CONTROL_CHANGEWK_guidance,
 0, (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_GRAPHICS_CONTROL_DCLOSE_guidance[] = { " CALL GDCLOS",
 "It closes the currently open view bank; it must be called after the",
 "end of the drawing to be stored." };
static KmCommand _GEANT_GRAPHICS_CONTROL_DCLOSE = {
 &_GEANT_GRAPHICS_CONTROL_CHANGEWK, "/GEANT/GRAPHICS_CONTROL/DCLOSE",
 "DCLOSE", 0, 2, 0, 0, (KmParameter**)0, 0, 0, gxgcon_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_GRAPHICS_CONTROL_DCLOSE_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GRAPHICS_CONTROL_DELETE_IVIEW_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_DELETE_IVIEW = { "IVIEW", 5,
 "View number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GRAPHICS_CONTROL_DELETE_IVIEW_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_DELETE_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_DELETE_IVIEW };
static char *_GEANT_GRAPHICS_CONTROL_DELETE_guidance[] = {
 " CALL GDELET(iview)", "It deletes a view bank from memory." };
static KmCommand _GEANT_GRAPHICS_CONTROL_DELETE = {
 &_GEANT_GRAPHICS_CONTROL_DCLOSE, "/GEANT/GRAPHICS_CONTROL/DELETE", "DELETE",
 0, 2, 1, 1, _GEANT_GRAPHICS_CONTROL_DELETE_parameters, 0, 0, gxgcon_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_GRAPHICS_CONTROL_DELETE_guidance, 0, (char**)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GRAPHICS_CONTROL_DSHOW_IVIEW_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_DSHOW_IVIEW = { "IVIEW", 5,
 "View number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GRAPHICS_CONTROL_DSHOW_IVIEW_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_DSHOW_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_DSHOW_IVIEW };
static char *_GEANT_GRAPHICS_CONTROL_DSHOW_guidance[] = {
 " CALL GDSHOW(iview)",
 "It shows on the screen the contents of a view bank. It",
 "can be called after a view bank has been closed." };
static KmCommand _GEANT_GRAPHICS_CONTROL_DSHOW = {
 &_GEANT_GRAPHICS_CONTROL_DELETE, "/GEANT/GRAPHICS_CONTROL/DSHOW", "DSHOW", 0,
 2, 1, 0, _GEANT_GRAPHICS_CONTROL_DSHOW_parameters, 0, 0, gxgcon_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_GRAPHICS_CONTROL_DSHOW_guidance, 0, (char**)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GRAPHICS_CONTROL_DOPEN_IVIEW_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_DOPEN_IVIEW = { "IVIEW", 5,
 "View number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GRAPHICS_CONTROL_DOPEN_IVIEW_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_DOPEN_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_DOPEN_IVIEW };
static char *_GEANT_GRAPHICS_CONTROL_DOPEN_guidance[] = {
 " CALL GDOPEN(iview)",
 "When a drawing is very complex and requires a long time to be",
 "executed, it can be useful to store it in a view bank: after a",
 "call to DOPEN and the execution of the drawing (nothing will",
 "appear on the screen), and after a necessary call to DCLOSE,",
 "the contents of the bank can be displayed in a very fast way",
 "through a call to DSHOW; therefore, the detector can be easily",
 "zoomed many times in different ways. Please note that the pictures",
 "with solid colours can now be stored in a view bank or in 'PICTURE FILES'."
 };
static KmCommand _GEANT_GRAPHICS_CONTROL_DOPEN = {
 &_GEANT_GRAPHICS_CONTROL_DSHOW, "/GEANT/GRAPHICS_CONTROL/DOPEN", "DOPEN", 0,
 2, 1, 1, _GEANT_GRAPHICS_CONTROL_DOPEN_parameters, 0, 0, gxgcon_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 9,
 _GEANT_GRAPHICS_CONTROL_DOPEN_guidance, 0, (char**)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_GRAPHICS_CONTROL_guidance[] = {
 "Graphics control commands." };
static KmMenu _GEANT_GRAPHICS_CONTROL = {  (KmMenu*)0,  (KmMenu*)0,
 "/GEANT/GRAPHICS_CONTROL", "GRAPHICS_CONTROL", 2,
 &_GEANT_GRAPHICS_CONTROL_DOPEN, 1, _GEANT_GRAPHICS_CONTROL_guidance, 0,
 (char**)0, 0, (char**)0 };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_GRAPHICS_CONTROL, "/GEANT",
 "GEANT", 1,  (KmCommand*)0, 0, (char**)0, 0, (char**)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 950303 );
}
 
 
#ifdef F77_LCASE
#  define gklist_ gklist
#  define gxlist_ gxlist
#endif
 
#ifdef F77_UCASE
#  define gklist_ GKLIST
#  define gxlist_ GXLIST
#endif
 
#ifdef IBM370
#  pragma linkage(GKLIST,FORTRAN)
#  pragma linkage(GXLIST,FORTRAN)
#endif
 
extern void gklist_();
extern void gxlist_();
 
void gklist_()
{
 
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_1 = { "LRSAVE_1", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_2 = { "LRSAVE_2", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_3 = { "LRSAVE_3", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_4 = { "LRSAVE_4", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_5 = { "LRSAVE_5", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_6 = { "LRSAVE_6", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_7 = { "LRSAVE_7", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_8 = { "LRSAVE_8", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_9 = { "LRSAVE_9", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_10 = { "LRSAVE_10", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_11 = { "LRSAVE_11", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_12 = { "LRSAVE_12", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_13 = { "LRSAVE_13", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_14 = { "LRSAVE_14", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_15 = { "LRSAVE_15", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_16 = { "LRSAVE_16", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_17 = { "LRSAVE_17", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_18 = { "LRSAVE_18", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_19 = { "LRSAVE_19", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_20 = { "LRSAVE_20", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_RSAV_parameters[] = {
 &_GEANT_LISTS_RSAV_LRSAVE_1, &_GEANT_LISTS_RSAV_LRSAVE_2,
 &_GEANT_LISTS_RSAV_LRSAVE_3, &_GEANT_LISTS_RSAV_LRSAVE_4,
 &_GEANT_LISTS_RSAV_LRSAVE_5, &_GEANT_LISTS_RSAV_LRSAVE_6,
 &_GEANT_LISTS_RSAV_LRSAVE_7, &_GEANT_LISTS_RSAV_LRSAVE_8,
 &_GEANT_LISTS_RSAV_LRSAVE_9, &_GEANT_LISTS_RSAV_LRSAVE_10,
 &_GEANT_LISTS_RSAV_LRSAVE_11, &_GEANT_LISTS_RSAV_LRSAVE_12,
 &_GEANT_LISTS_RSAV_LRSAVE_13, &_GEANT_LISTS_RSAV_LRSAVE_14,
 &_GEANT_LISTS_RSAV_LRSAVE_15, &_GEANT_LISTS_RSAV_LRSAVE_16,
 &_GEANT_LISTS_RSAV_LRSAVE_17, &_GEANT_LISTS_RSAV_LRSAVE_18,
 &_GEANT_LISTS_RSAV_LRSAVE_19, &_GEANT_LISTS_RSAV_LRSAVE_20 };
static char *_GEANT_LISTS_RSAV_guidance[] = {
 "The command RSAV is similar to the RSAV data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_RSAV = {  (KmCommand*)0, "/GEANT/LISTS/RSAV",
 "RSAV", 0, 2, 20, 0, _GEANT_LISTS_RSAV_parameters, 0, 0, gxlist_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_LISTS_RSAV_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_RGET_LRGET_1 = { "LRGET_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_2 = { "LRGET_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_3 = { "LRGET_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_4 = { "LRGET_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_5 = { "LRGET_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_6 = { "LRGET_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_7 = { "LRGET_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_8 = { "LRGET_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_9 = { "LRGET_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_10 = { "LRGET_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_11 = { "LRGET_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_12 = { "LRGET_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_13 = { "LRGET_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_14 = { "LRGET_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_15 = { "LRGET_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_16 = { "LRGET_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_17 = { "LRGET_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_18 = { "LRGET_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_19 = { "LRGET_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_20 = { "LRGET_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_RGET_parameters[] = {
 &_GEANT_LISTS_RGET_LRGET_1, &_GEANT_LISTS_RGET_LRGET_2,
 &_GEANT_LISTS_RGET_LRGET_3, &_GEANT_LISTS_RGET_LRGET_4,
 &_GEANT_LISTS_RGET_LRGET_5, &_GEANT_LISTS_RGET_LRGET_6,
 &_GEANT_LISTS_RGET_LRGET_7, &_GEANT_LISTS_RGET_LRGET_8,
 &_GEANT_LISTS_RGET_LRGET_9, &_GEANT_LISTS_RGET_LRGET_10,
 &_GEANT_LISTS_RGET_LRGET_11, &_GEANT_LISTS_RGET_LRGET_12,
 &_GEANT_LISTS_RGET_LRGET_13, &_GEANT_LISTS_RGET_LRGET_14,
 &_GEANT_LISTS_RGET_LRGET_15, &_GEANT_LISTS_RGET_LRGET_16,
 &_GEANT_LISTS_RGET_LRGET_17, &_GEANT_LISTS_RGET_LRGET_18,
 &_GEANT_LISTS_RGET_LRGET_19, &_GEANT_LISTS_RGET_LRGET_20 };
static char *_GEANT_LISTS_RGET_guidance[] = {
 "The command RGET is similar to the RGET data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_RGET = { &_GEANT_LISTS_RSAV,
 "/GEANT/LISTS/RGET", "RGET", 0, 2, 20, 0, _GEANT_LISTS_RGET_parameters, 0, 0,
 gxlist_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_LISTS_RGET_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_STAT_LSTAT_1 = { "LSTAT_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_2 = { "LSTAT_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_3 = { "LSTAT_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_4 = { "LSTAT_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_5 = { "LSTAT_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_6 = { "LSTAT_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_7 = { "LSTAT_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_8 = { "LSTAT_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_9 = { "LSTAT_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_10 = { "LSTAT_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_11 = { "LSTAT_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_12 = { "LSTAT_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_13 = { "LSTAT_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_14 = { "LSTAT_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_15 = { "LSTAT_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_16 = { "LSTAT_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_17 = { "LSTAT_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_18 = { "LSTAT_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_19 = { "LSTAT_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_20 = { "LSTAT_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_STAT_parameters[] = {
 &_GEANT_LISTS_STAT_LSTAT_1, &_GEANT_LISTS_STAT_LSTAT_2,
 &_GEANT_LISTS_STAT_LSTAT_3, &_GEANT_LISTS_STAT_LSTAT_4,
 &_GEANT_LISTS_STAT_LSTAT_5, &_GEANT_LISTS_STAT_LSTAT_6,
 &_GEANT_LISTS_STAT_LSTAT_7, &_GEANT_LISTS_STAT_LSTAT_8,
 &_GEANT_LISTS_STAT_LSTAT_9, &_GEANT_LISTS_STAT_LSTAT_10,
 &_GEANT_LISTS_STAT_LSTAT_11, &_GEANT_LISTS_STAT_LSTAT_12,
 &_GEANT_LISTS_STAT_LSTAT_13, &_GEANT_LISTS_STAT_LSTAT_14,
 &_GEANT_LISTS_STAT_LSTAT_15, &_GEANT_LISTS_STAT_LSTAT_16,
 &_GEANT_LISTS_STAT_LSTAT_17, &_GEANT_LISTS_STAT_LSTAT_18,
 &_GEANT_LISTS_STAT_LSTAT_19, &_GEANT_LISTS_STAT_LSTAT_20 };
static char *_GEANT_LISTS_STAT_guidance[] = {
 "The command STAT is similar to the STAT data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_STAT = { &_GEANT_LISTS_RGET,
 "/GEANT/LISTS/STAT", "STAT", 0, 2, 20, 0, _GEANT_LISTS_STAT_parameters, 0, 0,
 gxlist_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_LISTS_STAT_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_PLOT_LPLOT_1 = { "LPLOT_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_2 = { "LPLOT_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_3 = { "LPLOT_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_4 = { "LPLOT_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_5 = { "LPLOT_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_6 = { "LPLOT_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_7 = { "LPLOT_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_8 = { "LPLOT_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_9 = { "LPLOT_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_10 = { "LPLOT_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_11 = { "LPLOT_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_12 = { "LPLOT_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_13 = { "LPLOT_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_14 = { "LPLOT_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_15 = { "LPLOT_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_16 = { "LPLOT_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_17 = { "LPLOT_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_18 = { "LPLOT_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_19 = { "LPLOT_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_20 = { "LPLOT_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_PLOT_parameters[] = {
 &_GEANT_LISTS_PLOT_LPLOT_1, &_GEANT_LISTS_PLOT_LPLOT_2,
 &_GEANT_LISTS_PLOT_LPLOT_3, &_GEANT_LISTS_PLOT_LPLOT_4,
 &_GEANT_LISTS_PLOT_LPLOT_5, &_GEANT_LISTS_PLOT_LPLOT_6,
 &_GEANT_LISTS_PLOT_LPLOT_7, &_GEANT_LISTS_PLOT_LPLOT_8,
 &_GEANT_LISTS_PLOT_LPLOT_9, &_GEANT_LISTS_PLOT_LPLOT_10,
 &_GEANT_LISTS_PLOT_LPLOT_11, &_GEANT_LISTS_PLOT_LPLOT_12,
 &_GEANT_LISTS_PLOT_LPLOT_13, &_GEANT_LISTS_PLOT_LPLOT_14,
 &_GEANT_LISTS_PLOT_LPLOT_15, &_GEANT_LISTS_PLOT_LPLOT_16,
 &_GEANT_LISTS_PLOT_LPLOT_17, &_GEANT_LISTS_PLOT_LPLOT_18,
 &_GEANT_LISTS_PLOT_LPLOT_19, &_GEANT_LISTS_PLOT_LPLOT_20 };
static char *_GEANT_LISTS_PLOT_guidance[] = {
 "The command PLOT is similar to the PLOT data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_PLOT = { &_GEANT_LISTS_STAT,
 "/GEANT/LISTS/PLOT", "PLOT", 0, 2, 20, 0, _GEANT_LISTS_PLOT_parameters, 0, 0,
 gxlist_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_LISTS_PLOT_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_VIEW_LVIEW_1 = { "LVIEW_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_2 = { "LVIEW_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_3 = { "LVIEW_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_4 = { "LVIEW_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_5 = { "LVIEW_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_6 = { "LVIEW_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_7 = { "LVIEW_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_8 = { "LVIEW_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_9 = { "LVIEW_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_10 = { "LVIEW_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_11 = { "LVIEW_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_12 = { "LVIEW_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_13 = { "LVIEW_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_14 = { "LVIEW_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_15 = { "LVIEW_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_16 = { "LVIEW_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_17 = { "LVIEW_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_18 = { "LVIEW_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_19 = { "LVIEW_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_20 = { "LVIEW_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_VIEW_parameters[] = {
 &_GEANT_LISTS_VIEW_LVIEW_1, &_GEANT_LISTS_VIEW_LVIEW_2,
 &_GEANT_LISTS_VIEW_LVIEW_3, &_GEANT_LISTS_VIEW_LVIEW_4,
 &_GEANT_LISTS_VIEW_LVIEW_5, &_GEANT_LISTS_VIEW_LVIEW_6,
 &_GEANT_LISTS_VIEW_LVIEW_7, &_GEANT_LISTS_VIEW_LVIEW_8,
 &_GEANT_LISTS_VIEW_LVIEW_9, &_GEANT_LISTS_VIEW_LVIEW_10,
 &_GEANT_LISTS_VIEW_LVIEW_11, &_GEANT_LISTS_VIEW_LVIEW_12,
 &_GEANT_LISTS_VIEW_LVIEW_13, &_GEANT_LISTS_VIEW_LVIEW_14,
 &_GEANT_LISTS_VIEW_LVIEW_15, &_GEANT_LISTS_VIEW_LVIEW_16,
 &_GEANT_LISTS_VIEW_LVIEW_17, &_GEANT_LISTS_VIEW_LVIEW_18,
 &_GEANT_LISTS_VIEW_LVIEW_19, &_GEANT_LISTS_VIEW_LVIEW_20 };
static char *_GEANT_LISTS_VIEW_guidance[] = {
 "The command VIEW is similar to the VIEW data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_VIEW = { &_GEANT_LISTS_PLOT,
 "/GEANT/LISTS/VIEW", "VIEW", 0, 2, 20, 0, _GEANT_LISTS_VIEW_parameters, 0, 0,
 gxlist_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_LISTS_VIEW_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_GEOM_LGEOM_1 = { "LGEOM_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_2 = { "LGEOM_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_3 = { "LGEOM_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_4 = { "LGEOM_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_5 = { "LGEOM_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_6 = { "LGEOM_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_7 = { "LGEOM_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_8 = { "LGEOM_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_9 = { "LGEOM_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_10 = { "LGEOM_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_11 = { "LGEOM_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_12 = { "LGEOM_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_13 = { "LGEOM_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_14 = { "LGEOM_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_15 = { "LGEOM_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_16 = { "LGEOM_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_17 = { "LGEOM_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_18 = { "LGEOM_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_19 = { "LGEOM_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_20 = { "LGEOM_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_GEOM_parameters[] = {
 &_GEANT_LISTS_GEOM_LGEOM_1, &_GEANT_LISTS_GEOM_LGEOM_2,
 &_GEANT_LISTS_GEOM_LGEOM_3, &_GEANT_LISTS_GEOM_LGEOM_4,
 &_GEANT_LISTS_GEOM_LGEOM_5, &_GEANT_LISTS_GEOM_LGEOM_6,
 &_GEANT_LISTS_GEOM_LGEOM_7, &_GEANT_LISTS_GEOM_LGEOM_8,
 &_GEANT_LISTS_GEOM_LGEOM_9, &_GEANT_LISTS_GEOM_LGEOM_10,
 &_GEANT_LISTS_GEOM_LGEOM_11, &_GEANT_LISTS_GEOM_LGEOM_12,
 &_GEANT_LISTS_GEOM_LGEOM_13, &_GEANT_LISTS_GEOM_LGEOM_14,
 &_GEANT_LISTS_GEOM_LGEOM_15, &_GEANT_LISTS_GEOM_LGEOM_16,
 &_GEANT_LISTS_GEOM_LGEOM_17, &_GEANT_LISTS_GEOM_LGEOM_18,
 &_GEANT_LISTS_GEOM_LGEOM_19, &_GEANT_LISTS_GEOM_LGEOM_20 };
static char *_GEANT_LISTS_GEOM_guidance[] = {
 "The command GEOM is similar to the GEOM data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_GEOM = { &_GEANT_LISTS_VIEW,
 "/GEANT/LISTS/GEOM", "GEOM", 0, 2, 20, 0, _GEANT_LISTS_GEOM_parameters, 0, 0,
 gxlist_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_LISTS_GEOM_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_1 = { "LPRIN_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_2 = { "LPRIN_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_3 = { "LPRIN_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_4 = { "LPRIN_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_5 = { "LPRIN_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_6 = { "LPRIN_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_7 = { "LPRIN_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_8 = { "LPRIN_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_9 = { "LPRIN_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_10 = { "LPRIN_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_11 = { "LPRIN_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_12 = { "LPRIN_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_13 = { "LPRIN_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_14 = { "LPRIN_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_15 = { "LPRIN_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_16 = { "LPRIN_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_17 = { "LPRIN_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_18 = { "LPRIN_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_19 = { "LPRIN_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_20 = { "LPRIN_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_LPRIN_parameters[] = {
 &_GEANT_LISTS_LPRIN_LPRIN_1, &_GEANT_LISTS_LPRIN_LPRIN_2,
 &_GEANT_LISTS_LPRIN_LPRIN_3, &_GEANT_LISTS_LPRIN_LPRIN_4,
 &_GEANT_LISTS_LPRIN_LPRIN_5, &_GEANT_LISTS_LPRIN_LPRIN_6,
 &_GEANT_LISTS_LPRIN_LPRIN_7, &_GEANT_LISTS_LPRIN_LPRIN_8,
 &_GEANT_LISTS_LPRIN_LPRIN_9, &_GEANT_LISTS_LPRIN_LPRIN_10,
 &_GEANT_LISTS_LPRIN_LPRIN_11, &_GEANT_LISTS_LPRIN_LPRIN_12,
 &_GEANT_LISTS_LPRIN_LPRIN_13, &_GEANT_LISTS_LPRIN_LPRIN_14,
 &_GEANT_LISTS_LPRIN_LPRIN_15, &_GEANT_LISTS_LPRIN_LPRIN_16,
 &_GEANT_LISTS_LPRIN_LPRIN_17, &_GEANT_LISTS_LPRIN_LPRIN_18,
 &_GEANT_LISTS_LPRIN_LPRIN_19, &_GEANT_LISTS_LPRIN_LPRIN_20 };
static char *_GEANT_LISTS_LPRIN_guidance[] = {
 "The command PRIN is similar to the PRIN data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_LPRIN = { &_GEANT_LISTS_GEOM,
 "/GEANT/LISTS/LPRIN", "LPRIN", 0, 2, 20, 0, _GEANT_LISTS_LPRIN_parameters, 0,
 0, gxlist_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_LISTS_LPRIN_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_SETS_LSETS_1 = { "LSETS_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_2 = { "LSETS_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_3 = { "LSETS_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_4 = { "LSETS_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_5 = { "LSETS_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_6 = { "LSETS_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_7 = { "LSETS_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_8 = { "LSETS_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_9 = { "LSETS_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_10 = { "LSETS_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_11 = { "LSETS_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_12 = { "LSETS_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_13 = { "LSETS_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_14 = { "LSETS_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_15 = { "LSETS_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_16 = { "LSETS_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_17 = { "LSETS_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_18 = { "LSETS_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_19 = { "LSETS_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_20 = { "LSETS_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_SETS_parameters[] = {
 &_GEANT_LISTS_SETS_LSETS_1, &_GEANT_LISTS_SETS_LSETS_2,
 &_GEANT_LISTS_SETS_LSETS_3, &_GEANT_LISTS_SETS_LSETS_4,
 &_GEANT_LISTS_SETS_LSETS_5, &_GEANT_LISTS_SETS_LSETS_6,
 &_GEANT_LISTS_SETS_LSETS_7, &_GEANT_LISTS_SETS_LSETS_8,
 &_GEANT_LISTS_SETS_LSETS_9, &_GEANT_LISTS_SETS_LSETS_10,
 &_GEANT_LISTS_SETS_LSETS_11, &_GEANT_LISTS_SETS_LSETS_12,
 &_GEANT_LISTS_SETS_LSETS_13, &_GEANT_LISTS_SETS_LSETS_14,
 &_GEANT_LISTS_SETS_LSETS_15, &_GEANT_LISTS_SETS_LSETS_16,
 &_GEANT_LISTS_SETS_LSETS_17, &_GEANT_LISTS_SETS_LSETS_18,
 &_GEANT_LISTS_SETS_LSETS_19, &_GEANT_LISTS_SETS_LSETS_20 };
static char *_GEANT_LISTS_SETS_guidance[] = {
 "The command SETS is similar to the SETS data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_SETS = { &_GEANT_LISTS_LPRIN,
 "/GEANT/LISTS/SETS", "SETS", 0, 2, 20, 0, _GEANT_LISTS_SETS_parameters, 0, 0,
 gxlist_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_LISTS_SETS_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_SAVE_LSAVE_1 = { "LSAVE_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_2 = { "LSAVE_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_3 = { "LSAVE_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_4 = { "LSAVE_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_5 = { "LSAVE_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_6 = { "LSAVE_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_7 = { "LSAVE_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_8 = { "LSAVE_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_9 = { "LSAVE_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_10 = { "LSAVE_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_11 = { "LSAVE_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_12 = { "LSAVE_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_13 = { "LSAVE_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_14 = { "LSAVE_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_15 = { "LSAVE_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_16 = { "LSAVE_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_17 = { "LSAVE_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_18 = { "LSAVE_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_19 = { "LSAVE_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_20 = { "LSAVE_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_SAVE_parameters[] = {
 &_GEANT_LISTS_SAVE_LSAVE_1, &_GEANT_LISTS_SAVE_LSAVE_2,
 &_GEANT_LISTS_SAVE_LSAVE_3, &_GEANT_LISTS_SAVE_LSAVE_4,
 &_GEANT_LISTS_SAVE_LSAVE_5, &_GEANT_LISTS_SAVE_LSAVE_6,
 &_GEANT_LISTS_SAVE_LSAVE_7, &_GEANT_LISTS_SAVE_LSAVE_8,
 &_GEANT_LISTS_SAVE_LSAVE_9, &_GEANT_LISTS_SAVE_LSAVE_10,
 &_GEANT_LISTS_SAVE_LSAVE_11, &_GEANT_LISTS_SAVE_LSAVE_12,
 &_GEANT_LISTS_SAVE_LSAVE_13, &_GEANT_LISTS_SAVE_LSAVE_14,
 &_GEANT_LISTS_SAVE_LSAVE_15, &_GEANT_LISTS_SAVE_LSAVE_16,
 &_GEANT_LISTS_SAVE_LSAVE_17, &_GEANT_LISTS_SAVE_LSAVE_18,
 &_GEANT_LISTS_SAVE_LSAVE_19, &_GEANT_LISTS_SAVE_LSAVE_20 };
static char *_GEANT_LISTS_SAVE_guidance[] = {
 "The command SAVE is similar to the SAVE data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_SAVE = { &_GEANT_LISTS_SETS,
 "/GEANT/LISTS/SAVE", "SAVE", 0, 2, 20, 0, _GEANT_LISTS_SAVE_parameters, 0, 0,
 gxlist_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_LISTS_SAVE_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_GET_LGET_1 = { "LGET_1", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_2 = { "LGET_2", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_3 = { "LGET_3", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_4 = { "LGET_4", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_5 = { "LGET_5", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_6 = { "LGET_6", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_7 = { "LGET_7", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_8 = { "LGET_8", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_9 = { "LGET_9", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_10 = { "LGET_10", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_11 = { "LGET_11", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_12 = { "LGET_12", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_13 = { "LGET_13", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_14 = { "LGET_14", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_15 = { "LGET_15", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_16 = { "LGET_16", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_17 = { "LGET_17", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_18 = { "LGET_18", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_19 = { "LGET_19", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_20 = { "LGET_20", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_GET_parameters[] = {
 &_GEANT_LISTS_GET_LGET_1, &_GEANT_LISTS_GET_LGET_2, &_GEANT_LISTS_GET_LGET_3,
 &_GEANT_LISTS_GET_LGET_4, &_GEANT_LISTS_GET_LGET_5, &_GEANT_LISTS_GET_LGET_6,
 &_GEANT_LISTS_GET_LGET_7, &_GEANT_LISTS_GET_LGET_8, &_GEANT_LISTS_GET_LGET_9,
 &_GEANT_LISTS_GET_LGET_10, &_GEANT_LISTS_GET_LGET_11,
 &_GEANT_LISTS_GET_LGET_12, &_GEANT_LISTS_GET_LGET_13,
 &_GEANT_LISTS_GET_LGET_14, &_GEANT_LISTS_GET_LGET_15,
 &_GEANT_LISTS_GET_LGET_16, &_GEANT_LISTS_GET_LGET_17,
 &_GEANT_LISTS_GET_LGET_18, &_GEANT_LISTS_GET_LGET_19,
 &_GEANT_LISTS_GET_LGET_20 };
static char *_GEANT_LISTS_GET_guidance[] = {
 "The command GET is similar to the GET data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_GET = { &_GEANT_LISTS_SAVE, "/GEANT/LISTS/GET",
 "GET", 0, 2, 20, 0, _GEANT_LISTS_GET_parameters, 0, 0, gxlist_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_LISTS_GET_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_HSTA_LHSTA_1 = { "LHSTA_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_2 = { "LHSTA_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_3 = { "LHSTA_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_4 = { "LHSTA_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_5 = { "LHSTA_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_6 = { "LHSTA_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_7 = { "LHSTA_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_8 = { "LHSTA_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_9 = { "LHSTA_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_10 = { "LHSTA_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_11 = { "LHSTA_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_12 = { "LHSTA_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_13 = { "LHSTA_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_14 = { "LHSTA_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_15 = { "LHSTA_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_16 = { "LHSTA_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_17 = { "LHSTA_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_18 = { "LHSTA_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_19 = { "LHSTA_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_20 = { "LHSTA_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_HSTA_parameters[] = {
 &_GEANT_LISTS_HSTA_LHSTA_1, &_GEANT_LISTS_HSTA_LHSTA_2,
 &_GEANT_LISTS_HSTA_LHSTA_3, &_GEANT_LISTS_HSTA_LHSTA_4,
 &_GEANT_LISTS_HSTA_LHSTA_5, &_GEANT_LISTS_HSTA_LHSTA_6,
 &_GEANT_LISTS_HSTA_LHSTA_7, &_GEANT_LISTS_HSTA_LHSTA_8,
 &_GEANT_LISTS_HSTA_LHSTA_9, &_GEANT_LISTS_HSTA_LHSTA_10,
 &_GEANT_LISTS_HSTA_LHSTA_11, &_GEANT_LISTS_HSTA_LHSTA_12,
 &_GEANT_LISTS_HSTA_LHSTA_13, &_GEANT_LISTS_HSTA_LHSTA_14,
 &_GEANT_LISTS_HSTA_LHSTA_15, &_GEANT_LISTS_HSTA_LHSTA_16,
 &_GEANT_LISTS_HSTA_LHSTA_17, &_GEANT_LISTS_HSTA_LHSTA_18,
 &_GEANT_LISTS_HSTA_LHSTA_19, &_GEANT_LISTS_HSTA_LHSTA_20 };
static char *_GEANT_LISTS_HSTA_guidance[] = {
 "The command HSTA is similar to the HSTA data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_HSTA = { &_GEANT_LISTS_GET, "/GEANT/LISTS/HSTA",
 "HSTA", 0, 2, 20, 0, _GEANT_LISTS_HSTA_parameters, 0, 0, gxlist_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_LISTS_HSTA_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmMenu _GEANT_LISTS = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/LISTS",
 "LISTS", 2, &_GEANT_LISTS_HSTA, 0, (char**)0, 0, (char**)0, 0, (char**)0 };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_LISTS, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 0, (char**)0, 0, (char**)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 950303 );
}
 
 
#ifdef F77_LCASE
#  define gkgeom_ gkgeom
#  define gxgeom_ gxgeom
#endif
 
#ifdef F77_UCASE
#  define gkgeom_ GKGEOM
#  define gxgeom_ GXGEOM
#endif
 
#ifdef IBM370
#  pragma linkage(GKGEOM,FORTRAN)
#  pragma linkage(GXGEOM,FORTRAN)
#endif
 
extern void gkgeom_();
extern void gxgeom_();
 
void gkgeom_()
{
 
static KmParInt    _GEANT_GEOMETRY_WEUCLID_LUN_type = { "1", "100", "1",
 "100", 0 };
static KmParameter _GEANT_GEOMETRY_WEUCLID_LUN = { "LUN", 3,
 "Logical unit of the file to be written", (char*)0, (char*)0, 4, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_GEOMETRY_WEUCLID_LUN_type };
static KmParameter _GEANT_GEOMETRY_WEUCLID_FNAME = { "FNAME", 5,
 "Name of the EUCLID file to be written", (char*)0, (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GEOMETRY_WEUCLID_TOPVOL = { "TOPVOL", 6,
 "Volume name of the starting node", (char*)0, (char*)0, 20, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_GEOMETRY_WEUCLID_NUMBER_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_WEUCLID_NUMBER = { "NUMBER", 6,
 "Copy number of TOPVOL (relevant for GSPOSP)", "1", (char*)0, 8, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_GEOMETRY_WEUCLID_NUMBER_type };
static KmParInt    _GEANT_GEOMETRY_WEUCLID_NLEVEL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_WEUCLID_NLEVEL = { "NLEVEL", 6,
 "Number of levels in the tree structure", "15", (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_WEUCLID_NLEVEL_type };
static KmParameter *_GEANT_GEOMETRY_WEUCLID_parameters[] = {
 &_GEANT_GEOMETRY_WEUCLID_LUN, &_GEANT_GEOMETRY_WEUCLID_FNAME,
 &_GEANT_GEOMETRY_WEUCLID_TOPVOL, &_GEANT_GEOMETRY_WEUCLID_NUMBER,
 &_GEANT_GEOMETRY_WEUCLID_NLEVEL };
static char *_GEANT_GEOMETRY_WEUCLID_guidance[] = {
 "          CALL GWEUCL(LUN,FNAME)",
 "Calls the routine to write the current GEANT geometry into an ASCII file",
 "in EUCLID compatible format." };
static KmCommand _GEANT_GEOMETRY_WEUCLID = {  (KmCommand*)0,
 "/GEANT/GEOMETRY/WEUCLID", "WEUCLID", 0, 2, 5, 3,
 _GEANT_GEOMETRY_WEUCLID_parameters, 0, 0, gxgeom_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_GEOMETRY_WEUCLID_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GEOMETRY_REUCLID_LUN_type = { "1", "100", "1",
 "100", 0 };
static KmParameter _GEANT_GEOMETRY_REUCLID_LUN = { "LUN", 3,
 "Logical unit of the file to be read", (char*)0, (char*)0, 4, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_REUCLID_LUN_type };
static KmParameter _GEANT_GEOMETRY_REUCLID_FNAME = { "FNAME", 5,
 "Name of the EUCLID file to be read", (char*)0, (char*)0, 20, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_GEOMETRY_REUCLID_parameters[] = {
 &_GEANT_GEOMETRY_REUCLID_LUN, &_GEANT_GEOMETRY_REUCLID_FNAME };
static char *_GEANT_GEOMETRY_REUCLID_guidance[] = {
 "          CALL GREUCL(LUN,FNAME)",
 "Calls the routine to read into GEANT a geometry from an ASCII file",
 "written by the EUCLID-GEANT interface." };
static KmCommand _GEANT_GEOMETRY_REUCLID = { &_GEANT_GEOMETRY_WEUCLID,
 "/GEANT/GEOMETRY/REUCLID", "REUCLID", 0, 2, 2, 2,
 _GEANT_GEOMETRY_REUCLID_parameters, 0, 0, gxgeom_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_GEOMETRY_REUCLID_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_GEOMETRY_CADINT_FNAME = { "FNAME", 5,
 "Name of the SET file", "example.set", (char*)0, 20, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GEOMETRY_CADINT_ANAME = { "ANAME", 5,
 "Name of the volume", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_GEOMETRY_CADINT_NBINS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_CADINT_NBINS = { "NBINS", 5,
 "Number of the instances", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_CADINT_NBINS_type };
static KmParInt    _GEANT_GEOMETRY_CADINT_LUNIT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_CADINT_LUNIT = { "LUNIT", 5,
 "Logical unit number for SET file", "66", (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_CADINT_LUNIT_type };
static KmParInt    _GEANT_GEOMETRY_CADINT_LUNIT2_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_CADINT_LUNIT2 = { "LUNIT2", 6,
 "Logical unit number for material file", "67", (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_CADINT_LUNIT2_type };
static KmParameter _GEANT_GEOMETRY_CADINT_INST = { "INST", 4,
 "Name of your institute", "CERN", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GEOMETRY_CADINT_SITE = { "SITE", 4, "Name of site",
 "MEYRIN", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GEOMETRY_CADINT_DEPT = { "DEPT", 4,
 "Name of departement", "CN", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GEOMETRY_CADINT_RESP = { "RESP", 4,
 "Name of sender", "god_knows_who", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_GEOMETRY_CADINT_parameters[] = {
 &_GEANT_GEOMETRY_CADINT_FNAME, &_GEANT_GEOMETRY_CADINT_ANAME,
 &_GEANT_GEOMETRY_CADINT_NBINS, &_GEANT_GEOMETRY_CADINT_LUNIT,
 &_GEANT_GEOMETRY_CADINT_LUNIT2, &_GEANT_GEOMETRY_CADINT_INST,
 &_GEANT_GEOMETRY_CADINT_SITE, &_GEANT_GEOMETRY_CADINT_DEPT,
 &_GEANT_GEOMETRY_CADINT_RESP };
static char *_GEANT_GEOMETRY_CADINT_guidance[] = {
 " CALL GTXSET(fname,aname,nbins,lunit,lunit2,inst,site,dept,resp)",
 "This command produces a SET file describing the given volume with",
 "the contents currently set visible. (Use the visibility attribute,",
 "see SATT SEEN.) The description is given as a flat assembly",
 "related to the global coordinate system.",
 "The ouput can be read into CAD systems (EUCLID-IS) trough a SET interface.",
 "A list of materials of the volumes in the SET file and the GEANT tree",
 "is written into a file with the same filename as the SET file,",
 "but with extension .mat." };
static KmCommand _GEANT_GEOMETRY_CADINT = { &_GEANT_GEOMETRY_REUCLID,
 "/GEANT/GEOMETRY/CADINT", "CADINT", 0, 2, 9, 9,
 _GEANT_GEOMETRY_CADINT_parameters, 0, 0, gxgeom_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 9, _GEANT_GEOMETRY_CADINT_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GEOMETRY_EDITV_ISEL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_EDITV_ISEL = { "ISEL", 4, "Options", "0",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_GEOMETRY_EDITV_ISEL_type };
static KmParameter _GEANT_GEOMETRY_EDITV_NAME = { "NAME", 4, "Volume name",
 "   ", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParameter *_GEANT_GEOMETRY_EDITV_parameters[] = {
 &_GEANT_GEOMETRY_EDITV_ISEL, &_GEANT_GEOMETRY_EDITV_NAME };
static char *_GEANT_GEOMETRY_EDITV_guidance[] = { " CALL GEDITV(isel,name)",
 "When the routine prompts for input parameters that do not need",
 "to be changed, type return.",
 "ISEL is used to select the editing operation to be performed:",
 " ISEL=0, CALL GGCLOS",
 " ISEL=1, to modify shape parameters PAR given by GSVOLU",
 " ISEL=2, to modify NAME given by GSVOLU",
 " ISEL=3, to delete NAME given by GSVOLU",
 " ISEL=4, to unlink NAME,NR given by GSPOS/GSDVN/GSDV..",
 " ISEL=5, to modify X0,Y0,Z0 of NAME,NR given by GSPOS",
 " ISEL=6, to modify IROT of NAME,NR given by GSPOS",
 " ISEL=7, to modify NDIV given by GSDVN",
 " ISEL=8, to modify IAXIS given by GSDVN" };
static KmCommand _GEANT_GEOMETRY_EDITV = { &_GEANT_GEOMETRY_CADINT,
 "/GEANT/GEOMETRY/EDITV", "EDITV", 0, 2, 2, 0,
 _GEANT_GEOMETRY_EDITV_parameters, 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 13, _GEANT_GEOMETRY_EDITV_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GEOMETRY_PTMED_NUMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_PTMED_NUMB = { "NUMB", 4, "Medium ID",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_GEOMETRY_PTMED_NUMB_type };
static KmParameter *_GEANT_GEOMETRY_PTMED_parameters[] = {
 &_GEANT_GEOMETRY_PTMED_NUMB };
static char *_GEANT_GEOMETRY_PTMED_guidance[] = { " CALL GPTMED(numb)",
 "Print tracking media's specifications." };
static KmCommand _GEANT_GEOMETRY_PTMED = { &_GEANT_GEOMETRY_EDITV,
 "/GEANT/GEOMETRY/PTMED", "PTMED", 0, 2, 1, 1,
 _GEANT_GEOMETRY_PTMED_parameters, 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 2, _GEANT_GEOMETRY_PTMED_guidance, 0, (char**)0, 0, (char**)0,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GEOMETRY_STMED_NTMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_NTMED = { "NTMED", 5,
 "Tracking medium number", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_STMED_NTMED_type };
static KmParameter _GEANT_GEOMETRY_STMED_NAME = { "NAME", 4,
 "Tracking medium name", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_GEOMETRY_STMED_NMAT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_NMAT = { "NMAT", 4,
 "Material number", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_STMED_NMAT_type };
static KmParInt    _GEANT_GEOMETRY_STMED_ISVOL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_ISVOL = { "ISVOL", 5,
 "Sensitive volume flag", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_STMED_ISVOL_type };
static KmParInt    _GEANT_GEOMETRY_STMED_IFIELD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_IFIELD = { "IFIELD", 6,
 "Magnetic field", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_INT, &_GEANT_GEOMETRY_STMED_IFIELD_type };
static KmParReal   _GEANT_GEOMETRY_STMED_FIELDM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_FIELDM = { "FIELDM", 6,
 "Max. field value (Kilogauss)", "0", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_STMED_FIELDM_type };
static KmParReal   _GEANT_GEOMETRY_STMED_TMAXFD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_TMAXFD = { "TMAXFD", 6,
 "Max. angle due to field (deg/step)", "0.01", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_STMED_TMAXFD_type };
static KmParReal   _GEANT_GEOMETRY_STMED_STEMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_STEMAX = { "STEMAX", 6,
 "Max. step allowed", "1.E+10", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_STMED_STEMAX_type };
static KmParReal   _GEANT_GEOMETRY_STMED_DEEMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_DEEMAX = { "DEEMAX", 6,
 "Max. fraction of energy lost in a step", "0.01", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_STMED_DEEMAX_type };
static KmParReal   _GEANT_GEOMETRY_STMED_EPSIL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_EPSIL = { "EPSIL", 5,
 "Tracking precision (cm)", "0.01", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_STMED_EPSIL_type };
static KmParReal   _GEANT_GEOMETRY_STMED_STMIN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_STMIN = { "STMIN", 5,
 "Min. step due to continuos processes (cm)", "0.1", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_GEOMETRY_STMED_STMIN_type };
static KmParameter *_GEANT_GEOMETRY_STMED_parameters[] = {
 &_GEANT_GEOMETRY_STMED_NTMED, &_GEANT_GEOMETRY_STMED_NAME,
 &_GEANT_GEOMETRY_STMED_NMAT, &_GEANT_GEOMETRY_STMED_ISVOL,
 &_GEANT_GEOMETRY_STMED_IFIELD, &_GEANT_GEOMETRY_STMED_FIELDM,
 &_GEANT_GEOMETRY_STMED_TMAXFD, &_GEANT_GEOMETRY_STMED_STEMAX,
 &_GEANT_GEOMETRY_STMED_DEEMAX, &_GEANT_GEOMETRY_STMED_EPSIL,
 &_GEANT_GEOMETRY_STMED_STMIN };
static char *_GEANT_GEOMETRY_STMED_guidance[] = {
 "      CALL GSTMED(ntmed,name,nmat,isvol,ifield,fieldm,tmaxfd,",
 "     +            stemax,deemax,epsil,stmin,0,0)",
 "IFIELD = 0 if no magnetic field; IFIELD = -1 if user decision in GUSWIM;",
 "IFIELD = 1 if tracking performed with GRKUTA; IFIELD = 2 if tracking",
 "performed with GHELIX; IFIELD = 3 if tracking performed with GHELX3." };
static KmCommand _GEANT_GEOMETRY_STMED = { &_GEANT_GEOMETRY_PTMED,
 "/GEANT/GEOMETRY/STMED", "STMED", 0, 2, 11, 11,
 _GEANT_GEOMETRY_STMED_parameters, 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 5, _GEANT_GEOMETRY_STMED_guidance, 0, (char**)0, 0, (char**)0,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GEOMETRY_PROTM_NUMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_PROTM_NUMB = { "NUMB", 4, "Matrix ID",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_GEOMETRY_PROTM_NUMB_type };
static KmParameter *_GEANT_GEOMETRY_PROTM_parameters[] = {
 &_GEANT_GEOMETRY_PROTM_NUMB };
static char *_GEANT_GEOMETRY_PROTM_guidance[] = { " CALL GPROTM(numb)",
 "Print matrixes' specifications." };
static KmCommand _GEANT_GEOMETRY_PROTM = { &_GEANT_GEOMETRY_STMED,
 "/GEANT/GEOMETRY/PROTM", "PROTM", 0, 2, 1, 1,
 _GEANT_GEOMETRY_PROTM_parameters, 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 2, _GEANT_GEOMETRY_PROTM_guidance, 0, (char**)0, 0, (char**)0,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GEOMETRY_SROTM_IROT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SROTM_IROT = { "IROT", 4,
 "Rotation matrix number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_SROTM_IROT_type };
static KmParReal   _GEANT_GEOMETRY_SROTM_THETA1_type = { "0.", "180.", "0.",
 "180.", 0 };
static KmParameter _GEANT_GEOMETRY_SROTM_THETA1 = { "THETA1", 6,
 "Polar angle for axis I", "0.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_SROTM_THETA1_type };
static KmParReal   _GEANT_GEOMETRY_SROTM_PHI1_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_GEOMETRY_SROTM_PHI1 = { "PHI1", 4,
 "Azimuthal angle for axis I", "0.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_SROTM_PHI1_type };
static KmParReal   _GEANT_GEOMETRY_SROTM_THETA2_type = { "0.", "180.", "0.",
 "180.", 0 };
static KmParameter _GEANT_GEOMETRY_SROTM_THETA2 = { "THETA2", 6,
 "Polar angle for axis II", "0.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_SROTM_THETA2_type };
static KmParReal   _GEANT_GEOMETRY_SROTM_PHI2_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_GEOMETRY_SROTM_PHI2 = { "PHI2", 4,
 "Azimuthal angle for axis II", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_SROTM_PHI2_type };
static KmParReal   _GEANT_GEOMETRY_SROTM_THETA3_type = { "0.", "180.", "0.",
 "180.", 0 };
static KmParameter _GEANT_GEOMETRY_SROTM_THETA3 = { "THETA3", 6,
 "Polar angle for axis III", "0.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_SROTM_THETA3_type };
static KmParReal   _GEANT_GEOMETRY_SROTM_PHI3_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_GEOMETRY_SROTM_PHI3 = { "PHI3", 4,
 "Azimuthal angle for axis III", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_SROTM_PHI3_type };
static KmParameter *_GEANT_GEOMETRY_SROTM_parameters[] = {
 &_GEANT_GEOMETRY_SROTM_IROT, &_GEANT_GEOMETRY_SROTM_THETA1,
 &_GEANT_GEOMETRY_SROTM_PHI1, &_GEANT_GEOMETRY_SROTM_THETA2,
 &_GEANT_GEOMETRY_SROTM_PHI2, &_GEANT_GEOMETRY_SROTM_THETA3,
 &_GEANT_GEOMETRY_SROTM_PHI3 };
static char *_GEANT_GEOMETRY_SROTM_guidance[] = {
 " CALL GSROTM(irot,theta1,phi1,theta2,phi2,theta3,phi3)",
 "It defines the rotation matrix number IROT." };
static KmCommand _GEANT_GEOMETRY_SROTM = { &_GEANT_GEOMETRY_PROTM,
 "/GEANT/GEOMETRY/SROTM", "SROTM", 0, 2, 7, 7,
 _GEANT_GEOMETRY_SROTM_parameters, 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 2, _GEANT_GEOMETRY_SROTM_guidance, 0, (char**)0, 0, (char**)0,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GEOMETRY_PVOLU_NUMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_PVOLU_NUMB = { "NUMB", 4, "Volume ID",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_GEOMETRY_PVOLU_NUMB_type };
static KmParameter *_GEANT_GEOMETRY_PVOLU_parameters[] = {
 &_GEANT_GEOMETRY_PVOLU_NUMB };
static char *_GEANT_GEOMETRY_PVOLU_guidance[] = { " CALL GPVOLU(numb)",
 "Prints volumes' specifications." };
static KmCommand _GEANT_GEOMETRY_PVOLU = { &_GEANT_GEOMETRY_SROTM,
 "/GEANT/GEOMETRY/PVOLU", "PVOLU", 0, 2, 1, 1,
 _GEANT_GEOMETRY_PVOLU_parameters, 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 2, _GEANT_GEOMETRY_PVOLU_guidance, 0, (char**)0, 0, (char**)0,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_GEOMETRY_SDVN_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GEOMETRY_SDVN_MOTHER = { "MOTHER", 6,
 "Mother volume name", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_GEOMETRY_SDVN_NDIV_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SDVN_NDIV = { "NDIV", 4,
 "Number of divisions", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_SDVN_NDIV_type };
static char *_GEANT_GEOMETRY_SDVN_CAXIS_range[] = { "X", "Y", "Z", "1", "2",
 "3" };
static char *_GEANT_GEOMETRY_SDVN_CAXIS_text[] = { (char*)0, (char*)0,
 (char*)0, (char*)0, (char*)0, (char*)0 };
static KmParOption _GEANT_GEOMETRY_SDVN_CAXIS_type = {
 _GEANT_GEOMETRY_SDVN_CAXIS_text, (int*)0, (int*)0 };
static KmParameter _GEANT_GEOMETRY_SDVN_CAXIS = { "CAXIS", 5, "Axis value",
 (char*)0, (char*)0, 8, 6, _GEANT_GEOMETRY_SDVN_CAXIS_range, 6,
 _GEANT_GEOMETRY_SDVN_CAXIS_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_GEOMETRY_SDVN_CAXIS_type };
static KmParameter *_GEANT_GEOMETRY_SDVN_parameters[] = {
 &_GEANT_GEOMETRY_SDVN_NAME, &_GEANT_GEOMETRY_SDVN_MOTHER,
 &_GEANT_GEOMETRY_SDVN_NDIV, &_GEANT_GEOMETRY_SDVN_CAXIS };
static char *_GEANT_GEOMETRY_SDVN_guidance[] = {
 " CALL GSDVN(name,mother,ndiv,iaxis)",
 "X,Y,Z of CAXIS will be translated to 1,2,3 for IAXIS.",
 "It divides a previously defined volume." };
static KmCommand _GEANT_GEOMETRY_SDVN = { &_GEANT_GEOMETRY_PVOLU,
 "/GEANT/GEOMETRY/SDVN", "SDVN", 0, 2, 4, 4, _GEANT_GEOMETRY_SDVN_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_GEOMETRY_SDVN_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_GEOMETRY_SPOS_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_GEOMETRY_SPOS_NUMBER_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SPOS_NUMBER = { "NUMBER", 6,
 "Copy number of the volume", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_SPOS_NUMBER_type };
static KmParameter _GEANT_GEOMETRY_SPOS_MOTHER = { "MOTHER", 6,
 "Mother volume name", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_GEOMETRY_SPOS_X0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SPOS_X0 = { "X0", 2,
 "X coord. of the volume in mother ref. sys.", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_GEOMETRY_SPOS_X0_type };
static KmParReal   _GEANT_GEOMETRY_SPOS_Y0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SPOS_Y0 = { "Y0", 2,
 "Y coord. of the volume in mother ref. sys.", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_GEOMETRY_SPOS_Y0_type };
static KmParReal   _GEANT_GEOMETRY_SPOS_Z0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SPOS_Z0 = { "Z0", 2,
 "Z coord. of the volume in mother ref. sys.", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_GEOMETRY_SPOS_Z0_type };
static KmParInt    _GEANT_GEOMETRY_SPOS_IROT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SPOS_IROT = { "IROT", 4,
 "Rotation matrix number w.r.t. mother ref. sys.", (char*)0, (char*)0, 8, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_GEOMETRY_SPOS_IROT_type };
static KmParameter _GEANT_GEOMETRY_SPOS_ONLY = { "ONLY", 4, "ONLY/MANY flag",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_GEOMETRY_SPOS_parameters[] = {
 &_GEANT_GEOMETRY_SPOS_NAME, &_GEANT_GEOMETRY_SPOS_NUMBER,
 &_GEANT_GEOMETRY_SPOS_MOTHER, &_GEANT_GEOMETRY_SPOS_X0,
 &_GEANT_GEOMETRY_SPOS_Y0, &_GEANT_GEOMETRY_SPOS_Z0,
 &_GEANT_GEOMETRY_SPOS_IROT, &_GEANT_GEOMETRY_SPOS_ONLY };
static char *_GEANT_GEOMETRY_SPOS_guidance[] = {
 " CALL GSPOS(name,number,mother,x0,y0,z0,irot,only)",
 "It positions a previously defined volume in the mother." };
static KmCommand _GEANT_GEOMETRY_SPOS = { &_GEANT_GEOMETRY_SDVN,
 "/GEANT/GEOMETRY/SPOS", "SPOS", 0, 2, 8, 8, _GEANT_GEOMETRY_SPOS_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_GEOMETRY_SPOS_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_GEOMETRY_SVOLU_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GEOMETRY_SVOLU_SHAPE = { "SHAPE", 5, "Volume type",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_GEOMETRY_SVOLU_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SVOLU_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_SVOLU_NUMED_type };
static KmParInt    _GEANT_GEOMETRY_SVOLU_NPAR_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SVOLU_NPAR = { "NPAR", 4,
 "Number of shape parameters", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_SVOLU_NPAR_type };
static KmParameter _GEANT_GEOMETRY_SVOLU_PAR = { "PAR", 3,
 "Vector containing shape parameters", (char*)0, (char*)0, 20, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_GEOMETRY_SVOLU_parameters[] = {
 &_GEANT_GEOMETRY_SVOLU_NAME, &_GEANT_GEOMETRY_SVOLU_SHAPE,
 &_GEANT_GEOMETRY_SVOLU_NUMED, &_GEANT_GEOMETRY_SVOLU_NPAR,
 &_GEANT_GEOMETRY_SVOLU_PAR };
static char *_GEANT_GEOMETRY_SVOLU_guidance[] = {
 " CALL GSVOLU(name,shape,numed,par,npar,ivolu)",
 "where par is a KUIP vector.",
 "It creates a new volume in the JVOLUM data structure." };
static KmCommand _GEANT_GEOMETRY_SVOLU = { &_GEANT_GEOMETRY_SPOS,
 "/GEANT/GEOMETRY/SVOLU", "SVOLU", 0, 2, 5, 5,
 _GEANT_GEOMETRY_SVOLU_parameters, 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 3, _GEANT_GEOMETRY_SVOLU_guidance, 0, (char**)0, 0, (char**)0,
 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_GEOMETRY_OPTI_IOPTI_range[] = { "-1", "2" };
static KmParInt    _GEANT_GEOMETRY_OPTI_IOPTI_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_OPTI_IOPTI = { "IOPTI", 5,
 "GSORD optimisation level", "0", (char*)0, 8, 2,
 _GEANT_GEOMETRY_OPTI_IOPTI_range, 2, _GEANT_GEOMETRY_OPTI_IOPTI_range,
 (KmParFlag)2, KmTYPE_INT, &_GEANT_GEOMETRY_OPTI_IOPTI_type };
static KmParameter *_GEANT_GEOMETRY_OPTI_parameters[] = {
 &_GEANT_GEOMETRY_OPTI_IOPTI };
static char *_GEANT_GEOMETRY_OPTI_guidance[] = {
 "This flag controls the tracking optimisation performed via the",
 "GSORD routine:", "    1 no optimisation at all; GSORD calls disabled;",
 "    0 no optimisation; only user calls to GSORD kept;",
 "    1 all non-GSORDered volumes are ordered along the best axis;",
 "    2 all volumes are ordered along the best axis." };
static KmCommand _GEANT_GEOMETRY_OPTI = { &_GEANT_GEOMETRY_SVOLU,
 "/GEANT/GEOMETRY/OPTI", "OPTI", 0, 2, 1, 1, _GEANT_GEOMETRY_OPTI_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 6,
 _GEANT_GEOMETRY_OPTI_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_SPARA_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_SPARA_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SPARA_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_SPARA_NUMED_type };
static KmParReal   _GEANT_CREATE_SPARA_HALFX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SPARA_HALFX = { "HALFX", 5, "Half X length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SPARA_HALFX_type };
static KmParReal   _GEANT_CREATE_SPARA_HALFY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SPARA_HALFY = { "HALFY", 5, "Half Y length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SPARA_HALFY_type };
static KmParReal   _GEANT_CREATE_SPARA_HALFZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SPARA_HALFZ = { "HALFZ", 5, "Half Z length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SPARA_HALFZ_type };
static KmParReal   _GEANT_CREATE_SPARA_AXIS_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_SPARA_AXIS = { "AXIS", 4,
 "Angle of Y mid-faces segment to Y axis", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CREATE_SPARA_AXIS_type };
static KmParReal   _GEANT_CREATE_SPARA_PHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_SPARA_PHI = { "PHI", 3,
 "PHI angle of Low Z mid-face to High Z mid-face segment", (char*)0, (char*)0,
 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CREATE_SPARA_PHI_type };
static KmParReal   _GEANT_CREATE_SPARA_THETA_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_SPARA_THETA = { "THETA", 5,
 "THETA angle of mid-low-Z-face to mid-high-Z-face segment", (char*)0,
 (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CREATE_SPARA_THETA_type };
static char *_GEANT_CREATE_SPARA_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_SPARA_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_SPARA_YESNO_type = {
 _GEANT_CREATE_SPARA_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_SPARA_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_SPARA_YESNO_range, 2,
 _GEANT_CREATE_SPARA_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_SPARA_YESNO_type };
static KmParameter *_GEANT_CREATE_SPARA_parameters[] = {
 &_GEANT_CREATE_SPARA_NAME, &_GEANT_CREATE_SPARA_NUMED,
 &_GEANT_CREATE_SPARA_HALFX, &_GEANT_CREATE_SPARA_HALFY,
 &_GEANT_CREATE_SPARA_HALFZ, &_GEANT_CREATE_SPARA_AXIS,
 &_GEANT_CREATE_SPARA_PHI, &_GEANT_CREATE_SPARA_THETA,
 &_GEANT_CREATE_SPARA_YESNO };
static KmCommand _GEANT_CREATE_SPARA = {  (KmCommand*)0,
 "/GEANT/CREATE/SPARA", "SPARA", 0, 2, 9, 8, _GEANT_CREATE_SPARA_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_SSPHE_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_SSPHE_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SSPHE_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_SSPHE_NUMED_type };
static KmParReal   _GEANT_CREATE_SSPHE_INRAD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SSPHE_INRAD = { "INRAD", 5, "Inside Radius",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SSPHE_INRAD_type };
static KmParReal   _GEANT_CREATE_SSPHE_OUTRAD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SSPHE_OUTRAD = { "OUTRAD", 6,
 "Outside Radius", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SSPHE_OUTRAD_type };
static KmParReal   _GEANT_CREATE_SSPHE_SPHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_SSPHE_SPHI = { "SPHI", 4,
 "Start of section PHI", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SSPHE_SPHI_type };
static KmParReal   _GEANT_CREATE_SSPHE_EPHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_SSPHE_EPHI = { "EPHI", 4,
 "End of section PHI", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SSPHE_EPHI_type };
static KmParReal   _GEANT_CREATE_SSPHE_STHETA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SSPHE_STHETA = { "STHETA", 6,
 "Start of section THETA", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SSPHE_STHETA_type };
static KmParReal   _GEANT_CREATE_SSPHE_ETHETA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SSPHE_ETHETA = { "ETHETA", 6,
 "End of section THETA", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SSPHE_ETHETA_type };
static char *_GEANT_CREATE_SSPHE_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_SSPHE_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_SSPHE_YESNO_type = {
 _GEANT_CREATE_SSPHE_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_SSPHE_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_SSPHE_YESNO_range, 2,
 _GEANT_CREATE_SSPHE_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_SSPHE_YESNO_type };
static KmParameter *_GEANT_CREATE_SSPHE_parameters[] = {
 &_GEANT_CREATE_SSPHE_NAME, &_GEANT_CREATE_SSPHE_NUMED,
 &_GEANT_CREATE_SSPHE_INRAD, &_GEANT_CREATE_SSPHE_OUTRAD,
 &_GEANT_CREATE_SSPHE_SPHI, &_GEANT_CREATE_SSPHE_EPHI,
 &_GEANT_CREATE_SSPHE_STHETA, &_GEANT_CREATE_SSPHE_ETHETA,
 &_GEANT_CREATE_SSPHE_YESNO };
static KmCommand _GEANT_CREATE_SSPHE = { &_GEANT_CREATE_SPARA,
 "/GEANT/CREATE/SSPHE", "SSPHE", 0, 2, 9, 8, _GEANT_CREATE_SSPHE_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_SCONS_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_SCONS_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONS_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_SCONS_NUMED_type };
static KmParReal   _GEANT_CREATE_SCONS_INRDW_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONS_INRDW = { "INRDW", 5,
 "Inside Radius in Lower Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONS_INRDW_type };
static KmParReal   _GEANT_CREATE_SCONS_OUTRDW_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONS_OUTRDW = { "OUTRDW", 6,
 "Outside Radius in Lower Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONS_OUTRDW_type };
static KmParReal   _GEANT_CREATE_SCONS_INRUP_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONS_INRUP = { "INRUP", 5,
 "Inside Radius in Upper Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONS_INRUP_type };
static KmParReal   _GEANT_CREATE_SCONS_OUTRUP_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONS_OUTRUP = { "OUTRUP", 6,
 "Outside Radius in Upper Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONS_OUTRUP_type };
static KmParReal   _GEANT_CREATE_SCONS_HALFZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONS_HALFZ = { "HALFZ", 5, "Half Z length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SCONS_HALFZ_type };
static KmParReal   _GEANT_CREATE_SCONS_SPHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_SCONS_SPHI = { "SPHI", 4,
 "Start of section PHI", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONS_SPHI_type };
static KmParReal   _GEANT_CREATE_SCONS_EPHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_SCONS_EPHI = { "EPHI", 4,
 "End of section PHI", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONS_EPHI_type };
static char *_GEANT_CREATE_SCONS_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_SCONS_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_SCONS_YESNO_type = {
 _GEANT_CREATE_SCONS_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_SCONS_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_SCONS_YESNO_range, 2,
 _GEANT_CREATE_SCONS_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_SCONS_YESNO_type };
static KmParameter *_GEANT_CREATE_SCONS_parameters[] = {
 &_GEANT_CREATE_SCONS_NAME, &_GEANT_CREATE_SCONS_NUMED,
 &_GEANT_CREATE_SCONS_INRDW, &_GEANT_CREATE_SCONS_OUTRDW,
 &_GEANT_CREATE_SCONS_INRUP, &_GEANT_CREATE_SCONS_OUTRUP,
 &_GEANT_CREATE_SCONS_HALFZ, &_GEANT_CREATE_SCONS_SPHI,
 &_GEANT_CREATE_SCONS_EPHI, &_GEANT_CREATE_SCONS_YESNO };
static KmCommand _GEANT_CREATE_SCONS = { &_GEANT_CREATE_SSPHE,
 "/GEANT/CREATE/SCONS", "SCONS", 0, 2, 10, 9, _GEANT_CREATE_SCONS_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_SCONE_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_SCONE_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONE_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_SCONE_NUMED_type };
static KmParReal   _GEANT_CREATE_SCONE_INRDW_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONE_INRDW = { "INRDW", 5,
 "Inside Radius in Lower Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONE_INRDW_type };
static KmParReal   _GEANT_CREATE_SCONE_OUTRDW_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONE_OUTRDW = { "OUTRDW", 6,
 "Outside Radius in Lower Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONE_OUTRDW_type };
static KmParReal   _GEANT_CREATE_SCONE_INRUP_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONE_INRUP = { "INRUP", 5,
 "Inside Radius in Upper Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONE_INRUP_type };
static KmParReal   _GEANT_CREATE_SCONE_OUTRUP_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONE_OUTRUP = { "OUTRUP", 6,
 "Outside Radius in Upper Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONE_OUTRUP_type };
static KmParReal   _GEANT_CREATE_SCONE_HALFZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONE_HALFZ = { "HALFZ", 5, "Half Z length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SCONE_HALFZ_type };
static char *_GEANT_CREATE_SCONE_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_SCONE_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_SCONE_YESNO_type = {
 _GEANT_CREATE_SCONE_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_SCONE_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_SCONE_YESNO_range, 2,
 _GEANT_CREATE_SCONE_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_SCONE_YESNO_type };
static KmParameter *_GEANT_CREATE_SCONE_parameters[] = {
 &_GEANT_CREATE_SCONE_NAME, &_GEANT_CREATE_SCONE_NUMED,
 &_GEANT_CREATE_SCONE_INRDW, &_GEANT_CREATE_SCONE_OUTRDW,
 &_GEANT_CREATE_SCONE_INRUP, &_GEANT_CREATE_SCONE_OUTRUP,
 &_GEANT_CREATE_SCONE_HALFZ, &_GEANT_CREATE_SCONE_YESNO };
static KmCommand _GEANT_CREATE_SCONE = { &_GEANT_CREATE_SCONS,
 "/GEANT/CREATE/SCONE", "SCONE", 0, 2, 8, 7, _GEANT_CREATE_SCONE_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_STUBS_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_STUBS_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STUBS_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_STUBS_NUMED_type };
static KmParReal   _GEANT_CREATE_STUBS_INRAD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STUBS_INRAD = { "INRAD", 5, "Inside Radius",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_STUBS_INRAD_type };
static KmParReal   _GEANT_CREATE_STUBS_OUTRAD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STUBS_OUTRAD = { "OUTRAD", 6,
 "Outside Radius", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STUBS_OUTRAD_type };
static KmParReal   _GEANT_CREATE_STUBS_HALFZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STUBS_HALFZ = { "HALFZ", 5, "Half Z length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_STUBS_HALFZ_type };
static KmParReal   _GEANT_CREATE_STUBS_SPHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_STUBS_SPHI = { "SPHI", 4,
 "Start of section PHI", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STUBS_SPHI_type };
static KmParReal   _GEANT_CREATE_STUBS_EPHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_STUBS_EPHI = { "EPHI", 4,
 "End of section PHI", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STUBS_EPHI_type };
static char *_GEANT_CREATE_STUBS_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_STUBS_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_STUBS_YESNO_type = {
 _GEANT_CREATE_STUBS_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_STUBS_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_STUBS_YESNO_range, 2,
 _GEANT_CREATE_STUBS_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_STUBS_YESNO_type };
static KmParameter *_GEANT_CREATE_STUBS_parameters[] = {
 &_GEANT_CREATE_STUBS_NAME, &_GEANT_CREATE_STUBS_NUMED,
 &_GEANT_CREATE_STUBS_INRAD, &_GEANT_CREATE_STUBS_OUTRAD,
 &_GEANT_CREATE_STUBS_HALFZ, &_GEANT_CREATE_STUBS_SPHI,
 &_GEANT_CREATE_STUBS_EPHI, &_GEANT_CREATE_STUBS_YESNO };
static KmCommand _GEANT_CREATE_STUBS = { &_GEANT_CREATE_SCONE,
 "/GEANT/CREATE/STUBS", "STUBS", 0, 2, 8, 7, _GEANT_CREATE_STUBS_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_STUBE_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_STUBE_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STUBE_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_STUBE_NUMED_type };
static KmParReal   _GEANT_CREATE_STUBE_INRAD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STUBE_INRAD = { "INRAD", 5, "Inside Radius",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_STUBE_INRAD_type };
static KmParReal   _GEANT_CREATE_STUBE_OUTRAD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STUBE_OUTRAD = { "OUTRAD", 6,
 "Outside Radius", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STUBE_OUTRAD_type };
static KmParReal   _GEANT_CREATE_STUBE_HALFZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STUBE_HALFZ = { "HALFZ", 5, "Half Z length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_STUBE_HALFZ_type };
static char *_GEANT_CREATE_STUBE_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_STUBE_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_STUBE_YESNO_type = {
 _GEANT_CREATE_STUBE_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_STUBE_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_STUBE_YESNO_range, 2,
 _GEANT_CREATE_STUBE_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_STUBE_YESNO_type };
static KmParameter *_GEANT_CREATE_STUBE_parameters[] = {
 &_GEANT_CREATE_STUBE_NAME, &_GEANT_CREATE_STUBE_NUMED,
 &_GEANT_CREATE_STUBE_INRAD, &_GEANT_CREATE_STUBE_OUTRAD,
 &_GEANT_CREATE_STUBE_HALFZ, &_GEANT_CREATE_STUBE_YESNO };
static KmCommand _GEANT_CREATE_STUBE = { &_GEANT_CREATE_STUBS,
 "/GEANT/CREATE/STUBE", "STUBE", 0, 2, 6, 5, _GEANT_CREATE_STUBE_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_STRD2_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_STRD2_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD2_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_STRD2_NUMED_type };
static KmParReal   _GEANT_CREATE_STRD2_HLFDWX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD2_HLFDWX = { "HLFDWX", 6,
 "Half X length in Lower Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STRD2_HLFDWX_type };
static KmParReal   _GEANT_CREATE_STRD2_HLFUPX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD2_HLFUPX = { "HLFUPX", 6,
 "Half X length in Upper Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STRD2_HLFUPX_type };
static KmParReal   _GEANT_CREATE_STRD2_HLFDWY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD2_HLFDWY = { "HLFDWY", 6,
 "Half Y length in Lower Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STRD2_HLFDWY_type };
static KmParReal   _GEANT_CREATE_STRD2_HLFUPY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD2_HLFUPY = { "HLFUPY", 6,
 "Half Y length in Upper Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STRD2_HLFUPY_type };
static KmParReal   _GEANT_CREATE_STRD2_HALFZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD2_HALFZ = { "HALFZ", 5, "Half Z length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_STRD2_HALFZ_type };
static char *_GEANT_CREATE_STRD2_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_STRD2_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_STRD2_YESNO_type = {
 _GEANT_CREATE_STRD2_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_STRD2_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_STRD2_YESNO_range, 2,
 _GEANT_CREATE_STRD2_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_STRD2_YESNO_type };
static KmParameter *_GEANT_CREATE_STRD2_parameters[] = {
 &_GEANT_CREATE_STRD2_NAME, &_GEANT_CREATE_STRD2_NUMED,
 &_GEANT_CREATE_STRD2_HLFDWX, &_GEANT_CREATE_STRD2_HLFUPX,
 &_GEANT_CREATE_STRD2_HLFDWY, &_GEANT_CREATE_STRD2_HLFUPY,
 &_GEANT_CREATE_STRD2_HALFZ, &_GEANT_CREATE_STRD2_YESNO };
static KmCommand _GEANT_CREATE_STRD2 = { &_GEANT_CREATE_STUBE,
 "/GEANT/CREATE/STRD2", "STRD2", 0, 2, 8, 7, _GEANT_CREATE_STRD2_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_STRD1_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_STRD1_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD1_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_STRD1_NUMED_type };
static KmParReal   _GEANT_CREATE_STRD1_HLFDWX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD1_HLFDWX = { "HLFDWX", 6,
 "Half X length in Lower Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STRD1_HLFDWX_type };
static KmParReal   _GEANT_CREATE_STRD1_HLFUPX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD1_HLFUPX = { "HLFUPX", 6,
 "Half X length in Upper Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STRD1_HLFUPX_type };
static KmParReal   _GEANT_CREATE_STRD1_HALFY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD1_HALFY = { "HALFY", 5, "Half Y length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_STRD1_HALFY_type };
static KmParReal   _GEANT_CREATE_STRD1_HALFZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD1_HALFZ = { "HALFZ", 5, "Half Z length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_STRD1_HALFZ_type };
static char *_GEANT_CREATE_STRD1_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_STRD1_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_STRD1_YESNO_type = {
 _GEANT_CREATE_STRD1_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_STRD1_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_STRD1_YESNO_range, 2,
 _GEANT_CREATE_STRD1_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_STRD1_YESNO_type };
static KmParameter *_GEANT_CREATE_STRD1_parameters[] = {
 &_GEANT_CREATE_STRD1_NAME, &_GEANT_CREATE_STRD1_NUMED,
 &_GEANT_CREATE_STRD1_HLFDWX, &_GEANT_CREATE_STRD1_HLFUPX,
 &_GEANT_CREATE_STRD1_HALFY, &_GEANT_CREATE_STRD1_HALFZ,
 &_GEANT_CREATE_STRD1_YESNO };
static KmCommand _GEANT_CREATE_STRD1 = { &_GEANT_CREATE_STRD2,
 "/GEANT/CREATE/STRD1", "STRD1", 0, 2, 7, 6, _GEANT_CREATE_STRD1_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_SBOX_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_SBOX_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SBOX_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_SBOX_NUMED_type };
static KmParReal   _GEANT_CREATE_SBOX_HALFX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SBOX_HALFX = { "HALFX", 5, "Half X length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SBOX_HALFX_type };
static KmParReal   _GEANT_CREATE_SBOX_HALFY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SBOX_HALFY = { "HALFY", 5, "Half Y length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SBOX_HALFY_type };
static KmParReal   _GEANT_CREATE_SBOX_HALFZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SBOX_HALFZ = { "HALFZ", 5, "Half Z length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SBOX_HALFZ_type };
static char *_GEANT_CREATE_SBOX_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_SBOX_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_SBOX_YESNO_type = {
 _GEANT_CREATE_SBOX_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_SBOX_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_SBOX_YESNO_range, 2,
 _GEANT_CREATE_SBOX_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_SBOX_YESNO_type };
static KmParameter *_GEANT_CREATE_SBOX_parameters[] = {
 &_GEANT_CREATE_SBOX_NAME, &_GEANT_CREATE_SBOX_NUMED,
 &_GEANT_CREATE_SBOX_HALFX, &_GEANT_CREATE_SBOX_HALFY,
 &_GEANT_CREATE_SBOX_HALFZ, &_GEANT_CREATE_SBOX_YESNO };
static KmCommand _GEANT_CREATE_SBOX = { &_GEANT_CREATE_STRD1,
 "/GEANT/CREATE/SBOX", "SBOX", 0, 2, 6, 5, _GEANT_CREATE_SBOX_parameters, 0,
 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_CREATE_guidance[] = {
 "It creates volumes of the given shape interactively.",
 "CALL GSVOLU(name,shape,numed,par,npar,ivolu)", "where par is a KUIP vector"
 };
static KmMenu _GEANT_CREATE = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/CREATE",
 "CREATE", 2, &_GEANT_CREATE_SBOX, 3, _GEANT_CREATE_guidance, 0, (char**)0, 0,
 (char**)0 };
 
static char *_GEANT_GEOMETRY_guidance[] = { "Geometry commands." };
static KmMenu _GEANT_GEOMETRY = { &_GEANT_CREATE,  (KmMenu*)0,
 "/GEANT/GEOMETRY", "GEOMETRY", 2, &_GEANT_GEOMETRY_OPTI, 1,
 _GEANT_GEOMETRY_guidance, 0, (char**)0, 0, (char**)0 };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_GEOMETRY, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 0, (char**)0, 0, (char**)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 950303 );
}
 
 
#ifdef F77_LCASE
#  define gkcont_ gkcont
#  define gxcont_ gxcont
#endif
 
#ifdef F77_UCASE
#  define gkcont_ GKCONT
#  define gxcont_ GXCONT
#endif
 
#ifdef IBM370
#  pragma linkage(GKCONT,FORTRAN)
#  pragma linkage(GXCONT,FORTRAN)
#endif
 
extern void gkcont_();
extern void gxcont_();
 
void gkcont_()
{
 
static char *_GEANT_CONTROL_DEBUG_IDEB_range[] = { "ON", "OFF" };
static char *_GEANT_CONTROL_DEBUG_IDEB_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CONTROL_DEBUG_IDEB_type = {
 _GEANT_CONTROL_DEBUG_IDEB_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CONTROL_DEBUG_IDEB = { "IDEB", 4, "Debug option",
 "ON", (char*)0, 8, 2, _GEANT_CONTROL_DEBUG_IDEB_range, 2,
 _GEANT_CONTROL_DEBUG_IDEB_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CONTROL_DEBUG_IDEB_type };
static KmParameter *_GEANT_CONTROL_DEBUG_parameters[] = {
 &_GEANT_CONTROL_DEBUG_IDEB };
static char *_GEANT_CONTROL_DEBUG_guidance[] = { "If ideb='ON  ' then :",
 " idebug=1, idemin=1, idemax=1000000, itime=1", "else :",
 " idebug=0, idemin=0, idemax=0" };
static KmCommand _GEANT_CONTROL_DEBUG = {  (KmCommand*)0,
 "/GEANT/CONTROL/DEBUG", "DEBUG", 0, 2, 1, 0, _GEANT_CONTROL_DEBUG_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_CONTROL_DEBUG_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_PRKINE_NUMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PRKINE_NUMB = { "NUMB", 4, "Track number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_PRKINE_NUMB_type };
static KmParameter *_GEANT_CONTROL_PRKINE_parameters[] = {
 &_GEANT_CONTROL_PRKINE_NUMB };
static char *_GEANT_CONTROL_PRKINE_guidance[] = { "CALL GPKINE(numb)" };
static KmCommand _GEANT_CONTROL_PRKINE = { &_GEANT_CONTROL_DEBUG,
 "/GEANT/CONTROL/PRKINE", "PRKINE", 0, 2, 1, 1,
 _GEANT_CONTROL_PRKINE_parameters, 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 1, _GEANT_CONTROL_PRKINE_guidance, 0, (char**)0, 0, (char**)0,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_PPART_NUMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PPART_NUMB = { "NUMB", 4, "Particle number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_PPART_NUMB_type };
static KmParameter *_GEANT_CONTROL_PPART_parameters[] = {
 &_GEANT_CONTROL_PPART_NUMB };
static char *_GEANT_CONTROL_PPART_guidance[] = { "CALL GPPART(numb)" };
static KmCommand _GEANT_CONTROL_PPART = { &_GEANT_CONTROL_PRKINE,
 "/GEANT/CONTROL/PPART", "PPART", 0, 2, 1, 1, _GEANT_CONTROL_PPART_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_PPART_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_SPART_IPART_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_IPART = { "IPART", 5,
 "Particle number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_SPART_IPART_type };
static KmParameter _GEANT_CONTROL_SPART_NAPART = { "NAPART", 6,
 "Particle name", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CONTROL_SPART_ITRTYP_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_ITRTYP = { "ITRTYP", 6, " ", (char*)0,
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_SPART_ITRTYP_type };
static KmParReal   _GEANT_CONTROL_SPART_AMASS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_AMASS = { "AMASS", 5, "Mass",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SPART_AMASS_type };
static KmParReal   _GEANT_CONTROL_SPART_CHARGE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_CHARGE = { "CHARGE", 6, "Charge",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SPART_CHARGE_type };
static KmParReal   _GEANT_CONTROL_SPART_TLIFE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_TLIFE = { "TLIFE", 5, "Lifetime",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SPART_TLIFE_type };
static KmParReal   _GEANT_CONTROL_SPART_UBUF_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_UBUF = { "UBUF", 4, " ", (char*)0,
 (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CONTROL_SPART_UBUF_type };
static KmParInt    _GEANT_CONTROL_SPART_NWBUF_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_NWBUF = { "NWBUF", 5, " ", (char*)0,
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_SPART_NWBUF_type };
static KmParReal   _GEANT_CONTROL_SPART_BRATIO_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_BRATIO = { "BRATIO", 6,
 "Branching ratios", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CONTROL_SPART_BRATIO_type };
static KmParInt    _GEANT_CONTROL_SPART_MODE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_MODE = { "MODE", 4, "Decay mode",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_SPART_MODE_type };
static KmParameter *_GEANT_CONTROL_SPART_parameters[] = {
 &_GEANT_CONTROL_SPART_IPART, &_GEANT_CONTROL_SPART_NAPART,
 &_GEANT_CONTROL_SPART_ITRTYP, &_GEANT_CONTROL_SPART_AMASS,
 &_GEANT_CONTROL_SPART_CHARGE, &_GEANT_CONTROL_SPART_TLIFE,
 &_GEANT_CONTROL_SPART_UBUF, &_GEANT_CONTROL_SPART_NWBUF,
 &_GEANT_CONTROL_SPART_BRATIO, &_GEANT_CONTROL_SPART_MODE };
static char *_GEANT_CONTROL_SPART_guidance[] = {
 "CALL GSPART(ipart,napart,itrtyp,amass,charge,tlife,ubuf,nwbuf);",
 "CALL GSDK(ipart,bratio,mode)" };
static KmCommand _GEANT_CONTROL_SPART = { &_GEANT_CONTROL_PPART,
 "/GEANT/CONTROL/SPART", "SPART", 0, 2, 10, 10,
 _GEANT_CONTROL_SPART_parameters, 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 2, _GEANT_CONTROL_SPART_guidance, 0, (char**)0, 0, (char**)0,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_STPAR_ITMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_STPAR_ITMED = { "ITMED", 5, "Medium number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_STPAR_ITMED_type };
static KmParameter _GEANT_CONTROL_STPAR_CHPAR = { "CHPAR", 5,
 "Cut or mechanism", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_CONTROL_STPAR_PARVAL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_STPAR_PARVAL = { "PARVAL", 6, "Value",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_STPAR_PARVAL_type };
static KmParameter *_GEANT_CONTROL_STPAR_parameters[] = {
 &_GEANT_CONTROL_STPAR_ITMED, &_GEANT_CONTROL_STPAR_CHPAR,
 &_GEANT_CONTROL_STPAR_PARVAL };
static char *_GEANT_CONTROL_STPAR_guidance[] = {
 "CALL GSTPAR(itmed,chpar,parval)" };
static KmCommand _GEANT_CONTROL_STPAR = { &_GEANT_CONTROL_SPART,
 "/GEANT/CONTROL/STPAR", "STPAR", 0, 2, 3, 3, _GEANT_CONTROL_STPAR_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_STPAR_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_DRMAT_IMATE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_DRMAT_IMATE = { "IMATE", 5,
 "Material number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_DRMAT_IMATE_type };
static KmParInt    _GEANT_CONTROL_DRMAT_IPART_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_DRMAT_IPART = { "IPART", 5,
 "Particle number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_DRMAT_IPART_type };
static KmParameter _GEANT_CONTROL_DRMAT_MECAN = { "MECAN", 5,
 "List of mechanism", "ALL", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_CONTROL_DRMAT_parameters[] = {
 &_GEANT_CONTROL_DRMAT_IMATE, &_GEANT_CONTROL_DRMAT_IPART,
 &_GEANT_CONTROL_DRMAT_MECAN };
static char *_GEANT_CONTROL_DRMAT_guidance[] = {
 "CALL GDRMAT(imate,ipart,mecan,nmec)",
 "If MECAN = 'ALL' all the mechanisms are plotted. If the material number",
 "is negative, the cross sections relative to material ABS(IMATE) will",
 "be plotted in barns rather than in 1/cm.",
 "Note that it is not possible to plot anything if GSTMED has not been\
 called", "for the material number IMATE." };
static KmCommand _GEANT_CONTROL_DRMAT = { &_GEANT_CONTROL_STPAR,
 "/GEANT/CONTROL/DRMAT", "DRMAT", 0, 2, 3, 2, _GEANT_CONTROL_DRMAT_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 6,
 _GEANT_CONTROL_DRMAT_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_PLMAT_IMATE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PLMAT_IMATE = { "IMATE", 5,
 "Material number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_PLMAT_IMATE_type };
static KmParInt    _GEANT_CONTROL_PLMAT_IPART_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PLMAT_IPART = { "IPART", 5,
 "Particle number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_PLMAT_IPART_type };
static KmParameter _GEANT_CONTROL_PLMAT_MECAN = { "MECAN", 5, "Mechanism",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CONTROL_PLMAT_IDM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PLMAT_IDM = { "IDM", 3, "ID mode option",
 "0", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_PLMAT_IDM_type };
static KmParameter *_GEANT_CONTROL_PLMAT_parameters[] = {
 &_GEANT_CONTROL_PLMAT_IMATE, &_GEANT_CONTROL_PLMAT_IPART,
 &_GEANT_CONTROL_PLMAT_MECAN, &_GEANT_CONTROL_PLMAT_IDM };
static char *_GEANT_CONTROL_PLMAT_guidance[] = {
 "CALL GPLMAT(imate,ipart,mecan,nekbin,elow,idm)",
 " IDM convention for histogramming mode :",
 " IDM.gt.0  fill, print,   keep   histogram(s)",
 " IDM.eq.0  fill, print,   delete histogram(s)",
 " IDM.lt.0  fill, noprint, keep   histogram(s)",
 "If MECAN = 'ALL' all the mechanisms are histogrammed. If the material\
 number",
 "is negative, the cross sections relative to material ABS(IMATE) will",
 "be histogrammed in barns rather than in 1/cm." };
static KmCommand _GEANT_CONTROL_PLMAT = { &_GEANT_CONTROL_DRMAT,
 "/GEANT/CONTROL/PLMAT", "PLMAT", 0, 2, 4, 3, _GEANT_CONTROL_PLMAT_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 8,
 _GEANT_CONTROL_PLMAT_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_PRMAT_IMATE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PRMAT_IMATE = { "IMATE", 5,
 "Material number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_PRMAT_IMATE_type };
static KmParInt    _GEANT_CONTROL_PRMAT_IPART_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PRMAT_IPART = { "IPART", 5,
 "Particle number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_PRMAT_IPART_type };
static KmParameter _GEANT_CONTROL_PRMAT_MECAN = { "MECAN", 5, "Mechanism",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_CONTROL_PRMAT_parameters[] = {
 &_GEANT_CONTROL_PRMAT_IMATE, &_GEANT_CONTROL_PRMAT_IPART,
 &_GEANT_CONTROL_PRMAT_MECAN };
static char *_GEANT_CONTROL_PRMAT_guidance[] = {
 " CALL GPRMAT(imate,ipart,mecan,nekbin,elow)" };
static KmCommand _GEANT_CONTROL_PRMAT = { &_GEANT_CONTROL_PLMAT,
 "/GEANT/CONTROL/PRMAT", "PRMAT", 0, 2, 3, 3, _GEANT_CONTROL_PRMAT_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_PRMAT_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_PMATE_NUMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PMATE_NUMB = { "NUMB", 4, "Material number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_PMATE_NUMB_type };
static KmParameter *_GEANT_CONTROL_PMATE_parameters[] = {
 &_GEANT_CONTROL_PMATE_NUMB };
static char *_GEANT_CONTROL_PMATE_guidance[] = { " CALL GPMATE(numb)" };
static KmCommand _GEANT_CONTROL_PMATE = { &_GEANT_CONTROL_PRMAT,
 "/GEANT/CONTROL/PMATE", "PMATE", 0, 2, 1, 1, _GEANT_CONTROL_PMATE_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_PMATE_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_SMIXT_IMAT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMIXT_IMAT = { "IMAT", 4, "Material number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_SMIXT_IMAT_type };
static KmParameter _GEANT_CONTROL_SMIXT_NAMATE = { "NAMATE", 6,
 "Material name", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_CONTROL_SMIXT_A_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMIXT_A = { "A", 1, "Atomic weight",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SMIXT_A_type };
static KmParReal   _GEANT_CONTROL_SMIXT_Z_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMIXT_Z = { "Z", 1, "Atomic number",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SMIXT_Z_type };
static KmParReal   _GEANT_CONTROL_SMIXT_DENS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMIXT_DENS = { "DENS", 4, "Density",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SMIXT_DENS_type };
static KmParInt    _GEANT_CONTROL_SMIXT_NLMAT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMIXT_NLMAT = { "NLMAT", 5, "Flag for WMAT",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_SMIXT_NLMAT_type };
static KmParReal   _GEANT_CONTROL_SMIXT_WMAT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMIXT_WMAT = { "WMAT", 4,
 "Relative weights or n. of atoms in molecule", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CONTROL_SMIXT_WMAT_type };
static KmParameter *_GEANT_CONTROL_SMIXT_parameters[] = {
 &_GEANT_CONTROL_SMIXT_IMAT, &_GEANT_CONTROL_SMIXT_NAMATE,
 &_GEANT_CONTROL_SMIXT_A, &_GEANT_CONTROL_SMIXT_Z, &_GEANT_CONTROL_SMIXT_DENS,
 &_GEANT_CONTROL_SMIXT_NLMAT, &_GEANT_CONTROL_SMIXT_WMAT };
static char *_GEANT_CONTROL_SMIXT_guidance[] = {
 " CALL GSMIXT(imat,namate,a,z,dens,nlmat,wmat)" };
static KmCommand _GEANT_CONTROL_SMIXT = { &_GEANT_CONTROL_PMATE,
 "/GEANT/CONTROL/SMIXT", "SMIXT", 0, 2, 7, 7, _GEANT_CONTROL_SMIXT_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_SMIXT_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_SMATE_IMAT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMATE_IMAT = { "IMAT", 4, "Material number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_SMATE_IMAT_type };
static KmParameter _GEANT_CONTROL_SMATE_NAMATE = { "NAMATE", 6,
 "Material name", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_CONTROL_SMATE_A_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMATE_A = { "A", 1, "Atomic weight",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SMATE_A_type };
static KmParReal   _GEANT_CONTROL_SMATE_Z_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMATE_Z = { "Z", 1, "Atomic number",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SMATE_Z_type };
static KmParReal   _GEANT_CONTROL_SMATE_DENS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMATE_DENS = { "DENS", 4, "Density",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SMATE_DENS_type };
static KmParReal   _GEANT_CONTROL_SMATE_RADL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMATE_RADL = { "RADL", 4,
 "Radiation lenght", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CONTROL_SMATE_RADL_type };
static KmParReal   _GEANT_CONTROL_SMATE_ABSL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMATE_ABSL = { "ABSL", 4,
 "Absorption lenght", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CONTROL_SMATE_ABSL_type };
static KmParReal   _GEANT_CONTROL_SMATE_UBUF_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMATE_UBUF = { "UBUF", 4, " ", (char*)0,
 (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CONTROL_SMATE_UBUF_type };
static KmParInt    _GEANT_CONTROL_SMATE_NWBUF_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMATE_NWBUF = { "NWBUF", 5, " ", (char*)0,
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_SMATE_NWBUF_type };
static KmParameter *_GEANT_CONTROL_SMATE_parameters[] = {
 &_GEANT_CONTROL_SMATE_IMAT, &_GEANT_CONTROL_SMATE_NAMATE,
 &_GEANT_CONTROL_SMATE_A, &_GEANT_CONTROL_SMATE_Z, &_GEANT_CONTROL_SMATE_DENS,
 &_GEANT_CONTROL_SMATE_RADL, &_GEANT_CONTROL_SMATE_ABSL,
 &_GEANT_CONTROL_SMATE_UBUF, &_GEANT_CONTROL_SMATE_NWBUF };
static char *_GEANT_CONTROL_SMATE_guidance[] = {
 " CALL GSMATE(imat,namate,a,z,dens,radl,absl,ubuf,nwbuf)" };
static KmCommand _GEANT_CONTROL_SMATE = { &_GEANT_CONTROL_SMIXT,
 "/GEANT/CONTROL/SMATE", "SMATE", 0, 2, 9, 9, _GEANT_CONTROL_SMATE_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_SMATE_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_CONTROL_PDIGI_CHUSET = { "CHUSET", 6, "User set",
 "*", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParameter _GEANT_CONTROL_PDIGI_CHUDET = { "CHUDET", 6,
 "User detector", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_CONTROL_PDIGI_parameters[] = {
 &_GEANT_CONTROL_PDIGI_CHUSET, &_GEANT_CONTROL_PDIGI_CHUDET };
static char *_GEANT_CONTROL_PDIGI_guidance[] = { " CALL GPDIGI(chuset,chudet)"
 };
static KmCommand _GEANT_CONTROL_PDIGI = { &_GEANT_CONTROL_SMATE,
 "/GEANT/CONTROL/PDIGI", "PDIGI", 0, 2, 2, 0, _GEANT_CONTROL_PDIGI_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_PDIGI_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_CONTROL_PHITS_CHUSET = { "CHUSET", 6, "User set",
 "*", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParameter _GEANT_CONTROL_PHITS_CHUDET = { "CHUDET", 6,
 "User detector", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CONTROL_PHITS_NUMHI_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PHITS_NUMHI = { "NUMHI", 5, "Hit number",
 "0", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_PHITS_NUMHI_type };
static KmParameter *_GEANT_CONTROL_PHITS_parameters[] = {
 &_GEANT_CONTROL_PHITS_CHUSET, &_GEANT_CONTROL_PHITS_CHUDET,
 &_GEANT_CONTROL_PHITS_NUMHI };
static char *_GEANT_CONTROL_PHITS_guidance[] = { " CALL GPHITS(chuset,chudet)"
 };
static KmCommand _GEANT_CONTROL_PHITS = { &_GEANT_CONTROL_PDIGI,
 "/GEANT/CONTROL/PHITS", "PHITS", 0, 2, 3, 0, _GEANT_CONTROL_PHITS_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_PHITS_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_OUTPUT_LP_LOUT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_OUTPUT_LP_LOUT = { "LOUT", 4,
 "New output unit", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_OUTPUT_LP_LOUT_type };
static KmParameter *_GEANT_CONTROL_OUTPUT_LP_parameters[] = {
 &_GEANT_CONTROL_OUTPUT_LP_LOUT };
static char *_GEANT_CONTROL_OUTPUT_LP_guidance[] = {
 "To change lout in /GCUNIT/",
 "Note: unit numbers 5,11,12,13,14,15 are reserved and cannot be used." };
static KmCommand _GEANT_CONTROL_OUTPUT_LP = { &_GEANT_CONTROL_PHITS,
 "/GEANT/CONTROL/OUTPUT_LP", "OUTPUT_LP", 0, 2, 1, 1,
 _GEANT_CONTROL_OUTPUT_LP_parameters, 0, 0, gxcont_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_CONTROL_OUTPUT_LP_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CONTROL_PRINT_NAME = { "NAME", 4, "Name", (char*)0,
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParInt    _GEANT_CONTROL_PRINT_NUMBER_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PRINT_NUMBER = { "NUMBER", 6, "Number", "0",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_PRINT_NUMBER_type };
static KmParameter *_GEANT_CONTROL_PRINT_parameters[] = {
 &_GEANT_CONTROL_PRINT_NAME, &_GEANT_CONTROL_PRINT_NUMBER };
static char *_GEANT_CONTROL_PRINT_guidance[] = { " CALL GPRINT(name,number)" };
static KmCommand _GEANT_CONTROL_PRINT = { &_GEANT_CONTROL_OUTPUT_LP,
 "/GEANT/CONTROL/PRINT", "PRINT", 0, 2, 2, 2, _GEANT_CONTROL_PRINT_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_PRINT_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_MZLOGL_LEVEL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_MZLOGL_LEVEL = { "LEVEL", 5, "MZ log level",
 "0", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_MZLOGL_LEVEL_type };
static KmParameter *_GEANT_CONTROL_MZLOGL_parameters[] = {
 &_GEANT_CONTROL_MZLOGL_LEVEL };
static char *_GEANT_CONTROL_MZLOGL_guidance[] = {
 "Set the log level for the MZ package of ZEBRA: CALL MZLOGL(0,level)",
 " LEVEL = -3   no messages at all", "         -2   error messages only",
 "         -1   terse logging", "          0   normal",
 "         +1   log rare events", "         +2   log calls to MZ routines" };
static KmCommand _GEANT_CONTROL_MZLOGL = { &_GEANT_CONTROL_PRINT,
 "/GEANT/CONTROL/MZLOGL", "MZLOGL", 0, 2, 1, 1,
 _GEANT_CONTROL_MZLOGL_parameters, 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 7, _GEANT_CONTROL_MZLOGL_guidance, 0, (char**)0, 0, (char**)0,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_SWITCH_ISWI_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SWITCH_ISWI = { "ISWI", 4, "Switch number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_SWITCH_ISWI_type };
static KmParInt    _GEANT_CONTROL_SWITCH_IVAL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SWITCH_IVAL = { "IVAL", 4,
 "New switch value", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_SWITCH_IVAL_type };
static KmParameter *_GEANT_CONTROL_SWITCH_parameters[] = {
 &_GEANT_CONTROL_SWITCH_ISWI, &_GEANT_CONTROL_SWITCH_IVAL };
static char *_GEANT_CONTROL_SWITCH_guidance[] = {
 "Change one element of array ISWIT(10) in /GCFLAG/" };
static KmCommand _GEANT_CONTROL_SWITCH = { &_GEANT_CONTROL_MZLOGL,
 "/GEANT/CONTROL/SWITCH", "SWITCH", 0, 2, 2, 2,
 _GEANT_CONTROL_SWITCH_parameters, 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 1, _GEANT_CONTROL_SWITCH_guidance, 0, (char**)0, 0, (char**)0,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_RNDM_ISEED1_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_RNDM_ISEED1 = { "ISEED1", 6,
 "First seed for the random number generator", (char*)0, (char*)0, 8, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_RNDM_ISEED1_type };
static KmParInt    _GEANT_CONTROL_RNDM_ISEED2_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_RNDM_ISEED2 = { "ISEED2", 6,
 "Second seed for the random number generator", (char*)0, (char*)0, 8, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_RNDM_ISEED2_type };
static KmParameter *_GEANT_CONTROL_RNDM_parameters[] = {
 &_GEANT_CONTROL_RNDM_ISEED1, &_GEANT_CONTROL_RNDM_ISEED2 };
static char *_GEANT_CONTROL_RNDM_guidance[] = {
 "Set the seeds for the random number generator. If no numbers are",
 "given, the currents seeds are printed." };
static KmCommand _GEANT_CONTROL_RNDM = { &_GEANT_CONTROL_SWITCH,
 "/GEANT/CONTROL/RNDM", "RNDM", 0, 2, 2, 0, _GEANT_CONTROL_RNDM_parameters, 0,
 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_CONTROL_RNDM_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_TRIGGER_N_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_TRIGGER_N = { "N", 1, "Number of events",
 "1", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_TRIGGER_N_type };
static KmParameter *_GEANT_CONTROL_TRIGGER_parameters[] = {
 &_GEANT_CONTROL_TRIGGER_N };
static char *_GEANT_CONTROL_TRIGGER_guidance[] = {
 "Start one or more new events." };
static KmCommand _GEANT_CONTROL_TRIGGER = { &_GEANT_CONTROL_RNDM,
 "/GEANT/CONTROL/TRIGGER", "TRIGGER", 0, 2, 1, 0,
 _GEANT_CONTROL_TRIGGER_parameters, 0, 0, gxcont_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 1, _GEANT_CONTROL_TRIGGER_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_CONTROL_TRACK_guidance[] = {
 "Restart tracking, clearing the track and hit",
 "banks, but keeping the kinematics." };
static KmCommand _GEANT_CONTROL_TRACK = { &_GEANT_CONTROL_TRIGGER,
 "/GEANT/CONTROL/TRACK", "TRACK", 0, 2, 0, 0, (KmParameter**)0, 0, 0, gxcont_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_CONTROL_TRACK_guidance,
 0, (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_CONTROL_GTIME_TIMINT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_GTIME_TIMINT = { "TIMINT", 6,
 "Total time after initialisation", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CONTROL_GTIME_TIMINT_type };
static KmParReal   _GEANT_CONTROL_GTIME_TIMEND_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_GTIME_TIMEND = { "TIMEND", 6,
 "Time reserved for the termination phase", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CONTROL_GTIME_TIMEND_type };
static KmParInt    _GEANT_CONTROL_GTIME_ITIME_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_GTIME_ITIME = { "ITIME", 5,
 "Frequency of control printing", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_GTIME_ITIME_type };
static KmParameter *_GEANT_CONTROL_GTIME_parameters[] = {
 &_GEANT_CONTROL_GTIME_TIMINT, &_GEANT_CONTROL_GTIME_TIMEND,
 &_GEANT_CONTROL_GTIME_ITIME };
static char *_GEANT_CONTROL_GTIME_guidance[] = {
 "These commands have limited use in the interactive version. In",
 "particular the value of TIMINT is disregarded by GEANT." };
static KmCommand _GEANT_CONTROL_GTIME = { &_GEANT_CONTROL_TRACK,
 "/GEANT/CONTROL/GTIME", "GTIME", 0, 2, 3, 3, _GEANT_CONTROL_GTIME_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_CONTROL_GTIME_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_CONTROL_SORD_ISTORD_range[] = { "1", "0" };
static KmParInt    _GEANT_CONTROL_SORD_ISTORD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SORD_ISTORD = { "ISTORD", 6,
 "Flag to control user ordering of the stack", "1", (char*)0, 8, 2,
 _GEANT_CONTROL_SORD_ISTORD_range, 2, _GEANT_CONTROL_SORD_ISTORD_range,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_SORD_ISTORD_type };
static KmParameter *_GEANT_CONTROL_SORD_parameters[] = {
 &_GEANT_CONTROL_SORD_ISTORD };
static char *_GEANT_CONTROL_SORD_guidance[] = {
 "If ISTORD is set to 1, the particle with the highest value of the",
 "user weight UPWGHT will be selected to be tracked next." };
static KmCommand _GEANT_CONTROL_SORD = { &_GEANT_CONTROL_GTIME,
 "/GEANT/CONTROL/SORD", "SORD", 0, 2, 1, 1, _GEANT_CONTROL_SORD_parameters, 0,
 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_CONTROL_SORD_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_RUNG_IDRUN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_RUNG_IDRUN = { "IDRUN", 5,
 "User run number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_RUNG_IDRUN_type };
static KmParInt    _GEANT_CONTROL_RUNG_IDEVT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_RUNG_IDEVT = { "IDEVT", 5,
 "User starting event number", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_RUNG_IDEVT_type };
static KmParameter *_GEANT_CONTROL_RUNG_parameters[] = {
 &_GEANT_CONTROL_RUNG_IDRUN, &_GEANT_CONTROL_RUNG_IDEVT };
static char *_GEANT_CONTROL_RUNG_guidance[] = {
 "Set the run number and the starting value for the user event number." };
static KmCommand _GEANT_CONTROL_RUNG = { &_GEANT_CONTROL_SORD,
 "/GEANT/CONTROL/RUNG", "RUNG", 0, 2, 2, 2, _GEANT_CONTROL_RUNG_parameters, 0,
 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_RUNG_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_KINE_IKINE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_IKINE = { "IKINE", 5, "IKINE", "1",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_KINE_IKINE_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE1_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE1 = { "PKINE1", 6, "PKINE(1)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE1_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE2_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE2 = { "PKINE2", 6, "PKINE(2)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE2_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE3_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE3 = { "PKINE3", 6, "PKINE(3)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE3_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE4_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE4 = { "PKINE4", 6, "PKINE(4)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE4_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE5_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE5 = { "PKINE5", 6, "PKINE(5)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE5_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE6_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE6 = { "PKINE6", 6, "PKINE(6)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE6_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE7_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE7 = { "PKINE7", 6, "PKINE(7)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE7_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE8_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE8 = { "PKINE8", 6, "PKINE(8)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE8_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE9_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE9 = { "PKINE9", 6, "PKINE(9)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE9_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE10_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE10 = { "PKINE10", 7, "PKINE(10)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE10_type };
static KmParameter *_GEANT_CONTROL_KINE_parameters[] = {
 &_GEANT_CONTROL_KINE_IKINE, &_GEANT_CONTROL_KINE_PKINE1,
 &_GEANT_CONTROL_KINE_PKINE2, &_GEANT_CONTROL_KINE_PKINE3,
 &_GEANT_CONTROL_KINE_PKINE4, &_GEANT_CONTROL_KINE_PKINE5,
 &_GEANT_CONTROL_KINE_PKINE6, &_GEANT_CONTROL_KINE_PKINE7,
 &_GEANT_CONTROL_KINE_PKINE8, &_GEANT_CONTROL_KINE_PKINE9,
 &_GEANT_CONTROL_KINE_PKINE10 };
static char *_GEANT_CONTROL_KINE_guidance[] = {
 "Set the variables in /GCFLAG/ IKINE, PKINE(10)" };
static KmCommand _GEANT_CONTROL_KINE = { &_GEANT_CONTROL_RUNG,
 "/GEANT/CONTROL/KINE", "KINE", 0, 2, 11, 1, _GEANT_CONTROL_KINE_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_KINE_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_CONTROL_guidance[] = { "Control commands." };
static KmMenu _GEANT_CONTROL = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/CONTROL",
 "CONTROL", 2, &_GEANT_CONTROL_KINE, 1, _GEANT_CONTROL_guidance, 0, (char**)0,
 0, (char**)0 };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_CONTROL, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 0, (char**)0, 0, (char**)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 950303 );
}
 
 
#ifdef F77_LCASE
#  define gkdz_ gkdz
#  define gxdz_ gxdz
#endif
 
#ifdef F77_UCASE
#  define gkdz_ GKDZ
#  define gxdz_ GXDZ
#endif
 
#ifdef IBM370
#  pragma linkage(GKDZ,FORTRAN)
#  pragma linkage(GXDZ,FORTRAN)
#endif
 
extern void gkdz_();
extern void gxdz_();
 
void gkdz_()
{
 
static KmParameter _GEANT_DZ_DIRZ_PATH = { "PATH", 4,
 "Name of the RZ directory to analyse", (char*)0, (char*)0, 20, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_DZ_DIRZ_parameters[] = { &_GEANT_DZ_DIRZ_PATH };
static char *_GEANT_DZ_DIRZ_guidance[] = {
 "Facility to display RZ directory trees.",
 " CALL DZDIRZ(0,LDUMMY,0,path,'N',1,0,1)" };
static KmCommand _GEANT_DZ_DIRZ = {  (KmCommand*)0, "/GEANT/DZ/DIRZ", "DIRZ",
 0, 2, 1, 0, _GEANT_DZ_DIRZ_parameters, 0, 0, gxdz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_DZ_DIRZ_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DZ_DISP_BANK = { "BANK", 4, "Name of the bank",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_DZ_DISP_PATH = { "PATH", 4, "Name of the doc file",
 " ", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParInt    _GEANT_DZ_DISP_NUMBER_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DZ_DISP_NUMBER = { "NUMBER", 6,
 "Number of the bank", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DZ_DISP_NUMBER_type };
static KmParameter *_GEANT_DZ_DISP_parameters[] = { &_GEANT_DZ_DISP_BANK,
 &_GEANT_DZ_DISP_PATH, &_GEANT_DZ_DISP_NUMBER };
static char *_GEANT_DZ_DISP_guidance[] = { "Interactive bank display tool.",
 " CALL DZDISP(IXSTOR,LBANK,path,'N',1,0,1,IWTYPE)" };
static KmCommand _GEANT_DZ_DISP = { &_GEANT_DZ_DIRZ, "/GEANT/DZ/DISP", "DISP",
 0, 2, 3, 1, _GEANT_DZ_DISP_parameters, 0, 0, gxdz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_DZ_DISP_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DZ_DDIV_IDIV_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_DZ_DDIV_IDIV = { "IDIV", 4, "Division number", "2",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DZ_DDIV_IDIV_type };
static KmParameter _GEANT_DZ_DDIV_PATH = { "PATH", 4, "Name of the doc file",
 " ", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParameter *_GEANT_DZ_DDIV_parameters[] = { &_GEANT_DZ_DDIV_IDIV,
 &_GEANT_DZ_DDIV_PATH };
static char *_GEANT_DZ_DDIV_guidance[] = {
 "Facility to display the layout of stores and divisions.",
 " CALL DZDDIV(idiv,LDUMMY,path,'IN',1,0,1,IWTYPE)" };
static KmCommand _GEANT_DZ_DDIV = { &_GEANT_DZ_DISP, "/GEANT/DZ/DDIV", "DDIV",
 0, 2, 2, 0, _GEANT_DZ_DDIV_parameters, 0, 0, gxdz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_DZ_DDIV_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DZ_STORE_IXSTOR_type = { "0", "24", "0", "24", 0 };
static KmParameter _GEANT_DZ_STORE_IXSTOR = { "IXSTOR", 6, "Store number",
 "0", (char*)0, 3, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DZ_STORE_IXSTOR_type };
static KmParameter *_GEANT_DZ_STORE_parameters[] = { &_GEANT_DZ_STORE_IXSTOR };
static char *_GEANT_DZ_STORE_guidance[] = {
 "Display the structure of the ZEBRA store IXSTOR.",
 "Output the parameters characterizing the store, followed by a",
 "list of all divisions and all link areas associated with the store in",
 "question." };
static KmCommand _GEANT_DZ_STORE = { &_GEANT_DZ_DDIV, "/GEANT/DZ/STORE",
 "STORE", 0, 2, 1, 0, _GEANT_DZ_STORE_parameters, 0, 0, gxdz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 4, _GEANT_DZ_STORE_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DZ_VERIFY_IDIV_type = { "0", "24", "0", "24", 0 };
static KmParameter _GEANT_DZ_VERIFY_IDIV = { "IDIV", 4, "Division number ",
 "0", (char*)0, 3, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DZ_VERIFY_IDIV_type };
static KmParOption _GEANT_DZ_VERIFY_CHOPT_type = { (char**)0, (int*)0, (int*)0
 };
static KmParameter _GEANT_DZ_VERIFY_CHOPT = { "CHOPT", 5, "Options", "CLSU",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_DZ_VERIFY_CHOPT_type };
static KmParameter *_GEANT_DZ_VERIFY_parameters[] = { &_GEANT_DZ_VERIFY_IDIV,
 &_GEANT_DZ_VERIFY_CHOPT };
static char *_GEANT_DZ_VERIFY_guidance[] = {
 "Check the structure of one or more ZEBRA divisions.",
 "The verification detail depends on the settings in CHOPT.",
 " CHOPT='C' Check chaining of banks only",
 " CHOPT='L' Check validity of the structural links (implies 'C')",
 " CHOPT='S' Check the store parameters",
 " CHOPT='U' Check the validity of the up and origin (implies 'C')",
 " CHOPT='F' Errors are considered fatal and generate a call to ZFATAL" };
static KmCommand _GEANT_DZ_VERIFY = { &_GEANT_DZ_STORE, "/GEANT/DZ/VERIFY",
 "VERIFY", 0, 2, 2, 0, _GEANT_DZ_VERIFY_parameters, 0, 0, gxdz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 7, _GEANT_DZ_VERIFY_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DZ_SNAP_IDIV_type = { "0", "24", "0", "24", 0 };
static KmParameter _GEANT_DZ_SNAP_IDIV = { "IDIV", 4, "Division number ", "2",
 (char*)0, 3, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DZ_SNAP_IDIV_type };
static KmParOption _GEANT_DZ_SNAP_CHOPT_type = { (char**)0, (int*)0, (int*)0 };
static KmParameter _GEANT_DZ_SNAP_CHOPT = { "CHOPT", 5, "Options", "M",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_DZ_SNAP_CHOPT_type };
static KmParameter *_GEANT_DZ_SNAP_parameters[] = { &_GEANT_DZ_SNAP_IDIV,
 &_GEANT_DZ_SNAP_CHOPT };
static char *_GEANT_DZ_SNAP_guidance[] = { "Snap of one or more divisions.",
 "Provides a snapshot of one or more divisions in a ZEBRA store.",
 "The kind of information provided is controlled by CHOPT.",
 " CHOPT='M' Print Map entry for each bank",
 " CHOPT='E' Extend map entry to dump all links of each bank",
 "           (otherwise only as many links as will fit on a line)",
 " CHOPT='F' Full. Dump all active banks, links and data",
 " CHOPT='K' Kill. Dropped banks to be treated as active",
 "           (dropped banks are not normally dumped under D or F option)",
 " CHOPT='L' Dump all Link areas associated with the store",
 " CHOPT='W' Dump the Working space, links and data",
 " CHOPT='Z' Dump the information in hexadecimal." };
static KmCommand _GEANT_DZ_SNAP = { &_GEANT_DZ_VERIFY, "/GEANT/DZ/SNAP",
 "SNAP", 0, 2, 2, 0, _GEANT_DZ_SNAP_parameters, 0, 0, gxdz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 12, _GEANT_DZ_SNAP_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DZ_SHOW_NAME = { "NAME", 4, "Bank name", (char*)0,
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParInt    _GEANT_DZ_SHOW_NUMBER_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DZ_SHOW_NUMBER = { "NUMBER", 6, "Bank number", "1",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DZ_SHOW_NUMBER_type };
static KmParOption _GEANT_DZ_SHOW_CHOPT_type = { (char**)0, (int*)0, (int*)0 };
static KmParameter _GEANT_DZ_SHOW_CHOPT = { "CHOPT", 5, "Options", "BSV",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_DZ_SHOW_CHOPT_type };
static KmParameter *_GEANT_DZ_SHOW_parameters[] = { &_GEANT_DZ_SHOW_NAME,
 &_GEANT_DZ_SHOW_NUMBER, &_GEANT_DZ_SHOW_CHOPT };
static char *_GEANT_DZ_SHOW_guidance[] = {
 "Display the contents of a bank or a data structure",
 "identified by its NAME and NUMBER.",
 "The output format of the data part is controlled by the internal",
 "or external I/O characteristic.", " CHOPT='B' Print the bank.",
 " CHOPT='S' Print the bank contents from left to right Sideways",
 "           with up to ten elements per line.",
 " CHOPT='V' Print the vertical (down) structure.",
 " CHOPT='D' Print the bank contents from top to bottom Downwards",
 "           with five elements per line.",
 " CHOPT='L' Print the linear structure.",
 " CHOPT='Z' Print the data part of each bank in hexadecimal format" };
static KmCommand _GEANT_DZ_SHOW = { &_GEANT_DZ_SNAP, "/GEANT/DZ/SHOW", "SHOW",
 0, 2, 3, 1, _GEANT_DZ_SHOW_parameters, 0, 0, gxdz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 12, _GEANT_DZ_SHOW_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DZ_SURV_NAME = { "NAME", 4, "Bank name", (char*)0,
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParInt    _GEANT_DZ_SURV_NUMBER_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DZ_SURV_NUMBER = { "NUMBER", 6, "Bank number", "1",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DZ_SURV_NUMBER_type };
static KmParameter *_GEANT_DZ_SURV_parameters[] = { &_GEANT_DZ_SURV_NAME,
 &_GEANT_DZ_SURV_NUMBER };
static char *_GEANT_DZ_SURV_guidance[] = {
 "Print a survey of the structure identified by NAME, NUMBER." };
static KmCommand _GEANT_DZ_SURV = { &_GEANT_DZ_SHOW, "/GEANT/DZ/SURV", "SURV",
 0, 2, 2, 1, _GEANT_DZ_SURV_parameters, 0, 0, gxdz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 1, _GEANT_DZ_SURV_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmMenu _GEANT_DZ = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/DZ", "DZ", 2,
 &_GEANT_DZ_SURV, 0, (char**)0, 0, (char**)0, 0, (char**)0 };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_DZ, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 0, (char**)0, 0, (char**)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 950303 );
}
 
 
#ifdef F77_LCASE
#  define gkfz_ gkfz
#  define gxfz_ gxfz
#endif
 
#ifdef F77_UCASE
#  define gkfz_ GKFZ
#  define gxfz_ GXFZ
#endif
 
#ifdef IBM370
#  pragma linkage(GKFZ,FORTRAN)
#  pragma linkage(GXFZ,FORTRAN)
#endif
 
extern void gkfz_();
extern void gxfz_();
 
void gkfz_()
{
 
static KmParInt    _GEANT_FZ_FZCLOSE_LUN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_FZ_FZCLOSE_LUN = { "LUN", 3,
 "Fortran unit of the FZ to close", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_FZ_FZCLOSE_LUN_type };
static KmParameter *_GEANT_FZ_FZCLOSE_parameters[] = { &_GEANT_FZ_FZCLOSE_LUN
 };
static char *_GEANT_FZ_FZCLOSE_guidance[] = { "Equivalent to a call to:",
 "       CALL GCLOSE(LUN,IER)" };
static KmCommand _GEANT_FZ_FZCLOSE = {  (KmCommand*)0, "/GEANT/FZ/FZCLOSE",
 "FZCLOSE", 0, 2, 1, 1, _GEANT_FZ_FZCLOSE_parameters, 0, 0, gxfz_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_FZ_FZCLOSE_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_FZ_FZOUT_LUN_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_FZ_FZOUT_LUN = { "LUN", 3,
 "Fortran unit of the FZ file", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_FZ_FZOUT_LUN_type };
static KmParameter _GEANT_FZ_FZOUT_KEYSU = { "KEYSU", 5,
 "Name of the data structure to be saved", (char*)0, (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_FZ_FZOUT_IDENT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_FZ_FZOUT_IDENT = { "IDENT", 5,
 "Version of the data structure to be saved", "1", (char*)0, 8, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_FZ_FZOUT_IDENT_type };
static KmParameter *_GEANT_FZ_FZOUT_parameters[] = { &_GEANT_FZ_FZOUT_LUN,
 &_GEANT_FZ_FZOUT_KEYSU, &_GEANT_FZ_FZOUT_IDENT };
static char *_GEANT_FZ_FZOUT_guidance[] = { "Equivalent to a call to:",
 "       CALL GFOUT(LUN,KEYSU,1,IDENT,' ',IER)" };
static KmCommand _GEANT_FZ_FZOUT = { &_GEANT_FZ_FZCLOSE, "/GEANT/FZ/FZOUT",
 "FZOUT", 0, 2, 3, 2, _GEANT_FZ_FZOUT_parameters, 0, 0, gxfz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_FZ_FZOUT_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_FZ_FZOPEN_LUN_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_FZ_FZOPEN_LUN = { "LUN", 3,
 "Fortran unit with which to open the file", (char*)0, (char*)0, 8, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_FZ_FZOPEN_LUN_type
 };
static KmParameter _GEANT_FZ_FZOPEN_FILE = { "FILE", 4,
 "Name of the file to be opened", (char*)0, (char*)0, 20, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_FZ_FZOPEN_LUNTYP = { "LUNTYP", 6,
 "Type of FZ file to be opened by GOPEN", "XI", (char*)0, 20, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_FZ_FZOPEN_LEN_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_FZ_FZOPEN_LEN = { "LEN", 3,
 "Recordlenght of the file", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_FZ_FZOPEN_LEN_type };
static KmParOption _GEANT_FZ_FZOPEN_CHOPT_type = { (char**)0, (int*)0, (int*)0
 };
static KmParameter _GEANT_FZ_FZOPEN_CHOPT = { "CHOPT", 5,
 "Optional parameter to specify the action", " ", (char*)0, 20, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION, &_GEANT_FZ_FZOPEN_CHOPT_type };
static KmParameter *_GEANT_FZ_FZOPEN_parameters[] = { &_GEANT_FZ_FZOPEN_LUN,
 &_GEANT_FZ_FZOPEN_FILE, &_GEANT_FZ_FZOPEN_LUNTYP, &_GEANT_FZ_FZOPEN_LEN,
 &_GEANT_FZ_FZOPEN_CHOPT };
static char *_GEANT_FZ_FZOPEN_guidance[] = { "Equivalent to a call to:",
 "       CALL GOPEN(LUN,FILE,LUNTYP,LEN,IER)",
 "If CHOPT = I then a call to GFIN or GFOUT will be performed in addition",
 "according to the value of LUNTYP, with the key INIT to save or retrieve",
 "the whole initialization data structure." };
static KmCommand _GEANT_FZ_FZOPEN = { &_GEANT_FZ_FZOUT, "/GEANT/FZ/FZOPEN",
 "FZOPEN", 0, 2, 5, 4, _GEANT_FZ_FZOPEN_parameters, 0, 0, gxfz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 5, _GEANT_FZ_FZOPEN_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_FZ_FZIN_LUN_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_FZ_FZIN_LUN = { "LUN", 3,
 "Fortran unit of the FZ file", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_FZ_FZIN_LUN_type };
static KmParameter _GEANT_FZ_FZIN_KEYSU = { "KEYSU", 5,
 "Name of the data structure to be retrieved", (char*)0, (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_FZ_FZIN_IDENT_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_FZ_FZIN_IDENT = { "IDENT", 5,
 "Version of the data structure to be retrieved", "0", (char*)0, 8, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_FZ_FZIN_IDENT_type
 };
static KmParameter *_GEANT_FZ_FZIN_parameters[] = { &_GEANT_FZ_FZIN_LUN,
 &_GEANT_FZ_FZIN_KEYSU, &_GEANT_FZ_FZIN_IDENT };
static char *_GEANT_FZ_FZIN_guidance[] = { "Equivalent to a call to:",
 "       CALL GFIN(LUN,KEYSU,1,IDENT,' ',IER)" };
static KmCommand _GEANT_FZ_FZIN = { &_GEANT_FZ_FZOPEN, "/GEANT/FZ/FZIN",
 "FZIN", 0, 2, 3, 2, _GEANT_FZ_FZIN_parameters, 0, 0, gxfz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_FZ_FZIN_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_FZ_guidance[] = { "ZEBRA/FZ commands" };
static KmMenu _GEANT_FZ = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/FZ", "FZ", 2,
 &_GEANT_FZ_FZIN, 1, _GEANT_FZ_guidance, 0, (char**)0, 0, (char**)0 };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_FZ, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 0, (char**)0, 0, (char**)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 950303 );
}
 
 
#ifdef F77_LCASE
#  define gkrz_ gkrz
#  define gxrz_ gxrz
#endif
 
#ifdef F77_UCASE
#  define gkrz_ GKRZ
#  define gxrz_ GXRZ
#endif
 
#ifdef IBM370
#  pragma linkage(GKRZ,FORTRAN)
#  pragma linkage(GXRZ,FORTRAN)
#endif
 
extern void gkrz_();
extern void gxrz_();
 
void gkrz_()
{
 
static KmParameter _GEANT_RZ_FREE_CHDIR = { "CHDIR", 5, "Lock identifier",
 "RZFILE", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_RZ_FREE_parameters[] = { &_GEANT_RZ_FREE_CHDIR };
static char *_GEANT_RZ_FREE_guidance[] = { "Free an RZ directory." };
static KmCommand _GEANT_RZ_FREE = {  (KmCommand*)0, "/GEANT/RZ/FREE", "FREE",
 0, 2, 1, 1, _GEANT_RZ_FREE_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 1, _GEANT_RZ_FREE_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_RZ_LOCK_CHDIR = { "CHDIR", 5, "Lock identifier",
 "RZFILE", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_RZ_LOCK_parameters[] = { &_GEANT_RZ_LOCK_CHDIR };
static char *_GEANT_RZ_LOCK_guidance[] = { "Lock an RZ directory." };
static KmCommand _GEANT_RZ_LOCK = { &_GEANT_RZ_FREE, "/GEANT/RZ/LOCK", "LOCK",
 0, 2, 1, 1, _GEANT_RZ_LOCK_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 1, _GEANT_RZ_LOCK_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_RZ_SCR_OBJECT = { "OBJECT", 6, "Structure name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_RZ_SCR_IDVERS_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_RZ_SCR_IDVERS = { "IDVERS", 6, "Version number",
 "1", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_RZ_SCR_IDVERS_type };
static KmParameter *_GEANT_RZ_SCR_parameters[] = { &_GEANT_RZ_SCR_OBJECT,
 &_GEANT_RZ_SCR_IDVERS };
static char *_GEANT_RZ_SCR_guidance[] = {
 "Delete entry identified by OBJECT,IDVERS on RZ file.",
 "OBJECT may be : MATE,TMED,VOLU,ROTM,SETS,PART,SCAN, *",
 "If OBJECT= *    delete all entries with IDVERS." };
static KmCommand _GEANT_RZ_SCR = { &_GEANT_RZ_LOCK, "/GEANT/RZ/SCR", "SCR", 0,
 2, 2, 1, _GEANT_RZ_SCR_parameters, 0, 0, gxrz_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 3, _GEANT_RZ_SCR_guidance, 0, (char**)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_RZ_PURGE_NKEEP_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_RZ_PURGE_NKEEP = { "NKEEP", 5,
 "Number of cycles to keep", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_RZ_PURGE_NKEEP_type };
static KmParameter *_GEANT_RZ_PURGE_parameters[] = { &_GEANT_RZ_PURGE_NKEEP };
static char *_GEANT_RZ_PURGE_guidance[] = { "Purge an RZ directory." };
static KmCommand _GEANT_RZ_PURGE = { &_GEANT_RZ_SCR, "/GEANT/RZ/PURGE",
 "PURGE", 0, 2, 1, 0, _GEANT_RZ_PURGE_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 1, _GEANT_RZ_PURGE_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_RZ_LDIR_CHPATH = { "CHPATH", 6, "Path name", " ",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParOption _GEANT_RZ_LDIR_CHOPT_type = { (char**)0, (int*)0, (int*)0 };
static KmParameter _GEANT_RZ_LDIR_CHOPT = { "CHOPT", 5, "CHOPT", " ",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_RZ_LDIR_CHOPT_type };
static KmParameter *_GEANT_RZ_LDIR_parameters[] = { &_GEANT_RZ_LDIR_CHPATH,
 &_GEANT_RZ_LDIR_CHOPT };
static char *_GEANT_RZ_LDIR_guidance[] = {
 "List the contents of a directory (memory or disk).",
 "To list all RZ files currently open, type 'LD //'." };
static KmCommand _GEANT_RZ_LDIR = { &_GEANT_RZ_PURGE, "/GEANT/RZ/LDIR",
 "LDIR", 0, 2, 2, 0, _GEANT_RZ_LDIR_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_RZ_LDIR_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_RZ_OUT_OBJECT = { "OBJECT", 6, "Structure name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_RZ_OUT_IDVERS_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_RZ_OUT_IDVERS = { "IDVERS", 6, "Version number",
 "1", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_RZ_OUT_IDVERS_type };
static KmParOption _GEANT_RZ_OUT_CHOPT_type = { (char**)0, (int*)0, (int*)0 };
static KmParameter _GEANT_RZ_OUT_CHOPT = { "CHOPT", 5, "Option", " ",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_RZ_OUT_CHOPT_type };
static KmParameter *_GEANT_RZ_OUT_parameters[] = { &_GEANT_RZ_OUT_OBJECT,
 &_GEANT_RZ_OUT_IDVERS, &_GEANT_RZ_OUT_CHOPT };
static char *_GEANT_RZ_OUT_guidance[] = {
 "Write data structure identified by OBJECT,IDVERS to RZ file.",
 "  MATE write JMATE structure", "  TMED write JTMED structure",
 "  VOLU write JVOLUM structure", "  ROTM write JROTM structure",
 "  SETS write JSET  structure", "  PART write JPART structure",
 "  SCAN write LSCAN structure", "  INIT write all above data structures" };
static KmCommand _GEANT_RZ_OUT = { &_GEANT_RZ_LDIR, "/GEANT/RZ/OUT", "OUT", 0,
 2, 3, 1, _GEANT_RZ_OUT_parameters, 0, 0, gxrz_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 9, _GEANT_RZ_OUT_guidance, 0, (char**)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_RZ_IN_OBJECT = { "OBJECT", 6, "Structure name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_RZ_IN_IDVERS_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_RZ_IN_IDVERS = { "IDVERS", 6, "Version number", "1",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_RZ_IN_IDVERS_type };
static KmParOption _GEANT_RZ_IN_CHOPT_type = { (char**)0, (int*)0, (int*)0 };
static KmParameter _GEANT_RZ_IN_CHOPT = { "CHOPT", 5, "Option", " ", (char*)0,
 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_RZ_IN_CHOPT_type };
static KmParameter *_GEANT_RZ_IN_parameters[] = { &_GEANT_RZ_IN_OBJECT,
 &_GEANT_RZ_IN_IDVERS, &_GEANT_RZ_IN_CHOPT };
static char *_GEANT_RZ_IN_guidance[] = {
 "Read data structure identified by OBJECT,IDVERS into memory.",
 "  MATE read JMATE structure", "  TMED read JTMED structure",
 "  VOLU read JVOLUM structure", "  ROTM read JROTM structure",
 "  SETS read JSET  structure", "  PART read JPART structure",
 "  SCAN read LSCAN structure", "  INIT read all above data structures" };
static KmCommand _GEANT_RZ_IN = { &_GEANT_RZ_OUT, "/GEANT/RZ/IN", "IN", 0, 2,
 3, 1, _GEANT_RZ_IN_parameters, 0, 0, gxrz_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 9, _GEANT_RZ_IN_guidance, 0, (char**)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_RZ_CDIR_CHPATH = { "CHPATH", 6, "Path name", " ",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParOption _GEANT_RZ_CDIR_CHOPT_type = { (char**)0, (int*)0, (int*)0 };
static KmParameter _GEANT_RZ_CDIR_CHOPT = { "CHOPT", 5, "CHOPT", " ",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_RZ_CDIR_CHOPT_type };
static KmParameter *_GEANT_RZ_CDIR_parameters[] = { &_GEANT_RZ_CDIR_CHPATH,
 &_GEANT_RZ_CDIR_CHOPT };
static char *_GEANT_RZ_CDIR_guidance[] = {
 "Change or print the current directory.",
 " Ex.  CD dir1         ; make DIR1 the new CWD",
 "      CD //file1/dir2 ; make //FILE1/DIR2 the new CWD",
 "      CD              ; print the name of the CWD" };
static KmCommand _GEANT_RZ_CDIR = { &_GEANT_RZ_IN, "/GEANT/RZ/CDIR", "CDIR",
 0, 2, 2, 0, _GEANT_RZ_CDIR_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 4, _GEANT_RZ_CDIR_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_RZ_MDIR_CHDIR = { "CHDIR", 5, "Directory name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParOption _GEANT_RZ_MDIR_CHOPT_type = { (char**)0, (int*)0, (int*)0 };
static KmParameter _GEANT_RZ_MDIR_CHOPT = { "CHOPT", 5, "Options", " ",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_RZ_MDIR_CHOPT_type };
static KmParameter *_GEANT_RZ_MDIR_parameters[] = { &_GEANT_RZ_MDIR_CHDIR,
 &_GEANT_RZ_MDIR_CHOPT };
static char *_GEANT_RZ_MDIR_guidance[] = {
 "To create a new RZ directory below the current directory.", "with",
 " RZTAGS(1)='Object'", " RZTAGS(2)='Idvers-NR '" };
static KmCommand _GEANT_RZ_MDIR = { &_GEANT_RZ_CDIR, "/GEANT/RZ/MDIR", "MDIR",
 0, 2, 2, 1, _GEANT_RZ_MDIR_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 4, _GEANT_RZ_MDIR_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_RZ_REND_LUNRZ_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_RZ_REND_LUNRZ = { "LUNRZ", 5, "Logical unit number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_RZ_REND_LUNRZ_type };
static KmParameter *_GEANT_RZ_REND_parameters[] = { &_GEANT_RZ_REND_LUNRZ };
static char *_GEANT_RZ_REND_guidance[] = {
 "Close an RZ file opened by GRFILE on logical unit LUNRZ.",
 " CALL GREND(LUNRZ)" };
static KmCommand _GEANT_RZ_REND = { &_GEANT_RZ_MDIR, "/GEANT/RZ/REND", "REND",
 0, 2, 1, 1, _GEANT_RZ_REND_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_RZ_REND_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_RZ_FILE_LUN_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_RZ_FILE_LUN = { "LUN", 3, "Logical unit number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_RZ_FILE_LUN_type };
static KmParameter _GEANT_RZ_FILE_FNAME = { "FNAME", 5, "File name", (char*)0,
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static char *_GEANT_RZ_FILE_CHOPT_range[] = { " ", "A", "N", "U" };
static char *_GEANT_RZ_FILE_CHOPT_text[] = { (char*)0, (char*)0, (char*)0,
 (char*)0 };
static KmParOption _GEANT_RZ_FILE_CHOPT_type = { _GEANT_RZ_FILE_CHOPT_text,
 (int*)0, (int*)0 };
static KmParameter _GEANT_RZ_FILE_CHOPT = { "CHOPT", 5, "Options", " ",
 (char*)0, 8, 4, _GEANT_RZ_FILE_CHOPT_range, 4, _GEANT_RZ_FILE_CHOPT_range,
 (KmParFlag)0, KmTYPE_OPTION, &_GEANT_RZ_FILE_CHOPT_type };
static KmParameter *_GEANT_RZ_FILE_parameters[] = { &_GEANT_RZ_FILE_LUN,
 &_GEANT_RZ_FILE_FNAME, &_GEANT_RZ_FILE_CHOPT };
static char *_GEANT_RZ_FILE_guidance[] = { "Open a GRZ file.",
 " CHOPT=' ' readonly mode", " CHOPT='U' update mode",
 " CHOPT='N' create new file",
 " CHOPT='I' Read all structures from existing file",
 " CHOPT='O' Write all structures on file" };
static KmCommand _GEANT_RZ_FILE = { &_GEANT_RZ_REND, "/GEANT/RZ/FILE", "FILE",
 0, 2, 3, 2, _GEANT_RZ_FILE_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 6, _GEANT_RZ_FILE_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_RZ_PQUEST_IQ1_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_RZ_PQUEST_IQ1 = { "IQ1", 3,
 "Lower limit for IQ index", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_RZ_PQUEST_IQ1_type };
static KmParInt    _GEANT_RZ_PQUEST_IQ2_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_RZ_PQUEST_IQ2 = { "IQ2", 3,
 "Upper limit for IQ index", "20", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_RZ_PQUEST_IQ2_type };
static KmParameter *_GEANT_RZ_PQUEST_parameters[] = { &_GEANT_RZ_PQUEST_IQ1,
 &_GEANT_RZ_PQUEST_IQ2 };
static char *_GEANT_RZ_PQUEST_guidance[] = {
 "Print the array IQUEST in /QUEST/." };
static KmCommand _GEANT_RZ_PQUEST = { &_GEANT_RZ_FILE, "/GEANT/RZ/PQUEST",
 "PQUEST", 0, 2, 2, 0, _GEANT_RZ_PQUEST_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 1, _GEANT_RZ_PQUEST_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_RZ_guidance[] = { "ZEBRA/RZ commands." };
static KmMenu _GEANT_RZ = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/RZ", "RZ", 2,
 &_GEANT_RZ_PQUEST, 1, _GEANT_RZ_guidance, 0, (char**)0, 0, (char**)0 };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_RZ, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 0, (char**)0, 0, (char**)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 950303 );
}
 
 
#ifdef F77_LCASE
#  define gkscan_ gkscan
#  define gxscan_ gxscan
#endif
 
#ifdef F77_UCASE
#  define gkscan_ GKSCAN
#  define gxscan_ GXSCAN
#endif
 
#ifdef IBM370
#  pragma linkage(GKSCAN,FORTRAN)
#  pragma linkage(GXSCAN,FORTRAN)
#endif
 
extern void gkscan_();
extern void gxscan_();
 
void gkscan_()
{
 
static KmParInt    _GEANT_SCAN_HSCAN_IDPHI_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_HSCAN_IDPHI = { "IDPHI", 5,
 "Histogram/phi identifier", "1000", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_SCAN_HSCAN_IDPHI_type };
static KmParameter _GEANT_SCAN_HSCAN_VOLUME = { "VOLUME", 6, "Volume name",
 "XXXX", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static char *_GEANT_SCAN_HSCAN_CHOPT_range[] = { " ", "O", "P", "I", "X", "L"
 };
static char *_GEANT_SCAN_HSCAN_CHOPT_text[] = { (char*)0, (char*)0, (char*)0,
 (char*)0, (char*)0, (char*)0 };
static KmParOption _GEANT_SCAN_HSCAN_CHOPT_type = {
 _GEANT_SCAN_HSCAN_CHOPT_text, (int*)0, (int*)0 };
static KmParameter _GEANT_SCAN_HSCAN_CHOPT = { "CHOPT", 5, "List of options",
 "OPX", (char*)0, 8, 6, _GEANT_SCAN_HSCAN_CHOPT_range, 6,
 _GEANT_SCAN_HSCAN_CHOPT_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_SCAN_HSCAN_CHOPT_type };
static KmParameter *_GEANT_SCAN_HSCAN_parameters[] = {
 &_GEANT_SCAN_HSCAN_IDPHI, &_GEANT_SCAN_HSCAN_VOLUME, &_GEANT_SCAN_HSCAN_CHOPT
 };
static char *_GEANT_SCAN_HSCAN_guidance[] = {
 "Generates and plots an histogram of physics quantities such as",
 "the total number of radiation lengths or interaction lengths",
 "as a function of the SCAN parameter TETA for a given value of PHI.",
 "  CHOPT='O' histogram is generated at Exit  of VOLUME.",
 "  CHOPT='I' histogram is generated at Entry of VOLUME.",
 "  CHOPT='X' radiation lengths", "  CHOPT='L' Interaction lengths",
 "  CHOPT='P' Plot the histogram", "If VOLUME='XXXX' Mother volume is used.",
 "The histogram identifier IDPHI is used to also identify which",
 "PHI division to plot: IPHI=MOD(IDPHI,1000).",
 "If IPHI=0, then all PHI divisions are generated (not plotted)",
 "with histogram identifiers IDPHI+PHI division number." };
static KmCommand _GEANT_SCAN_HSCAN = {  (KmCommand*)0, "/GEANT/SCAN/HSCAN",
 "HSCAN", 0, 2, 3, 1, _GEANT_SCAN_HSCAN_parameters, 0, 0, gxscan_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 13, _GEANT_SCAN_HSCAN_guidance,
 0, (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_SCAN_LSCAN_ID_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_SCAN_LSCAN_ID = { "ID", 2, "Lego plot identifier",
 "2000", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_SCAN_LSCAN_ID_type };
static KmParameter _GEANT_SCAN_LSCAN_VOLUME = { "VOLUME", 6, "Volume name",
 "XXXX", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static char *_GEANT_SCAN_LSCAN_CHOPT_range[] = { " ", "O", "P", "I", "X", "L"
 };
static char *_GEANT_SCAN_LSCAN_CHOPT_text[] = { (char*)0, (char*)0, (char*)0,
 (char*)0, (char*)0, (char*)0 };
static KmParOption _GEANT_SCAN_LSCAN_CHOPT_type = {
 _GEANT_SCAN_LSCAN_CHOPT_text, (int*)0, (int*)0 };
static KmParameter _GEANT_SCAN_LSCAN_CHOPT = { "CHOPT", 5, "List of options",
 "OPX", (char*)0, 8, 6, _GEANT_SCAN_LSCAN_CHOPT_range, 6,
 _GEANT_SCAN_LSCAN_CHOPT_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_SCAN_LSCAN_CHOPT_type };
static KmParameter *_GEANT_SCAN_LSCAN_parameters[] = { &_GEANT_SCAN_LSCAN_ID,
 &_GEANT_SCAN_LSCAN_VOLUME, &_GEANT_SCAN_LSCAN_CHOPT };
static char *_GEANT_SCAN_LSCAN_guidance[] = {
 "Generates and plot a table of physics quantities such as",
 "the total number of radiation lengths or interaction lengths",
 "in function of the SCAN parameters TETA,PHI.",
 "  CHOPT='O' table is generated at Exit  of VOLUME.",
 "  CHOPT='I' table is generated at Entry of VOLUME.",
 "  CHOPT='X' radiation lengths", "  CHOPT='L' Interaction lengths",
 "  CHOPT='P' Plot the table", "If VOLUME='XXXX' Mother volume is used." };
static KmCommand _GEANT_SCAN_LSCAN = { &_GEANT_SCAN_HSCAN,
 "/GEANT/SCAN/LSCAN", "LSCAN", 0, 2, 3, 1, _GEANT_SCAN_LSCAN_parameters, 0, 0,
 gxscan_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 9,
 _GEANT_SCAN_LSCAN_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_SCAN_PCUTS_IPARAM_type = { "0", "1", "0", "1", 0 };
static KmParameter _GEANT_SCAN_PCUTS_IPARAM = { "IPARAM", 6,
 "Parametrization Flag", (char*)0, (char*)0, 2, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_SCAN_PCUTS_IPARAM_type };
static KmParReal   _GEANT_SCAN_PCUTS_PCUTGA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_PCUTS_PCUTGA = { "PCUTGA", 6,
 "Parametrization Cut for gammas", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_PCUTS_PCUTGA_type };
static KmParReal   _GEANT_SCAN_PCUTS_PCUTEL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_PCUTS_PCUTEL = { "PCUTEL", 6,
 "Parametrization Cut for electrons", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_PCUTS_PCUTEL_type };
static KmParReal   _GEANT_SCAN_PCUTS_PCUTHA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_PCUTS_PCUTHA = { "PCUTHA", 6,
 "Parametrization Cut for charged hadrons", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_SCAN_PCUTS_PCUTHA_type };
static KmParReal   _GEANT_SCAN_PCUTS_PCUTNE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_PCUTS_PCUTNE = { "PCUTNE", 6,
 "Parametrization Cut for neutral hadrons", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_SCAN_PCUTS_PCUTNE_type };
static KmParReal   _GEANT_SCAN_PCUTS_PCUTMU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_PCUTS_PCUTMU = { "PCUTMU", 6,
 "Parametrization Cut for muons", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_PCUTS_PCUTMU_type };
static KmParameter *_GEANT_SCAN_PCUTS_parameters[] = {
 &_GEANT_SCAN_PCUTS_IPARAM, &_GEANT_SCAN_PCUTS_PCUTGA,
 &_GEANT_SCAN_PCUTS_PCUTEL, &_GEANT_SCAN_PCUTS_PCUTHA,
 &_GEANT_SCAN_PCUTS_PCUTNE, &_GEANT_SCAN_PCUTS_PCUTMU };
static char *_GEANT_SCAN_PCUTS_guidance[] = {
 "Control parametrization at tracking time.",
 "     IPARAM=0       No parametrization is performed",
 "     IPARAM=1       Parametrization is performed",
 "If parametrization is active and a particle falls below its",
 "parametrization cut, then the particle will be replaced by",
 "a parametrized shower which will be tracked in the SCAN", "geometry." };
static KmCommand _GEANT_SCAN_PCUTS = { &_GEANT_SCAN_LSCAN,
 "/GEANT/SCAN/PCUTS", "PCUTS", 0, 2, 6, 0, _GEANT_SCAN_PCUTS_parameters, 0, 0,
 gxscan_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 7,
 _GEANT_SCAN_PCUTS_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_SCAN_STURN_CHOPT_range[] = { "ON", "OFF", "INIT" };
static char *_GEANT_SCAN_STURN_CHOPT_text[] = { (char*)0, (char*)0, (char*)0 };
static KmParOption _GEANT_SCAN_STURN_CHOPT_type = {
 _GEANT_SCAN_STURN_CHOPT_text, (int*)0, (int*)0 };
static KmParameter _GEANT_SCAN_STURN_CHOPT = { "CHOPT", 5,
 "SCAN mode setting", (char*)0, (char*)0, 8, 3, _GEANT_SCAN_STURN_CHOPT_range,
 3, _GEANT_SCAN_STURN_CHOPT_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_SCAN_STURN_CHOPT_type };
static KmParameter *_GEANT_SCAN_STURN_parameters[] = {
 &_GEANT_SCAN_STURN_CHOPT };
static char *_GEANT_SCAN_STURN_guidance[] = {
 "Switch on/off SCAN mode. If SCAN mode is on, SCAN geantinos",
 "are generated and tracked to fill (or complete) the current",
 "scan data structure. If SCAN mode is off, normal kinematics",
 "generation and tracking will take place. If INIT is given,",
 "the current SCAN data structure (if any) will be dropped",
 "and SCAN mode will be turned on." };
static KmCommand _GEANT_SCAN_STURN = { &_GEANT_SCAN_PCUTS,
 "/GEANT/SCAN/STURN", "STURN", 0, 2, 1, 1, _GEANT_SCAN_STURN_parameters, 0, 0,
 gxscan_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 6,
 _GEANT_SCAN_STURN_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParReal   _GEANT_SCAN_SFACTORS_FACTX0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_SFACTORS_FACTX0 = { "FACTX0", 6,
 "Scale factor for SX0", "100.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_SFACTORS_FACTX0_type };
static KmParReal   _GEANT_SCAN_SFACTORS_FACTL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_SFACTORS_FACTL = { "FACTL", 5,
 "Scale factor for SL", "1000.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_SFACTORS_FACTL_type };
static KmParReal   _GEANT_SCAN_SFACTORS_FACTR_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_SFACTORS_FACTR = { "FACTR", 5,
 "Scale factor for R", "100.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_SFACTORS_FACTR_type };
static KmParameter *_GEANT_SCAN_SFACTORS_parameters[] = {
 &_GEANT_SCAN_SFACTORS_FACTX0, &_GEANT_SCAN_SFACTORS_FACTL,
 &_GEANT_SCAN_SFACTORS_FACTR };
static char *_GEANT_SCAN_SFACTORS_guidance[] = {
 "Set scale factors for SX0,SL and R. The given scale factors must be",
 "such that:", "  SX0*FACTX0 < 2**15-1 (32767)",
 "  SL*FACTL   < 2**10-1 (1023)", "  SR*FACTR   < 2**17-1 (131071)" };
static KmCommand _GEANT_SCAN_SFACTORS = { &_GEANT_SCAN_STURN,
 "/GEANT/SCAN/SFACTORS", "SFACTORS", 0, 2, 3, 3,
 _GEANT_SCAN_SFACTORS_parameters, 0, 0, gxscan_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 5, _GEANT_SCAN_SFACTORS_guidance, 0, (char**)0, 0, (char**)0,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_SCAN_VERTEX_VX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_VERTEX_VX = { "VX", 2, "Scan X-origin", "0.",
 (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_SCAN_VERTEX_VX_type };
static KmParReal   _GEANT_SCAN_VERTEX_VY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_VERTEX_VY = { "VY", 2, "Scan Y-origin", "0.",
 (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_SCAN_VERTEX_VY_type };
static KmParReal   _GEANT_SCAN_VERTEX_VZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_VERTEX_VZ = { "VZ", 2, "Scan Z-origin", "0.",
 (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_SCAN_VERTEX_VZ_type };
static KmParameter *_GEANT_SCAN_VERTEX_parameters[] = {
 &_GEANT_SCAN_VERTEX_VX, &_GEANT_SCAN_VERTEX_VY, &_GEANT_SCAN_VERTEX_VZ };
static char *_GEANT_SCAN_VERTEX_guidance[] = {
 "All Geantinos tracked will start from position VX,VY,VZ." };
static KmCommand _GEANT_SCAN_VERTEX = { &_GEANT_SCAN_SFACTORS,
 "/GEANT/SCAN/VERTEX", "VERTEX", 0, 2, 3, 3, _GEANT_SCAN_VERTEX_parameters, 0,
 0, gxscan_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_SCAN_VERTEX_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_SCAN_SLIST_LIST = { "LIST", 4,
 "List of master volumes", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_SCAN_SLIST_parameters[] = { &_GEANT_SCAN_SLIST_LIST
 };
static char *_GEANT_SCAN_SLIST_guidance[] = {
 "Only boundary crossings of volumes given in LIST will be seen",
 "in the SCAN geometry. If no parameters are given, the current",
 "SCAN volumes will be listed. If a full stop (.) is given, the list",
 "of scan volumes will be erased." };
static KmCommand _GEANT_SCAN_SLIST = { &_GEANT_SCAN_VERTEX,
 "/GEANT/SCAN/SLIST", "SLIST", 0, 2, 1, 1, _GEANT_SCAN_SLIST_parameters, 0, 0,
 gxscan_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_SCAN_SLIST_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_SCAN_TETA_NTETA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_TETA_NTETA = { "NTETA", 5,
 "Number of TETA divisions", "90", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_SCAN_TETA_NTETA_type };
static KmParReal   _GEANT_SCAN_TETA_TETMIN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_TETA_TETMIN = { "TETMIN", 6,
 "Minimum value of TETA", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_TETA_TETMIN_type };
static KmParReal   _GEANT_SCAN_TETA_TETMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_TETA_TETMAX = { "TETMAX", 6,
 "Maximum value of TETA", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_TETA_TETMAX_type };
static KmParInt    _GEANT_SCAN_TETA_DIVTYP_type = { "1", "3", "1", "3", 0 };
static KmParameter _GEANT_SCAN_TETA_DIVTYP = { "DIVTYP", 6,
 "Type of TETA division", (char*)0, (char*)0, 2, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_SCAN_TETA_DIVTYP_type };
static KmParameter *_GEANT_SCAN_TETA_parameters[] = { &_GEANT_SCAN_TETA_NTETA,
 &_GEANT_SCAN_TETA_TETMIN, &_GEANT_SCAN_TETA_TETMAX, &_GEANT_SCAN_TETA_DIVTYP
 };
static char *_GEANT_SCAN_TETA_guidance[] = {
 "To specify number of divisions along TETA.",
 "If DIVTYP=1 divisions in pseudo-rapidity ETA.",
 "If DIVTYP=2 divisions in degrees following the THETA angle.",
 "If DIVTYP=3 divisions in cos(TETA).",
 "If no parameter is given, the current values of the parameters",
 "are displayed." };
static KmCommand _GEANT_SCAN_TETA = { &_GEANT_SCAN_SLIST, "/GEANT/SCAN/TETA",
 "TETA", 0, 2, 4, 1, _GEANT_SCAN_TETA_parameters, 0, 0, gxscan_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 6, _GEANT_SCAN_TETA_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_SCAN_PHI_NPHI_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_SCAN_PHI_NPHI = { "NPHI", 4,
 "Number of PHI divisions", "90", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_SCAN_PHI_NPHI_type };
static KmParReal   _GEANT_SCAN_PHI_PHIMIN_type = { "0.", "360.", "0.", "360.",
 0 };
static KmParameter _GEANT_SCAN_PHI_PHIMIN = { "PHIMIN", 6,
 "Minimum PHI in degrees", "0.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_PHI_PHIMIN_type };
static KmParReal   _GEANT_SCAN_PHI_PHIMAX_type = { "0.", "360.", "0.", "360.",
 0 };
static KmParameter _GEANT_SCAN_PHI_PHIMAX = { "PHIMAX", 6,
 "Maximum PHI in degrees", "360.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_PHI_PHIMAX_type };
static KmParameter *_GEANT_SCAN_PHI_parameters[] = { &_GEANT_SCAN_PHI_NPHI,
 &_GEANT_SCAN_PHI_PHIMIN, &_GEANT_SCAN_PHI_PHIMAX };
static char *_GEANT_SCAN_PHI_guidance[] = {
 "To specify number of divisions along PHI. If no parameter is",
 "given, the current values of the parameters are displayed." };
static KmCommand _GEANT_SCAN_PHI = { &_GEANT_SCAN_TETA, "/GEANT/SCAN/PHI",
 "PHI", 0, 2, 3, 1, _GEANT_SCAN_PHI_parameters, 0, 0, gxscan_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_SCAN_PHI_guidance, 0, (char**)0, 0,
 (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_SCAN_guidance[] = {
 "To define parameters for the SCAN geometry. If the routine GUSTEP",
 "and GUKINE are properly instrumented (see examples in GEANX),",
 "when the TRI command is entered NTETA Geantinos will be",
 "tracked through the real detector starting at the vertex position",
 "defined by the command vertex. A simplified version of the geometry",
 "is automatically generated in (ETA,PHI) or (THETA,PHI) following",
 "the option given in the command TETA. The data structure LSCAN",
 "generated may be saved on an RZ file for subsequent processing.",
 "This data structure may be used for fast parametrization techniques." };
static KmMenu _GEANT_SCAN = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/SCAN", "SCAN",
 2, &_GEANT_SCAN_PHI, 9, _GEANT_SCAN_guidance, 0, (char**)0, 0, (char**)0 };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_SCAN, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 0, (char**)0, 0, (char**)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 950303 );
}
 
 
#ifdef F77_LCASE
#  define gkphys_ gkphys
#  define gxphys_ gxphys
#endif
 
#ifdef F77_UCASE
#  define gkphys_ GKPHYS
#  define gxphys_ GXPHYS
#endif
 
#ifdef IBM370
#  pragma linkage(GKPHYS,FORTRAN)
#  pragma linkage(GXPHYS,FORTRAN)
#endif
 
extern void gkphys_();
extern void gxphys_();
 
void gkphys_()
{
 
static char *_GEANT_PHYSICS_PHYSI_guidance[] = {
 "Call the GEANT initialisation routine GPHYSI to recompute",
 "the tables of cross-sections and energy loss. This command",
 "must be invoked after CUTS, LOSS or ERAN commands." };
static KmCommand _GEANT_PHYSICS_PHYSI = {  (KmCommand*)0,
 "/GEANT/PHYSICS/PHYSI", "PHYSI", 0, 2, 0, 0, (KmParameter**)0, 0, 0, gxphys_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_PHYSICS_PHYSI_guidance,
 0, (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_PHYSICS_DRPRT_IPART_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_DRPRT_IPART = { "IPART", 5,
 "GEANT particle number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_PHYSICS_DRPRT_IPART_type };
static KmParInt    _GEANT_PHYSICS_DRPRT_IMATE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_DRPRT_IMATE = { "IMATE", 5,
 "GEANT material number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_PHYSICS_DRPRT_IMATE_type };
static KmParReal   _GEANT_PHYSICS_DRPRT_STEP_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_DRPRT_STEP = { "STEP", 4,
 "step length in centimeters", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_DRPRT_STEP_type };
static KmParInt    _GEANT_PHYSICS_DRPRT_NPOINT_type = { "2", "100", "2",
 "100", 0 };
static KmParameter _GEANT_PHYSICS_DRPRT_NPOINT = { "NPOINT", 6,
 "number of logarithmically spaced energy points", "10", (char*)0, 4, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_DRPRT_NPOINT_type };
static KmParameter *_GEANT_PHYSICS_DRPRT_parameters[] = {
 &_GEANT_PHYSICS_DRPRT_IPART, &_GEANT_PHYSICS_DRPRT_IMATE,
 &_GEANT_PHYSICS_DRPRT_STEP, &_GEANT_PHYSICS_DRPRT_NPOINT };
static char *_GEANT_PHYSICS_DRPRT_guidance[] = {
 "This routine prints the relevant parameters linked with the energy loss",
 "fluctuation." };
static KmCommand _GEANT_PHYSICS_DRPRT = { &_GEANT_PHYSICS_PHYSI,
 "/GEANT/PHYSICS/DRPRT", "DRPRT", 0, 2, 4, 3, _GEANT_PHYSICS_DRPRT_parameters,
 0, 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_PHYSICS_DRPRT_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParReal   _GEANT_PHYSICS_CUTS_CUTGAM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_CUTGAM = { "CUTGAM", 6,
 "Cut for gammas", "0.001", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_CUTGAM_type };
static KmParReal   _GEANT_PHYSICS_CUTS_CUTELE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_CUTELE = { "CUTELE", 6,
 "Cut for electrons", "0.001", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_CUTELE_type };
static KmParReal   _GEANT_PHYSICS_CUTS_CUTHAD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_CUTHAD = { "CUTHAD", 6,
 "Cut for charged hadrons", "0.01", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_CUTHAD_type };
static KmParReal   _GEANT_PHYSICS_CUTS_CUTNEU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_CUTNEU = { "CUTNEU", 6,
 "Cut for neutral hadrons", "0.01", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_CUTNEU_type };
static KmParReal   _GEANT_PHYSICS_CUTS_CUTMUO_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_CUTMUO = { "CUTMUO", 6,
 "Cut for muons", "0.01", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_CUTMUO_type };
static KmParReal   _GEANT_PHYSICS_CUTS_BCUTE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_BCUTE = { "BCUTE", 5,
 "Cut for electron brems.", "-1.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_BCUTE_type };
static KmParReal   _GEANT_PHYSICS_CUTS_BCUTM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_BCUTM = { "BCUTM", 5,
 "Cut for muon brems.", "-1.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_BCUTM_type };
static KmParReal   _GEANT_PHYSICS_CUTS_DCUTE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_DCUTE = { "DCUTE", 5,
 "Cut for electron delta-rays", "-1.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_DCUTE_type };
static KmParReal   _GEANT_PHYSICS_CUTS_DCUTM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_DCUTM = { "DCUTM", 5,
 "Cut for muon delta-rays", "-1.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_DCUTM_type };
static KmParReal   _GEANT_PHYSICS_CUTS_PPCUTM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_PPCUTM = { "PPCUTM", 6,
 "Cut for e+e- pairs by muons", "0.01", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_PPCUTM_type };
static KmParReal   _GEANT_PHYSICS_CUTS_TOFMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_TOFMAX = { "TOFMAX", 6,
 "Time of flight cut", "1.E+10", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_TOFMAX_type };
static KmParReal   _GEANT_PHYSICS_CUTS_GCUTS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_GCUTS = { "GCUTS", 5, "5 user words",
 "0.", (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_PHYSICS_CUTS_GCUTS_type };
static KmParameter *_GEANT_PHYSICS_CUTS_parameters[] = {
 &_GEANT_PHYSICS_CUTS_CUTGAM, &_GEANT_PHYSICS_CUTS_CUTELE,
 &_GEANT_PHYSICS_CUTS_CUTHAD, &_GEANT_PHYSICS_CUTS_CUTNEU,
 &_GEANT_PHYSICS_CUTS_CUTMUO, &_GEANT_PHYSICS_CUTS_BCUTE,
 &_GEANT_PHYSICS_CUTS_BCUTM, &_GEANT_PHYSICS_CUTS_DCUTE,
 &_GEANT_PHYSICS_CUTS_DCUTM, &_GEANT_PHYSICS_CUTS_PPCUTM,
 &_GEANT_PHYSICS_CUTS_TOFMAX, &_GEANT_PHYSICS_CUTS_GCUTS };
static char *_GEANT_PHYSICS_CUTS_guidance[] = {
 "To change physics cuts. If no parameter is given, the list",
 "of the current cuts is printed.",
 " If the default values (-1.) for       BCUTE ,BCUTM ,DCUTE ,DCUTM",
 " are not modified, they will be set to CUTGAM,CUTGAM,CUTELE,CUTELE",
 " respectively.", "If one of the parameters from CUTGAM to PPCUTM included",
 "is modified, cross-sections and energy loss tables must be",
 "recomputed via the command 'PHYSI'." };
static KmCommand _GEANT_PHYSICS_CUTS = { &_GEANT_PHYSICS_DRPRT,
 "/GEANT/PHYSICS/CUTS", "CUTS", 0, 2, 12, 0, _GEANT_PHYSICS_CUTS_parameters,
 0, 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 8,
 _GEANT_PHYSICS_CUTS_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_SYNC_ISYNC_range[] = { "0", "1" };
static KmParInt    _GEANT_PHYSICS_SYNC_ISYNC_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_SYNC_ISYNC = { "ISYNC", 5, "Flag ISYNC",
 "1", (char*)0, 8, 2, _GEANT_PHYSICS_SYNC_ISYNC_range, 2,
 _GEANT_PHYSICS_SYNC_ISYNC_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_SYNC_ISYNC_type };
static KmParameter *_GEANT_PHYSICS_SYNC_parameters[] = {
 &_GEANT_PHYSICS_SYNC_ISYNC };
static char *_GEANT_PHYSICS_SYNC_guidance[] = {
 "To control synchrotron radiation:", " ISYNC=0 no synchrotron radiation;",
 "      =1 synchrotron radiation." };
static KmCommand _GEANT_PHYSICS_SYNC = { &_GEANT_PHYSICS_CUTS,
 "/GEANT/PHYSICS/SYNC", "SYNC", 0, 2, 1, 0, _GEANT_PHYSICS_SYNC_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_PHYSICS_SYNC_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_STRA_ISTRA_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_STRA_ISTRA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_STRA_ISTRA = { "ISTRA", 5, "Flag ISTRA",
 "0", (char*)0, 8, 3, _GEANT_PHYSICS_STRA_ISTRA_range, 3,
 _GEANT_PHYSICS_STRA_ISTRA_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_STRA_ISTRA_type };
static KmParameter *_GEANT_PHYSICS_STRA_parameters[] = {
 &_GEANT_PHYSICS_STRA_ISTRA };
static char *_GEANT_PHYSICS_STRA_guidance[] = {
 "To control energy loss fluctuation model:", " ISTRA=0 Urban model;",
 "      =1 PAI model;", "      =2 PAI+ASHO model (not active at the moment)."
 };
static KmCommand _GEANT_PHYSICS_STRA = { &_GEANT_PHYSICS_SYNC,
 "/GEANT/PHYSICS/STRA", "STRA", 0, 2, 1, 0, _GEANT_PHYSICS_STRA_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_STRA_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_RAYL_IRAYL_range[] = { "0", "1" };
static KmParInt    _GEANT_PHYSICS_RAYL_IRAYL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_RAYL_IRAYL = { "IRAYL", 5, "Flag IRAYL",
 "1", (char*)0, 8, 2, _GEANT_PHYSICS_RAYL_IRAYL_range, 2,
 _GEANT_PHYSICS_RAYL_IRAYL_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_RAYL_IRAYL_type };
static KmParameter *_GEANT_PHYSICS_RAYL_parameters[] = {
 &_GEANT_PHYSICS_RAYL_IRAYL };
static char *_GEANT_PHYSICS_RAYL_guidance[] = {
 "To control Rayleigh scattering.", " IRAYL=0 no Rayleigh scattering.",
 "      =1 Rayleigh." };
static KmCommand _GEANT_PHYSICS_RAYL = { &_GEANT_PHYSICS_STRA,
 "/GEANT/PHYSICS/RAYL", "RAYL", 0, 2, 1, 0, _GEANT_PHYSICS_RAYL_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_PHYSICS_RAYL_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_PHOT_IPHOT_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_PHOT_IPHOT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_PHOT_IPHOT = { "IPHOT", 5, "Flag IPHOT",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_PHOT_IPHOT_range, 3,
 _GEANT_PHYSICS_PHOT_IPHOT_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_PHOT_IPHOT_type };
static KmParameter *_GEANT_PHYSICS_PHOT_parameters[] = {
 &_GEANT_PHYSICS_PHOT_IPHOT };
static char *_GEANT_PHYSICS_PHOT_guidance[] = { "To control Photo effect.",
 " IPHOT=0 no photo electric effect.",
 "      =1 Photo effect. Electron processed.",
 "      =2 Photo effect. No electron stored." };
static KmCommand _GEANT_PHYSICS_PHOT = { &_GEANT_PHYSICS_RAYL,
 "/GEANT/PHYSICS/PHOT", "PHOT", 0, 2, 1, 0, _GEANT_PHYSICS_PHOT_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_PHOT_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_PFIS_IPFIS_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_PFIS_IPFIS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_PFIS_IPFIS = { "IPFIS", 5, "Flag IPFIS",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_PFIS_IPFIS_range, 3,
 _GEANT_PHYSICS_PFIS_IPFIS_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_PFIS_IPFIS_type };
static KmParameter *_GEANT_PHYSICS_PFIS_parameters[] = {
 &_GEANT_PHYSICS_PFIS_IPFIS };
static char *_GEANT_PHYSICS_PFIS_guidance[] = {
 "To control photo fission mechanism.", " IPFIS=0 no photo fission.",
 "      =1 Photo fission. secondaries processed.",
 "      =2 Photo fission. No secondaries stored." };
static KmCommand _GEANT_PHYSICS_PFIS = { &_GEANT_PHYSICS_PHOT,
 "/GEANT/PHYSICS/PFIS", "PFIS", 0, 2, 1, 0, _GEANT_PHYSICS_PFIS_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_PFIS_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_PAIR_IPAIR_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_PAIR_IPAIR_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_PAIR_IPAIR = { "IPAIR", 5, "Flag IPAIR",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_PAIR_IPAIR_range, 3,
 _GEANT_PHYSICS_PAIR_IPAIR_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_PAIR_IPAIR_type };
static KmParameter *_GEANT_PHYSICS_PAIR_parameters[] = {
 &_GEANT_PHYSICS_PAIR_IPAIR };
static char *_GEANT_PHYSICS_PAIR_guidance[] = {
 "To control pair production mechanism.", " IPAIR=0 no pair production.",
 "      =1 Pair production. secondaries processed.",
 "      =2 Pair production. No secondaries stored." };
static KmCommand _GEANT_PHYSICS_PAIR = { &_GEANT_PHYSICS_PFIS,
 "/GEANT/PHYSICS/PAIR", "PAIR", 0, 2, 1, 0, _GEANT_PHYSICS_PAIR_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_PAIR_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_MUNU_IMUNU_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_MUNU_IMUNU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_MUNU_IMUNU = { "IMUNU", 5, "Flag IMUNU",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_MUNU_IMUNU_range, 3,
 _GEANT_PHYSICS_MUNU_IMUNU_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_MUNU_IMUNU_type };
static KmParameter *_GEANT_PHYSICS_MUNU_parameters[] = {
 &_GEANT_PHYSICS_MUNU_IMUNU };
static char *_GEANT_PHYSICS_MUNU_guidance[] = {
 "To control muon nuclear interactions.",
 " IMUNU=0 no muon-nuclear interactions.",
 "      =1 Nuclear interactions. Secondaries processed.",
 "      =2 Nuclear interactions. Secondaries not processed." };
static KmCommand _GEANT_PHYSICS_MUNU = { &_GEANT_PHYSICS_PAIR,
 "/GEANT/PHYSICS/MUNU", "MUNU", 0, 2, 1, 0, _GEANT_PHYSICS_MUNU_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_MUNU_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_MULS_IMULS_range[] = { "0", "1", "2", "3" };
static KmParInt    _GEANT_PHYSICS_MULS_IMULS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_MULS_IMULS = { "IMULS", 5, "Flag IMULS",
 "1", (char*)0, 8, 4, _GEANT_PHYSICS_MULS_IMULS_range, 4,
 _GEANT_PHYSICS_MULS_IMULS_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_MULS_IMULS_type };
static KmParameter *_GEANT_PHYSICS_MULS_parameters[] = {
 &_GEANT_PHYSICS_MULS_IMULS };
static char *_GEANT_PHYSICS_MULS_guidance[] = {
 "To control multiple scattering.", " IMULS=0 no multiple scattering.",
 "      =1 Moliere or Coulomb scattering.",
 "      =2 Moliere or Coulomb scattering.", "      =3 Gaussian scattering." };
static KmCommand _GEANT_PHYSICS_MULS = { &_GEANT_PHYSICS_MUNU,
 "/GEANT/PHYSICS/MULS", "MULS", 0, 2, 1, 0, _GEANT_PHYSICS_MULS_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 5,
 _GEANT_PHYSICS_MULS_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_LOSS_ILOSS_range[] = { "0", "1", "2", "3", "4" };
static KmParInt    _GEANT_PHYSICS_LOSS_ILOSS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_LOSS_ILOSS = { "ILOSS", 5, "Flag ILOSS",
 "2", (char*)0, 8, 5, _GEANT_PHYSICS_LOSS_ILOSS_range, 5,
 _GEANT_PHYSICS_LOSS_ILOSS_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_LOSS_ILOSS_type };
static KmParameter *_GEANT_PHYSICS_LOSS_parameters[] = {
 &_GEANT_PHYSICS_LOSS_ILOSS };
static char *_GEANT_PHYSICS_LOSS_guidance[] = { "To control energy loss.",
 " ILOSS=0 no energy loss;", "      =1 restricted energy loss fluctuations;",
 "      =2 complete energy loss fluctuations;", "      =3 same as 1;",
 "      =4 no energy loss fluctuations.",
 "If the value ILOSS is changed, then cross-sections and energy loss",
 "tables must be recomputed via the command 'PHYSI'." };
static KmCommand _GEANT_PHYSICS_LOSS = { &_GEANT_PHYSICS_MULS,
 "/GEANT/PHYSICS/LOSS", "LOSS", 0, 2, 1, 0, _GEANT_PHYSICS_LOSS_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 8,
 _GEANT_PHYSICS_LOSS_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_PHYSICS_LABS_LABS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_LABS_LABS = { "LABS", 4, "Flag LABS", "0",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_LABS_LABS_type };
static KmParameter *_GEANT_PHYSICS_LABS_parameters[] = {
 &_GEANT_PHYSICS_LABS_LABS };
static char *_GEANT_PHYSICS_LABS_guidance[] = {
 "To control absorbtion of Cerenkov photons:",
 "    LABS=0 no absorbtion of photons;", "    LABS=1 absorbtion of photons;" };
static KmCommand _GEANT_PHYSICS_LABS = { &_GEANT_PHYSICS_LOSS,
 "/GEANT/PHYSICS/LABS", "LABS", 0, 2, 1, 0, _GEANT_PHYSICS_LABS_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_PHYSICS_LABS_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_PHYSICS_HADR_IHADR_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_HADR_IHADR = { "IHADR", 5, "Flag IHADR",
 "1", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_HADR_IHADR_type };
static KmParameter *_GEANT_PHYSICS_HADR_parameters[] = {
 &_GEANT_PHYSICS_HADR_IHADR };
static char *_GEANT_PHYSICS_HADR_guidance[] = {
 "To control hadronic interactions.", " IHADR=0 no hadronic interactions.",
 "      =1 Hadronic interactions. secondaries processed.",
 "      =2 Hadronic interactions. No secondaries stored." };
static KmCommand _GEANT_PHYSICS_HADR = { &_GEANT_PHYSICS_LABS,
 "/GEANT/PHYSICS/HADR", "HADR", 0, 2, 1, 0, _GEANT_PHYSICS_HADR_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_HADR_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParReal   _GEANT_PHYSICS_ERAN_EKMIN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_ERAN_EKMIN = { "EKMIN", 5,
 "Minimum energy of the tables", "1E-5", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_ERAN_EKMIN_type };
static KmParReal   _GEANT_PHYSICS_ERAN_EKMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_ERAN_EKMAX = { "EKMAX", 5,
 "Maximum energy of the tables", "1E+4", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_ERAN_EKMAX_type };
static KmParInt    _GEANT_PHYSICS_ERAN_NEKBIN_type = { "1", "200", "1", "200",
 0 };
static KmParameter _GEANT_PHYSICS_ERAN_NEKBIN = { "NEKBIN", 6,
 "Number of bins in the tables", "90", (char*)0, 4, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_PHYSICS_ERAN_NEKBIN_type };
static KmParameter *_GEANT_PHYSICS_ERAN_parameters[] = {
 &_GEANT_PHYSICS_ERAN_EKMIN, &_GEANT_PHYSICS_ERAN_EKMAX,
 &_GEANT_PHYSICS_ERAN_NEKBIN };
static char *_GEANT_PHYSICS_ERAN_guidance[] = {
 "To define the range and binning of internal tables." };
static KmCommand _GEANT_PHYSICS_ERAN = { &_GEANT_PHYSICS_HADR,
 "/GEANT/PHYSICS/ERAN", "ERAN", 0, 2, 3, 0, _GEANT_PHYSICS_ERAN_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_PHYSICS_ERAN_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_DRAY_IDRAY_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_DRAY_IDRAY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_DRAY_IDRAY = { "IDRAY", 5, "Flag IDRAY",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_DRAY_IDRAY_range, 3,
 _GEANT_PHYSICS_DRAY_IDRAY_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_DRAY_IDRAY_type };
static KmParameter *_GEANT_PHYSICS_DRAY_parameters[] = {
 &_GEANT_PHYSICS_DRAY_IDRAY };
static char *_GEANT_PHYSICS_DRAY_guidance[] = {
 "To control delta rays mechanism.", " IDRAY=0 no delta rays.",
 "      =1 Delta rays. secondaries processed.",
 "      =2 Delta rays. No secondaries stored." };
static KmCommand _GEANT_PHYSICS_DRAY = { &_GEANT_PHYSICS_ERAN,
 "/GEANT/PHYSICS/DRAY", "DRAY", 0, 2, 1, 0, _GEANT_PHYSICS_DRAY_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_DRAY_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_DCAY_IDCAY_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_DCAY_IDCAY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_DCAY_IDCAY = { "IDCAY", 5, "Flag IDCAY",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_DCAY_IDCAY_range, 3,
 _GEANT_PHYSICS_DCAY_IDCAY_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_DCAY_IDCAY_type };
static KmParameter *_GEANT_PHYSICS_DCAY_parameters[] = {
 &_GEANT_PHYSICS_DCAY_IDCAY };
static char *_GEANT_PHYSICS_DCAY_guidance[] = { "To control Decay mechanism.",
 " IDCAY=0 no decays.", "      =1 Decays. secondaries processed.",
 "      =2 Decays. No secondaries stored." };
static KmCommand _GEANT_PHYSICS_DCAY = { &_GEANT_PHYSICS_DRAY,
 "/GEANT/PHYSICS/DCAY", "DCAY", 0, 2, 1, 0, _GEANT_PHYSICS_DCAY_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_DCAY_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_COMP_ICOMP_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_COMP_ICOMP_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_COMP_ICOMP = { "ICOMP", 5, "Flag ICOMP",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_COMP_ICOMP_range, 3,
 _GEANT_PHYSICS_COMP_ICOMP_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_COMP_ICOMP_type };
static KmParameter *_GEANT_PHYSICS_COMP_parameters[] = {
 &_GEANT_PHYSICS_COMP_ICOMP };
static char *_GEANT_PHYSICS_COMP_guidance[] = {
 "To control Compton scattering", " ICOMP=0 no Compton",
 "      =1 Compton. Electron processed.",
 "      =2 Compton. No electron stored." };
static KmCommand _GEANT_PHYSICS_COMP = { &_GEANT_PHYSICS_DCAY,
 "/GEANT/PHYSICS/COMP", "COMP", 0, 2, 1, 0, _GEANT_PHYSICS_COMP_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_COMP_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_CKOV_ICKOV_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_CKOV_ICKOV_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CKOV_ICKOV = { "ICKOV", 5, "Flag ICKOV",
 "0", (char*)0, 8, 3, _GEANT_PHYSICS_CKOV_ICKOV_range, 3,
 _GEANT_PHYSICS_CKOV_ICKOV_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_CKOV_ICKOV_type };
static KmParameter *_GEANT_PHYSICS_CKOV_parameters[] = {
 &_GEANT_PHYSICS_CKOV_ICKOV };
static char *_GEANT_PHYSICS_CKOV_guidance[] = {
 "To control Cerenkov production", " ICOMP=0 no Cerenkov;",
 "      =1 Cerenkov;", "      =2 Cerenkov with primary stopped at each step."
 };
static KmCommand _GEANT_PHYSICS_CKOV = { &_GEANT_PHYSICS_COMP,
 "/GEANT/PHYSICS/CKOV", "CKOV", 0, 2, 1, 0, _GEANT_PHYSICS_CKOV_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_CKOV_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_BREM_IBREM_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_BREM_IBREM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_BREM_IBREM = { "IBREM", 5, "Flag IBREM",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_BREM_IBREM_range, 3,
 _GEANT_PHYSICS_BREM_IBREM_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_BREM_IBREM_type };
static KmParameter *_GEANT_PHYSICS_BREM_parameters[] = {
 &_GEANT_PHYSICS_BREM_IBREM };
static char *_GEANT_PHYSICS_BREM_guidance[] = { "To control bremstrahlung.",
 " IBREM=0 no bremstrahlung", "      =1 bremstrahlung. Photon processed.",
 "      =2 bremstrahlung. No photon stored." };
static KmCommand _GEANT_PHYSICS_BREM = { &_GEANT_PHYSICS_CKOV,
 "/GEANT/PHYSICS/BREM", "BREM", 0, 2, 1, 0, _GEANT_PHYSICS_BREM_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_BREM_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_AUTO_IAUTO_range[] = { "0", "1" };
static KmParInt    _GEANT_PHYSICS_AUTO_IAUTO_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_AUTO_IAUTO = { "IAUTO", 5, "Flag IAUTO",
 "1", (char*)0, 8, 2, _GEANT_PHYSICS_AUTO_IAUTO_range, 2,
 _GEANT_PHYSICS_AUTO_IAUTO_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_AUTO_IAUTO_type };
static KmParameter *_GEANT_PHYSICS_AUTO_parameters[] = {
 &_GEANT_PHYSICS_AUTO_IAUTO };
static char *_GEANT_PHYSICS_AUTO_guidance[] = {
 "To control automatic calculation of tracking medium parameters:",
 " IAUTO=0 no automatic calculation;", "      =1 automati calculation." };
static KmCommand _GEANT_PHYSICS_AUTO = { &_GEANT_PHYSICS_BREM,
 "/GEANT/PHYSICS/AUTO", "AUTO", 0, 2, 1, 0, _GEANT_PHYSICS_AUTO_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_PHYSICS_AUTO_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_ANNI_IANNI_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_ANNI_IANNI_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_ANNI_IANNI = { "IANNI", 5, "Flag IANNI",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_ANNI_IANNI_range, 3,
 _GEANT_PHYSICS_ANNI_IANNI_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_ANNI_IANNI_type };
static KmParameter *_GEANT_PHYSICS_ANNI_parameters[] = {
 &_GEANT_PHYSICS_ANNI_IANNI };
static char *_GEANT_PHYSICS_ANNI_guidance[] = {
 "To control positron annihilation.", " IANNI=0 no annihilation",
 "      =1 annihilation. Decays processed.",
 "      =2 annihilation. No decay products stored." };
static KmCommand _GEANT_PHYSICS_ANNI = { &_GEANT_PHYSICS_AUTO,
 "/GEANT/PHYSICS/ANNI", "ANNI", 0, 2, 1, 0, _GEANT_PHYSICS_ANNI_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_ANNI_guidance, 0, (char**)0, 0, (char**)0, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_guidance[] = {
 "Commands to set physics parameters." };
static KmMenu _GEANT_PHYSICS = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/PHYSICS",
 "PHYSICS", 2, &_GEANT_PHYSICS_ANNI, 1, _GEANT_PHYSICS_guidance, 0, (char**)0,
 0, (char**)0 };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_PHYSICS, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 0, (char**)0, 0, (char**)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 950303 );
}
 
 
#ifdef F77_LCASE
#  define gkfort_ gkfort
#  define gxfort_ gxfort
#endif
 
#ifdef F77_UCASE
#  define gkfort_ GKFORT
#  define gxfort_ GXFORT
#endif
 
#ifdef IBM370
#  pragma linkage(GKFORT,FORTRAN)
#  pragma linkage(GXFORT,FORTRAN)
#endif
 
extern void gkfort_();
extern void gxfort_();
 
void gkfort_()
{
 
static KmParameter _FORTRAN_FORTRAN_FNAME = { "FNAME", 5, "File name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_FORTRAN_FORTRAN_parameters[] = { &_FORTRAN_FORTRAN_FNAME
 };
static char *_FORTRAN_FORTRAN_guidance[] = {
 "The routines in the file FNAME will be compiled by COMIS.",
 "If routines with names: UGEOM,GUKINE,GUOUT,UGLAST are found,",
 "then they will be automatically called by GXINT instead of",
 "the routines with the same names compiled with the standard",
 "Fortran compiler and linked with the application.",
 "The user callable routines from the GEANT library as well as",
 "routines from PACKLIB (HBOOK,HPLOT,HIGZ,ZEBRA) may be called",
 "from these user routines. All GEANT common blocks may be", "referenced.",
 "In case where the routine UGEOM is called several times,",
 "it is important to DROP all the initialisation data structures",
 "JVOLUM,JMATE,JTMED,etc already in memory by using the routine GIDROP.",
 " Example of an interactive session where the routine UGEOM is modified:",
 "", "   GEANT > Edit ugeom.for", "   GEANT > Fortran ugeom.for",
 "   GEANT > Call GIDROP", "   GEANT > Call UGEOM", "   GEANT > Dtree",
 "   GEANT > Edit ugeom.for", "   GEANT > Fortran ugeom.for",
 "   GEANT > Call GIDROP", "   GEANT > Call UGEOM", "   GEANT > Dtree",
 "If FNAME='-', calls to user routines is reset and standard",
 "routines called instead." };
static KmCommand _FORTRAN_FORTRAN = {  (KmCommand*)0, "/FORTRAN/FORTRAN",
 "FORTRAN", 0, 1, 1, 1, _FORTRAN_FORTRAN_parameters, 0, 0, gxfort_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 26, _FORTRAN_FORTRAN_guidance, 0,
 (char**)0, 0, (char**)0, 0, (char**)0, (char*)0, (int*)0 };
 
static KmMenu _FORTRAN = {  (KmMenu*)0,  (KmMenu*)0, "/FORTRAN", "FORTRAN", 1,
 &_FORTRAN_FORTRAN, 0, (char**)0, 0, (char**)0, 0, (char**)0 };
 
  klnkmenu( &_FORTRAN, 950303 );
}
 
#endif
#if defined(CERNLIB_KUIP95A)
 
/*CMZ :          21/03/95  18.51.56  by  S.Giani*/
/*-- Author :*/
/*
 * This file has been generated by the KUIP compiler.  Do NOT change it!
 *
 * KUIP header: 921023      Generation date: Tue Mar 21 18:51:54 1995
 *
 * Input file: g321x.doc
 */
 
#if !defined(F77_LCASE) && !defined(F77_UCASE) && !defined(F77_USCORE)
#  if defined(__EXTENDED__) && !defined(IBM370) && !defined(_IBMR2)
#    define IBM370
#  endif
#  if defined(CRAY) || defined(IBM370) || defined(vms)
#    define F77_UCASE
#  else
#    if ( defined(apollo) || defined(__apollo) ) && defined(APOFTN)
#      define F77_LCASE
#    else
#      define F77_USCORE
#    endif
#  endif
#endif
 
typedef int     IntFunc();
typedef char*   CharFunc();
typedef char** pCharFunc();
typedef void    SUBROUTINE();
#ifdef IBM370
#  pragma linkage(SUBROUTINE,FORTRAN)
#endif
 
extern void klnkmenu();
extern void klnkbrcl();
extern void klnkkmcl();
extern void klnkicon();
extern void klnkbutt();
 
typedef unsigned long KmPixmap; /* Pixmap from <X11/X.h>                   */
 typedef void *KmWidget;         /* Widget from <X11/Intrinsic.h>           */
 typedef void *KmCalldata;       /* XmAnyCallbackStruct from <Motif/Xm.h>   */
                                 /*                                         */
 typedef enum {                  /*                                         */
   BRACT_OPEN = 0,               /*                                         */
   BRACT_ROOT = 1,               /*                                         */
   BRACT_CONT = 2,               /*                                         */
   BRACT_GRAF = 3                /*                                         */
 } BrActTag;                     /*                                         */
                                 /*                                         */
 typedef enum {                  /*                                         */
   BrActUpdate    = 0x01,        /* browser window has to be updated ('!')  */
   BrActSeparator = 0x02,        /* put separator in menu ('/')             */
   BrActToggle    = 0x04,        /* register as toggle button               */
   BrActToggleOn  = 0x08,        /* toggle state is on                      */
   BrActSensitive = 0x10         /* button is sensitive                     */
 } BrActFlag;                    /*                                         */
                                 /*                                         */
 
typedef struct _BrAction {      /*                                         */
  struct _BrAction *next;       /* link to next action binding             */
  BrActFlag   flags;            /*                                         */
  char       *text;             /* text line in menu                       */
  char       *user_text;        /* user text overriding CDF text (malloced)*/
  char       *accel;            /* accelerator                             */
  char       *exec;             /* action commands                         */
  SUBROUTINE *call_F;           /* action routine                          */
  IntFunc    *call_C;           /* action function                         */
  BrActTag    tag;              /* for which window the action is defined  */
  struct _BrClass *class;       /* pointer to BrClass in case of open menu */
 } BrAction;                     /*                                         */
                                 /*                                         */
 typedef struct _BrClass {       /*                                         */
   struct _BrClass *next;        /* link to next browsable class            */
   char       *name;             /* unique identifier name                  */
   char       *title;            /* title for popup menu (maybe NULL)       */
   SUBROUTINE *scan_km_F;        /* user function scanning the directory    */
   pCharFunc  *scan_km_C;        /* user function scanning the directory    */
   SUBROUTINE *scan_br_F;        /* user function scanning for browsables   */
   pCharFunc  *scan_br_C;        /* user function scanning for browsables   */
   BrAction   *root;             /* list of actions in root window          */
   BrAction   *open;             /* list of actions in open menu            */
 } BrClass;                      /*                                         */
                                 /*                                         */
 
typedef struct _KmIcon {        /*                                         */
  struct _KmIcon *next;         /* link to next icon                       */
  char       *name;             /* unique identifier name                  */
  int         width;            /* width of the pixmap                     */
  int         height;           /* height of the pixmap                    */
  char       *bitmap;           /* bitmap data                             */
  KmPixmap    pix;              /* filled in Motif part                    */
  KmPixmap    hi_pix;           /* high lighted pixmap                     */
 } KmIcon;                       /*                                         */
                                 /*                                         */
 typedef struct _KmClass {       /*                                         */
   struct _KmClass *next;        /* link to next object class               */
   int         is_dir;           /* flag if class has is a directory        */
   char       *name;             /* unique identifier name                  */
   char       *title;            /* title for popup menu (maybe NULL)       */
   char       *big_icon;         /* name of the big icon                    */
   KmIcon     *bicon;            /* pointer to the big icon structure       */
   char       *sm_icon;          /* name of the small icon                  */
   KmIcon     *sicon;            /* pointer to the small icon structure     */
   SUBROUTINE *user_icon_F;      /* user function to return icon bitmap     */
   IntFunc    *user_icon_C;      /* user function to return icon bitmap     */
   BrAction   *cont;             /* list of actions in content window       */
   BrAction   *graf;             /* list of actions in graphics window      */
   int         obj_count;        /* number of objects in content window     */
 } KmClass;                      /*                                         */
                                 /*                                         */
 
typedef enum {                  /*                                         */
  KmButtSensitive       = 0x00, /* sensitive button                        */
  KmButtNonSensitive    = 0x01, /* non-sensitive button ('NS')             */
  KmButtToggleSensitive = 0x02, /* toggle-sensitive button ('TS')          */
  KmButtSensitivityMask = 0x03, /* mask for sensitivity type               */
  KmButtSeparator       = 0x04, /* put separator in menu ('/')             */
  KmButtBrowser         = 0x08  /* button is in main browser ('BR')        */
 } KmButtFlag;                   /*                                         */
                                 /*                                         */
 typedef struct _KmButton {      /*                                         */
   struct _KmButton *next;       /* button label or menu item               */
   char       *menu;             /* menu name or NULL for buttons           */
   char       *label;            /* button label or menu item               */
   SUBROUTINE *call_F;           /* callback routine (FORTRAN)              */
   IntFunc    *call_C;           /* callback routine (C)                    */
   char       *action;           /* name of callback routine                */
   char       *mnemo;            /* button mnemonic                         */
   char       *accel;            /* button accelerator                      */
   char       *accel_text;       /* button accelerator text                 */
   KmButtFlag  flags;            /* sensitivity type etc.                   */
   KmWidget    widget;           /* Motif widget ID                         */
 } KmButton;                     /*                                         */
                                 /*                                         */
 
extern struct {                        /*
    */   /* indirect calls to avoid linking HIGZ
    */   IntFunc    *graf_info_C;      /* pass display, open and close
 (ixmotif)  */   SUBROUTINE *graf_size_F;      /* resize window (IGRSIZ)
            */   SUBROUTINE *graf_pick_F;      /* identifying graphics objects
 (IGOBJ)    */   SUBROUTINE *graf_attr_F;      /* set attributes (IGSET)
            */   SUBROUTINE *graf_close_F;     /* close workstation (ICLWK)
            */   /* optional routines for Motif customization
            */   pCharFunc  *user_FallBk_C;    /* get application fallbacks
            */   IntFunc    *user_TopWid_C;    /* pass toplevel widget
 identifiers        */ } klnkaddr;                     /*
                    */
 
typedef enum {                  /*                                         */
  KmFLAG_FORGET = 0x01,         /* last value is not kept for Motif panels */
  KmFLAG_MINUS  = 0x02,         /* -VALUE is not an abbrev for CHOPT=VALUE */
  KmFLAG_QUOTE  = 0x04,         /* do not remove quotes                    */
  KmFLAG_VARARG = 0x08,         /* append additional args to this param.   */
  KmFLAG_CONST  = 0x10,         /* do not allow to assign a value          */
  KmFLAG_HIDDEN = 0x20,         /* do not show in menus                    */
  KmFLAG_SEPARATE = 0x40        /* treat arguments as separate tokens      */
 } KmParFlag;                    /*                                         */
                                 /*                                         */
 typedef enum {                  /*                                         */
   KmTYPE_CHAR   = 'C',          /* character string                        */
   KmTYPE_FILE   = 'F',          /* file name                               */
   KmTYPE_INT    = 'I',          /* integer                                 */
   KmTYPE_OPTION = 'O',          /* option                                  */
   KmTYPE_REAL   = 'R'           /* real                                    */
 } KmParType;                    /*                                         */
                                 /*                                         */
 
typedef struct {                /* file name                               */
  char         *filter_default; /* filter wildcard                         */
  char         *filter_current; /* current filter                          */
 } KmParFile;                    /*                                         */
                                 /*                                         */
 typedef struct {                /*                                         */
   char         *range_lower;    /* lower value of range                    */
   char         *range_upper;    /* upper value of range                    */
   char         *slider_lower;   /* lower limit for slider                  */
   char         *slider_upper;   /* upper limit for slider                  */
   int           decimals;       /* number of decimals used for slider      */
 } KmParInt;                     /*                                         */
                                 /*                                         */
 typedef struct {                /* option                                  */
   char        **text;           /* explanations (parallel to range_value)  */
   int          *mutex;          /* mutex group to which text belongs       */
   int          *radio;          /* radio group to which text belongs       */
 } KmParOption;                  /*                                         */
                                 /*                                         */
 
typedef KmParInt KmParReal;     /* real and int have the same fields       */
                                /*                                         */
 typedef struct {                /*                                         */
   char         *name;           /* parameter name                          */
   int           abbrev;         /* minimum length that name is recognized  */
   char         *prompt;         /* prompt string                           */
   char         *dfault;         /* default value                           */
   char         *last;           /* last value for Motif panel (malloced)   */
   int           width;          /* width of input field                    */
   int           range_count;    /* number of items in range_value          */
   char        **range_value;    /* list of allowed values                  */
   int           select_count;   /* number of items in select_count         */
   char        **select_value;   /* list of values for selection box        */
   KmParFlag     flags;          /* special flags                           */
   KmParType     type;           /* parameter type                          */
   void        *ptype;           /* structure pointer selected by type      */
 } KmParameter;                  /*                                         */
                                 /*                                         */
 
typedef struct _KmCommand {     /*                                         */
  struct _KmCommand *next;      /* link to next command                    */
  char         *path;           /* command path                            */
  char         *name;           /* command name                            */
  int           hidden;         /* flag if command is invisible            */
  int           level;          /* depth of submenus                       */
  int           total;          /* total number of parameters              */
  int           mandatory;      /* number of mandatory parameters          */
  KmParameter **par;            /* list of total parameter descriptions    */
  int           list_par;       /* index+1 of parameter taking a list      */
  int           xcount;         /* count number of action calls            */
  SUBROUTINE   *action_F;       /* action routine                          */
  IntFunc      *action_C;       /* action routine                          */
  SUBROUTINE   *user_help_F;    /* user help routine                       */
  pCharFunc    *user_help_C;    /* user help routine                       */
  int          nguidance;       /* number of lines in guidance text        */
  char        **guidance;       /* help text                               */
  int           argc;           /* number of arguments entered             */
  char        **argv;           /* argc argument values                    */
  char         *argline;        /* argument line as entered                */
  int          *argoffs;        /* argc offsets into argline for KUGETE    */
 } KmCommand;                    /*                                         */
                                 /*                                         */
 
typedef struct _KmMenu {        /*                                         */
  struct _KmMenu *next;         /* link to next menu                       */
  struct _KmMenu *down;         /* link to submenu                         */
  char         *path;           /* path of parent menu                     */
  char         *name;           /* menu name                               */
  int           level;          /* depth of submenus                       */
  KmCommand    *cmds;           /* link to first command                   */
  int          nguidance;       /* number of lines in guidance text        */
  char        **guidance;       /* help text                               */
 } KmMenu;                       /*                                         */
                                 /*                                         */
 extern void klnkbrcl();         /*                                         */
 extern void klnkicon();         /*                                         */
 extern void klnkkmcl();         /*                                         */
 extern void klnkmenu();         /*                                         */
                                 /*                                         */
 
#ifdef F77_LCASE
#  define gkdraw_ gkdraw
#  define gxdraw_ gxdraw
#  define gxpick_ gxpick
#endif
 
#ifdef F77_UCASE
#  define gkdraw_ GKDRAW
#  define gxdraw_ GXDRAW
#  define gxpick_ GXPICK
#endif
 
#ifdef IBM370
#  pragma linkage(GKDRAW,FORTRAN)
#  pragma linkage(GXDRAW,FORTRAN)
#  pragma linkage(GXPICK,FORTRAN)
#endif
 
extern void gkdraw_();
extern void gxdraw_();
extern void gxpick_();
 
void gkdraw_()
{
 
static KmParReal   _GEANT_CVOL_VALCUT_XCUT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_VALCUT_XCUT = { "XCUT", 4,
 "x coordinate of cutted value", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_VALCUT_XCUT_type };
static KmParReal   _GEANT_CVOL_VALCUT_YCUT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_VALCUT_YCUT = { "YCUT", 4,
 "y coordinate of cutted value", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_VALCUT_YCUT_type };
static KmParReal   _GEANT_CVOL_VALCUT_ZCUT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_VALCUT_ZCUT = { "ZCUT", 4,
 "z coordinate of cutted value", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_VALCUT_ZCUT_type };
static KmParameter *_GEANT_CVOL_VALCUT_parameters[] = {
 &_GEANT_CVOL_VALCUT_XCUT, &_GEANT_CVOL_VALCUT_YCUT, &_GEANT_CVOL_VALCUT_ZCUT
 };
static char *_GEANT_CVOL_VALCUT_guidance[] = {
 "It allows the cutting in the ray-tracing. All the volumes are cutted",
 "from XCUT to +BIG along the x axis, from YCUT to +BIG along the y axis",
 "and from ZCUT to +BIG along the z axis." };
static KmCommand _GEANT_CVOL_VALCUT = {  (KmCommand*)0, "/GEANT/CVOL/VALCUT",
 "VALCUT", 0, 2, 3, 3, _GEANT_CVOL_VALCUT_parameters, 0, 0, gxdraw_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_CVOL_VALCUT_guidance,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CVOL_SPHE_CNVV = { "CNVV", 4,
 " Name of volume to be clipped          ", "*   ", (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_CVOL_SPHE_RMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_SPHE_RMAX = { "RMAX", 4,
 " External radius of sphere             ", "0.1", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_SPHE_RMAX_type };
static KmParReal   _GEANT_CVOL_SPHE_XMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_SPHE_XMED = { "XMED", 4,
 " Center X coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_SPHE_XMED_type };
static KmParReal   _GEANT_CVOL_SPHE_YMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_SPHE_YMED = { "YMED", 4,
 " Center Y coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_SPHE_YMED_type };
static KmParReal   _GEANT_CVOL_SPHE_ZMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_SPHE_ZMED = { "ZMED", 4,
 " Center Z coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_SPHE_ZMED_type };
static KmParameter *_GEANT_CVOL_SPHE_parameters[] = { &_GEANT_CVOL_SPHE_CNVV,
 &_GEANT_CVOL_SPHE_RMAX, &_GEANT_CVOL_SPHE_XMED, &_GEANT_CVOL_SPHE_YMED,
 &_GEANT_CVOL_SPHE_ZMED };
static char *_GEANT_CVOL_SPHE_guidance[] = {
 "This command performs a boolean subtraction between the volume",
 "CNVV and a sphere; the sphere has the given parameters and is placed in",
 "the MARS according to the given coordinates of its center.",
 "See also CVOL. The following commands clip by a sphere,",
 "positioned according to the given parameters, the volume specified",
 "by NAME (a valid string for the NAME of the volume",
 "can be found using the DTREE command).", "EXAMPLE -", " dopt hide on",
 " satt * seen -2", " draw NAME 40 40 0 10 10 .01 .01", " next",
 " sphe * 500 0 0 500", " draw NAME 40 40 0 10 10 .01 .01", " box ." };
static KmCommand _GEANT_CVOL_SPHE = { &_GEANT_CVOL_VALCUT, "/GEANT/CVOL/SPHE",
 "SPHE", 0, 2, 5, 1, _GEANT_CVOL_SPHE_parameters, 0, 0, gxdraw_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 15, _GEANT_CVOL_SPHE_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_CVOL_CONE_CNVV = { "CNVV", 4,
 " Name of volume to be clipped          ", "*   ", (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_CVOL_CONE_RMAX1_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_CONE_RMAX1 = { "RMAX1", 5,
 " Min external radius                   ", "0.1", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_CONE_RMAX1_type };
static KmParReal   _GEANT_CVOL_CONE_RMAX2_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_CONE_RMAX2 = { "RMAX2", 5,
 " Max external radius                   ", "0.1", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_CONE_RMAX2_type };
static KmParReal   _GEANT_CVOL_CONE_ZDEM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_CONE_ZDEM = { "ZDEM", 4,
 " Half length of cone axis              ", "0.1", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_CONE_ZDEM_type };
static KmParReal   _GEANT_CVOL_CONE_XMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_CONE_XMED = { "XMED", 4,
 " Center X coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_CONE_XMED_type };
static KmParReal   _GEANT_CVOL_CONE_YMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_CONE_YMED = { "YMED", 4,
 " Center Y coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_CONE_YMED_type };
static KmParReal   _GEANT_CVOL_CONE_ZMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_CONE_ZMED = { "ZMED", 4,
 " Center Z coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_CONE_ZMED_type };
static KmParameter *_GEANT_CVOL_CONE_parameters[] = { &_GEANT_CVOL_CONE_CNVV,
 &_GEANT_CVOL_CONE_RMAX1, &_GEANT_CVOL_CONE_RMAX2, &_GEANT_CVOL_CONE_ZDEM,
 &_GEANT_CVOL_CONE_XMED, &_GEANT_CVOL_CONE_YMED, &_GEANT_CVOL_CONE_ZMED };
static char *_GEANT_CVOL_CONE_guidance[] = {
 "This command performs a boolean subtraction between the volume",
 "CNVV and a cone; the cone has the given parameters and is placed in",
 "the MARS according to the given coordinates of its center.",
 "See also CVOL.", "The following commands will clip by a cone,",
 "positioned according the given parameters, the volume specified",
 "by NAME (a valid string for the NAME of the volume",
 "can be found using the DTREE command).", " EXAMPLE -", " dopt hide on",
 " satt * seen -2", " draw NAME 40 40 0 10 10 .01 .01", " next",
 " cone * 1 750 1000 0 0 1000", " draw NAME 40 40 0 10 10 .01 .01", " box ." };
static KmCommand _GEANT_CVOL_CONE = { &_GEANT_CVOL_SPHE, "/GEANT/CVOL/CONE",
 "CONE", 0, 2, 7, 1, _GEANT_CVOL_CONE_parameters, 0, 0, gxdraw_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 16, _GEANT_CVOL_CONE_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_CVOL_TUBE_CNVV = { "CNVV", 4,
 " Name of volume to be clipped          ", "*   ", (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_CVOL_TUBE_RMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_TUBE_RMAX = { "RMAX", 4,
 " External radius of tube               ", "0.1", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_TUBE_RMAX_type };
static KmParReal   _GEANT_CVOL_TUBE_ZDEM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_TUBE_ZDEM = { "ZDEM", 4,
 " Half length of tube axis              ", "0.1", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CVOL_TUBE_ZDEM_type };
static KmParReal   _GEANT_CVOL_TUBE_XMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_TUBE_XMED = { "XMED", 4,
 " Center X coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_TUBE_XMED_type };
static KmParReal   _GEANT_CVOL_TUBE_YMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_TUBE_YMED = { "YMED", 4,
 " Center Y coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_TUBE_YMED_type };
static KmParReal   _GEANT_CVOL_TUBE_ZMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CVOL_TUBE_ZMED = { "ZMED", 4,
 " Center Z coordinate                   ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_TUBE_ZMED_type };
static KmParameter *_GEANT_CVOL_TUBE_parameters[] = { &_GEANT_CVOL_TUBE_CNVV,
 &_GEANT_CVOL_TUBE_RMAX, &_GEANT_CVOL_TUBE_ZDEM, &_GEANT_CVOL_TUBE_XMED,
 &_GEANT_CVOL_TUBE_YMED, &_GEANT_CVOL_TUBE_ZMED };
static char *_GEANT_CVOL_TUBE_guidance[] = {
 "This command performs a boolean subtraction between the volume",
 "CNVV and a tube; the tube has the given parameters and is placed in",
 "the MARS according the given coordinates of its center.", "See also CVOL.",
 "The following commands will clip, by a tube,",
 "positioned according to the given parameters, the volume specified",
 "by NAME (a valid string for the NAME of the volume",
 "can be found using the DTREE command).", " EXAMPLE -", " dopt hide on",
 " satt * seen -2", " draw NAME 40 40 0 10 10 .01 .01", " next",
 " tube * 500 1000 500 0 0", " draw NAME 40 40 0 10 10 .01 .01", " box ." };
static KmCommand _GEANT_CVOL_TUBE = { &_GEANT_CVOL_CONE, "/GEANT/CVOL/TUBE",
 "TUBE", 0, 2, 6, 1, _GEANT_CVOL_TUBE_parameters, 0, 0, gxdraw_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 16, _GEANT_CVOL_TUBE_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_CVOL_BOX_CNNV = { "CNNV", 4,
 " Name of volume to be clipped          ", "*   ", (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_CVOL_BOX_XMIN_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_CVOL_BOX_XMIN = { "XMIN", 4,
 " Lower limit of the Shape X coordinate ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_BOX_XMIN_type };
static KmParReal   _GEANT_CVOL_BOX_XMAX_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_CVOL_BOX_XMAX = { "XMAX", 4,
 " Upper limit of the Shape X coordinate ", "-9999.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_BOX_XMAX_type };
static KmParReal   _GEANT_CVOL_BOX_YMIN_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_CVOL_BOX_YMIN = { "YMIN", 4,
 " Lower limit of the Shape Y coordinate ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_BOX_YMIN_type };
static KmParReal   _GEANT_CVOL_BOX_YMAX_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_CVOL_BOX_YMAX = { "YMAX", 4,
 " Upper limit of the Shape Y coordinate ", "-9999.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_BOX_YMAX_type };
static KmParReal   _GEANT_CVOL_BOX_ZMIN_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_CVOL_BOX_ZMIN = { "ZMIN", 4,
 " Lower limit of the Shape Z coordinate ", "-10000.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_BOX_ZMIN_type };
static KmParReal   _GEANT_CVOL_BOX_ZMAX_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_CVOL_BOX_ZMAX = { "ZMAX", 4,
 " Upper limit of the Shape Z coordinate ", "-9999.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CVOL_BOX_ZMAX_type };
static KmParameter *_GEANT_CVOL_BOX_parameters[] = { &_GEANT_CVOL_BOX_CNNV,
 &_GEANT_CVOL_BOX_XMIN, &_GEANT_CVOL_BOX_XMAX, &_GEANT_CVOL_BOX_YMIN,
 &_GEANT_CVOL_BOX_YMAX, &_GEANT_CVOL_BOX_ZMIN, &_GEANT_CVOL_BOX_ZMAX };
static char *_GEANT_CVOL_BOX_guidance[] = {
 "This command performs a boolean subtraction between the volume",
 "CNVV and a box placed in the MARS according the values of the given",
 "coordinates. See also CVOL.", "The following commands will clip by a box,",
 "with a vertex at the origin, the volume specified by NAME (a valid",
 "string for the NAME of the volume can be found using the DTREE command).",
 " EXAMPLE -", " dopt hide on", " satt * seen -2",
 " draw NAME 40 40 0 10 10 .01 .01", " next",
 " box NAME 0 1000 0 1000 0 1000", " draw NAME 40 40 0 10 10 .01 .01",
 " box ." };
static KmCommand _GEANT_CVOL_BOX = { &_GEANT_CVOL_TUBE, "/GEANT/CVOL/BOX",
 "BOX", 0, 2, 7, 1, _GEANT_CVOL_BOX_parameters, 0, 0, gxdraw_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 14, _GEANT_CVOL_BOX_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DUVIEW_NAME = { "NAME", 4, "Detector name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_DRAWING_DUVIEW_TYPE = { "TYPE", 4, "View name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_DRAWING_DUVIEW_CPXTYP = { "CPXTYP", 6,
 "Complexity name", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_DRAWING_DUVIEW_IVIEW_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DUVIEW_IVIEW = { "IVIEW", 5,
 "View number where picture is stored", "0", (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_DUVIEW_IVIEW_type };
static KmParameter *_GEANT_DRAWING_DUVIEW_parameters[] = {
 &_GEANT_DRAWING_DUVIEW_NAME, &_GEANT_DRAWING_DUVIEW_TYPE,
 &_GEANT_DRAWING_DUVIEW_CPXTYP, &_GEANT_DRAWING_DUVIEW_IVIEW };
static char *_GEANT_DRAWING_DUVIEW_guidance[] = {
 " CALL GUVIEW(name,type,cpxtyp,iview)" };
static KmCommand _GEANT_DRAWING_DUVIEW = {  (KmCommand*)0,
 "/GEANT/DRAWING/DUVIEW", "DUVIEW", 0, 2, 4, 3,
 _GEANT_DRAWING_DUVIEW_parameters, 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 1, _GEANT_DRAWING_DUVIEW_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static KmParameter _GEANT_DRAWING_DCHIT_CHUSET = { "CHUSET", 6,
 "User set identifier", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_DRAWING_DCHIT_CHUDET = { "CHUDET", 6,
 "User detector identifier", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_DRAWING_DCHIT_ITRA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCHIT_ITRA = { "ITRA", 4,
 "Number of the selected track", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_DCHIT_ITRA_type };
static KmParInt    _GEANT_DRAWING_DCHIT_ISYMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCHIT_ISYMB = { "ISYMB", 5,
 "Character selection number", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_DCHIT_ISYMB_type };
static KmParReal   _GEANT_DRAWING_DCHIT_SIZMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCHIT_SIZMAX = { "SIZMAX", 6,
 "Maximum character size (cm)", "1", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DCHIT_SIZMAX_type };
static KmParInt    _GEANT_DRAWING_DCHIT_IHIT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCHIT_IHIT = { "IHIT", 4,
 "Index of array HITS", "4", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_DCHIT_IHIT_type };
static KmParReal   _GEANT_DRAWING_DCHIT_HITMIN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCHIT_HITMIN = { "HITMIN", 6,
 "Lower boundary of HITS(IHIT)", "0", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DCHIT_HITMIN_type };
static KmParReal   _GEANT_DRAWING_DCHIT_HITMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCHIT_HITMAX = { "HITMAX", 6,
 "Upper boundary of HITS(IHIT)", "0", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DCHIT_HITMAX_type };
static KmParameter *_GEANT_DRAWING_DCHIT_parameters[] = {
 &_GEANT_DRAWING_DCHIT_CHUSET, &_GEANT_DRAWING_DCHIT_CHUDET,
 &_GEANT_DRAWING_DCHIT_ITRA, &_GEANT_DRAWING_DCHIT_ISYMB,
 &_GEANT_DRAWING_DCHIT_SIZMAX, &_GEANT_DRAWING_DCHIT_IHIT,
 &_GEANT_DRAWING_DCHIT_HITMIN, &_GEANT_DRAWING_DCHIT_HITMAX };
static char *_GEANT_DRAWING_DCHIT_guidance[] = {
 " CALL GDCHIT(chuset,chudet,itra,isymb,sizmax,ihit,hitmin,hitmax)",
 "The character plotted at each hit point may be chosen via",
 "CSYMB; isymb is composed as:",
 "      -1   (small) hardware points             (fast)",
 "       0   software crosses                    (default)",
 " 840,850   empty/full circles                  (slow)",
 " 841,851   empty/full squares                  (slow)",
 " 842,852   empty/full triangles (up)           (slow)",
 " 843,853   empty diamond/full triangle (down)  (slow)",
 " 844,854   empty/full stars                    (slow)",
 "Except for isymb=-1 the SIZE of the character on the screen",
 "is a function of HITS(IHIT), the array containing the calorimeter",
 "quantity, with HITMIN and HITMAX defining its range.",
 "The maximum character size (used in overflow) is SIZMAX.",
 " SIZE = SIZMAX * ( HITS(IHIT) - HITMIN ) / HITMAX" };
static KmCommand _GEANT_DRAWING_DCHIT = { &_GEANT_DRAWING_DUVIEW,
 "/GEANT/DRAWING/DCHIT", "DCHIT", 0, 2, 8, 0, _GEANT_DRAWING_DCHIT_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 15,
 _GEANT_DRAWING_DCHIT_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_KHITS_CHUSET = { "CHUSET", 6,
 "User set identifier", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_DRAWING_KHITS_CHUDET = { "CHUDET", 6,
 "User detector identifier", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_DRAWING_KHITS_EPSILO_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_KHITS_EPSILO = { "EPSILO", 6,
 "Pick aperture", "0.1", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_KHITS_EPSILO_type };
static KmParameter *_GEANT_DRAWING_KHITS_parameters[] = {
 &_GEANT_DRAWING_KHITS_CHUSET, &_GEANT_DRAWING_KHITS_CHUDET,
 &_GEANT_DRAWING_KHITS_EPSILO };
static char *_GEANT_DRAWING_KHITS_guidance[] = {
 " CALL GKHITS(chuset,chudet,epsilo)",
 "The picking of hit points requires the appropriate JSET data structure",
 "have been filled",
 "and is  repeated until the character typed is 'Q' or 'q' (GKS) or the",
 "right button of the mouse is clicked (X11).",
 "If the character typed to pick is 'K' or 'k' then the",
 "kinematics of the corresponding track is also printed.",
 "The search is made of all the hits of all tracks in",
 "detector CHUDET of set CHUSET.",
 "EPSILO is the pick aperture; if EPSILO<0 its absolute value is taken",
 "and in addition the pick aperture is drawn; if EPSILO=0",
 "there is an infinite pick aperture and",
 "over all the hits the one nearest to the pick point is taken." };
static KmCommand _GEANT_DRAWING_KHITS = { &_GEANT_DRAWING_DCHIT,
 "/GEANT/DRAWING/KHITS", "KHITS", 0, 2, 3, 0, _GEANT_DRAWING_KHITS_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 13,
 _GEANT_DRAWING_KHITS_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DHITS_CHUSET = { "CHUSET", 6,
 "User set identifier", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_DRAWING_DHITS_CHUDET = { "CHUDET", 6,
 "User detector identifier", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_DRAWING_DHITS_ITRA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DHITS_ITRA = { "ITRA", 4,
 "Number of the selected track", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_DHITS_ITRA_type };
static KmParInt    _GEANT_DRAWING_DHITS_ISYMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DHITS_ISYMB = { "ISYMB", 5,
 "Character selection number", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_DHITS_ISYMB_type };
static KmParReal   _GEANT_DRAWING_DHITS_SSYMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DHITS_SSYMB = { "SSYMB", 5,
 "Size of characters (cm)", "0.1", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DHITS_SSYMB_type };
static KmParameter *_GEANT_DRAWING_DHITS_parameters[] = {
 &_GEANT_DRAWING_DHITS_CHUSET, &_GEANT_DRAWING_DHITS_CHUDET,
 &_GEANT_DRAWING_DHITS_ITRA, &_GEANT_DRAWING_DHITS_ISYMB,
 &_GEANT_DRAWING_DHITS_SSYMB };
static char *_GEANT_DRAWING_DHITS_guidance[] = {
 "CALL GDHITS(chuset,chudet,itra,isymb,ssymb).",
 "The character plotted at each hit point may be chosen by isymb :",
 "      -1   (small) hardware points             (fast)",
 "       0   software crosses                    (default)",
 "   840,850   empty/full circles                  (slow)",
 "   841,851   empty/full squares                  (slow)",
 "   842,852   empty/full triangles (up)           (slow)",
 "   843,853   empty diamond/full triangle (down)  (slow)",
 "   844,854   empty/full stars                    (slow)",
 "Except for isymb=-1, the size of the character on the screen can be",
 "chosen by SSYMB cm. The hit colour will follow the value of TXCI (text",
 "colour) for isymb>0, the value of PMCI (polymarkers colour) for isymb<0,",
 "the value of PLCI (polyline colour) for isymb=0." };
static KmCommand _GEANT_DRAWING_DHITS = { &_GEANT_DRAWING_KHITS,
 "/GEANT/DRAWING/DHITS", "DHITS", 0, 2, 5, 0, _GEANT_DRAWING_DHITS_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 13,
 _GEANT_DRAWING_DHITS_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DRAWING_DPART_ITRA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DPART_ITRA = { "ITRA", 4, "Track number",
 "0", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_DPART_ITRA_type };
static KmParInt    _GEANT_DRAWING_DPART_ISEL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DPART_ISEL = { "ISEL", 4, "Option flag",
 "11", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_DPART_ISEL_type };
static KmParReal   _GEANT_DRAWING_DPART_SIZE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DPART_SIZE = { "SIZE", 4,
 "Character size (cm) for particle names", "0.25", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DPART_SIZE_type };
static KmParameter *_GEANT_DRAWING_DPART_parameters[] = {
 &_GEANT_DRAWING_DPART_ITRA, &_GEANT_DRAWING_DPART_ISEL,
 &_GEANT_DRAWING_DPART_SIZE };
static char *_GEANT_DRAWING_DPART_guidance[] = {
 " CALL GDPART(itra,isel,size)", " isel=x1 to draw the track number",
 " isel=1x to draw the particle name" };
static KmCommand _GEANT_DRAWING_DPART = { &_GEANT_DRAWING_DHITS,
 "/GEANT/DRAWING/DPART", "DPART", 0, 2, 3, 0, _GEANT_DRAWING_DPART_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_DRAWING_DPART_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_KXYZ_EPSILO_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_KXYZ_EPSILO = { "EPSILO", 6, "Delta angle",
 "0.25", (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_KXYZ_EPSILO_type };
static KmParameter *_GEANT_DRAWING_KXYZ_parameters[] = {
 &_GEANT_DRAWING_KXYZ_EPSILO };
static char *_GEANT_DRAWING_KXYZ_guidance[] = { " CALL GKXYZ(epsilo)",
 "The picking of track points requires the JXYZ data structure",
 "and is  repeated until the character typed is 'Q' or 'q' (GKS)",
 "or the right button of the mouse is clicked (X11).",
 "EPSILO is the delta angle used for picking; if EPSILO=0",
 "there is no optimization performed and",
 "over all the track points the one nearest to the pick", "point is taken." };
static KmCommand _GEANT_DRAWING_KXYZ = { &_GEANT_DRAWING_DPART,
 "/GEANT/DRAWING/KXYZ", "KXYZ", 0, 2, 1, 0, _GEANT_DRAWING_KXYZ_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 8,
 _GEANT_DRAWING_KXYZ_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DRAWING_DXYZ_ITRA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DXYZ_ITRA = { "ITRA", 4, "Track number",
 "0", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_DXYZ_ITRA_type };
static KmParameter *_GEANT_DRAWING_DXYZ_parameters[] = {
 &_GEANT_DRAWING_DXYZ_ITRA };
static char *_GEANT_DRAWING_DXYZ_guidance[] = { " CALL GDXYZ(itra)",
 "Draw tracks previously stored via GSXYZ." };
static KmCommand _GEANT_DRAWING_DXYZ = { &_GEANT_DRAWING_KXYZ,
 "/GEANT/DRAWING/DXYZ", "DXYZ", 0, 2, 1, 0, _GEANT_DRAWING_DXYZ_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_DRAWING_DXYZ_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_ZOOM_ZFU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_ZOOM_ZFU = { "ZFU", 3,
 "Zoom factor for U-coord. (horizontal)", "2.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_ZOOM_ZFU_type };
static KmParReal   _GEANT_DRAWING_ZOOM_ZFV_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_ZOOM_ZFV = { "ZFV", 3,
 "Zoom factor for V-coord. (vertical)", "2.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_ZOOM_ZFV_type };
static KmParInt    _GEANT_DRAWING_ZOOM_ISEL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_ZOOM_ISEL = { "ISEL", 4, "Options", "1",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_ZOOM_ISEL_type };
static KmParReal   _GEANT_DRAWING_ZOOM_UZ0_type = { "0.", "20.", "0.", "20.",
 0 };
static KmParameter _GEANT_DRAWING_ZOOM_UZ0 = { "UZ0", 3,
 "U-coord. of the centre of zoom rectangle", "10.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_ZOOM_UZ0_type };
static KmParReal   _GEANT_DRAWING_ZOOM_VZ0_type = { "0.", "20.", "0.", "20.",
 0 };
static KmParameter _GEANT_DRAWING_ZOOM_VZ0 = { "VZ0", 3,
 "V-coord. of the centre of zoom rectangle", "10.", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_ZOOM_VZ0_type };
static KmParReal   _GEANT_DRAWING_ZOOM_U0_type = { "0.", "20.", "0.", "20.", 0
 };
static KmParameter _GEANT_DRAWING_ZOOM_U0 = { "U0", 2,
 "U-coord. of the centre of resulting zoomed rectangle", "10.", (char*)0, 12,
 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_ZOOM_U0_type };
static KmParReal   _GEANT_DRAWING_ZOOM_V0_type = { "0.", "20.", "0.", "20.", 0
 };
static KmParameter _GEANT_DRAWING_ZOOM_V0 = { "V0", 2,
 "V-coord. of the centre of resulting zoomed rectangle", "10.", (char*)0, 12,
 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_ZOOM_V0_type };
static KmParameter *_GEANT_DRAWING_ZOOM_parameters[] = {
 &_GEANT_DRAWING_ZOOM_ZFU, &_GEANT_DRAWING_ZOOM_ZFV,
 &_GEANT_DRAWING_ZOOM_ISEL, &_GEANT_DRAWING_ZOOM_UZ0,
 &_GEANT_DRAWING_ZOOM_VZ0, &_GEANT_DRAWING_ZOOM_U0, &_GEANT_DRAWING_ZOOM_V0 };
static char *_GEANT_DRAWING_ZOOM_guidance[] = {
 " CALL GDZOOM(zfu,zfv,uz0,vz0,u0,v0)",
 "This command sets the zoom parameters that will be used by",
 "subsequent calls to the drawing routines. Each zoom operation is always",
 "relative to the status of the current zoom parameters.",
 "The scale factors in u,v are respectively  zfu,zfv.",
 "zfu=0 (or zfv=0) will act as a reset (i.e. unzoomed viewing).",
 "The zoom is computed around uz0,vz0 (user coordinates),",
 "and the resulting picture will be centered at u0,v0.",
 "The use of the space bar is replaced by the left button of the mouse",
 "running with X11:", "If isel=0 :", " 1. position the cursor at (uz0,vz0)",
 " 2. type the space bar (GKS)", "(u0,v0 are chosen at centre of screen)",
 "If isel=1 :", " 1. position the cursor at first corner of zoom rectangle",
 " 2. type the space bar (GKS)",
 " 3. position the cursor at second corner of zoom rectangle",
 " 4. type the space bar (GKS)",
 "(zfu,zfv are chosen according to the zoom rectangle;",
 "uz0,vz0 are chosen at the centre of the zoom rectangle;",
 "u0,v0 are chosen at centre of screen)", "If isel=2 :",
 " 1. position the cursor at (uz0,vz0)", " 2. type the space bar (GKS)",
 " 3. position the cursor at (u0,v0)", " 4. type the space bar (GKS)",
 "If isel=1000+n and running with X-windows:",
 " 1. n must be the identifier of an active view bank",
 " 2. clicking on the left button of the mouse will display",
 "    a zoomed view (computed around the cursor position) of",
 "    the previous drawing in a new window",
 " 3. it is now possible to iterate the zooming from the new window",
 " 4. clicking on the right button will return the control to the",
 "    main window",
 " 5. clicking on the left button it is possible to open new windows",
 "    zooming in other points of the detector",
 " 6. clicking on the right button when the main window is active",
 "    will return the control to the 'command mode'." };
static KmCommand _GEANT_DRAWING_ZOOM = { &_GEANT_DRAWING_DXYZ,
 "/GEANT/DRAWING/ZOOM", "ZOOM", 0, 2, 7, 0, _GEANT_DRAWING_ZOOM_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 39,
 _GEANT_DRAWING_ZOOM_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DRAWING_LENS_KNUM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_LENS_KNUM = { "KNUM", 4,
 "View bank identifier", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_LENS_KNUM_type };
static KmParameter _GEANT_DRAWING_LENS_KSAM = { "KSAM", 4,
 "Sample mode         ", "OFF ", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_DRAWING_LENS_parameters[] = {
 &_GEANT_DRAWING_LENS_KNUM, &_GEANT_DRAWING_LENS_KSAM };
static char *_GEANT_DRAWING_LENS_guidance[] = {
 "Interactive zooming for detectors and events when running",
 "with X-windows. Using this command, when showing the contents of a",
 "view bank, it is possible to click (left button) in two points of the",
 "drawing (which will represent the left upper corner and the right",
 "bottom corner of the part to be zoomed). After the second click",
 "a new 'window' will appear to fit the frame defined",
 "by the two clicks and it will show a zoomed view as seen from a",
 "lens with those dimensions. Clicking now the central button will",
 "translate the lens over the drawing, while clicking the right button",
 "will stop it. Moreover, clicking the left button of the",
 "mouse, the lens will increase (or decrease) its magnification",
 "power according to the backward-to-forward movement of the mouse.",
 "A click on the right button will stop this action and it is possible",
 "to restart the translation of the lens or, clicking",
 "on the right button again, to make the lens disappear. It is then possible",
 "to open another 'window-lens' with different dimensions. Thus,",
 "this command can be useful to scan detailed parts of a detector or",
 "to scan hits and showers for events. Clicking the right",
 "button when no lens is displayed will return the control to the",
 "'command mode'. The LENS is also available in sample mode when KSAM is",
 "'ON'.", "The following commands will fill a view bank and will",
 "allow to scan the detector and an event previously stored",
 "via the use of LENS (when running", "with X-windows):", " EXAMPLE -",
 " satt * seen 1", " dopen 1", " draw NAME 40 40 0 10 10 .01 .01", " dxyz 0",
 " dhits * * 0 0 .2", " dclose", " dsh 1", " lens 1 on" };
static KmCommand _GEANT_DRAWING_LENS = { &_GEANT_DRAWING_ZOOM,
 "/GEANT/DRAWING/LENS", "LENS", 0, 2, 2, 1, _GEANT_DRAWING_LENS_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 34,
 _GEANT_DRAWING_LENS_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_PERSP_NAME = { "NAME", 4, "Volume name",
 "    ", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParReal   _GEANT_DRAWING_PERSP_DISTT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_PERSP_DISTT = { "DISTT", 5,
 "Volume distance from observer", "1000.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_PERSP_DISTT_type };
static KmParameter _GEANT_DRAWING_PERSP_SAMP = { "SAMP", 4,
 "Control to the mouse", "OFF ", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_DRAWING_PERSP_parameters[] = {
 &_GEANT_DRAWING_PERSP_NAME, &_GEANT_DRAWING_PERSP_DISTT,
 &_GEANT_DRAWING_PERSP_SAMP };
static char *_GEANT_DRAWING_PERSP_guidance[] = {
 "To control the perspective according to the variation of the distance",
 "between the observer and the object (if PROJ has the value PERS).",
 "If SAMP is ON the control of the distance is given via the mouse." };
static KmCommand _GEANT_DRAWING_PERSP = { &_GEANT_DRAWING_LENS,
 "/GEANT/DRAWING/PERSP", "PERSP", 0, 2, 3, 2, _GEANT_DRAWING_PERSP_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_DRAWING_PERSP_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_MOVE3D_NAME = { "NAME", 4, "Volume name",
 "    ", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParReal   _GEANT_DRAWING_MOVE3D_THETA_type = { "0.", "180.", "0.",
 "180.", 0 };
static KmParameter _GEANT_DRAWING_MOVE3D_THETA = { "THETA", 5,
 "Viewing angle theta (for 3D projection)", "40.", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_MOVE3D_THETA_type };
static KmParReal   _GEANT_DRAWING_MOVE3D_PHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_MOVE3D_PHI = { "PHI", 3,
 "Viewing angle phi (for 3D projection)", "40.", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_MOVE3D_PHI_type };
static KmParReal   _GEANT_DRAWING_MOVE3D_PSI_type = { "0.", "180.", "0.",
 "180.", 0 };
static KmParameter _GEANT_DRAWING_MOVE3D_PSI = { "PSI", 3,
 "Viewing angle psi (for 2D rotation)", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_MOVE3D_PSI_type };
static KmParReal   _GEANT_DRAWING_MOVE3D_U0_type = { "0.", "20.", "0.", "20.",
 0 };
static KmParameter _GEANT_DRAWING_MOVE3D_U0 = { "U0", 2,
 "U-coord. (horizontal) of volume origin", "10.", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_MOVE3D_U0_type };
static KmParReal   _GEANT_DRAWING_MOVE3D_V0_type = { "0.", "20.", "0.", "20.",
 0 };
static KmParameter _GEANT_DRAWING_MOVE3D_V0 = { "V0", 2,
 "V-coord. (vertical) of volume origin", "10.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_MOVE3D_V0_type };
static KmParReal   _GEANT_DRAWING_MOVE3D_SU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_MOVE3D_SU = { "SU", 2,
 "Scale factor for U-coord.", "0.01", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_MOVE3D_SU_type };
static KmParReal   _GEANT_DRAWING_MOVE3D_SV_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_MOVE3D_SV = { "SV", 2,
 "Scale factor for V-coord.", "0.01", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_MOVE3D_SV_type };
static KmParReal   _GEANT_DRAWING_MOVE3D_SZ_type = { "0.1", "10.", "0.1",
 "10.", 1 };
static KmParameter _GEANT_DRAWING_MOVE3D_SZ = { "SZ", 2, "Scale zoom factor",
 "1.", (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_MOVE3D_SZ_type };
static char *_GEANT_DRAWING_MOVE3D_NOPT_range[] = { "T", "H" };
static char *_GEANT_DRAWING_MOVE3D_NOPT_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_DRAWING_MOVE3D_NOPT_type = {
 _GEANT_DRAWING_MOVE3D_NOPT_text, (int*)0, (int*)0 };
static KmParameter _GEANT_DRAWING_MOVE3D_NOPT = { "NOPT", 4,
 "T=tracks,H=hits", "    ", (char*)0, 8, 2, _GEANT_DRAWING_MOVE3D_NOPT_range,
 2, _GEANT_DRAWING_MOVE3D_NOPT_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_DRAWING_MOVE3D_NOPT_type };
static KmParameter *_GEANT_DRAWING_MOVE3D_parameters[] = {
 &_GEANT_DRAWING_MOVE3D_NAME, &_GEANT_DRAWING_MOVE3D_THETA,
 &_GEANT_DRAWING_MOVE3D_PHI, &_GEANT_DRAWING_MOVE3D_PSI,
 &_GEANT_DRAWING_MOVE3D_U0, &_GEANT_DRAWING_MOVE3D_V0,
 &_GEANT_DRAWING_MOVE3D_SU, &_GEANT_DRAWING_MOVE3D_SV,
 &_GEANT_DRAWING_MOVE3D_SZ, &_GEANT_DRAWING_MOVE3D_NOPT };
static char *_GEANT_DRAWING_MOVE3D_guidance[] = {
 "Same functionality of the command MOVE interfaced with MOTIF." };
static KmCommand _GEANT_DRAWING_MOVE3D = { &_GEANT_DRAWING_PERSP,
 "/GEANT/DRAWING/MOVE3D", "MOVE3D", 0, 2, 10, 1,
 _GEANT_DRAWING_MOVE3D_parameters, 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 1, _GEANT_DRAWING_MOVE3D_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static KmParameter _GEANT_DRAWING_MOVE_NAME = { "NAME", 4, "Volume name",
 "    ", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParameter _GEANT_DRAWING_MOVE_NOPT = { "NOPT", 4,
 "S=sample mode,T=tracks,H=hits", "    ", (char*)0, 20, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_DRAWING_MOVE_parameters[] = {
 &_GEANT_DRAWING_MOVE_NAME, &_GEANT_DRAWING_MOVE_NOPT };
static char *_GEANT_DRAWING_MOVE_guidance[] = {
 "Positioning some daughter volumes inside a 'mother', it can be",
 "important to check if overlaps between such volumes have occurred.",
 "Instead of putting the drawing in a view bank, zooming, and iterating",
 "the process for different viewing angles of the same detector, the",
 "MOVE facility has been developed (for machines running with X11):",
 "it is sufficient to draw a view of the volumes to be analysed (after",
 "setting the proper SEEN, COLO, etc. attributes) and then to enter",
 "'MOVE' followed by the same 'NAME' used for the last command DRAW.",
 "The detector will appear in a panel with five buttons at the",
 "bottom: THETA, PHI, TRASL, ZOOM, OFF. Clicking on the left button",
 "of the mouse, when the cursor is inside the THETA area, will rotate the",
 "detector along the polar angle theta according to the",
 "backward-to-forward movement of the mouse",
 "(clicking up and down the left button if",
 "not in sample mode); clicking on the right button of",
 "the mouse will stop the rotation; clicking now on the",
 "left button of the mouse when inside the PHI area will activate a",
 "rotation along the polar angle phi. In the same way, activating the",
 "TRASL button, the detector can be translated in the u,v plane",
 "of the screen according to the 2D-movement of the mouse. Finally,",
 "activating the ZOOM button, the detector will be zoomed (or unzoomed)",
 "according to the backward-to-forward movement of the mouse. Clicking on\
 the", "OFF button will return the control to the 'command mode'. The MOVE",
 "command will work also with hidden line removal and shading options",
 "(when SHAD is on the background will be black);",
 "moreover, if the volumes are clipped, exploded, shifted, etc., they",
 "will be 'MOVED' with these features as well.",
 "Tracks and hits of a previously stored physical event can be moved",
 "together with the detector, allowing a dynamical 3-D analysis of the",
 "simulated events. Clicking the central button of the mouse when a good",
 "view of the event is found, will stop any movement and the mouse will",
 "allow the normal picking capabilities first for the tracks and then for",
 "the hits. After clicking of the right button, the normal",
 "movement will restart to find another interesting view of the event",
 "and to iterate the process.", "The MOVE is also available in sample mode.",
 "The following commands will produce a drawing of a volume",
 "and then will give the control to the MOVE panel; try the following",
 "possibilities:", " EXAMPLE 1 -", " dopt hide off", " satt * seen -2",
 " draw NAME 40 40 0 10 10 .01 .01", " move NAME", " EXAMPLE 2 -",
 " dopt hide on", " satt * seen -2", " draw NAME 40 40 0 10 10 .01 .01",
 " move NAME", " EXAMPLE 3 -", " dopt shad on", " satt * colo 3",
 " satt * fill 2", " dopt edge off", " draw NAME 40 40 0 10 10 .01 .01",
 " move NAME" };
static KmCommand _GEANT_DRAWING_MOVE = { &_GEANT_DRAWING_MOVE3D,
 "/GEANT/DRAWING/MOVE", "MOVE", 0, 2, 2, 1, _GEANT_DRAWING_MOVE_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 56,
 _GEANT_DRAWING_MOVE_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_DRAWING_PICK_guidance[] = {
 "Activates graphic input to identify detector elements",
 "in a cut view. Clicking on the left button of the mouse when",
 "the cursor is in a given point of the drawing and clicking again",
 "(outside the detector) will produce the following effect:",
 "a line joininig the two points will be drawn together with",
 "the name and the medium number of the volume picked",
 "with the first clicking close to the second point." };
static KmCommand _GEANT_DRAWING_PICK = { &_GEANT_DRAWING_MOVE,
 "/GEANT/DRAWING/PICK", "PICK", 0, 2, 0, 0, (KmParameter**)0, 0, 0, gxpick_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 7, _GEANT_DRAWING_PICK_guidance,
 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_DRAWING_MEASURE_guidance[] = {
 "Position the cursor on the first point (u1,v1) and hit the space bar(GKS).",
 "Position the cursor on the second point (u2,v2) and hit the space\
 bar(GKS).",
 "Clicking the left button of the mouse (X11) will have the same effect as",
 "hiting the space bar (GKS).",
 "The command will compute and print the distance in space separating",
 "the two points on the projection view. It can be useful to measure",
 "distances either between volumes or between tracks or hits." };
static KmCommand _GEANT_DRAWING_MEASURE = { &_GEANT_DRAWING_PICK,
 "/GEANT/DRAWING/MEASURE", "MEASURE", 0, 2, 0, 0, (KmParameter**)0, 0, 0,
 gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 7,
 _GEANT_DRAWING_MEASURE_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DRAWING_DHEAD_ISEL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DHEAD_ISEL = { "ISEL", 4, "Option flag",
 "111110", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_DHEAD_ISEL_type };
static KmParameter _GEANT_DRAWING_DHEAD_NAME = { "NAME", 4, "Title", " ",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParReal   _GEANT_DRAWING_DHEAD_CHRSIZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DHEAD_CHRSIZ = { "CHRSIZ", 6,
 "Character size (cm) of title NAME", "0.6", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DHEAD_CHRSIZ_type };
static KmParameter *_GEANT_DRAWING_DHEAD_parameters[] = {
 &_GEANT_DRAWING_DHEAD_ISEL, &_GEANT_DRAWING_DHEAD_NAME,
 &_GEANT_DRAWING_DHEAD_CHRSIZ };
static char *_GEANT_DRAWING_DHEAD_guidance[] = {
 " CALL GDHEAD(isel,name,chrsiz)", "ISEL =",
 " 0      to have only the header lines",
 " xxxxx1 to add the text name centered on top of header",
 " xxxx1x to add global detector name (first volume) on left",
 " xxx1xx to add date on right",
 " xx1xxx to select thick characters for text on top of header",
 " x1xxxx to add the text 'EVENT NR x' on top of header",
 " 1xxxxx to add the text 'RUN NR x' on top of header",
 "NOTE that ISEL=x1xxx1 or ISEL=1xxxx1 are illegal choices,",
 "i.e. they generate overwritten text.", "NAME is the title",
 "and CHRSIZ the character size in cm of text name." };
static KmCommand _GEANT_DRAWING_DHEAD = { &_GEANT_DRAWING_MEASURE,
 "/GEANT/DRAWING/DHEAD", "DHEAD", 0, 2, 3, 0, _GEANT_DRAWING_DHEAD_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 13,
 _GEANT_DRAWING_DHEAD_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_DMAN_U_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DMAN_U = { "U", 1,
 "U-coord. (horizontal) of the centre of man", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DMAN_U_type };
static KmParReal   _GEANT_DRAWING_DMAN_V_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DMAN_V = { "V", 1,
 "V-coord. (vertical) of the centre of man", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DMAN_V_type };
static char *_GEANT_DRAWING_DMAN_TYPE_range[] = { "MAN", "WM1", "WM2", "WM3" };
static char *_GEANT_DRAWING_DMAN_TYPE_text[] = { (char*)0, (char*)0, (char*)0,
 (char*)0 };
static KmParOption _GEANT_DRAWING_DMAN_TYPE_type = {
 _GEANT_DRAWING_DMAN_TYPE_text, (int*)0, (int*)0 };
static KmParameter _GEANT_DRAWING_DMAN_TYPE = { "TYPE", 4,
 "Man, Wm1, Wm2, Wm3", "MAN", (char*)0, 8, 4, _GEANT_DRAWING_DMAN_TYPE_range,
 4, _GEANT_DRAWING_DMAN_TYPE_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_DRAWING_DMAN_TYPE_type };
static KmParameter *_GEANT_DRAWING_DMAN_parameters[] = {
 &_GEANT_DRAWING_DMAN_U, &_GEANT_DRAWING_DMAN_V, &_GEANT_DRAWING_DMAN_TYPE };
static char *_GEANT_DRAWING_DMAN_guidance[] = {
 " CALL GDMAN(u,v),CALL GDWMN1(u,v),CALL GDWMN2(u,v),CALL GDWMN2(u,v)",
 "It superimposes the picure of a man or of a woman, chosen among",
 "three different ones, with the same scale factors as the detector",
 "in the current drawing." };
static KmCommand _GEANT_DRAWING_DMAN = { &_GEANT_DRAWING_DHEAD,
 "/GEANT/DRAWING/DMAN", "DMAN", 0, 2, 3, 3, _GEANT_DRAWING_DMAN_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_DRAWING_DMAN_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_DAXIS_X0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DAXIS_X0 = { "X0", 2,
 "X-coord. of axis origin", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DAXIS_X0_type };
static KmParReal   _GEANT_DRAWING_DAXIS_Y0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DAXIS_Y0 = { "Y0", 2,
 "Y-coord. of axis origin", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DAXIS_Y0_type };
static KmParReal   _GEANT_DRAWING_DAXIS_Z0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DAXIS_Z0 = { "Z0", 2,
 "Z-coord. of axis origin", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DAXIS_Z0_type };
static KmParReal   _GEANT_DRAWING_DAXIS_DX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DAXIS_DX = { "DX", 2, "Axis size", (char*)0,
 (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DAXIS_DX_type };
static KmParameter *_GEANT_DRAWING_DAXIS_parameters[] = {
 &_GEANT_DRAWING_DAXIS_X0, &_GEANT_DRAWING_DAXIS_Y0, &_GEANT_DRAWING_DAXIS_Z0,
 &_GEANT_DRAWING_DAXIS_DX };
static char *_GEANT_DRAWING_DAXIS_guidance[] = { " CALL GDAXIS(x0,y0,z0,dx)",
 "This commmand superimposes the axis of the MARS on the",
 "current picture. It is useful for finding immediately the",
 "orientation of the current drawing of the detector in the space." };
static KmCommand _GEANT_DRAWING_DAXIS = { &_GEANT_DRAWING_DMAN,
 "/GEANT/DRAWING/DAXIS", "DAXIS", 0, 2, 4, 4, _GEANT_DRAWING_DAXIS_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_DRAWING_DAXIS_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_DSCALE_U_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DSCALE_U = { "U", 1,
 "U-coord. (horizontal) of the centre of scale", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DSCALE_U_type };
static KmParReal   _GEANT_DRAWING_DSCALE_V_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DSCALE_V = { "V", 1,
 "V-coord. (vertical) of the centre of scale", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DSCALE_V_type };
static KmParameter *_GEANT_DRAWING_DSCALE_parameters[] = {
 &_GEANT_DRAWING_DSCALE_U, &_GEANT_DRAWING_DSCALE_V };
static char *_GEANT_DRAWING_DSCALE_guidance[] = { " CALL GDSCAL(u,v)",
 "It draws a scale centered in U,V." };
static KmCommand _GEANT_DRAWING_DSCALE = { &_GEANT_DRAWING_DAXIS,
 "/GEANT/DRAWING/DSCALE", "DSCALE", 0, 2, 2, 2,
 _GEANT_DRAWING_DSCALE_parameters, 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 2, _GEANT_DRAWING_DSCALE_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static KmParameter _GEANT_DRAWING_DVECTOR_XVECT = { "XVECT", 5,
 "Vector containing X-coord. (horizontal)", (char*)0, (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_DRAWING_DVECTOR_YVECT = { "YVECT", 5,
 "Vector containing Y-coord. (vertical)", (char*)0, (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_DRAWING_DVECTOR_NPOINT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DVECTOR_NPOINT = { "NPOINT", 6,
 "Number of coord.", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_DVECTOR_NPOINT_type };
static KmParameter *_GEANT_DRAWING_DVECTOR_parameters[] = {
 &_GEANT_DRAWING_DVECTOR_XVECT, &_GEANT_DRAWING_DVECTOR_YVECT,
 &_GEANT_DRAWING_DVECTOR_NPOINT };
static char *_GEANT_DRAWING_DVECTOR_guidance[] = {
 "Draw a polyline of 'npoint' point via",
 "a call to GDRAWV(xvect,yvect,npoint)",
 "where xvect and yvect are two KUIP vectors" };
static KmCommand _GEANT_DRAWING_DVECTOR = { &_GEANT_DRAWING_DSCALE,
 "/GEANT/DRAWING/DVECTOR", "DVECTOR", 0, 2, 3, 3,
 _GEANT_DRAWING_DVECTOR_parameters, 0, 0, gxdraw_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_DRAWING_DVECTOR_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_DTEXT_X0_type = { "0.", "20.", "0.", "20.",
 0 };
static KmParameter _GEANT_DRAWING_DTEXT_X0 = { "X0", 2,
 "X-coord. (horizontal) of text string", "10.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DTEXT_X0_type };
static KmParReal   _GEANT_DRAWING_DTEXT_Y0_type = { "0.", "20.", "0.", "20.",
 0 };
static KmParameter _GEANT_DRAWING_DTEXT_Y0 = { "Y0", 2,
 "Y-coord. (vertical) of text string", "10.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DTEXT_Y0_type };
static KmParameter _GEANT_DRAWING_DTEXT_TEXT = { "TEXT", 4, "Text string",
 "GEANT", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
  (void*)0 };
static KmParReal   _GEANT_DRAWING_DTEXT_SIZE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DTEXT_SIZE = { "SIZE", 4,
 "Character size (cm)", ".5", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DTEXT_SIZE_type };
static KmParReal   _GEANT_DRAWING_DTEXT_ANGLE_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DTEXT_ANGLE = { "ANGLE", 5,
 "Rotation angle (deg)", "0.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DTEXT_ANGLE_type };
static KmParInt    _GEANT_DRAWING_DTEXT_LWID_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DTEXT_LWID = { "LWID", 4, "Line width", "4",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_DTEXT_LWID_type };
static char *_GEANT_DRAWING_DTEXT_CENT_range[] = { "CENT", "LEFT", "RIGH" };
static char *_GEANT_DRAWING_DTEXT_CENT_text[] = { (char*)0, (char*)0, (char*)0
 };
static KmParOption _GEANT_DRAWING_DTEXT_CENT_type = {
 _GEANT_DRAWING_DTEXT_CENT_text, (int*)0, (int*)0 };
static KmParameter _GEANT_DRAWING_DTEXT_CENT = { "CENT", 4,
 "Centering option", "CENT", (char*)0, 8, 3, _GEANT_DRAWING_DTEXT_CENT_range,
 3, _GEANT_DRAWING_DTEXT_CENT_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_DRAWING_DTEXT_CENT_type };
static KmParameter *_GEANT_DRAWING_DTEXT_parameters[] = {
 &_GEANT_DRAWING_DTEXT_X0, &_GEANT_DRAWING_DTEXT_Y0,
 &_GEANT_DRAWING_DTEXT_TEXT, &_GEANT_DRAWING_DTEXT_SIZE,
 &_GEANT_DRAWING_DTEXT_ANGLE, &_GEANT_DRAWING_DTEXT_LWID,
 &_GEANT_DRAWING_DTEXT_CENT };
static char *_GEANT_DRAWING_DTEXT_guidance[] = {
 " CALL GDRAWT(x0,y0,text,size,angle,lwid,opt)",
 "It allows one to draw some text in the current picture.",
 "Now more than 160 colours are available. The text colour",
 "must be set via the command IGSET. The size of the",
 "text will follow the zooming factors in the view banks." };
static KmCommand _GEANT_DRAWING_DTEXT = { &_GEANT_DRAWING_DVECTOR,
 "/GEANT/DRAWING/DTEXT", "DTEXT", 0, 2, 7, 7, _GEANT_DRAWING_DTEXT_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 5,
 _GEANT_DRAWING_DTEXT_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DFSPC_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static char *_GEANT_DRAWING_DFSPC_CSORT_range[] = { "Y", "N", "0", "1" };
static char *_GEANT_DRAWING_DFSPC_CSORT_text[] = { (char*)0, (char*)0,
 (char*)0, (char*)0 };
static KmParOption _GEANT_DRAWING_DFSPC_CSORT_type = {
 _GEANT_DRAWING_DFSPC_CSORT_text, (int*)0, (int*)0 };
static KmParameter _GEANT_DRAWING_DFSPC_CSORT = { "CSORT", 5,
 "Alphabetic sorting flag", "N", (char*)0, 8, 4,
 _GEANT_DRAWING_DFSPC_CSORT_range, 4, _GEANT_DRAWING_DFSPC_CSORT_range,
 (KmParFlag)0, KmTYPE_OPTION, &_GEANT_DRAWING_DFSPC_CSORT_type };
static char *_GEANT_DRAWING_DFSPC_CINTER_range[] = { "I", "B", "0", "1" };
static char *_GEANT_DRAWING_DFSPC_CINTER_text[] = { (char*)0, (char*)0,
 (char*)0, (char*)0 };
static KmParOption _GEANT_DRAWING_DFSPC_CINTER_type = {
 _GEANT_DRAWING_DFSPC_CINTER_text, (int*)0, (int*)0 };
static KmParameter _GEANT_DRAWING_DFSPC_CINTER = { "CINTER", 6,
 "Interactive/Batch version", "I", (char*)0, 8, 4,
 _GEANT_DRAWING_DFSPC_CINTER_range, 4, _GEANT_DRAWING_DFSPC_CINTER_range,
 (KmParFlag)0, KmTYPE_OPTION, &_GEANT_DRAWING_DFSPC_CINTER_type };
static KmParameter *_GEANT_DRAWING_DFSPC_parameters[] = {
 &_GEANT_DRAWING_DFSPC_NAME, &_GEANT_DRAWING_DFSPC_CSORT,
 &_GEANT_DRAWING_DFSPC_CINTER };
static char *_GEANT_DRAWING_DFSPC_guidance[] = {
 " CALL GDFSPC(name,isort,inter)",
 "Same as DSPEC, but it will draw the specifications for all the volumes.",
 "If the alphabetic sorting flag is YES, all pictures will be drawn in\
 ascending", "alphabetic order; isort is set to 1.",
 "If INTERACTIVE, (inter=1), the routine will prompt the user at each plot",
 "before doing a clear screen, otherwise it will clear automatically",
 "the screen before starting a new frame." };
static KmCommand _GEANT_DRAWING_DFSPC = { &_GEANT_DRAWING_DTEXT,
 "/GEANT/DRAWING/DFSPC", "DFSPC", 0, 2, 3, 1, _GEANT_DRAWING_DFSPC_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 7,
 _GEANT_DRAWING_DFSPC_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_D3DSPEC_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_DRAWING_D3DSPEC_TETA3_type = { "0.", "180.", "0.",
 "180.", 0 };
static KmParameter _GEANT_DRAWING_D3DSPEC_TETA3 = { "TETA3", 5, "Theta angle",
 "40.", (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_D3DSPEC_TETA3_type };
static KmParReal   _GEANT_DRAWING_D3DSPEC_PHI3_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_D3DSPEC_PHI3 = { "PHI3", 4, "Phi angle",
 "40.", (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_D3DSPEC_PHI3_type };
static KmParReal   _GEANT_DRAWING_D3DSPEC_PSI3_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_D3DSPEC_PSI3 = { "PSI3", 4, "Psi angle",
 "0.", (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_D3DSPEC_PSI3_type };
static KmParReal   _GEANT_DRAWING_D3DSPEC_U03_type = { "-40.", "40.", "-40.",
 "40.", 0 };
static KmParameter _GEANT_DRAWING_D3DSPEC_U03 = { "U03", 3,
 "U-coord. (horizontal) of volume origin", "10.", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_D3DSPEC_U03_type };
static KmParReal   _GEANT_DRAWING_D3DSPEC_V03_type = { "-40.", "40.", "-40.",
 "40.", 0 };
static KmParameter _GEANT_DRAWING_D3DSPEC_V03 = { "V03", 3,
 "V-coord. (vertical) of volume origin", "10.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_D3DSPEC_V03_type };
static KmParReal   _GEANT_DRAWING_D3DSPEC_ZM3_type = { "0.00001", "10.",
 "0.00001", "10.", 5 };
static KmParameter _GEANT_DRAWING_D3DSPEC_ZM3 = { "ZM3", 3,
 "Zoom factor for current size factors", "1.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_D3DSPEC_ZM3_type };
static KmParameter *_GEANT_DRAWING_D3DSPEC_parameters[] = {
 &_GEANT_DRAWING_D3DSPEC_NAME, &_GEANT_DRAWING_D3DSPEC_TETA3,
 &_GEANT_DRAWING_D3DSPEC_PHI3, &_GEANT_DRAWING_D3DSPEC_PSI3,
 &_GEANT_DRAWING_D3DSPEC_U03, &_GEANT_DRAWING_D3DSPEC_V03,
 &_GEANT_DRAWING_D3DSPEC_ZM3 };
static char *_GEANT_DRAWING_D3DSPEC_guidance[] = {
 "Trough a call to GSPE3D, this command allows one to show",
 "the volume (3D views in real time), together with",
 "its geometrical specifications (if using MOTIF). The 3D drawing will",
 "be performed according the current values of the options HIDE and",
 "SHAD and according the current CVOL clipping parameters for that", "volume."
 };
static KmCommand _GEANT_DRAWING_D3DSPEC = { &_GEANT_DRAWING_DFSPC,
 "/GEANT/DRAWING/D3DSPEC", "D3DSPEC", 0, 2, 7, 1,
 _GEANT_DRAWING_D3DSPEC_parameters, 0, 0, gxdraw_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 6, _GEANT_DRAWING_D3DSPEC_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DSPEC_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_DRAWING_DSPEC_parameters[] = {
 &_GEANT_DRAWING_DSPEC_NAME };
static char *_GEANT_DRAWING_DSPEC_guidance[] = {
 "Trough a call to GDSPEC(name), this command allows one to show three",
 "views of the volume (two cut-views and a 3D view), together with",
 "its geometrical specifications. The 3D drawing will",
 "be performed according the current values of the options HIDE and",
 "SHAD and according the current CVOL clipping parameters for that", "volume."
 };
static KmCommand _GEANT_DRAWING_DSPEC = { &_GEANT_DRAWING_D3DSPEC,
 "/GEANT/DRAWING/DSPEC", "DSPEC", 0, 2, 1, 1, _GEANT_DRAWING_DSPEC_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 6,
 _GEANT_DRAWING_DSPEC_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DTREE_NAME = { "NAME", 4, "Volume name",
 " ", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParInt    _GEANT_DRAWING_DTREE_LEVMAX_type = { "-15", "15", "-15",
 "15", 0 };
static KmParameter _GEANT_DRAWING_DTREE_LEVMAX = { "LEVMAX", 6, "Depth level",
 "3", (char*)0, 3, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_DTREE_LEVMAX_type };
static KmParInt    _GEANT_DRAWING_DTREE_ISELT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DTREE_ISELT = { "ISELT", 5, "Options    ",
 "111", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_DTREE_ISELT_type };
static KmParameter *_GEANT_DRAWING_DTREE_parameters[] = {
 &_GEANT_DRAWING_DTREE_NAME, &_GEANT_DRAWING_DTREE_LEVMAX,
 &_GEANT_DRAWING_DTREE_ISELT };
static char *_GEANT_DRAWING_DTREE_guidance[] = {
 "This command allows the drawing of the logical tree,",
 "displaying the name, the multiplicity and other information about the\
 volumes,", "via a call to GDTREE(name,levmax,isel):",
 "if the third parameter is not given (default), the command will",
 "produce the drawing of the tree displaying, for each volume, the",
 "number of the following levels (red arrows) and of the preceeding",
 "levels (green arrows); then the control is automatically given to the",
 "mouse: clicking on the left button when the cursor is inside a volume's",
 "pave will perform a DSPEC for that volume; doing the same when the cursor",
 "is on a red arrow, will perform a DTREE for the relative volume (the",
 "number of levels displayed depending on the clicked arrow); doing the",
 "same for the 'i-th' green arrow of a given volume, will perform a DTREE",
 "for its mother-volume staying 'i' levels before.",
 "If running with X-windows, the drawing of the specification (DSPEC)",
 "is performed",
 "in a different window to speed up the scanning of the tree.",
 "Iterating this procedure it is possible to analyse very easily and quickly",
 "any kind of tree. Clicking the right button of the mouse will return",
 "the control to the command mode.", "If the ISELT parameter is given,",
 "then the TREE will work as in the",
 "previous version, with ISELT up to 10001.",
 "The following command will perform a drawing of the tree and give the",
 "control to the user via the mouse:", " EXAMPLE -", " dtree NAME 3" };
static KmCommand _GEANT_DRAWING_DTREE = { &_GEANT_DRAWING_DSPEC,
 "/GEANT/DRAWING/DTREE", "DTREE", 0, 2, 3, 0, _GEANT_DRAWING_DTREE_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 26,
 _GEANT_DRAWING_DTREE_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_BOMB_BOOM_type = { "-10.", "10.", "-10.",
 "10.", 0 };
static KmParameter _GEANT_DRAWING_BOMB_BOOM = { "BOOM", 4,
 " Exploding factor for volumes position ", "0.", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_BOMB_BOOM_type };
static KmParameter *_GEANT_DRAWING_BOMB_parameters[] = {
 &_GEANT_DRAWING_BOMB_BOOM };
static char *_GEANT_DRAWING_BOMB_guidance[] = {
 "To 'explode' the detector. If BOOM is positive (values smaller",
 "than 1. are suggested, but any value is possible)",
 "all the volumes are shifted by a distance",
 "proportional to BOOM along the direction between their centre",
 "and the origin of the MARS; the volumes which are symmetric",
 "with respect to this origin are simply not shown.",
 "BOOM equal to 0 resets the normal mode.",
 "A negative (greater than -1.) value of",
 "BOOM will cause an 'implosion'; for even lower values of BOOM",
 "the volumes' positions will be reflected respect to the origin.",
 "This command can be useful to improve the 3D effect for very",
 "complex detectors. The following commands will make explode the",
 "detector:", " EXAMPLE -", " dopt hide on", " satt * seen 1",
 " draw NAME 40 40 0 10 10 .01 .01", " bomb 1", " next",
 " draw NAME 40 40 0 10 10 .01 .01" };
static KmCommand _GEANT_DRAWING_BOMB = { &_GEANT_DRAWING_DTREE,
 "/GEANT/DRAWING/BOMB", "BOMB", 0, 2, 1, 1, _GEANT_DRAWING_BOMB_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 20,
 _GEANT_DRAWING_BOMB_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_SHIFT_CNVN = { "CNVN", 4,
 " Name of volume to be shifted        ", "*", (char*)0, 20, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_DRAWING_SHIFT_XXXX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_SHIFT_XXXX = { "XXXX", 4,
 " Shift along X axis                  ", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_SHIFT_XXXX_type };
static KmParReal   _GEANT_DRAWING_SHIFT_YYYY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_SHIFT_YYYY = { "YYYY", 4,
 " Shift along Y axis                  ", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_SHIFT_YYYY_type };
static KmParReal   _GEANT_DRAWING_SHIFT_ZZZZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_SHIFT_ZZZZ = { "ZZZZ", 4,
 " Shift along Z axis                  ", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_SHIFT_ZZZZ_type };
static KmParameter *_GEANT_DRAWING_SHIFT_parameters[] = {
 &_GEANT_DRAWING_SHIFT_CNVN, &_GEANT_DRAWING_SHIFT_XXXX,
 &_GEANT_DRAWING_SHIFT_YYYY, &_GEANT_DRAWING_SHIFT_ZZZZ };
static char *_GEANT_DRAWING_SHIFT_guidance[] = {
 "To draw a volume shifted from its initial position when hidden",
 "line removal is ON. It can be useful if you want to extract a",
 "volume or some volumes from the detector to show them more clearly.",
 "The last requested SHIFT for each volume",
 "NAME is performed. Moreover, the SHIFT of",
 "each volume will be performed starting from where its mother has",
 "been shifted, so that it's easier to SHIFT nicely sets",
 "of volumes using the mother-daughter relationships.",
 "If '.' is given as the name of the volume",
 "to be shifted, the shifts for all volumes will be reset.",
 "The following commands will produce the translation along",
 "the Z-axis of the previously drawn volume:", " EXAMPLE -", " dopt hide on",
 " satt * seen -2", " draw NAME 40 40 0 10 10 .01 .01", " shift NAME 0 0 10" };
static KmCommand _GEANT_DRAWING_SHIFT = { &_GEANT_DRAWING_BOMB,
 "/GEANT/DRAWING/SHIFT", "SHIFT", 0, 2, 4, 4, _GEANT_DRAWING_SHIFT_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 17,
 _GEANT_DRAWING_SHIFT_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DXCUT_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_DRAWING_DXCUT_CUTTHE_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DXCUT_CUTTHE = { "CUTTHE", 6,
 "Theta angle of the line normal to cut plane", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DXCUT_CUTTHE_type };
static KmParReal   _GEANT_DRAWING_DXCUT_CUTPHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DXCUT_CUTPHI = { "CUTPHI", 6,
 "Phi angle of the line normal to cut plane", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DXCUT_CUTPHI_type };
static KmParReal   _GEANT_DRAWING_DXCUT_CUTVAL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DXCUT_CUTVAL = { "CUTVAL", 6,
 "Cut plane distance from the origin along the axis", (char*)0, (char*)0, 12,
 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DXCUT_CUTVAL_type };
static KmParReal   _GEANT_DRAWING_DXCUT_THETA_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DXCUT_THETA = { "THETA", 5,
 "Viewing angle theta (for 3D projection)", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DXCUT_THETA_type };
static KmParReal   _GEANT_DRAWING_DXCUT_PHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DXCUT_PHI = { "PHI", 3,
 "Viewing angle phi (for 3D projection)", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DXCUT_PHI_type };
static KmParReal   _GEANT_DRAWING_DXCUT_U0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DXCUT_U0 = { "U0", 2,
 "U-coord. (horizontal) of volume origin", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DXCUT_U0_type };
static KmParReal   _GEANT_DRAWING_DXCUT_V0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DXCUT_V0 = { "V0", 2,
 "V-coord. (vertical) of volume origin", (char*)0, (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DXCUT_V0_type };
static KmParReal   _GEANT_DRAWING_DXCUT_SU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DXCUT_SU = { "SU", 2,
 "Scale factor for U-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DXCUT_SU_type };
static KmParReal   _GEANT_DRAWING_DXCUT_SV_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DXCUT_SV = { "SV", 2,
 "Scale factor for V-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DXCUT_SV_type };
static KmParameter *_GEANT_DRAWING_DXCUT_parameters[] = {
 &_GEANT_DRAWING_DXCUT_NAME, &_GEANT_DRAWING_DXCUT_CUTTHE,
 &_GEANT_DRAWING_DXCUT_CUTPHI, &_GEANT_DRAWING_DXCUT_CUTVAL,
 &_GEANT_DRAWING_DXCUT_THETA, &_GEANT_DRAWING_DXCUT_PHI,
 &_GEANT_DRAWING_DXCUT_U0, &_GEANT_DRAWING_DXCUT_V0, &_GEANT_DRAWING_DXCUT_SU,
 &_GEANT_DRAWING_DXCUT_SV };
static char *_GEANT_DRAWING_DXCUT_guidance[] = {
 " CALL GDRAWX(name,cutthe,cutphi,cutval,theta,phi,u0,v0,su,sv)",
 "The cut plane is normal to the line given by the cut angles",
 "cutthe and cutphi and placed at the distance cutval from the origin.",
 "The resulting picture is seen from the viewing angles theta,phi.",
 "If optional parameters are missing, the current values in /GCDRAW/",
 "are taken." };
static KmCommand _GEANT_DRAWING_DXCUT = { &_GEANT_DRAWING_SHIFT,
 "/GEANT/DRAWING/DXCUT", "DXCUT", 0, 2, 10, 4,
 _GEANT_DRAWING_DXCUT_parameters, 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 6, _GEANT_DRAWING_DXCUT_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static KmParameter _GEANT_DRAWING_DCUT_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static char *_GEANT_DRAWING_DCUT_CAXIS_range[] = { "X", "Y", "Z" };
static char *_GEANT_DRAWING_DCUT_CAXIS_text[] = { (char*)0, (char*)0, (char*)0
 };
static KmParOption _GEANT_DRAWING_DCUT_CAXIS_type = {
 _GEANT_DRAWING_DCUT_CAXIS_text, (int*)0, (int*)0 };
static KmParameter _GEANT_DRAWING_DCUT_CAXIS = { "CAXIS", 5, "Axis value",
 (char*)0, (char*)0, 8, 3, _GEANT_DRAWING_DCUT_CAXIS_range, 3,
 _GEANT_DRAWING_DCUT_CAXIS_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_DRAWING_DCUT_CAXIS_type };
static KmParReal   _GEANT_DRAWING_DCUT_CUTVAL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCUT_CUTVAL = { "CUTVAL", 6,
 "Cut plane distance from the origin along the axis", (char*)0, (char*)0, 12,
 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DCUT_CUTVAL_type };
static KmParReal   _GEANT_DRAWING_DCUT_U0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCUT_U0 = { "U0", 2,
 "U-coord. (horizontal) of volume origin", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DCUT_U0_type };
static KmParReal   _GEANT_DRAWING_DCUT_V0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCUT_V0 = { "V0", 2,
 "V-coord. (vertical) of volume origin", (char*)0, (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DCUT_V0_type };
static KmParReal   _GEANT_DRAWING_DCUT_SU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCUT_SU = { "SU", 2,
 "Scale factor for U-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DCUT_SU_type };
static KmParReal   _GEANT_DRAWING_DCUT_SV_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DCUT_SV = { "SV", 2,
 "Scale factor for V-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DCUT_SV_type };
static KmParameter *_GEANT_DRAWING_DCUT_parameters[] = {
 &_GEANT_DRAWING_DCUT_NAME, &_GEANT_DRAWING_DCUT_CAXIS,
 &_GEANT_DRAWING_DCUT_CUTVAL, &_GEANT_DRAWING_DCUT_U0,
 &_GEANT_DRAWING_DCUT_V0, &_GEANT_DRAWING_DCUT_SU, &_GEANT_DRAWING_DCUT_SV };
static char *_GEANT_DRAWING_DCUT_guidance[] = {
 " CALL GDRAWC(name,iaxis,cutval,u0,v0,su,sv)",
 "The cut plane is normal to caxis (X,Y,Z), corresponding to iaxis (1,2,3),",
 "and placed at the distance cutval from the origin.",
 "The resulting picture is seen from the the same axis.",
 "If optional parameters are missing, the current values in /GCDRAW/",
 "are taken.",
 "When HIDE Mode is ON, it is possible to get the same effect with",
 "the CVOL/BOX command." };
static KmCommand _GEANT_DRAWING_DCUT = { &_GEANT_DRAWING_DXCUT,
 "/GEANT/DRAWING/DCUT", "DCUT", 0, 2, 7, 3, _GEANT_DRAWING_DCUT_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 8,
 _GEANT_DRAWING_DCUT_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DRAWING_DVOLUME_N_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DVOLUME_N = { "N", 1,
 "Number of elements in arrays LNAMES and LNUMBS", "1", (char*)0, 8, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DRAWING_DVOLUME_N_type };
static KmParameter _GEANT_DRAWING_DVOLUME_NAMNUM = { "NAMNUM", 6,
 "Volume names and numbers (ex. \"NAME1,NR1,NAME2,NR2\")", (char*)0, (char*)0,
 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static char *_GEANT_DRAWING_DVOLUME_CHNRS_range[] = { "MARS", "DRS" };
static char *_GEANT_DRAWING_DVOLUME_CHNRS_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_DRAWING_DVOLUME_CHNRS_type = {
 _GEANT_DRAWING_DVOLUME_CHNRS_text, (int*)0, (int*)0 };
static KmParameter _GEANT_DRAWING_DVOLUME_CHNRS = { "CHNRS", 5,
 "Reference system used", "MARS", (char*)0, 8, 2,
 _GEANT_DRAWING_DVOLUME_CHNRS_range, 2, _GEANT_DRAWING_DVOLUME_CHNRS_range,
 (KmParFlag)0, KmTYPE_OPTION, &_GEANT_DRAWING_DVOLUME_CHNRS_type };
static KmParReal   _GEANT_DRAWING_DVOLUME_THETA_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DVOLUME_THETA = { "THETA", 5,
 "Viewing angle theta (for 3D projection)", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DVOLUME_THETA_type };
static KmParReal   _GEANT_DRAWING_DVOLUME_PHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DVOLUME_PHI = { "PHI", 3,
 "Viewing angle phi (for 3D projection)", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DVOLUME_PHI_type };
static KmParReal   _GEANT_DRAWING_DVOLUME_PSI_type = { "0.", "180.", "0.",
 "180.", 0 };
static KmParameter _GEANT_DRAWING_DVOLUME_PSI = { "PSI", 3,
 "Viewing angle psi (for 2D rotation)", (char*)0, (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DVOLUME_PSI_type };
static KmParReal   _GEANT_DRAWING_DVOLUME_U0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DVOLUME_U0 = { "U0", 2,
 "U-coord. (horizontal) of volume origin", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DVOLUME_U0_type };
static KmParReal   _GEANT_DRAWING_DVOLUME_V0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DVOLUME_V0 = { "V0", 2,
 "V-coord. (vertical) of volume origin", (char*)0, (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DVOLUME_V0_type };
static KmParReal   _GEANT_DRAWING_DVOLUME_SU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DVOLUME_SU = { "SU", 2,
 "Scale factor for U-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DVOLUME_SU_type };
static KmParReal   _GEANT_DRAWING_DVOLUME_SV_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DVOLUME_SV = { "SV", 2,
 "Scale factor for V-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DVOLUME_SV_type };
static KmParameter *_GEANT_DRAWING_DVOLUME_parameters[] = {
 &_GEANT_DRAWING_DVOLUME_N, &_GEANT_DRAWING_DVOLUME_NAMNUM,
 &_GEANT_DRAWING_DVOLUME_CHNRS, &_GEANT_DRAWING_DVOLUME_THETA,
 &_GEANT_DRAWING_DVOLUME_PHI, &_GEANT_DRAWING_DVOLUME_PSI,
 &_GEANT_DRAWING_DVOLUME_U0, &_GEANT_DRAWING_DVOLUME_V0,
 &_GEANT_DRAWING_DVOLUME_SU, &_GEANT_DRAWING_DVOLUME_SV };
static char *_GEANT_DRAWING_DVOLUME_guidance[] = {
 " CALL GDRVOL(n,lnames,lnumbs,nrs,theta,phi,psi,u0,v0,su,sv)",
 "N is the number of levels from the top of the geometry structure",
 "to the volume lnames(n),lnumbs(n) to be drawn.",
 "NAMNUM contain the arrays lnames and lnumbs,",
 "identifying the path, in pairs and separated by commas; for",
 "example (with n=2) :", "'lname(1),lnumbs(1),lname(2),lnumbs(2) '",
 "CHNRS is the name of the reference system used: MARS for MAster Reference",
 "System or DRS for Daughter Reference System.",
 "NRS=0 for MARS or NRS<>0 for DRS",
 "If optional parameters are missing, the current values in /GCDRAW/",
 "are taken." };
static KmCommand _GEANT_DRAWING_DVOLUME = { &_GEANT_DRAWING_DCUT,
 "/GEANT/DRAWING/DVOLUME", "DVOLUME", 0, 2, 10, 3,
 _GEANT_DRAWING_DVOLUME_parameters, 0, 0, gxdraw_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 12, _GEANT_DRAWING_DVOLUME_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_RANG5D_X1MIN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_RANG5D_X1MIN = { "X1MIN", 5,
 "x coordinate min", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_RANG5D_X1MIN_type };
static KmParReal   _GEANT_DRAWING_RANG5D_X1MAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_RANG5D_X1MAX = { "X1MAX", 5,
 "x coordinate max", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_RANG5D_X1MAX_type };
static KmParReal   _GEANT_DRAWING_RANG5D_Y1MIN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_RANG5D_Y1MIN = { "Y1MIN", 5,
 "y coordinate min", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_RANG5D_Y1MIN_type };
static KmParReal   _GEANT_DRAWING_RANG5D_Y1MAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_RANG5D_Y1MAX = { "Y1MAX", 5,
 "y coordinate max", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_RANG5D_Y1MAX_type };
static KmParReal   _GEANT_DRAWING_RANG5D_Z1MIN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_RANG5D_Z1MIN = { "Z1MIN", 5,
 "z coordinate min", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_RANG5D_Z1MIN_type };
static KmParReal   _GEANT_DRAWING_RANG5D_Z1MAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_RANG5D_Z1MAX = { "Z1MAX", 5,
 "z coordinate max", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_RANG5D_Z1MAX_type };
static KmParameter *_GEANT_DRAWING_RANG5D_parameters[] = {
 &_GEANT_DRAWING_RANG5D_X1MIN, &_GEANT_DRAWING_RANG5D_X1MAX,
 &_GEANT_DRAWING_RANG5D_Y1MIN, &_GEANT_DRAWING_RANG5D_Y1MAX,
 &_GEANT_DRAWING_RANG5D_Z1MIN, &_GEANT_DRAWING_RANG5D_Z1MAX };
static char *_GEANT_DRAWING_RANG5D_guidance[] = {
 "It sets the range for the x,y,z variables." };
static KmCommand _GEANT_DRAWING_RANG5D = { &_GEANT_DRAWING_DVOLUME,
 "/GEANT/DRAWING/RANG5D", "RANG5D", 0, 2, 6, 6,
 _GEANT_DRAWING_RANG5D_parameters, 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 1, _GEANT_DRAWING_RANG5D_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static KmParReal   _GEANT_DRAWING_VAR5D_TSEQTO_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_VAR5D_TSEQTO = { "TSEQTO", 6,
 "total sequential time", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_VAR5D_TSEQTO_type };
static KmParInt    _GEANT_DRAWING_VAR5D_NPROC_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_VAR5D_NPROC = { "NPROC", 5,
 "number of processors", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_VAR5D_NPROC_type };
static KmParInt    _GEANT_DRAWING_VAR5D_NMPTOT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_VAR5D_NMPTOT = { "NMPTOT", 6,
 "number of message passing", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_VAR5D_NMPTOT_type };
static KmParReal   _GEANT_DRAWING_VAR5D_TOTMBY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_VAR5D_TOTMBY = { "TOTMBY", 6,
 "total megabytes transfert", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_VAR5D_TOTMBY_type };
static KmParReal   _GEANT_DRAWING_VAR5D_TSEQ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_VAR5D_TSEQ = { "TSEQ", 4,
 "not parallelized code", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_VAR5D_TSEQ_type };
static KmParReal   _GEANT_DRAWING_VAR5D_TLAT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_VAR5D_TLAT = { "TLAT", 4, "latency time",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_DRAWING_VAR5D_TLAT_type };
static KmParReal   _GEANT_DRAWING_VAR5D_TNET_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_VAR5D_TNET = { "TNET", 4,
 "network speed in Mbytes/sec", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_VAR5D_TNET_type };
static KmParameter *_GEANT_DRAWING_VAR5D_parameters[] = {
 &_GEANT_DRAWING_VAR5D_TSEQTO, &_GEANT_DRAWING_VAR5D_NPROC,
 &_GEANT_DRAWING_VAR5D_NMPTOT, &_GEANT_DRAWING_VAR5D_TOTMBY,
 &_GEANT_DRAWING_VAR5D_TSEQ, &_GEANT_DRAWING_VAR5D_TLAT,
 &_GEANT_DRAWING_VAR5D_TNET };
static char *_GEANT_DRAWING_VAR5D_guidance[] = {
 "It sets the values of the parameters expressed in the formula and",
 "specify which variables must be assumed as x,y,z (setting their value",
 "to 1001,1002,1003, respectively)." };
static KmCommand _GEANT_DRAWING_VAR5D = { &_GEANT_DRAWING_RANG5D,
 "/GEANT/DRAWING/VAR5D", "VAR5D", 0, 2, 7, 7, _GEANT_DRAWING_VAR5D_parameters,
 0, 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_DRAWING_VAR5D_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_DRAWING_SPOT_XLPOS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_SPOT_XLPOS = { "XLPOS", 5,
 "x coordinate of light source", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_SPOT_XLPOS_type };
static KmParReal   _GEANT_DRAWING_SPOT_YLPOS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_SPOT_YLPOS = { "YLPOS", 5,
 "y coordinate of light source", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_SPOT_YLPOS_type };
static KmParReal   _GEANT_DRAWING_SPOT_ZLPOS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_SPOT_ZLPOS = { "ZLPOS", 5,
 "z coordinate of light source", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_SPOT_ZLPOS_type };
static KmParInt    _GEANT_DRAWING_SPOT_INTEN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_SPOT_INTEN = { "INTEN", 5,
 "intensity of light source", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_DRAWING_SPOT_INTEN_type };
static KmParameter *_GEANT_DRAWING_SPOT_parameters[] = {
 &_GEANT_DRAWING_SPOT_XLPOS, &_GEANT_DRAWING_SPOT_YLPOS,
 &_GEANT_DRAWING_SPOT_ZLPOS, &_GEANT_DRAWING_SPOT_INTEN };
static char *_GEANT_DRAWING_SPOT_guidance[] = {
 "This point-like light source can be moved in the space and its intensity",
 "can be changed (INTEN going from 0 to 10) relatively to the ambience light."
 };
static KmCommand _GEANT_DRAWING_SPOT = { &_GEANT_DRAWING_VAR5D,
 "/GEANT/DRAWING/SPOT", "SPOT", 0, 2, 4, 4, _GEANT_DRAWING_SPOT_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_DRAWING_SPOT_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_DRAWING_DRAW_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_DRAWING_DRAW_THETA_type = { "0.", "180.", "0.",
 "180.", 0 };
static KmParameter _GEANT_DRAWING_DRAW_THETA = { "THETA", 5,
 "Viewing angle theta (for 3D projection)", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DRAW_THETA_type };
static KmParReal   _GEANT_DRAWING_DRAW_PHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DRAW_PHI = { "PHI", 3,
 "Viewing angle phi (for 3D projection)", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DRAW_PHI_type };
static KmParReal   _GEANT_DRAWING_DRAW_PSI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_DRAWING_DRAW_PSI = { "PSI", 3,
 "Viewing angle psi (for 2D rotation)", (char*)0, (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DRAW_PSI_type };
static KmParReal   _GEANT_DRAWING_DRAW_U0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DRAW_U0 = { "U0", 2,
 "U-coord. (horizontal) of volume origin", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_DRAWING_DRAW_U0_type };
static KmParReal   _GEANT_DRAWING_DRAW_V0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DRAW_V0 = { "V0", 2,
 "V-coord. (vertical) of volume origin", (char*)0, (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DRAW_V0_type };
static KmParReal   _GEANT_DRAWING_DRAW_SU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DRAW_SU = { "SU", 2,
 "Scale factor for U-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DRAW_SU_type };
static KmParReal   _GEANT_DRAWING_DRAW_SV_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DRAWING_DRAW_SV = { "SV", 2,
 "Scale factor for V-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_DRAWING_DRAW_SV_type };
static KmParameter *_GEANT_DRAWING_DRAW_parameters[] = {
 &_GEANT_DRAWING_DRAW_NAME, &_GEANT_DRAWING_DRAW_THETA,
 &_GEANT_DRAWING_DRAW_PHI, &_GEANT_DRAWING_DRAW_PSI, &_GEANT_DRAWING_DRAW_U0,
 &_GEANT_DRAWING_DRAW_V0, &_GEANT_DRAWING_DRAW_SU, &_GEANT_DRAWING_DRAW_SV };
static char *_GEANT_DRAWING_DRAW_guidance[] = {
 " CALL GDRAW(name,theta,phi,psi,u0,v0,su,sv)",
 "If optional parameters are missing, the corresponding values are",
 "taken from the common /GCDRAW/. This command will draw the volumes,",
 "selected with their graphical attributes, set by the SATT",
 "facility. The drawing may be performed with hidden line removal",
 "and with shading effects according to the value of the options HIDE",
 "and SHAD; if the option SHAD is ON, the contour's edges can be",
 "drawn or not. If the option HIDE is ON, the detector can be",
 "exploded (BOMB), clipped with different shapes (CVOL), and some",
 "of its parts can be shifted from their original",
 "position (SHIFT). When HIDE is ON, if",
 "the drawing requires more than the available memory, the program",
 "will evaluate and display the number of missing words",
 "(so that the user can increase the",
 "size of its ZEBRA store). Finally, at the end of each drawing (with HIDE\
 on),", "the program will print messages about the memory used and",
 "statistics on the volumes' visibility.",
 "The following commands will produce the drawing of a green",
 "volume, specified by NAME, without using the hidden line removal",
 "technique, using the hidden line removal technique,",
 "with different linewidth and colour (red), with",
 "solid colour, with shading of surfaces, and without edges.",
 "Finally, some examples are given for the ray-tracing. (A possible",
 "string for the NAME of the volume can be found using the command DTREE).",
 " EXAMPLE -", " satt * seen -2", " satt NAME colo 3",
 " draw NAME 40 40 0 10 10 .01 .01", " next", " dopt hide on",
 " draw NAME 40 40 0 10 10 .01 .01", " next", " satt NAME colo 2",
 " satt NAME lwid 4", " draw NAME 40 40 0 10 10 .01 .01", " next",
 " dopt shad on", " satt * lwid 1", " satt NAME fill 1",
 " draw NAME 40 40 0 10 10 .01 .01", " next", " satt NAME fill 3",
 " draw NAME 40 40 0 10 10 .01 .01", " next", " dopt edge off",
 " draw NAME 40 40 0 10 10 .01 .01", " dopt rayt on", " satt * fill 20",
 " dopt mapp 1", " draw NAME 40 40 0 10 10 .01 .01", " dopt proj pers",
 " persp NAME 500", " draw NAME 40 40 0 10 10 1 1", " valcut 100 100 100",
 " dopt mapp 0", " dopt user on", " satt NAM1 seen 0", " satt NAM2 colo 2",
 " draw NAME 40 40 0 10 10 5 5" };
static KmCommand _GEANT_DRAWING_DRAW = { &_GEANT_DRAWING_SPOT,
 "/GEANT/DRAWING/DRAW", "DRAW", 0, 2, 8, 1, _GEANT_DRAWING_DRAW_parameters, 0,
 0, gxdraw_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 59,
 _GEANT_DRAWING_DRAW_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_DRAWING_guidance[] = {
 "Drawing commands. These commands allow the visualization in several ways",
 "of the volumes defined in the geometrical data structure. It is possible",
 "to draw the logical tree of volumes belonging to the detector (DTREE),",
 "to show their geometrical specification (DSPEC,DFSPC), to draw them",
 "and their cut views (DRAW, DCUT). Moreover, it is possible to execute",
 "these commands when the hidden line removal option is activated; in",
 "this case, the volumes can be also either translated in the space",
 "(SHIFT), or clipped by boolean operation (CVOL). In addition, it is",
 "possible to fill the surfaces of the volumes",
 "with solid colours when the shading option (SHAD) is activated.",
 "Several tools (ZOOM, LENS) have been developed to zoom detailed parts",
 "of the detectors or to scan physical events as well.",
 "Finally, the command MOVE will allow the rotation, translation and zooming",
 "on real time parts of the detectors or tracks and hits of a simulated\
 event.",
 "Ray-tracing commands. In case the command (DOPT RAYT ON) is executed,",
 "the drawing is performed by the Geant ray-tracing;",
 "automatically, the color is assigned according to the tracking medium of\
 each",
 "volume and the volumes with a density lower/equal than the air are\
 considered",
 "transparent; if the option (USER) is set (ON) (again via the command\
 (DOPT)),",
 "the user can set color and visibility for the desired volumes via the\
 command",
 "(SATT), as usual, relatively to the attributes (COLO) and (SEEN).",
 "The resolution can be set via the command (SATT * FILL VALUE), where\
 (VALUE)",
 "is the ratio between the number of pixels drawn and 20 (user coordinates).",
 "Parallel view and perspective view are possible (DOPT PROJ PARA/PERS); in\
 the",
 "first case, we assume that the first mother volume of the tree is a box\
 with",
 "dimensions 10000 X 10000 X 10000 cm and the view point (infinetely far) is",
 "5000 cm far from the origin along the Z axis of the user coordinates; in\
 the",
 "second case, the distance between the observer and the origin of the world",
 "reference system is set in cm by the command (PERSP NAME VALUE);\
 grand-angle",
 "or telescopic effects can be achieved changing the scale factors in the\
 command", "(DRAW). When the final picture does not occupy the full window,",
 "mapping the space before tracing can speed up the drawing, but can also",
 "produce less precise results; values from 1 to 4 are allowed in the\
 command",
 "(DOPT MAPP VALUE), the mapping being more precise for increasing (VALUE);\
 for",
 "(VALUE = 0) no mapping is performed (therefore max precision and lowest\
 speed).",
 "The command (VALCUT) allows the cutting of the detector by three planes",
 "ortogonal to the x,y,z axis. The attribute (LSTY) can be set by the\
 command",
 "SATT for any desired volume and can assume values from 0 to 7; it\
 determines",
 "the different light processing to be performed for different materials:",
 "0 = dark-matt, 1 = bright-matt, 2 = plastic, 3 = ceramic, 4 =\
 rough-metals,",
 "5 = shiny-metals, 6 = glass, 7 = mirror. The detector is assumed to be in\
 the",
 "dark, the ambient light luminosity is 0.2 for each basic hue (the\
 saturation",
 "is 0.9) and the observer is assumed to have a light source (therefore he\
 will",
 "produce parallel light in the case of parallel view and point-like-source",
 "light in the case of perspective view)." };
static KmMenu _GEANT_DRAWING = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/DRAWING",
 "DRAWING", 2, &_GEANT_DRAWING_DRAW, 45, _GEANT_DRAWING_guidance };
 
static char *_GEANT_CVOL_guidance[] = { "Clipping commands.",
 "The hidden line removal technique is necessary to visualize properly",
 "very complex detectors. At the same time, it can be useful to visualize",
 "the inner elements of a detector in detail. For this purpose, the",
 "commands menu CVOL has been developed: these commands allow",
 "subtractions (via boolean operation) of given shapes from any part of",
 "the detector, therefore showing its inner contents. It is possible",
 "to clip each different volume by means of a different shape (BOX ,",
 "TUBE, CONE, SPHE are available). If '*' is given as the name of the",
 "volume to be clipped, all volumes are clipped by the given shape.",
 "A volume can be clipped at most twice (even by",
 "different shapes); if a volume is explicitely clipped",
 "twice, the '*' will not act on it anymore. Giving '.' as the name",
 "of the volume to be clipped will reset the clipping." };
static KmMenu _GEANT_CVOL = { &_GEANT_DRAWING,  (KmMenu*)0, "/GEANT/CVOL",
 "CVOL", 2, &_GEANT_CVOL_BOX, 14, _GEANT_CVOL_guidance };
 
static char *_GEANT_guidance[] = { "GEANT specific commands." };
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_CVOL, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 1, _GEANT_guidance };
 
  klnkmenu( &_GEANT, 921023 );
}
 
 
#ifdef F77_LCASE
#  define gkgcon_ gkgcon
#  define gxgcon_ gxgcon
#endif
 
#ifdef F77_UCASE
#  define gkgcon_ GKGCON
#  define gxgcon_ GXGCON
#endif
 
#ifdef IBM370
#  pragma linkage(GKGCON,FORTRAN)
#  pragma linkage(GXGCON,FORTRAN)
#endif
 
extern void gkgcon_();
extern void gxgcon_();
 
void gkgcon_()
{
 
static KmParInt    _GEANT_GRAPHICS_CONTROL_MAP_COLOR_ICADD_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_MAP_COLOR_ICADD = { "ICADD", 5,
 "Colour table index", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GRAPHICS_CONTROL_MAP_COLOR_ICADD_type };
static KmParInt    _GEANT_GRAPHICS_CONTROL_MAP_COLOR_ICVAL_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_MAP_COLOR_ICVAL = { "ICVAL", 5,
 "Colour table value", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GRAPHICS_CONTROL_MAP_COLOR_ICVAL_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_MAP_COLOR_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_MAP_COLOR_ICADD,
 &_GEANT_GRAPHICS_CONTROL_MAP_COLOR_ICVAL };
static char *_GEANT_GRAPHICS_CONTROL_MAP_COLOR_guidance[] = {
 "Sets the color table LOOKTB(ICADD)=ICVAL.",
 "If ICADD=0 then LOOKTB(1:16) is taken.",
 "If ICVAL is omitted the current value of LOOKTB(ICADD) is shown." };
static KmCommand _GEANT_GRAPHICS_CONTROL_MAP_COLOR = {  (KmCommand*)0,
 "/GEANT/GRAPHICS_CONTROL/MAP_COLOR", "MAP_COLOR", 0, 2, 2, 0,
 _GEANT_GRAPHICS_CONTROL_MAP_COLOR_parameters, 0, 0, gxgcon_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_GRAPHICS_CONTROL_MAP_COLOR_guidance,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_GRAPHICS_CONTROL_SPERS_DPERS_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_SPERS_DPERS = { "DPERS", 5,
 "Distance from the origin", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_GRAPHICS_CONTROL_SPERS_DPERS_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_SPERS_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_SPERS_DPERS };
static char *_GEANT_GRAPHICS_CONTROL_SPERS_guidance[] = {
 "Set the variable dpers in /GCDRAW/, representing",
 "the distance from the origin when using option PERSpective." };
static KmCommand _GEANT_GRAPHICS_CONTROL_SPERS = {
 &_GEANT_GRAPHICS_CONTROL_MAP_COLOR, "/GEANT/GRAPHICS_CONTROL/SPERS", "SPERS",
 0, 2, 1, 1, _GEANT_GRAPHICS_CONTROL_SPERS_parameters, 0, 0, gxgcon_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_GRAPHICS_CONTROL_SPERS_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_GRAPHICS_CONTROL_SIZE_XSIZE_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_SIZE_XSIZE = { "XSIZE", 5,
 "Size along X", "20.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GRAPHICS_CONTROL_SIZE_XSIZE_type };
static KmParReal   _GEANT_GRAPHICS_CONTROL_SIZE_YSIZE_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_SIZE_YSIZE = { "YSIZE", 5,
 "Size along Y", "20.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GRAPHICS_CONTROL_SIZE_YSIZE_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_SIZE_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_SIZE_XSIZE, &_GEANT_GRAPHICS_CONTROL_SIZE_YSIZE };
static char *_GEANT_GRAPHICS_CONTROL_SIZE_guidance[] = {
 "Set the size of the picture.",
 "On the terminal, the pictures will have the ratio YSIZE/XSIZE, and,",
 "if a metafile is produced, pictures will be YSIZE by XSIZE cm.",
 "This command sets the parameters for the normalisation transformation",
 "number 1 to [0-XSIZE], [0-YSIZE]." };
static KmCommand _GEANT_GRAPHICS_CONTROL_SIZE = {
 &_GEANT_GRAPHICS_CONTROL_SPERS, "/GEANT/GRAPHICS_CONTROL/SIZE", "SIZE", 0, 2,
 2, 0, _GEANT_GRAPHICS_CONTROL_SIZE_parameters, 0, 0, gxgcon_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 5, _GEANT_GRAPHICS_CONTROL_SIZE_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_GRAPHICS_CONTROL_DOPT_IOPT = { "IOPT", 4,
 "Option name", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_DOPT_IVAL = { "IVAL", 4,
 "Option value", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_GRAPHICS_CONTROL_DOPT_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_DOPT_IOPT, &_GEANT_GRAPHICS_CONTROL_DOPT_IVAL };
static char *_GEANT_GRAPHICS_CONTROL_DOPT_guidance[] = {
 " CALL GDOPT(iopt,ival)", "To set/modify the drawing options.",
 "   IOPT   IVAL      Action", "   THRZ    ON       Draw tracks in R vs Z",
 "           OFF (D)  Draw tracks in X,Y,Z", "           180",
 "           360", "   PROJ    PARA (D) Parallel projection",
 "           PERS     Perspective",
 "   TRAK    LINE (D) Trajectory drawn with lines",
 "           POIN       \" \" with markers",
 "   HIDE    ON       Hidden line removal using the CG package",
 "           OFF (D)  No hidden line removal",
 "   SHAD    ON       Fill area and shading of surfaces.",
 "           OFF (D)  Normal hidden line removal.",
 "   RAYT    ON       Ray-tracing on.",
 "           OFF (D)  Ray-tracing off.",
 "   EDGE    OFF      Does not draw contours when shad is on.",
 "           ON  (D)  Normal shading.",
 "   MAPP    1,2,3,4  Mapping before ray-tracing.",
 "           0   (D)  No mapping.",
 "   USER    ON       User graphics options in the raytracing.",
 "           OFF (D)  Automatic graphics options." };
static KmCommand _GEANT_GRAPHICS_CONTROL_DOPT = {
 &_GEANT_GRAPHICS_CONTROL_SIZE, "/GEANT/GRAPHICS_CONTROL/DOPT", "DOPT", 0, 2,
 2, 0, _GEANT_GRAPHICS_CONTROL_DOPT_parameters, 0, 0, gxgcon_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 23, _GEANT_GRAPHICS_CONTROL_DOPT_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_GRAPHICS_CONTROL_NEXT_guidance[] = {
 "Clear screen (start a new picture on graphics file, if opened)." };
static KmCommand _GEANT_GRAPHICS_CONTROL_NEXT = {
 &_GEANT_GRAPHICS_CONTROL_DOPT, "/GEANT/GRAPHICS_CONTROL/NEXT", "NEXT", 0, 2,
 0, 0, (KmParameter**)0, 0, 0, gxgcon_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 1, _GEANT_GRAPHICS_CONTROL_NEXT_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GRAPHICS_CONTROL_LWID_LWIDTH_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_LWID_LWIDTH = { "LWIDTH", 6,
 "Line width code", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GRAPHICS_CONTROL_LWID_LWIDTH_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_LWID_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_LWID_LWIDTH };
static char *_GEANT_GRAPHICS_CONTROL_LWID_guidance[] = {
 " CALL GDLW(-abs(lwidth))" };
static KmCommand _GEANT_GRAPHICS_CONTROL_LWID = {
 &_GEANT_GRAPHICS_CONTROL_NEXT, "/GEANT/GRAPHICS_CONTROL/LWID", "LWID", 0, 2,
 1, 1, _GEANT_GRAPHICS_CONTROL_LWID_parameters, 0, 0, gxgcon_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 1, _GEANT_GRAPHICS_CONTROL_LWID_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GRAPHICS_CONTROL_COLOR_ICOL_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_COLOR_ICOL = { "ICOL", 4,
 "Colour code", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_INT, &_GEANT_GRAPHICS_CONTROL_COLOR_ICOL_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_COLOR_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_COLOR_ICOL };
static char *_GEANT_GRAPHICS_CONTROL_COLOR_guidance[] = {
 " CALL GDCOL(-abs(icol))" };
static KmCommand _GEANT_GRAPHICS_CONTROL_COLOR = {
 &_GEANT_GRAPHICS_CONTROL_LWID, "/GEANT/GRAPHICS_CONTROL/COLOR", "COLOR", 0,
 2, 1, 1, _GEANT_GRAPHICS_CONTROL_COLOR_parameters, 0, 0, gxgcon_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_GRAPHICS_CONTROL_COLOR_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_GRAPHICS_CONTROL_SCALE_GSCU_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_SCALE_GSCU = { "GSCU", 4,
 "Scale factor for U-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_GRAPHICS_CONTROL_SCALE_GSCU_type };
static KmParReal   _GEANT_GRAPHICS_CONTROL_SCALE_GSCV_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_SCALE_GSCV = { "GSCV", 4,
 "Scale factor for V-coord.", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_GRAPHICS_CONTROL_SCALE_GSCV_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_SCALE_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_SCALE_GSCU, &_GEANT_GRAPHICS_CONTROL_SCALE_GSCV };
static char *_GEANT_GRAPHICS_CONTROL_SCALE_guidance[] = {
 "Change the scale factors GSCU and GSCV in /GCDRAW/." };
static KmCommand _GEANT_GRAPHICS_CONTROL_SCALE = {
 &_GEANT_GRAPHICS_CONTROL_COLOR, "/GEANT/GRAPHICS_CONTROL/SCALE", "SCALE", 0,
 2, 2, 2, _GEANT_GRAPHICS_CONTROL_SCALE_parameters, 0, 0, gxgcon_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_GRAPHICS_CONTROL_SCALE_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_GRAPHICS_CONTROL_SATT_NAME = { "NAME", 4,
 "Volume name", "*   ", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_SATT_IOPT = { "IOPT", 4,
 "Name of the attribute to be set", "DEFA", (char*)0, 20, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_GRAPHICS_CONTROL_SATT_IVAL_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_SATT_IVAL = { "IVAL", 4,
 "Value to which the attribute is to be set", "10000", (char*)0, 8, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_GRAPHICS_CONTROL_SATT_IVAL_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_SATT_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_SATT_NAME, &_GEANT_GRAPHICS_CONTROL_SATT_IOPT,
 &_GEANT_GRAPHICS_CONTROL_SATT_IVAL };
static char *_GEANT_GRAPHICS_CONTROL_SATT_guidance[] = {
 " CALL GSATT(name,iopt,ival)", "name='*' stands for all the volumes.",
 "iopt can be chosen among the following :",
 " 'WORK'   0=volume name is inactive for the tracking",
 "          1=volume name is active for the tracking (default)",
 " 'SEEN'   0=volume name is invisible",
 "          1=volume name is visible (default)",
 "         -1=volume invisible with all its descendants in the tree",
 "         -2=volume visible but not its descendants in the tree",
 " 'LSTY'   line style 1,2,3,... (default=1)",
 "          LSTY=7 will produce a very precise approximation for",
 "          revolution bodies.",
 " 'LWID'   line width -7,...,1,2,3,..7 (default=1)",
 "          LWID<0 will act as abs(LWID) was set for the volume",
 "          and for all the levels below it. When SHAD is 'ON', LWID",
 "          represent the linewidth of the scan lines filling the surfaces",
 "          (whereas the FILL value represent their number). Therefore",
 "          tuning this parameter will help to obtain the desired",
 "          quality/performance ratio.",
 " 'COLO'   colour code -166,...,1,2,..166 (default=1)",
 "          n=1=black",
 "          n=2=red;    n=17+m, m=0,25, increasing luminosity according to\
 'm';",
 "          n=3=green;  n=67+m, m=0,25, increasing luminosity according to\
 'm';",
 "          n=4=blue;   n=117+m, m=0,25, increasing luminosity according to\
 'm';",
 "          n=5=yellow; n=42+m, m=0,25, increasing luminosity according to\
 'm';",
 "          n=6=violet; n=142+m, m=0,25, increasing luminosity according to\
 'm';",
 "          n=7=lightblue; n=92+m, m=0,25, increasing luminosity according to\
 'm';", "          colour=n*10+m, m=1,2,...9, will produce the same colour",
 "          as 'n', but with increasing luminosity according to 'm';",
 "          COLO<0 will act as if abs(COLO) was set for the volume",
 "          and for all the levels below it.",
 "          When for a volume the attribute FILL is > 1 (and the",
 "          option SHAD is on), the ABS of its colour code must be < 8",
 "          because an automatic shading of its faces will be",
 "          performed.",
 " 'FILL'   (1992) fill area  -7,...,0,1,...7 (default=0)",
 "          when option SHAD is 'on' the FILL attribute of any",
 "          volume can be set different from 0 (normal drawing);",
 "          if it is set to 1, the faces of such volume will be filled",
 "          with solid colours; if ABS(FILL) is > 1, then a light",
 "          source is placed along the observer line, and the faces of",
 "          such volumes will be painted by colours whose luminosity",
 "          will depend on the amount of light reflected;",
 "          if ABS(FILL) = 1, then it is possible to use all the 166",
 "          colours of the colour table, becouse the automatic shading",
 "          is not performed;",
 "          for increasing values of FILL the drawing will be performed",
 "          with higher and higher resolution improving the quality (the",
 "          number of scan lines used to fill the faces increases with\
 FILL);", "          it is possible to set different values of FILL",
 "          for different volumes, in order to optimize at the same time",
 "          the performance and the quality of the picture;",
 "          FILL<0 will act as if abs(FILL) was set for the volume",
 "          and for all the levels below it.",
 "          This kind of drawing can be saved in 'picture files'",
 "          or in view banks.", "          0=drawing without fill area",
 "          1=faces filled with solid colours and resolution = 6",
 "          2=lowest resolution (very fast)",
 "          3=default resolution", "          4=.................",
 "          5=.................", "          6=.................",
 "          7=max resolution",
 "          Finally, if a coloured background is desired, the FILL",
 "          attribute for the first volume of the tree must be set",
 "          equal to -abs(colo), colo being >0 and <166.",
 " 'SET '   set number associated to volume name",
 " 'DET '   detector number associated to volume name",
 " 'DTYP'   detector type (1,2)" };
static KmCommand _GEANT_GRAPHICS_CONTROL_SATT = {
 &_GEANT_GRAPHICS_CONTROL_SCALE, "/GEANT/GRAPHICS_CONTROL/SATT", "SATT", 0, 2,
 3, 0, _GEANT_GRAPHICS_CONTROL_SATT_parameters, 0, 0, gxgcon_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 70, _GEANT_GRAPHICS_CONTROL_SATT_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_GRAPHICS_CONTROL_SSETVA_RVAL_type = { "-10.", "10.",
 "-10.", "10.", 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_SSETVA_RVAL = { "RVAL", 4,
 "Attribute value", "1.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GRAPHICS_CONTROL_SSETVA_RVAL_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_SSETVA_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_SSETVA_RVAL };
static char *_GEANT_GRAPHICS_CONTROL_SSETVA_guidance[] = {
 "Set current attribute value." };
static KmCommand _GEANT_GRAPHICS_CONTROL_SSETVA = {
 &_GEANT_GRAPHICS_CONTROL_SATT, "/GEANT/GRAPHICS_CONTROL/SSETVA", "SSETVA", 0,
 2, 1, 0, _GEANT_GRAPHICS_CONTROL_SSETVA_parameters, 0, 0, gxgcon_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_GRAPHICS_CONTROL_SSETVA_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_GRAPHICS_CONTROL_SSETAT_IOPT = { "IOPT", 4,
 "Attribute name", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_GRAPHICS_CONTROL_SSETAT_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_SSETAT_IOPT };
static char *_GEANT_GRAPHICS_CONTROL_SSETAT_guidance[] = {
 "Set current attribute." };
static KmCommand _GEANT_GRAPHICS_CONTROL_SSETAT = {
 &_GEANT_GRAPHICS_CONTROL_SSETVA, "/GEANT/GRAPHICS_CONTROL/SSETAT", "SSETAT",
 0, 2, 1, 1, _GEANT_GRAPHICS_CONTROL_SSETAT_parameters, 0, 0, gxgcon_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_GRAPHICS_CONTROL_SSETAT_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_GRAPHICS_CONTROL_RESETWK_guidance[] = { "CALL GRESWK",
 "It deactivate the previosly activated workstation and reactivate the",
 "default one." };
static KmCommand _GEANT_GRAPHICS_CONTROL_RESETWK = {
 &_GEANT_GRAPHICS_CONTROL_SSETAT, "/GEANT/GRAPHICS_CONTROL/RESETWK",
 "RESETWK", 0, 2, 0, 0, (KmParameter**)0, 0, 0, gxgcon_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_GRAPHICS_CONTROL_RESETWK_guidance,
 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_GRAPHICS_CONTROL_CHANGEWK_guidance[] = { "CALL GCHNWK",
 "It open a new workstation (if not already opened) and activate it",
 "(deactivating the default one)." };
static KmCommand _GEANT_GRAPHICS_CONTROL_CHANGEWK = {
 &_GEANT_GRAPHICS_CONTROL_RESETWK, "/GEANT/GRAPHICS_CONTROL/CHANGEWK",
 "CHANGEWK", 0, 2, 0, 0, (KmParameter**)0, 0, 0, gxgcon_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_GRAPHICS_CONTROL_CHANGEWK_guidance,
 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_GRAPHICS_CONTROL_DCLOSE_guidance[] = { " CALL GDCLOS",
 "It closes the currently open view bank; it must be called after the",
 "end of the drawing to be stored." };
static KmCommand _GEANT_GRAPHICS_CONTROL_DCLOSE = {
 &_GEANT_GRAPHICS_CONTROL_CHANGEWK, "/GEANT/GRAPHICS_CONTROL/DCLOSE",
 "DCLOSE", 0, 2, 0, 0, (KmParameter**)0, 0, 0, gxgcon_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_GRAPHICS_CONTROL_DCLOSE_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GRAPHICS_CONTROL_DELETE_IVIEW_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_DELETE_IVIEW = { "IVIEW", 5,
 "View number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GRAPHICS_CONTROL_DELETE_IVIEW_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_DELETE_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_DELETE_IVIEW };
static char *_GEANT_GRAPHICS_CONTROL_DELETE_guidance[] = {
 " CALL GDELET(iview)", "It deletes a view bank from memory." };
static KmCommand _GEANT_GRAPHICS_CONTROL_DELETE = {
 &_GEANT_GRAPHICS_CONTROL_DCLOSE, "/GEANT/GRAPHICS_CONTROL/DELETE", "DELETE",
 0, 2, 1, 1, _GEANT_GRAPHICS_CONTROL_DELETE_parameters, 0, 0, gxgcon_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_GRAPHICS_CONTROL_DELETE_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GRAPHICS_CONTROL_DSHOW_IVIEW_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_DSHOW_IVIEW = { "IVIEW", 5,
 "View number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GRAPHICS_CONTROL_DSHOW_IVIEW_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_DSHOW_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_DSHOW_IVIEW };
static char *_GEANT_GRAPHICS_CONTROL_DSHOW_guidance[] = {
 " CALL GDSHOW(iview)",
 "It shows on the screen the contents of a view bank. It",
 "can be called after a view bank has been closed." };
static KmCommand _GEANT_GRAPHICS_CONTROL_DSHOW = {
 &_GEANT_GRAPHICS_CONTROL_DELETE, "/GEANT/GRAPHICS_CONTROL/DSHOW", "DSHOW", 0,
 2, 1, 0, _GEANT_GRAPHICS_CONTROL_DSHOW_parameters, 0, 0, gxgcon_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_GRAPHICS_CONTROL_DSHOW_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GRAPHICS_CONTROL_DOPEN_IVIEW_type = { (char*)0,
 (char*)0, (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GRAPHICS_CONTROL_DOPEN_IVIEW = { "IVIEW", 5,
 "View number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GRAPHICS_CONTROL_DOPEN_IVIEW_type };
static KmParameter *_GEANT_GRAPHICS_CONTROL_DOPEN_parameters[] = {
 &_GEANT_GRAPHICS_CONTROL_DOPEN_IVIEW };
static char *_GEANT_GRAPHICS_CONTROL_DOPEN_guidance[] = {
 " CALL GDOPEN(iview)",
 "When a drawing is very complex and requires a long time to be",
 "executed, it can be useful to store it in a view bank: after a",
 "call to DOPEN and the execution of the drawing (nothing will",
 "appear on the screen), and after a necessary call to DCLOSE,",
 "the contents of the bank can be displayed in a very fast way",
 "through a call to DSHOW; therefore, the detector can be easily",
 "zoomed many times in different ways. Please note that the pictures",
 "with solid colours can now be stored in a view bank or in 'PICTURE FILES'."
 };
static KmCommand _GEANT_GRAPHICS_CONTROL_DOPEN = {
 &_GEANT_GRAPHICS_CONTROL_DSHOW, "/GEANT/GRAPHICS_CONTROL/DOPEN", "DOPEN", 0,
 2, 1, 1, _GEANT_GRAPHICS_CONTROL_DOPEN_parameters, 0, 0, gxgcon_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 9,
 _GEANT_GRAPHICS_CONTROL_DOPEN_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_GRAPHICS_CONTROL_guidance[] = {
 "Graphics control commands." };
static KmMenu _GEANT_GRAPHICS_CONTROL = {  (KmMenu*)0,  (KmMenu*)0,
 "/GEANT/GRAPHICS_CONTROL", "GRAPHICS_CONTROL", 2,
 &_GEANT_GRAPHICS_CONTROL_DOPEN, 1, _GEANT_GRAPHICS_CONTROL_guidance };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_GRAPHICS_CONTROL, "/GEANT",
 "GEANT", 1,  (KmCommand*)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 921023 );
}
 
 
#ifdef F77_LCASE
#  define gklist_ gklist
#  define gxlist_ gxlist
#endif
 
#ifdef F77_UCASE
#  define gklist_ GKLIST
#  define gxlist_ GXLIST
#endif
 
#ifdef IBM370
#  pragma linkage(GKLIST,FORTRAN)
#  pragma linkage(GXLIST,FORTRAN)
#endif
 
extern void gklist_();
extern void gxlist_();
 
void gklist_()
{
 
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_1 = { "LRSAVE_1", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_2 = { "LRSAVE_2", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_3 = { "LRSAVE_3", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_4 = { "LRSAVE_4", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_5 = { "LRSAVE_5", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_6 = { "LRSAVE_6", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_7 = { "LRSAVE_7", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_8 = { "LRSAVE_8", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_9 = { "LRSAVE_9", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_10 = { "LRSAVE_10", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_11 = { "LRSAVE_11", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_12 = { "LRSAVE_12", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_13 = { "LRSAVE_13", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_14 = { "LRSAVE_14", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_15 = { "LRSAVE_15", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_16 = { "LRSAVE_16", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_17 = { "LRSAVE_17", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_18 = { "LRSAVE_18", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_19 = { "LRSAVE_19", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RSAV_LRSAVE_20 = { "LRSAVE_20", 9,
 "user word", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_RSAV_parameters[] = {
 &_GEANT_LISTS_RSAV_LRSAVE_1, &_GEANT_LISTS_RSAV_LRSAVE_2,
 &_GEANT_LISTS_RSAV_LRSAVE_3, &_GEANT_LISTS_RSAV_LRSAVE_4,
 &_GEANT_LISTS_RSAV_LRSAVE_5, &_GEANT_LISTS_RSAV_LRSAVE_6,
 &_GEANT_LISTS_RSAV_LRSAVE_7, &_GEANT_LISTS_RSAV_LRSAVE_8,
 &_GEANT_LISTS_RSAV_LRSAVE_9, &_GEANT_LISTS_RSAV_LRSAVE_10,
 &_GEANT_LISTS_RSAV_LRSAVE_11, &_GEANT_LISTS_RSAV_LRSAVE_12,
 &_GEANT_LISTS_RSAV_LRSAVE_13, &_GEANT_LISTS_RSAV_LRSAVE_14,
 &_GEANT_LISTS_RSAV_LRSAVE_15, &_GEANT_LISTS_RSAV_LRSAVE_16,
 &_GEANT_LISTS_RSAV_LRSAVE_17, &_GEANT_LISTS_RSAV_LRSAVE_18,
 &_GEANT_LISTS_RSAV_LRSAVE_19, &_GEANT_LISTS_RSAV_LRSAVE_20 };
static char *_GEANT_LISTS_RSAV_guidance[] = {
 "The command RSAV is similar to the RSAV data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_RSAV = {  (KmCommand*)0, "/GEANT/LISTS/RSAV",
 "RSAV", 0, 2, 20, 0, _GEANT_LISTS_RSAV_parameters, 0, 0, gxlist_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_LISTS_RSAV_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_RGET_LRGET_1 = { "LRGET_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_2 = { "LRGET_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_3 = { "LRGET_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_4 = { "LRGET_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_5 = { "LRGET_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_6 = { "LRGET_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_7 = { "LRGET_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_8 = { "LRGET_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_9 = { "LRGET_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_10 = { "LRGET_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_11 = { "LRGET_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_12 = { "LRGET_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_13 = { "LRGET_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_14 = { "LRGET_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_15 = { "LRGET_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_16 = { "LRGET_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_17 = { "LRGET_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_18 = { "LRGET_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_19 = { "LRGET_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_RGET_LRGET_20 = { "LRGET_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_RGET_parameters[] = {
 &_GEANT_LISTS_RGET_LRGET_1, &_GEANT_LISTS_RGET_LRGET_2,
 &_GEANT_LISTS_RGET_LRGET_3, &_GEANT_LISTS_RGET_LRGET_4,
 &_GEANT_LISTS_RGET_LRGET_5, &_GEANT_LISTS_RGET_LRGET_6,
 &_GEANT_LISTS_RGET_LRGET_7, &_GEANT_LISTS_RGET_LRGET_8,
 &_GEANT_LISTS_RGET_LRGET_9, &_GEANT_LISTS_RGET_LRGET_10,
 &_GEANT_LISTS_RGET_LRGET_11, &_GEANT_LISTS_RGET_LRGET_12,
 &_GEANT_LISTS_RGET_LRGET_13, &_GEANT_LISTS_RGET_LRGET_14,
 &_GEANT_LISTS_RGET_LRGET_15, &_GEANT_LISTS_RGET_LRGET_16,
 &_GEANT_LISTS_RGET_LRGET_17, &_GEANT_LISTS_RGET_LRGET_18,
 &_GEANT_LISTS_RGET_LRGET_19, &_GEANT_LISTS_RGET_LRGET_20 };
static char *_GEANT_LISTS_RGET_guidance[] = {
 "The command RGET is similar to the RGET data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_RGET = { &_GEANT_LISTS_RSAV,
 "/GEANT/LISTS/RGET", "RGET", 0, 2, 20, 0, _GEANT_LISTS_RGET_parameters, 0, 0,
 gxlist_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_LISTS_RGET_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_STAT_LSTAT_1 = { "LSTAT_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_2 = { "LSTAT_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_3 = { "LSTAT_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_4 = { "LSTAT_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_5 = { "LSTAT_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_6 = { "LSTAT_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_7 = { "LSTAT_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_8 = { "LSTAT_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_9 = { "LSTAT_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_10 = { "LSTAT_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_11 = { "LSTAT_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_12 = { "LSTAT_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_13 = { "LSTAT_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_14 = { "LSTAT_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_15 = { "LSTAT_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_16 = { "LSTAT_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_17 = { "LSTAT_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_18 = { "LSTAT_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_19 = { "LSTAT_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_STAT_LSTAT_20 = { "LSTAT_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_STAT_parameters[] = {
 &_GEANT_LISTS_STAT_LSTAT_1, &_GEANT_LISTS_STAT_LSTAT_2,
 &_GEANT_LISTS_STAT_LSTAT_3, &_GEANT_LISTS_STAT_LSTAT_4,
 &_GEANT_LISTS_STAT_LSTAT_5, &_GEANT_LISTS_STAT_LSTAT_6,
 &_GEANT_LISTS_STAT_LSTAT_7, &_GEANT_LISTS_STAT_LSTAT_8,
 &_GEANT_LISTS_STAT_LSTAT_9, &_GEANT_LISTS_STAT_LSTAT_10,
 &_GEANT_LISTS_STAT_LSTAT_11, &_GEANT_LISTS_STAT_LSTAT_12,
 &_GEANT_LISTS_STAT_LSTAT_13, &_GEANT_LISTS_STAT_LSTAT_14,
 &_GEANT_LISTS_STAT_LSTAT_15, &_GEANT_LISTS_STAT_LSTAT_16,
 &_GEANT_LISTS_STAT_LSTAT_17, &_GEANT_LISTS_STAT_LSTAT_18,
 &_GEANT_LISTS_STAT_LSTAT_19, &_GEANT_LISTS_STAT_LSTAT_20 };
static char *_GEANT_LISTS_STAT_guidance[] = {
 "The command STAT is similar to the STAT data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_STAT = { &_GEANT_LISTS_RGET,
 "/GEANT/LISTS/STAT", "STAT", 0, 2, 20, 0, _GEANT_LISTS_STAT_parameters, 0, 0,
 gxlist_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_LISTS_STAT_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_PLOT_LPLOT_1 = { "LPLOT_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_2 = { "LPLOT_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_3 = { "LPLOT_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_4 = { "LPLOT_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_5 = { "LPLOT_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_6 = { "LPLOT_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_7 = { "LPLOT_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_8 = { "LPLOT_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_9 = { "LPLOT_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_10 = { "LPLOT_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_11 = { "LPLOT_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_12 = { "LPLOT_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_13 = { "LPLOT_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_14 = { "LPLOT_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_15 = { "LPLOT_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_16 = { "LPLOT_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_17 = { "LPLOT_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_18 = { "LPLOT_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_19 = { "LPLOT_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_PLOT_LPLOT_20 = { "LPLOT_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_PLOT_parameters[] = {
 &_GEANT_LISTS_PLOT_LPLOT_1, &_GEANT_LISTS_PLOT_LPLOT_2,
 &_GEANT_LISTS_PLOT_LPLOT_3, &_GEANT_LISTS_PLOT_LPLOT_4,
 &_GEANT_LISTS_PLOT_LPLOT_5, &_GEANT_LISTS_PLOT_LPLOT_6,
 &_GEANT_LISTS_PLOT_LPLOT_7, &_GEANT_LISTS_PLOT_LPLOT_8,
 &_GEANT_LISTS_PLOT_LPLOT_9, &_GEANT_LISTS_PLOT_LPLOT_10,
 &_GEANT_LISTS_PLOT_LPLOT_11, &_GEANT_LISTS_PLOT_LPLOT_12,
 &_GEANT_LISTS_PLOT_LPLOT_13, &_GEANT_LISTS_PLOT_LPLOT_14,
 &_GEANT_LISTS_PLOT_LPLOT_15, &_GEANT_LISTS_PLOT_LPLOT_16,
 &_GEANT_LISTS_PLOT_LPLOT_17, &_GEANT_LISTS_PLOT_LPLOT_18,
 &_GEANT_LISTS_PLOT_LPLOT_19, &_GEANT_LISTS_PLOT_LPLOT_20 };
static char *_GEANT_LISTS_PLOT_guidance[] = {
 "The command PLOT is similar to the PLOT data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_PLOT = { &_GEANT_LISTS_STAT,
 "/GEANT/LISTS/PLOT", "PLOT", 0, 2, 20, 0, _GEANT_LISTS_PLOT_parameters, 0, 0,
 gxlist_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_LISTS_PLOT_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_VIEW_LVIEW_1 = { "LVIEW_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_2 = { "LVIEW_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_3 = { "LVIEW_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_4 = { "LVIEW_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_5 = { "LVIEW_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_6 = { "LVIEW_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_7 = { "LVIEW_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_8 = { "LVIEW_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_9 = { "LVIEW_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_10 = { "LVIEW_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_11 = { "LVIEW_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_12 = { "LVIEW_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_13 = { "LVIEW_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_14 = { "LVIEW_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_15 = { "LVIEW_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_16 = { "LVIEW_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_17 = { "LVIEW_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_18 = { "LVIEW_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_19 = { "LVIEW_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_VIEW_LVIEW_20 = { "LVIEW_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_VIEW_parameters[] = {
 &_GEANT_LISTS_VIEW_LVIEW_1, &_GEANT_LISTS_VIEW_LVIEW_2,
 &_GEANT_LISTS_VIEW_LVIEW_3, &_GEANT_LISTS_VIEW_LVIEW_4,
 &_GEANT_LISTS_VIEW_LVIEW_5, &_GEANT_LISTS_VIEW_LVIEW_6,
 &_GEANT_LISTS_VIEW_LVIEW_7, &_GEANT_LISTS_VIEW_LVIEW_8,
 &_GEANT_LISTS_VIEW_LVIEW_9, &_GEANT_LISTS_VIEW_LVIEW_10,
 &_GEANT_LISTS_VIEW_LVIEW_11, &_GEANT_LISTS_VIEW_LVIEW_12,
 &_GEANT_LISTS_VIEW_LVIEW_13, &_GEANT_LISTS_VIEW_LVIEW_14,
 &_GEANT_LISTS_VIEW_LVIEW_15, &_GEANT_LISTS_VIEW_LVIEW_16,
 &_GEANT_LISTS_VIEW_LVIEW_17, &_GEANT_LISTS_VIEW_LVIEW_18,
 &_GEANT_LISTS_VIEW_LVIEW_19, &_GEANT_LISTS_VIEW_LVIEW_20 };
static char *_GEANT_LISTS_VIEW_guidance[] = {
 "The command VIEW is similar to the VIEW data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_VIEW = { &_GEANT_LISTS_PLOT,
 "/GEANT/LISTS/VIEW", "VIEW", 0, 2, 20, 0, _GEANT_LISTS_VIEW_parameters, 0, 0,
 gxlist_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_LISTS_VIEW_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_GEOM_LGEOM_1 = { "LGEOM_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_2 = { "LGEOM_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_3 = { "LGEOM_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_4 = { "LGEOM_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_5 = { "LGEOM_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_6 = { "LGEOM_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_7 = { "LGEOM_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_8 = { "LGEOM_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_9 = { "LGEOM_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_10 = { "LGEOM_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_11 = { "LGEOM_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_12 = { "LGEOM_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_13 = { "LGEOM_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_14 = { "LGEOM_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_15 = { "LGEOM_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_16 = { "LGEOM_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_17 = { "LGEOM_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_18 = { "LGEOM_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_19 = { "LGEOM_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GEOM_LGEOM_20 = { "LGEOM_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_GEOM_parameters[] = {
 &_GEANT_LISTS_GEOM_LGEOM_1, &_GEANT_LISTS_GEOM_LGEOM_2,
 &_GEANT_LISTS_GEOM_LGEOM_3, &_GEANT_LISTS_GEOM_LGEOM_4,
 &_GEANT_LISTS_GEOM_LGEOM_5, &_GEANT_LISTS_GEOM_LGEOM_6,
 &_GEANT_LISTS_GEOM_LGEOM_7, &_GEANT_LISTS_GEOM_LGEOM_8,
 &_GEANT_LISTS_GEOM_LGEOM_9, &_GEANT_LISTS_GEOM_LGEOM_10,
 &_GEANT_LISTS_GEOM_LGEOM_11, &_GEANT_LISTS_GEOM_LGEOM_12,
 &_GEANT_LISTS_GEOM_LGEOM_13, &_GEANT_LISTS_GEOM_LGEOM_14,
 &_GEANT_LISTS_GEOM_LGEOM_15, &_GEANT_LISTS_GEOM_LGEOM_16,
 &_GEANT_LISTS_GEOM_LGEOM_17, &_GEANT_LISTS_GEOM_LGEOM_18,
 &_GEANT_LISTS_GEOM_LGEOM_19, &_GEANT_LISTS_GEOM_LGEOM_20 };
static char *_GEANT_LISTS_GEOM_guidance[] = {
 "The command GEOM is similar to the GEOM data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_GEOM = { &_GEANT_LISTS_VIEW,
 "/GEANT/LISTS/GEOM", "GEOM", 0, 2, 20, 0, _GEANT_LISTS_GEOM_parameters, 0, 0,
 gxlist_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_LISTS_GEOM_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_1 = { "LPRIN_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_2 = { "LPRIN_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_3 = { "LPRIN_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_4 = { "LPRIN_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_5 = { "LPRIN_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_6 = { "LPRIN_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_7 = { "LPRIN_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_8 = { "LPRIN_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_9 = { "LPRIN_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_10 = { "LPRIN_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_11 = { "LPRIN_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_12 = { "LPRIN_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_13 = { "LPRIN_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_14 = { "LPRIN_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_15 = { "LPRIN_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_16 = { "LPRIN_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_17 = { "LPRIN_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_18 = { "LPRIN_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_19 = { "LPRIN_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_LPRIN_LPRIN_20 = { "LPRIN_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_LPRIN_parameters[] = {
 &_GEANT_LISTS_LPRIN_LPRIN_1, &_GEANT_LISTS_LPRIN_LPRIN_2,
 &_GEANT_LISTS_LPRIN_LPRIN_3, &_GEANT_LISTS_LPRIN_LPRIN_4,
 &_GEANT_LISTS_LPRIN_LPRIN_5, &_GEANT_LISTS_LPRIN_LPRIN_6,
 &_GEANT_LISTS_LPRIN_LPRIN_7, &_GEANT_LISTS_LPRIN_LPRIN_8,
 &_GEANT_LISTS_LPRIN_LPRIN_9, &_GEANT_LISTS_LPRIN_LPRIN_10,
 &_GEANT_LISTS_LPRIN_LPRIN_11, &_GEANT_LISTS_LPRIN_LPRIN_12,
 &_GEANT_LISTS_LPRIN_LPRIN_13, &_GEANT_LISTS_LPRIN_LPRIN_14,
 &_GEANT_LISTS_LPRIN_LPRIN_15, &_GEANT_LISTS_LPRIN_LPRIN_16,
 &_GEANT_LISTS_LPRIN_LPRIN_17, &_GEANT_LISTS_LPRIN_LPRIN_18,
 &_GEANT_LISTS_LPRIN_LPRIN_19, &_GEANT_LISTS_LPRIN_LPRIN_20 };
static char *_GEANT_LISTS_LPRIN_guidance[] = {
 "The command PRIN is similar to the PRIN data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_LPRIN = { &_GEANT_LISTS_GEOM,
 "/GEANT/LISTS/LPRIN", "LPRIN", 0, 2, 20, 0, _GEANT_LISTS_LPRIN_parameters, 0,
 0, gxlist_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_LISTS_LPRIN_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_SETS_LSETS_1 = { "LSETS_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_2 = { "LSETS_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_3 = { "LSETS_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_4 = { "LSETS_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_5 = { "LSETS_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_6 = { "LSETS_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_7 = { "LSETS_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_8 = { "LSETS_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_9 = { "LSETS_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_10 = { "LSETS_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_11 = { "LSETS_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_12 = { "LSETS_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_13 = { "LSETS_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_14 = { "LSETS_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_15 = { "LSETS_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_16 = { "LSETS_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_17 = { "LSETS_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_18 = { "LSETS_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_19 = { "LSETS_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SETS_LSETS_20 = { "LSETS_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_SETS_parameters[] = {
 &_GEANT_LISTS_SETS_LSETS_1, &_GEANT_LISTS_SETS_LSETS_2,
 &_GEANT_LISTS_SETS_LSETS_3, &_GEANT_LISTS_SETS_LSETS_4,
 &_GEANT_LISTS_SETS_LSETS_5, &_GEANT_LISTS_SETS_LSETS_6,
 &_GEANT_LISTS_SETS_LSETS_7, &_GEANT_LISTS_SETS_LSETS_8,
 &_GEANT_LISTS_SETS_LSETS_9, &_GEANT_LISTS_SETS_LSETS_10,
 &_GEANT_LISTS_SETS_LSETS_11, &_GEANT_LISTS_SETS_LSETS_12,
 &_GEANT_LISTS_SETS_LSETS_13, &_GEANT_LISTS_SETS_LSETS_14,
 &_GEANT_LISTS_SETS_LSETS_15, &_GEANT_LISTS_SETS_LSETS_16,
 &_GEANT_LISTS_SETS_LSETS_17, &_GEANT_LISTS_SETS_LSETS_18,
 &_GEANT_LISTS_SETS_LSETS_19, &_GEANT_LISTS_SETS_LSETS_20 };
static char *_GEANT_LISTS_SETS_guidance[] = {
 "The command SETS is similar to the SETS data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_SETS = { &_GEANT_LISTS_LPRIN,
 "/GEANT/LISTS/SETS", "SETS", 0, 2, 20, 0, _GEANT_LISTS_SETS_parameters, 0, 0,
 gxlist_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_LISTS_SETS_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_SAVE_LSAVE_1 = { "LSAVE_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_2 = { "LSAVE_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_3 = { "LSAVE_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_4 = { "LSAVE_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_5 = { "LSAVE_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_6 = { "LSAVE_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_7 = { "LSAVE_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_8 = { "LSAVE_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_9 = { "LSAVE_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_10 = { "LSAVE_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_11 = { "LSAVE_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_12 = { "LSAVE_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_13 = { "LSAVE_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_14 = { "LSAVE_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_15 = { "LSAVE_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_16 = { "LSAVE_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_17 = { "LSAVE_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_18 = { "LSAVE_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_19 = { "LSAVE_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_SAVE_LSAVE_20 = { "LSAVE_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_SAVE_parameters[] = {
 &_GEANT_LISTS_SAVE_LSAVE_1, &_GEANT_LISTS_SAVE_LSAVE_2,
 &_GEANT_LISTS_SAVE_LSAVE_3, &_GEANT_LISTS_SAVE_LSAVE_4,
 &_GEANT_LISTS_SAVE_LSAVE_5, &_GEANT_LISTS_SAVE_LSAVE_6,
 &_GEANT_LISTS_SAVE_LSAVE_7, &_GEANT_LISTS_SAVE_LSAVE_8,
 &_GEANT_LISTS_SAVE_LSAVE_9, &_GEANT_LISTS_SAVE_LSAVE_10,
 &_GEANT_LISTS_SAVE_LSAVE_11, &_GEANT_LISTS_SAVE_LSAVE_12,
 &_GEANT_LISTS_SAVE_LSAVE_13, &_GEANT_LISTS_SAVE_LSAVE_14,
 &_GEANT_LISTS_SAVE_LSAVE_15, &_GEANT_LISTS_SAVE_LSAVE_16,
 &_GEANT_LISTS_SAVE_LSAVE_17, &_GEANT_LISTS_SAVE_LSAVE_18,
 &_GEANT_LISTS_SAVE_LSAVE_19, &_GEANT_LISTS_SAVE_LSAVE_20 };
static char *_GEANT_LISTS_SAVE_guidance[] = {
 "The command SAVE is similar to the SAVE data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_SAVE = { &_GEANT_LISTS_SETS,
 "/GEANT/LISTS/SAVE", "SAVE", 0, 2, 20, 0, _GEANT_LISTS_SAVE_parameters, 0, 0,
 gxlist_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_LISTS_SAVE_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_GET_LGET_1 = { "LGET_1", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_2 = { "LGET_2", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_3 = { "LGET_3", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_4 = { "LGET_4", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_5 = { "LGET_5", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_6 = { "LGET_6", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_7 = { "LGET_7", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_8 = { "LGET_8", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_9 = { "LGET_9", 6, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_10 = { "LGET_10", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_11 = { "LGET_11", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_12 = { "LGET_12", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_13 = { "LGET_13", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_14 = { "LGET_14", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_15 = { "LGET_15", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_16 = { "LGET_16", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_17 = { "LGET_17", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_18 = { "LGET_18", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_19 = { "LGET_19", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_GET_LGET_20 = { "LGET_20", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_GET_parameters[] = {
 &_GEANT_LISTS_GET_LGET_1, &_GEANT_LISTS_GET_LGET_2, &_GEANT_LISTS_GET_LGET_3,
 &_GEANT_LISTS_GET_LGET_4, &_GEANT_LISTS_GET_LGET_5, &_GEANT_LISTS_GET_LGET_6,
 &_GEANT_LISTS_GET_LGET_7, &_GEANT_LISTS_GET_LGET_8, &_GEANT_LISTS_GET_LGET_9,
 &_GEANT_LISTS_GET_LGET_10, &_GEANT_LISTS_GET_LGET_11,
 &_GEANT_LISTS_GET_LGET_12, &_GEANT_LISTS_GET_LGET_13,
 &_GEANT_LISTS_GET_LGET_14, &_GEANT_LISTS_GET_LGET_15,
 &_GEANT_LISTS_GET_LGET_16, &_GEANT_LISTS_GET_LGET_17,
 &_GEANT_LISTS_GET_LGET_18, &_GEANT_LISTS_GET_LGET_19,
 &_GEANT_LISTS_GET_LGET_20 };
static char *_GEANT_LISTS_GET_guidance[] = {
 "The command GET is similar to the GET data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_GET = { &_GEANT_LISTS_SAVE, "/GEANT/LISTS/GET",
 "GET", 0, 2, 20, 0, _GEANT_LISTS_GET_parameters, 0, 0, gxlist_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_LISTS_GET_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_LISTS_HSTA_LHSTA_1 = { "LHSTA_1", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_2 = { "LHSTA_2", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_3 = { "LHSTA_3", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_4 = { "LHSTA_4", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_5 = { "LHSTA_5", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_6 = { "LHSTA_6", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_7 = { "LHSTA_7", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_8 = { "LHSTA_8", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_9 = { "LHSTA_9", 7, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_10 = { "LHSTA_10", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_11 = { "LHSTA_11", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_12 = { "LHSTA_12", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_13 = { "LHSTA_13", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_14 = { "LHSTA_14", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_15 = { "LHSTA_15", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_16 = { "LHSTA_16", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_17 = { "LHSTA_17", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_18 = { "LHSTA_18", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_19 = { "LHSTA_19", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_LISTS_HSTA_LHSTA_20 = { "LHSTA_20", 8, "user word",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_LISTS_HSTA_parameters[] = {
 &_GEANT_LISTS_HSTA_LHSTA_1, &_GEANT_LISTS_HSTA_LHSTA_2,
 &_GEANT_LISTS_HSTA_LHSTA_3, &_GEANT_LISTS_HSTA_LHSTA_4,
 &_GEANT_LISTS_HSTA_LHSTA_5, &_GEANT_LISTS_HSTA_LHSTA_6,
 &_GEANT_LISTS_HSTA_LHSTA_7, &_GEANT_LISTS_HSTA_LHSTA_8,
 &_GEANT_LISTS_HSTA_LHSTA_9, &_GEANT_LISTS_HSTA_LHSTA_10,
 &_GEANT_LISTS_HSTA_LHSTA_11, &_GEANT_LISTS_HSTA_LHSTA_12,
 &_GEANT_LISTS_HSTA_LHSTA_13, &_GEANT_LISTS_HSTA_LHSTA_14,
 &_GEANT_LISTS_HSTA_LHSTA_15, &_GEANT_LISTS_HSTA_LHSTA_16,
 &_GEANT_LISTS_HSTA_LHSTA_17, &_GEANT_LISTS_HSTA_LHSTA_18,
 &_GEANT_LISTS_HSTA_LHSTA_19, &_GEANT_LISTS_HSTA_LHSTA_20 };
static char *_GEANT_LISTS_HSTA_guidance[] = {
 "The command HSTA is similar to the HSTA data records. It can accept",
 "up to 20 4-character words. If the first argument is '.', the number",
 "of words is reset to 0 and all the words to four blanks." };
static KmCommand _GEANT_LISTS_HSTA = { &_GEANT_LISTS_GET, "/GEANT/LISTS/HSTA",
 "HSTA", 0, 2, 20, 0, _GEANT_LISTS_HSTA_parameters, 0, 0, gxlist_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_LISTS_HSTA_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmMenu _GEANT_LISTS = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/LISTS",
 "LISTS", 2, &_GEANT_LISTS_HSTA, 0, (char**)0 };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_LISTS, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 921023 );
}
 
 
#ifdef F77_LCASE
#  define gkgeom_ gkgeom
#  define gxgeom_ gxgeom
#endif
 
#ifdef F77_UCASE
#  define gkgeom_ GKGEOM
#  define gxgeom_ GXGEOM
#endif
 
#ifdef IBM370
#  pragma linkage(GKGEOM,FORTRAN)
#  pragma linkage(GXGEOM,FORTRAN)
#endif
 
extern void gkgeom_();
extern void gxgeom_();
 
void gkgeom_()
{
 
static KmParInt    _GEANT_GEOMETRY_WEUCLID_LUN_type = { "1", "100", "1",
 "100", 0 };
static KmParameter _GEANT_GEOMETRY_WEUCLID_LUN = { "LUN", 3,
 "Logical unit of the file to be written", (char*)0, (char*)0, 4, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_GEOMETRY_WEUCLID_LUN_type };
static KmParameter _GEANT_GEOMETRY_WEUCLID_FNAME = { "FNAME", 5,
 "Name of the EUCLID file to be written", (char*)0, (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GEOMETRY_WEUCLID_TOPVOL = { "TOPVOL", 6,
 "Volume name of the starting node", (char*)0, (char*)0, 20, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_GEOMETRY_WEUCLID_NUMBER_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_WEUCLID_NUMBER = { "NUMBER", 6,
 "Copy number of TOPVOL (relevant for GSPOSP)", "1", (char*)0, 8, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_GEOMETRY_WEUCLID_NUMBER_type };
static KmParInt    _GEANT_GEOMETRY_WEUCLID_NLEVEL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_WEUCLID_NLEVEL = { "NLEVEL", 6,
 "Number of levels in the tree structure", "15", (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_WEUCLID_NLEVEL_type };
static KmParameter *_GEANT_GEOMETRY_WEUCLID_parameters[] = {
 &_GEANT_GEOMETRY_WEUCLID_LUN, &_GEANT_GEOMETRY_WEUCLID_FNAME,
 &_GEANT_GEOMETRY_WEUCLID_TOPVOL, &_GEANT_GEOMETRY_WEUCLID_NUMBER,
 &_GEANT_GEOMETRY_WEUCLID_NLEVEL };
static char *_GEANT_GEOMETRY_WEUCLID_guidance[] = {
 "          CALL GWEUCL(LUN,FNAME)",
 "Calls the routine to write the current GEANT geometry into an ASCII file",
 "in EUCLID compatible format." };
static KmCommand _GEANT_GEOMETRY_WEUCLID = {  (KmCommand*)0,
 "/GEANT/GEOMETRY/WEUCLID", "WEUCLID", 0, 2, 5, 3,
 _GEANT_GEOMETRY_WEUCLID_parameters, 0, 0, gxgeom_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_GEOMETRY_WEUCLID_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GEOMETRY_REUCLID_LUN_type = { "1", "100", "1",
 "100", 0 };
static KmParameter _GEANT_GEOMETRY_REUCLID_LUN = { "LUN", 3,
 "Logical unit of the file to be read", (char*)0, (char*)0, 4, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_REUCLID_LUN_type };
static KmParameter _GEANT_GEOMETRY_REUCLID_FNAME = { "FNAME", 5,
 "Name of the EUCLID file to be read", (char*)0, (char*)0, 20, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_GEOMETRY_REUCLID_parameters[] = {
 &_GEANT_GEOMETRY_REUCLID_LUN, &_GEANT_GEOMETRY_REUCLID_FNAME };
static char *_GEANT_GEOMETRY_REUCLID_guidance[] = {
 "          CALL GREUCL(LUN,FNAME)",
 "Calls the routine to read into GEANT a geometry from an ASCII file",
 "written by the EUCLID-GEANT interface." };
static KmCommand _GEANT_GEOMETRY_REUCLID = { &_GEANT_GEOMETRY_WEUCLID,
 "/GEANT/GEOMETRY/REUCLID", "REUCLID", 0, 2, 2, 2,
 _GEANT_GEOMETRY_REUCLID_parameters, 0, 0, gxgeom_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_GEOMETRY_REUCLID_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_GEOMETRY_CADINT_FNAME = { "FNAME", 5,
 "Name of the SET file", "example.set", (char*)0, 20, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GEOMETRY_CADINT_ANAME = { "ANAME", 5,
 "Name of the volume", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_GEOMETRY_CADINT_NBINS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_CADINT_NBINS = { "NBINS", 5,
 "Number of the instances", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_CADINT_NBINS_type };
static KmParInt    _GEANT_GEOMETRY_CADINT_LUNIT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_CADINT_LUNIT = { "LUNIT", 5,
 "Logical unit number for SET file", "66", (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_CADINT_LUNIT_type };
static KmParInt    _GEANT_GEOMETRY_CADINT_LUNIT2_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_CADINT_LUNIT2 = { "LUNIT2", 6,
 "Logical unit number for material file", "67", (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_CADINT_LUNIT2_type };
static KmParameter _GEANT_GEOMETRY_CADINT_INST = { "INST", 4,
 "Name of your institute", "CERN", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GEOMETRY_CADINT_SITE = { "SITE", 4, "Name of site",
 "MEYRIN", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GEOMETRY_CADINT_DEPT = { "DEPT", 4,
 "Name of departement", "CN", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GEOMETRY_CADINT_RESP = { "RESP", 4,
 "Name of sender", "god_knows_who", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_GEOMETRY_CADINT_parameters[] = {
 &_GEANT_GEOMETRY_CADINT_FNAME, &_GEANT_GEOMETRY_CADINT_ANAME,
 &_GEANT_GEOMETRY_CADINT_NBINS, &_GEANT_GEOMETRY_CADINT_LUNIT,
 &_GEANT_GEOMETRY_CADINT_LUNIT2, &_GEANT_GEOMETRY_CADINT_INST,
 &_GEANT_GEOMETRY_CADINT_SITE, &_GEANT_GEOMETRY_CADINT_DEPT,
 &_GEANT_GEOMETRY_CADINT_RESP };
static char *_GEANT_GEOMETRY_CADINT_guidance[] = {
 " CALL GTXSET(fname,aname,nbins,lunit,lunit2,inst,site,dept,resp)",
 "This command produces a SET file describing the given volume with",
 "the contents currently set visible. (Use the visibility attribute,",
 "see SATT SEEN.) The description is given as a flat assembly",
 "related to the global coordinate system.",
 "The ouput can be read into CAD systems (EUCLID-IS) trough a SET interface.",
 "A list of materials of the volumes in the SET file and the GEANT tree",
 "is written into a file with the same filename as the SET file,",
 "but with extension .mat." };
static KmCommand _GEANT_GEOMETRY_CADINT = { &_GEANT_GEOMETRY_REUCLID,
 "/GEANT/GEOMETRY/CADINT", "CADINT", 0, 2, 9, 9,
 _GEANT_GEOMETRY_CADINT_parameters, 0, 0, gxgeom_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 9, _GEANT_GEOMETRY_CADINT_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_GEOMETRY_EDITV_ISEL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_EDITV_ISEL = { "ISEL", 4, "Options", "0",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_GEOMETRY_EDITV_ISEL_type };
static KmParameter _GEANT_GEOMETRY_EDITV_NAME = { "NAME", 4, "Volume name",
 "   ", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParameter *_GEANT_GEOMETRY_EDITV_parameters[] = {
 &_GEANT_GEOMETRY_EDITV_ISEL, &_GEANT_GEOMETRY_EDITV_NAME };
static char *_GEANT_GEOMETRY_EDITV_guidance[] = { " CALL GEDITV(isel,name)",
 "When the routine prompts for input parameters that do not need",
 "to be changed, type return.",
 "ISEL is used to select the editing operation to be performed:",
 " ISEL=0, CALL GGCLOS",
 " ISEL=1, to modify shape parameters PAR given by GSVOLU",
 " ISEL=2, to modify NAME given by GSVOLU",
 " ISEL=3, to delete NAME given by GSVOLU",
 " ISEL=4, to unlink NAME,NR given by GSPOS/GSDVN/GSDV..",
 " ISEL=5, to modify X0,Y0,Z0 of NAME,NR given by GSPOS",
 " ISEL=6, to modify IROT of NAME,NR given by GSPOS",
 " ISEL=7, to modify NDIV given by GSDVN",
 " ISEL=8, to modify IAXIS given by GSDVN" };
static KmCommand _GEANT_GEOMETRY_EDITV = { &_GEANT_GEOMETRY_CADINT,
 "/GEANT/GEOMETRY/EDITV", "EDITV", 0, 2, 2, 0,
 _GEANT_GEOMETRY_EDITV_parameters, 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 13, _GEANT_GEOMETRY_EDITV_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static KmParInt    _GEANT_GEOMETRY_PTMED_NUMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_PTMED_NUMB = { "NUMB", 4, "Medium ID",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_GEOMETRY_PTMED_NUMB_type };
static KmParameter *_GEANT_GEOMETRY_PTMED_parameters[] = {
 &_GEANT_GEOMETRY_PTMED_NUMB };
static char *_GEANT_GEOMETRY_PTMED_guidance[] = { " CALL GPTMED(numb)",
 "Print tracking media's specifications." };
static KmCommand _GEANT_GEOMETRY_PTMED = { &_GEANT_GEOMETRY_EDITV,
 "/GEANT/GEOMETRY/PTMED", "PTMED", 0, 2, 1, 1,
 _GEANT_GEOMETRY_PTMED_parameters, 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 2, _GEANT_GEOMETRY_PTMED_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static KmParInt    _GEANT_GEOMETRY_STMED_NTMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_NTMED = { "NTMED", 5,
 "Tracking medium number", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_STMED_NTMED_type };
static KmParameter _GEANT_GEOMETRY_STMED_NAME = { "NAME", 4,
 "Tracking medium name", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_GEOMETRY_STMED_NMAT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_NMAT = { "NMAT", 4,
 "Material number", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_STMED_NMAT_type };
static KmParInt    _GEANT_GEOMETRY_STMED_ISVOL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_ISVOL = { "ISVOL", 5,
 "Sensitive volume flag", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_STMED_ISVOL_type };
static KmParInt    _GEANT_GEOMETRY_STMED_IFIELD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_IFIELD = { "IFIELD", 6,
 "Magnetic field", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_INT, &_GEANT_GEOMETRY_STMED_IFIELD_type };
static KmParReal   _GEANT_GEOMETRY_STMED_FIELDM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_FIELDM = { "FIELDM", 6,
 "Max. field value (Kilogauss)", "0", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_STMED_FIELDM_type };
static KmParReal   _GEANT_GEOMETRY_STMED_TMAXFD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_TMAXFD = { "TMAXFD", 6,
 "Max. angle due to field (deg/step)", "0.01", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_STMED_TMAXFD_type };
static KmParReal   _GEANT_GEOMETRY_STMED_STEMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_STEMAX = { "STEMAX", 6,
 "Max. step allowed", "1.E+10", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_STMED_STEMAX_type };
static KmParReal   _GEANT_GEOMETRY_STMED_DEEMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_DEEMAX = { "DEEMAX", 6,
 "Max. fraction of energy lost in a step", "0.01", (char*)0, 12, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_STMED_DEEMAX_type };
static KmParReal   _GEANT_GEOMETRY_STMED_EPSIL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_EPSIL = { "EPSIL", 5,
 "Tracking precision (cm)", "0.01", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_STMED_EPSIL_type };
static KmParReal   _GEANT_GEOMETRY_STMED_STMIN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_STMED_STMIN = { "STMIN", 5,
 "Min. step due to continuos processes (cm)", "0.1", (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_GEOMETRY_STMED_STMIN_type };
static KmParameter *_GEANT_GEOMETRY_STMED_parameters[] = {
 &_GEANT_GEOMETRY_STMED_NTMED, &_GEANT_GEOMETRY_STMED_NAME,
 &_GEANT_GEOMETRY_STMED_NMAT, &_GEANT_GEOMETRY_STMED_ISVOL,
 &_GEANT_GEOMETRY_STMED_IFIELD, &_GEANT_GEOMETRY_STMED_FIELDM,
 &_GEANT_GEOMETRY_STMED_TMAXFD, &_GEANT_GEOMETRY_STMED_STEMAX,
 &_GEANT_GEOMETRY_STMED_DEEMAX, &_GEANT_GEOMETRY_STMED_EPSIL,
 &_GEANT_GEOMETRY_STMED_STMIN };
static char *_GEANT_GEOMETRY_STMED_guidance[] = {
 "      CALL GSTMED(ntmed,name,nmat,isvol,ifield,fieldm,tmaxfd,",
 "     +            stemax,deemax,epsil,stmin,0,0)",
 "IFIELD = 0 if no magnetic field; IFIELD = -1 if user decision in GUSWIM;",
 "IFIELD = 1 if tracking performed with GRKUTA; IFIELD = 2 if tracking",
 "performed with GHELIX; IFIELD = 3 if tracking performed with GHELX3." };
static KmCommand _GEANT_GEOMETRY_STMED = { &_GEANT_GEOMETRY_PTMED,
 "/GEANT/GEOMETRY/STMED", "STMED", 0, 2, 11, 11,
 _GEANT_GEOMETRY_STMED_parameters, 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 5, _GEANT_GEOMETRY_STMED_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static KmParInt    _GEANT_GEOMETRY_PROTM_NUMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_PROTM_NUMB = { "NUMB", 4, "Matrix ID",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_GEOMETRY_PROTM_NUMB_type };
static KmParameter *_GEANT_GEOMETRY_PROTM_parameters[] = {
 &_GEANT_GEOMETRY_PROTM_NUMB };
static char *_GEANT_GEOMETRY_PROTM_guidance[] = { " CALL GPROTM(numb)",
 "Print matrixes' specifications." };
static KmCommand _GEANT_GEOMETRY_PROTM = { &_GEANT_GEOMETRY_STMED,
 "/GEANT/GEOMETRY/PROTM", "PROTM", 0, 2, 1, 1,
 _GEANT_GEOMETRY_PROTM_parameters, 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 2, _GEANT_GEOMETRY_PROTM_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static KmParInt    _GEANT_GEOMETRY_SROTM_IROT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SROTM_IROT = { "IROT", 4,
 "Rotation matrix number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_SROTM_IROT_type };
static KmParReal   _GEANT_GEOMETRY_SROTM_THETA1_type = { "0.", "180.", "0.",
 "180.", 0 };
static KmParameter _GEANT_GEOMETRY_SROTM_THETA1 = { "THETA1", 6,
 "Polar angle for axis I", "0.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_SROTM_THETA1_type };
static KmParReal   _GEANT_GEOMETRY_SROTM_PHI1_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_GEOMETRY_SROTM_PHI1 = { "PHI1", 4,
 "Azimuthal angle for axis I", "0.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_SROTM_PHI1_type };
static KmParReal   _GEANT_GEOMETRY_SROTM_THETA2_type = { "0.", "180.", "0.",
 "180.", 0 };
static KmParameter _GEANT_GEOMETRY_SROTM_THETA2 = { "THETA2", 6,
 "Polar angle for axis II", "0.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_SROTM_THETA2_type };
static KmParReal   _GEANT_GEOMETRY_SROTM_PHI2_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_GEOMETRY_SROTM_PHI2 = { "PHI2", 4,
 "Azimuthal angle for axis II", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_SROTM_PHI2_type };
static KmParReal   _GEANT_GEOMETRY_SROTM_THETA3_type = { "0.", "180.", "0.",
 "180.", 0 };
static KmParameter _GEANT_GEOMETRY_SROTM_THETA3 = { "THETA3", 6,
 "Polar angle for axis III", "0.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_SROTM_THETA3_type };
static KmParReal   _GEANT_GEOMETRY_SROTM_PHI3_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_GEOMETRY_SROTM_PHI3 = { "PHI3", 4,
 "Azimuthal angle for axis III", "0.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_GEOMETRY_SROTM_PHI3_type };
static KmParameter *_GEANT_GEOMETRY_SROTM_parameters[] = {
 &_GEANT_GEOMETRY_SROTM_IROT, &_GEANT_GEOMETRY_SROTM_THETA1,
 &_GEANT_GEOMETRY_SROTM_PHI1, &_GEANT_GEOMETRY_SROTM_THETA2,
 &_GEANT_GEOMETRY_SROTM_PHI2, &_GEANT_GEOMETRY_SROTM_THETA3,
 &_GEANT_GEOMETRY_SROTM_PHI3 };
static char *_GEANT_GEOMETRY_SROTM_guidance[] = {
 " CALL GSROTM(irot,theta1,phi1,theta2,phi2,theta3,phi3)",
 "It defines the rotation matrix number IROT." };
static KmCommand _GEANT_GEOMETRY_SROTM = { &_GEANT_GEOMETRY_PROTM,
 "/GEANT/GEOMETRY/SROTM", "SROTM", 0, 2, 7, 7,
 _GEANT_GEOMETRY_SROTM_parameters, 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 2, _GEANT_GEOMETRY_SROTM_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static KmParInt    _GEANT_GEOMETRY_PVOLU_NUMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_PVOLU_NUMB = { "NUMB", 4, "Volume ID",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_GEOMETRY_PVOLU_NUMB_type };
static KmParameter *_GEANT_GEOMETRY_PVOLU_parameters[] = {
 &_GEANT_GEOMETRY_PVOLU_NUMB };
static char *_GEANT_GEOMETRY_PVOLU_guidance[] = { " CALL GPVOLU(numb)",
 "Prints volumes' specifications." };
static KmCommand _GEANT_GEOMETRY_PVOLU = { &_GEANT_GEOMETRY_SROTM,
 "/GEANT/GEOMETRY/PVOLU", "PVOLU", 0, 2, 1, 1,
 _GEANT_GEOMETRY_PVOLU_parameters, 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 2, _GEANT_GEOMETRY_PVOLU_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static KmParameter _GEANT_GEOMETRY_SDVN_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GEOMETRY_SDVN_MOTHER = { "MOTHER", 6,
 "Mother volume name", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_GEOMETRY_SDVN_NDIV_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SDVN_NDIV = { "NDIV", 4,
 "Number of divisions", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_SDVN_NDIV_type };
static char *_GEANT_GEOMETRY_SDVN_CAXIS_range[] = { "X", "Y", "Z", "1", "2",
 "3" };
static char *_GEANT_GEOMETRY_SDVN_CAXIS_text[] = { (char*)0, (char*)0,
 (char*)0, (char*)0, (char*)0, (char*)0 };
static KmParOption _GEANT_GEOMETRY_SDVN_CAXIS_type = {
 _GEANT_GEOMETRY_SDVN_CAXIS_text, (int*)0, (int*)0 };
static KmParameter _GEANT_GEOMETRY_SDVN_CAXIS = { "CAXIS", 5, "Axis value",
 (char*)0, (char*)0, 8, 6, _GEANT_GEOMETRY_SDVN_CAXIS_range, 6,
 _GEANT_GEOMETRY_SDVN_CAXIS_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_GEOMETRY_SDVN_CAXIS_type };
static KmParameter *_GEANT_GEOMETRY_SDVN_parameters[] = {
 &_GEANT_GEOMETRY_SDVN_NAME, &_GEANT_GEOMETRY_SDVN_MOTHER,
 &_GEANT_GEOMETRY_SDVN_NDIV, &_GEANT_GEOMETRY_SDVN_CAXIS };
static char *_GEANT_GEOMETRY_SDVN_guidance[] = {
 " CALL GSDVN(name,mother,ndiv,iaxis)",
 "X,Y,Z of CAXIS will be translated to 1,2,3 for IAXIS.",
 "It divides a previously defined volume." };
static KmCommand _GEANT_GEOMETRY_SDVN = { &_GEANT_GEOMETRY_PVOLU,
 "/GEANT/GEOMETRY/SDVN", "SDVN", 0, 2, 4, 4, _GEANT_GEOMETRY_SDVN_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_GEOMETRY_SDVN_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_GEOMETRY_SPOS_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_GEOMETRY_SPOS_NUMBER_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SPOS_NUMBER = { "NUMBER", 6,
 "Copy number of the volume", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_SPOS_NUMBER_type };
static KmParameter _GEANT_GEOMETRY_SPOS_MOTHER = { "MOTHER", 6,
 "Mother volume name", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_GEOMETRY_SPOS_X0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SPOS_X0 = { "X0", 2,
 "X coord. of the volume in mother ref. sys.", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_GEOMETRY_SPOS_X0_type };
static KmParReal   _GEANT_GEOMETRY_SPOS_Y0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SPOS_Y0 = { "Y0", 2,
 "Y coord. of the volume in mother ref. sys.", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_GEOMETRY_SPOS_Y0_type };
static KmParReal   _GEANT_GEOMETRY_SPOS_Z0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SPOS_Z0 = { "Z0", 2,
 "Z coord. of the volume in mother ref. sys.", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_GEOMETRY_SPOS_Z0_type };
static KmParInt    _GEANT_GEOMETRY_SPOS_IROT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SPOS_IROT = { "IROT", 4,
 "Rotation matrix number w.r.t. mother ref. sys.", (char*)0, (char*)0, 8, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_GEOMETRY_SPOS_IROT_type };
static KmParameter _GEANT_GEOMETRY_SPOS_ONLY = { "ONLY", 4, "ONLY/MANY flag",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_GEOMETRY_SPOS_parameters[] = {
 &_GEANT_GEOMETRY_SPOS_NAME, &_GEANT_GEOMETRY_SPOS_NUMBER,
 &_GEANT_GEOMETRY_SPOS_MOTHER, &_GEANT_GEOMETRY_SPOS_X0,
 &_GEANT_GEOMETRY_SPOS_Y0, &_GEANT_GEOMETRY_SPOS_Z0,
 &_GEANT_GEOMETRY_SPOS_IROT, &_GEANT_GEOMETRY_SPOS_ONLY };
static char *_GEANT_GEOMETRY_SPOS_guidance[] = {
 " CALL GSPOS(name,number,mother,x0,y0,z0,irot,only)",
 "It positions a previously defined volume in the mother." };
static KmCommand _GEANT_GEOMETRY_SPOS = { &_GEANT_GEOMETRY_SDVN,
 "/GEANT/GEOMETRY/SPOS", "SPOS", 0, 2, 8, 8, _GEANT_GEOMETRY_SPOS_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_GEOMETRY_SPOS_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_GEOMETRY_SVOLU_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_GEOMETRY_SVOLU_SHAPE = { "SHAPE", 5, "Volume type",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_GEOMETRY_SVOLU_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SVOLU_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_SVOLU_NUMED_type };
static KmParInt    _GEANT_GEOMETRY_SVOLU_NPAR_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_SVOLU_NPAR = { "NPAR", 4,
 "Number of shape parameters", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_GEOMETRY_SVOLU_NPAR_type };
static KmParameter _GEANT_GEOMETRY_SVOLU_PAR = { "PAR", 3,
 "Vector containing shape parameters", (char*)0, (char*)0, 20, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_GEOMETRY_SVOLU_parameters[] = {
 &_GEANT_GEOMETRY_SVOLU_NAME, &_GEANT_GEOMETRY_SVOLU_SHAPE,
 &_GEANT_GEOMETRY_SVOLU_NUMED, &_GEANT_GEOMETRY_SVOLU_NPAR,
 &_GEANT_GEOMETRY_SVOLU_PAR };
static char *_GEANT_GEOMETRY_SVOLU_guidance[] = {
 " CALL GSVOLU(name,shape,numed,par,npar,ivolu)",
 "where par is a KUIP vector.",
 "It creates a new volume in the JVOLUM data structure." };
static KmCommand _GEANT_GEOMETRY_SVOLU = { &_GEANT_GEOMETRY_SPOS,
 "/GEANT/GEOMETRY/SVOLU", "SVOLU", 0, 2, 5, 5,
 _GEANT_GEOMETRY_SVOLU_parameters, 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 3, _GEANT_GEOMETRY_SVOLU_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static char *_GEANT_GEOMETRY_OPTI_IOPTI_range[] = { "-1", "2" };
static KmParInt    _GEANT_GEOMETRY_OPTI_IOPTI_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_GEOMETRY_OPTI_IOPTI = { "IOPTI", 5,
 "GSORD optimisation level", "0", (char*)0, 8, 2,
 _GEANT_GEOMETRY_OPTI_IOPTI_range, 2, _GEANT_GEOMETRY_OPTI_IOPTI_range,
 (KmParFlag)2, KmTYPE_INT, &_GEANT_GEOMETRY_OPTI_IOPTI_type };
static KmParameter *_GEANT_GEOMETRY_OPTI_parameters[] = {
 &_GEANT_GEOMETRY_OPTI_IOPTI };
static char *_GEANT_GEOMETRY_OPTI_guidance[] = {
 "This flag controls the tracking optimisation performed via the",
 "GSORD routine:", "    1 no optimisation at all; GSORD calls disabled;",
 "    0 no optimisation; only user calls to GSORD kept;",
 "    1 all non-GSORDered volumes are ordered along the best axis;",
 "    2 all volumes are ordered along the best axis." };
static KmCommand _GEANT_GEOMETRY_OPTI = { &_GEANT_GEOMETRY_SVOLU,
 "/GEANT/GEOMETRY/OPTI", "OPTI", 0, 2, 1, 1, _GEANT_GEOMETRY_OPTI_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 6,
 _GEANT_GEOMETRY_OPTI_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_SPARA_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_SPARA_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SPARA_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_SPARA_NUMED_type };
static KmParReal   _GEANT_CREATE_SPARA_HALFX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SPARA_HALFX = { "HALFX", 5, "Half X length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SPARA_HALFX_type };
static KmParReal   _GEANT_CREATE_SPARA_HALFY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SPARA_HALFY = { "HALFY", 5, "Half Y length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SPARA_HALFY_type };
static KmParReal   _GEANT_CREATE_SPARA_HALFZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SPARA_HALFZ = { "HALFZ", 5, "Half Z length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SPARA_HALFZ_type };
static KmParReal   _GEANT_CREATE_SPARA_AXIS_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_SPARA_AXIS = { "AXIS", 4,
 "Angle of Y mid-faces segment to Y axis", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CREATE_SPARA_AXIS_type };
static KmParReal   _GEANT_CREATE_SPARA_PHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_SPARA_PHI = { "PHI", 3,
 "PHI angle of Low Z mid-face to High Z mid-face segment", (char*)0, (char*)0,
 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CREATE_SPARA_PHI_type };
static KmParReal   _GEANT_CREATE_SPARA_THETA_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_SPARA_THETA = { "THETA", 5,
 "THETA angle of mid-low-Z-face to mid-high-Z-face segment", (char*)0,
 (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CREATE_SPARA_THETA_type };
static char *_GEANT_CREATE_SPARA_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_SPARA_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_SPARA_YESNO_type = {
 _GEANT_CREATE_SPARA_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_SPARA_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_SPARA_YESNO_range, 2,
 _GEANT_CREATE_SPARA_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_SPARA_YESNO_type };
static KmParameter *_GEANT_CREATE_SPARA_parameters[] = {
 &_GEANT_CREATE_SPARA_NAME, &_GEANT_CREATE_SPARA_NUMED,
 &_GEANT_CREATE_SPARA_HALFX, &_GEANT_CREATE_SPARA_HALFY,
 &_GEANT_CREATE_SPARA_HALFZ, &_GEANT_CREATE_SPARA_AXIS,
 &_GEANT_CREATE_SPARA_PHI, &_GEANT_CREATE_SPARA_THETA,
 &_GEANT_CREATE_SPARA_YESNO };
static KmCommand _GEANT_CREATE_SPARA = {  (KmCommand*)0,
 "/GEANT/CREATE/SPARA", "SPARA", 0, 2, 9, 8, _GEANT_CREATE_SPARA_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_SSPHE_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_SSPHE_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SSPHE_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_SSPHE_NUMED_type };
static KmParReal   _GEANT_CREATE_SSPHE_INRAD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SSPHE_INRAD = { "INRAD", 5, "Inside Radius",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SSPHE_INRAD_type };
static KmParReal   _GEANT_CREATE_SSPHE_OUTRAD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SSPHE_OUTRAD = { "OUTRAD", 6,
 "Outside Radius", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SSPHE_OUTRAD_type };
static KmParReal   _GEANT_CREATE_SSPHE_SPHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_SSPHE_SPHI = { "SPHI", 4,
 "Start of section PHI", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SSPHE_SPHI_type };
static KmParReal   _GEANT_CREATE_SSPHE_EPHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_SSPHE_EPHI = { "EPHI", 4,
 "End of section PHI", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SSPHE_EPHI_type };
static KmParReal   _GEANT_CREATE_SSPHE_STHETA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SSPHE_STHETA = { "STHETA", 6,
 "Start of section THETA", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SSPHE_STHETA_type };
static KmParReal   _GEANT_CREATE_SSPHE_ETHETA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SSPHE_ETHETA = { "ETHETA", 6,
 "End of section THETA", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SSPHE_ETHETA_type };
static char *_GEANT_CREATE_SSPHE_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_SSPHE_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_SSPHE_YESNO_type = {
 _GEANT_CREATE_SSPHE_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_SSPHE_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_SSPHE_YESNO_range, 2,
 _GEANT_CREATE_SSPHE_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_SSPHE_YESNO_type };
static KmParameter *_GEANT_CREATE_SSPHE_parameters[] = {
 &_GEANT_CREATE_SSPHE_NAME, &_GEANT_CREATE_SSPHE_NUMED,
 &_GEANT_CREATE_SSPHE_INRAD, &_GEANT_CREATE_SSPHE_OUTRAD,
 &_GEANT_CREATE_SSPHE_SPHI, &_GEANT_CREATE_SSPHE_EPHI,
 &_GEANT_CREATE_SSPHE_STHETA, &_GEANT_CREATE_SSPHE_ETHETA,
 &_GEANT_CREATE_SSPHE_YESNO };
static KmCommand _GEANT_CREATE_SSPHE = { &_GEANT_CREATE_SPARA,
 "/GEANT/CREATE/SSPHE", "SSPHE", 0, 2, 9, 8, _GEANT_CREATE_SSPHE_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_SCONS_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_SCONS_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONS_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_SCONS_NUMED_type };
static KmParReal   _GEANT_CREATE_SCONS_INRDW_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONS_INRDW = { "INRDW", 5,
 "Inside Radius in Lower Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONS_INRDW_type };
static KmParReal   _GEANT_CREATE_SCONS_OUTRDW_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONS_OUTRDW = { "OUTRDW", 6,
 "Outside Radius in Lower Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONS_OUTRDW_type };
static KmParReal   _GEANT_CREATE_SCONS_INRUP_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONS_INRUP = { "INRUP", 5,
 "Inside Radius in Upper Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONS_INRUP_type };
static KmParReal   _GEANT_CREATE_SCONS_OUTRUP_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONS_OUTRUP = { "OUTRUP", 6,
 "Outside Radius in Upper Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONS_OUTRUP_type };
static KmParReal   _GEANT_CREATE_SCONS_HALFZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONS_HALFZ = { "HALFZ", 5, "Half Z length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SCONS_HALFZ_type };
static KmParReal   _GEANT_CREATE_SCONS_SPHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_SCONS_SPHI = { "SPHI", 4,
 "Start of section PHI", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONS_SPHI_type };
static KmParReal   _GEANT_CREATE_SCONS_EPHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_SCONS_EPHI = { "EPHI", 4,
 "End of section PHI", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONS_EPHI_type };
static char *_GEANT_CREATE_SCONS_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_SCONS_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_SCONS_YESNO_type = {
 _GEANT_CREATE_SCONS_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_SCONS_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_SCONS_YESNO_range, 2,
 _GEANT_CREATE_SCONS_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_SCONS_YESNO_type };
static KmParameter *_GEANT_CREATE_SCONS_parameters[] = {
 &_GEANT_CREATE_SCONS_NAME, &_GEANT_CREATE_SCONS_NUMED,
 &_GEANT_CREATE_SCONS_INRDW, &_GEANT_CREATE_SCONS_OUTRDW,
 &_GEANT_CREATE_SCONS_INRUP, &_GEANT_CREATE_SCONS_OUTRUP,
 &_GEANT_CREATE_SCONS_HALFZ, &_GEANT_CREATE_SCONS_SPHI,
 &_GEANT_CREATE_SCONS_EPHI, &_GEANT_CREATE_SCONS_YESNO };
static KmCommand _GEANT_CREATE_SCONS = { &_GEANT_CREATE_SSPHE,
 "/GEANT/CREATE/SCONS", "SCONS", 0, 2, 10, 9, _GEANT_CREATE_SCONS_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_SCONE_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_SCONE_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONE_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_SCONE_NUMED_type };
static KmParReal   _GEANT_CREATE_SCONE_INRDW_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONE_INRDW = { "INRDW", 5,
 "Inside Radius in Lower Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONE_INRDW_type };
static KmParReal   _GEANT_CREATE_SCONE_OUTRDW_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONE_OUTRDW = { "OUTRDW", 6,
 "Outside Radius in Lower Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONE_OUTRDW_type };
static KmParReal   _GEANT_CREATE_SCONE_INRUP_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONE_INRUP = { "INRUP", 5,
 "Inside Radius in Upper Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONE_INRUP_type };
static KmParReal   _GEANT_CREATE_SCONE_OUTRUP_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONE_OUTRUP = { "OUTRUP", 6,
 "Outside Radius in Upper Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_SCONE_OUTRUP_type };
static KmParReal   _GEANT_CREATE_SCONE_HALFZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SCONE_HALFZ = { "HALFZ", 5, "Half Z length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SCONE_HALFZ_type };
static char *_GEANT_CREATE_SCONE_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_SCONE_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_SCONE_YESNO_type = {
 _GEANT_CREATE_SCONE_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_SCONE_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_SCONE_YESNO_range, 2,
 _GEANT_CREATE_SCONE_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_SCONE_YESNO_type };
static KmParameter *_GEANT_CREATE_SCONE_parameters[] = {
 &_GEANT_CREATE_SCONE_NAME, &_GEANT_CREATE_SCONE_NUMED,
 &_GEANT_CREATE_SCONE_INRDW, &_GEANT_CREATE_SCONE_OUTRDW,
 &_GEANT_CREATE_SCONE_INRUP, &_GEANT_CREATE_SCONE_OUTRUP,
 &_GEANT_CREATE_SCONE_HALFZ, &_GEANT_CREATE_SCONE_YESNO };
static KmCommand _GEANT_CREATE_SCONE = { &_GEANT_CREATE_SCONS,
 "/GEANT/CREATE/SCONE", "SCONE", 0, 2, 8, 7, _GEANT_CREATE_SCONE_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_STUBS_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_STUBS_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STUBS_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_STUBS_NUMED_type };
static KmParReal   _GEANT_CREATE_STUBS_INRAD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STUBS_INRAD = { "INRAD", 5, "Inside Radius",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_STUBS_INRAD_type };
static KmParReal   _GEANT_CREATE_STUBS_OUTRAD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STUBS_OUTRAD = { "OUTRAD", 6,
 "Outside Radius", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STUBS_OUTRAD_type };
static KmParReal   _GEANT_CREATE_STUBS_HALFZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STUBS_HALFZ = { "HALFZ", 5, "Half Z length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_STUBS_HALFZ_type };
static KmParReal   _GEANT_CREATE_STUBS_SPHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_STUBS_SPHI = { "SPHI", 4,
 "Start of section PHI", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STUBS_SPHI_type };
static KmParReal   _GEANT_CREATE_STUBS_EPHI_type = { "0.", "360.", "0.",
 "360.", 0 };
static KmParameter _GEANT_CREATE_STUBS_EPHI = { "EPHI", 4,
 "End of section PHI", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STUBS_EPHI_type };
static char *_GEANT_CREATE_STUBS_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_STUBS_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_STUBS_YESNO_type = {
 _GEANT_CREATE_STUBS_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_STUBS_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_STUBS_YESNO_range, 2,
 _GEANT_CREATE_STUBS_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_STUBS_YESNO_type };
static KmParameter *_GEANT_CREATE_STUBS_parameters[] = {
 &_GEANT_CREATE_STUBS_NAME, &_GEANT_CREATE_STUBS_NUMED,
 &_GEANT_CREATE_STUBS_INRAD, &_GEANT_CREATE_STUBS_OUTRAD,
 &_GEANT_CREATE_STUBS_HALFZ, &_GEANT_CREATE_STUBS_SPHI,
 &_GEANT_CREATE_STUBS_EPHI, &_GEANT_CREATE_STUBS_YESNO };
static KmCommand _GEANT_CREATE_STUBS = { &_GEANT_CREATE_SCONE,
 "/GEANT/CREATE/STUBS", "STUBS", 0, 2, 8, 7, _GEANT_CREATE_STUBS_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_STUBE_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_STUBE_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STUBE_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_STUBE_NUMED_type };
static KmParReal   _GEANT_CREATE_STUBE_INRAD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STUBE_INRAD = { "INRAD", 5, "Inside Radius",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_STUBE_INRAD_type };
static KmParReal   _GEANT_CREATE_STUBE_OUTRAD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STUBE_OUTRAD = { "OUTRAD", 6,
 "Outside Radius", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STUBE_OUTRAD_type };
static KmParReal   _GEANT_CREATE_STUBE_HALFZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STUBE_HALFZ = { "HALFZ", 5, "Half Z length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_STUBE_HALFZ_type };
static char *_GEANT_CREATE_STUBE_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_STUBE_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_STUBE_YESNO_type = {
 _GEANT_CREATE_STUBE_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_STUBE_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_STUBE_YESNO_range, 2,
 _GEANT_CREATE_STUBE_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_STUBE_YESNO_type };
static KmParameter *_GEANT_CREATE_STUBE_parameters[] = {
 &_GEANT_CREATE_STUBE_NAME, &_GEANT_CREATE_STUBE_NUMED,
 &_GEANT_CREATE_STUBE_INRAD, &_GEANT_CREATE_STUBE_OUTRAD,
 &_GEANT_CREATE_STUBE_HALFZ, &_GEANT_CREATE_STUBE_YESNO };
static KmCommand _GEANT_CREATE_STUBE = { &_GEANT_CREATE_STUBS,
 "/GEANT/CREATE/STUBE", "STUBE", 0, 2, 6, 5, _GEANT_CREATE_STUBE_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_STRD2_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_STRD2_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD2_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_STRD2_NUMED_type };
static KmParReal   _GEANT_CREATE_STRD2_HLFDWX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD2_HLFDWX = { "HLFDWX", 6,
 "Half X length in Lower Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STRD2_HLFDWX_type };
static KmParReal   _GEANT_CREATE_STRD2_HLFUPX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD2_HLFUPX = { "HLFUPX", 6,
 "Half X length in Upper Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STRD2_HLFUPX_type };
static KmParReal   _GEANT_CREATE_STRD2_HLFDWY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD2_HLFDWY = { "HLFDWY", 6,
 "Half Y length in Lower Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STRD2_HLFDWY_type };
static KmParReal   _GEANT_CREATE_STRD2_HLFUPY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD2_HLFUPY = { "HLFUPY", 6,
 "Half Y length in Upper Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STRD2_HLFUPY_type };
static KmParReal   _GEANT_CREATE_STRD2_HALFZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD2_HALFZ = { "HALFZ", 5, "Half Z length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_STRD2_HALFZ_type };
static char *_GEANT_CREATE_STRD2_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_STRD2_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_STRD2_YESNO_type = {
 _GEANT_CREATE_STRD2_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_STRD2_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_STRD2_YESNO_range, 2,
 _GEANT_CREATE_STRD2_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_STRD2_YESNO_type };
static KmParameter *_GEANT_CREATE_STRD2_parameters[] = {
 &_GEANT_CREATE_STRD2_NAME, &_GEANT_CREATE_STRD2_NUMED,
 &_GEANT_CREATE_STRD2_HLFDWX, &_GEANT_CREATE_STRD2_HLFUPX,
 &_GEANT_CREATE_STRD2_HLFDWY, &_GEANT_CREATE_STRD2_HLFUPY,
 &_GEANT_CREATE_STRD2_HALFZ, &_GEANT_CREATE_STRD2_YESNO };
static KmCommand _GEANT_CREATE_STRD2 = { &_GEANT_CREATE_STUBE,
 "/GEANT/CREATE/STRD2", "STRD2", 0, 2, 8, 7, _GEANT_CREATE_STRD2_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_STRD1_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_STRD1_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD1_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_STRD1_NUMED_type };
static KmParReal   _GEANT_CREATE_STRD1_HLFDWX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD1_HLFDWX = { "HLFDWX", 6,
 "Half X length in Lower Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STRD1_HLFDWX_type };
static KmParReal   _GEANT_CREATE_STRD1_HLFUPX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD1_HLFUPX = { "HLFUPX", 6,
 "Half X length in Upper Z Surface", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CREATE_STRD1_HLFUPX_type };
static KmParReal   _GEANT_CREATE_STRD1_HALFY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD1_HALFY = { "HALFY", 5, "Half Y length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_STRD1_HALFY_type };
static KmParReal   _GEANT_CREATE_STRD1_HALFZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_STRD1_HALFZ = { "HALFZ", 5, "Half Z length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_STRD1_HALFZ_type };
static char *_GEANT_CREATE_STRD1_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_STRD1_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_STRD1_YESNO_type = {
 _GEANT_CREATE_STRD1_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_STRD1_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_STRD1_YESNO_range, 2,
 _GEANT_CREATE_STRD1_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_STRD1_YESNO_type };
static KmParameter *_GEANT_CREATE_STRD1_parameters[] = {
 &_GEANT_CREATE_STRD1_NAME, &_GEANT_CREATE_STRD1_NUMED,
 &_GEANT_CREATE_STRD1_HLFDWX, &_GEANT_CREATE_STRD1_HLFUPX,
 &_GEANT_CREATE_STRD1_HALFY, &_GEANT_CREATE_STRD1_HALFZ,
 &_GEANT_CREATE_STRD1_YESNO };
static KmCommand _GEANT_CREATE_STRD1 = { &_GEANT_CREATE_STRD2,
 "/GEANT/CREATE/STRD1", "STRD1", 0, 2, 7, 6, _GEANT_CREATE_STRD1_parameters,
 0, 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CREATE_SBOX_NAME = { "NAME", 4, "Volume name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CREATE_SBOX_NUMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SBOX_NUMED = { "NUMED", 5,
 "Tracking medium number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CREATE_SBOX_NUMED_type };
static KmParReal   _GEANT_CREATE_SBOX_HALFX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SBOX_HALFX = { "HALFX", 5, "Half X length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SBOX_HALFX_type };
static KmParReal   _GEANT_CREATE_SBOX_HALFY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SBOX_HALFY = { "HALFY", 5, "Half Y length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SBOX_HALFY_type };
static KmParReal   _GEANT_CREATE_SBOX_HALFZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CREATE_SBOX_HALFZ = { "HALFZ", 5, "Half Z length",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CREATE_SBOX_HALFZ_type };
static char *_GEANT_CREATE_SBOX_YESNO_range[] = { "YES", "NO" };
static char *_GEANT_CREATE_SBOX_YESNO_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CREATE_SBOX_YESNO_type = {
 _GEANT_CREATE_SBOX_YESNO_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CREATE_SBOX_YESNO = { "YESNO", 5, "GSPOSP option",
 "NO", (char*)0, 8, 2, _GEANT_CREATE_SBOX_YESNO_range, 2,
 _GEANT_CREATE_SBOX_YESNO_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CREATE_SBOX_YESNO_type };
static KmParameter *_GEANT_CREATE_SBOX_parameters[] = {
 &_GEANT_CREATE_SBOX_NAME, &_GEANT_CREATE_SBOX_NUMED,
 &_GEANT_CREATE_SBOX_HALFX, &_GEANT_CREATE_SBOX_HALFY,
 &_GEANT_CREATE_SBOX_HALFZ, &_GEANT_CREATE_SBOX_YESNO };
static KmCommand _GEANT_CREATE_SBOX = { &_GEANT_CREATE_STRD1,
 "/GEANT/CREATE/SBOX", "SBOX", 0, 2, 6, 5, _GEANT_CREATE_SBOX_parameters, 0,
 0, gxgeom_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 0, (char**)0, 0,
 (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_CREATE_guidance[] = {
 "It creates volumes of the given shape interactively.",
 "CALL GSVOLU(name,shape,numed,par,npar,ivolu)", "where par is a KUIP vector"
 };
static KmMenu _GEANT_CREATE = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/CREATE",
 "CREATE", 2, &_GEANT_CREATE_SBOX, 3, _GEANT_CREATE_guidance };
 
static char *_GEANT_GEOMETRY_guidance[] = { "Geometry commands." };
static KmMenu _GEANT_GEOMETRY = { &_GEANT_CREATE,  (KmMenu*)0,
 "/GEANT/GEOMETRY", "GEOMETRY", 2, &_GEANT_GEOMETRY_OPTI, 1,
 _GEANT_GEOMETRY_guidance };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_GEOMETRY, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 921023 );
}
 
 
#ifdef F77_LCASE
#  define gkcont_ gkcont
#  define gxcont_ gxcont
#endif
 
#ifdef F77_UCASE
#  define gkcont_ GKCONT
#  define gxcont_ GXCONT
#endif
 
#ifdef IBM370
#  pragma linkage(GKCONT,FORTRAN)
#  pragma linkage(GXCONT,FORTRAN)
#endif
 
extern void gkcont_();
extern void gxcont_();
 
void gkcont_()
{
 
static char *_GEANT_CONTROL_DEBUG_IDEB_range[] = { "ON", "OFF" };
static char *_GEANT_CONTROL_DEBUG_IDEB_text[] = { (char*)0, (char*)0 };
static KmParOption _GEANT_CONTROL_DEBUG_IDEB_type = {
 _GEANT_CONTROL_DEBUG_IDEB_text, (int*)0, (int*)0 };
static KmParameter _GEANT_CONTROL_DEBUG_IDEB = { "IDEB", 4, "Debug option",
 "ON", (char*)0, 8, 2, _GEANT_CONTROL_DEBUG_IDEB_range, 2,
 _GEANT_CONTROL_DEBUG_IDEB_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_CONTROL_DEBUG_IDEB_type };
static KmParameter *_GEANT_CONTROL_DEBUG_parameters[] = {
 &_GEANT_CONTROL_DEBUG_IDEB };
static char *_GEANT_CONTROL_DEBUG_guidance[] = { "If ideb='ON  ' then :",
 " idebug=1, idemin=1, idemax=1000000, itime=1", "else :",
 " idebug=0, idemin=0, idemax=0" };
static KmCommand _GEANT_CONTROL_DEBUG = {  (KmCommand*)0,
 "/GEANT/CONTROL/DEBUG", "DEBUG", 0, 2, 1, 0, _GEANT_CONTROL_DEBUG_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_CONTROL_DEBUG_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_PRKINE_NUMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PRKINE_NUMB = { "NUMB", 4, "Track number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_PRKINE_NUMB_type };
static KmParameter *_GEANT_CONTROL_PRKINE_parameters[] = {
 &_GEANT_CONTROL_PRKINE_NUMB };
static char *_GEANT_CONTROL_PRKINE_guidance[] = { "CALL GPKINE(numb)" };
static KmCommand _GEANT_CONTROL_PRKINE = { &_GEANT_CONTROL_DEBUG,
 "/GEANT/CONTROL/PRKINE", "PRKINE", 0, 2, 1, 1,
 _GEANT_CONTROL_PRKINE_parameters, 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 1, _GEANT_CONTROL_PRKINE_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static KmParInt    _GEANT_CONTROL_PPART_NUMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PPART_NUMB = { "NUMB", 4, "Particle number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_PPART_NUMB_type };
static KmParameter *_GEANT_CONTROL_PPART_parameters[] = {
 &_GEANT_CONTROL_PPART_NUMB };
static char *_GEANT_CONTROL_PPART_guidance[] = { "CALL GPPART(numb)" };
static KmCommand _GEANT_CONTROL_PPART = { &_GEANT_CONTROL_PRKINE,
 "/GEANT/CONTROL/PPART", "PPART", 0, 2, 1, 1, _GEANT_CONTROL_PPART_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_PPART_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_SPART_IPART_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_IPART = { "IPART", 5,
 "Particle number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_SPART_IPART_type };
static KmParameter _GEANT_CONTROL_SPART_NAPART = { "NAPART", 6,
 "Particle name", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CONTROL_SPART_ITRTYP_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_ITRTYP = { "ITRTYP", 6, " ", (char*)0,
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_SPART_ITRTYP_type };
static KmParReal   _GEANT_CONTROL_SPART_AMASS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_AMASS = { "AMASS", 5, "Mass",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SPART_AMASS_type };
static KmParReal   _GEANT_CONTROL_SPART_CHARGE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_CHARGE = { "CHARGE", 6, "Charge",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SPART_CHARGE_type };
static KmParReal   _GEANT_CONTROL_SPART_TLIFE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_TLIFE = { "TLIFE", 5, "Lifetime",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SPART_TLIFE_type };
static KmParReal   _GEANT_CONTROL_SPART_UBUF_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_UBUF = { "UBUF", 4, " ", (char*)0,
 (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CONTROL_SPART_UBUF_type };
static KmParInt    _GEANT_CONTROL_SPART_NWBUF_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_NWBUF = { "NWBUF", 5, " ", (char*)0,
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_SPART_NWBUF_type };
static KmParReal   _GEANT_CONTROL_SPART_BRATIO_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_BRATIO = { "BRATIO", 6,
 "Branching ratios", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CONTROL_SPART_BRATIO_type };
static KmParInt    _GEANT_CONTROL_SPART_MODE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SPART_MODE = { "MODE", 4, "Decay mode",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_SPART_MODE_type };
static KmParameter *_GEANT_CONTROL_SPART_parameters[] = {
 &_GEANT_CONTROL_SPART_IPART, &_GEANT_CONTROL_SPART_NAPART,
 &_GEANT_CONTROL_SPART_ITRTYP, &_GEANT_CONTROL_SPART_AMASS,
 &_GEANT_CONTROL_SPART_CHARGE, &_GEANT_CONTROL_SPART_TLIFE,
 &_GEANT_CONTROL_SPART_UBUF, &_GEANT_CONTROL_SPART_NWBUF,
 &_GEANT_CONTROL_SPART_BRATIO, &_GEANT_CONTROL_SPART_MODE };
static char *_GEANT_CONTROL_SPART_guidance[] = {
 "CALL GSPART(ipart,napart,itrtyp,amass,charge,tlife,ubuf,nwbuf);",
 "CALL GSDK(ipart,bratio,mode)" };
static KmCommand _GEANT_CONTROL_SPART = { &_GEANT_CONTROL_PPART,
 "/GEANT/CONTROL/SPART", "SPART", 0, 2, 10, 10,
 _GEANT_CONTROL_SPART_parameters, 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 2, _GEANT_CONTROL_SPART_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static KmParInt    _GEANT_CONTROL_STPAR_ITMED_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_STPAR_ITMED = { "ITMED", 5, "Medium number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_STPAR_ITMED_type };
static KmParameter _GEANT_CONTROL_STPAR_CHPAR = { "CHPAR", 5,
 "Cut or mechanism", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_CONTROL_STPAR_PARVAL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_STPAR_PARVAL = { "PARVAL", 6, "Value",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_STPAR_PARVAL_type };
static KmParameter *_GEANT_CONTROL_STPAR_parameters[] = {
 &_GEANT_CONTROL_STPAR_ITMED, &_GEANT_CONTROL_STPAR_CHPAR,
 &_GEANT_CONTROL_STPAR_PARVAL };
static char *_GEANT_CONTROL_STPAR_guidance[] = {
 "CALL GSTPAR(itmed,chpar,parval)" };
static KmCommand _GEANT_CONTROL_STPAR = { &_GEANT_CONTROL_SPART,
 "/GEANT/CONTROL/STPAR", "STPAR", 0, 2, 3, 3, _GEANT_CONTROL_STPAR_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_STPAR_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_DRMAT_IMATE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_DRMAT_IMATE = { "IMATE", 5,
 "Material number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_DRMAT_IMATE_type };
static KmParInt    _GEANT_CONTROL_DRMAT_IPART_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_DRMAT_IPART = { "IPART", 5,
 "Particle number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_DRMAT_IPART_type };
static KmParameter _GEANT_CONTROL_DRMAT_MECAN = { "MECAN", 5,
 "List of mechanism", "ALL", (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_CONTROL_DRMAT_parameters[] = {
 &_GEANT_CONTROL_DRMAT_IMATE, &_GEANT_CONTROL_DRMAT_IPART,
 &_GEANT_CONTROL_DRMAT_MECAN };
static char *_GEANT_CONTROL_DRMAT_guidance[] = {
 "CALL GDRMAT(imate,ipart,mecan,nmec)",
 "If MECAN = 'ALL' all the mechanisms are plotted. If the material number",
 "is negative, the cross sections relative to material ABS(IMATE) will",
 "be plotted in barns rather than in 1/cm.",
 "Note that it is not possible to plot anything if GSTMED has not been\
 called", "for the material number IMATE." };
static KmCommand _GEANT_CONTROL_DRMAT = { &_GEANT_CONTROL_STPAR,
 "/GEANT/CONTROL/DRMAT", "DRMAT", 0, 2, 3, 2, _GEANT_CONTROL_DRMAT_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 6,
 _GEANT_CONTROL_DRMAT_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_PLMAT_IMATE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PLMAT_IMATE = { "IMATE", 5,
 "Material number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_PLMAT_IMATE_type };
static KmParInt    _GEANT_CONTROL_PLMAT_IPART_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PLMAT_IPART = { "IPART", 5,
 "Particle number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_PLMAT_IPART_type };
static KmParameter _GEANT_CONTROL_PLMAT_MECAN = { "MECAN", 5, "Mechanism",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CONTROL_PLMAT_IDM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PLMAT_IDM = { "IDM", 3, "ID mode option",
 "0", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_PLMAT_IDM_type };
static KmParameter *_GEANT_CONTROL_PLMAT_parameters[] = {
 &_GEANT_CONTROL_PLMAT_IMATE, &_GEANT_CONTROL_PLMAT_IPART,
 &_GEANT_CONTROL_PLMAT_MECAN, &_GEANT_CONTROL_PLMAT_IDM };
static char *_GEANT_CONTROL_PLMAT_guidance[] = {
 "CALL GPLMAT(imate,ipart,mecan,nekbin,elow,idm)",
 " IDM convention for histogramming mode :",
 " IDM.gt.0  fill, print,   keep   histogram(s)",
 " IDM.eq.0  fill, print,   delete histogram(s)",
 " IDM.lt.0  fill, noprint, keep   histogram(s)",
 "If MECAN = 'ALL' all the mechanisms are histogrammed. If the material\
 number",
 "is negative, the cross sections relative to material ABS(IMATE) will",
 "be histogrammed in barns rather than in 1/cm." };
static KmCommand _GEANT_CONTROL_PLMAT = { &_GEANT_CONTROL_DRMAT,
 "/GEANT/CONTROL/PLMAT", "PLMAT", 0, 2, 4, 3, _GEANT_CONTROL_PLMAT_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 8,
 _GEANT_CONTROL_PLMAT_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_PRMAT_IMATE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PRMAT_IMATE = { "IMATE", 5,
 "Material number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_PRMAT_IMATE_type };
static KmParInt    _GEANT_CONTROL_PRMAT_IPART_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PRMAT_IPART = { "IPART", 5,
 "Particle number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_PRMAT_IPART_type };
static KmParameter _GEANT_CONTROL_PRMAT_MECAN = { "MECAN", 5, "Mechanism",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_CONTROL_PRMAT_parameters[] = {
 &_GEANT_CONTROL_PRMAT_IMATE, &_GEANT_CONTROL_PRMAT_IPART,
 &_GEANT_CONTROL_PRMAT_MECAN };
static char *_GEANT_CONTROL_PRMAT_guidance[] = {
 " CALL GPRMAT(imate,ipart,mecan,nekbin,elow)" };
static KmCommand _GEANT_CONTROL_PRMAT = { &_GEANT_CONTROL_PLMAT,
 "/GEANT/CONTROL/PRMAT", "PRMAT", 0, 2, 3, 3, _GEANT_CONTROL_PRMAT_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_PRMAT_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_PMATE_NUMB_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PMATE_NUMB = { "NUMB", 4, "Material number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_PMATE_NUMB_type };
static KmParameter *_GEANT_CONTROL_PMATE_parameters[] = {
 &_GEANT_CONTROL_PMATE_NUMB };
static char *_GEANT_CONTROL_PMATE_guidance[] = { " CALL GPMATE(numb)" };
static KmCommand _GEANT_CONTROL_PMATE = { &_GEANT_CONTROL_PRMAT,
 "/GEANT/CONTROL/PMATE", "PMATE", 0, 2, 1, 1, _GEANT_CONTROL_PMATE_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_PMATE_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_SMIXT_IMAT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMIXT_IMAT = { "IMAT", 4, "Material number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_SMIXT_IMAT_type };
static KmParameter _GEANT_CONTROL_SMIXT_NAMATE = { "NAMATE", 6,
 "Material name", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_CONTROL_SMIXT_A_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMIXT_A = { "A", 1, "Atomic weight",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SMIXT_A_type };
static KmParReal   _GEANT_CONTROL_SMIXT_Z_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMIXT_Z = { "Z", 1, "Atomic number",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SMIXT_Z_type };
static KmParReal   _GEANT_CONTROL_SMIXT_DENS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMIXT_DENS = { "DENS", 4, "Density",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SMIXT_DENS_type };
static KmParInt    _GEANT_CONTROL_SMIXT_NLMAT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMIXT_NLMAT = { "NLMAT", 5, "Flag for WMAT",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_SMIXT_NLMAT_type };
static KmParReal   _GEANT_CONTROL_SMIXT_WMAT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMIXT_WMAT = { "WMAT", 4,
 "Relative weights or n. of atoms in molecule", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CONTROL_SMIXT_WMAT_type };
static KmParameter *_GEANT_CONTROL_SMIXT_parameters[] = {
 &_GEANT_CONTROL_SMIXT_IMAT, &_GEANT_CONTROL_SMIXT_NAMATE,
 &_GEANT_CONTROL_SMIXT_A, &_GEANT_CONTROL_SMIXT_Z, &_GEANT_CONTROL_SMIXT_DENS,
 &_GEANT_CONTROL_SMIXT_NLMAT, &_GEANT_CONTROL_SMIXT_WMAT };
static char *_GEANT_CONTROL_SMIXT_guidance[] = {
 " CALL GSMIXT(imat,namate,a,z,dens,nlmat,wmat)" };
static KmCommand _GEANT_CONTROL_SMIXT = { &_GEANT_CONTROL_PMATE,
 "/GEANT/CONTROL/SMIXT", "SMIXT", 0, 2, 7, 7, _GEANT_CONTROL_SMIXT_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_SMIXT_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_SMATE_IMAT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMATE_IMAT = { "IMAT", 4, "Material number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_SMATE_IMAT_type };
static KmParameter _GEANT_CONTROL_SMATE_NAMATE = { "NAMATE", 6,
 "Material name", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParReal   _GEANT_CONTROL_SMATE_A_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMATE_A = { "A", 1, "Atomic weight",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SMATE_A_type };
static KmParReal   _GEANT_CONTROL_SMATE_Z_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMATE_Z = { "Z", 1, "Atomic number",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SMATE_Z_type };
static KmParReal   _GEANT_CONTROL_SMATE_DENS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMATE_DENS = { "DENS", 4, "Density",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_SMATE_DENS_type };
static KmParReal   _GEANT_CONTROL_SMATE_RADL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMATE_RADL = { "RADL", 4,
 "Radiation lenght", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CONTROL_SMATE_RADL_type };
static KmParReal   _GEANT_CONTROL_SMATE_ABSL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMATE_ABSL = { "ABSL", 4,
 "Absorption lenght", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_CONTROL_SMATE_ABSL_type };
static KmParReal   _GEANT_CONTROL_SMATE_UBUF_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMATE_UBUF = { "UBUF", 4, " ", (char*)0,
 (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CONTROL_SMATE_UBUF_type };
static KmParInt    _GEANT_CONTROL_SMATE_NWBUF_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SMATE_NWBUF = { "NWBUF", 5, " ", (char*)0,
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_SMATE_NWBUF_type };
static KmParameter *_GEANT_CONTROL_SMATE_parameters[] = {
 &_GEANT_CONTROL_SMATE_IMAT, &_GEANT_CONTROL_SMATE_NAMATE,
 &_GEANT_CONTROL_SMATE_A, &_GEANT_CONTROL_SMATE_Z, &_GEANT_CONTROL_SMATE_DENS,
 &_GEANT_CONTROL_SMATE_RADL, &_GEANT_CONTROL_SMATE_ABSL,
 &_GEANT_CONTROL_SMATE_UBUF, &_GEANT_CONTROL_SMATE_NWBUF };
static char *_GEANT_CONTROL_SMATE_guidance[] = {
 " CALL GSMATE(imat,namate,a,z,dens,radl,absl,ubuf,nwbuf)" };
static KmCommand _GEANT_CONTROL_SMATE = { &_GEANT_CONTROL_SMIXT,
 "/GEANT/CONTROL/SMATE", "SMATE", 0, 2, 9, 9, _GEANT_CONTROL_SMATE_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_SMATE_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CONTROL_PDIGI_CHUSET = { "CHUSET", 6, "User set",
 "*", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParameter _GEANT_CONTROL_PDIGI_CHUDET = { "CHUDET", 6,
 "User detector", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_CONTROL_PDIGI_parameters[] = {
 &_GEANT_CONTROL_PDIGI_CHUSET, &_GEANT_CONTROL_PDIGI_CHUDET };
static char *_GEANT_CONTROL_PDIGI_guidance[] = { " CALL GPDIGI(chuset,chudet)"
 };
static KmCommand _GEANT_CONTROL_PDIGI = { &_GEANT_CONTROL_SMATE,
 "/GEANT/CONTROL/PDIGI", "PDIGI", 0, 2, 2, 0, _GEANT_CONTROL_PDIGI_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_PDIGI_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CONTROL_PHITS_CHUSET = { "CHUSET", 6, "User set",
 "*", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParameter _GEANT_CONTROL_PHITS_CHUDET = { "CHUDET", 6,
 "User detector", "*", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_CONTROL_PHITS_NUMHI_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PHITS_NUMHI = { "NUMHI", 5, "Hit number",
 "0", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_PHITS_NUMHI_type };
static KmParameter *_GEANT_CONTROL_PHITS_parameters[] = {
 &_GEANT_CONTROL_PHITS_CHUSET, &_GEANT_CONTROL_PHITS_CHUDET,
 &_GEANT_CONTROL_PHITS_NUMHI };
static char *_GEANT_CONTROL_PHITS_guidance[] = { " CALL GPHITS(chuset,chudet)"
 };
static KmCommand _GEANT_CONTROL_PHITS = { &_GEANT_CONTROL_PDIGI,
 "/GEANT/CONTROL/PHITS", "PHITS", 0, 2, 3, 0, _GEANT_CONTROL_PHITS_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_PHITS_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_OUTPUT_LP_LOUT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_OUTPUT_LP_LOUT = { "LOUT", 4,
 "New output unit", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_OUTPUT_LP_LOUT_type };
static KmParameter *_GEANT_CONTROL_OUTPUT_LP_parameters[] = {
 &_GEANT_CONTROL_OUTPUT_LP_LOUT };
static char *_GEANT_CONTROL_OUTPUT_LP_guidance[] = {
 "To change lout in /GCUNIT/",
 "Note: unit numbers 5,11,12,13,14,15 are reserved and cannot be used." };
static KmCommand _GEANT_CONTROL_OUTPUT_LP = { &_GEANT_CONTROL_PHITS,
 "/GEANT/CONTROL/OUTPUT_LP", "OUTPUT_LP", 0, 2, 1, 1,
 _GEANT_CONTROL_OUTPUT_LP_parameters, 0, 0, gxcont_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_CONTROL_OUTPUT_LP_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_CONTROL_PRINT_NAME = { "NAME", 4, "Name", (char*)0,
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParInt    _GEANT_CONTROL_PRINT_NUMBER_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_PRINT_NUMBER = { "NUMBER", 6, "Number", "0",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_PRINT_NUMBER_type };
static KmParameter *_GEANT_CONTROL_PRINT_parameters[] = {
 &_GEANT_CONTROL_PRINT_NAME, &_GEANT_CONTROL_PRINT_NUMBER };
static char *_GEANT_CONTROL_PRINT_guidance[] = { " CALL GPRINT(name,number)" };
static KmCommand _GEANT_CONTROL_PRINT = { &_GEANT_CONTROL_OUTPUT_LP,
 "/GEANT/CONTROL/PRINT", "PRINT", 0, 2, 2, 2, _GEANT_CONTROL_PRINT_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_PRINT_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_MZLOGL_LEVEL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_MZLOGL_LEVEL = { "LEVEL", 5, "MZ log level",
 "0", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_MZLOGL_LEVEL_type };
static KmParameter *_GEANT_CONTROL_MZLOGL_parameters[] = {
 &_GEANT_CONTROL_MZLOGL_LEVEL };
static char *_GEANT_CONTROL_MZLOGL_guidance[] = {
 "Set the log level for the MZ package of ZEBRA: CALL MZLOGL(0,level)",
 " LEVEL = -3   no messages at all", "         -2   error messages only",
 "         -1   terse logging", "          0   normal",
 "         +1   log rare events", "         +2   log calls to MZ routines" };
static KmCommand _GEANT_CONTROL_MZLOGL = { &_GEANT_CONTROL_PRINT,
 "/GEANT/CONTROL/MZLOGL", "MZLOGL", 0, 2, 1, 1,
 _GEANT_CONTROL_MZLOGL_parameters, 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 7, _GEANT_CONTROL_MZLOGL_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static KmParInt    _GEANT_CONTROL_SWITCH_ISWI_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SWITCH_ISWI = { "ISWI", 4, "Switch number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_SWITCH_ISWI_type };
static KmParInt    _GEANT_CONTROL_SWITCH_IVAL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SWITCH_IVAL = { "IVAL", 4,
 "New switch value", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_SWITCH_IVAL_type };
static KmParameter *_GEANT_CONTROL_SWITCH_parameters[] = {
 &_GEANT_CONTROL_SWITCH_ISWI, &_GEANT_CONTROL_SWITCH_IVAL };
static char *_GEANT_CONTROL_SWITCH_guidance[] = {
 "Change one element of array ISWIT(10) in /GCFLAG/" };
static KmCommand _GEANT_CONTROL_SWITCH = { &_GEANT_CONTROL_MZLOGL,
 "/GEANT/CONTROL/SWITCH", "SWITCH", 0, 2, 2, 2,
 _GEANT_CONTROL_SWITCH_parameters, 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 1, _GEANT_CONTROL_SWITCH_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static KmParInt    _GEANT_CONTROL_RNDM_ISEED1_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_RNDM_ISEED1 = { "ISEED1", 6,
 "First seed for the random number generator", (char*)0, (char*)0, 8, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_RNDM_ISEED1_type };
static KmParInt    _GEANT_CONTROL_RNDM_ISEED2_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_RNDM_ISEED2 = { "ISEED2", 6,
 "Second seed for the random number generator", (char*)0, (char*)0, 8, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_RNDM_ISEED2_type };
static KmParameter *_GEANT_CONTROL_RNDM_parameters[] = {
 &_GEANT_CONTROL_RNDM_ISEED1, &_GEANT_CONTROL_RNDM_ISEED2 };
static char *_GEANT_CONTROL_RNDM_guidance[] = {
 "Set the seeds for the random number generator. If no numbers are",
 "given, the currents seeds are printed." };
static KmCommand _GEANT_CONTROL_RNDM = { &_GEANT_CONTROL_SWITCH,
 "/GEANT/CONTROL/RNDM", "RNDM", 0, 2, 2, 0, _GEANT_CONTROL_RNDM_parameters, 0,
 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_CONTROL_RNDM_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_TRIGGER_N_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_TRIGGER_N = { "N", 1, "Number of events",
 "1", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_TRIGGER_N_type };
static KmParameter *_GEANT_CONTROL_TRIGGER_parameters[] = {
 &_GEANT_CONTROL_TRIGGER_N };
static char *_GEANT_CONTROL_TRIGGER_guidance[] = {
 "Start one or more new events." };
static KmCommand _GEANT_CONTROL_TRIGGER = { &_GEANT_CONTROL_RNDM,
 "/GEANT/CONTROL/TRIGGER", "TRIGGER", 0, 2, 1, 0,
 _GEANT_CONTROL_TRIGGER_parameters, 0, 0, gxcont_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 1, _GEANT_CONTROL_TRIGGER_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_CONTROL_TRACK_guidance[] = {
 "Restart tracking, clearing the track and hit",
 "banks, but keeping the kinematics." };
static KmCommand _GEANT_CONTROL_TRACK = { &_GEANT_CONTROL_TRIGGER,
 "/GEANT/CONTROL/TRACK", "TRACK", 0, 2, 0, 0, (KmParameter**)0, 0, 0, gxcont_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_CONTROL_TRACK_guidance,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_CONTROL_GTIME_TIMINT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_GTIME_TIMINT = { "TIMINT", 6,
 "Total time after initialisation", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_CONTROL_GTIME_TIMINT_type };
static KmParReal   _GEANT_CONTROL_GTIME_TIMEND_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_GTIME_TIMEND = { "TIMEND", 6,
 "Time reserved for the termination phase", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_CONTROL_GTIME_TIMEND_type };
static KmParInt    _GEANT_CONTROL_GTIME_ITIME_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_GTIME_ITIME = { "ITIME", 5,
 "Frequency of control printing", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_GTIME_ITIME_type };
static KmParameter *_GEANT_CONTROL_GTIME_parameters[] = {
 &_GEANT_CONTROL_GTIME_TIMINT, &_GEANT_CONTROL_GTIME_TIMEND,
 &_GEANT_CONTROL_GTIME_ITIME };
static char *_GEANT_CONTROL_GTIME_guidance[] = {
 "These commands have limited use in the interactive version. In",
 "particular the value of TIMINT is disregarded by GEANT." };
static KmCommand _GEANT_CONTROL_GTIME = { &_GEANT_CONTROL_TRACK,
 "/GEANT/CONTROL/GTIME", "GTIME", 0, 2, 3, 3, _GEANT_CONTROL_GTIME_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_CONTROL_GTIME_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_CONTROL_SORD_ISTORD_range[] = { "1", "0" };
static KmParInt    _GEANT_CONTROL_SORD_ISTORD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_SORD_ISTORD = { "ISTORD", 6,
 "Flag to control user ordering of the stack", "1", (char*)0, 8, 2,
 _GEANT_CONTROL_SORD_ISTORD_range, 2, _GEANT_CONTROL_SORD_ISTORD_range,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_SORD_ISTORD_type };
static KmParameter *_GEANT_CONTROL_SORD_parameters[] = {
 &_GEANT_CONTROL_SORD_ISTORD };
static char *_GEANT_CONTROL_SORD_guidance[] = {
 "If ISTORD is set to 1, the particle with the highest value of the",
 "user weight UPWGHT will be selected to be tracked next." };
static KmCommand _GEANT_CONTROL_SORD = { &_GEANT_CONTROL_GTIME,
 "/GEANT/CONTROL/SORD", "SORD", 0, 2, 1, 1, _GEANT_CONTROL_SORD_parameters, 0,
 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_CONTROL_SORD_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_RUNG_IDRUN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_RUNG_IDRUN = { "IDRUN", 5,
 "User run number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_RUNG_IDRUN_type };
static KmParInt    _GEANT_CONTROL_RUNG_IDEVT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_RUNG_IDEVT = { "IDEVT", 5,
 "User starting event number", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_CONTROL_RUNG_IDEVT_type };
static KmParameter *_GEANT_CONTROL_RUNG_parameters[] = {
 &_GEANT_CONTROL_RUNG_IDRUN, &_GEANT_CONTROL_RUNG_IDEVT };
static char *_GEANT_CONTROL_RUNG_guidance[] = {
 "Set the run number and the starting value for the user event number." };
static KmCommand _GEANT_CONTROL_RUNG = { &_GEANT_CONTROL_SORD,
 "/GEANT/CONTROL/RUNG", "RUNG", 0, 2, 2, 2, _GEANT_CONTROL_RUNG_parameters, 0,
 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_RUNG_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_CONTROL_KINE_IKINE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_IKINE = { "IKINE", 5, "IKINE", "1",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_CONTROL_KINE_IKINE_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE1_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE1 = { "PKINE1", 6, "PKINE(1)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE1_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE2_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE2 = { "PKINE2", 6, "PKINE(2)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE2_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE3_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE3 = { "PKINE3", 6, "PKINE(3)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE3_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE4_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE4 = { "PKINE4", 6, "PKINE(4)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE4_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE5_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE5 = { "PKINE5", 6, "PKINE(5)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE5_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE6_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE6 = { "PKINE6", 6, "PKINE(6)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE6_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE7_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE7 = { "PKINE7", 6, "PKINE(7)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE7_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE8_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE8 = { "PKINE8", 6, "PKINE(8)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE8_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE9_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE9 = { "PKINE9", 6, "PKINE(9)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE9_type };
static KmParReal   _GEANT_CONTROL_KINE_PKINE10_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_CONTROL_KINE_PKINE10 = { "PKINE10", 7, "PKINE(10)",
 (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_REAL, &_GEANT_CONTROL_KINE_PKINE10_type };
static KmParameter *_GEANT_CONTROL_KINE_parameters[] = {
 &_GEANT_CONTROL_KINE_IKINE, &_GEANT_CONTROL_KINE_PKINE1,
 &_GEANT_CONTROL_KINE_PKINE2, &_GEANT_CONTROL_KINE_PKINE3,
 &_GEANT_CONTROL_KINE_PKINE4, &_GEANT_CONTROL_KINE_PKINE5,
 &_GEANT_CONTROL_KINE_PKINE6, &_GEANT_CONTROL_KINE_PKINE7,
 &_GEANT_CONTROL_KINE_PKINE8, &_GEANT_CONTROL_KINE_PKINE9,
 &_GEANT_CONTROL_KINE_PKINE10 };
static char *_GEANT_CONTROL_KINE_guidance[] = {
 "Set the variables in /GCFLAG/ IKINE, PKINE(10)" };
static KmCommand _GEANT_CONTROL_KINE = { &_GEANT_CONTROL_RUNG,
 "/GEANT/CONTROL/KINE", "KINE", 0, 2, 11, 1, _GEANT_CONTROL_KINE_parameters,
 0, 0, gxcont_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_CONTROL_KINE_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_CONTROL_guidance[] = { "Control commands." };
static KmMenu _GEANT_CONTROL = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/CONTROL",
 "CONTROL", 2, &_GEANT_CONTROL_KINE, 1, _GEANT_CONTROL_guidance };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_CONTROL, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 921023 );
}
 
 
#ifdef F77_LCASE
#  define gkdz_ gkdz
#  define gxdz_ gxdz
#endif
 
#ifdef F77_UCASE
#  define gkdz_ GKDZ
#  define gxdz_ GXDZ
#endif
 
#ifdef IBM370
#  pragma linkage(GKDZ,FORTRAN)
#  pragma linkage(GXDZ,FORTRAN)
#endif
 
extern void gkdz_();
extern void gxdz_();
 
void gkdz_()
{
 
static KmParameter _GEANT_DZ_DIRZ_PATH = { "PATH", 4,
 "Name of the RZ directory to analyse", (char*)0, (char*)0, 20, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_DZ_DIRZ_parameters[] = { &_GEANT_DZ_DIRZ_PATH };
static char *_GEANT_DZ_DIRZ_guidance[] = {
 "Facility to display RZ directory trees.",
 " CALL DZDIRZ(0,LDUMMY,0,path,'N',1,0,1)" };
static KmCommand _GEANT_DZ_DIRZ = {  (KmCommand*)0, "/GEANT/DZ/DIRZ", "DIRZ",
 0, 2, 1, 0, _GEANT_DZ_DIRZ_parameters, 0, 0, gxdz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_DZ_DIRZ_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_DZ_DISP_BANK = { "BANK", 4, "Name of the bank",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_DZ_DISP_PATH = { "PATH", 4, "Name of the doc file",
 " ", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParInt    _GEANT_DZ_DISP_NUMBER_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DZ_DISP_NUMBER = { "NUMBER", 6,
 "Number of the bank", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_DZ_DISP_NUMBER_type };
static KmParameter *_GEANT_DZ_DISP_parameters[] = { &_GEANT_DZ_DISP_BANK,
 &_GEANT_DZ_DISP_PATH, &_GEANT_DZ_DISP_NUMBER };
static char *_GEANT_DZ_DISP_guidance[] = { "Interactive bank display tool.",
 " CALL DZDISP(IXSTOR,LBANK,path,'N',1,0,1,IWTYPE)" };
static KmCommand _GEANT_DZ_DISP = { &_GEANT_DZ_DIRZ, "/GEANT/DZ/DISP", "DISP",
 0, 2, 3, 1, _GEANT_DZ_DISP_parameters, 0, 0, gxdz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_DZ_DISP_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DZ_DDIV_IDIV_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_DZ_DDIV_IDIV = { "IDIV", 4, "Division number", "2",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DZ_DDIV_IDIV_type };
static KmParameter _GEANT_DZ_DDIV_PATH = { "PATH", 4, "Name of the doc file",
 " ", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParameter *_GEANT_DZ_DDIV_parameters[] = { &_GEANT_DZ_DDIV_IDIV,
 &_GEANT_DZ_DDIV_PATH };
static char *_GEANT_DZ_DDIV_guidance[] = {
 "Facility to display the layout of stores and divisions.",
 " CALL DZDDIV(idiv,LDUMMY,path,'IN',1,0,1,IWTYPE)" };
static KmCommand _GEANT_DZ_DDIV = { &_GEANT_DZ_DISP, "/GEANT/DZ/DDIV", "DDIV",
 0, 2, 2, 0, _GEANT_DZ_DDIV_parameters, 0, 0, gxdz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_DZ_DDIV_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DZ_STORE_IXSTOR_type = { "0", "24", "0", "24", 0 };
static KmParameter _GEANT_DZ_STORE_IXSTOR = { "IXSTOR", 6, "Store number",
 "0", (char*)0, 3, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DZ_STORE_IXSTOR_type };
static KmParameter *_GEANT_DZ_STORE_parameters[] = { &_GEANT_DZ_STORE_IXSTOR };
static char *_GEANT_DZ_STORE_guidance[] = {
 "Display the structure of the ZEBRA store IXSTOR.",
 "Output the parameters characterizing the store, followed by a",
 "list of all divisions and all link areas associated with the store in",
 "question." };
static KmCommand _GEANT_DZ_STORE = { &_GEANT_DZ_DDIV, "/GEANT/DZ/STORE",
 "STORE", 0, 2, 1, 0, _GEANT_DZ_STORE_parameters, 0, 0, gxdz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 4, _GEANT_DZ_STORE_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DZ_VERIFY_IDIV_type = { "0", "24", "0", "24", 0 };
static KmParameter _GEANT_DZ_VERIFY_IDIV = { "IDIV", 4, "Division number ",
 "0", (char*)0, 3, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DZ_VERIFY_IDIV_type };
static KmParOption _GEANT_DZ_VERIFY_CHOPT_type = { (char**)0, (int*)0, (int*)0
 };
static KmParameter _GEANT_DZ_VERIFY_CHOPT = { "CHOPT", 5, "Options", "CLSU",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_DZ_VERIFY_CHOPT_type };
static KmParameter *_GEANT_DZ_VERIFY_parameters[] = { &_GEANT_DZ_VERIFY_IDIV,
 &_GEANT_DZ_VERIFY_CHOPT };
static char *_GEANT_DZ_VERIFY_guidance[] = {
 "Check the structure of one or more ZEBRA divisions.",
 "The verification detail depends on the settings in CHOPT.",
 " CHOPT='C' Check chaining of banks only",
 " CHOPT='L' Check validity of the structural links (implies 'C')",
 " CHOPT='S' Check the store parameters",
 " CHOPT='U' Check the validity of the up and origin (implies 'C')",
 " CHOPT='F' Errors are considered fatal and generate a call to ZFATAL" };
static KmCommand _GEANT_DZ_VERIFY = { &_GEANT_DZ_STORE, "/GEANT/DZ/VERIFY",
 "VERIFY", 0, 2, 2, 0, _GEANT_DZ_VERIFY_parameters, 0, 0, gxdz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 7, _GEANT_DZ_VERIFY_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_DZ_SNAP_IDIV_type = { "0", "24", "0", "24", 0 };
static KmParameter _GEANT_DZ_SNAP_IDIV = { "IDIV", 4, "Division number ", "2",
 (char*)0, 3, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DZ_SNAP_IDIV_type };
static KmParOption _GEANT_DZ_SNAP_CHOPT_type = { (char**)0, (int*)0, (int*)0 };
static KmParameter _GEANT_DZ_SNAP_CHOPT = { "CHOPT", 5, "Options", "M",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_DZ_SNAP_CHOPT_type };
static KmParameter *_GEANT_DZ_SNAP_parameters[] = { &_GEANT_DZ_SNAP_IDIV,
 &_GEANT_DZ_SNAP_CHOPT };
static char *_GEANT_DZ_SNAP_guidance[] = { "Snap of one or more divisions.",
 "Provides a snapshot of one or more divisions in a ZEBRA store.",
 "The kind of information provided is controlled by CHOPT.",
 " CHOPT='M' Print Map entry for each bank",
 " CHOPT='E' Extend map entry to dump all links of each bank",
 "           (otherwise only as many links as will fit on a line)",
 " CHOPT='F' Full. Dump all active banks, links and data",
 " CHOPT='K' Kill. Dropped banks to be treated as active",
 "           (dropped banks are not normally dumped under D or F option)",
 " CHOPT='L' Dump all Link areas associated with the store",
 " CHOPT='W' Dump the Working space, links and data",
 " CHOPT='Z' Dump the information in hexadecimal." };
static KmCommand _GEANT_DZ_SNAP = { &_GEANT_DZ_VERIFY, "/GEANT/DZ/SNAP",
 "SNAP", 0, 2, 2, 0, _GEANT_DZ_SNAP_parameters, 0, 0, gxdz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 12, _GEANT_DZ_SNAP_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_DZ_SHOW_NAME = { "NAME", 4, "Bank name", (char*)0,
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParInt    _GEANT_DZ_SHOW_NUMBER_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DZ_SHOW_NUMBER = { "NUMBER", 6, "Bank number", "1",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DZ_SHOW_NUMBER_type };
static KmParOption _GEANT_DZ_SHOW_CHOPT_type = { (char**)0, (int*)0, (int*)0 };
static KmParameter _GEANT_DZ_SHOW_CHOPT = { "CHOPT", 5, "Options", "BSV",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_DZ_SHOW_CHOPT_type };
static KmParameter *_GEANT_DZ_SHOW_parameters[] = { &_GEANT_DZ_SHOW_NAME,
 &_GEANT_DZ_SHOW_NUMBER, &_GEANT_DZ_SHOW_CHOPT };
static char *_GEANT_DZ_SHOW_guidance[] = {
 "Display the contents of a bank or a data structure",
 "identified by its NAME and NUMBER.",
 "The output format of the data part is controlled by the internal",
 "or external I/O characteristic.", " CHOPT='B' Print the bank.",
 " CHOPT='S' Print the bank contents from left to right Sideways",
 "           with up to ten elements per line.",
 " CHOPT='V' Print the vertical (down) structure.",
 " CHOPT='D' Print the bank contents from top to bottom Downwards",
 "           with five elements per line.",
 " CHOPT='L' Print the linear structure.",
 " CHOPT='Z' Print the data part of each bank in hexadecimal format" };
static KmCommand _GEANT_DZ_SHOW = { &_GEANT_DZ_SNAP, "/GEANT/DZ/SHOW", "SHOW",
 0, 2, 3, 1, _GEANT_DZ_SHOW_parameters, 0, 0, gxdz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 12, _GEANT_DZ_SHOW_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_DZ_SURV_NAME = { "NAME", 4, "Bank name", (char*)0,
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParInt    _GEANT_DZ_SURV_NUMBER_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_DZ_SURV_NUMBER = { "NUMBER", 6, "Bank number", "1",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_DZ_SURV_NUMBER_type };
static KmParameter *_GEANT_DZ_SURV_parameters[] = { &_GEANT_DZ_SURV_NAME,
 &_GEANT_DZ_SURV_NUMBER };
static char *_GEANT_DZ_SURV_guidance[] = {
 "Print a survey of the structure identified by NAME, NUMBER." };
static KmCommand _GEANT_DZ_SURV = { &_GEANT_DZ_SHOW, "/GEANT/DZ/SURV", "SURV",
 0, 2, 2, 1, _GEANT_DZ_SURV_parameters, 0, 0, gxdz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 1, _GEANT_DZ_SURV_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmMenu _GEANT_DZ = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/DZ", "DZ", 2,
 &_GEANT_DZ_SURV, 0, (char**)0 };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_DZ, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 921023 );
}
 
 
#ifdef F77_LCASE
#  define gkfz_ gkfz
#  define gxfz_ gxfz
#endif
 
#ifdef F77_UCASE
#  define gkfz_ GKFZ
#  define gxfz_ GXFZ
#endif
 
#ifdef IBM370
#  pragma linkage(GKFZ,FORTRAN)
#  pragma linkage(GXFZ,FORTRAN)
#endif
 
extern void gkfz_();
extern void gxfz_();
 
void gkfz_()
{
 
static KmParInt    _GEANT_FZ_FZCLOSE_LUN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_FZ_FZCLOSE_LUN = { "LUN", 3,
 "Fortran unit of the FZ to close", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_FZ_FZCLOSE_LUN_type };
static KmParameter *_GEANT_FZ_FZCLOSE_parameters[] = { &_GEANT_FZ_FZCLOSE_LUN
 };
static char *_GEANT_FZ_FZCLOSE_guidance[] = { "Equivalent to a call to:",
 "       CALL GCLOSE(LUN,IER)" };
static KmCommand _GEANT_FZ_FZCLOSE = {  (KmCommand*)0, "/GEANT/FZ/FZCLOSE",
 "FZCLOSE", 0, 2, 1, 1, _GEANT_FZ_FZCLOSE_parameters, 0, 0, gxfz_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_FZ_FZCLOSE_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_FZ_FZOUT_LUN_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_FZ_FZOUT_LUN = { "LUN", 3,
 "Fortran unit of the FZ file", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_FZ_FZOUT_LUN_type };
static KmParameter _GEANT_FZ_FZOUT_KEYSU = { "KEYSU", 5,
 "Name of the data structure to be saved", (char*)0, (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_FZ_FZOUT_IDENT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_FZ_FZOUT_IDENT = { "IDENT", 5,
 "Version of the data structure to be saved", "1", (char*)0, 8, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_FZ_FZOUT_IDENT_type };
static KmParameter *_GEANT_FZ_FZOUT_parameters[] = { &_GEANT_FZ_FZOUT_LUN,
 &_GEANT_FZ_FZOUT_KEYSU, &_GEANT_FZ_FZOUT_IDENT };
static char *_GEANT_FZ_FZOUT_guidance[] = { "Equivalent to a call to:",
 "       CALL GFOUT(LUN,KEYSU,1,IDENT,' ',IER)" };
static KmCommand _GEANT_FZ_FZOUT = { &_GEANT_FZ_FZCLOSE, "/GEANT/FZ/FZOUT",
 "FZOUT", 0, 2, 3, 2, _GEANT_FZ_FZOUT_parameters, 0, 0, gxfz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_FZ_FZOUT_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_FZ_FZOPEN_LUN_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_FZ_FZOPEN_LUN = { "LUN", 3,
 "Fortran unit with which to open the file", (char*)0, (char*)0, 8, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_FZ_FZOPEN_LUN_type
 };
static KmParameter _GEANT_FZ_FZOPEN_FILE = { "FILE", 4,
 "Name of the file to be opened", (char*)0, (char*)0, 20, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter _GEANT_FZ_FZOPEN_LUNTYP = { "LUNTYP", 6,
 "Type of FZ file to be opened by GOPEN", "XI", (char*)0, 20, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_FZ_FZOPEN_LEN_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_FZ_FZOPEN_LEN = { "LEN", 3,
 "Recordlenght of the file", "0", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_FZ_FZOPEN_LEN_type };
static KmParOption _GEANT_FZ_FZOPEN_CHOPT_type = { (char**)0, (int*)0, (int*)0
 };
static KmParameter _GEANT_FZ_FZOPEN_CHOPT = { "CHOPT", 5,
 "Optional parameter to specify the action", " ", (char*)0, 20, 0, (char**)0,
 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION, &_GEANT_FZ_FZOPEN_CHOPT_type };
static KmParameter *_GEANT_FZ_FZOPEN_parameters[] = { &_GEANT_FZ_FZOPEN_LUN,
 &_GEANT_FZ_FZOPEN_FILE, &_GEANT_FZ_FZOPEN_LUNTYP, &_GEANT_FZ_FZOPEN_LEN,
 &_GEANT_FZ_FZOPEN_CHOPT };
static char *_GEANT_FZ_FZOPEN_guidance[] = { "Equivalent to a call to:",
 "       CALL GOPEN(LUN,FILE,LUNTYP,LEN,IER)",
 "If CHOPT = I then a call to GFIN or GFOUT will be performed in addition",
 "according to the value of LUNTYP, with the key INIT to save or retrieve",
 "the whole initialization data structure." };
static KmCommand _GEANT_FZ_FZOPEN = { &_GEANT_FZ_FZOUT, "/GEANT/FZ/FZOPEN",
 "FZOPEN", 0, 2, 5, 4, _GEANT_FZ_FZOPEN_parameters, 0, 0, gxfz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 5, _GEANT_FZ_FZOPEN_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_FZ_FZIN_LUN_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_FZ_FZIN_LUN = { "LUN", 3,
 "Fortran unit of the FZ file", (char*)0, (char*)0, 8, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_FZ_FZIN_LUN_type };
static KmParameter _GEANT_FZ_FZIN_KEYSU = { "KEYSU", 5,
 "Name of the data structure to be retrieved", (char*)0, (char*)0, 20, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_FZ_FZIN_IDENT_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_FZ_FZIN_IDENT = { "IDENT", 5,
 "Version of the data structure to be retrieved", "0", (char*)0, 8, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_FZ_FZIN_IDENT_type
 };
static KmParameter *_GEANT_FZ_FZIN_parameters[] = { &_GEANT_FZ_FZIN_LUN,
 &_GEANT_FZ_FZIN_KEYSU, &_GEANT_FZ_FZIN_IDENT };
static char *_GEANT_FZ_FZIN_guidance[] = { "Equivalent to a call to:",
 "       CALL GFIN(LUN,KEYSU,1,IDENT,' ',IER)" };
static KmCommand _GEANT_FZ_FZIN = { &_GEANT_FZ_FZOPEN, "/GEANT/FZ/FZIN",
 "FZIN", 0, 2, 3, 2, _GEANT_FZ_FZIN_parameters, 0, 0, gxfz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_FZ_FZIN_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_FZ_guidance[] = { "ZEBRA/FZ commands" };
static KmMenu _GEANT_FZ = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/FZ", "FZ", 2,
 &_GEANT_FZ_FZIN, 1, _GEANT_FZ_guidance };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_FZ, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 921023 );
}
 
 
#ifdef F77_LCASE
#  define gkrz_ gkrz
#  define gxrz_ gxrz
#endif
 
#ifdef F77_UCASE
#  define gkrz_ GKRZ
#  define gxrz_ GXRZ
#endif
 
#ifdef IBM370
#  pragma linkage(GKRZ,FORTRAN)
#  pragma linkage(GXRZ,FORTRAN)
#endif
 
extern void gkrz_();
extern void gxrz_();
 
void gkrz_()
{
 
static KmParameter _GEANT_RZ_FREE_CHDIR = { "CHDIR", 5, "Lock identifier",
 "RZFILE", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_RZ_FREE_parameters[] = { &_GEANT_RZ_FREE_CHDIR };
static char *_GEANT_RZ_FREE_guidance[] = { "Free an RZ directory." };
static KmCommand _GEANT_RZ_FREE = {  (KmCommand*)0, "/GEANT/RZ/FREE", "FREE",
 0, 2, 1, 1, _GEANT_RZ_FREE_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 1, _GEANT_RZ_FREE_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_RZ_LOCK_CHDIR = { "CHDIR", 5, "Lock identifier",
 "RZFILE", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_RZ_LOCK_parameters[] = { &_GEANT_RZ_LOCK_CHDIR };
static char *_GEANT_RZ_LOCK_guidance[] = { "Lock an RZ directory." };
static KmCommand _GEANT_RZ_LOCK = { &_GEANT_RZ_FREE, "/GEANT/RZ/LOCK", "LOCK",
 0, 2, 1, 1, _GEANT_RZ_LOCK_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 1, _GEANT_RZ_LOCK_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_RZ_SCR_OBJECT = { "OBJECT", 6, "Structure name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_RZ_SCR_IDVERS_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_RZ_SCR_IDVERS = { "IDVERS", 6, "Version number",
 "1", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_RZ_SCR_IDVERS_type };
static KmParameter *_GEANT_RZ_SCR_parameters[] = { &_GEANT_RZ_SCR_OBJECT,
 &_GEANT_RZ_SCR_IDVERS };
static char *_GEANT_RZ_SCR_guidance[] = {
 "Delete entry identified by OBJECT,IDVERS on RZ file.",
 "OBJECT may be : MATE,TMED,VOLU,ROTM,SETS,PART,SCAN, *",
 "If OBJECT= *    delete all entries with IDVERS." };
static KmCommand _GEANT_RZ_SCR = { &_GEANT_RZ_LOCK, "/GEANT/RZ/SCR", "SCR", 0,
 2, 2, 1, _GEANT_RZ_SCR_parameters, 0, 0, gxrz_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 3, _GEANT_RZ_SCR_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_RZ_PURGE_NKEEP_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_RZ_PURGE_NKEEP = { "NKEEP", 5,
 "Number of cycles to keep", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_RZ_PURGE_NKEEP_type };
static KmParameter *_GEANT_RZ_PURGE_parameters[] = { &_GEANT_RZ_PURGE_NKEEP };
static char *_GEANT_RZ_PURGE_guidance[] = { "Purge an RZ directory." };
static KmCommand _GEANT_RZ_PURGE = { &_GEANT_RZ_SCR, "/GEANT/RZ/PURGE",
 "PURGE", 0, 2, 1, 0, _GEANT_RZ_PURGE_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 1, _GEANT_RZ_PURGE_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_RZ_LDIR_CHPATH = { "CHPATH", 6, "Path name", " ",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParOption _GEANT_RZ_LDIR_CHOPT_type = { (char**)0, (int*)0, (int*)0 };
static KmParameter _GEANT_RZ_LDIR_CHOPT = { "CHOPT", 5, "CHOPT", " ",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_RZ_LDIR_CHOPT_type };
static KmParameter *_GEANT_RZ_LDIR_parameters[] = { &_GEANT_RZ_LDIR_CHPATH,
 &_GEANT_RZ_LDIR_CHOPT };
static char *_GEANT_RZ_LDIR_guidance[] = {
 "List the contents of a directory (memory or disk).",
 "To list all RZ files currently open, type 'LD //'." };
static KmCommand _GEANT_RZ_LDIR = { &_GEANT_RZ_PURGE, "/GEANT/RZ/LDIR",
 "LDIR", 0, 2, 2, 0, _GEANT_RZ_LDIR_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_RZ_LDIR_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_RZ_OUT_OBJECT = { "OBJECT", 6, "Structure name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_RZ_OUT_IDVERS_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_RZ_OUT_IDVERS = { "IDVERS", 6, "Version number",
 "1", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_RZ_OUT_IDVERS_type };
static KmParOption _GEANT_RZ_OUT_CHOPT_type = { (char**)0, (int*)0, (int*)0 };
static KmParameter _GEANT_RZ_OUT_CHOPT = { "CHOPT", 5, "Option", " ",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_RZ_OUT_CHOPT_type };
static KmParameter *_GEANT_RZ_OUT_parameters[] = { &_GEANT_RZ_OUT_OBJECT,
 &_GEANT_RZ_OUT_IDVERS, &_GEANT_RZ_OUT_CHOPT };
static char *_GEANT_RZ_OUT_guidance[] = {
 "Write data structure identified by OBJECT,IDVERS to RZ file.",
 "  MATE write JMATE structure", "  TMED write JTMED structure",
 "  VOLU write JVOLUM structure", "  ROTM write JROTM structure",
 "  SETS write JSET  structure", "  PART write JPART structure",
 "  SCAN write LSCAN structure", "  INIT write all above data structures" };
static KmCommand _GEANT_RZ_OUT = { &_GEANT_RZ_LDIR, "/GEANT/RZ/OUT", "OUT", 0,
 2, 3, 1, _GEANT_RZ_OUT_parameters, 0, 0, gxrz_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 9, _GEANT_RZ_OUT_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_RZ_IN_OBJECT = { "OBJECT", 6, "Structure name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParInt    _GEANT_RZ_IN_IDVERS_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_RZ_IN_IDVERS = { "IDVERS", 6, "Version number", "1",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_RZ_IN_IDVERS_type };
static KmParOption _GEANT_RZ_IN_CHOPT_type = { (char**)0, (int*)0, (int*)0 };
static KmParameter _GEANT_RZ_IN_CHOPT = { "CHOPT", 5, "Option", " ", (char*)0,
 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_RZ_IN_CHOPT_type };
static KmParameter *_GEANT_RZ_IN_parameters[] = { &_GEANT_RZ_IN_OBJECT,
 &_GEANT_RZ_IN_IDVERS, &_GEANT_RZ_IN_CHOPT };
static char *_GEANT_RZ_IN_guidance[] = {
 "Read data structure identified by OBJECT,IDVERS into memory.",
 "  MATE read JMATE structure", "  TMED read JTMED structure",
 "  VOLU read JVOLUM structure", "  ROTM read JROTM structure",
 "  SETS read JSET  structure", "  PART read JPART structure",
 "  SCAN read LSCAN structure", "  INIT read all above data structures" };
static KmCommand _GEANT_RZ_IN = { &_GEANT_RZ_OUT, "/GEANT/RZ/IN", "IN", 0, 2,
 3, 1, _GEANT_RZ_IN_parameters, 0, 0, gxrz_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 9, _GEANT_RZ_IN_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_RZ_CDIR_CHPATH = { "CHPATH", 6, "Path name", " ",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static KmParOption _GEANT_RZ_CDIR_CHOPT_type = { (char**)0, (int*)0, (int*)0 };
static KmParameter _GEANT_RZ_CDIR_CHOPT = { "CHOPT", 5, "CHOPT", " ",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_RZ_CDIR_CHOPT_type };
static KmParameter *_GEANT_RZ_CDIR_parameters[] = { &_GEANT_RZ_CDIR_CHPATH,
 &_GEANT_RZ_CDIR_CHOPT };
static char *_GEANT_RZ_CDIR_guidance[] = {
 "Change or print the current directory.",
 " Ex.  CD dir1         ; make DIR1 the new CWD",
 "      CD //file1/dir2 ; make //FILE1/DIR2 the new CWD",
 "      CD              ; print the name of the CWD" };
static KmCommand _GEANT_RZ_CDIR = { &_GEANT_RZ_IN, "/GEANT/RZ/CDIR", "CDIR",
 0, 2, 2, 0, _GEANT_RZ_CDIR_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 4, _GEANT_RZ_CDIR_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParameter _GEANT_RZ_MDIR_CHDIR = { "CHDIR", 5, "Directory name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParOption _GEANT_RZ_MDIR_CHOPT_type = { (char**)0, (int*)0, (int*)0 };
static KmParameter _GEANT_RZ_MDIR_CHOPT = { "CHOPT", 5, "Options", " ",
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_RZ_MDIR_CHOPT_type };
static KmParameter *_GEANT_RZ_MDIR_parameters[] = { &_GEANT_RZ_MDIR_CHDIR,
 &_GEANT_RZ_MDIR_CHOPT };
static char *_GEANT_RZ_MDIR_guidance[] = {
 "To create a new RZ directory below the current directory.", "with",
 " RZTAGS(1)='Object'", " RZTAGS(2)='Idvers-NR '" };
static KmCommand _GEANT_RZ_MDIR = { &_GEANT_RZ_CDIR, "/GEANT/RZ/MDIR", "MDIR",
 0, 2, 2, 1, _GEANT_RZ_MDIR_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 4, _GEANT_RZ_MDIR_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_RZ_REND_LUNRZ_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_RZ_REND_LUNRZ = { "LUNRZ", 5, "Logical unit number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_RZ_REND_LUNRZ_type };
static KmParameter *_GEANT_RZ_REND_parameters[] = { &_GEANT_RZ_REND_LUNRZ };
static char *_GEANT_RZ_REND_guidance[] = {
 "Close an RZ file opened by GRFILE on logical unit LUNRZ.",
 " CALL GREND(LUNRZ)" };
static KmCommand _GEANT_RZ_REND = { &_GEANT_RZ_MDIR, "/GEANT/RZ/REND", "REND",
 0, 2, 1, 1, _GEANT_RZ_REND_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_RZ_REND_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_RZ_FILE_LUN_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_RZ_FILE_LUN = { "LUN", 3, "Logical unit number",
 (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_RZ_FILE_LUN_type };
static KmParameter _GEANT_RZ_FILE_FNAME = { "FNAME", 5, "File name", (char*)0,
 (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static char *_GEANT_RZ_FILE_CHOPT_range[] = { " ", "A", "N", "U" };
static char *_GEANT_RZ_FILE_CHOPT_text[] = { (char*)0, (char*)0, (char*)0,
 (char*)0 };
static KmParOption _GEANT_RZ_FILE_CHOPT_type = { _GEANT_RZ_FILE_CHOPT_text,
 (int*)0, (int*)0 };
static KmParameter _GEANT_RZ_FILE_CHOPT = { "CHOPT", 5, "Options", " ",
 (char*)0, 8, 4, _GEANT_RZ_FILE_CHOPT_range, 4, _GEANT_RZ_FILE_CHOPT_range,
 (KmParFlag)0, KmTYPE_OPTION, &_GEANT_RZ_FILE_CHOPT_type };
static KmParameter *_GEANT_RZ_FILE_parameters[] = { &_GEANT_RZ_FILE_LUN,
 &_GEANT_RZ_FILE_FNAME, &_GEANT_RZ_FILE_CHOPT };
static char *_GEANT_RZ_FILE_guidance[] = { "Open a GRZ file.",
 " CHOPT=' ' readonly mode", " CHOPT='U' update mode",
 " CHOPT='N' create new file",
 " CHOPT='I' Read all structures from existing file",
 " CHOPT='O' Write all structures on file" };
static KmCommand _GEANT_RZ_FILE = { &_GEANT_RZ_REND, "/GEANT/RZ/FILE", "FILE",
 0, 2, 3, 2, _GEANT_RZ_FILE_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 6, _GEANT_RZ_FILE_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_RZ_PQUEST_IQ1_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_RZ_PQUEST_IQ1 = { "IQ1", 3,
 "Lower limit for IQ index", "1", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_RZ_PQUEST_IQ1_type };
static KmParInt    _GEANT_RZ_PQUEST_IQ2_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_RZ_PQUEST_IQ2 = { "IQ2", 3,
 "Upper limit for IQ index", "20", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_RZ_PQUEST_IQ2_type };
static KmParameter *_GEANT_RZ_PQUEST_parameters[] = { &_GEANT_RZ_PQUEST_IQ1,
 &_GEANT_RZ_PQUEST_IQ2 };
static char *_GEANT_RZ_PQUEST_guidance[] = {
 "Print the array IQUEST in /QUEST/." };
static KmCommand _GEANT_RZ_PQUEST = { &_GEANT_RZ_FILE, "/GEANT/RZ/PQUEST",
 "PQUEST", 0, 2, 2, 0, _GEANT_RZ_PQUEST_parameters, 0, 0, gxrz_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 1, _GEANT_RZ_PQUEST_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_RZ_guidance[] = { "ZEBRA/RZ commands." };
static KmMenu _GEANT_RZ = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/RZ", "RZ", 2,
 &_GEANT_RZ_PQUEST, 1, _GEANT_RZ_guidance };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_RZ, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 921023 );
}
 
 
#ifdef F77_LCASE
#  define gkscan_ gkscan
#  define gxscan_ gxscan
#endif
 
#ifdef F77_UCASE
#  define gkscan_ GKSCAN
#  define gxscan_ GXSCAN
#endif
 
#ifdef IBM370
#  pragma linkage(GKSCAN,FORTRAN)
#  pragma linkage(GXSCAN,FORTRAN)
#endif
 
extern void gkscan_();
extern void gxscan_();
 
void gkscan_()
{
 
static KmParInt    _GEANT_SCAN_HSCAN_IDPHI_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_HSCAN_IDPHI = { "IDPHI", 5,
 "Histogram/phi identifier", "1000", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_SCAN_HSCAN_IDPHI_type };
static KmParameter _GEANT_SCAN_HSCAN_VOLUME = { "VOLUME", 6, "Volume name",
 "XXXX", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static char *_GEANT_SCAN_HSCAN_CHOPT_range[] = { " ", "O", "P", "I", "X", "L"
 };
static char *_GEANT_SCAN_HSCAN_CHOPT_text[] = { (char*)0, (char*)0, (char*)0,
 (char*)0, (char*)0, (char*)0 };
static KmParOption _GEANT_SCAN_HSCAN_CHOPT_type = {
 _GEANT_SCAN_HSCAN_CHOPT_text, (int*)0, (int*)0 };
static KmParameter _GEANT_SCAN_HSCAN_CHOPT = { "CHOPT", 5, "List of options",
 "OPX", (char*)0, 8, 6, _GEANT_SCAN_HSCAN_CHOPT_range, 6,
 _GEANT_SCAN_HSCAN_CHOPT_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_SCAN_HSCAN_CHOPT_type };
static KmParameter *_GEANT_SCAN_HSCAN_parameters[] = {
 &_GEANT_SCAN_HSCAN_IDPHI, &_GEANT_SCAN_HSCAN_VOLUME, &_GEANT_SCAN_HSCAN_CHOPT
 };
static char *_GEANT_SCAN_HSCAN_guidance[] = {
 "Generates and plots an histogram of physics quantities such as",
 "the total number of radiation lengths or interaction lengths",
 "as a function of the SCAN parameter TETA for a given value of PHI.",
 "  CHOPT='O' histogram is generated at Exit  of VOLUME.",
 "  CHOPT='I' histogram is generated at Entry of VOLUME.",
 "  CHOPT='X' radiation lengths", "  CHOPT='L' Interaction lengths",
 "  CHOPT='P' Plot the histogram", "If VOLUME='XXXX' Mother volume is used.",
 "The histogram identifier IDPHI is used to also identify which",
 "PHI division to plot: IPHI=MOD(IDPHI,1000).",
 "If IPHI=0, then all PHI divisions are generated (not plotted)",
 "with histogram identifiers IDPHI+PHI division number." };
static KmCommand _GEANT_SCAN_HSCAN = {  (KmCommand*)0, "/GEANT/SCAN/HSCAN",
 "HSCAN", 0, 2, 3, 1, _GEANT_SCAN_HSCAN_parameters, 0, 0, gxscan_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 13, _GEANT_SCAN_HSCAN_guidance,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_SCAN_LSCAN_ID_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_SCAN_LSCAN_ID = { "ID", 2, "Lego plot identifier",
 "2000", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_SCAN_LSCAN_ID_type };
static KmParameter _GEANT_SCAN_LSCAN_VOLUME = { "VOLUME", 6, "Volume name",
 "XXXX", (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_CHAR,
 (void*)0 };
static char *_GEANT_SCAN_LSCAN_CHOPT_range[] = { " ", "O", "P", "I", "X", "L"
 };
static char *_GEANT_SCAN_LSCAN_CHOPT_text[] = { (char*)0, (char*)0, (char*)0,
 (char*)0, (char*)0, (char*)0 };
static KmParOption _GEANT_SCAN_LSCAN_CHOPT_type = {
 _GEANT_SCAN_LSCAN_CHOPT_text, (int*)0, (int*)0 };
static KmParameter _GEANT_SCAN_LSCAN_CHOPT = { "CHOPT", 5, "List of options",
 "OPX", (char*)0, 8, 6, _GEANT_SCAN_LSCAN_CHOPT_range, 6,
 _GEANT_SCAN_LSCAN_CHOPT_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_SCAN_LSCAN_CHOPT_type };
static KmParameter *_GEANT_SCAN_LSCAN_parameters[] = { &_GEANT_SCAN_LSCAN_ID,
 &_GEANT_SCAN_LSCAN_VOLUME, &_GEANT_SCAN_LSCAN_CHOPT };
static char *_GEANT_SCAN_LSCAN_guidance[] = {
 "Generates and plot a table of physics quantities such as",
 "the total number of radiation lengths or interaction lengths",
 "in function of the SCAN parameters TETA,PHI.",
 "  CHOPT='O' table is generated at Exit  of VOLUME.",
 "  CHOPT='I' table is generated at Entry of VOLUME.",
 "  CHOPT='X' radiation lengths", "  CHOPT='L' Interaction lengths",
 "  CHOPT='P' Plot the table", "If VOLUME='XXXX' Mother volume is used." };
static KmCommand _GEANT_SCAN_LSCAN = { &_GEANT_SCAN_HSCAN,
 "/GEANT/SCAN/LSCAN", "LSCAN", 0, 2, 3, 1, _GEANT_SCAN_LSCAN_parameters, 0, 0,
 gxscan_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 9,
 _GEANT_SCAN_LSCAN_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_SCAN_PCUTS_IPARAM_type = { "0", "1", "0", "1", 0 };
static KmParameter _GEANT_SCAN_PCUTS_IPARAM = { "IPARAM", 6,
 "Parametrization Flag", (char*)0, (char*)0, 2, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_SCAN_PCUTS_IPARAM_type };
static KmParReal   _GEANT_SCAN_PCUTS_PCUTGA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_PCUTS_PCUTGA = { "PCUTGA", 6,
 "Parametrization Cut for gammas", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_PCUTS_PCUTGA_type };
static KmParReal   _GEANT_SCAN_PCUTS_PCUTEL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_PCUTS_PCUTEL = { "PCUTEL", 6,
 "Parametrization Cut for electrons", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_PCUTS_PCUTEL_type };
static KmParReal   _GEANT_SCAN_PCUTS_PCUTHA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_PCUTS_PCUTHA = { "PCUTHA", 6,
 "Parametrization Cut for charged hadrons", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_SCAN_PCUTS_PCUTHA_type };
static KmParReal   _GEANT_SCAN_PCUTS_PCUTNE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_PCUTS_PCUTNE = { "PCUTNE", 6,
 "Parametrization Cut for neutral hadrons", (char*)0, (char*)0, 12, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_SCAN_PCUTS_PCUTNE_type };
static KmParReal   _GEANT_SCAN_PCUTS_PCUTMU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_PCUTS_PCUTMU = { "PCUTMU", 6,
 "Parametrization Cut for muons", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_PCUTS_PCUTMU_type };
static KmParameter *_GEANT_SCAN_PCUTS_parameters[] = {
 &_GEANT_SCAN_PCUTS_IPARAM, &_GEANT_SCAN_PCUTS_PCUTGA,
 &_GEANT_SCAN_PCUTS_PCUTEL, &_GEANT_SCAN_PCUTS_PCUTHA,
 &_GEANT_SCAN_PCUTS_PCUTNE, &_GEANT_SCAN_PCUTS_PCUTMU };
static char *_GEANT_SCAN_PCUTS_guidance[] = {
 "Control parametrization at tracking time.",
 "     IPARAM=0       No parametrization is performed",
 "     IPARAM=1       Parametrization is performed",
 "If parametrization is active and a particle falls below its",
 "parametrization cut, then the particle will be replaced by",
 "a parametrized shower which will be tracked in the SCAN", "geometry." };
static KmCommand _GEANT_SCAN_PCUTS = { &_GEANT_SCAN_LSCAN,
 "/GEANT/SCAN/PCUTS", "PCUTS", 0, 2, 6, 0, _GEANT_SCAN_PCUTS_parameters, 0, 0,
 gxscan_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 7,
 _GEANT_SCAN_PCUTS_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_SCAN_STURN_CHOPT_range[] = { "ON", "OFF", "INIT" };
static char *_GEANT_SCAN_STURN_CHOPT_text[] = { (char*)0, (char*)0, (char*)0 };
static KmParOption _GEANT_SCAN_STURN_CHOPT_type = {
 _GEANT_SCAN_STURN_CHOPT_text, (int*)0, (int*)0 };
static KmParameter _GEANT_SCAN_STURN_CHOPT = { "CHOPT", 5,
 "SCAN mode setting", (char*)0, (char*)0, 8, 3, _GEANT_SCAN_STURN_CHOPT_range,
 3, _GEANT_SCAN_STURN_CHOPT_range, (KmParFlag)0, KmTYPE_OPTION,
 &_GEANT_SCAN_STURN_CHOPT_type };
static KmParameter *_GEANT_SCAN_STURN_parameters[] = {
 &_GEANT_SCAN_STURN_CHOPT };
static char *_GEANT_SCAN_STURN_guidance[] = {
 "Switch on/off SCAN mode. If SCAN mode is on, SCAN geantinos",
 "are generated and tracked to fill (or complete) the current",
 "scan data structure. If SCAN mode is off, normal kinematics",
 "generation and tracking will take place. If INIT is given,",
 "the current SCAN data structure (if any) will be dropped",
 "and SCAN mode will be turned on." };
static KmCommand _GEANT_SCAN_STURN = { &_GEANT_SCAN_PCUTS,
 "/GEANT/SCAN/STURN", "STURN", 0, 2, 1, 1, _GEANT_SCAN_STURN_parameters, 0, 0,
 gxscan_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 6,
 _GEANT_SCAN_STURN_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_SCAN_SFACTORS_FACTX0_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_SFACTORS_FACTX0 = { "FACTX0", 6,
 "Scale factor for SX0", "100.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_SFACTORS_FACTX0_type };
static KmParReal   _GEANT_SCAN_SFACTORS_FACTL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_SFACTORS_FACTL = { "FACTL", 5,
 "Scale factor for SL", "1000.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_SFACTORS_FACTL_type };
static KmParReal   _GEANT_SCAN_SFACTORS_FACTR_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_SFACTORS_FACTR = { "FACTR", 5,
 "Scale factor for R", "100.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_SFACTORS_FACTR_type };
static KmParameter *_GEANT_SCAN_SFACTORS_parameters[] = {
 &_GEANT_SCAN_SFACTORS_FACTX0, &_GEANT_SCAN_SFACTORS_FACTL,
 &_GEANT_SCAN_SFACTORS_FACTR };
static char *_GEANT_SCAN_SFACTORS_guidance[] = {
 "Set scale factors for SX0,SL and R. The given scale factors must be",
 "such that:", "  SX0*FACTX0 < 2**15-1 (32767)",
 "  SL*FACTL   < 2**10-1 (1023)", "  SR*FACTR   < 2**17-1 (131071)" };
static KmCommand _GEANT_SCAN_SFACTORS = { &_GEANT_SCAN_STURN,
 "/GEANT/SCAN/SFACTORS", "SFACTORS", 0, 2, 3, 3,
 _GEANT_SCAN_SFACTORS_parameters, 0, 0, gxscan_, (IntFunc*)0, (SUBROUTINE*)0,
 (pCharFunc*)0, 5, _GEANT_SCAN_SFACTORS_guidance, 0, (char**)0, (char*)0,
 (int*)0 };
 
static KmParReal   _GEANT_SCAN_VERTEX_VX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_VERTEX_VX = { "VX", 2, "Scan X-origin", "0.",
 (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_SCAN_VERTEX_VX_type };
static KmParReal   _GEANT_SCAN_VERTEX_VY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_VERTEX_VY = { "VY", 2, "Scan Y-origin", "0.",
 (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_SCAN_VERTEX_VY_type };
static KmParReal   _GEANT_SCAN_VERTEX_VZ_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_VERTEX_VZ = { "VZ", 2, "Scan Z-origin", "0.",
 (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_SCAN_VERTEX_VZ_type };
static KmParameter *_GEANT_SCAN_VERTEX_parameters[] = {
 &_GEANT_SCAN_VERTEX_VX, &_GEANT_SCAN_VERTEX_VY, &_GEANT_SCAN_VERTEX_VZ };
static char *_GEANT_SCAN_VERTEX_guidance[] = {
 "All Geantinos tracked will start from position VX,VY,VZ." };
static KmCommand _GEANT_SCAN_VERTEX = { &_GEANT_SCAN_SFACTORS,
 "/GEANT/SCAN/VERTEX", "VERTEX", 0, 2, 3, 3, _GEANT_SCAN_VERTEX_parameters, 0,
 0, gxscan_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_SCAN_VERTEX_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParameter _GEANT_SCAN_SLIST_LIST = { "LIST", 4,
 "List of master volumes", (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_CHAR,  (void*)0 };
static KmParameter *_GEANT_SCAN_SLIST_parameters[] = { &_GEANT_SCAN_SLIST_LIST
 };
static char *_GEANT_SCAN_SLIST_guidance[] = {
 "Only boundary crossings of volumes given in LIST will be seen",
 "in the SCAN geometry. If no parameters are given, the current",
 "SCAN volumes will be listed. If a full stop (.) is given, the list",
 "of scan volumes will be erased." };
static KmCommand _GEANT_SCAN_SLIST = { &_GEANT_SCAN_VERTEX,
 "/GEANT/SCAN/SLIST", "SLIST", 0, 2, 1, 1, _GEANT_SCAN_SLIST_parameters, 0, 0,
 gxscan_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_SCAN_SLIST_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_SCAN_TETA_NTETA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_TETA_NTETA = { "NTETA", 5,
 "Number of TETA divisions", "90", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_SCAN_TETA_NTETA_type };
static KmParReal   _GEANT_SCAN_TETA_TETMIN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_TETA_TETMIN = { "TETMIN", 6,
 "Minimum value of TETA", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_TETA_TETMIN_type };
static KmParReal   _GEANT_SCAN_TETA_TETMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_SCAN_TETA_TETMAX = { "TETMAX", 6,
 "Maximum value of TETA", (char*)0, (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_TETA_TETMAX_type };
static KmParInt    _GEANT_SCAN_TETA_DIVTYP_type = { "1", "3", "1", "3", 0 };
static KmParameter _GEANT_SCAN_TETA_DIVTYP = { "DIVTYP", 6,
 "Type of TETA division", (char*)0, (char*)0, 2, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_SCAN_TETA_DIVTYP_type };
static KmParameter *_GEANT_SCAN_TETA_parameters[] = { &_GEANT_SCAN_TETA_NTETA,
 &_GEANT_SCAN_TETA_TETMIN, &_GEANT_SCAN_TETA_TETMAX, &_GEANT_SCAN_TETA_DIVTYP
 };
static char *_GEANT_SCAN_TETA_guidance[] = {
 "To specify number of divisions along TETA.",
 "If DIVTYP=1 divisions in pseudo-rapidity ETA.",
 "If DIVTYP=2 divisions in degrees following the THETA angle.",
 "If DIVTYP=3 divisions in cos(TETA).",
 "If no parameter is given, the current values of the parameters",
 "are displayed." };
static KmCommand _GEANT_SCAN_TETA = { &_GEANT_SCAN_SLIST, "/GEANT/SCAN/TETA",
 "TETA", 0, 2, 4, 1, _GEANT_SCAN_TETA_parameters, 0, 0, gxscan_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 6, _GEANT_SCAN_TETA_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static KmParInt    _GEANT_SCAN_PHI_NPHI_type = { (char*)0, (char*)0, (char*)0,
 (char*)0, 0 };
static KmParameter _GEANT_SCAN_PHI_NPHI = { "NPHI", 4,
 "Number of PHI divisions", "90", (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_SCAN_PHI_NPHI_type };
static KmParReal   _GEANT_SCAN_PHI_PHIMIN_type = { "0.", "360.", "0.", "360.",
 0 };
static KmParameter _GEANT_SCAN_PHI_PHIMIN = { "PHIMIN", 6,
 "Minimum PHI in degrees", "0.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_PHI_PHIMIN_type };
static KmParReal   _GEANT_SCAN_PHI_PHIMAX_type = { "0.", "360.", "0.", "360.",
 0 };
static KmParameter _GEANT_SCAN_PHI_PHIMAX = { "PHIMAX", 6,
 "Maximum PHI in degrees", "360.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_SCAN_PHI_PHIMAX_type };
static KmParameter *_GEANT_SCAN_PHI_parameters[] = { &_GEANT_SCAN_PHI_NPHI,
 &_GEANT_SCAN_PHI_PHIMIN, &_GEANT_SCAN_PHI_PHIMAX };
static char *_GEANT_SCAN_PHI_guidance[] = {
 "To specify number of divisions along PHI. If no parameter is",
 "given, the current values of the parameters are displayed." };
static KmCommand _GEANT_SCAN_PHI = { &_GEANT_SCAN_TETA, "/GEANT/SCAN/PHI",
 "PHI", 0, 2, 3, 1, _GEANT_SCAN_PHI_parameters, 0, 0, gxscan_, (IntFunc*)0,
 (SUBROUTINE*)0, (pCharFunc*)0, 2, _GEANT_SCAN_PHI_guidance, 0, (char**)0,
 (char*)0, (int*)0 };
 
static char *_GEANT_SCAN_guidance[] = {
 "To define parameters for the SCAN geometry. If the routine GUSTEP",
 "and GUKINE are properly instrumented (see examples in GEANX),",
 "when the TRI command is entered NTETA Geantinos will be",
 "tracked through the real detector starting at the vertex position",
 "defined by the command vertex. A simplified version of the geometry",
 "is automatically generated in (ETA,PHI) or (THETA,PHI) following",
 "the option given in the command TETA. The data structure LSCAN",
 "generated may be saved on an RZ file for subsequent processing.",
 "This data structure may be used for fast parametrization techniques." };
static KmMenu _GEANT_SCAN = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/SCAN", "SCAN",
 2, &_GEANT_SCAN_PHI, 9, _GEANT_SCAN_guidance };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_SCAN, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 921023 );
}
 
 
#ifdef F77_LCASE
#  define gkphys_ gkphys
#  define gxphys_ gxphys
#endif
 
#ifdef F77_UCASE
#  define gkphys_ GKPHYS
#  define gxphys_ GXPHYS
#endif
 
#ifdef IBM370
#  pragma linkage(GKPHYS,FORTRAN)
#  pragma linkage(GXPHYS,FORTRAN)
#endif
 
extern void gkphys_();
extern void gxphys_();
 
void gkphys_()
{
 
static char *_GEANT_PHYSICS_PHYSI_guidance[] = {
 "Call the GEANT initialisation routine GPHYSI to recompute",
 "the tables of cross-sections and energy loss. This command",
 "must be invoked after CUTS, LOSS or ERAN commands." };
static KmCommand _GEANT_PHYSICS_PHYSI = {  (KmCommand*)0,
 "/GEANT/PHYSICS/PHYSI", "PHYSI", 0, 2, 0, 0, (KmParameter**)0, 0, 0, gxphys_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3, _GEANT_PHYSICS_PHYSI_guidance,
 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_PHYSICS_DRPRT_IPART_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_DRPRT_IPART = { "IPART", 5,
 "GEANT particle number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_PHYSICS_DRPRT_IPART_type };
static KmParInt    _GEANT_PHYSICS_DRPRT_IMATE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_DRPRT_IMATE = { "IMATE", 5,
 "GEANT material number", (char*)0, (char*)0, 8, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_INT, &_GEANT_PHYSICS_DRPRT_IMATE_type };
static KmParReal   _GEANT_PHYSICS_DRPRT_STEP_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_DRPRT_STEP = { "STEP", 4,
 "step length in centimeters", (char*)0, (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_DRPRT_STEP_type };
static KmParInt    _GEANT_PHYSICS_DRPRT_NPOINT_type = { "2", "100", "2",
 "100", 0 };
static KmParameter _GEANT_PHYSICS_DRPRT_NPOINT = { "NPOINT", 6,
 "number of logarithmically spaced energy points", "10", (char*)0, 4, 0,
 (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_DRPRT_NPOINT_type };
static KmParameter *_GEANT_PHYSICS_DRPRT_parameters[] = {
 &_GEANT_PHYSICS_DRPRT_IPART, &_GEANT_PHYSICS_DRPRT_IMATE,
 &_GEANT_PHYSICS_DRPRT_STEP, &_GEANT_PHYSICS_DRPRT_NPOINT };
static char *_GEANT_PHYSICS_DRPRT_guidance[] = {
 "This routine prints the relevant parameters linked with the energy loss",
 "fluctuation." };
static KmCommand _GEANT_PHYSICS_DRPRT = { &_GEANT_PHYSICS_PHYSI,
 "/GEANT/PHYSICS/DRPRT", "DRPRT", 0, 2, 4, 3, _GEANT_PHYSICS_DRPRT_parameters,
 0, 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 2,
 _GEANT_PHYSICS_DRPRT_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_PHYSICS_CUTS_CUTGAM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_CUTGAM = { "CUTGAM", 6,
 "Cut for gammas", "0.001", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_CUTGAM_type };
static KmParReal   _GEANT_PHYSICS_CUTS_CUTELE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_CUTELE = { "CUTELE", 6,
 "Cut for electrons", "0.001", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_CUTELE_type };
static KmParReal   _GEANT_PHYSICS_CUTS_CUTHAD_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_CUTHAD = { "CUTHAD", 6,
 "Cut for charged hadrons", "0.01", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_CUTHAD_type };
static KmParReal   _GEANT_PHYSICS_CUTS_CUTNEU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_CUTNEU = { "CUTNEU", 6,
 "Cut for neutral hadrons", "0.01", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_CUTNEU_type };
static KmParReal   _GEANT_PHYSICS_CUTS_CUTMUO_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_CUTMUO = { "CUTMUO", 6,
 "Cut for muons", "0.01", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_CUTMUO_type };
static KmParReal   _GEANT_PHYSICS_CUTS_BCUTE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_BCUTE = { "BCUTE", 5,
 "Cut for electron brems.", "-1.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_BCUTE_type };
static KmParReal   _GEANT_PHYSICS_CUTS_BCUTM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_BCUTM = { "BCUTM", 5,
 "Cut for muon brems.", "-1.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_BCUTM_type };
static KmParReal   _GEANT_PHYSICS_CUTS_DCUTE_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_DCUTE = { "DCUTE", 5,
 "Cut for electron delta-rays", "-1.", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_DCUTE_type };
static KmParReal   _GEANT_PHYSICS_CUTS_DCUTM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_DCUTM = { "DCUTM", 5,
 "Cut for muon delta-rays", "-1.", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_DCUTM_type };
static KmParReal   _GEANT_PHYSICS_CUTS_PPCUTM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_PPCUTM = { "PPCUTM", 6,
 "Cut for e+e- pairs by muons", "0.01", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_PPCUTM_type };
static KmParReal   _GEANT_PHYSICS_CUTS_TOFMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_TOFMAX = { "TOFMAX", 6,
 "Time of flight cut", "1.E+10", (char*)0, 12, 0, (char**)0, 0, (char**)0,
 (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_CUTS_TOFMAX_type };
static KmParReal   _GEANT_PHYSICS_CUTS_GCUTS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CUTS_GCUTS = { "GCUTS", 5, "5 user words",
 "0.", (char*)0, 12, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_REAL,
 &_GEANT_PHYSICS_CUTS_GCUTS_type };
static KmParameter *_GEANT_PHYSICS_CUTS_parameters[] = {
 &_GEANT_PHYSICS_CUTS_CUTGAM, &_GEANT_PHYSICS_CUTS_CUTELE,
 &_GEANT_PHYSICS_CUTS_CUTHAD, &_GEANT_PHYSICS_CUTS_CUTNEU,
 &_GEANT_PHYSICS_CUTS_CUTMUO, &_GEANT_PHYSICS_CUTS_BCUTE,
 &_GEANT_PHYSICS_CUTS_BCUTM, &_GEANT_PHYSICS_CUTS_DCUTE,
 &_GEANT_PHYSICS_CUTS_DCUTM, &_GEANT_PHYSICS_CUTS_PPCUTM,
 &_GEANT_PHYSICS_CUTS_TOFMAX, &_GEANT_PHYSICS_CUTS_GCUTS };
static char *_GEANT_PHYSICS_CUTS_guidance[] = {
 "To change physics cuts. If no parameter is given, the list",
 "of the current cuts is printed.",
 " If the default values (-1.) for       BCUTE ,BCUTM ,DCUTE ,DCUTM",
 " are not modified, they will be set to CUTGAM,CUTGAM,CUTELE,CUTELE",
 " respectively.", "If one of the parameters from CUTGAM to PPCUTM included",
 "is modified, cross-sections and energy loss tables must be",
 "recomputed via the command 'PHYSI'." };
static KmCommand _GEANT_PHYSICS_CUTS = { &_GEANT_PHYSICS_DRPRT,
 "/GEANT/PHYSICS/CUTS", "CUTS", 0, 2, 12, 0, _GEANT_PHYSICS_CUTS_parameters,
 0, 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 8,
 _GEANT_PHYSICS_CUTS_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_SYNC_ISYNC_range[] = { "0", "1" };
static KmParInt    _GEANT_PHYSICS_SYNC_ISYNC_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_SYNC_ISYNC = { "ISYNC", 5, "Flag ISYNC",
 "1", (char*)0, 8, 2, _GEANT_PHYSICS_SYNC_ISYNC_range, 2,
 _GEANT_PHYSICS_SYNC_ISYNC_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_SYNC_ISYNC_type };
static KmParameter *_GEANT_PHYSICS_SYNC_parameters[] = {
 &_GEANT_PHYSICS_SYNC_ISYNC };
static char *_GEANT_PHYSICS_SYNC_guidance[] = {
 "To control synchrotron radiation:", " ISYNC=0 no synchrotron radiation;",
 "      =1 synchrotron radiation." };
static KmCommand _GEANT_PHYSICS_SYNC = { &_GEANT_PHYSICS_CUTS,
 "/GEANT/PHYSICS/SYNC", "SYNC", 0, 2, 1, 0, _GEANT_PHYSICS_SYNC_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_PHYSICS_SYNC_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_STRA_ISTRA_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_STRA_ISTRA_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_STRA_ISTRA = { "ISTRA", 5, "Flag ISTRA",
 "0", (char*)0, 8, 3, _GEANT_PHYSICS_STRA_ISTRA_range, 3,
 _GEANT_PHYSICS_STRA_ISTRA_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_STRA_ISTRA_type };
static KmParameter *_GEANT_PHYSICS_STRA_parameters[] = {
 &_GEANT_PHYSICS_STRA_ISTRA };
static char *_GEANT_PHYSICS_STRA_guidance[] = {
 "To control energy loss fluctuation model:", " ISTRA=0 Urban model;",
 "      =1 PAI model;", "      =2 PAI+ASHO model (not active at the moment)."
 };
static KmCommand _GEANT_PHYSICS_STRA = { &_GEANT_PHYSICS_SYNC,
 "/GEANT/PHYSICS/STRA", "STRA", 0, 2, 1, 0, _GEANT_PHYSICS_STRA_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_STRA_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_RAYL_IRAYL_range[] = { "0", "1" };
static KmParInt    _GEANT_PHYSICS_RAYL_IRAYL_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_RAYL_IRAYL = { "IRAYL", 5, "Flag IRAYL",
 "1", (char*)0, 8, 2, _GEANT_PHYSICS_RAYL_IRAYL_range, 2,
 _GEANT_PHYSICS_RAYL_IRAYL_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_RAYL_IRAYL_type };
static KmParameter *_GEANT_PHYSICS_RAYL_parameters[] = {
 &_GEANT_PHYSICS_RAYL_IRAYL };
static char *_GEANT_PHYSICS_RAYL_guidance[] = {
 "To control Rayleigh scattering.", " IRAYL=0 no Rayleigh scattering.",
 "      =1 Rayleigh." };
static KmCommand _GEANT_PHYSICS_RAYL = { &_GEANT_PHYSICS_STRA,
 "/GEANT/PHYSICS/RAYL", "RAYL", 0, 2, 1, 0, _GEANT_PHYSICS_RAYL_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_PHYSICS_RAYL_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_PHOT_IPHOT_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_PHOT_IPHOT_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_PHOT_IPHOT = { "IPHOT", 5, "Flag IPHOT",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_PHOT_IPHOT_range, 3,
 _GEANT_PHYSICS_PHOT_IPHOT_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_PHOT_IPHOT_type };
static KmParameter *_GEANT_PHYSICS_PHOT_parameters[] = {
 &_GEANT_PHYSICS_PHOT_IPHOT };
static char *_GEANT_PHYSICS_PHOT_guidance[] = { "To control Photo effect.",
 " IPHOT=0 no photo electric effect.",
 "      =1 Photo effect. Electron processed.",
 "      =2 Photo effect. No electron stored." };
static KmCommand _GEANT_PHYSICS_PHOT = { &_GEANT_PHYSICS_RAYL,
 "/GEANT/PHYSICS/PHOT", "PHOT", 0, 2, 1, 0, _GEANT_PHYSICS_PHOT_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_PHOT_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_PFIS_IPFIS_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_PFIS_IPFIS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_PFIS_IPFIS = { "IPFIS", 5, "Flag IPFIS",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_PFIS_IPFIS_range, 3,
 _GEANT_PHYSICS_PFIS_IPFIS_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_PFIS_IPFIS_type };
static KmParameter *_GEANT_PHYSICS_PFIS_parameters[] = {
 &_GEANT_PHYSICS_PFIS_IPFIS };
static char *_GEANT_PHYSICS_PFIS_guidance[] = {
 "To control photo fission mechanism.", " IPFIS=0 no photo fission.",
 "      =1 Photo fission. secondaries processed.",
 "      =2 Photo fission. No secondaries stored." };
static KmCommand _GEANT_PHYSICS_PFIS = { &_GEANT_PHYSICS_PHOT,
 "/GEANT/PHYSICS/PFIS", "PFIS", 0, 2, 1, 0, _GEANT_PHYSICS_PFIS_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_PFIS_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_PAIR_IPAIR_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_PAIR_IPAIR_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_PAIR_IPAIR = { "IPAIR", 5, "Flag IPAIR",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_PAIR_IPAIR_range, 3,
 _GEANT_PHYSICS_PAIR_IPAIR_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_PAIR_IPAIR_type };
static KmParameter *_GEANT_PHYSICS_PAIR_parameters[] = {
 &_GEANT_PHYSICS_PAIR_IPAIR };
static char *_GEANT_PHYSICS_PAIR_guidance[] = {
 "To control pair production mechanism.", " IPAIR=0 no pair production.",
 "      =1 Pair production. secondaries processed.",
 "      =2 Pair production. No secondaries stored." };
static KmCommand _GEANT_PHYSICS_PAIR = { &_GEANT_PHYSICS_PFIS,
 "/GEANT/PHYSICS/PAIR", "PAIR", 0, 2, 1, 0, _GEANT_PHYSICS_PAIR_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_PAIR_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_MUNU_IMUNU_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_MUNU_IMUNU_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_MUNU_IMUNU = { "IMUNU", 5, "Flag IMUNU",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_MUNU_IMUNU_range, 3,
 _GEANT_PHYSICS_MUNU_IMUNU_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_MUNU_IMUNU_type };
static KmParameter *_GEANT_PHYSICS_MUNU_parameters[] = {
 &_GEANT_PHYSICS_MUNU_IMUNU };
static char *_GEANT_PHYSICS_MUNU_guidance[] = {
 "To control muon nuclear interactions.",
 " IMUNU=0 no muon-nuclear interactions.",
 "      =1 Nuclear interactions. Secondaries processed.",
 "      =2 Nuclear interactions. Secondaries not processed." };
static KmCommand _GEANT_PHYSICS_MUNU = { &_GEANT_PHYSICS_PAIR,
 "/GEANT/PHYSICS/MUNU", "MUNU", 0, 2, 1, 0, _GEANT_PHYSICS_MUNU_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_MUNU_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_MULS_IMULS_range[] = { "0", "1", "2", "3" };
static KmParInt    _GEANT_PHYSICS_MULS_IMULS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_MULS_IMULS = { "IMULS", 5, "Flag IMULS",
 "1", (char*)0, 8, 4, _GEANT_PHYSICS_MULS_IMULS_range, 4,
 _GEANT_PHYSICS_MULS_IMULS_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_MULS_IMULS_type };
static KmParameter *_GEANT_PHYSICS_MULS_parameters[] = {
 &_GEANT_PHYSICS_MULS_IMULS };
static char *_GEANT_PHYSICS_MULS_guidance[] = {
 "To control multiple scattering.", " IMULS=0 no multiple scattering.",
 "      =1 Moliere or Coulomb scattering.",
 "      =2 Moliere or Coulomb scattering.", "      =3 Gaussian scattering." };
static KmCommand _GEANT_PHYSICS_MULS = { &_GEANT_PHYSICS_MUNU,
 "/GEANT/PHYSICS/MULS", "MULS", 0, 2, 1, 0, _GEANT_PHYSICS_MULS_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 5,
 _GEANT_PHYSICS_MULS_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_LOSS_ILOSS_range[] = { "0", "1", "2", "3", "4" };
static KmParInt    _GEANT_PHYSICS_LOSS_ILOSS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_LOSS_ILOSS = { "ILOSS", 5, "Flag ILOSS",
 "2", (char*)0, 8, 5, _GEANT_PHYSICS_LOSS_ILOSS_range, 5,
 _GEANT_PHYSICS_LOSS_ILOSS_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_LOSS_ILOSS_type };
static KmParameter *_GEANT_PHYSICS_LOSS_parameters[] = {
 &_GEANT_PHYSICS_LOSS_ILOSS };
static char *_GEANT_PHYSICS_LOSS_guidance[] = { "To control energy loss.",
 " ILOSS=0 no energy loss;", "      =1 restricted energy loss fluctuations;",
 "      =2 complete energy loss fluctuations;", "      =3 same as 1;",
 "      =4 no energy loss fluctuations.",
 "If the value ILOSS is changed, then cross-sections and energy loss",
 "tables must be recomputed via the command 'PHYSI'." };
static KmCommand _GEANT_PHYSICS_LOSS = { &_GEANT_PHYSICS_MULS,
 "/GEANT/PHYSICS/LOSS", "LOSS", 0, 2, 1, 0, _GEANT_PHYSICS_LOSS_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 8,
 _GEANT_PHYSICS_LOSS_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_PHYSICS_LABS_LABS_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_LABS_LABS = { "LABS", 4, "Flag LABS", "0",
 (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_LABS_LABS_type };
static KmParameter *_GEANT_PHYSICS_LABS_parameters[] = {
 &_GEANT_PHYSICS_LABS_LABS };
static char *_GEANT_PHYSICS_LABS_guidance[] = {
 "To control absorbtion of Cerenkov photons:",
 "    LABS=0 no absorbtion of photons;", "    LABS=1 absorbtion of photons;" };
static KmCommand _GEANT_PHYSICS_LABS = { &_GEANT_PHYSICS_LOSS,
 "/GEANT/PHYSICS/LABS", "LABS", 0, 2, 1, 0, _GEANT_PHYSICS_LABS_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_PHYSICS_LABS_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParInt    _GEANT_PHYSICS_HADR_IHADR_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_HADR_IHADR = { "IHADR", 5, "Flag IHADR",
 "1", (char*)0, 8, 0, (char**)0, 0, (char**)0, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_HADR_IHADR_type };
static KmParameter *_GEANT_PHYSICS_HADR_parameters[] = {
 &_GEANT_PHYSICS_HADR_IHADR };
static char *_GEANT_PHYSICS_HADR_guidance[] = {
 "To control hadronic interactions.", " IHADR=0 no hadronic interactions.",
 "      =1 Hadronic interactions. secondaries processed.",
 "      =2 Hadronic interactions. No secondaries stored." };
static KmCommand _GEANT_PHYSICS_HADR = { &_GEANT_PHYSICS_LABS,
 "/GEANT/PHYSICS/HADR", "HADR", 0, 2, 1, 0, _GEANT_PHYSICS_HADR_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_HADR_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static KmParReal   _GEANT_PHYSICS_ERAN_EKMIN_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_ERAN_EKMIN = { "EKMIN", 5,
 "Minimum energy of the tables", "1E-5", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_ERAN_EKMIN_type };
static KmParReal   _GEANT_PHYSICS_ERAN_EKMAX_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_ERAN_EKMAX = { "EKMAX", 5,
 "Maximum energy of the tables", "1E+4", (char*)0, 12, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_REAL, &_GEANT_PHYSICS_ERAN_EKMAX_type };
static KmParInt    _GEANT_PHYSICS_ERAN_NEKBIN_type = { "1", "200", "1", "200",
 0 };
static KmParameter _GEANT_PHYSICS_ERAN_NEKBIN = { "NEKBIN", 6,
 "Number of bins in the tables", "90", (char*)0, 4, 0, (char**)0, 0,
 (char**)0, (KmParFlag)0, KmTYPE_INT, &_GEANT_PHYSICS_ERAN_NEKBIN_type };
static KmParameter *_GEANT_PHYSICS_ERAN_parameters[] = {
 &_GEANT_PHYSICS_ERAN_EKMIN, &_GEANT_PHYSICS_ERAN_EKMAX,
 &_GEANT_PHYSICS_ERAN_NEKBIN };
static char *_GEANT_PHYSICS_ERAN_guidance[] = {
 "To define the range and binning of internal tables." };
static KmCommand _GEANT_PHYSICS_ERAN = { &_GEANT_PHYSICS_HADR,
 "/GEANT/PHYSICS/ERAN", "ERAN", 0, 2, 3, 0, _GEANT_PHYSICS_ERAN_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 1,
 _GEANT_PHYSICS_ERAN_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_DRAY_IDRAY_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_DRAY_IDRAY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_DRAY_IDRAY = { "IDRAY", 5, "Flag IDRAY",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_DRAY_IDRAY_range, 3,
 _GEANT_PHYSICS_DRAY_IDRAY_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_DRAY_IDRAY_type };
static KmParameter *_GEANT_PHYSICS_DRAY_parameters[] = {
 &_GEANT_PHYSICS_DRAY_IDRAY };
static char *_GEANT_PHYSICS_DRAY_guidance[] = {
 "To control delta rays mechanism.", " IDRAY=0 no delta rays.",
 "      =1 Delta rays. secondaries processed.",
 "      =2 Delta rays. No secondaries stored." };
static KmCommand _GEANT_PHYSICS_DRAY = { &_GEANT_PHYSICS_ERAN,
 "/GEANT/PHYSICS/DRAY", "DRAY", 0, 2, 1, 0, _GEANT_PHYSICS_DRAY_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_DRAY_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_DCAY_IDCAY_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_DCAY_IDCAY_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_DCAY_IDCAY = { "IDCAY", 5, "Flag IDCAY",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_DCAY_IDCAY_range, 3,
 _GEANT_PHYSICS_DCAY_IDCAY_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_DCAY_IDCAY_type };
static KmParameter *_GEANT_PHYSICS_DCAY_parameters[] = {
 &_GEANT_PHYSICS_DCAY_IDCAY };
static char *_GEANT_PHYSICS_DCAY_guidance[] = { "To control Decay mechanism.",
 " IDCAY=0 no decays.", "      =1 Decays. secondaries processed.",
 "      =2 Decays. No secondaries stored." };
static KmCommand _GEANT_PHYSICS_DCAY = { &_GEANT_PHYSICS_DRAY,
 "/GEANT/PHYSICS/DCAY", "DCAY", 0, 2, 1, 0, _GEANT_PHYSICS_DCAY_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_DCAY_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_COMP_ICOMP_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_COMP_ICOMP_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_COMP_ICOMP = { "ICOMP", 5, "Flag ICOMP",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_COMP_ICOMP_range, 3,
 _GEANT_PHYSICS_COMP_ICOMP_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_COMP_ICOMP_type };
static KmParameter *_GEANT_PHYSICS_COMP_parameters[] = {
 &_GEANT_PHYSICS_COMP_ICOMP };
static char *_GEANT_PHYSICS_COMP_guidance[] = {
 "To control Compton scattering", " ICOMP=0 no Compton",
 "      =1 Compton. Electron processed.",
 "      =2 Compton. No electron stored." };
static KmCommand _GEANT_PHYSICS_COMP = { &_GEANT_PHYSICS_DCAY,
 "/GEANT/PHYSICS/COMP", "COMP", 0, 2, 1, 0, _GEANT_PHYSICS_COMP_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_COMP_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_CKOV_ICKOV_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_CKOV_ICKOV_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_CKOV_ICKOV = { "ICKOV", 5, "Flag ICKOV",
 "0", (char*)0, 8, 3, _GEANT_PHYSICS_CKOV_ICKOV_range, 3,
 _GEANT_PHYSICS_CKOV_ICKOV_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_CKOV_ICKOV_type };
static KmParameter *_GEANT_PHYSICS_CKOV_parameters[] = {
 &_GEANT_PHYSICS_CKOV_ICKOV };
static char *_GEANT_PHYSICS_CKOV_guidance[] = {
 "To control Cerenkov production", " ICOMP=0 no Cerenkov;",
 "      =1 Cerenkov;", "      =2 Cerenkov with primary stopped at each step."
 };
static KmCommand _GEANT_PHYSICS_CKOV = { &_GEANT_PHYSICS_COMP,
 "/GEANT/PHYSICS/CKOV", "CKOV", 0, 2, 1, 0, _GEANT_PHYSICS_CKOV_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_CKOV_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_BREM_IBREM_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_BREM_IBREM_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_BREM_IBREM = { "IBREM", 5, "Flag IBREM",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_BREM_IBREM_range, 3,
 _GEANT_PHYSICS_BREM_IBREM_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_BREM_IBREM_type };
static KmParameter *_GEANT_PHYSICS_BREM_parameters[] = {
 &_GEANT_PHYSICS_BREM_IBREM };
static char *_GEANT_PHYSICS_BREM_guidance[] = { "To control bremstrahlung.",
 " IBREM=0 no bremstrahlung", "      =1 bremstrahlung. Photon processed.",
 "      =2 bremstrahlung. No photon stored." };
static KmCommand _GEANT_PHYSICS_BREM = { &_GEANT_PHYSICS_CKOV,
 "/GEANT/PHYSICS/BREM", "BREM", 0, 2, 1, 0, _GEANT_PHYSICS_BREM_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_BREM_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_AUTO_IAUTO_range[] = { "0", "1" };
static KmParInt    _GEANT_PHYSICS_AUTO_IAUTO_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_AUTO_IAUTO = { "IAUTO", 5, "Flag IAUTO",
 "1", (char*)0, 8, 2, _GEANT_PHYSICS_AUTO_IAUTO_range, 2,
 _GEANT_PHYSICS_AUTO_IAUTO_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_AUTO_IAUTO_type };
static KmParameter *_GEANT_PHYSICS_AUTO_parameters[] = {
 &_GEANT_PHYSICS_AUTO_IAUTO };
static char *_GEANT_PHYSICS_AUTO_guidance[] = {
 "To control automatic calculation of tracking medium parameters:",
 " IAUTO=0 no automatic calculation;", "      =1 automati calculation." };
static KmCommand _GEANT_PHYSICS_AUTO = { &_GEANT_PHYSICS_BREM,
 "/GEANT/PHYSICS/AUTO", "AUTO", 0, 2, 1, 0, _GEANT_PHYSICS_AUTO_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 3,
 _GEANT_PHYSICS_AUTO_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_ANNI_IANNI_range[] = { "0", "1", "2" };
static KmParInt    _GEANT_PHYSICS_ANNI_IANNI_type = { (char*)0, (char*)0,
 (char*)0, (char*)0, 0 };
static KmParameter _GEANT_PHYSICS_ANNI_IANNI = { "IANNI", 5, "Flag IANNI",
 "1", (char*)0, 8, 3, _GEANT_PHYSICS_ANNI_IANNI_range, 3,
 _GEANT_PHYSICS_ANNI_IANNI_range, (KmParFlag)0, KmTYPE_INT,
 &_GEANT_PHYSICS_ANNI_IANNI_type };
static KmParameter *_GEANT_PHYSICS_ANNI_parameters[] = {
 &_GEANT_PHYSICS_ANNI_IANNI };
static char *_GEANT_PHYSICS_ANNI_guidance[] = {
 "To control positron annihilation.", " IANNI=0 no annihilation",
 "      =1 annihilation. Decays processed.",
 "      =2 annihilation. No decay products stored." };
static KmCommand _GEANT_PHYSICS_ANNI = { &_GEANT_PHYSICS_AUTO,
 "/GEANT/PHYSICS/ANNI", "ANNI", 0, 2, 1, 0, _GEANT_PHYSICS_ANNI_parameters, 0,
 0, gxphys_, (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 4,
 _GEANT_PHYSICS_ANNI_guidance, 0, (char**)0, (char*)0, (int*)0 };
 
static char *_GEANT_PHYSICS_guidance[] = {
 "Commands to set physics parameters." };
static KmMenu _GEANT_PHYSICS = {  (KmMenu*)0,  (KmMenu*)0, "/GEANT/PHYSICS",
 "PHYSICS", 2, &_GEANT_PHYSICS_ANNI, 1, _GEANT_PHYSICS_guidance };
 
static KmMenu _GEANT = {  (KmMenu*)0, &_GEANT_PHYSICS, "/GEANT", "GEANT", 1,
 (KmCommand*)0, 0, (char**)0 };
 
  klnkmenu( &_GEANT, 921023 );
}
 
 
#ifdef F77_LCASE
#  define gkfort_ gkfort
#  define gxfort_ gxfort
#endif
 
#ifdef F77_UCASE
#  define gkfort_ GKFORT
#  define gxfort_ GXFORT
#endif
 
#ifdef IBM370
#  pragma linkage(GKFORT,FORTRAN)
#  pragma linkage(GXFORT,FORTRAN)
#endif
 
extern void gkfort_();
extern void gxfort_();
 
void gkfort_()
{
 
static KmParameter _FORTRAN_FORTRAN_FNAME = { "FNAME", 5, "File name",
 (char*)0, (char*)0, 20, 0, (char**)0, 0, (char**)0, (KmParFlag)0,
 KmTYPE_CHAR,  (void*)0 };
static KmParameter *_FORTRAN_FORTRAN_parameters[] = { &_FORTRAN_FORTRAN_FNAME
 };
static char *_FORTRAN_FORTRAN_guidance[] = {
 "The routines in the file FNAME will be compiled by COMIS.",
 "If routines with names: UGEOM,GUKINE,GUOUT,UGLAST are found,",
 "then they will be automatically called by GXINT instead of",
 "the routines with the same names compiled with the standard",
 "Fortran compiler and linked with the application.",
 "The user callable routines from the GEANT library as well as",
 "routines from PACKLIB (HBOOK,HPLOT,HIGZ,ZEBRA) may be called",
 "from these user routines. All GEANT common blocks may be", "referenced.",
 "In case where the routine UGEOM is called several times,",
 "it is important to DROP all the initialisation data structures",
 "JVOLUM,JMATE,JTMED,etc already in memory by using the routine GIDROP.",
 " Example of an interactive session where the routine UGEOM is modified:",
 "", "   GEANT > Edit ugeom.for", "   GEANT > Fortran ugeom.for",
 "   GEANT > Call GIDROP", "   GEANT > Call UGEOM", "   GEANT > Dtree",
 "   GEANT > Edit ugeom.for", "   GEANT > Fortran ugeom.for",
 "   GEANT > Call GIDROP", "   GEANT > Call UGEOM", "   GEANT > Dtree",
 "If FNAME='-', calls to user routines is reset and standard",
 "routines called instead." };
static KmCommand _FORTRAN_FORTRAN = {  (KmCommand*)0, "/FORTRAN/FORTRAN",
 "FORTRAN", 0, 1, 1, 1, _FORTRAN_FORTRAN_parameters, 0, 0, gxfort_,
 (IntFunc*)0, (SUBROUTINE*)0, (pCharFunc*)0, 26, _FORTRAN_FORTRAN_guidance, 0,
 (char**)0, (char*)0, (int*)0 };
 
static KmMenu _FORTRAN = {  (KmMenu*)0,  (KmMenu*)0, "/FORTRAN", "FORTRAN", 1,
 &_FORTRAN_FORTRAN, 0, (char**)0 };
 
  klnkmenu( &_FORTRAN, 921023 );
}
 
#endif
