/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LVCOLUMN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TableColumn
extends Item {
    Table parent;
    boolean resizable = true;

    public TableColumn(Table table, int n) {
        super(table, TableColumn.checkStyle(n));
        this.parent = table;
        table.createItem(this, table.getColumnCount());
    }

    public TableColumn(Table table, int n, int n2) {
        super(table, TableColumn.checkStyle(n));
        this.parent = table;
        table.createItem(this, n2);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Widget.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    String getNameText() {
        return this.getText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public int getWidth() {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return 0;
        }
        int n2 = this.parent.handle;
        return OS.SendMessage(n2, 4125, n, 0);
    }

    public void pack() {
        int n;
        this.checkWidget();
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        int n3 = this.parent.handle;
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.text, true);
        int n4 = OS.SendMessage(n3, OS.LVM_GETSTRINGWIDTH, 0, tCHAR) + 10;
        if (this.image != null) {
            n = 0;
            if ((OS.COMCTL32_MAJOR << 16 | OS.COMCTL32_MINOR) >= 327760) {
                int n5 = OS.SendMessage(n3, 4127, 0, 0);
                n = OS.SendMessage(n5, 4629, 0, 0);
            } else {
                n = OS.GetSystemMetrics(45) * 3;
            }
            Rectangle rectangle = this.image.getBounds();
            n4 += rectangle.width + n * 2;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            if (this.image == null) {
                OS.SendMessage(n3, 4126, n2, -2);
            } else {
                OS.SendMessage(n3, 4126, n2, n4);
            }
        } else {
            OS.SendMessage(n3, 4126, n2, -1);
            n = OS.SendMessage(n3, 4125, n2, 0);
            if (n2 == 0 && this.parent.imageList == null) {
                n += 2;
            }
            if (n4 > n) {
                if (this.image == null) {
                    OS.SendMessage(n3, 4126, n2, -2);
                } else {
                    OS.SendMessage(n3, 4126, n2, n4);
                }
            } else if (n2 == 0) {
                OS.SendMessage(n3, 4126, n2, n);
            }
        }
    }

    void releaseChild() {
        super.releaseChild();
        this.parent.destroyItem(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n & 0x1024000) == 0) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1 || n2 == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        int n3 = this.parent.handle;
        LVCOLUMN lVCOLUMN = new LVCOLUMN();
        lVCOLUMN.mask = 17;
        OS.SendMessage(n3, OS.LVM_GETCOLUMN, n2, lVCOLUMN);
        lVCOLUMN.fmt &= 0xFFFFFFFC;
        int n4 = 0;
        if ((this.style & 0x4000) == 16384) {
            n4 = 0;
        }
        if ((this.style & 0x1000000) == 0x1000000) {
            n4 = 2;
        }
        if ((this.style & 0x20000) == 131072) {
            n4 = 1;
        }
        lVCOLUMN.fmt |= n4;
        OS.SendMessage(n3, OS.LVM_SETCOLUMN, n2, lVCOLUMN);
    }

    public void setImage(Image image) {
        int n;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((n = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setImage(image);
        int n2 = this.parent.handle;
        LVCOLUMN lVCOLUMN = new LVCOLUMN();
        lVCOLUMN.mask = 17;
        OS.SendMessage(n2, OS.LVM_GETCOLUMN, n, lVCOLUMN);
        if (image != null) {
            lVCOLUMN.fmt |= 0x800;
            lVCOLUMN.iImage = this.parent.imageIndex(image);
        } else {
            lVCOLUMN.fmt &= 0xFFFFF7FF;
        }
        OS.SendMessage(n2, OS.LVM_SETCOLUMN, n, lVCOLUMN);
    }

    public void setResizable(boolean bl) {
        this.checkWidget();
        this.resizable = bl;
    }

    public void setText(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setText(string);
        int n2 = this.parent.handle;
        LVCOLUMN lVCOLUMN = new LVCOLUMN();
        lVCOLUMN.mask = 1;
        OS.SendMessage(n2, OS.LVM_GETCOLUMN, n, lVCOLUMN);
        int n3 = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), string, true);
        int n4 = tCHAR.length() * TCHAR.sizeof;
        int n5 = OS.HeapAlloc(n3, 8, n4);
        OS.MoveMemory(n5, tCHAR, n4);
        lVCOLUMN.mask |= 4;
        lVCOLUMN.pszText = n5;
        int n6 = OS.SendMessage(n2, OS.LVM_SETCOLUMN, n, lVCOLUMN);
        if (n5 != 0) {
            OS.HeapFree(n3, 0, n5);
        }
        if (n6 == 0) {
            this.error(13);
        }
    }

    public void setWidth(int n) {
        this.checkWidget();
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        int n3 = this.parent.handle;
        OS.SendMessage(n3, 4126, n2, n);
    }
}

