/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.win32.FILETIME;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.SHELLEXECUTEINFO;
import org.eclipse.swt.internal.win32.TCHAR;

public final class Program {
    String name;
    String command;
    String iconName;

    Program() {
    }

    public static Program findProgram(String string) {
        int[] nArray;
        TCHAR tCHAR;
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) != '.') {
            string = "." + string;
        }
        if (OS.RegOpenKeyEx(Integer.MIN_VALUE, tCHAR = new TCHAR(0, string, true), 0, 131097, nArray = new int[1]) != 0) {
            return null;
        }
        int[] nArray2 = new int[]{256};
        TCHAR tCHAR2 = new TCHAR(0, nArray2[0]);
        int n = OS.RegQueryValueEx(nArray[0], null, 0, null, tCHAR2, nArray2);
        OS.RegCloseKey(nArray[0]);
        if (n != 0) {
            return null;
        }
        return Program.getProgram(tCHAR2.toString(0, tCHAR2.strlen()));
    }

    public static String[] getExtensions() {
        Object object;
        Object object2 = new String[1024];
        TCHAR tCHAR = new TCHAR(0, 1024);
        int[] nArray = new int[]{tCHAR.length()};
        FILETIME fILETIME = new FILETIME();
        int n = 0;
        int n2 = 0;
        while (OS.RegEnumKeyEx(Integer.MIN_VALUE, n, tCHAR, nArray, null, null, null, fILETIME) != 259) {
            object = tCHAR.toString(0, nArray[0]);
            nArray[0] = tCHAR.length();
            if (((String)object).length() > 0 && ((String)object).charAt(0) == '.') {
                if (n2 == ((String[])object2).length) {
                    String[] stringArray = new String[((String[])object2).length + 1024];
                    System.arraycopy(object2, 0, stringArray, 0, ((String[])object2).length);
                    object2 = stringArray;
                }
                object2[n2++] = object;
            }
            ++n;
        }
        if (n2 != ((String[])object2).length) {
            object = new String[n2];
            System.arraycopy(object2, 0, object, 0, n2);
            object2 = object;
        }
        return object2;
    }

    static String getKeyValue(String string, boolean bl) {
        TCHAR tCHAR = new TCHAR(0, string, true);
        int[] nArray = new int[1];
        if (OS.RegOpenKeyEx(Integer.MIN_VALUE, tCHAR, 0, 131097, nArray) != 0) {
            return null;
        }
        String string2 = null;
        int[] nArray2 = new int[1];
        if (OS.RegQueryValueEx(nArray[0], null, 0, null, null, nArray2) == 0) {
            TCHAR tCHAR2;
            string2 = "";
            int n = nArray2[0] / TCHAR.sizeof;
            if (n != 0 && OS.RegQueryValueEx(nArray[0], null, 0, null, tCHAR2 = new TCHAR(0, n), nArray2) == 0) {
                if (!OS.IsWinCE && bl) {
                    n = OS.ExpandEnvironmentStrings(tCHAR2, null, 0);
                    if (n != 0) {
                        TCHAR tCHAR3 = new TCHAR(0, n);
                        OS.ExpandEnvironmentStrings(tCHAR2, tCHAR3, n);
                        string2 = tCHAR3.toString(0, Math.max(0, n - 1));
                    }
                } else {
                    n = Math.max(0, tCHAR2.length() - 1);
                    string2 = tCHAR2.toString(0, n);
                }
            }
        }
        if (nArray[0] != 0) {
            OS.RegCloseKey(nArray[0]);
        }
        return string2;
    }

    static Program getProgram(String string) {
        String string2 = Program.getKeyValue(string, false);
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        String string3 = "\\shell";
        String string4 = Program.getKeyValue(String.valueOf(string) + string3, true);
        if (string4 == null) {
            string4 = "open";
        }
        String string5 = "\\shell\\" + string4 + "\\command";
        String string6 = Program.getKeyValue(String.valueOf(string) + string5, true);
        if (string6 == null || string6.length() == 0) {
            return null;
        }
        String string7 = "\\DefaultIcon";
        String string8 = Program.getKeyValue(String.valueOf(string) + string7, true);
        if (string8 == null || string8.length() == 0) {
            return null;
        }
        Program program = new Program();
        program.name = string2;
        program.command = string6;
        program.iconName = string8;
        return program;
    }

    public static Program[] getPrograms() {
        Object object;
        Program[] programArray = new Program[1024];
        TCHAR tCHAR = new TCHAR(0, 1024);
        int[] nArray = new int[]{tCHAR.length()};
        FILETIME fILETIME = new FILETIME();
        int n = 0;
        int n2 = 0;
        while (OS.RegEnumKeyEx(Integer.MIN_VALUE, n, tCHAR, nArray, null, null, null, fILETIME) != 259) {
            object = tCHAR.toString(0, nArray[0]);
            nArray[0] = tCHAR.length();
            Program program = Program.getProgram((String)object);
            if (program != null) {
                if (n2 == programArray.length) {
                    Program[] programArray2 = new Program[programArray.length + 1024];
                    System.arraycopy(programArray, 0, programArray2, 0, programArray.length);
                    programArray = programArray2;
                }
                programArray[n2++] = program;
            }
            ++n;
        }
        if (n2 != programArray.length) {
            object = new Program[n2];
            System.arraycopy(programArray, 0, object, 0, n2);
            programArray = object;
        }
        return programArray;
    }

    public static boolean launch(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int n = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(0, string, true);
        int n2 = tCHAR.length() * TCHAR.sizeof;
        int n3 = OS.HeapAlloc(n, 8, n2);
        OS.MoveMemory(n3, tCHAR, n2);
        SHELLEXECUTEINFO sHELLEXECUTEINFO = new SHELLEXECUTEINFO();
        sHELLEXECUTEINFO.cbSize = 60;
        sHELLEXECUTEINFO.lpFile = n3;
        sHELLEXECUTEINFO.nShow = 5;
        boolean bl = OS.ShellExecuteEx(sHELLEXECUTEINFO);
        if (n3 != 0) {
            OS.HeapFree(n, 0, n3);
        }
        return bl;
    }

    public boolean execute(String string) {
        if (string == null) {
            SWT.error(4);
        }
        boolean bl = true;
        String string2 = this.command;
        String string3 = "";
        int n = this.command.indexOf("%1");
        if (n != -1) {
            int n2 = 0;
            int n3 = n + 2;
            int n4 = this.command.length();
            while (n3 < n4) {
                if (this.command.charAt(n3) == '\"') {
                    ++n2;
                }
                ++n3;
            }
            bl = n2 % 2 == 0;
            string2 = this.command.substring(0, n);
            string3 = this.command.substring(n + 2, n4);
        }
        if (bl) {
            string = " \"" + string + "\"";
        }
        try {
            Compatibility.exec(String.valueOf(string2) + string + string3);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public ImageData getImageData() {
        Object object;
        int n = 0;
        String string = this.iconName;
        int n2 = this.iconName.indexOf(44);
        if (n2 != -1) {
            string = this.iconName.substring(0, n2);
            object = this.iconName.substring(n2 + 1, this.iconName.length()).trim();
            try {
                n = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        object = new TCHAR(0, string, true);
        int[] nArray = new int[1];
        int[] nArray2 = null;
        OS.ExtractIconEx((TCHAR)object, n, nArray2, nArray, 1);
        if (nArray[0] == 0) {
            return null;
        }
        Image image = Image.win32_new(null, 1, nArray[0]);
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Program) {
            Program program = (Program)object;
            return this.name.equals(program.name) && this.command.equals(program.command) && this.iconName.equals(program.iconName);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.iconName.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

