/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PRINTDLG;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    int scope = 0;
    int startPage = 1;
    int endPage = 1;
    boolean printToFile = false;

    public PrintDialog(Shell shell) {
        this(shell, 32768);
    }

    public PrintDialog(Shell shell, int n) {
        super(shell, n);
        this.checkSubclass();
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int n) {
        this.scope = n;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int n) {
        this.startPage = n;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int n) {
        this.endPage = n;
    }

    public boolean getPrintToFile() {
        return this.printToFile;
    }

    public void setPrintToFile(boolean bl) {
        this.printToFile = bl;
    }

    protected void checkSubclass() {
    }

    public PrinterData open() {
        int n;
        PRINTDLG pRINTDLG = new PRINTDLG();
        pRINTDLG.lStructSize = 66;
        Shell shell = this.getParent();
        if (shell != null) {
            pRINTDLG.hwndOwner = shell.handle;
        }
        pRINTDLG.Flags = 262144;
        if (this.printToFile) {
            pRINTDLG.Flags |= 0x20;
        }
        switch (this.scope) {
            case 1: {
                pRINTDLG.Flags |= 2;
                break;
            }
            case 2: {
                pRINTDLG.Flags |= 1;
                break;
            }
            default: {
                pRINTDLG.Flags |= 0;
            }
        }
        pRINTDLG.nMinPage = 1;
        pRINTDLG.nMaxPage = (short)-1;
        pRINTDLG.nFromPage = (short)Math.min(65535, Math.max(1, this.startPage));
        pRINTDLG.nToPage = (short)Math.min(65535, Math.max(1, this.endPage));
        Display display = shell.getDisplay();
        Shell[] shellArray = display.getShells();
        if ((this.getStyle() & 0x30000) != 0) {
            int n2 = 0;
            while (n2 < shellArray.length) {
                if (shellArray[n2].isEnabled() && shellArray[n2] != shell) {
                    shellArray[n2].setEnabled(false);
                } else {
                    shellArray[n2] = null;
                }
                ++n2;
            }
        }
        PrinterData printerData = null;
        boolean bl = OS.PrintDlg(pRINTDLG);
        if ((this.getStyle() & 0x30000) != 0) {
            n = 0;
            while (n < shellArray.length) {
                if (shellArray[n] != null && !shellArray[n].isDisposed()) {
                    shellArray[n].setEnabled(true);
                }
                ++n;
            }
        }
        if (bl) {
            n = pRINTDLG.hDevNames;
            int n3 = OS.GlobalSize(n) / TCHAR.sizeof * TCHAR.sizeof;
            int n4 = OS.GlobalLock(n);
            short[] sArray = new short[4];
            OS.MoveMemory(sArray, n4, 2 * sArray.length);
            TCHAR tCHAR = new TCHAR(0, n3);
            OS.MoveMemory(tCHAR, n4, n3);
            OS.GlobalUnlock(n);
            short s = sArray[0];
            int n5 = 0;
            while (s + n5 < n3) {
                if (tCHAR.tcharAt(s + n5) == 0) break;
                ++n5;
            }
            String string = tCHAR.toString(s, n5);
            short s2 = sArray[1];
            n5 = 0;
            while (s2 + n5 < n3) {
                if (tCHAR.tcharAt(s2 + n5) == 0) break;
                ++n5;
            }
            String string2 = tCHAR.toString(s2, n5);
            short s3 = sArray[2];
            n5 = 0;
            while (s3 + n5 < n3) {
                if (tCHAR.tcharAt(s3 + n5) == 0) break;
                ++n5;
            }
            String string3 = tCHAR.toString(s3, n5);
            printerData = new PrinterData(string, string2);
            if ((pRINTDLG.Flags & 2) != 0) {
                printerData.scope = 1;
                printerData.startPage = pRINTDLG.nFromPage & 0xFFFF;
                printerData.endPage = pRINTDLG.nToPage & 0xFFFF;
            } else if ((pRINTDLG.Flags & 1) != 0) {
                printerData.scope = 2;
            }
            boolean bl2 = printerData.printToFile = (pRINTDLG.Flags & 0x20) != 0;
            if (printerData.printToFile) {
                printerData.fileName = string3;
            }
            printerData.copyCount = pRINTDLG.nCopies;
            printerData.collate = (pRINTDLG.Flags & 0x10) != 0;
            n = pRINTDLG.hDevMode;
            n3 = OS.GlobalSize(n);
            n4 = OS.GlobalLock(n);
            printerData.otherData = new byte[n3];
            OS.MoveMemory(printerData.otherData, n4, n3);
            OS.GlobalUnlock(n);
            this.endPage = printerData.endPage;
            this.printToFile = printerData.printToFile;
            this.scope = printerData.scope;
            this.startPage = printerData.startPage;
        }
        return printerData;
    }
}

