/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import org.eclipse.swt.internal.image.PngDecodingDataStream;

public class PngHuffmanTable {
    CodeLengthInfo[] codeLengthInfo;
    int[] codeValues;
    static final int MAX_CODE_LENGTH = 15;
    static final int BAD_CODE = 0xFFFFFFF;

    PngHuffmanTable(int[] nArray) {
        this.initialize(nArray);
        this.generateTable(nArray);
    }

    private void initialize(int[] nArray) {
        this.codeValues = new int[nArray.length];
        int n = 0;
        while (n < this.codeValues.length) {
            this.codeValues[n] = n;
            ++n;
        }
        this.codeLengthInfo = new CodeLengthInfo[15];
        n = 0;
        while (n < 15) {
            this.codeLengthInfo[n] = new CodeLengthInfo();
            this.codeLengthInfo[n].length = n;
            this.codeLengthInfo[n].baseIndex = 0;
            this.codeLengthInfo[n].min = 0xFFFFFFF;
            this.codeLengthInfo[n].max = -1;
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void generateTable(int[] var1_1) {
        var2_2 = 0;
        while (var2_2 < var1_1.length - 1) {
            var3_4 = var2_2 + 1;
            while (var3_4 < var1_1.length) {
                if (var1_1[var3_4] < var1_1[var2_2] || var1_1[var3_4] == var1_1[var2_2] && this.codeValues[var3_4] < this.codeValues[var2_2]) {
                    var4_5 = var1_1[var3_4];
                    var1_1[var3_4] = var1_1[var2_2];
                    var1_1[var2_2] = var4_5;
                    var4_5 = this.codeValues[var3_4];
                    this.codeValues[var3_4] = this.codeValues[var2_2];
                    this.codeValues[var2_2] = var4_5;
                }
                ++var3_4;
            }
            ++var2_2;
        }
        var2_3 = new int[var1_1.length];
        var3_4 = 0;
        var4_5 = 0;
        var5_6 = 0;
        ** GOTO lbl28
        {
            ++var3_4;
            var4_5 <<= 1;
            do {
                if (var3_4 != var1_1[var5_6]) continue block2;
                if (var3_4 != 0) {
                    var2_3[var5_6] = var4_5++;
                }
                ++var5_6;
lbl28:
                // 2 sources

            } while (var5_6 < var1_1.length);
        }
        var5_6 = 0;
        var6_7 = 0;
        while (var6_7 < var1_1.length) {
            if (var5_6 != var1_1[var6_7]) {
                var5_6 = var1_1[var6_7];
                this.codeLengthInfo[var5_6 - 1].baseIndex = var6_7;
                this.codeLengthInfo[var5_6 - 1].min = var2_3[var6_7];
            }
            if (var5_6 != 0) {
                this.codeLengthInfo[var5_6 - 1].max = var2_3[var6_7];
            }
            ++var6_7;
        }
    }

    int getNextValue(PngDecodingDataStream pngDecodingDataStream) {
        int n = pngDecodingDataStream.getNextIdatBit();
        int n2 = 0;
        while (n2 < 15 && n > this.codeLengthInfo[n2].max) {
            n = n << 1 | pngDecodingDataStream.getNextIdatBit();
            ++n2;
        }
        if (n2 >= 15) {
            pngDecodingDataStream.error();
        }
        int n3 = n - this.codeLengthInfo[n2].min;
        int n4 = this.codeLengthInfo[n2].baseIndex + n3;
        return this.codeValues[n4];
    }

    class CodeValuePair {
        int value;
        int code;

        CodeValuePair() {
        }
    }

    class CodeLengthInfo {
        int length;
        int max;
        int min;
        int baseIndex;

        CodeLengthInfo() {
        }
    }
}

