/**************************************************************************************************
	$Header: /pub/cvsroot/yencode/src/ypost/nntp.h,v 1.1 2002/03/15 15:10:49 bboy Exp $

	Copyright (C) 2002  Don Moore <bboy@bboy.net>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at Your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**************************************************************************************************/

#ifndef _NNTP_H
#define _NNTP_H

/*+ 1xx: Informative message +*/
#define STATUS_INFORMATIVE(n)    ((n >= 100) && (n <= 199))

/*+ 2xx: Command ok +*/
#define STATUS_OK(n)             ((n >= 200) && (n <= 299))

/*+ 3xx: Command ok so far, send the rest of it +*/
#define STATUS_OK_CONTINUE(n)    ((n >= 300) && (n <= 399))

/*+ 4xx: Command was correct, but couldn't be performed for some reason +*/
#define STATUS_INTERNAL_ERR(n)   ((n >= 400) && (n <= 499))

/*+ 5xx: Command unimplemented, incorrect, or a serious program error occurred +*/
#define STATUS_ERROR(n)          ((n >= 500) && (n <= 599))

/* This matches anything that's not 1xx, 2xx, or 3xx.. */
#define STATUS_ERR(n)            ((STATUS_INTERNAL_ERR(n)) || (STATUS_ERROR(n)))


extern int nntp_fd;												/* Connection to NNTP server */

extern inline int nntp_get_reply_num(const char *reply);
extern void nntp_connect(void);
extern void nntp_disconnect(void);
extern unsigned char *nntptrans(const char *fmt, ...) __printflike(1,2);
extern void nntptransx(const char *fmt, ...) __printflike(1,2);

#endif /* !_NNTP_H */

/* vi:set ts=3: */
