#! /bin/sh
set -e

cat <<EOF
/** @file mime-types.h
 * List of pre-defined extension - mime type mappings.
 *
 * This file contains the compiled-in defaults for the extension -
 * mime type mapping. It was generated from etc/mime.types. If you
 * want to change something, change there, not here. Or use the
 * command-line options. 
 */
#ifndef _THY_MIME_TYPES_H
#define _THY_MIME_TYPES_H 1 /**< mime-types.h multi-include guard. */

#include <stdlib.h>
#include "types.h"

/** Built-in mime type map.
 */
static const pair_t mime_types[] = {
EOF

while read line; do
	if echo "$line" | grep -q "^\([^ 	\#]\+\)[ 	]\+\(.\+\)"; then
		if [ ! -z "$line" ]; then
			line=$(echo "$line" | sed -e "s,[ 	]\+, ,g")
			type=$(echo "$line" | sed -e "s,^\([^ ]\+\).*,\1,")
			extensions=$(echo "$line" | sed -e "s,^[^ ]\+ ,,")
			for ext in $extensions; do
				echo "	{\".$ext\", \"$type\"},"
			done
		fi
	fi
done

cat <<EOF
	{NULL, NULL}};

#endif /* !_THY_MIME_TYPES_H */
EOF
