//***********************************************************//
//  StringFlt.cpp: Implementation of the StringFlt Object    //
//                                                           //
//                                                           //
//                                                           //
//***********************************************************//

#include "StringFlt.h"

//////////CONSTRUCTION /////////////////////

StringFlt::StringFlt(){

m_vdtime = 0.f;
m_fdbgain = 0.f;
m_fr = 0.f;
m_a = 0.f;
m_delaytime = .05f;
m_size = (long) 2205;
if(!(m_delay = new float[m_size])){
     m_error = 13;
	 cout << ErrorMessage();
    return;
}
m_APDelay = m_LPDelay = 0.f;
Reset();

AddMsg("feedback gain", 31);
AddMsg("frequency", 32);


}

StringFlt::StringFlt(float fr, float fdbgain, SndObj* inObj, 
					 SndObj* InFrObj, int vecsize, float sr) :
			DelayLine(.05f, inObj, vecsize, sr)
{

m_inputfr = InFrObj;
m_fr = fr;
if(fr && fr < 20) m_fr = 20.f;

float tdelay = m_sr/m_fr;
int delay = (int) (tdelay -.5);
float fracdelay = (float)(tdelay - (delay +.5));
m_a = (1-fracdelay)/(1+fracdelay);

m_rpointer = 0;
m_vdtime =  m_size - tdelay;
m_fdbgain = fdbgain;

m_APDelay = m_LPDelay = 0.f;

AddMsg("feedback gain", 31);
AddMsg("frequency", 32);


}

StringFlt::~StringFlt()
{

}

//////////////////OPERATIONS //////////////////////

void
StringFlt::SetSr(float sr){
m_sr = sr;
float tdelay = m_sr/m_fr;
int delay = (int) (tdelay -.5);
float fracdelay = (float)(tdelay - (delay +.5));
m_a = (1-fracdelay)/(1+fracdelay);
m_delaytime = .05f;
m_size = (long)(m_delaytime*m_sr);
m_vdtime = m_size - tdelay;
if(m_delay)delete[] m_delay;
if(!(m_delay = new float[m_size])){
     m_error = 13;
	 cout << ErrorMessage();
}
return;
}


void
StringFlt::SetFreq(float fr, SndObj* InFrObj){
  m_fr = fr;     
  if(fr < 20)m_fr = 20.f;  
      m_inputfr = InFrObj;      
      float tdelay = m_sr/m_fr;
      int delay = (int) (tdelay -.5);
      float fracdelay = (float)(tdelay - (delay +.5));
      m_a = (1-fracdelay)/(1+fracdelay);
      m_vdtime = m_size - tdelay;
      
}


int
StringFlt::Set(char* mess, float value){

	switch (FindMsg(mess)){

	case 31:
    SetFdbgain(value);
	return 1;

	case 32:
	SetFreq(value);
    return 1;
	
	case 1:
	SetSr(value);
    return 1;

	default:
    return DelayLine::Set(mess,value);
     
	}


}

int
StringFlt::Connect(char* mess, void* input){

	switch (FindMsg(mess)){

	case 32:
	m_inputfr = (SndObj *) input;
    return 1;

	default:
		return SndObj::Connect(mess,input);
     
	}


}


short
StringFlt::DoProcess(){
if(!m_error){
if(m_input){
  float fr, pos, tdelay, fracdelay, w, s, output;
  int delay;
for(m_vecpos=0; m_vecpos<m_vecsize;m_vecpos++){
 if(m_enable){
       if(m_inputfr){
       fr = m_fr + m_inputfr->Output(m_vecpos);
       if(fr < 20.f) fr = 20.f;
       tdelay = m_sr/fr;
       delay = (int)(tdelay - .5);
       fracdelay = (tdelay  - (delay +.5f));
       m_vdtime = m_size - tdelay;
       m_a = (1-fracdelay)/(1+fracdelay);
          } 
   
   pos = m_wpointer + m_vdtime;
   while(pos > m_size) pos -= m_size;
   while(pos < 0) pos += m_size;

   w = GetSample(pos) + m_input->Output(m_vecpos);
   s = m_LPDelay*.5f + w*.5f;
   m_LPDelay = w;
   output = m_APDelay + s*(m_a);
   m_APDelay = s + output*(-m_a);
   PutSample(output*m_fdbgain); 
   m_output[m_vecpos] = output;  
    } 
 else m_output[m_vecpos] = 0.f;
}
 return 1;
}
else { m_error =11;
       return 0;
}
}
else return 0;
}











