#include "SpecMult.h"


SpecMult::SpecMult(){
SetVectorSize(DEF_FFTSIZE);
m_input2 = 0;
AddMsg("input 2", 21);

}


SpecMult::SpecMult(SndObj* input1, SndObj* input2, int vecsize,
		    float sr)
			: SndObj(input1, vecsize, sr){

m_input2 = input2;
AddMsg("input 2", 21);

}

SpecMult::~SpecMult(){
}

int
SpecMult::Connect(char* mess, void* input){

	switch(FindMsg(mess)){

    case 21:
	SetInput2((SndObj*) input);
    return 1;

	default:
		return SndObj::Connect(mess, input);

	}


}

short
SpecMult::DoProcess(){

if(!m_error){
 if(m_input && m_input2){
	 float re1,re2,im1,im2;
	 for(m_vecpos = 2; m_vecpos < m_vecsize; m_vecpos+=2) {

		// every complex pair except 0 and nyquist
		 if(m_enable) {
        
          re1 = m_input->Output(m_vecpos);
		  re2 = m_input2->Output(m_vecpos); 
          im1 = m_input->Output(m_vecpos+1);
		  im2 = m_input2->Output(m_vecpos+1);      
		
		// complex multiplication (a+ib)*(c+id)
		// (ac - bd) - i(ad + bc)  
		  m_output[m_vecpos] = re1*re2 - im1*im2;
		  m_output[m_vecpos+1] = re1*im2 + im1*re2;

		}
		 else 
			 m_output[m_vecpos+1] = m_output[m_vecpos] = 0.f;
	 } 
	 m_output[0] = m_input->Output(0)*m_input2->Output(0);
	 m_output[1] = m_input->Output(1)*m_input2->Output(1);

 return 1;
 } else {
	m_error = 3;
	return 0;
 }
}
else return 0;

}
