#!/usr/bin/env python

#****************************************************************************
#** $Id: sqlcustom1.py,v 1.3 2002/07/06 13:35:41 phil Exp $
#**
#** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
#**
#** This file is part of an example program for PyQt.  This example
#** program may be used, distributed and modified without limitation.
#**
#*****************************************************************************/

import sys
from qt import *
from qtsql import *

from dbconnect import createConnection

TRUE  = 1
FALSE = 0

class CustomEdit(QLineEdit):
    def __init__(self, parent = None, name = None):
        QLineEdit.__init__(self, parent, name)
        QObject.connect(self, SIGNAL("textChanged(const QString &)"),
                        self.changed)

    def changed(self, line):
        self.setUpperLine(line)

    def setUpperLine(self, line):
        self.upperLineText = line.upper()
        self.setText(self.upperLineText)


class FormDialog(QDialog):
    def __init__(self):
        QDialog.__init__(self)
        forenameLabel = QLabel("Forename:", self)
        forenameEdit = CustomEdit(self)
        surnameLabel = QLabel("Surname:", self)
        surnameEdit = CustomEdit(self)
        salaryLabel = QLabel("Salary:", self)
        salaryEdit = QLineEdit(self)
        salaryEdit.setAlignment(Qt.AlignRight)
        saveButton = QPushButton("&Save", self)
        self.connect(saveButton, SIGNAL("clicked()"), self.save)

        grid = QGridLayout(self)
        grid.addWidget(forenameLabel, 0, 0)
        grid.addWidget(forenameEdit, 0, 1)
        grid.addWidget(surnameLabel, 1, 0)
        grid.addWidget(surnameEdit, 1, 1)
        grid.addWidget(salaryLabel, 2, 0)
        grid.addWidget(salaryEdit, 2, 1)
        grid.addWidget(saveButton, 3, 0)
        grid.activate()

        self.staffCursor = QSqlCursor("staff")
        self.staffCursor.setTrimmed("forename", TRUE)
        self.staffCursor.setTrimmed("surname", TRUE)
        self.idIndex = self.staffCursor.index("id")
        self.staffCursor.select(self.idIndex)
        self.staffCursor.first()

        self.propMap = QSqlPropertyMap()
        self.propMap.insert(forenameEdit.className(), "upperLine")

        self.sqlForm = QSqlForm()
        self.sqlForm.setRecord(self.staffCursor.primeUpdate())
        self.sqlForm.installPropertyMap(self.propMap)
        self.sqlForm.insert(forenameEdit, "forename")
        self.sqlForm.insert(surnameEdit, "surname")
        self.sqlForm.insert(salaryEdit, "salary")
        self.sqlForm.readFields()

    def save(self):
        self.sqlForm.writeFields()
        self.staffCursor.update()
        self.staffCursor.select(self.idIndex)
        self.staffCursor.first()


if __name__=='__main__':
    app = QApplication( sys.argv )

    if createConnection():
        formDialog = FormDialog()
        formDialog.show()

        app.setMainWidget(formDialog)
        app.exec_loop()


