
import os, posixpath
from Ft.Lib import Uri
from Ft.Server.Common.Install import Serialize
from Ft.Server.Common import AclConstants, ResourceTypes

BASE_URI = Uri.OsPathToUri(os.path.abspath(__file__))

def GetTestUri(*parts):
    path = posixpath.join(*parts)
    return Uri.BaseJoin(BASE_URI, path)

def Test(tester):

    tester.startTest("Read File simple.xml")

    uri = Uri.BaseJoin(BASE_URI, 'simple.xml')
    f = open(Uri.UriToOsPath(uri))
    pl = Serialize.Deserialize(f, refUri=uri)
    f.close()

    tester.testDone()
    
    tester.startTest("Containers Loaded")

    #There should be a container in the resource list with a path of /test
    c = FindResource(tester,'/test',pl)

    tester.compare('/test',c.path)
    tester.compare(AclConstants.SUPER_USER_GROUP_NAME,c.owner)

    tester.compare(3,len(c.acl))
    tester.compareIn(c.acl,(u'write', 'super-users', 1))
    tester.compareIn(c.acl,(u'read', 'world', 1))
    tester.compareIn(c.acl,(u'read', u'owner', 1))
    tester.compare(None,c.docDef)
    tester.compare('text/xml',c.imt)
    tester.compare(ResourceTypes.ResourceType.CONTAINER,c.resourceType)
    tester.testDone()

    tester.startTest("Raw File")
    r = FindResource(tester,'/test/test1.html',pl)
    tester.compare('/test/test1.html',r.path)
    tester.compare(None,r.owner)
    tester.compare(0,len(r.acl))
    tester.compare('text/html',r.imt)
    tester.compare(ResourceTypes.ResourceType.RAW_FILE,r.resourceType)
    tester.compare(GetTestUri('test1.html'), r.contentUri)
    tester.testDone()

    for (name,path,dd,rt) in [('Xml Document','test1.xml','test1.xpdd',ResourceTypes.ResourceType.XML_DOCUMENT),
                              ('Xslt Document','test1.xslt',None,ResourceTypes.ResourceType.XSLT_DOCUMENT),
                              ('Schematron Document','test1.schematron',None,ResourceTypes.ResourceType.SCHEMATRON_DOCUMENT),
                              ('RDF Document','test1.rdf',None,ResourceTypes.ResourceType.RDF_DOCUMENT),
                              ('Server','test1.server',None,ResourceTypes.ResourceType.SERVER),
                              ('Command','test1.command',None,ResourceTypes.ResourceType.COMMAND),
                              ('XPath Document Definition','test1.xpdd',None,ResourceTypes.ResourceType.XPATH_DOCUMENT_DEFINITION),
                              ('Xslt Document Definition','test1.xsltdd',None,ResourceTypes.ResourceType.XSLT_DOCUMENT_DEFINITION),
                              ]:
        tester.startTest(name)
        r = FindResource(tester,'/test/' + path,pl)
        tester.compare('/test/' + path,r.path)
        tester.compare(None,r.owner)
        tester.compare(0,len(r.acl))
        tester.compare('text/xml',r.imt)
        tester.compare(dd,r.docDef)
        tester.compare(rt,r.resourceType)
        tester.compare(GetTestUri(path), r.contentUri)
        tester.testDone()


    tester.startTest("URI Reference File")
    r = FindResource(tester,'/test/test1.uri',pl)
    tester.compare('/test/test1.uri',r.path)
    tester.compare(None,r.owner)
    tester.compare(0,len(r.acl))
    tester.compare('text/plain',r.imt)
    tester.compare(ResourceTypes.ResourceType.URI_REFERENCE_FILE,r.resourceType)
    tester.compare(None,r.contentUri)
    tester.compare(GetTestUri('test1.uri'),r.href)
    tester.testDone()

    tester.startTest("User")
    r = FindResource(tester,'/test/test-user',pl)
    tester.compare('/test/test-user',r.path)
    tester.compare(None,r.owner)
    tester.compare(0,len(r.acl))
    tester.compare('text/xml',r.imt)
    tester.compare(None,r.docDef)
    tester.compare(ResourceTypes.ResourceType.USER,r.resourceType)
    tester.compare('test-user',r.userName)
    tester.compare('/test',r.basePath)
    tester.compare('test',r.password)
    tester.compare(None,r.contentUri)
    tester.warning("Test User Data")
    tester.testDone()

    tester.startTest("Group")
    r = FindResource(tester,'/test/test-group',pl)
    tester.compare('/test/test-group',r.path)
    tester.compare(None,r.owner)
    tester.compare(0,len(r.acl))
    tester.compare('text/xml',r.imt)
    tester.compare(None,r.docDef)
    tester.compare(ResourceTypes.ResourceType.GROUP,r.resourceType)
    tester.compare('test-group',r.groupName)
    tester.compare('/test',r.basePath)
    tester.compare(1,len(r.members))
    tester.compareIn(r.members,'test-user')
    tester.compare(None,r.contentUri)
    tester.testDone()

    tester.startTest("Alias")
    r = FindResource(tester,'/test/test1.alias',pl)
    tester.compare('/test/test1.alias',r.path)
    tester.compare(None,r.owner)
    tester.compare(0,len(r.acl))
    tester.compare('text/xml',r.imt)
    tester.compare(None,r.docDef)
    tester.compare(ResourceTypes.ResourceType.ALIAS,r.resourceType)
    tester.compare('/test/test1.html',r.reference)
    tester.compare(None,r.contentUri)
    tester.testDone()

    tester.startTest("Include")
    r = FindResource(tester,'/test/test2.html',pl)
    tester.compare('/test/test2.html',r.path)
    tester.compare(None,r.owner)
    tester.compare(0,len(r.acl))
    tester.compare('text/html',r.imt)
    tester.compare(ResourceTypes.ResourceType.RAW_FILE,r.resourceType)
    tester.compare(GetTestUri('test2.html'), r.contentUri)
    tester.testDone()

    tester.startTest("Mirror")

    #Make sure all of the mirrored resources got copied
    r = FindResource(tester,'/test/mirror/mirror1.html',pl)
    tester.compare('/test/mirror/mirror1.html',r.path)
    tester.compare(None,r.owner)
    tester.compare(0,len(r.acl))
    tester.compare('text/html',r.imt)
    tester.compare(ResourceTypes.ResourceType.RAW_FILE,r.resourceType)
    tester.compare(GetTestUri('mirror', 'mirror1.html'), r.contentUri)

    r = FindResource(tester,'/test/mirror/mirror1.jpg',pl)
    tester.compare('/test/mirror/mirror1.jpg',r.path)
    tester.compare(None,r.owner)
    tester.compare(0,len(r.acl))
    tester.compare('image/jon',r.imt)
    tester.compare(ResourceTypes.ResourceType.RAW_FILE,r.resourceType)
    tester.compare(GetTestUri('mirror', 'mirror1.jpg'), r.contentUri)

    r = FindResource(tester,'/test/mirror/mirror1.dc',pl)
    tester.compare('/test/mirror/mirror1.dc',r.path)
    tester.compare(None,r.owner)
    tester.compare(0,len(r.acl))
    tester.compare('text/xml',r.imt)
    tester.compare(None,r.docDef)
    tester.compare(ResourceTypes.ResourceType.XML_DOCUMENT,r.resourceType)
    tester.compare(GetTestUri('mirror', 'mirror1.dc'), r.contentUri)

    r = FindResource(tester,'/test/mirror/mirror1.doc',pl)
    tester.compare('/test/mirror/mirror1.doc',r.path)
    tester.compare(None,r.owner)
    tester.compare(0,len(r.acl))
    tester.compare('text/xml',r.imt)
    tester.compare('/test/test1.xsltdd',r.docDef)
    tester.compare(ResourceTypes.ResourceType.XML_DOCUMENT,r.resourceType)
    tester.compare(GetTestUri('mirror', 'mirror1.doc'), r.contentUri)

    c = FindResource(tester,'/test/mirror/sub',pl)
    tester.compare('/test/mirror/sub',c.path)
    tester.compare(None,c.owner)
    tester.compare(0,len(c.acl))
    tester.compare(None,c.docDef)
    tester.compare('text/xml',c.imt)
    tester.compare(ResourceTypes.ResourceType.CONTAINER,c.resourceType)

    r = FindResource(tester,'/test/mirror/sub/mirror2.html',pl)
    tester.compare('/test/mirror/sub/mirror2.html',r.path)
    tester.compare(None,r.owner)
    tester.compare(0,len(r.acl))
    tester.compare('text/html',r.imt)
    tester.compare(ResourceTypes.ResourceType.RAW_FILE,r.resourceType)
    tester.compare(GetTestUri('mirror', 'sub', 'mirror2.html'), r.contentUri)



    tester.testDone()




def FindResource(tester,path,pl):
    for r in pl.resourceList:
        if r.path == path:
            return r
    tester.error("Resource %s not read from file" % path)
        
