import sys, os
p = os.path.join("..")
sys.path.append(p)
import profile_util
from Ft.Rdf import Model
from Ft.Rdf import Statement

NUM_STATEMENT = 10000

REDUNDANT_FACTOR=10
BLOCK_SIZE = 500
        


def do_complete(db):
    #db = profile_util.GetRdfDriver()
    db.begin()
    m = Model.Model(db)
    m.complete('sub-empty','pred-empty','obj-empty')
    db.commit()



def do_profile():


    num_statements = NUM_STATEMENT
    db = profile_util.GetRdfDriver()
    m = Model.Model(db)
    numOuter = int(NUM_STATEMENT/REDUNDANT_FACTOR)
    for outer in range(numOuter):
        for ctr in range(REDUNDANT_FACTOR):
            stmt = Statement.Statement('sub%d'%ctr,
                                       'pred%d'%ctr,
                                       'obj%d'%ctr,
                                       'uri%d'%ctr)
            m.add([stmt])

    db.commit()

    profile_util.run("do_complete(db)",globals(),locals())

if __name__ == '__main__':
    profile_util.InitModel()
    do_profile()



