########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Rdf/__init__.py,v 1.17 2004/10/16 05:35:58 mbrown Exp $
"""
An RDF processing library with support for persistent data models

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft import __version__

BNODE_BASE = 'http://4suite.org/rdf/anonymous/'
BNODE_BASE_LEN = len(BNODE_BASE)

RDF_MS_BASE = 'http://www.w3.org/1999/02/22-rdf-syntax-ns#'
RDF_SCHEMA_BASE = "http://www.w3.org/2000/01/rdf-schema#"
RIL_NAMESPACE = 'http://namespaces.rdfinference.org/ril'

OLD_DAML_OIL_NS = 'http://www.daml.org/2001/03/daml+oil#'
DAML_OIL_NS = 'http://www.w3.org/2001/10/daml+oil#'

OWL_NS = 'http://www.w3.org/2002/07/owl#'

OBJECT_TYPE_UNKNOWN = "?"
OBJECT_TYPE_RESOURCE = "R"
OBJECT_TYPE_LITERAL = "L"

ANONYMOUS_FRAGMENT_BASE = 'anonymous:'

class SchemaHandler:
    def initModel(self):
        return

    def suspend(self):
        old = self._active
        self._active = 0
        return old

    def resume(self):
        old = self._active
        self._active = 1
        return old

    def setActivity(self, value):
        old = self._active
        self._active = value and 1 or 0
        return old

    def add(self, statements):
        return

    def remove(self, statements):
        return

    def contains(self, statements):
        return


class RdfException(Exception):
    INTERNAL_ERROR = 0
    FEATURE_NOT_SUPPORTED = 1
    INVALID_FLAG = 2
    INVALID_CONTAINER_TYPE = 3
    INVALID_REGEX_STATEMENT = 4
    INVALID_ARGUMENT = 5
    INVALID_CONTAINER_ITEM_TYPE = 6
    ABOUT_EACH_OBJECT_NOT_CONTAINER = 100
    MISSING_DRIVER = 200

    def __init__(self, errorCode, *args):
        import MessageSource
        self.args = args
        self.errorCode = errorCode
        Exception.__init__(self, MessageSource.RDF_ERROR_MESSAGES[errorCode]%args)


class ParseException(Exception):
    FEATURE_NOT_SUPPORTED = 1
    INVALID_PREDICATE = 10
    INVALID_CONTAINER_PROPERTY = 20
    INVALID_CONTAINER_TYPE = 30
    MULTIPLE_VALUE_OBJECTS = 40
    NONEMPTY_PROPELT_WITH_PROPATTRS = 50
    NONEMPTY_PROPELT_WITH_RESATTR = 51

    def __init__(self, errorCode, *args):
        import MessageSource
        self.args = args
        self.errorCode = errorCode
        Exception.__init__(self, MessageSource.PARSE_ERROR_MESSAGES[errorCode]%args)
