--TEST--
maxdb bind_param/bind_result with send_long_data 
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
	include "connect.inc";

	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);
  	maxdb_query($link,"DROP TABLE test_bind_fetch");
        maxdb_report (MAXDB_REPORT_ERROR);

  	maxdb_query($link,"CREATE TABLE test_bind_fetch(c1 varchar(11), c2 long ascii)");

	$stmt = maxdb_prepare ($link, "INSERT INTO test_bind_fetch VALUES (?,?)");
	maxdb_bind_param($stmt, "sb", $c1, $c2);

	$c1 = "Hello World";

	maxdb_send_long_data($stmt, 1, "This is the first sentence.");
	maxdb_send_long_data($stmt, 1, " And this is the second sentence.");
	maxdb_send_long_data($stmt, 1, " And finally this is the last sentence.");

	maxdb_execute($stmt);
	maxdb_stmt_close($stmt);

	$stmt = maxdb_prepare($link, "SELECT * FROM test_bind_fetch");
	maxdb_bind_result($stmt, $d1, $d2);
	maxdb_execute($stmt);
	maxdb_fetch($stmt);

	$test = array($d1,$d2);

	var_dump($test);

	maxdb_stmt_close($stmt);

	maxdb_close($link);
?>
--EXPECT--
array(2) {
  [0]=>
  string(11) "Hello World"
  [1]=>
  string(99) "This is the first sentence. And this is the second sentence. And finally this is the last sentence."
}
