#ifndef NPLUGIN_IAPTMEDIATOR_H_2005_03_06
#define NPLUGIN_IAPTMEDIATOR_H_2005_03_06

#include <qstringlist.h>

namespace NPlugin
{

/** @brief This interface is used to allow the Apt-Plugins to communicate with
  * each other without having to know each other.
  *
  * @author Benjamin Mesing
  */
class IAptMediator 
{
public:
	/** @brief Returns the list of patterns currently searched for by the AptSearchPlugin.
	  *
	  * @returns the list of patterns currently searched for, an empty list if no searched
	  * is active or the plugin is not available
	  */
	virtual QStringList searchPatterns() = 0;
};

}	// namespace NPlugin

#endif // NPLUGIN_IAPTMEDIATOR_H_2005_03_06

