/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include "pxmchem-findmassopt.h"



/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmFindmassOpt *
pxmchem_findmassopt_new (void)
{
  PxmFindmassOpt *fmopt = g_malloc0 (sizeof (PxmFindmassOpt));
  
  return fmopt;
}


PxmFindmassOpt *
pxmchem_findmassopt_dup (PxmFindmassOpt *fmopt, gint how_dup)
{
  PxmFindmassOpt *fmopt_new = g_malloc0 (sizeof (PxmFindmassOpt));
  
  g_assert (fmopt != NULL);
  
  fmopt_new->mass = fmopt->mass;
  fmopt_new->mass_type = fmopt->mass_type;

  fmopt_new->tolerance = fmopt->tolerance;
  fmopt_new->tolerance_type = fmopt->tolerance_type;

  return fmopt_new;
}


PxmProp *
pxmchem_findmassopt_prop_dup (PxmProp * prop, gint how_dup)
{
  PxmProp *prop_new = NULL;
  
  g_assert (prop != NULL);
  g_assert (prop->name != NULL);
  g_assert (prop->data != NULL);
  
  prop_new = libpolyxmass_prop_new ();
  
  libpolyxmass_prop_set_name (prop_new, prop->name);
  
  prop_new->data = 
    (gpointer) pxmchem_findmassopt_dup ((PxmFindmassOpt *) prop->data,
					how_dup);
  
  return prop_new;
}


/* UTILITY FUNCTIONS
 */
gboolean
pxmchem_findmassopt_set_default (PxmFindmassOpt *fmopt)
{
  g_assert (fmopt != NULL);
  
  fmopt->mass_type = PXM_MASS_MONO;
  
  fmopt->tolerance_type = PXM_MASS_TOLERANCE_AMU;

  return TRUE;
}


  

/* FREE'ING FUNCTIONS
 */
gboolean
pxmchem_findmassopt_free (PxmFindmassOpt *fmopt)
{
  g_assert (fmopt != NULL);
  
  g_free (fmopt);
  
  return TRUE;
}

gint 
pxmchem_findmassopt_prop_free (PxmProp *prop)
{
  g_assert (prop != NULL);
  
  if (prop->name != NULL)
    g_free (prop->name);
  
  if (prop->data == NULL)
    return TRUE;
  
  /* Now free the findmassopt data.
   */
  return pxmchem_findmassopt_free ((PxmFindmassOpt *) prop->data);
}


/* GPtrArray-RELATED FUNCTIONS
 */
gint
pxmchem_findmassopt_GPA_free (GPtrArray *GPA)
{
  gint count = 0;
  
  PxmFindmassOpt *fmopt = NULL;
  

  g_assert (GPA != NULL);
  
  while (GPA->len > 0)
    {
      fmopt = g_ptr_array_remove_index (GPA, 0);
      g_assert (fmopt != NULL);
      pxmchem_findmassopt_free (fmopt);
      count++;
    }
  
  g_ptr_array_free (GPA, TRUE);

  return count;
}
