/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef PXMCHEM_CLEAVE_H
#define PXMCHEM_CLEAVE_H

#include "libpolyxmass-globals.h"
#include "pxmchem-polymer.h"
#include "pxmchem-cleavespec.h"
#include "pxmchem-cleaveopt.h"
#include "pxmchem-oligomer.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/*********************** POLYMER CLEAVING STUFF ************************/

gint
pxmchem_cleave_polymer (PxmPolymer *polymer,
			GPtrArray *GPA,
			PxmPolchemdef *polchemdef,			
			PxmCleaveOpt *cleaveopt, 
			PxmCalcOpt *calcopt,
			PxmIonizerule *ionizerule);
  
gint
pxmchem_cleave_parse_cleavespec_pattern (PxmCleaveSpec *cls,
					     gchar *delim_codes,
					     gint codelen);

gint
pxmchem_cleave_parse_cleavage_site (gchar *site,
					PxmCleavemotif *clm,
					gchar *delim_codes,
					gint codelen);

gint
pxmchem_cleave_fill_cleave_nocleave_GA (PxmPolymer *polymer,
				      PxmCleaveSpec *cleavespec,
				      GArray *cleaveGA, GArray *nocleaveGA);

gint
pxmchem_cleave_remove_nocleave_GA (GArray *cleaveGA, GArray *nocleaveGA);
  
gint
pxmchem_cleave_find_next_cleavemotif (PxmCleavemotif *cleavemotif,
					  GPtrArray *GPA,
				      gint idx);
  
gint
pxmchem_cleave_sort_increasing_cleave_GA (gconstpointer a,
					  gconstpointer b);
  

gint
pxmchem_cleave_fill_oligomer_GPA (PxmPolymer *polymer,
				  GPtrArray *GPA,
				  GArray *cleaveidxGA,
				  PxmPolchemdef *polchemdef,
				  PxmCleaveOpt *cleaveopt,
				  PxmCalcOpt *calcopt,
				  PxmIonizerule *ionizerule);
 
PxmOligomer *
pxmchem_cleave_oligomer_new_with_options (PxmPolymer *polymer,
					  gint start_idx,
					  gint end_idx,
					  gint index,
					  PxmCleaveOpt *cleaveopt,
					  PxmCalcOpt *calcopt,
					  PxmIonizerule *ionizerule,
					  PxmPolchemdef *polchemdef);

				  





















































#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* PXMCHEM_CLEAVE_H */
