/***************************************************************************
 $RCSfile: progressmonitor.cpp,v $
                             -------------------
    cvs         : $Id: progressmonitor.cpp,v 1.5 2002/07/28 12:05:18 derzach Exp $
    begin       : Sun Jun 09 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/



#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "progressmonitor.h"
#include <stdio.h>


namespace HBCI {

void ProgressMonitor::transactionStarted(TransProgressType type,
					 string const &descr, int jobs){
#if DEBUGMODE>0
    fprintf(stderr,"Transaction (type %d) started: %s\n",
	    type, descr.c_str());
#endif
}


void ProgressMonitor::transactionFinished(){
#if DEBUGMODE>0
    fprintf(stderr,"Transaction finished\n");
#endif
}


void ProgressMonitor::jobStarted(JobProgressType type,
				 const string &descr, int actions){
    fprintf(stderr,"Job (type %d) started: %s\n", type, descr.c_str());
}


void ProgressMonitor::jobFinished(){
#if DEBUGMODE>0
    fprintf(stderr,"Job finished\n");
#endif
}


void ProgressMonitor::actionStarted(ActionProgressType type,
				    const string &descr){
#if DEBUGMODE>0
    fprintf(stderr,"Action (type %d) started: %s\n", type, descr.c_str());
#endif
}


void ProgressMonitor::actionFinished(){
#if DEBUGMODE>0
    fprintf(stderr,"Action finished\n");
#endif
}


void ProgressMonitor::logMessage(const string &msg){
    fprintf(stderr,"Log: %s\n",msg.c_str());
}


} // namespace HBCI





