/***************************************************************************
 $RCSfile: adminjobs.cpp,v $
                             -------------------
    cvs         : $Id: adminjobs.cpp,v 1.31 2003/06/10 17:48:40 aquamaniac Exp $
    begin       : Mon Nov 19 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif

// #include <stdio.h> // DEBUG
// #include <list>

#include "hbcistring.h"
#include "accountparams.h"
#include "adminjobs.h"

#include "adminsegs.h"
#include "seg.h"
#include "mediumrdhbase.h"


namespace HBCI {

/*AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 JOBDialogInit
 AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 */


JOBDialogInit::JOBDialogInit(Pointer<Customer> cust,
			     bool anonymous,
			     bool needcrypt,
			     bool needsign,
			     bool getkeys,
			     bool sync)
: Job(cust)
,_anonymous(anonymous)
,_sync(sync)
,_crypt(needcrypt)
,_sign(needsign)
,_getkeys(getkeys)
{
  if (Hbci::debugLevel()>5)
    fprintf(stderr,"JOBDialogInit::JOBDialogInit()\n");
  _upd.setDescription("JOBDialogInit::_upd");
  _bpd.setDescription("JOBDialogInit::_bpd");
}


JOBDialogInit::~JOBDialogInit(){
}


string JOBDialogInit::toString(int firstseg){
  string result;
  string userid;
  string systemid;
  _startSegment = firstseg;
  Pointer<Medium> medium;
  string userId999;

  if (Hbci::debugLevel()>5)
    fprintf(stderr,"JOBDialogInit::toString()\n");
  medium=_customer.ref().user().ref().medium();

  // SEGIdentification
  userid=(_anonymous)?"9999999999":"";
  // in case of syncing, systemId has to be "0"!
  SEGIdentification ident(_customer, _sync);
  ident.setData(_anonymous,userid);
  result += ident.toString(firstseg++);

  // set necessary data the institute wants to know
  SEGPreProcessing procPrep(_customer);
  result+=procPrep.toString(firstseg++);
  if (_getkeys) {
    // request public institute crypt key
    SEGGetInstKey gikcrypt(_customer);
    userId999=(_bank.ref().hbciVersion()== HBCI_VERSION_201)?"9999999999":"999";
    gikcrypt.setData(false,999,999,userId999);
    result+=gikcrypt.toString(firstseg++);
    // request public institute sign key
    SEGGetInstKey giksign(_customer);
    userId999=(_bank.ref().hbciVersion()== HBCI_VERSION_201)?"9999999999":"999";
    giksign.setData(true,999,999,userId999);
    result+=giksign.toString(firstseg++);
  }
  _lastSegment = --firstseg;
  return result;
}


bool JOBDialogInit::needsToBeSigned() const {
  return _sign;
}


bool JOBDialogInit::needsToBeEncrypted() const {
  return _crypt;
}


void JOBDialogInit::parseResponse(const string& segment){
    string segname;
    Pointer<Medium> medium;

    if (Hbci::debugLevel()>5)
	fprintf(stderr,"JOBDialogInit::parseResponse()\n");
    medium=_customer.ref().user().ref().medium();
    unsigned int pos = 0;

    segname=String::nextDEG(segment,0);
    if ((medium.ref().securityMode()==HBCI_SECURITY_RDH) &&
        (segname=="HIISA")) {
        Pointer<RSAKey> key;

        SEGPublicKeyReturn kr(_customer);
        if (!kr.parse(segment,0))
            throw Error("JOBDialogInit::parseResponse()",
                            ERROR_LEVEL_NORMAL,
                            0,
                            ERROR_ADVISE_ABORT,
                            "error parsing HIISA",
                            String::dumpToString(segment));
        key=kr.getKey();
	// set the new key for this medium
        if (key.ref().isCryptoKey()) {
            _cryptKey=key;
	} else {
            _signKey=key;
	}
    } // if RDH
    else if (segname=="HIUPA") {
        if (!_upd.isValid()) {
            _upd=new userParams();
            _upd.setObjectDescription("userParams");
        }
        // skip head
        pos+=String::nextDE(segment, pos).length() + 1;
        // skip user id
        pos+=String::nextDE(segment, pos).length() + 1;
        // read upd version
        _upd.ref().setVersion(atoi(String::nextDE(segment, pos).c_str()));
		pos+=String::nextDE(segment, pos).length() + 1;
		// can we rely on the updJobs? (some banks send it, some don't)
		_upd.ref().setKnowsSupportedJobs("0" == String::nextDE(segment, pos));
    }
    else if (segname=="HIUPD") {
        if (!_upd.isValid()) {
            _upd=new userParams();
            _upd.setObjectDescription("userParams");
        }
        // account parameters follow
        SEGUserParameter upd(_customer);
        accountParams acc;

        upd.parse(segment,0);
        _upd.ref().addAccount(upd.getData());
    }
    else if (segname == "HIBPA") {
        if (!_bpd.isValid()) {
            _bpd=new bankParams();
            _bpd.setObjectDescription("bankParams");
        }

        // main institute-data
        SEGInstituteParameter instData(0);
        if (!instData.parse(segment,0))
            throw Error("JOBDialogInit::parseResponse()",
                            ERROR_LEVEL_NORMAL,
                            0,
                            ERROR_ADVISE_ABORT,
                            "error in segment HIBPA",
                            String::dumpToString(segment));
        _bpd.ref()._bpd=instData.getData();
    } // HIBPA

    else if (segname=="HIKOM") {
        if (!_bpd.isValid()) {
            _bpd=new bankParams();
            _bpd.setObjectDescription("bankParams");
        }
        // communication-parameter for each allowed communication-mode
        SEGComParameter comModes(0);
        if (! comModes.parse(segment,0))
            throw Error("JOBDialogInit::parseResponse()",
                            ERROR_LEVEL_NORMAL,
                            0,
                            ERROR_ADVISE_DONTKNOW,
                            "error in segment HIKOM",
                            String::dumpToString(segment));
        _bpd.ref()._bpdcom=comModes.getData();
    } // "HIKOM"

    else if (segname=="HISHV") {
        // TODO
    } // HISHV"

    else if (segname=="HIKPV") {
        // TODO
    } // HIPKV

    else {
        if (!_bpd.isValid()) {
            _bpd=new bankParams();
            _bpd.setObjectDescription("bankParams");
        }
        // should be supported job
        SEGSupportedJob newJob(0);
        if (!newJob.parse(segment,0))
            throw Error("JOBDialogInit::parseResponse()",
                            ERROR_LEVEL_NORMAL,
                            0,
                            ERROR_ADVISE_DONTKNOW,
                            "error in job segment",
                            String::dumpToString(segment));
        _bpd.ref()._supportedJobs.push_back(newJob.getData());
    }
}


void JOBDialogInit::jobSuccess(const string& response) {
    if (Hbci::debugLevel()>5)
	fprintf(stderr,"JOBDialogInit::jobSuccess()\n");

    segResponse respStruct(response);
    if (respStruct.code>=9000)
        // was it a response to GetSignKey?
        if (respStruct.replyTo==5 && _anonymous){
            // yes, so fake the result code (make it a warning)
            respStruct.code=8999;
            fprintf(stderr,"JOBDialogInit: faked result code.\n");
        }

    _responses.push_back(respStruct);
    _bank.ref().hbci()->interactor().ref().msgStateResponse(respStruct.toString());
}


/*AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 JOBSynchronize
 AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 */


JOBSynchronize::JOBSynchronize(Pointer<Customer> cust,
                               int syncmode):Job(cust){
    if (Hbci::debugLevel()>5)
	fprintf(stderr,"JOBSynchronize::JOBSynchronize()\n");
    _syncmode=syncmode;
}


JOBSynchronize::~JOBSynchronize(){
    if (Hbci::debugLevel()>5)
	fprintf(stderr,"JOBSynchronize::~JOBSynchronize()\n");
}


string JOBSynchronize::toString(int firstseg){
    string result;
    SEGSynchronize sync(_customer);

    if (Hbci::debugLevel()>5)
	fprintf(stderr,"JOBSynchronize::toString()\n");

    _startSegment = firstseg;
    sync.setData(_syncmode);
    result=sync.toString(firstseg);
    _lastSegment = firstseg;
    return result;
}


void JOBSynchronize::parseResponse(const string& response){
    string t1,t2,t3;
    unsigned int pos=0;

    if (Hbci::debugLevel()>5)
	fprintf(stderr,"JOBSynchronize::parseResponse()\n");

    // get and check medium
    if (_customer.ref().user().ref().medium().ref().securityMode()!=
        HBCI_SECURITY_RDH)
        return;

    // now check answer
    if (String::nextDEG(response,0) == "HISYN") {
        // skip segment head
        pos+=String::nextDE(response,0).length()+1;
        if (pos<response.length())
            t1=String::nextDEG(response,pos);
        pos+=String::nextDEG(response,pos).length()+1;
        if (pos<response.length())
            t2=String::nextDEG(response,pos);
        pos+=String::nextDEG(response,pos).length()+1;
        if (pos<response.length())
            t3=String::nextDEG(response,pos);

        // store
        if (_syncmode==HBCI_SYNC_SYSTEMID)
            _sysid=t1;
        else if (_syncmode==HBCI_SYNC_MSGNUMBER)
            _msgNumber=atoi(t1.c_str());
        else if (_syncmode==HBCI_SYNC_SIGNATUREID)
            _signatureId=atoi(t1.c_str());
    } // if HISYN
}


/*AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 JOBFirstInit
 AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 */


JOBFirstInit::JOBFirstInit(Pointer<Customer> cust)
 :Job(cust)
{
    if (Hbci::debugLevel()>5)
	fprintf(stderr,"JOBFirstInit::JOBFirstInit()\n");
}


JOBFirstInit::~JOBFirstInit(){
    if (Hbci::debugLevel()>5)
	fprintf(stderr,"JOBFirstInit::~JOBFirstInit()\n");
}


string JOBFirstInit::toString(int firstseg){
    string result;
    Pointer<Medium> medium;
    Pointer<MediumRDHBase> mediumrdh;

    if (Hbci::debugLevel()>5)
	fprintf(stderr,"JOBFirstInit::toString()\n");

    _startSegment = firstseg;
    medium=_customer.ref().user().ref().medium();
    if (medium.ref().securityMode()!=HBCI_SECURITY_RDH)
        throw Error("JOBFirstInit::toString()",
                    "Not in RDH mode.",0);
    mediumrdh=medium.cast<MediumRDHBase>();

    // identify yourself
    SEGIdentification ident(_customer);
    ident.setData(false,"");
    result += ident.toString(firstseg++);

    // set sign-key
    SEGPublicKeyChange keyChange(_customer);
    keyChange.setKey(mediumrdh.ref().userPubSignKey());
    result+=keyChange.toString(firstseg++);

    // set crypt-key
    keyChange.setKey(mediumrdh.ref().userPubCryptKey());
    result+=keyChange.toString(firstseg++);

    _lastSegment = --firstseg;
    return result;
}


void JOBFirstInit::parseResponse(const string& response){
    if (Hbci::debugLevel()>5)
	fprintf(stderr,"JOBFirstInit::parseResponse()\n");

}


/*AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 JOBDialogEnd
 AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
 */

JOBDialogEnd::JOBDialogEnd(Pointer<Customer> cust,
                           const string& dialogid,
                           bool crypt,
                           bool sign):Job(cust){
    if (Hbci::debugLevel()>5)
	fprintf(stderr,"JOBDialogEnd::JOBDialogEnd()\n");

    _sign=sign;
    _crypt=crypt;
    _dialogid=dialogid;
}


JOBDialogEnd::~JOBDialogEnd(){
    if (Hbci::debugLevel()>5)
	fprintf(stderr,"JOBDialogEnd::~JOBDialogEnd()\n");

}


string JOBDialogEnd::toString(int firstseg){
    string result;

    if (Hbci::debugLevel()>5)
	fprintf(stderr,"JOBDialogEnd::toString()\n");

    _startSegment = firstseg;

    SEGDialogEnd dlgend(_customer);
    dlgend.setData(_dialogid);
    result=dlgend.toString(firstseg);
    _lastSegment=firstseg;
    return result;
}


void JOBDialogEnd::parseResponse(const string& response){
    if (Hbci::debugLevel()>5)
	fprintf(stderr,"JOBDialogEnd::parseResponse()\n");

}




JOBPublicKeysDisable::JOBPublicKeysDisable(Pointer<Customer> cust,
										   int keyNumber, 
										   int keyVersion):Job(cust){
  _keyNumber = keyNumber;
  _keyVersion = keyVersion;
}


JOBPublicKeysDisable::~JOBPublicKeysDisable(){
}

bool JOBPublicKeysDisable::needsToBeSigned() const { 
  return (0 == _keyVersion + _keyNumber);
}

string JOBPublicKeysDisable::toString(int firstseg){
  string result;
  Pointer<Medium> medium;
  Pointer<RSAKey> key;

  _startSegment = firstseg;
  medium=_customer.ref().user().ref().medium();
  if (medium.ref().securityMode()!=HBCI_SECURITY_RDH)
    throw Error("JOBPublicKeysDisable::toString",
		"not in RDH mode",0);

  SEGPublicKeyDisable ck(_customer);
  // was the number/version set manually or do we have
  // the key that shall be locked?
  if (0 < _keyVersion + _keyNumber) {
    ck.setData(_keyNumber, _keyVersion);
  } else {
    key=medium.cast<MediumRDHBase>().ref().userPubSignKey();
    ck.setData(key);
  }

  result=ck.toString(firstseg);
  _lastSegment=firstseg;
  return result;
}


JOBPublicKeysChange::JOBPublicKeysChange(Pointer<Customer> cust):Job(cust) {
}


JOBPublicKeysChange::~JOBPublicKeysChange(){
}

string JOBPublicKeysChange::toString(int firstseg){
    string result;
    Pointer<MediumRDHBase> mediumRDH;
    Pointer<RSAKey> key;

    _startSegment = firstseg;

	if (! (HBCI_SECURITY_RDH == _customer.ref().user().ref().medium().ref().securityMode()))
	  throw Error("JOBPublicKeysChange::toString",
				  "not in RDH mode", 0);

	SEGPublicKeyChange ckS(_customer);
	SEGPublicKeyChange ckC(_customer);
	mediumRDH = _customer.ref().user().ref().medium().cast<MediumRDHBase>();

	// change the signature key
	key = mediumRDH.ref().getTempSignKey();
    if (! key.isValid())
        throw Error("JOBPublicKeysChange::toString",
                        "no signature key given",0);
	ckS.setKey(key);

	// change the encryption key
	key = mediumRDH.ref().getTempCryptKey();
    if (! key.isValid())
        throw Error("JOBPublicKeysChange::toString",
                        "no encryption key given",0);
	ckC.setKey(key);

    result = ckS.toString(firstseg) + ckC.toString(firstseg + 1);
    _lastSegment=firstseg + 1;
    return result;
}




JOBGetStatusReport::JOBGetStatusReport(Pointer<Customer> cust,
				       const Date& fromDate,
				       const Date& toDate,
				       int maxentries)
:Job(cust)
,_fromdate(fromDate)
,_todate(toDate)
,_maxEntries(maxentries)
{
}


JOBGetStatusReport::JOBGetStatusReport(Pointer<Customer> cust,
				       const Date& fromDate,
				       const Date& toDate,
				       int maxentries,
				       Pointer<Job> lastJob)
:Job(cust)
,_fromdate(fromDate)
,_todate(toDate)
,_maxEntries(maxentries)
{
  _attachPoint = dynamic_cast<JOBGetStatusReport&>(lastJob.ref()).
    _attachPoint;
}


JOBGetStatusReport::~JOBGetStatusReport(){
}


string JOBGetStatusReport::toString(int firstseg){
  string result;

  _startSegment = firstseg;
  SEGGetStatusReport gt(_customer);
  gt.setData(_fromdate,_todate,_maxEntries, _attachPoint);
  // clear attachpoint
  _attachPoint = "";
  result=gt.toString(firstseg);
  _lastSegment = firstseg;
  return result;
}


void JOBGetStatusReport::parseResponse(const string& response){
  unsigned int pos;

  pos=0;
  SEGStatusReport b(_customer);
  if (!b.parse(response,0))
    throw Error("JOBGetStatusReport::parseResponse",
		"Error parsing.",0);
  _reports.push_back(b.statusReport());
}


bool JOBGetStatusReport::attachMore() {
  list<segResponse> responses = getSegmentResponse();
  list<segResponse>::const_iterator it;

  for (it = responses.begin(); it != responses.end(); it++) {
    if (3040 == (*it).code && (*it).param != "") {
      _attachPoint = (*it).param;
    }
  }

  return ("" != _attachPoint);
}



} // namespace HBCI


