/* 
 * $Id: ctkrange.c,v 1.4 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "ctk.h"

/* Initialize the Range */
void
    ctk_range_init(CtkRange *range)
{
	range->adjustment = NULL;
	range->digits = 0;
	
	ctk_widget_init(&range->widget);
}

void
    ctk_range_set_adjustment(CtkRange *range, CtkAdjustment *adjustment)
{
	if (!range)
	    return;
	
	if (range->adjustment)
	    g_free(range->adjustment);
	
	range->adjustment = adjustment;
}

/* Destroy Range Data */
gpointer
    ctk_range_destroy(CtkRange *range)
{
	if (range->adjustment)
	    g_free(range->adjustment);
	
	return NULL;
}
