/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.collection;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.BoundedCollection;
import org.apache.commons.collections.collection.AbstractCollectionDecorator;
import org.apache.commons.collections.collection.AbstractSerializableCollectionDecorator;
import org.apache.commons.collections.collection.SynchronizedCollection;
import org.apache.commons.collections.iterators.UnmodifiableIterator;

public final class UnmodifiableBoundedCollection
extends AbstractSerializableCollectionDecorator
implements BoundedCollection {
    private static final long serialVersionUID = -7112672385450340330L;

    public static final BoundedCollection decorate(BoundedCollection coll) {
        return new UnmodifiableBoundedCollection(coll);
    }

    public static final BoundedCollection decorateUsing(Collection coll) {
        if (coll == null) {
            throw new IllegalArgumentException("The collection must not be null");
        }
        int i = 0;
        while (i < 1000) {
            if (coll instanceof BoundedCollection) break;
            if (coll instanceof AbstractCollectionDecorator) {
                coll = ((AbstractCollectionDecorator)coll).collection;
            } else {
                if (!(coll instanceof SynchronizedCollection)) break;
                coll = ((SynchronizedCollection)coll).collection;
            }
            ++i;
        }
        if (!(coll instanceof BoundedCollection)) {
            throw new IllegalArgumentException("The collection is not a bounded collection");
        }
        return new UnmodifiableBoundedCollection((BoundedCollection)coll);
    }

    public final Iterator iterator() {
        return UnmodifiableIterator.decorate(this.getCollection().iterator());
    }

    public final boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    public final boolean addAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public final boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    public final boolean removeAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    public final boolean retainAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    public final boolean isFull() {
        return ((BoundedCollection)this.collection).isFull();
    }

    public final int maxSize() {
        return ((BoundedCollection)this.collection).maxSize();
    }

    private UnmodifiableBoundedCollection(BoundedCollection coll) {
        super(coll);
    }
}

