/***************************************************************************
 $RCSfile: ctmisc.cpp,v $
                             -------------------
    cvs         : $Id: ctmisc.cpp,v 1.7 2003/04/24 01:43:28 aquamaniac Exp $
    begin       : Fri May 31 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 Changes

 */


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef __declspec
# if BUILDING_CHIPCARD_DLL
#  define CHIPCARD_API __declspec (dllexport)
# else /* Not BUILDING_CHIPCARD_DLL */
#  define CHIPCARD_API __declspec (dllimport)
# endif /* Not BUILDING_CHIPCARD_DLL */
#else
# define CHIPCARD_API
#endif

#include <stdio.h>
#include <string>
#include <cctype>
#include "ctmisc.h"



string CTMisc::num2string(int n, const string &format) {
    char buffer[32];

    sprintf(buffer,format.c_str(),n);
    return buffer;
}


int CTMisc::string2num(const string &n, const string &format) {
    int result;

    if (n.empty())
        return 0;

    if (sscanf(n.c_str(),format.c_str(),&result)!=1)
      result=0;
    return result;
}


bool CTMisc::compare(const string &s1, const string &s2){
    unsigned int i;

    if (s1.length()!=s2.length())
        return false;

    for (i=0; i<s1.length(); i++)
        if (toupper(s1[i])!=toupper(s2[i]))
            return false;
    return true;
}


unsigned int CTMisc::bsd2int(unsigned char c) {
    int i;

    i=(c>>4)*10;
    i+=(c & 0xf);
    return i;
}


string CTMisc::bsd2string(unsigned char c) {
    int i;
    string d;

    i=(c>>4)+'0';
    d+=(char)i;
    i=(c & 0xf)+'0';
    d+=(char)i;
    return d;
}


string CTMisc::bsd2string(const string &s){
    string result;
    unsigned int i;

    for (i=0; i<s.length(); i++) {
        result+=(((unsigned char)s[i])>>4)+'0';
        result+=(((unsigned char)s[i])& 0xf)+'0';
    } // for

    return result;
}


string CTMisc::string2bsd(const string &s){
  string result;
  unsigned int i;
  unsigned char c;

  for (i=0; i<s.length(); i+=2) {
    c=((s[i]-'0')<<4);
    if ((i+1)<s.length())
      c|=(s[i+1]-'0');
    result+=c;
  } // for

  // done.
  return result;
}



void CTMisc::removeBlanks(string &s) {
  unsigned int i;

  if (!s.empty()) {
    for (i=0; i<s.length()-1; i++)
      if (s.at(i)>32)
	break;
    if (i>0)
      s=s.substr(i);
  }

  if (!s.empty()) {
    for (i=s.length()-1; i>0; i--) {
      if (s.at(i)>32) {
	if (i<s.length()-1)
	  s.erase(i+1);
	return;
      }
    } // for
    s.erase();
  }
};


string CTMisc::bin2hex(const string &s, int groups){
  string d;
  unsigned int i;
  unsigned char c;

  for (i=0; i<s.length(); i++) {
    c=(s[i]>>4)&0xf;
    if (c>9)
      c+=7;
    c+='0';
    d+=(char)c;
    c=(s[i]&0xf);
    if (c>9)
      c+=7;
    c+='0';
    d+=(char)c;
    if (groups && (i%groups)==0)
      d+=' ';
  } // for
  return d;
}


string CTMisc::hex2bin(const string &s){
  unsigned int i;
  unsigned char c;
  char n;
  int j;
  string result;

  i=0;

  while(i<s.length()) {
    // skip blanks
    while(i<s.length()) {
      if (!isspace(s[i]))
	break;
      i++;
    } // while

    c=0;
    j=0;
    while(i<s.length()) {
      if (!isspace(s[i])) {
	n=toupper(s[i]);
	if (!((n>='0' && n<='9') ||
	      (n>='A' && n<='F')))
	  return "";
	n-='0';
	if (n>9)
	  n-=7;
	c=c<<4;
	c|=(n&0xf);
      }
      if ((j==1) || isspace(s[i])) {
	result+=(char)c;
        i++;
        break;
      }
      else
	j++;
      i++;
    } // while
  } // while
  return result;
}







