# $Id: rsacard.cmd,v 1.13 2003/05/08 11:01:22 aquamaniac Exp $
# This file contains command descriptions for G&D RSA cards


#
# SelectFile(fileId)
#
[all/RSAcard/select_file_w]
arguments=1
apdu="apdu1"

[all/RSAcard/select_file_w/apdu1]
cla="0"
ins="0xa4"
p1=0
p2="0x0c"
data="$data"
lr=0

[all/RSAcard/select_file_w/data]
argument=0
type="uword"


#
# SelectID()
#

[all/RSACard/select_file_id]
arguments=1
apdu="apdu1"

[all/RSACard/select_file_id/apdu1]
cla="0"
ins="0xa4"
p1="0x4"
p2=0xc
#p2=0
data="$data"
lr=0

[all/RSACard/select_file_id/data]
argument=0
type="bin"
min=1
max=64


#
# SelectID() for Cyberjack
#

[cyberjack/RSACard/select_file_id]
arguments=1
apdu="apdu1"

[cyberjack/RSACard/select_file_id/apdu1]
cla="0"
ins="0xa4"
p1="0x4"
p2=0xc
#p2=0
data="$data"
lr=0

[cyberjack/RSACard/select_file_id/data]
argument=0
type="bin"
min=1
max=64



#
# SelectID() for Kobil
#
[kobil/RSACard/select_file_id]
arguments=1
apdu="apdu1"

[kobil/RSACard/select_file_id/apdu1]
cla="0"
ins="0xa4"
p1="0x4"
p2=0xc
#p2=0
data="$data"
lr=0

[kobil/RSACard/select_file_id/data]
argument=0
type="bin"
min=1
max=64






[all/RSACard/select_hbapp]
arguments=0
apdu="apdu1"

[all/RSACard/select_hbapp/apdu1]
cla="0"
ins="0xa4"
p1="0x4"
p2="0xc"
data="d2 76 00 00 74 48 42 01 10"
lr="255"




#
# Read_File()
#
[all/RSAcard/read_file]
arguments=0
apdu="apdu1"

[all/RSAcard/read_file/apdu1]
cla="0"
ins="0xb0"
p12="0"
lr="256"


#
# Verify_Pin(kid, pin)
#
[all/RSAcard/verify_pin]
arguments=2
apdu="apdu1"

[all/RSAcard/verify_pin/apdu1]
cla="0"
ins="0x20"
p1="0x00"
p2="$kid"
data="$data"
lr=0

[all/RSAcard/verify_pin/kid]
argument=0
type="uchar"

[all/RSAcard/verify_pin/data]
argument=1
type="bin"
min=1
max=8
fillwith="0x20"



#
# Secure_Verify_Pin(kid)
#
[all/RSAcard/secure_verify_pin]
arguments=1
apdu="apdu1"

[all/RSAcard/secure_verify_pin/apdu1]
cla="0x20"
ins="0x18"
p1="0x01"
p2="0x00"
data="52 0f 01 06 00 20 00","$kid","08 2020202020202020"
lr=0

[all/RSAcard/secure_verify_pin/kid]
argument=0
type="uchar"



#
# Change_Pin(KID, oldKey, newKey)
#
[all/RSAcard/change_pin]
arguments=3
apdu="apdu1"

[all/RSAcard/change_pin/apdu1]
cla="0"
ins="0x24"
p1="0x00"
p2="$kid"
data="$oldkey","$newkey"
lr=0

[all/RSAcard/change_pin/kid]
argument=0
type="uchar"

[all/RSAcard/change_pin/oldkey]
argument=1
type="bin"
min=1
max=8
fillwith="0x20"

[all/RSAcard/change_pin/newkey]
argument=2
type="bin"
min=4
max=8
fillwith="0x20"



#
# Secure_Change_Pin(KID)
#
[all/RSAcard/secure_change_pin]
arguments=1
apdu="apdu1"

[all/RSAcard/secure_change_pin/apdu1]
cla="0x20"
ins="0x19"
p1="0x01"
p2="0x00"
data="52 18 01 06 0e 00 24 00","$kid","102020202020202020","2020202020202020"
lr=0

[all/RSAcard/secure_change_pin/kid]
argument=0
type="uchar"



#
# Generate_KeyPair(KID, keylength_in_bits, keylength_in_bytes)
#
[all/RSAcard/generate_keypair]
arguments=3
apdu="apdu1"

[all/RSAcard/generate_keypair/apdu1]
cla="0x00"
ins="0x46"
p1="0x00"
p2="$kid"
data="$keylenbits"
lr="$keylenbytes"

[all/RSAcard/generate_keypair/kid]
argument=0
type="uchar"

[all/RSAcard/generate_keypair/keylenbits]
argument=1
type="uword"


[all/RSAcard/generate_keypair/keylenbytes]
argument=2
type="uchar"



#
# Manage_Security_Environment(template, secret_KID, public_KID, AR)
#
[all/RSAcard/manage_se]
arguments=4
apdu="apdu1"

[all/RSAcard/manage_se/apdu1]
cla="0x00"
ins="0x22"
p1="0x41"
p2="$tmpl"
data="84 01","$kids","83 01","$kidp","80 01","$ar"
lr=0

[all/RSAcard/manage_se/tmpl]
argument=0
type="uchar"

[all/RSAcard/manage_se/kids]
argument=1
type="uchar"

[all/RSAcard/manage_se/kidp]
argument=2
type="uchar"

[all/RSAcard/manage_se/ar]
argument=3
type="uchar"



[all/RSAcard/select_pubkey]
arguments=3
apdu="apdu1"

[all/RSAcard/select_pubkey/apdu1]
cla="0x00"
ins="0x22"
p1="0x41"
p2="$tmpl"
data="83 01","$kidp","80 01","$ar"
lr=0

[all/RSAcard/select_pubkey/tmpl]
argument=0
type="uchar"

[all/RSAcard/select_pubkey/kidp]
argument=1
type="uchar"

[all/RSAcard/select_pubkey/ar]
argument=2
type="uchar"


[all/RSAcard/select_privkey]
arguments=3
apdu="apdu1"

[all/RSAcard/select_privkey/apdu1]
cla="0x00"
ins="0x22"
p1="0x41"
p2="$tmpl"
data="84 01","$kids","80 01","$ar"
lr=0

[all/RSAcard/select_privkey/tmpl]
argument=0
type="uchar"

[all/RSAcard/select_privkey/kids]
argument=1
type="uchar"

[all/RSAcard/select_privkey/ar]
argument=2
type="uchar"



[all/RSAcard/put_hash]
arguments=1
apdu="apdu1"

[all/RSAcard/put_hash/apdu1]
cla="0"
ins="0x2a"
p1="0x90"
p2="0x81"
data="$data"
lr="0"

[all/RSAcard/put_hash/data]
argument=0
type="bin"
min=20
max=20


[all/RSAcard/sign]
arguments=0
apdu="apdu1"

[all/RSAcard/sign/apdu1]
cla="0"
ins="0x2a"
p1="0x9e"
p2="0x9a"
lr="256"


[all/RSAcard/verify]
arguments=1
apdu="apdu1"

[all/RSAcard/verify/apdu1]
cla="0"
ins="0x2a"
p1="0x00"
p2="0xa8"
data="$data"
lr="0"

[all/RSAcard/verify/data]
argument=0
type="bin"



[all/RSAcard/challenge]
arguments=1
apdu="apdu1"

[all/RSAcard/challenge/apdu1]
cla="0"
ins="0x84"
p1="0x00"
p2="0x00"
lr="$len"

[all/RSAcard/challenge/len]
argument=0
type="uchar"
min=1
max=8



[all/RSAcard/encipher]
arguments=1
apdu="apdu1"

[all/RSAcard/encipher/apdu1]
cla="0x00"
ins="0x2a"
p1="0x86"
p2="0x80"
data="$data"
lr="256"

[all/RSAcard/encipher/data]
argument=0
type="bin"
min=16
max=16


[all/RSAcard/decipher]
arguments=1
apdu="apdu1"

[all/RSAcard/decipher/apdu1]
cla="0x00"
ins="0x2a"
p1="0x80"
p2="0x86"
data="00","$data"
lr="256"

[all/RSAcard/decipher/data]
argument=0
type="bin"
min=96
max=96


[all/RSAcard/activate_key]
arguments=3
apdu="apdu1"


[all/RSAcard/activate_key/apdu1]
cla="0xf0"
ins="0x47"
p1="$src"
p2="$dest"
data="$data"
lr="0"

[all/RSAcard/activate_key/src]
argument=0
type="uchar"
min="0x8e"
max="0x8f"

[all/RSAcard/activate_key/dest]
argument=1
type="uchar"
min="0x81"
max="0x8a"


[all/RSAcard/activate_key/data]
argument=2
type="bin"
min=8
max=8



#
# get pin status for Kobil
#
[kobil/RSACard/pin_status]
arguments=0
apdu="apdu1"

[kobil/RSACard/pin_status/apdu1]
cla="0x80"
ins="0xf2"
p1="0x00"
p2="0x90"
# yes, empty data !
data="" 
lr=0


#
# get pin status for Cyberjack
#
[cyberjack/RSACard/pin_status]
arguments=0
apdu="apdu1"

[cyberjack/RSACard/pin_status/apdu1]
cla="0x80"
ins="0xf2"
p1="0x00"
p2="0x90"
# yes, empty data !
data="" 
lr="0"


#
# get pin status for Towitoko
#
[towitoko/RSACard/pin_status]
arguments=0
apdu="apdu1"

[towitoko/RSACard/pin_status/apdu1]
cla="0x80"
ins="0xf2"
p1="0x00"
p2="0x90"
# yes, empty data !
data="" 
lr="0x0"





