//LabPlot : PruneListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <qstring.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qcolordialog.h>
#include <klocale.h>
#include "PruneListDialog.h"

PruneListDialog::PruneListDialog(Worksheet *p, Spreadsheet *s, const char *name)
	: ListDialog(p, s, name)
{
	setCaption(i18n("Prune Dialog"));

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	new QLabel(i18n(" Prune every n points : "),tab1);
	QHBox *hb = new QHBox(tab1);
	new QLabel(QString(" n = "),hb);
	nle = new KLineEdit(QString("3"),hb);
	nle->setValidator(new QIntValidator(nle));

	Style style;
	Symbol symbol;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw);
	else
		styletab = simpleStyle(tw,0, &style, &symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void PruneListDialog::apply_clicked() {
	// TODO : more selected graphs ???
	int n = (nle->text()).toInt();

	if(s) {
		QTable *table = s->Table();
		int col = table->currentColumn();
		
		// add column if needed
		bool empty=TRUE;
		for(int i=0;i<table->numRows();i++) {
			if(table->text(i,table->numCols()-1).length()>0) {
				empty =FALSE;
			}
		}
		if (!empty)
			s->addColumn();

		int newcol = table->numCols()-1;
		for (int i = 0;i<table->numRows()/n;i++) {
			double sum = 0;
			for (int j=0;j<n;j++) {
				sum+=table->text(i+j,col).toDouble();
			}
			sum = sum/n;
			
			// insert into last column
			int index = (int) (n*i+n/2);
			table->setText(index,newcol,table->text(index,col));
		}
		return;
	}

	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->getNumber()==0)
		return;
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());

	GRAPHType st = gl->getStruct(item);

	if (st == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point *a = g->Data();

		// do the average
		double xmin=0, xmax=1, ymin=0, ymax=1;
		for (int i = 0;i<nx/n;i++) {
			int index = (int) (n*i+n/2);
			double x = a[index].X();
			double y = a[index].Y();
			
			// new ranges
			if (i==0) {
				xmin=xmax=x;
				ymin=ymax=y;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}

			ptr[i].setPoint(x,y);
		}

		// create the new Graph
		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		
		QString fun = QString(i18n("prune (")+QString::number(n)+i18n(") of ")+g->Label());
		
		Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			widthle->text().toInt(),pencb->currentItem(),brushcb->currentItem());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
		
		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,g->Number()/n);
		p->addGraph2D(ng);	
	}
	else if (st == GRAPH3D) {
		// TODO
	}
	else if (st == GRAPHM) {
		// TODO
	}

	updateList();
}
