//LabPlot : PlotGL.cc

#include <kmessagebox.h>
#include "PlotGL.h"

PlotGL::PlotGL(Worksheet *p)
	: Plot(p), QGLWidget(p)
{
	if ( !QGLFormat::hasOpenGL() )
		KMessageBox::warningContinueCancel(this,i18n("Sorry. Your system has no OpenGL support!"));

	setFormat(QGLFormat(DoubleBuffer | DepthBuffer));
	rotationX = 22.5;
	rotationY = -22.5;
	rotationZ = 0;
	faceColors[0] = red;
	faceColors[1] = green;
	faceColors[2] = blue;
	
	resize(p->size());
}

//! initialize GL
void PlotGL::initGL() {
#ifdef HAVE_GL
	qglClearColor(white);
	glShadeModel(GL_FLAT);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_CULL_FACE);
#endif
}

//! resize GL
void PlotGL::resizeGL(int w, int h) {
#ifdef HAVE_GL
	glViewport(0,0,w,h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	GLfloat x = (GLfloat) w/h;
	glFrustum(-x,x,-1.0,1.0,4.0,15.0);
	glMatrixMode(GL_MODELVIEW);
#endif
}

//! paint GL
void PlotGL::paintGL() {
#ifdef HAVE_GL
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	drawGL();
#endif
}

void PlotGL::drawGL() {
#ifdef HAVE_GL
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	static const GLfloat coords[3][8][3] = {
	{ { -1.0, -1.0, -1.0 }, { +1.0, -1.0, -1.0 },{ -1.0, +1.0, -1.0 }, { +1.0, +1.0, -1.0 },
		{-1.0,+1.0,+1.0},{+1.0,+1.0,+1.0},{-1.0,-1.0,+1.0},{+1.0,-1.0,+1.0} },
	{ { -1.0, -1.0, -1.0 }, { -1.0, +1.0, -1.0 },{ +1.0, -1.0, -1.0 }, { +1.0, +1.0, -1.0 },
		{ +1.0, -1.0, +1.0 }, { +1.0, +1.0, +1.0 },{ -1.0, -1.0, +1.0 }, { -1.0, +1.0, +1.0 } },
	{ { -1.0, -1.0, -1.0 }, { -1.0, -1.0, +1.0 },{ -1.0, +1.0, +1.0 }, { -1.0, +1.0, -1.0 },
		{ +1.0, +1.0, -1.0 }, { +1.0, +1.0, +1.0 },{ +1.0, -1.0, -1.0 }, { +1.0, -1.0, +1.0 } }
	};

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glTranslatef(0.0, 0.0, -7.0);
	glRotatef(rotationX, 1.0, 0.0, 0.0);
	glRotatef(rotationY, 0.0, 1.0, 0.0);
	glRotatef(rotationZ, 0.0, 0.0, 1.0);

	for (int i = 0; i < 3; ++i) {
		glLoadName(i);
		glBegin(GL_LINES);
		qglColor(faceColors[i]);
		for (int j = 0; j < 4; ++j) {
			glVertex3f(coords[i][2*j][0], coords[i][2*j][1],coords[i][2*j][2]);
			glVertex3f(coords[i][2*j+1][0], coords[i][2*j+1][1],coords[i][2*j+1][2]);
		}
		glEnd();
	}
	 
	 //draw x ticks
	int nr_xtics=10;
	for (int i=0;i<nr_xtics;i++) {
		double x = 2*i/(double)(nr_xtics-1)-1.0;
		glBegin(GL_LINES);
		qglColor(black);
		glVertex3f(x, -1.0, 1.0 );		// start x,y,z
		glVertex3f(x, -1.1, 1.0 );		// end x,y,z
		glEnd();
		
		// TODO : tic label
		//qglColor(black);
		GLboolean lighting;
		glGetBooleanv( GL_LIGHTING, &lighting );
		if ( lighting )
			glDisable( GL_LIGHTING );
		qglColor( blue );

		// doesnt work !
//		QFont f = QApplication::font();
//		f.setStyleStrategy(QFont::PreferBitmap);

//		renderText(x,-1.2,1.0,QString("Test"),f);
//		renderText(10,10,QString("Test"),f);
	}
	// TODO : axes label

	// TODO : x2,x3,x4 axes
	
	// TODO: y,z axis
#endif
}

void PlotGL::draw(QPainter *p, int w, int h) {
	initGL();	// needed for white background :-(
	resize(w,h);
}

void  PlotGL::mousePressEvent(QMouseEvent *e) {
	lastPos = e->pos();
}

void  PlotGL::mouseMoveEvent(QMouseEvent *e) {
#ifdef HAVE_GL
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	GLfloat dx = (GLfloat)(e->x() - lastPos.x()) / width();
	GLfloat dy = (GLfloat)(e->y() - lastPos.y()) / height();

	// TODO : zoom
	if (e->state() & LeftButton) {
		rotationX += 180 * dy;
		rotationY += 180 * dx;
		updateGL();
	} 
	else if (e->state() & RightButton) {
		rotationX += 180 * dy;
		rotationZ += 180 * dx;
		updateGL();
	}
	lastPos = e->pos();
#endif
}
