//LabPlot : Line.cc

#include <math.h>
#include <iostream>
#include <kdebug.h>
#include "Line.h"

using namespace std;

Line::Line(Point s,Point e,QColor c,int w, Arrow sa, Arrow ea) 
	: start(s), end(e), color(c),width(w), sarrow(sa),earrow(ea)
{
	sarrow.setLocation(0);
	earrow.setLocation(1);
}

QStringList Line::Info() {
	QStringList s;

        s << QString::number(start.X())+"/"+QString::number(start.Y());
        s << QString::number(end.X())+"/"+QString::number(end.Y());
	s << QString::number(width);
        s << color.name();
	s += sarrow.Info();
	s += earrow.Info();
	
	return s;
}

// draw the line on the worksheet
void Line::draw(QPainter *p, double X, double Y) {
	//kdDebug()<<"DRAW LINE from "<<X*start.X()<<'/'<<Y*start.Y()<<" to "<<X*end.X()<<'/'<<Y*end.Y()<<endl;

	QPen pn = p->pen();
        pn.setWidth(width);
        pn.setColor(color);
        p->setPen(pn);
	
	int sx = (int)(X*start.X());
	int sy = (int)(Y*start.Y());
	int ex = (int)(X*end.X());
	int ey = (int)(Y*end.Y());
	
	p->drawLine(sx,sy,ex,ey);

	sarrow.draw(p,start,end,(int)X,(int)Y);
	earrow.draw(p,start,end,(int)X,(int)Y);
}

// save
void Line::save(QTextStream *t) {
	*t<<start.X()<<' '<<start.Y()<<' '<<end.X()<<' '<<end.Y()<<endl;
	*t<<color.name()<<' '<<width<<endl;
	sarrow.save(t);
	earrow.save(t);
}

// open
void Line::open(QTextStream *t,int version) {
	double sx,sy,ex,ey;
	QString colorstring;
	
	*t>>sx>>sy>>ex>>ey;

	start.setPoint(sx,sy);
	end.setPoint(ex,ey);
	
	*t>>colorstring>>width;
	color=QColor(colorstring);
	sarrow.open(t,version);
	earrow.open(t,version);
}

bool Line::inside(int x, int y, int w, int h) {
	double sx = w*start.X();
	double sy = h*start.Y();
	double ex = w*end.X();
	double ey = h*end.Y();
	double d = sqrt((sx - x)*(sx-x) + (sy-y)*(sy-y) - pow((ex - sx)*(-sx + x) + (ey - sy)*(-sy + y),2)/
     ((ex - sx)*(ex-sx) + (ey - sy)*(ey-sy)));

	//kdDebug()<<"Distance : "<<fabs(d)<<endl;

	if(d<10)
		return TRUE;
	return FALSE;
}
