//LabPlot : LabPlotPart.h

#ifndef LABPLOTPART_H
#define LABPLOTPART_H

#include <kparts/part.h>
#include <kparts/browserextension.h>
#include <kparts/factory.h>
#include <klibloader.h>
#include "MainWin.h"

class KAboutData;
class KInstance;
class QLabel;

class LabPlotFactory : public KParts::Factory
{
    Q_OBJECT
public:
	LabPlotFactory();	
	virtual ~LabPlotFactory();

	virtual KParts::Part *createPartObject( QWidget *parentWidget, const char *widgetName, QObject *parent=0, 
		const char *name=0, const char *classname = "QObject", const QStringList &args = QStringList() );
	
    static KInstance *instance();
    static KAboutData *aboutData();

private:
    static KInstance *s_instance;
};

class LabPlotBrowserExtension : public KParts::BrowserExtension
{
    Q_OBJECT
    friend class LabPlotPart;
public:
    LabPlotBrowserExtension(LabPlotPart *parent);
    virtual ~LabPlotBrowserExtension();
};

class LabPlotPart: public KParts::ReadOnlyPart
{
    Q_OBJECT
public:
    LabPlotPart(QWidget *parentW, const char *wname,QObject *parent, const char *name);
    virtual ~LabPlotPart();
    virtual bool closeURL();

protected:
    virtual bool openFile();

private:
    QWidget *p;
    QWorkspace *ws;
    LabPlotBrowserExtension *m_extension;
};

#endif

