//LabPlot : FilterAUDIOFILE.h

#ifndef FILTERAUDIOFILE_H
#define FILTERAUDIOFILE_H

#include <qstring.h>
#include <qstringlist.h>

#include <audiofile.h>

class FilterAUDIOFILE
{
public:
	FilterAUDIOFILE(QString filename=0);
	bool fileOK() { return fileok; }
	QString description() { return QString("TODO"); }	// TODO
	int frameCount() { return (int) afGetFrameCount(file, AF_DEFAULT_TRACK); }
	int channelCount() { return afGetVirtualChannels(file, AF_DEFAULT_TRACK); }
	QString Name() { return QString((char *)afQueryPointer(AF_QUERYTYPE_FILEFMT,AF_QUERY_NAME,format,0,0)); }
	QString Desc() { return QString((char *)afQueryPointer(AF_QUERYTYPE_FILEFMT,AF_QUERY_DESC,format,0,0)); }
	QString sampleFormat();
	QString Format(int f);
	int sampleWidth();
	double sampleRate() { return afGetRate(file, AF_DEFAULT_TRACK); }
	double frameSize() { return (double) afGetVirtualFrameSize(file, AF_DEFAULT_TRACK, 1); }
	unsigned int virtualFrameSize() { return (unsigned int)afGetVirtualFrameSize(file,AF_DEFAULT_TRACK, 1);}
	double *Data();

private:
	QString filename;			// file
	bool fileok;				// is an audio file and readable
	AFfilehandle file;
	int format;				// numeric format id
};

#endif //FILTERAUDIOFILE_H
