/*
                   (C) Copyright 2000-2002 NAVICON ApS
                   Author: Carsten O. Madsen
$Id: GeoXY.cpp,v 1.5 2002/04/23 09:28:18 com Exp $
*/

#include <GeoXY.h>

#define DEBUG 1

GeoXY::GeoXY() {};

GeoXY::GeoXY(struct Cell_head* window, QRect& rect) {
  set(window, rect);
}


GeoXY::~GeoXY() {}


void GeoXY::set(struct Cell_head* window, QRect& rect) {
  double A_hori_to_vert ;
  double D_vert, D_hori ;
  double WIND_BOT, WIND_TOP, WIND_LEFT, WIND_RITE ;
  double Dadj ;

//    WIND_TOP  = (doubla_colse)t ;
//    WIND_BOT  = (double)b ;
//    WIND_LEFT = (double)l ;
//    WIND_RITE = (double)r ;
  WIND_TOP  = (double)rect.top() ;
  WIND_BOT  = (double)rect.bottom() ;
  WIND_LEFT = (double)rect.left() ;
  WIND_RITE = (double)rect.right() ;


  ns_resolution = window->ns_res ;
  ew_resolution = window->ew_res ;

  /* Key all coordinate limits off UTM window limits  */
  U_west  = window->west ;
  U_east  = window->east ;
  U_south = window->south ;
  U_north = window->north ;

  /* Calculate Array window limits from UTM limits */
  /* OLD CODE ***********
     ARRAY_COLS = (U_east - U_west) / ew_resolution + WINDOW_ROUND ;
     ARRAY_ROWS = (U_north - U_south) / ns_resolution + WINDOW_ROUND ;
  **********************/
  ARRAY_COLS = (int)((U_east-U_west+ew_resolution/2) /ew_resolution);
  ARRAY_ROWS = (int)((U_north-U_south+ns_resolution/2) /ns_resolution);

  A_west = 0.0 ;
  A_east = (U_east - U_west) / ew_resolution ;
  A_south = (double)(ARRAY_ROWS) ;
  A_north = (double)(ARRAY_ROWS) - (U_north - U_south) / ns_resolution ;
  A_hori_to_vert = ew_resolution / ns_resolution ;

  /* Calculate Dot limits from Array limits */
  D_vert = WIND_BOT - WIND_TOP ;
  D_hori = WIND_RITE - WIND_LEFT ;

  D_north = WIND_TOP ;
  D_west  = WIND_LEFT ;

  A_to_D_xconv = D_hori / ( (A_east  - A_west ) * A_hori_to_vert) ;
  A_to_D_yconv = D_vert / (A_south - A_north) ;

  /** comment out the follwing to allow different x,y scaling **/

//    if (A_to_D_xconv > A_to_D_yconv)
//      A_to_D_xconv = A_to_D_yconv ;
//    else
//      A_to_D_yconv = A_to_D_xconv ;

//    A_to_D_xconv *= A_hori_to_vert ;

  /** scaling end **/

  D_hori = A_to_D_xconv * (A_east  - A_west ) ;
  D_vert = A_to_D_yconv * (A_south - A_north) ;

  /* Pull all edges in so picture stays centered */
  Dadj = ((WIND_BOT - WIND_TOP ) - D_vert) / 2 ;
  if (Dadj > 0.0) {
    D_north = WIND_TOP + Dadj ;
    D_south = D_north + D_vert ;
  } else {
    D_south = WIND_BOT ;
  }
  Dadj = ((WIND_RITE - WIND_LEFT ) - D_hori) / 2 ;
  if (Dadj > 0.0) {
    D_west = WIND_LEFT + Dadj ;
    D_east = D_west + D_hori ;
  } else {
    D_east = WIND_RITE ;
  }

  U_to_D_xconv = (D_east  - D_west ) / (U_east  - U_west ) ;
  U_to_D_yconv = (D_south - D_north) / (U_north - U_south) ;

  /*
    if (t != D_north || b != D_south
    ||  l != D_west  || r != D_east)
    D_reset_screen_window((int)D_north, (int)D_south, (int)D_west, (int)D_east) ;
  */

#ifdef DEBUG
  fprintf(stderr,
	  " D_w %10.1f  D_e %10.1f  D_s %10.1f  D_n %10.1f\n",
	  D_west, D_east, D_south, D_north) ;
  fprintf(stderr,
	  " A_w %10.1f  A_e %10.1f  A_s %10.1f  A_n %10.1f\n",
	  A_west, A_east, A_south, A_north) ;
  fprintf(stderr,
	  " U_w %10.1f  U_e %10.1f  U_s %10.1f  U_n %10.1f\n",
	  U_west, U_east, U_south, U_north) ;
  fprintf(stderr,
	  " ARRAY_ROWS %d  resolution_ns %10.2f\n", ARRAY_ROWS, window->ns_res) ;
  fprintf(stderr,
	  " ARRAY_COLS %d  resolution_ew %10.2f\n", ARRAY_COLS, window->ew_res) ;
  fprintf(stderr,
	  " A_to_D_xconv %10.1f A_to_D_yconv %10.1f \n", 
	  A_to_D_xconv, A_to_D_yconv ) ;
  fprintf(stderr,
	  " BOT %10.1f  TOP %10.1f  LFT %10.1f  RHT %10.1f\n",
	  WIND_BOT, WIND_TOP, WIND_LEFT, WIND_RITE) ;
//    getchar() ;
#endif DEBUG
}



double GeoXY::D_get_u_to_a_yconv()
{ return(U_to_A_yconv) ; }

double GeoXY::D_get_u_to_a_xconv()
{ return(U_to_A_xconv) ; }

double GeoXY::D_get_a_to_d_xconv()
{ return(A_to_D_xconv) ; }

double GeoXY::D_get_a_to_d_yconv()
{ return(A_to_D_yconv) ; }

double GeoXY::D_get_u_to_d_xconv()
{ return(U_to_D_xconv) ; }

double GeoXY::D_get_u_to_d_yconv()
{ return(U_to_D_yconv) ; }

double GeoXY::D_get_u_west()
{ return(U_west) ; }

double GeoXY::D_get_u_east()
{ return(U_east) ; }

double GeoXY::D_get_u_north()
{ return(U_north) ; }

double GeoXY::D_get_u_south()
{ return(U_south) ; }

double GeoXY::D_get_a_west()
{ return(A_west) ; }

double GeoXY::D_get_a_east()
{ return(A_east) ; }

double GeoXY::D_get_a_north()
{ return(A_north) ; }

double GeoXY::D_get_a_south()
{ return(A_south) ; }

double GeoXY::D_get_d_west()
{ return(D_west) ; }

double GeoXY::D_get_d_east()
{ return(D_east) ; }

double GeoXY::D_get_d_north()
{ return(D_north) ; }

double GeoXY::D_get_d_south()
{ return(D_south) ; }

double GeoXY::D_u_to_a_row( double U_row )
{ 
	return( (double)ARRAY_ROWS - (((double)U_row - U_south)/ns_resolution) ) ;
}

double GeoXY::D_u_to_a_col(double U_col )
{ 
	return(((double)U_col - U_west )/ew_resolution )  ; 
}

double GeoXY::D_a_to_d_row(double A_row )
{ 
	return((A_row - A_north) * A_to_D_yconv + D_north);
}

double GeoXY::D_a_to_d_col(double A_col )
{ 
	return((A_col - A_west )*A_to_D_xconv + D_west) ; 
}

double GeoXY::D_u_to_d_row(double U_row )
{ 
	return((int)((U_north - U_row) * U_to_D_yconv + D_north)) ; 
}

double GeoXY::D_u_to_d_col( double U_col )
{ 
	return((int)((U_col - U_west) * U_to_D_xconv + D_west)) ; 
}

double GeoXY::D_d_to_u_row(double D_row )
{ 
	return(U_north - ((double)(D_row) - D_north)/U_to_D_yconv) ;
}

double GeoXY::D_d_to_u_col(double D_col )
{ 
	return(U_west + ((double)(D_col) - D_west)/U_to_D_xconv) ;
}

double GeoXY::D_d_to_a_row(double D_row )
{ 
	return(((double)D_row - D_north)/A_to_D_yconv + A_north) ; 
}

double GeoXY::D_d_to_a_col(double D_col )
{ 
	return(((double)D_col - D_west )/A_to_D_xconv + A_west) ; 
}

double GeoXY::D_get_ns_resolution()
{ return(ns_resolution) ; }

double GeoXY::D_get_ew_resolution()
{ return(ew_resolution) ; }


double GeoXY::distance(int x1, int y1, int x2, int y2) {
  static int first = 1;
  if ( first ) {
    /* Set up area/distance calculations  */
    G_begin_polygon_area_calculations();
    G_begin_distance_calculations();
    first = 1;
  }


  return G_distance(D_d_to_u_col((double)x1), 
		    D_d_to_u_row((double)y1),
		    D_d_to_u_col((double)x2), 
		    D_d_to_u_row((double)y2));
}
