/*
                   (C) Copyright 2000-2002 NAVICON ApS
                   Author: Carsten O. Madsen
$Id: GRASSSiteLayer.cpp,v 1.2 2002/04/23 09:28:18 com Exp $
*/

#include <iostream.h>
#include <qpainter.h>

#include <GRASSSiteLayer.h>
#include <GRASSPainter.h>


GRASSSiteLayer::GRASSSiteLayer(GRASSPainter* painter, 
			       char* name,
			       char* mapset) :
  _pixSize(4), _painter(painter)
{
  _name = name;
  _mapSet = mapset;

  mapset = G_find_file ("site_lists", name, "");
  if (mapset == NULL) {
    cerr << "sites file [" << name << "] not found " << endl;
    //xG_fatal_error (msg);
  }
  
  infile = G_fopen_sites_old (name, mapset);
  if (infile == NULL) {
    cerr << "can't open sites file [" << name << "%s]" << endl;
    //G_fatal_error (msg);
  }
	
  int ndim, ndec;
  RASTER_MAP_TYPE rtype;

  int nstr;
  rtype = -1;
  G_site_describe (infile, &ndim, &rtype, &nstr, &ndec);
  s = G_site_new_struct(rtype,ndim,nstr,ndec); 
  
}

GRASSSiteLayer::~GRASSSiteLayer() {
  G_site_free_struct(s);
} 


void GRASSSiteLayer::draw_points_diamond(QPainter* p) {
  double U_X, U_Y ;
  int D_X, D_Y ;
  int N=0;
  
  while(next_point(&U_X, &U_Y)) {
    D_X = (int)_painter->D.D_u_to_d_col(U_X) ;
    D_Y = (int)_painter->D.D_u_to_d_row(U_Y) ;
    p->moveTo(D_X, D_Y + _pixSize);
    p->lineTo(D_X + _pixSize, D_Y);
    p->lineTo(D_X, D_Y - _pixSize);
    p->lineTo(D_X - _pixSize, D_Y);
    p->lineTo(D_X, D_Y + _pixSize);
    N++; 
    if (s->str_att != NULL && s->str_alloc != 0 ) {
      cerr << "s->str_att[0] " << s->str_att[0] << endl << flush;
      p->drawText(D_X, D_Y, s->str_att[0]);
    }

  }
//    return (N);
}


int GRASSSiteLayer::rtti() { return GRASSSiteLayerID; }


void GRASSSiteLayer::draw(QPainter* p) {
  rewind(infile);
  draw_points_diamond(p);
}


int GRASSSiteLayer::next_point(double* U_X, double* U_Y) {
  do {
    if ( G_site_get (infile, s) != 0 )
      return 0;
  }
  while ( ! G_site_in_region(s, (Cell_head*)&_painter->grassRegion()) );
  
  *U_X=s->east;
  *U_Y=s->north;

  return 1;
}




