/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#ifdef __cplusplus
extern "C" 
{
#endif
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gtk.MessageDialog
     * Method:    gtk_message_dialog_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_MessageDialog_gtk_1message_1dialog_1get_1type (JNIEnv 
        *env, jclass cls) 
    {
        {
            return (jint)gtk_message_dialog_get_type ();
        }
    }

    /*
     * Class:     org.gnu.gtk.MessageDialog
     * Method:    gtk_message_dialog_new
     * Signature: (IIII[B)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gtk_MessageDialog_gtk_1message_1dialog_1new (JNIEnv *env, 
        jclass cls, jint parent, jint flags, jint type, jint buttons, jstring messageFormat) 
    {
        GtkWindow *parent_g = (GtkWindow *)parent;
        GtkDialogFlags flags_g = (GtkDialogFlags) flags;
        GtkMessageType type_g = (GtkMessageType) type;
        GtkButtonsType buttons_g = (GtkButtonsType) buttons;
        const gchar* messageFormat_g = (*env)->GetStringUTFChars(env, messageFormat, NULL);
		jint retval =  (jint)gtk_message_dialog_new (parent_g, flags_g, type_g, buttons_g, 
			messageFormat_g);
		(*env)->ReleaseStringUTFChars(env, messageFormat, messageFormat_g);
		return retval;
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/

/*
 * Class:     org_gnu_gtk_MessageDialog
 * Method:    gtk_message_dialog_new_with_markup  * Signature: (IIIILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_MessageDialog_gtk_1message_1dialog_1new_1with_1markup
  (JNIEnv *env, jclass cls, jint parent, jint flags, jint type, jint buttons, jstring message)
{
	const gchar* m = (*env)->GetStringUTFChars(env, message, NULL);
	jint handle = (jint)gtk_message_dialog_new_with_markup((GtkWindow*)parent, (GtkDialogFlags)flags,
					(GtkMessageType)type, (GtkButtonsType)buttons, m);
	(*env)->ReleaseStringUTFChars(env, message, m);
	return handle;
}
                                                                                
/*  * Class:     org_gnu_gtk_MessageDialog
 * Method:    gtk_message_dialog_set_markup
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_MessageDialog_gtk_1message_1dialog_1set_1markup
  (JNIEnv *env, jclass cls, jint mdialog, jstring message)
{
	const gchar* m = (*env)->GetStringUTFChars(env, message, NULL);
	gtk_message_dialog_set_markup((GtkMessageDialog*)mdialog, m);
	(*env)->ReleaseStringUTFChars(env, message, m);
}
                                                                                
#ifdef __cplusplus
}

#endif
