--
-- Alternative resizing for ion-devel
--
-- By Per Olofsson <pelle@dsv.su.se> (public domain)
--
--
-- More intuitive resizing keys for Ion:
--
-- key      function
-- --------------------------
-- left     shrink leftwards
-- right    grow rightwards
-- up       shrink upwards
-- down     grow downwards
--
-- The meaning of the corresponding keys are reversed when the window
-- is at the right or bottom edge of the workspace.
--
-- Add the code to ionws.lua to make use of it. You probably shouldn't
-- delete any bindings for keys that are not redefined here.
--

function ionws_alt_resize(f, dir)
    local ws = f:manager()

   if dir == "left" then
       if ws:right_of(f) then
           f:do_resize( 0,-1, 0, 0)
       else
           f:do_resize( 1, 0, 0, 0)
       end
   elseif dir == "right" then
       if ws:right_of(f) then
           f:do_resize( 0, 1, 0, 0)
       else
           f:do_resize(-1, 0, 0, 0)
       end
   elseif dir == "up" then
       if ws:below(f) then
           f:do_resize( 0, 0, 0,-1)
       else
           f:do_resize( 0, 0, 1, 0)
       end
   elseif dir == "down" then
       if ws:below(f) then
           f:do_resize( 0, 0, 0, 1)
       else
           f:do_resize( 0, 0,-1, 0)
       end
   end
end

ionframe_moveres_bindings{
    kpress("Left",  function(f) ionws_alt_resize(f, "left" ) end),
    kpress("Right", function(f) ionws_alt_resize(f, "right") end),
    kpress("Up",    function(f) ionws_alt_resize(f, "up"   ) end),
    kpress("Down",  function(f) ionws_alt_resize(f, "down" ) end),
    kpress("F",     function(f) ionws_alt_resize(f, "left" ) end),
    kpress("B",     function(f) ionws_alt_resize(f, "right") end),
    kpress("P",     function(f) ionws_alt_resize(f, "up"   ) end),
    kpress("N",     function(f) ionws_alt_resize(f, "down" ) end),
}
