/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: RuleOptionsDialog.cpp,v 1.6 2004/08/26 05:18:32 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"
#include "utils.h"
#include "platforms.h"

#include "RuleOptionsDialog.h"
#include "ObjectManipulator.h"
#include "RuleSetView.h"
#include "FWWindow.h"

#include "fwbuilder/Firewall.h"
#include "fwbuilder/Rule.h"
#include "fwbuilder/FWOptions.h"
#include "fwbuilder/Resources.h"

#include <qwidgetstack.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qcheckbox.h>

#include <iostream>

using namespace libfwbuilder;
using namespace std;

RuleOptionsDialog::RuleOptionsDialog(QWidget *parent) : RuleOptionsDialog_q(parent) {}

void RuleOptionsDialog::loadFWObject(FWObject *o)
{
    obj=o;
//    rsv=rv;

    FWObject *p=obj;
    while ( !Firewall::isA(p) ) p=p->getParent();
    platform=p->getStr("platform").c_str();

    Rule      *rule = dynamic_cast<Rule*>(o);
    FWOptions *ropt = rule->getOptionsObject();

    int wid=0;
    if (platform=="iptables") wid=0;
    if (platform=="ipf")      wid=1;
    if (platform=="pf")       wid=2;
    if (platform=="ipfw")     wid=3;
    if (platform=="pix")      wid=4;

    wStack->raiseWidget( wid );
    wStack->widget(wid)->show();

    QStringList  logLevels=getLogLevels( obj->getStr("platform").c_str() );

    ipt_logLevel->clear();
    ipt_logLevel->insertStringList(logLevels);

    ipf_logLevel->clear();
    ipf_logLevel->insertStringList(logLevels);


    QStringList  logFacilities=getLogFacilities( obj->getStr("platform").c_str() );

    ipf_logFacility->clear();
    ipf_logFacility->insertStringList(logFacilities);    

    data.clear();

    if (platform=="iptables")
    {
        data.registerOption( ipt_logPrefix            , ropt,  "log_prefix" );
        data.registerOption( ipt_logLevel             , ropt,  "log_level" );
        data.registerOption( ipt_nlgroup              , ropt,  "ulog_nlgroup" );
        data.registerOption( ipt_actionOnReject       , ropt,  "action_on_reject");
        data.registerOption( ipt_limit                , ropt,  "limit_value" );
        data.registerOption( ipt_limitSuffix          , ropt,  "limit_suffix" );
        data.registerOption( ipt_burst                , ropt,  "limit_burst" );
        data.registerOption( ipt_assumeFwIsPartOfAny  , ropt,  "firewall_is_part_of_any_and_networks" );
        data.registerOption( ipt_stateless            , ropt,  "stateless" );
    }


    if (platform=="ipf")
    {
        data.registerOption( ipf_logFacility     , ropt,  "ipf_log_facility");
        data.registerOption( ipf_logLevel        , ropt,  "log_level" );
        data.registerOption( ipf_actionOnReject  , ropt,  "action_on_reject");
        data.registerOption( ipf_masq_icmp       , ropt,  "ipf_return_icmp_as_dest");
        data.registerOption( ipf_stateless       , ropt,  "stateless" );
        data.registerOption( ipf_keep_frags      , ropt,  "ipf_keep_frags" );
    }

    if (platform=="pf")
    {
        data.registerOption( pf_logPrefix        , ropt,  "log_prefix" );
        data.registerOption( pf_actionOnReject   , ropt,  "action_on_reject");
        data.registerOption( pf_stateless        , ropt,  "stateless" );
        data.registerOption( pf_rule_max_state   , ropt,  "pf_rule_max_state" );
        data.registerOption( pf_source_tracking  , ropt,  "pf_source_tracking" );
        data.registerOption( pf_max_src_nodes    , ropt,  "pf_max_src_nodes" );
        data.registerOption( pf_max_src_states   , ropt,  "pf_max_src_states" );
    }

    if (platform=="ipfw")
    {
        data.registerOption( ipfw_actionOnReject , ropt,"action_on_reject");
        data.registerOption( ipfw_stateless      , ropt,"stateless" );
    }

    if (platform=="pix")
    {
        string vers="version_"+p->getStr("version");
        if ( Resources::platform_res["pix"]->getResourceBool(
              "/FWBuilderResources/Target/options/"+vers+"/pix_rule_syslog_settings"))
        {
            pix_disable_rule_log->setEnabled(true);
            pix_logLevel->setEnabled(true);
            pix_log_interval->setEnabled(true);

            data.registerOption( pix_disable_rule_log, ropt,"disable_logging_for_this_rule" );
            data.registerOption( pix_logLevel        , ropt,"log_level" );
            data.registerOption( pix_log_interval    , ropt,"log_interval" );
        } else
        {
            pix_disable_rule_log->setEnabled(false);
            pix_logLevel->setEnabled(false);
            pix_log_interval->setEnabled(false);
        }

    }

    init=true;
    data.loadAll();

    pf_max_src_nodes->setEnabled( pf_source_tracking->isChecked() );
    pf_max_src_states->setEnabled( pf_source_tracking->isChecked() );

    apply->setEnabled( false );
    init=false;
}
    
void RuleOptionsDialog::changed()
{
    apply->setEnabled( true );

    pf_max_src_nodes->setEnabled( pf_source_tracking->isChecked() );
    pf_max_src_states->setEnabled( pf_source_tracking->isChecked() );
}

void RuleOptionsDialog::validate(bool *res)
{
    *res=true;
}

void RuleOptionsDialog::isChanged(bool *res)
{
    *res=(!init && apply->isEnabled());
}

void RuleOptionsDialog::libChanged()
{
    changed();
}

void RuleOptionsDialog::applyChanges()
{
    if (!isTreeReadWrite(this,obj)) return;

    init=true;
    data.saveAll();
    init=false;

    mw->updateRuleOptions();

    apply->setEnabled( false );
}

void RuleOptionsDialog::discardChanges()
{
    loadFWObject(obj);
}


/* ObjectEditor class connects its slot to this signal and does all
 * the verification for us, then accepts (or not) the event. So we do
 * nothing here and defer all the processing to ObjectEditor
 */
void RuleOptionsDialog::closeEvent(QCloseEvent *e)
{
    emit close_sign(e);

}

